/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming.ui;

import java.io.Serializable;
import org.apache.spark.sql.streaming.ui.StreamingQueryUIData;
import org.apache.spark.sql.streaming.ui.StructuredStreamingRow;
import org.apache.spark.sql.streaming.ui.UIUtils$;
import org.apache.spark.ui.PagedDataSource;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u000194Q!\u0004\b\u0001\u001diA\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\to\u0001\u0011\t\u0011)A\u0005q!A\u0001\t\u0001B\u0001B\u0003%\u0011\tC\u0005F\u0001\t\u0005\t\u0015!\u0003G\u0013\"A!\n\u0001B\u0001B\u0003%\u0011\tC\u0003L\u0001\u0011\u0005A\nC\u0004T\u0001\t\u0007I\u0011\u0002+\t\ri\u0003\u0001\u0015!\u0003V\u0011\u0015Y\u0006\u0001\"\u0011]\u0011\u0015i\u0006\u0001\"\u0011_\u0011\u0015!\u0007\u0001\"\u0003f\u0011\u00159\u0007\u0001\"\u0003i\u0005a\u0019FO]3b[&tw-U;fef$\u0015\r^1T_V\u00148-\u001a\u0006\u0003\u001fA\t!!^5\u000b\u0005E\u0011\u0012!C:ue\u0016\fW.\u001b8h\u0015\t\u0019B#A\u0002tc2T!!\u0006\f\u0002\u000bM\u0004\u0018M]6\u000b\u0005]A\u0012AB1qC\u000eDWMC\u0001\u001a\u0003\ry'oZ\n\u0003\u0001m\u00012\u0001\b\u0010!\u001b\u0005i\"BA\b\u0015\u0013\tyRDA\bQC\u001e,G\rR1uCN{WO]2f!\t\t#%D\u0001\u000f\u0013\t\u0019cB\u0001\fTiJ,8\r^;sK\u0012\u001cFO]3b[&twMU8x\u0003\u0019)\u0018\u000eR1uC\u000e\u0001\u0001cA\u00142i9\u0011\u0001F\f\b\u0003S1j\u0011A\u000b\u0006\u0003W\u0015\na\u0001\u0010:p_Rt\u0014\"A\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u0005=\u0002\u0014a\u00029bG.\fw-\u001a\u0006\u0002[%\u0011!g\r\u0002\u0004'\u0016\f(BA\u00181!\t\tS'\u0003\u00027\u001d\t!2\u000b\u001e:fC6LgnZ)vKJLX+\u0013#bi\u0006\f!b]8si\u000e{G.^7o!\tITH\u0004\u0002;wA\u0011\u0011\u0006M\u0005\u0003yA\na\u0001\u0015:fI\u00164\u0017B\u0001 @\u0005\u0019\u0019FO]5oO*\u0011A\bM\u0001\u0005I\u0016\u001c8\r\u0005\u0002C\u00076\t\u0001'\u0003\u0002Ea\t9!i\\8mK\u0006t\u0017\u0001\u00039bO\u0016\u001c\u0016N_3\u0011\u0005\t;\u0015B\u0001%1\u0005\rIe\u000e^\u0005\u0003\u000bz\t\u0001\"[:BGRLg/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\r5su\nU)S!\t\t\u0003\u0001C\u0003%\r\u0001\u0007a\u0005C\u00038\r\u0001\u0007\u0001\bC\u0003A\r\u0001\u0007\u0011\tC\u0003F\r\u0001\u0007a\tC\u0003K\r\u0001\u0007\u0011)\u0001\u0003eCR\fW#A+\u0011\u0007YK\u0006%D\u0001X\u0015\tA\u0006'\u0001\u0006d_2dWm\u0019;j_:L!AM,\u0002\u000b\u0011\fG/\u0019\u0011\u0002\u0011\u0011\fG/Y*ju\u0016,\u0012AR\u0001\ng2L7-\u001a#bi\u0006$2a\u00181c!\r9\u0013\u0007\t\u0005\u0006C*\u0001\rAR\u0001\u0005MJ|W\u000eC\u0003d\u0015\u0001\u0007a)\u0001\u0002u_\u0006a1\u000f\u001e:fC6Lgn\u001a*poR\u0011\u0001E\u001a\u0005\u0006I-\u0001\r\u0001N\u0001\t_J$WM]5oOR\u0019\u0011\u000e\\7\u0011\u0007\u001dR\u0007%\u0003\u0002lg\tAqJ\u001d3fe&tw\rC\u00038\u0019\u0001\u0007\u0001\bC\u0003A\u0019\u0001\u0007\u0011\t")
public class StreamingQueryDataSource
extends PagedDataSource<StructuredStreamingRow> {
    private final boolean isActive;
    private final Seq<StructuredStreamingRow> data;

    private Seq<StructuredStreamingRow> data() {
        return this.data;
    }

    public int dataSize() {
        return this.data().size();
    }

    public Seq<StructuredStreamingRow> sliceData(int from, int to) {
        return (Seq)this.data().slice(from, to);
    }

    private StructuredStreamingRow streamingRow(StreamingQueryUIData uiData) {
        long duration = this.isActive ? System.currentTimeMillis() - uiData.summary().startTimestamp() : BoxesRunTime.unboxToLong((Object)UIUtils$.MODULE$.withNoProgress(uiData, (JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> {
            String endTimeMs = uiData.lastProgress().timestamp();
            return UIUtils$.MODULE$.parseProgressTimestamp(endTimeMs) - uiData.summary().startTimestamp();
        }, BoxesRunTime.boxToLong((long)0L)));
        double avgInput = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])uiData.recentProgress())).map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToDouble((double)UIUtils$.MODULE$.withNumberInvalid((Function0<Object>)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> p.inputRowsPerSecond())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)uiData.recentProgress().length;
        double avgProcess = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])uiData.recentProgress())).map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToDouble((double)UIUtils$.MODULE$.withNumberInvalid((Function0<Object>)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> p.processedRowsPerSecond())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)uiData.recentProgress().length;
        return new StructuredStreamingRow(duration, avgInput, avgProcess, uiData);
    }

    private Ordering<StructuredStreamingRow> ordering(String sortColumn, boolean desc) {
        Ordering ordering;
        String string = sortColumn;
        if ("Name".equals(string)) {
            ordering = package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)row -> UIUtils$.MODULE$.getQueryName(row.streamingUIData()), (Ordering)Ordering.String$.MODULE$);
        } else if ("Status".equals(string)) {
            ordering = package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)row -> UIUtils$.MODULE$.getQueryStatus(row.streamingUIData()), (Ordering)Ordering.String$.MODULE$);
        } else if ("ID".equals(string)) {
            ordering = package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x$5 -> x$5.streamingUIData().summary().id(), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
        } else if ("Run ID".equals(string)) {
            ordering = package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x$6 -> x$6.streamingUIData().summary().runId(), (Ordering)Ordering.String$.MODULE$);
        } else if ("Start Time".equals(string)) {
            ordering = package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)StreamingQueryDataSource.$anonfun$ordering$5(x$7)), (Ordering)Ordering.Long$.MODULE$);
        } else if ("Duration".equals(string)) {
            ordering = package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.duration()), (Ordering)Ordering.Long$.MODULE$);
        } else if ("Avg Input /sec".equals(string)) {
            ordering = package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToDouble((double)x$9.avgInput()), (Ordering)Ordering.Double$.MODULE$);
        } else if ("Avg Process /sec".equals(string)) {
            ordering = package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToDouble((double)x$10.avgProcess()), (Ordering)Ordering.Double$.MODULE$);
        } else if ("Latest Batch".equals(string)) {
            ordering = package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong((long)StreamingQueryDataSource.$anonfun$ordering$9(x$11)), (Ordering)Ordering.Long$.MODULE$);
        } else {
            throw new IllegalArgumentException(new StringBuilder(16).append("Unknown Column: ").append(string).toString());
        }
        Ordering ordering2 = ordering;
        if (desc) {
            return ordering2.reverse();
        }
        return ordering2;
    }

    public static final /* synthetic */ long $anonfun$ordering$5(StructuredStreamingRow x$7) {
        return x$7.streamingUIData().summary().startTimestamp();
    }

    public static final /* synthetic */ long $anonfun$ordering$9(StructuredStreamingRow x$11) {
        return x$11.streamingUIData().lastProgress().batchId();
    }

    public StreamingQueryDataSource(Seq<StreamingQueryUIData> uiData2, String sortColumn, boolean desc, int pageSize, boolean isActive) {
        this.isActive = isActive;
        super(pageSize);
        this.data = (Seq)((SeqLike)uiData2.map((Function1 & Serializable & scala.Serializable)uiData -> this.streamingRow((StreamingQueryUIData)uiData), Seq$.MODULE$.canBuildFrom())).sorted(this.ordering(sortColumn, desc));
    }
}

