/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.connector.expressions.aggregate.AggregateFunc;
import org.apache.spark.sql.connector.expressions.aggregate.GeneralAggregateFunc;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class OracleDialect$
extends JdbcDialect
implements Product {
    public static OracleDialect$ MODULE$;
    private final int BINARY_FLOAT;
    private final int BINARY_DOUBLE;
    private final int TIMESTAMPTZ;

    static {
        new OracleDialect$();
    }

    public int BINARY_FLOAT() {
        return this.BINARY_FLOAT;
    }

    public int BINARY_DOUBLE() {
        return this.BINARY_DOUBLE;
    }

    public int TIMESTAMPTZ() {
        return this.TIMESTAMPTZ;
    }

    @Override
    public boolean canHandle(String url) {
        return url.toLowerCase(Locale.ROOT).startsWith("jdbc:oracle");
    }

    @Override
    public Option<String> compileAggregate(AggregateFunc aggFunction) {
        return super.compileAggregate(aggFunction).orElse((Function0 & Serializable & scala.Serializable)() -> {
            boolean bl = false;
            GeneralAggregateFunc generalAggregateFunc = null;
            AggregateFunc aggregateFunc = aggFunction;
            if (aggregateFunc instanceof GeneralAggregateFunc) {
                bl = true;
                generalAggregateFunc = (GeneralAggregateFunc)aggregateFunc;
                String string = generalAggregateFunc.name();
                String string2 = "VAR_POP";
                if (!(string != null ? !string.equals(string2) : string2 != null) && !generalAggregateFunc.isDistinct()) {
                    Predef$.MODULE$.assert(generalAggregateFunc.children().length == 1);
                    return new Some((Object)new StringBuilder(9).append("VAR_POP(").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children())).head()).append(")").toString());
                }
            }
            if (bl) {
                String string = generalAggregateFunc.name();
                String string3 = "VAR_SAMP";
                if (!(string != null ? !string.equals(string3) : string3 != null) && !generalAggregateFunc.isDistinct()) {
                    Predef$.MODULE$.assert(generalAggregateFunc.children().length == 1);
                    return new Some((Object)new StringBuilder(10).append("VAR_SAMP(").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children())).head()).append(")").toString());
                }
            }
            if (bl) {
                String string = generalAggregateFunc.name();
                String string4 = "STDDEV_POP";
                if (!(string != null ? !string.equals(string4) : string4 != null) && !generalAggregateFunc.isDistinct()) {
                    Predef$.MODULE$.assert(generalAggregateFunc.children().length == 1);
                    return new Some((Object)new StringBuilder(12).append("STDDEV_POP(").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children())).head()).append(")").toString());
                }
            }
            if (bl) {
                String string = generalAggregateFunc.name();
                String string5 = "STDDEV_SAMP";
                if (!(string != null ? !string.equals(string5) : string5 != null) && !generalAggregateFunc.isDistinct()) {
                    Predef$.MODULE$.assert(generalAggregateFunc.children().length == 1);
                    return new Some((Object)new StringBuilder(13).append("STDDEV_SAMP(").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children())).head()).append(")").toString());
                }
            }
            if (bl) {
                String string = generalAggregateFunc.name();
                String string6 = "COVAR_POP";
                if (!(string != null ? !string.equals(string6) : string6 != null) && !generalAggregateFunc.isDistinct()) {
                    Predef$.MODULE$.assert(generalAggregateFunc.children().length == 2);
                    return new Some((Object)new StringBuilder(13).append("COVAR_POP(").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children())).head()).append(", ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children())).last()).append(")").toString());
                }
            }
            if (bl) {
                String string = generalAggregateFunc.name();
                String string7 = "COVAR_SAMP";
                if (!(string != null ? !string.equals(string7) : string7 != null) && !generalAggregateFunc.isDistinct()) {
                    Predef$.MODULE$.assert(generalAggregateFunc.children().length == 2);
                    return new Some((Object)new StringBuilder(14).append("COVAR_SAMP(").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children())).head()).append(", ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children())).last()).append(")").toString());
                }
            }
            if (bl) {
                String string = generalAggregateFunc.name();
                String string8 = "CORR";
                if (!(string != null ? !string.equals(string8) : string8 != null) && !generalAggregateFunc.isDistinct()) {
                    Predef$.MODULE$.assert(generalAggregateFunc.children().length == 2);
                    return new Some((Object)new StringBuilder(8).append("CORR(").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children())).head()).append(", ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])generalAggregateFunc.children())).last()).append(")").toString());
                }
            }
            return None$.MODULE$;
        });
    }

    private boolean supportTimeZoneTypes() {
        TimeZone timeZone;
        TimeZone timeZone2 = timeZone = DateTimeUtils$.MODULE$.getTimeZone(SQLConf$.MODULE$.get().sessionLocalTimeZone());
        TimeZone timeZone3 = TimeZone.getDefault();
        return !(timeZone2 != null ? !timeZone2.equals(timeZone3) : timeZone3 != null);
    }

    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        int n = sqlType;
        if (2 == n) {
            long scale = md != null ? md.build().getLong("scale") : 0L;
            int n2 = size;
            switch (n2) {
                case 0: {
                    return Option$.MODULE$.apply((Object)new DecimalType(DecimalType$.MODULE$.MAX_PRECISION(), 10));
                }
            }
            if (scale == -127L) {
                return Option$.MODULE$.apply((Object)new DecimalType(DecimalType$.MODULE$.MAX_PRECISION(), 10));
            }
            return None$.MODULE$;
        }
        if (this.TIMESTAMPTZ() == n && this.supportTimeZoneTypes()) {
            return new Some((Object)TimestampType$.MODULE$);
        }
        if (this.BINARY_FLOAT() == n) {
            return new Some((Object)FloatType$.MODULE$);
        }
        if (this.BINARY_DOUBLE() == n) {
            return new Some((Object)DoubleType$.MODULE$);
        }
        return None$.MODULE$;
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        DataType dataType = dt;
        if (BooleanType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("NUMBER(1)", 16));
        }
        if (IntegerType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("NUMBER(10)", 4));
        }
        if (LongType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("NUMBER(19)", -5));
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("NUMBER(19, 4)", 6));
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("NUMBER(19, 4)", 8));
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("NUMBER(3)", 5));
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("NUMBER(5)", 5));
        }
        if (StringType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("VARCHAR2(255)", 12));
        }
        return None$.MODULE$;
    }

    @Override
    public Object compileValue(Object value2) {
        Object object = value2;
        if (object instanceof String) {
            String string = (String)object;
            return new StringBuilder(2).append("'").append(this.escapeSql(string)).append("'").toString();
        }
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            return new StringBuilder(7).append("{ts '").append(timestamp).append("'}").toString();
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            return new StringBuilder(6).append("{d '").append(date).append("'}").toString();
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            return Predef$.MODULE$.genericArrayOps(Predef$.MODULE$.genericArrayOps((Object)objectArray).map((Function1 & Serializable & scala.Serializable)value -> MODULE$.compileValue(value), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()))).mkString(", ");
        }
        return value2;
    }

    @Override
    public Option<Object> isCascadingTruncateTable() {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Override
    public String getTruncateQuery(String table, Option<Object> cascade) {
        Some some;
        boolean bl;
        Option<Object> option = cascade;
        if (option instanceof Some && (bl = BoxesRunTime.unboxToBoolean((Object)(some = (Some)option).value()))) {
            return new StringBuilder(23).append("TRUNCATE TABLE ").append(table).append(" CASCADE").toString();
        }
        return new StringBuilder(15).append("TRUNCATE TABLE ").append(table).toString();
    }

    @Override
    public Option<Object> getTruncateQuery$default$2() {
        return this.isCascadingTruncateTable();
    }

    @Override
    public String getAddColumnQuery(String tableName, String columnName, String dataType) {
        return new StringBuilder(18).append("ALTER TABLE ").append(tableName).append(" ADD ").append(this.quoteIdentifier(columnName)).append(" ").append(dataType).toString();
    }

    @Override
    public String getUpdateColumnTypeQuery(String tableName, String columnName, String newDataType) {
        return new StringBuilder(21).append("ALTER TABLE ").append(tableName).append(" MODIFY ").append(this.quoteIdentifier(columnName)).append(" ").append(newDataType).toString();
    }

    @Override
    public String getUpdateColumnNullabilityQuery(String tableName, String columnName, boolean isNullable) {
        String nullable = isNullable ? "NULL" : "NOT NULL";
        return new StringBuilder(21).append("ALTER TABLE ").append(tableName).append(" MODIFY ").append(this.quoteIdentifier(columnName)).append(" ").append(nullable).toString();
    }

    public String productPrefix() {
        return "OracleDialect";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof OracleDialect$;
    }

    public int hashCode() {
        return 959235752;
    }

    public String toString() {
        return "OracleDialect";
    }

    private Object readResolve() {
        return MODULE$;
    }

    private OracleDialect$() {
        MODULE$ = this;
        Product.$init$((Product)this);
        this.BINARY_FLOAT = 100;
        this.BINARY_DOUBLE = 101;
        this.TIMESTAMPTZ = -101;
    }
}

