/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$;
import org.apache.spark.sql.catalyst.util.DateFormatter$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.catalog.index.TableIndex;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.Literal;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.aggregate.AggregateFunc;
import org.apache.spark.sql.connector.expressions.aggregate.Avg;
import org.apache.spark.sql.connector.expressions.aggregate.Count;
import org.apache.spark.sql.connector.expressions.aggregate.CountStar;
import org.apache.spark.sql.connector.expressions.aggregate.Max;
import org.apache.spark.sql.connector.expressions.aggregate.Min;
import org.apache.spark.sql.connector.expressions.aggregate.Sum;
import org.apache.spark.sql.connector.util.V2ExpressionSQLBuilder;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.jdbc.DriverRegistry$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.execution.datasources.jdbc.connection.ConnectionProvider$;
import org.apache.spark.sql.execution.datasources.v2.TableSampleInfo;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MetadataBuilder;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\rmf!B\u00181\u0003\u0003Y\u0004\"B&\u0001\t\u0003a\u0005\"B(\u0001\r\u0003\u0001\u0006\"B1\u0001\t\u0003\u0011\u0007\"\u0002>\u0001\t\u0003Y\bbBA\u0003\u0001\u0011\u0005\u0011q\u0001\u0005\b\u0003\u000b\u0002A\u0011AA$\u0011\u001d\ti\u0005\u0001C\u0001\u0003\u001fBq!!\u0016\u0001\t\u0003\t9\u0006C\u0004\u0002b\u0001!\t!a\u0019\t\u000f\u0005\u0005\u0004\u0001\"\u0001\u0002n!I\u0011Q\u0010\u0001\u0012\u0002\u0013\u0005\u0011q\u0010\u0005\b\u0003'\u0003A\u0011AAK\u0011!\tY\u000b\u0001C\ta\u00055\u0006bBA[\u0001\u0011\u0005\u0011q\u0017\u0004\b\u0003\u0007\u0004\u0001\u0001MAc\u0011\u0019Yu\u0002\"\u0001\u0002X\"9\u0011Q\\\b\u0005B\u0005}\u0007b\u0002B\u0002\u001f\u0011\u0005#Q\u0001\u0005\b\u0005#yA\u0011\tB\n\u0011\u001d\u0011ib\u0004C!\u0005?AqAa\f\u0001\t\u0003\u0011\t\u0004C\u0004\u00038\u0001!\tA!\u000f\t\u000f\t%\u0003\u0001\"\u0001\u0003L!9!q\f\u0001\u0005\u0002\t\u0005\u0004b\u0002B;\u0001\u0011\u0005!q\u000f\u0005\b\u0005\u0003\u0003A\u0011\u0001BB\u0011\u001d\u0011Y\t\u0001C\u0001\u0005\u001bCqAa$\u0001\t\u0003\u0011\t\nC\u0004\u0003\u001c\u0002!\tA!(\t\u000f\t%\u0007\u0001\"\u0001\u0003L\"9!Q\u001b\u0001\u0005\u0002\t]\u0007b\u0002Br\u0001\u0011\u0005!Q\u001d\u0005\b\u0005W\u0004A\u0011\u0001Bw\u0011\u001d\u00119\u0010\u0001C\u0001\u0005sDqaa\u0001\u0001\t\u0003\u0019)\u0001C\u0004\u0004\f\u0001!\ta!\u0004\t\u000f\rM\u0001\u0001\"\u0001\u0004\u0016!91\u0011\u0004\u0001\u0005\u0002\rm\u0001bBB\u0011\u0001\u0011\u000511\u0005\u0005\b\u0007\u0003\u0002A\u0011AB\"\u0011\u001d\u0019i\u0005\u0001C\u0001\u0007\u001fBqa!\u0016\u0001\t\u0003\u00199\u0006C\u0004\u0004n\u0001!\taa\u001c\t\u000f\r\u001d\u0005\u0001\"\u0001\u0004\n\"911\u0014\u0001\u0005\u0002\ru\u0005bBBP\u0001\u0011\u00051\u0011\u0015\u0002\f\u0015\u0012\u00147\rR5bY\u0016\u001cGO\u0003\u00022e\u0005!!\u000e\u001a2d\u0015\t\u0019D'A\u0002tc2T!!\u000e\u001c\u0002\u000bM\u0004\u0018M]6\u000b\u0005]B\u0014AB1qC\u000eDWMC\u0001:\u0003\ry'oZ\u0002\u0001'\u0011\u0001AHQ#\u0011\u0005u\u0002U\"\u0001 \u000b\u0003}\nQa]2bY\u0006L!!\u0011 \u0003\r\u0005s\u0017PU3g!\ti4)\u0003\u0002E}\ta1+\u001a:jC2L'0\u00192mKB\u0011a)S\u0007\u0002\u000f*\u0011\u0001\nN\u0001\tS:$XM\u001d8bY&\u0011!j\u0012\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\tQ\n\u0005\u0002O\u00015\t\u0001'A\u0005dC:D\u0015M\u001c3mKR\u0011\u0011\u000b\u0016\t\u0003{IK!a\u0015 \u0003\u000f\t{w\u000e\\3b]\")QK\u0001a\u0001-\u0006\u0019QO\u001d7\u0011\u0005]sfB\u0001-]!\tIf(D\u0001[\u0015\tY&(\u0001\u0004=e>|GOP\u0005\u0003;z\na\u0001\u0015:fI\u00164\u0017BA0a\u0005\u0019\u0019FO]5oO*\u0011QLP\u0001\u0010O\u0016$8)\u0019;bYf\u001cH\u000fV=qKR)1\r\\9tkB\u0019Q\b\u001a4\n\u0005\u0015t$AB(qi&|g\u000e\u0005\u0002hU6\t\u0001N\u0003\u0002je\u0005)A/\u001f9fg&\u00111\u000e\u001b\u0002\t\t\u0006$\u0018\rV=qK\")Qn\u0001a\u0001]\u000691/\u001d7UsB,\u0007CA\u001fp\u0013\t\u0001hHA\u0002J]RDQA]\u0002A\u0002Y\u000b\u0001\u0002^=qK:\u000bW.\u001a\u0005\u0006i\u000e\u0001\rA\\\u0001\u0005g&TX\rC\u0003w\u0007\u0001\u0007q/\u0001\u0002nIB\u0011q\r_\u0005\u0003s\"\u0014q\"T3uC\u0012\fG/\u0019\"vS2$WM]\u0001\fO\u0016$(\n\u0012\"D)f\u0004X\rF\u0002}\u0003\u0003\u00012!\u00103~!\tqe0\u0003\u0002\u0000a\tA!\n\u001a2d)f\u0004X\r\u0003\u0004\u0002\u0004\u0011\u0001\rAZ\u0001\u0003IR\fqc\u0019:fCR,7i\u001c8oK\u000e$\u0018n\u001c8GC\u000e$xN]=\u0015\t\u0005%\u0011Q\u0004\t\u0007{\u0005-a.a\u0004\n\u0007\u00055aHA\u0005Gk:\u001cG/[8ocA!\u0011\u0011CA\r\u001b\t\t\u0019BC\u00024\u0003+Q!!a\u0006\u0002\t)\fg/Y\u0005\u0005\u00037\t\u0019B\u0001\u0006D_:tWm\u0019;j_:Dq!a\b\u0006\u0001\u0004\t\t#A\u0004paRLwN\\:\u0011\t\u0005\r\u0012qF\u0007\u0003\u0003KQ1!MA\u0014\u0015\u0011\tI#a\u000b\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u0004\u0003[\u0011\u0014!C3yK\u000e,H/[8o\u0013\u0011\t\t$!\n\u0003\u0017)#%iQ(qi&|gn\u001d\u0015\u0006\u000b\u0005U\u0012\u0011\t\t\u0005\u0003o\ti$\u0004\u0002\u0002:)\u0019\u00111\b\u001b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002@\u0005e\"!B*j]\u000e,\u0017EAA\"\u0003\u0015\u0019df\r\u00181\u0003=\tXo\u001c;f\u0013\u0012,g\u000e^5gS\u0016\u0014Hc\u0001,\u0002J!1\u00111\n\u0004A\u0002Y\u000bqaY8m\u001d\u0006lW-A\nhKR$\u0016M\u00197f\u000bbL7\u000f^:Rk\u0016\u0014\u0018\u0010F\u0002W\u0003#Ba!a\u0015\b\u0001\u00041\u0016!\u0002;bE2,\u0017AD4fiN\u001b\u0007.Z7b#V,'/\u001f\u000b\u0004-\u0006e\u0003BBA*\u0011\u0001\u0007a\u000bK\u0003\t\u0003k\ti&\t\u0002\u0002`\u0005)!GL\u0019/a\u0005\u0001r-\u001a;UeVt7-\u0019;f#V,'/\u001f\u000b\u0004-\u0006\u0015\u0004BBA*\u0013\u0001\u0007a\u000bK\u0003\n\u0003k\tI'\t\u0002\u0002l\u0005)!GL\u001a/aQ)a+a\u001c\u0002r!1\u00111\u000b\u0006A\u0002YC\u0011\"a\u001d\u000b!\u0003\u0005\r!!\u001e\u0002\u000f\r\f7oY1eKB\u0019Q\bZ))\u000b)\t)$!\u001f\"\u0005\u0005m\u0014!\u0002\u001a/i9\u0002\u0014AG4fiR\u0013XO\\2bi\u0016\fV/\u001a:zI\u0011,g-Y;mi\u0012\u0012TCAAAU\u0011\t)(a!,\u0005\u0005\u0015\u0005\u0003BAD\u0003\u001fk!!!#\u000b\t\u0005-\u0015QR\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u000f?\u0013\u0011\t\t*!#\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0006cK\u001a|'/\u001a$fi\u000eDGCBAL\u0003;\u000b\t\u000bE\u0002>\u00033K1!a'?\u0005\u0011)f.\u001b;\t\u000f\u0005}E\u00021\u0001\u0002\u0010\u0005Q1m\u001c8oK\u000e$\u0018n\u001c8\t\u000f\u0005\rF\u00021\u0001\u0002&\u0006Q\u0001O]8qKJ$\u0018.Z:\u0011\u000b]\u000b9K\u0016,\n\u0007\u0005%\u0006MA\u0002NCB\f\u0011\"Z:dCB,7+\u001d7\u0015\u0007Y\u000by\u000b\u0003\u0004\u000226\u0001\rAV\u0001\u0006m\u0006dW/\u001a\u0015\u0006\u001b\u0005U\u0012\u0011N\u0001\rG>l\u0007/\u001b7f-\u0006dW/\u001a\u000b\u0005\u0003s\u000by\fE\u0002>\u0003wK1!!0?\u0005\r\te.\u001f\u0005\b\u0003cs\u0001\u0019AA]Q\u0015q\u0011QGA5\u00059QEIQ\"T#2\u0013U/\u001b7eKJ\u001c2aDAd!\u0011\tI-a5\u000e\u0005\u0005-'\u0002BAg\u0003\u001f\fA!\u001e;jY*\u0019\u0011\u0011\u001b\u001a\u0002\u0013\r|gN\\3di>\u0014\u0018\u0002BAk\u0003\u0017\u0014aC\u0016\u001aFqB\u0014Xm]:j_:\u001c\u0016\u000b\u0014\"vS2$WM\u001d\u000b\u0003\u00033\u00042!a7\u0010\u001b\u0005\u0001\u0011\u0001\u0004<jg&$H*\u001b;fe\u0006dGc\u0001,\u0002b\"9\u00111]\tA\u0002\u0005\u0015\u0018a\u00027ji\u0016\u0014\u0018\r\u001c\u0019\u0005\u0003O\f9\u0010\u0005\u0004\u0002j\u0006=\u00181_\u0007\u0003\u0003WTA!!<\u0002P\u0006YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0013\u0011\t\t0a;\u0003\u000f1KG/\u001a:bYB!\u0011Q_A|\u0019\u0001!A\"!?\u0002b\u0006\u0005\t\u0011!B\u0001\u0003w\u00141a\u0018\u00132#\u0011\ti0!/\u0011\u0007u\ny0C\u0002\u0003\u0002y\u0012qAT8uQ&tw-A\nwSNLGOT1nK\u0012\u0014VMZ3sK:\u001cW\rF\u0002W\u0005\u000fAqA!\u0003\u0013\u0001\u0004\u0011Y!\u0001\u0005oC6,GMU3g!\u0011\tIO!\u0004\n\t\t=\u00111\u001e\u0002\u000f\u001d\u0006lW\r\u001a*fM\u0016\u0014XM\\2f\u0003%1\u0018n]5u\u0007\u0006\u001cH\u000fF\u0003W\u0005+\u0011I\u0002\u0003\u0004\u0003\u0018M\u0001\rAV\u0001\u0002Y\"1!1D\nA\u0002\u0019\f\u0001\u0002Z1uCRK\b/Z\u0001\u0011m&\u001c\u0018\u000e^*R\u0019\u001a+hn\u0019;j_:$RA\u0016B\u0011\u0005KAaAa\t\u0015\u0001\u00041\u0016\u0001\u00034v]\u000et\u0015-\\3\t\u000f\t\u001dB\u00031\u0001\u0003*\u00051\u0011N\u001c9viN\u0004B!\u0010B\u0016-&\u0019!Q\u0006 \u0003\u000b\u0005\u0013(/Y=\u0002'%\u001c8+\u001e9q_J$X\r\u001a$v]\u000e$\u0018n\u001c8\u0015\u0007E\u0013\u0019\u0004\u0003\u0004\u0003$U\u0001\rA\u0016\u0015\u0006+\u0005U\u0012\u0011I\u0001\u0012G>l\u0007/\u001b7f\u000bb\u0004(/Z:tS>tG\u0003\u0002B\u001e\u0005{\u00012!\u00103W\u0011\u001d\u0011yD\u0006a\u0001\u0005\u0003\nA!\u001a=qeB!\u0011\u0011\u001eB\"\u0013\u0011\u0011)%a;\u0003\u0015\u0015C\bO]3tg&|g\u000eK\u0003\u0017\u0003k\t\t%\u0001\td_6\u0004\u0018\u000e\\3BO\u001e\u0014XmZ1uKR!!1\bB'\u0011\u001d\u0011ye\u0006a\u0001\u0005#\n1\"Y4h\rVt7\r^5p]B!!1\u000bB-\u001b\t\u0011)F\u0003\u0003\u0003X\u0005-\u0018!C1hOJ,w-\u0019;f\u0013\u0011\u0011YF!\u0016\u0003\u001b\u0005;wM]3hCR,g)\u001e8dQ\u00159\u0012QGA!\u00031\u0019'/Z1uKN\u001b\u0007.Z7b)!\t9Ja\u0019\u0003n\tE\u0004b\u0002B31\u0001\u0007!qM\u0001\ngR\fG/Z7f]R\u0004B!!\u0005\u0003j%!!1NA\n\u0005%\u0019F/\u0019;f[\u0016tG\u000f\u0003\u0004\u0003pa\u0001\rAV\u0001\u0007g\u000eDW-\\1\t\r\tM\u0004\u00041\u0001W\u0003\u001d\u0019w.\\7f]R\fQb]2iK6\f7/\u0012=jgR\u001cHcB)\u0003z\tu$q\u0010\u0005\b\u0005wJ\u0002\u0019AA\b\u0003\u0011\u0019wN\u001c8\t\u000f\u0005}\u0011\u00041\u0001\u0002\"!1!qN\rA\u0002Y\u000b1\u0002\\5tiN\u001b\u0007.Z7bgR1!Q\u0011BD\u0005\u0013\u0003R!\u0010B\u0016\u0005SAqAa\u001f\u001b\u0001\u0004\ty\u0001C\u0004\u0002 i\u0001\r!!\t\u00021%\u001c8)Y:dC\u0012Lgn\u001a+sk:\u001c\u0017\r^3UC\ndW\r\u0006\u0002\u0002v\u0005Y!/\u001a8b[\u0016$\u0016M\u00197f)\u00151&1\u0013BL\u0011\u0019\u0011)\n\ba\u0001-\u0006Aq\u000e\u001c3UC\ndW\r\u0003\u0004\u0003\u001ar\u0001\rAV\u0001\t]\u0016<H+\u00192mK\u0006Q\u0011\r\u001c;feR\u000b'\r\\3\u0015\u0011\t%\"q\u0014BR\u0005\u000bDaA!)\u001e\u0001\u00041\u0016!\u0003;bE2,g*Y7f\u0011\u001d\u0011)+\ba\u0001\u0005O\u000bqa\u00195b]\u001e,7\u000f\u0005\u0004\u0003*\nM&\u0011\u0018\b\u0005\u0005W\u0013yKD\u0002Z\u0005[K\u0011aP\u0005\u0004\u0005cs\u0014a\u00029bG.\fw-Z\u0005\u0005\u0005k\u00139LA\u0002TKFT1A!-?!\u0011\u0011YL!1\u000e\u0005\tu&\u0002\u0002B`\u0003\u001f\fqaY1uC2|w-\u0003\u0003\u0003D\nu&a\u0003+bE2,7\t[1oO\u0016DaAa2\u001e\u0001\u0004q\u0017A\u00043c\u001b\u0006TwN\u001d,feNLwN\\\u0001\u0012O\u0016$\u0018\t\u001a3D_2,XN\\)vKJLHc\u0002,\u0003N\n='1\u001b\u0005\u0007\u0005Cs\u0002\u0019\u0001,\t\r\tEg\u00041\u0001W\u0003)\u0019w\u000e\\;n]:\u000bW.\u001a\u0005\u0007\u00057q\u0002\u0019\u0001,\u0002)\u001d,GOU3oC6,7i\u001c7v[:\fV/\u001a:z)%1&\u0011\u001cBn\u0005;\u0014\t\u000f\u0003\u0004\u0003\"~\u0001\rA\u0016\u0005\u0007\u0005#|\u0002\u0019\u0001,\t\r\t}w\u00041\u0001W\u0003\u001dqWm\u001e(b[\u0016DaAa2 \u0001\u0004q\u0017\u0001F4fi\u0012+G.\u001a;f\u0007>dW/\u001c8Rk\u0016\u0014\u0018\u0010F\u0003W\u0005O\u0014I\u000f\u0003\u0004\u0003\"\u0002\u0002\rA\u0016\u0005\u0007\u0005#\u0004\u0003\u0019\u0001,\u00021\u001d,G/\u00169eCR,7i\u001c7v[:$\u0016\u0010]3Rk\u0016\u0014\u0018\u0010F\u0004W\u0005_\u0014\tPa=\t\r\t\u0005\u0016\u00051\u0001W\u0011\u0019\u0011\t.\ta\u0001-\"1!Q_\u0011A\u0002Y\u000b1B\\3x\t\u0006$\u0018\rV=qK\u0006yr-\u001a;Va\u0012\fG/Z\"pYVlgNT;mY\u0006\u0014\u0017\u000e\\5usF+XM]=\u0015\u000fY\u0013YP!@\u0003\u0000\"1!\u0011\u0015\u0012A\u0002YCaA!5#\u0001\u00041\u0006BBB\u0001E\u0001\u0007\u0011+\u0001\u0006jg:+H\u000e\\1cY\u0016\fAcZ3u)\u0006\u0014G.Z\"p[6,g\u000e^)vKJLH#\u0002,\u0004\b\r%\u0001BBA*G\u0001\u0007a\u000b\u0003\u0004\u0003t\r\u0002\rAV\u0001\u0016O\u0016$8k\u00195f[\u0006\u001cu.\\7f]R\fV/\u001a:z)\u001516qBB\t\u0011\u0019\u0011y\u0007\na\u0001-\"1!1\u000f\u0013A\u0002Y\u000b\u0001D]3n_Z,7k\u00195f[\u0006\u001cu.\\7f]R\fV/\u001a:z)\r16q\u0003\u0005\u0007\u0005_*\u0003\u0019\u0001,\u0002\u0015\u0011\u0014x\u000e]*dQ\u0016l\u0017\rF\u0003W\u0007;\u0019y\u0002\u0003\u0004\u0003p\u0019\u0002\rA\u0016\u0005\u0007\u0003g2\u0003\u0019A)\u0002\u0017\r\u0014X-\u0019;f\u0013:$W\r\u001f\u000b\f-\u000e\u00152\u0011FB\u0016\u0007c\u0019y\u0004\u0003\u0004\u0004(\u001d\u0002\rAV\u0001\nS:$W\r\u001f(b[\u0016DaA!)(\u0001\u00041\u0006bBB\u0017O\u0001\u00071qF\u0001\bG>dW/\u001c8t!\u0015i$1\u0006B\u0006\u0011\u001d\u0019\u0019d\na\u0001\u0007k\t\u0011cY8mk6t7\u000f\u0015:pa\u0016\u0014H/[3t!!\u00199da\u000f\u0003\f\ruRBAB\u001d\u0015\u0011\ti-!\u0006\n\t\u0005%6\u0011\b\t\u0007\u0007o\u0019YD\u0016,\t\u000f\u0005\rv\u00051\u0001\u0004>\u0005Y\u0011N\u001c3fq\u0016C\u0018n\u001d;t)%\t6QIB$\u0007\u0013\u001aY\u0005C\u0004\u0003|!\u0002\r!a\u0004\t\r\r\u001d\u0002\u00061\u0001W\u0011\u0019\u0011\t\u000b\u000ba\u0001-\"9\u0011q\u0004\u0015A\u0002\u0005\u0005\u0012!\u00033s_BLe\u000eZ3y)\u001516\u0011KB*\u0011\u0019\u00199#\u000ba\u0001-\"1!\u0011U\u0015A\u0002Y\u000b1\u0002\\5ti&sG-\u001a=fgRA1\u0011LB4\u0007S\u001aY\u0007E\u0003>\u0005W\u0019Y\u0006\u0005\u0003\u0004^\r\rTBAB0\u0015\u0011\u0019\tG!0\u0002\u000b%tG-\u001a=\n\t\r\u00154q\f\u0002\u000b)\u0006\u0014G.Z%oI\u0016D\bb\u0002B>U\u0001\u0007\u0011q\u0002\u0005\u0007\u0005CS\u0003\u0019\u0001,\t\u000f\u0005}!\u00061\u0001\u0002\"\u0005\t2\r\\1tg&4\u00170\u0012=dKB$\u0018n\u001c8\u0015\r\rE4\u0011PB?!\u0011\u0019\u0019h!\u001e\u000e\u0003IJ1aa\u001e3\u0005E\te.\u00197zg&\u001cX\t_2faRLwN\u001c\u0005\u0007\u0007wZ\u0003\u0019\u0001,\u0002\u000f5,7o]1hK\"91qP\u0016A\u0002\r\u0005\u0015!A3\u0011\t\t%61Q\u0005\u0005\u0007\u000b\u00139LA\u0005UQJ|w/\u00192mK\u0006qq-\u001a;MS6LGo\u00117bkN,Gc\u0001,\u0004\f\"91Q\u0012\u0017A\u0002\r=\u0015!\u00027j[&$\b\u0003BBI\u0007/k!aa%\u000b\t\rU\u0015QC\u0001\u0005Y\u0006tw-\u0003\u0003\u0004\u001a\u000eM%aB%oi\u0016<WM]\u0001\u0014gV\u0004\bo\u001c:ugR\u000b'\r\\3TC6\u0004H.Z\u000b\u0002#\u0006qq-\u001a;UC\ndWmU1na2,Gc\u0001,\u0004$\"91Q\u0015\u0018A\u0002\r\u001d\u0016AB:b[BdW\r\u0005\u0003\u0004*\u000e=VBABV\u0015\u0011\u0019i+a\n\u0002\u0005Y\u0014\u0014\u0002BBY\u0007W\u0013q\u0002V1cY\u0016\u001c\u0016-\u001c9mK&sgm\u001c\u0015\u0004\u0001\rU\u0006\u0003BA\u001c\u0007oKAa!/\u0002:\taA)\u001a<fY>\u0004XM]!qS\u0002")
public abstract class JdbcDialect
implements scala.Serializable,
Logging {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public abstract boolean canHandle(String var1);

    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        return None$.MODULE$;
    }

    public Option<JdbcType> getJDBCType(DataType dt) {
        return None$.MODULE$;
    }

    public Function1<Object, Connection> createConnectionFactory(JDBCOptions options) {
        String driverClass = options.driverClass();
        return (Function1 & Serializable & scala.Serializable)partitionId -> JdbcDialect.$anonfun$createConnectionFactory$1(driverClass, options, BoxesRunTime.unboxToInt((Object)partitionId));
    }

    public String quoteIdentifier(String colName) {
        return new StringBuilder(2).append("\"").append(colName).append("\"").toString();
    }

    public String getTableExistsQuery(String table) {
        return new StringBuilder(24).append("SELECT * FROM ").append(table).append(" WHERE 1=0").toString();
    }

    public String getSchemaQuery(String table) {
        return new StringBuilder(24).append("SELECT * FROM ").append(table).append(" WHERE 1=0").toString();
    }

    public String getTruncateQuery(String table) {
        return this.getTruncateQuery(table, this.isCascadingTruncateTable());
    }

    public String getTruncateQuery(String table, Option<Object> cascade) {
        return new StringBuilder(15).append("TRUNCATE TABLE ").append(table).toString();
    }

    public Option<Object> getTruncateQuery$default$2() {
        return this.isCascadingTruncateTable();
    }

    public void beforeFetch(Connection connection, scala.collection.immutable.Map<String, String> properties) {
    }

    public String escapeSql(String value) {
        if (value == null) {
            return null;
        }
        return StringUtils.replace((String)value, (String)"'", (String)"''");
    }

    public Object compileValue(Object value2) {
        Object object = value2;
        if (object instanceof String) {
            String string = (String)object;
            return new StringBuilder(2).append("'").append(this.escapeSql(string)).append("'").toString();
        }
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            return new StringBuilder(2).append("'").append(timestamp).append("'").toString();
        }
        if (object instanceof Instant) {
            Instant instant = (Instant)object;
            TimestampFormatter timestampFormatter = TimestampFormatter$.MODULE$.getFractionFormatter(DateTimeUtils$.MODULE$.getZoneId(SQLConf$.MODULE$.get().sessionLocalTimeZone()));
            return new StringBuilder(2).append("'").append(timestampFormatter.format(instant)).append("'").toString();
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            return new StringBuilder(2).append("'").append(date).append("'").toString();
        }
        if (object instanceof LocalDate) {
            LocalDate localDate = (LocalDate)object;
            return new StringBuilder(2).append("'").append(DateFormatter$.MODULE$.apply().format(localDate)).append("'").toString();
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            return Predef$.MODULE$.genericArrayOps(Predef$.MODULE$.genericArrayOps((Object)objectArray).map((Function1 & Serializable & scala.Serializable)value -> this.compileValue(value), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()))).mkString(", ");
        }
        return value2;
    }

    public boolean isSupportedFunction(String funcName) {
        return false;
    }

    public Option<String> compileExpression(Expression expr) {
        Some some;
        JDBCSQLBuilder jdbcSQLBuilder = new JDBCSQLBuilder();
        try {
            some = new Some((Object)jdbcSQLBuilder.build(expr));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error occurs while compiling V2 expression", e);
                some = None$.MODULE$;
            }
            throw throwable;
        }
        return some;
    }

    public Option<String> compileAggregate(AggregateFunc aggFunction) {
        AggregateFunc aggregateFunc = aggFunction;
        if (aggregateFunc instanceof Min) {
            Min min = (Min)aggregateFunc;
            return this.compileExpression(min.column()).map((Function1 & Serializable & scala.Serializable)v -> new StringBuilder(5).append("MIN(").append((String)v).append(")").toString());
        }
        if (aggregateFunc instanceof Max) {
            Max max = (Max)aggregateFunc;
            return this.compileExpression(max.column()).map((Function1 & Serializable & scala.Serializable)v -> new StringBuilder(5).append("MAX(").append((String)v).append(")").toString());
        }
        if (aggregateFunc instanceof Count) {
            Count count = (Count)aggregateFunc;
            String distinct = count.isDistinct() ? "DISTINCT " : "";
            return this.compileExpression(count.column()).map((Function1 & Serializable & scala.Serializable)v -> new StringBuilder(7).append("COUNT(").append(distinct).append((String)v).append(")").toString());
        }
        if (aggregateFunc instanceof Sum) {
            Sum sum = (Sum)aggregateFunc;
            String distinct = sum.isDistinct() ? "DISTINCT " : "";
            return this.compileExpression(sum.column()).map((Function1 & Serializable & scala.Serializable)v -> new StringBuilder(5).append("SUM(").append(distinct).append((String)v).append(")").toString());
        }
        if (aggregateFunc instanceof CountStar) {
            return new Some((Object)"COUNT(*)");
        }
        if (aggregateFunc instanceof Avg) {
            Avg avg = (Avg)aggregateFunc;
            String distinct = avg.isDistinct() ? "DISTINCT " : "";
            return this.compileExpression(avg.column()).map((Function1 & Serializable & scala.Serializable)v -> new StringBuilder(5).append("AVG(").append(distinct).append((String)v).append(")").toString());
        }
        return None$.MODULE$;
    }

    public void createSchema(Statement statement, String schema, String comment) {
        String schemaCommentQuery = new StringOps(Predef$.MODULE$.augmentString(comment)).nonEmpty() ? this.getSchemaCommentQuery(schema, comment) : comment;
        statement.executeUpdate(new StringBuilder(14).append("CREATE SCHEMA ").append(this.quoteIdentifier(schema)).toString());
        if (new StringOps(Predef$.MODULE$.augmentString(comment)).nonEmpty()) {
            statement.executeUpdate(schemaCommentQuery);
            return;
        }
    }

    public boolean schemasExists(Connection conn, JDBCOptions options, String schema) {
        ResultSet rs = conn.getMetaData().getSchemas(null, schema);
        while (rs.next()) {
            String string = rs.getString(1);
            String string2 = schema;
            if (string != null ? !string.equals(string2) : string2 != null) continue;
            return true;
        }
        return false;
    }

    public String[][] listSchemas(Connection conn, JDBCOptions options) {
        ArrayBuilder schemaBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
        ResultSet rs = conn.getMetaData().getSchemas();
        while (rs.next()) {
            schemaBuilder.$plus$eq((Object)new String[]{rs.getString(1)});
        }
        return (String[][])schemaBuilder.result();
    }

    public Option<Object> isCascadingTruncateTable() {
        return None$.MODULE$;
    }

    public String renameTable(String oldTable, String newTable) {
        return new StringBuilder(23).append("ALTER TABLE ").append(oldTable).append(" RENAME TO ").append(newTable).toString();
    }

    public String[] alterTable(String tableName, Seq<TableChange> changes, int dbMajorVersion) {
        ArrayBuilder updateClause = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(String.class));
        changes.foreach((Function1 & Serializable & scala.Serializable)change -> {
            TableChange.UpdateColumnNullability updateColumnNullability;
            TableChange.UpdateColumnType updateColumnType;
            TableChange.DeleteColumn deleteColumn;
            TableChange.RenameColumn renameColumn;
            TableChange.AddColumn addColumn;
            TableChange tableChange = change;
            if (tableChange instanceof TableChange.AddColumn && (addColumn = (TableChange.AddColumn)tableChange).fieldNames().length == 1) {
                String dataType = JdbcUtils$.MODULE$.getJdbcType(addColumn.dataType(), this).databaseTypeDefinition();
                String[] name = addColumn.fieldNames();
                return (ArrayBuilder)updateClause.$plus$eq((Object)this.getAddColumnQuery(tableName, name[0], dataType));
            }
            if (tableChange instanceof TableChange.RenameColumn && (renameColumn = (TableChange.RenameColumn)tableChange).fieldNames().length == 1) {
                String[] name = renameColumn.fieldNames();
                return (ArrayBuilder)updateClause.$plus$eq((Object)this.getRenameColumnQuery(tableName, name[0], renameColumn.newName(), dbMajorVersion));
            }
            if (tableChange instanceof TableChange.DeleteColumn && (deleteColumn = (TableChange.DeleteColumn)tableChange).fieldNames().length == 1) {
                String[] name = deleteColumn.fieldNames();
                return (ArrayBuilder)updateClause.$plus$eq((Object)this.getDeleteColumnQuery(tableName, name[0]));
            }
            if (tableChange instanceof TableChange.UpdateColumnType && (updateColumnType = (TableChange.UpdateColumnType)tableChange).fieldNames().length == 1) {
                String[] name = updateColumnType.fieldNames();
                String dataType = JdbcUtils$.MODULE$.getJdbcType(updateColumnType.newDataType(), this).databaseTypeDefinition();
                return (ArrayBuilder)updateClause.$plus$eq((Object)this.getUpdateColumnTypeQuery(tableName, name[0], dataType));
            }
            if (tableChange instanceof TableChange.UpdateColumnNullability && (updateColumnNullability = (TableChange.UpdateColumnNullability)tableChange).fieldNames().length == 1) {
                String[] name = updateColumnNullability.fieldNames();
                return (ArrayBuilder)updateClause.$plus$eq((Object)this.getUpdateColumnNullabilityQuery(tableName, name[0], updateColumnNullability.nullable()));
            }
            throw QueryCompilationErrors$.MODULE$.unsupportedTableChangeInJDBCCatalogError(change);
        });
        return (String[])updateClause.result();
    }

    public String getAddColumnQuery(String tableName, String columnName, String dataType) {
        return new StringBuilder(25).append("ALTER TABLE ").append(tableName).append(" ADD COLUMN ").append(this.quoteIdentifier(columnName)).append(" ").append(dataType).toString();
    }

    public String getRenameColumnQuery(String tableName, String columnName, String newName, int dbMajorVersion) {
        return new StringBuilder(31).append("ALTER TABLE ").append(tableName).append(" RENAME COLUMN ").append(this.quoteIdentifier(columnName)).append(" TO").append(" ").append(this.quoteIdentifier(newName)).toString();
    }

    public String getDeleteColumnQuery(String tableName, String columnName) {
        return new StringBuilder(25).append("ALTER TABLE ").append(tableName).append(" DROP COLUMN ").append(this.quoteIdentifier(columnName)).toString();
    }

    public String getUpdateColumnTypeQuery(String tableName, String columnName, String newDataType) {
        return new StringBuilder(27).append("ALTER TABLE ").append(tableName).append(" ALTER COLUMN ").append(this.quoteIdentifier(columnName)).append(" ").append(newDataType).toString();
    }

    public String getUpdateColumnNullabilityQuery(String tableName, String columnName, boolean isNullable) {
        String nullable = isNullable ? "NULL" : "NOT NULL";
        return new StringBuilder(31).append("ALTER TABLE ").append(tableName).append(" ALTER COLUMN ").append(this.quoteIdentifier(columnName)).append(" SET ").append(nullable).toString();
    }

    public String getTableCommentQuery(String table, String comment) {
        return new StringBuilder(23).append("COMMENT ON TABLE ").append(table).append(" IS '").append(comment).append("'").toString();
    }

    public String getSchemaCommentQuery(String schema, String comment) {
        return new StringBuilder(24).append("COMMENT ON SCHEMA ").append(this.quoteIdentifier(schema)).append(" IS '").append(comment).append("'").toString();
    }

    public String removeSchemaCommentQuery(String schema) {
        return new StringBuilder(26).append("COMMENT ON SCHEMA ").append(this.quoteIdentifier(schema)).append(" IS NULL").toString();
    }

    public String dropSchema(String schema, boolean cascade) {
        if (cascade) {
            return new StringBuilder(20).append("DROP SCHEMA ").append(this.quoteIdentifier(schema)).append(" CASCADE").toString();
        }
        return new StringBuilder(12).append("DROP SCHEMA ").append(this.quoteIdentifier(schema)).toString();
    }

    public String createIndex(String indexName, String tableName, NamedReference[] columns, Map<NamedReference, Map<String, String>> columnsProperties, Map<String, String> properties) {
        throw new UnsupportedOperationException("createIndex is not supported");
    }

    public boolean indexExists(Connection conn, String indexName, String tableName, JDBCOptions options) {
        throw new UnsupportedOperationException("indexExists is not supported");
    }

    public String dropIndex(String indexName, String tableName) {
        throw new UnsupportedOperationException("dropIndex is not supported");
    }

    public TableIndex[] listIndexes(Connection conn, String tableName, JDBCOptions options) {
        throw new UnsupportedOperationException("listIndexes is not supported");
    }

    public AnalysisException classifyException(String message, Throwable e) {
        String x$1 = message;
        Some x$2 = new Some((Object)e);
        Option x$3 = AnalysisException$.MODULE$.$lessinit$greater$default$2();
        Option x$4 = AnalysisException$.MODULE$.$lessinit$greater$default$3();
        Option x$5 = AnalysisException$.MODULE$.$lessinit$greater$default$4();
        Option x$6 = AnalysisException$.MODULE$.$lessinit$greater$default$6();
        String[] x$7 = AnalysisException$.MODULE$.$lessinit$greater$default$7();
        return new AnalysisException(x$1, x$3, x$4, x$5, (Option)x$2, x$6, x$7);
    }

    public String getLimitClause(Integer limit) {
        if (Predef$.MODULE$.Integer2int(limit) > 0) {
            return new StringBuilder(6).append("LIMIT ").append(limit).toString();
        }
        return "";
    }

    public boolean supportsTableSample() {
        return false;
    }

    public String getTableSample(TableSampleInfo sample) {
        throw new UnsupportedOperationException("TableSample is not supported by this data source");
    }

    public static final /* synthetic */ Connection $anonfun$createConnectionFactory$1(String driverClass$1, JDBCOptions options$1, int partitionId) {
        DriverRegistry$.MODULE$.register(driverClass$1);
        Driver driver = DriverRegistry$.MODULE$.get(driverClass$1);
        Connection connection = ConnectionProvider$.MODULE$.create(driver, (scala.collection.immutable.Map<String, String>)options$1.parameters(), options$1.connectionProviderName());
        Predef$.MODULE$.require(connection != null, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("The driver could not open a JDBC connection. Check the URL: ").append(options$1.url()).toString());
        return connection;
    }

    public JdbcDialect() {
        Logging.$init$((Logging)this);
    }

    public class JDBCSQLBuilder
    extends V2ExpressionSQLBuilder {
        public String visitLiteral(Literal<?> literal) {
            return this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().compileValue(CatalystTypeConverters$.MODULE$.convertToScala(literal.value(), literal.dataType())).toString();
        }

        public String visitNamedReference(NamedReference namedRef) {
            if (namedRef.fieldNames().length > 1) {
                throw QueryCompilationErrors$.MODULE$.commandNotSupportNestedColumnError("Filter push down", namedRef.toString());
            }
            return this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().quoteIdentifier((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])namedRef.fieldNames())).head());
        }

        public String visitCast(String l, DataType dataType) {
            String databaseTypeDefinition = (String)this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().getJDBCType(dataType).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.databaseTypeDefinition()).getOrElse((Function0 & Serializable & scala.Serializable)() -> dataType.typeName());
            return new StringBuilder(10).append("CAST(").append(l).append(" AS ").append(databaseTypeDefinition).append(")").toString();
        }

        public String visitSQLFunction(String funcName, String[] inputs) {
            if (this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().isSupportedFunction(funcName)) {
                return new StringBuilder(2).append(funcName).append("(").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inputs)).mkString(", ")).append(")").toString();
            }
            throw new UnsupportedOperationException(new StringBuilder(28).append(this.getClass().getSimpleName()).append(" does not support function: ").append(funcName).toString());
        }

        public /* synthetic */ JdbcDialect org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer() {
            return JdbcDialect.this;
        }

        public JDBCSQLBuilder() {
            if (JdbcDialect.this == null) {
                throw null;
            }
        }
    }
}

