/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Locale;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.SparkHadoopUtil;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogUtils$;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.connector.catalog.TableProvider;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.csv.CSVFileFormat;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcRelationProvider;
import org.apache.spark.sql.execution.datasources.json.JsonFileFormat;
import org.apache.spark.sql.execution.datasources.orc.OrcFileFormat;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat;
import org.apache.spark.sql.execution.datasources.v2.orc.OrcDataSourceV2;
import org.apache.spark.sql.execution.streaming.sources.RateStreamProvider;
import org.apache.spark.sql.execution.streaming.sources.TextSocketSourceProvider;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.HadoopFSUtils$;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple8;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class DataSource$
implements Logging,
scala.Serializable {
    public static DataSource$ MODULE$;
    private final Map<String, String> backwardCompatibilityMap;
    private final Set<String> spark2RemovedClasses;
    private final String GLOB_PATHS_KEY;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new DataSource$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Seq<String> $lessinit$greater$default$3() {
        return Nil$.MODULE$;
    }

    public Option<StructType> $lessinit$greater$default$4() {
        return None$.MODULE$;
    }

    public Seq<String> $lessinit$greater$default$5() {
        return (Seq)Nil$.MODULE$;
    }

    public Option<BucketSpec> $lessinit$greater$default$6() {
        return None$.MODULE$;
    }

    public Map<String, String> $lessinit$greater$default$7() {
        return Predef$.MODULE$.Map().empty();
    }

    public Option<CatalogTable> $lessinit$greater$default$8() {
        return None$.MODULE$;
    }

    private Map<String, String> backwardCompatibilityMap() {
        return this.backwardCompatibilityMap;
    }

    private Set<String> spark2RemovedClasses() {
        return this.spark2RemovedClasses;
    }

    /*
     * Unable to fully structure code
     */
    public Class<?> lookupDataSource(String provider, SQLConf conf) {
        block18: {
            block20: {
                block19: {
                    var8_3 = (String)this.backwardCompatibilityMap().getOrElse((Object)provider, (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$lookupDataSource$1(java.lang.String ), ()Ljava/lang/String;)((String)provider));
                    if (!var8_3.equalsIgnoreCase("orc")) break block19;
                    v0 = conf.getConf(SQLConf$.MODULE$.ORC_IMPLEMENTATION());
                    var9_4 = "native";
                    if (v0 != null ? v0.equals(var9_4) == false : var9_4 != null) break block19;
                    v1 = OrcDataSourceV2.class.getCanonicalName();
                    break block20;
                }
                if (!var8_3.equalsIgnoreCase("orc")) ** GOTO lbl-1000
                v2 = conf.getConf(SQLConf$.MODULE$.ORC_IMPLEMENTATION());
                var10_5 = "hive";
                if (!(v2 != null ? v2.equals(var10_5) == false : var10_5 != null)) {
                    v1 = "org.apache.spark.sql.hive.orc.OrcFileFormat";
                } else lbl-1000:
                // 2 sources

                {
                    v1 = "com.databricks.spark.avro".equals(var8_3) != false && conf.replaceDatabricksSparkAvroEnabled() != false ? "org.apache.spark.sql.avro.AvroFileFormat" : var8_3;
                }
            }
            provider1 = v1;
            provider2 = new StringBuilder(14).append(provider1).append(".DefaultSource").toString();
            loader = Utils$.MODULE$.getContextOrSparkClassLoader();
            serviceLoader = ServiceLoader.load(DataSourceRegister.class, loader);
            try {
                block21: {
                    var14_10 = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(serviceLoader).asScala()).filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$lookupDataSource$2$adapted(java.lang.String org.apache.spark.sql.sources.DataSourceRegister ), (Lorg/apache/spark/sql/sources/DataSourceRegister;)Ljava/lang/Object;)((String)provider1))).toList();
                    if (!Nil$.MODULE$.equals(var14_10)) break block21;
                    try {
                        block22: {
                            block23: {
                                block25: {
                                    block24: {
                                        var15_11 = Try$.MODULE$.apply((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$lookupDataSource$3(java.lang.ClassLoader java.lang.String ), ()Ljava/lang/Class;)((ClassLoader)loader, (String)provider1)).orElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$lookupDataSource$4(java.lang.ClassLoader java.lang.String ), ()Lscala/util/Try;)((ClassLoader)loader, (String)provider2));
                                        if (var15_11 instanceof Success) break block22;
                                        if (!(var15_11 instanceof Failure)) break block23;
                                        var18_14 = (Failure)var15_11;
                                        error = var18_14.exception();
                                        if (provider1.startsWith("org.apache.spark.sql.hive.orc")) {
                                            throw QueryCompilationErrors$.MODULE$.orcNotUsedWithHiveEnabledError();
                                        }
                                        v3 = provider1.toLowerCase(Locale.ROOT);
                                        var20_16 = "avro";
                                        if (!(v3 == null ? var20_16 != null : v3.equals(var20_16) == false)) break block24;
                                        v4 = provider1;
                                        var21_17 = "com.databricks.spark.avro";
                                        if (!(v4 == null ? var21_17 != null : v4.equals(var21_17) == false)) break block24;
                                        v5 = provider1;
                                        var22_18 = "org.apache.spark.sql.avro";
                                        if (v5 != null ? v5.equals(var22_18) == false : var22_18 != null) break block25;
                                    }
                                    throw QueryCompilationErrors$.MODULE$.failedToFindAvroDataSourceError(provider1);
                                }
                                v6 = provider1.toLowerCase(Locale.ROOT);
                                var23_19 = "kafka";
                                if (!(v6 != null ? v6.equals(var23_19) == false : var23_19 != null)) {
                                    throw QueryCompilationErrors$.MODULE$.failedToFindKafkaDataSourceError(provider1);
                                }
                                throw QueryExecutionErrors$.MODULE$.failedToFindDataSourceError(provider1, error);
                            }
                            throw new MatchError((Object)var15_11);
                        }
                        var16_12 = (Success)var15_11;
                        v7 = dataSource = (Class<?>)var16_12.value();
                        break block18;
                    }
                    catch (NoClassDefFoundError e) {
                        className = e.getMessage().replaceAll("/", ".");
                        if (this.spark2RemovedClasses().contains((Object)className)) {
                            throw QueryExecutionErrors$.MODULE$.removedClassInSpark2Error(className, (Throwable)e);
                        }
                        throw e;
                    }
                }
                if (var14_10 instanceof .colon.colon) {
                    var26_22 = (.colon.colon)var14_10;
                    head = (DataSourceRegister)var26_22.head();
                    var28_24 = var26_22.tl$access$1();
                    if (Nil$.MODULE$.equals(var28_24)) {
                        v7 = head.getClass();
                        break block18;
                    }
                }
                sourceNames = (List)var14_10.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$lookupDataSource$6(org.apache.spark.sql.sources.DataSourceRegister ), (Lorg/apache/spark/sql/sources/DataSourceRegister;)Ljava/lang/String;)(), List$.MODULE$.canBuildFrom());
                internalSources = (List)var14_10.filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$lookupDataSource$7$adapted(org.apache.spark.sql.sources.DataSourceRegister ), (Lorg/apache/spark/sql/sources/DataSourceRegister;)Ljava/lang/Object;)());
                if (internalSources.size() == 1) {
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$lookupDataSource$8(java.lang.String scala.collection.immutable.List scala.collection.immutable.List ), ()Ljava/lang/String;)((String)provider1, (List)sourceNames, (List)internalSources));
                    v7 = internalSources.head().getClass();
                    break block18;
                }
                throw QueryCompilationErrors$.MODULE$.findMultipleDataSourceError(provider1, (Seq)sourceNames);
            }
            catch (Throwable var31_27) {
                var32_28 = var31_27;
                if (var32_28 instanceof ServiceConfigurationError && (var33_29 = (ServiceConfigurationError)var32_28).getCause() instanceof NoClassDefFoundError) {
                    className = var33_29.getCause().getMessage().replaceAll("/", ".");
                    if (this.spark2RemovedClasses().contains((Object)className)) {
                        throw QueryExecutionErrors$.MODULE$.incompatibleDataSourceRegisterError((Throwable)var33_29);
                    }
                    throw var33_29;
                }
                throw var31_27;
            }
        }
        return v7;
    }

    public Option<TableProvider> lookupDataSourceV2(String provider, SQLConf conf) {
        String[] useV1Sources = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)conf.getConf(SQLConf$.MODULE$.USE_V1_SOURCE_LIST())).toLowerCase(Locale.ROOT).split(","))).map((Function1 & Serializable & scala.Serializable)x$20 -> x$20.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        Class<?> cls = this.lookupDataSource(provider, conf);
        Object obj = cls.newInstance();
        if (obj instanceof DataSourceRegister) {
            Object obj2 = obj;
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])useV1Sources)).contains((Object)((DataSourceRegister)obj2).shortName())) {
                return None$.MODULE$;
            }
        }
        if (obj instanceof TableProvider) {
            Object obj3 = obj;
            if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])useV1Sources)).contains((Object)cls.getCanonicalName().toLowerCase(Locale.ROOT))) {
                return new Some(obj3);
            }
        }
        return None$.MODULE$;
    }

    public String GLOB_PATHS_KEY() {
        return this.GLOB_PATHS_KEY;
    }

    public Seq<Path> checkAndGlobPathIfNecessary(Seq<String> pathStrings, Configuration hadoopConf, boolean checkEmptyGlobPath, boolean checkFilesExist, Integer numThreads, boolean enableGlobbing) {
        Seq allPaths;
        block10: {
            BoxedUnit boxedUnit;
            Seq seq;
            SparkHadoopUtil sparkHadoopUtil;
            Seq qualifiedPaths = (Seq)pathStrings.map((Function1 & Serializable & scala.Serializable)pathString -> {
                Path path = new Path(pathString);
                FileSystem fs = path.getFileSystem(hadoopConf);
                return path.makeQualified(fs.getUri(), fs.getWorkingDirectory());
            }, Seq$.MODULE$.canBuildFrom());
            Tuple2 tuple2 = qualifiedPaths.partition(arg_0 -> DataSource$.$anonfun$checkAndGlobPathIfNecessary$2$adapted(sparkHadoopUtil = SparkHadoopUtil$.MODULE$.get(), arg_0));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq globPaths = (Seq)tuple2._1();
            Seq nonGlobPaths = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)globPaths, (Object)nonGlobPaths);
            Seq globPaths2 = (Seq)tuple22._1();
            Seq nonGlobPaths2 = (Seq)tuple22._2();
            try {
                seq = (Seq)ThreadUtils$.MODULE$.parmap(globPaths2, "globPath", Predef$.MODULE$.Integer2int(numThreads), (Function1 & Serializable & scala.Serializable)globPath -> {
                    Seq globResult;
                    FileSystem fs = globPath.getFileSystem(hadoopConf);
                    Seq seq = globResult = enableGlobbing ? SparkHadoopUtil$.MODULE$.get().globPath(fs, globPath) : qualifiedPaths;
                    if (checkEmptyGlobPath && globResult.isEmpty()) {
                        throw QueryCompilationErrors$.MODULE$.dataPathNotExistError(globPath.toString());
                    }
                    return globResult;
                }).flatten((Function1)Predef$.MODULE$.$conforms());
            }
            catch (SparkException e) {
                throw e.getCause();
            }
            Seq globbedPaths = seq;
            if (checkFilesExist) {
                try {
                    boxedUnit = ThreadUtils$.MODULE$.parmap(nonGlobPaths2, "checkPathsExist", Predef$.MODULE$.Integer2int(numThreads), (Function1 & Serializable & scala.Serializable)path -> {
                        DataSource$.$anonfun$checkAndGlobPathIfNecessary$4(hadoopConf, path);
                        return BoxedUnit.UNIT;
                    });
                }
                catch (SparkException e) {
                    throw e.getCause();
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            allPaths = (Seq)globbedPaths.$plus$plus((GenTraversableOnce)nonGlobPaths2, Seq$.MODULE$.canBuildFrom());
            if (!checkFilesExist) break block10;
            Tuple2 tuple23 = allPaths.partition((Function1 & Serializable & scala.Serializable)path -> BoxesRunTime.boxToBoolean((boolean)HadoopFSUtils$.MODULE$.shouldFilterOutPathName(path.getName())));
            if (tuple23 == null) {
                throw new MatchError((Object)tuple23);
            }
            Seq filteredOut = (Seq)tuple23._1();
            Seq filteredIn = (Seq)tuple23._2();
            Tuple2 tuple24 = new Tuple2((Object)filteredOut, (Object)filteredIn);
            Seq filteredOut2 = (Seq)tuple24._1();
            Seq filteredIn2 = (Seq)tuple24._2();
            if (filteredIn2.isEmpty()) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("All paths were ignored:\n  ").append(filteredOut2.mkString("\n  ")).toString());
            } else {
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Some paths were ignored:\n  ").append(filteredOut2.mkString("\n  ")).toString());
            }
        }
        return allPaths;
    }

    public Integer checkAndGlobPathIfNecessary$default$5() {
        return Predef$.MODULE$.int2Integer(40);
    }

    public CatalogStorageFormat buildStorageFormatFromOptions(Map<String, String> options) {
        Option path = CaseInsensitiveMap$.MODULE$.apply(options).get("path");
        Map optionsWithoutPath = options.filterKeys((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)DataSource$.$anonfun$buildStorageFormatFromOptions$1(x$23)));
        Option x$1 = path.map((Function1 & Serializable & scala.Serializable)str -> CatalogUtils$.MODULE$.stringToURI(str));
        Map x$2 = optionsWithoutPath.toMap(Predef$.MODULE$.$conforms());
        Option x$3 = CatalogStorageFormat$.MODULE$.empty().copy$default$2();
        Option x$4 = CatalogStorageFormat$.MODULE$.empty().copy$default$3();
        Option x$5 = CatalogStorageFormat$.MODULE$.empty().copy$default$4();
        boolean x$6 = CatalogStorageFormat$.MODULE$.empty().copy$default$5();
        return CatalogStorageFormat$.MODULE$.empty().copy(x$1, x$3, x$4, x$5, x$6, x$2);
    }

    public void validateSchema(StructType schema) {
        if (DataSource$.hasEmptySchema$1(schema)) {
            throw QueryCompilationErrors$.MODULE$.writeEmptySchemasUnsupportedByDataSourceError();
        }
    }

    public DataSource apply(SparkSession sparkSession, String className, Seq<String> paths, Option<StructType> userSpecifiedSchema, Seq<String> partitionColumns, Option<BucketSpec> bucketSpec, Map<String, String> options, Option<CatalogTable> catalogTable) {
        return new DataSource(sparkSession, className, paths, userSpecifiedSchema, partitionColumns, bucketSpec, options, catalogTable);
    }

    public Seq<String> apply$default$3() {
        return Nil$.MODULE$;
    }

    public Option<StructType> apply$default$4() {
        return None$.MODULE$;
    }

    public Seq<String> apply$default$5() {
        return (Seq)Nil$.MODULE$;
    }

    public Option<BucketSpec> apply$default$6() {
        return None$.MODULE$;
    }

    public Map<String, String> apply$default$7() {
        return Predef$.MODULE$.Map().empty();
    }

    public Option<CatalogTable> apply$default$8() {
        return None$.MODULE$;
    }

    public Option<Tuple8<SparkSession, String, Seq<String>, Option<StructType>, Seq<String>, Option<BucketSpec>, Map<String, String>, Option<CatalogTable>>> unapply(DataSource x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple8((Object)x$0.sparkSession(), (Object)x$0.className(), x$0.paths(), x$0.userSpecifiedSchema(), x$0.partitionColumns(), x$0.bucketSpec(), x$0.options(), x$0.catalogTable()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ String $anonfun$lookupDataSource$1(String provider$1) {
        return provider$1;
    }

    public static final /* synthetic */ boolean $anonfun$lookupDataSource$2(String provider1$1, DataSourceRegister x$17) {
        return x$17.shortName().equalsIgnoreCase(provider1$1);
    }

    public static final /* synthetic */ Class $anonfun$lookupDataSource$3(ClassLoader loader$1, String provider1$1) {
        return loader$1.loadClass(provider1$1);
    }

    public static final /* synthetic */ Try $anonfun$lookupDataSource$4(ClassLoader loader$1, String provider2$1) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> loader$1.loadClass(provider2$1));
    }

    public static final /* synthetic */ String $anonfun$lookupDataSource$6(DataSourceRegister x$18) {
        return x$18.getClass().getName();
    }

    public static final /* synthetic */ boolean $anonfun$lookupDataSource$7(DataSourceRegister x$19) {
        return x$19.getClass().getName().startsWith("org.apache.spark");
    }

    public static final /* synthetic */ String $anonfun$lookupDataSource$8(String provider1$1, List sourceNames$1, List internalSources$1) {
        return new StringBuilder(73).append("Multiple sources found for ").append(provider1$1).append(" (").append(sourceNames$1.mkString(", ")).append("), ").append("defaulting to the internal datasource (").append(internalSources$1.head().getClass().getName()).append(").").toString();
    }

    public static final /* synthetic */ void $anonfun$checkAndGlobPathIfNecessary$4(Configuration hadoopConf$1, Path path) {
        FileSystem fs = path.getFileSystem(hadoopConf$1);
        if (!fs.exists(path)) {
            throw QueryCompilationErrors$.MODULE$.dataPathNotExistError(path.toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$buildStorageFormatFromOptions$1(String x$23) {
        String string = x$23.toLowerCase(Locale.ROOT);
        String string2 = "path";
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$validateSchema$1(StructField x0$1) {
        DataType b;
        StructField structField = x0$1;
        if (structField != null && (b = structField.dataType()) instanceof StructType) {
            StructType structType = (StructType)b;
            return DataSource$.hasEmptySchema$1(structType);
        }
        return false;
    }

    private static final boolean hasEmptySchema$1(StructType schema) {
        return schema.size() == 0 || schema.exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DataSource$.$anonfun$validateSchema$1(x0$1)));
    }

    private DataSource$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        String jdbc = JdbcRelationProvider.class.getCanonicalName();
        String json = JsonFileFormat.class.getCanonicalName();
        String parquet = ParquetFileFormat.class.getCanonicalName();
        String csv = CSVFileFormat.class.getCanonicalName();
        String libsvm = "org.apache.spark.ml.source.libsvm.LibSVMFileFormat";
        String orc = "org.apache.spark.sql.hive.orc.OrcFileFormat";
        String nativeOrc = OrcFileFormat.class.getCanonicalName();
        String socket = TextSocketSourceProvider.class.getCanonicalName();
        String rate = RateStreamProvider.class.getCanonicalName();
        this.backwardCompatibilityMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.jdbc"), (Object)jdbc), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.jdbc.DefaultSource"), (Object)jdbc), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.execution.datasources.jdbc.DefaultSource"), (Object)jdbc), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.execution.datasources.jdbc"), (Object)jdbc), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.json"), (Object)json), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.json.DefaultSource"), (Object)json), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.execution.datasources.json"), (Object)json), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.execution.datasources.json.DefaultSource"), (Object)json), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.parquet"), (Object)parquet), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.parquet.DefaultSource"), (Object)parquet), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.execution.datasources.parquet"), (Object)parquet), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.execution.datasources.parquet.DefaultSource"), (Object)parquet), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.hive.orc.DefaultSource"), (Object)orc), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.hive.orc"), (Object)orc), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.execution.datasources.orc.DefaultSource"), (Object)nativeOrc), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.execution.datasources.orc"), (Object)nativeOrc), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.ml.source.libsvm.DefaultSource"), (Object)libsvm), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.ml.source.libsvm"), (Object)libsvm), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"com.databricks.spark.csv"), (Object)csv), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.execution.streaming.TextSocketSourceProvider"), (Object)socket), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.execution.streaming.RateSourceProvider"), (Object)rate)}));
        this.spark2RemovedClasses = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"org.apache.spark.sql.DataFrame", "org.apache.spark.sql.sources.HadoopFsRelationProvider", "org.apache.spark.Logging"}));
        this.GLOB_PATHS_KEY = "__globPaths__";
    }

    public static final /* synthetic */ Object $anonfun$lookupDataSource$2$adapted(String provider1$1, DataSourceRegister x$17) {
        return BoxesRunTime.boxToBoolean((boolean)DataSource$.$anonfun$lookupDataSource$2(provider1$1, x$17));
    }

    public static final /* synthetic */ Object $anonfun$lookupDataSource$7$adapted(DataSourceRegister x$19) {
        return BoxesRunTime.boxToBoolean((boolean)DataSource$.$anonfun$lookupDataSource$7(x$19));
    }

    public static final /* synthetic */ Object $anonfun$checkAndGlobPathIfNecessary$2$adapted(SparkHadoopUtil eta$0$1$1, Path pattern) {
        return BoxesRunTime.boxToBoolean((boolean)eta$0$1$1.isGlobPath(pattern));
    }
}

