/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.trees.LeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.command.CommandUtils$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.LeafRunnableCommand;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.command.TruncateTableCommand$;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.util.PartitioningUtils$;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005eg\u0001\u0002\r\u001a\u0001\u001aB\u0001B\u0010\u0001\u0003\u0016\u0004%\ta\u0010\u0005\t\t\u0002\u0011\t\u0012)A\u0005\u0001\"AQ\t\u0001BK\u0002\u0013\u0005a\t\u0003\u0005c\u0001\tE\t\u0015!\u0003H\u0011\u0015\u0019\u0007\u0001\"\u0001e\u0011\u0015A\u0007\u0001\"\u0011j\u0011\u0015Y\b\u0001\"\u0003}\u0011%\tY\u0003AA\u0001\n\u0003\ti\u0003C\u0005\u00024\u0001\t\n\u0011\"\u0001\u00026!I\u00111\n\u0001\u0012\u0002\u0013\u0005\u0011Q\n\u0005\n\u0003#\u0002\u0011\u0011!C!\u0003'B\u0011\"!\u001a\u0001\u0003\u0003%\t!a\u001a\t\u0013\u0005=\u0004!!A\u0005\u0002\u0005E\u0004\"CA?\u0001\u0005\u0005I\u0011IA@\u0011%\ti\tAA\u0001\n\u0003\ty\tC\u0005\u0002\u001a\u0002\t\t\u0011\"\u0011\u0002\u001c\u001eI\u0011qT\r\u0002\u0002#\u0005\u0011\u0011\u0015\u0004\t1e\t\t\u0011#\u0001\u0002$\"11M\u0005C\u0001\u0003cC\u0011\"a-\u0013\u0003\u0003%)%!.\t\u0013\u0005]&#!A\u0005\u0002\u0006e\u0006\"CA`%\u0005\u0005I\u0011QAa\u0011%\tyMEA\u0001\n\u0013\t\tN\u0001\u000bUeVt7-\u0019;f)\u0006\u0014G.Z\"p[6\fg\u000e\u001a\u0006\u00035m\tqaY8n[\u0006tGM\u0003\u0002\u001d;\u0005IQ\r_3dkRLwN\u001c\u0006\u0003=}\t1a]9m\u0015\t\u0001\u0013%A\u0003ta\u0006\u00148N\u0003\u0002#G\u00051\u0011\r]1dQ\u0016T\u0011\u0001J\u0001\u0004_J<7\u0001A\n\u0006\u0001\u001d\nTg\u000f\t\u0003Q=j\u0011!\u000b\u0006\u0003U-\nq\u0001\\8hS\u000e\fGN\u0003\u0002-[\u0005)\u0001\u000f\\1og*\u0011a&H\u0001\tG\u0006$\u0018\r\\=ti&\u0011\u0001'\u000b\u0002\f\u0019><\u0017nY1m!2\fg\u000e\u0005\u00023g5\t\u0011$\u0003\u000253\t\u0019B*Z1g%Vtg.\u00192mK\u000e{W.\\1oIB\u0011a'O\u0007\u0002o)\t\u0001(A\u0003tG\u0006d\u0017-\u0003\u0002;o\t9\u0001K]8ek\u000e$\bC\u0001\u001c=\u0013\titG\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\u0005uC\ndWMT1nKV\t\u0001\t\u0005\u0002B\u00056\tQ&\u0003\u0002D[\tyA+\u00192mK&#WM\u001c;jM&,'/\u0001\u0006uC\ndWMT1nK\u0002\nQ\u0002]1si&$\u0018n\u001c8Ta\u0016\u001cW#A$\u0011\u0007YB%*\u0003\u0002Jo\t1q\n\u001d;j_:\u0004\"aS0\u000f\u00051cfBA'[\u001d\tq\u0015L\u0004\u0002P1:\u0011\u0001k\u0016\b\u0003#Zs!AU+\u000e\u0003MS!\u0001V\u0013\u0002\rq\u0012xn\u001c;?\u0013\u0005!\u0013B\u0001\u0012$\u0013\t\u0001\u0013%\u0003\u0002\u001f?%\u0011a&H\u0005\u000376\nqaY1uC2|w-\u0003\u0002^=\u0006a1)\u0019;bY><G+\u001f9fg*\u00111,L\u0005\u0003A\u0006\u0014!\u0003V1cY\u0016\u0004\u0016M\u001d;ji&|gn\u00159fG*\u0011QLX\u0001\u000fa\u0006\u0014H/\u001b;j_:\u001c\u0006/Z2!\u0003\u0019a\u0014N\\5u}Q\u0019QMZ4\u0011\u0005I\u0002\u0001\"\u0002 \u0006\u0001\u0004\u0001\u0005\"B#\u0006\u0001\u00049\u0015a\u0001:v]R\u0011!n\u001e\t\u0004WB\u001chB\u00017o\u001d\t\u0011V.C\u00019\u0013\tyw'A\u0004qC\u000e\\\u0017mZ3\n\u0005E\u0014(aA*fc*\u0011qn\u000e\t\u0003iVl\u0011!H\u0005\u0003mv\u00111AU8x\u0011\u0015\u0001c\u00011\u0001y!\t!\u00180\u0003\u0002{;\ta1\u000b]1sWN+7o]5p]\u0006Ya.Z<BG2,e\u000e\u001e:z)\u001di\u0018qBA\r\u0003G\u00012A`A\u0006\u001b\u0005y(\u0002BA\u0001\u0003\u0007\t!\u0002]3s[&\u001c8/[8o\u0015\u0011\t)!a\u0002\u0002\u0005\u0019\u001c(bAA\u0005C\u00051\u0001.\u00193p_BL1!!\u0004\u0000\u0005!\t5\r\\#oiJL\bbBA\t\u000f\u0001\u0007\u00111C\u0001\u0006g\u000e|\u0007/\u001a\t\u0004}\u0006U\u0011bAA\f\u007f\ni\u0011i\u00197F]R\u0014\u0018pU2pa\u0016Dq!a\u0007\b\u0001\u0004\ti\"A\u0004bG2$\u0016\u0010]3\u0011\u0007y\fy\"C\u0002\u0002\"}\u0014A\"Q2m\u000b:$(/\u001f+za\u0016Dq!!\u0001\b\u0001\u0004\t)\u0003E\u0002\u007f\u0003OI1!!\u000b\u0000\u0005!15/Q2uS>t\u0017\u0001B2paf$R!ZA\u0018\u0003cAqA\u0010\u0005\u0011\u0002\u0003\u0007\u0001\tC\u0004F\u0011A\u0005\t\u0019A$\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u0007\u0016\u0004\u0001\u0006e2FAA\u001e!\u0011\ti$a\u0012\u000e\u0005\u0005}\"\u0002BA!\u0003\u0007\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0015s'\u0001\u0006b]:|G/\u0019;j_:LA!!\u0013\u0002@\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011q\n\u0016\u0004\u000f\u0006e\u0012!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002VA!\u0011qKA1\u001b\t\tIF\u0003\u0003\u0002\\\u0005u\u0013\u0001\u00027b]\u001eT!!a\u0018\u0002\t)\fg/Y\u0005\u0005\u0003G\nIF\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003S\u00022ANA6\u0013\r\tig\u000e\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003g\nI\bE\u00027\u0003kJ1!a\u001e8\u0005\r\te.\u001f\u0005\n\u0003wj\u0011\u0011!a\u0001\u0003S\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAA!\u0019\t\u0019)!#\u0002t5\u0011\u0011Q\u0011\u0006\u0004\u0003\u000f;\u0014AC2pY2,7\r^5p]&!\u00111RAC\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005E\u0015q\u0013\t\u0004m\u0005M\u0015bAAKo\t9!i\\8mK\u0006t\u0007\"CA>\u001f\u0005\u0005\t\u0019AA:\u0003\u0019)\u0017/^1mgR!\u0011\u0011SAO\u0011%\tY\bEA\u0001\u0002\u0004\t\u0019(\u0001\u000bUeVt7-\u0019;f)\u0006\u0014G.Z\"p[6\fg\u000e\u001a\t\u0003eI\u0019BAEASwA9\u0011qUAW\u0001\u001e+WBAAU\u0015\r\tYkN\u0001\beVtG/[7f\u0013\u0011\ty+!+\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0006\u0002\u0002\"\u0006AAo\\*ue&tw\r\u0006\u0002\u0002V\u0005)\u0011\r\u001d9msR)Q-a/\u0002>\")a(\u0006a\u0001\u0001\")Q)\u0006a\u0001\u000f\u00069QO\\1qa2LH\u0003BAb\u0003\u0017\u0004BA\u000e%\u0002FB)a'a2A\u000f&\u0019\u0011\u0011Z\u001c\u0003\rQ+\b\u000f\\33\u0011!\tiMFA\u0001\u0002\u0004)\u0017a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t\u0019\u000e\u0005\u0003\u0002X\u0005U\u0017\u0002BAl\u00033\u0012aa\u00142kK\u000e$\b")
public class TruncateTableCommand
extends LogicalPlan
implements LeafRunnableCommand,
scala.Serializable {
    private final TableIdentifier tableName;
    private final Option<Map<String, String>> partitionSpec;
    private Map<String, SQLMetric> metrics;
    private final Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<TableIdentifier, Option<Map<String, String>>>> unapply(TruncateTableCommand truncateTableCommand) {
        return TruncateTableCommand$.MODULE$.unapply(truncateTableCommand);
    }

    public static Function1<Tuple2<TableIdentifier, Option<Map<String, String>>>, TruncateTableCommand> tupled() {
        return TruncateTableCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<Option<Map<String, String>>, TruncateTableCommand>> curried() {
        return TruncateTableCommand$.MODULE$.curried();
    }

    @Override
    public final Seq<LogicalPlan> children() {
        return LeafLike.children$((LeafLike)this);
    }

    public final TreeNode mapChildren(Function1 f) {
        return LeafLike.mapChildren$((LeafLike)this, (Function1)f);
    }

    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return LeafLike.withNewChildrenInternal$((LeafLike)this, (IndexedSeq)newChildren);
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        TruncateTableCommand truncateTableCommand = this;
        synchronized (truncateTableCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        if (!this.bitmap$0) {
            return this.metrics$lzycompute();
        }
        return this.metrics;
    }

    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    public final void org$apache$spark$sql$catalyst$plans$logical$Command$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public TableIdentifier tableName() {
        return this.tableName;
    }

    public Option<Map<String, String>> partitionSpec() {
        return this.partitionSpec;
    }

    @Override
    public Seq<Row> run(SparkSession spark) {
        Seq seq;
        Seq partCols;
        SessionCatalog catalog = spark.sessionState().catalog();
        CatalogTable table = catalog.getTableMetadata(this.tableName());
        String tableIdentWithDB = table.identifier().quotedString();
        CatalogTableType catalogTableType = table.tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.EXTERNAL();
        if (!(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null)) {
            throw QueryCompilationErrors$.MODULE$.truncateTableOnExternalTablesError(tableIdentWithDB);
        }
        if (table.partitionColumnNames().isEmpty() && this.partitionSpec().isDefined()) {
            throw QueryCompilationErrors$.MODULE$.truncateTablePartitionNotSupportedForNotPartitionedTablesError(tableIdentWithDB);
        }
        if (this.partitionSpec().isDefined()) {
            DDLUtils$.MODULE$.verifyPartitionProviderIsHive(spark, table, "TRUNCATE TABLE ... PARTITION");
        }
        if ((partCols = table.partitionColumnNames()).isEmpty()) {
            seq = (Seq)new .colon.colon((Object)table.storage().locationUri(), (List)Nil$.MODULE$);
        } else {
            Option normalizedSpec = this.partitionSpec().map((Function1 & Serializable & scala.Serializable)spec -> PartitioningUtils$.MODULE$.normalizePartitionSpec(spec, table.partitionSchema(), table.identifier().quotedString(), spark.sessionState().conf().resolver()));
            Seq partLocations = (Seq)catalog.listPartitions(table.identifier(), normalizedSpec).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.storage().locationUri(), Seq$.MODULE$.canBuildFrom());
            this.partitionSpec().withFilter((Function1 & Serializable & scala.Serializable)spec -> BoxesRunTime.boxToBoolean((boolean)TruncateTableCommand.$anonfun$run$7(partLocations, partCols, spec))).foreach((Function1 & Serializable & scala.Serializable)spec -> {
                throw QueryCompilationErrors$.MODULE$.noSuchPartitionError(table.database(), table.identifier().table(), spec);
            });
            seq = partLocations;
        }
        Seq locations = seq;
        Configuration hadoopConf = spark.sessionState().newHadoopConf();
        boolean ignorePermissionAcl = this.conf().truncateTableIgnorePermissionAcl();
        locations.foreach((Function1 & Serializable & scala.Serializable)location -> {
            TruncateTableCommand.$anonfun$run$9(this, hadoopConf, ignorePermissionAcl, tableIdentWithDB, location);
            return BoxedUnit.UNIT;
        });
        spark.catalog().refreshTable(tableIdentWithDB);
        CommandUtils$.MODULE$.updateTableStats(spark, table);
        return (Seq)Nil$.MODULE$;
    }

    private AclEntry newAclEntry(AclEntryScope scope, AclEntryType aclType, FsAction permission) {
        return new AclEntry.Builder().setScope(scope).setType(aclType).setPermission(permission).build();
    }

    public TruncateTableCommand copy(TableIdentifier tableName, Option<Map<String, String>> partitionSpec) {
        return new TruncateTableCommand(tableName, partitionSpec);
    }

    public TableIdentifier copy$default$1() {
        return this.tableName();
    }

    public Option<Map<String, String>> copy$default$2() {
        return this.partitionSpec();
    }

    public String productPrefix() {
        return "TruncateTableCommand";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.tableName();
            }
            case 1: {
                return this.partitionSpec();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TruncateTableCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TruncateTableCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        TruncateTableCommand truncateTableCommand = (TruncateTableCommand)x$1;
        TableIdentifier tableIdentifier = this.tableName();
        TableIdentifier tableIdentifier2 = truncateTableCommand.tableName();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        Option<Map<String, String>> option = this.partitionSpec();
        Option<Map<String, String>> option2 = truncateTableCommand.partitionSpec();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!truncateTableCommand.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$run$7(Seq partLocations$1, Seq partCols$1, Map spec) {
        return partLocations$1.isEmpty() && spec.size() == partCols$1.length();
    }

    public static final /* synthetic */ void $anonfun$run$10(FileSystem fs$1, Path path$1, FsPermission permission) {
        try {
            fs$1.setPermission(path$1, permission);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                throw QueryExecutionErrors$.MODULE$.failToSetOriginalPermissionBackError(permission, path$1, e);
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ boolean $anonfun$run$12(AclEntry x$4) {
        return x$4.getName() != null;
    }

    public static final /* synthetic */ boolean $anonfun$run$13(TruncateTableCommand $this, java.util.List aclEntries$1, FsPermission permission) {
        aclEntries$1.add($this.newAclEntry(AclEntryScope.ACCESS, AclEntryType.USER, permission.getUserAction()));
        aclEntries$1.add($this.newAclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, permission.getGroupAction()));
        return aclEntries$1.add($this.newAclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, permission.getOtherAction()));
    }

    public static final /* synthetic */ void $anonfun$run$11(TruncateTableCommand $this, ObjectRef optPermission$1, FileSystem fs$1, Path path$1, java.util.List acls) {
        java.util.List aclEntries = (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(acls).asScala()).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TruncateTableCommand.$anonfun$run$12(x$4)))).asJava();
        ((Option)optPermission$1.elem).map((Function1 & Serializable & scala.Serializable)permission -> BoxesRunTime.boxToBoolean((boolean)TruncateTableCommand.$anonfun$run$13($this, aclEntries, permission)));
        try {
            fs$1.setAcl(path$1, aclEntries);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                throw QueryExecutionErrors$.MODULE$.failToSetOriginalACLBackError(aclEntries.toString(), path$1, e);
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ void $anonfun$run$9(TruncateTableCommand $this, Configuration hadoopConf$1, boolean ignorePermissionAcl$1, String tableIdentWithDB$2, Option location) {
        if (location.isDefined()) {
            Path path = new Path((URI)location.get());
            try {
                FileSystem fs = path.getFileSystem(hadoopConf$1);
                ObjectRef optPermission = ObjectRef.create((Object)None$.MODULE$);
                None$ optAcls = None$.MODULE$;
                if (!ignorePermissionAcl$1) {
                    try {
                        FileStatus fileStatus = fs.getFileStatus(path);
                        optPermission.elem = new Some((Object)fileStatus.getPermission());
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                        if (!option.isEmpty()) {
                        }
                        throw throwable;
                    }
                    try {
                        optAcls = new Some((Object)fs.getAclStatus(path).getEntries());
                    }
                    catch (Throwable throwable) {
                        Throwable throwable3 = throwable;
                        Option option = NonFatal$.MODULE$.unapply(throwable3);
                        if (!option.isEmpty()) {
                        }
                        throw throwable;
                    }
                }
                fs.delete(path, true);
                fs.mkdirs(path);
                if (!ignorePermissionAcl$1) {
                    ((Option)optPermission.elem).foreach((Function1 & Serializable & scala.Serializable)permission -> {
                        TruncateTableCommand.$anonfun$run$10(fs, path, permission);
                        return BoxedUnit.UNIT;
                    });
                    optAcls.foreach((Function1 & Serializable & scala.Serializable)acls -> {
                        TruncateTableCommand.$anonfun$run$11($this, optPermission, fs, path, acls);
                        return BoxedUnit.UNIT;
                    });
                }
            }
            catch (Throwable throwable) {
                Throwable throwable4 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable4);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    throw QueryCompilationErrors$.MODULE$.failToTruncateTableWhenRemovingDataError(tableIdentWithDB$2, path, e);
                }
                throw throwable;
            }
            return;
        }
    }

    public TruncateTableCommand(TableIdentifier tableName, Option<Map<String, String>> partitionSpec) {
        this.tableName = tableName;
        this.partitionSpec = partitionSpec;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
        LeafLike.$init$((LeafLike)this);
    }
}

