/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.Serializable;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;
import scala.runtime.RichLong$;

public final class PartitionedFileUtil$ {
    public static PartitionedFileUtil$ MODULE$;

    static {
        new PartitionedFileUtil$();
    }

    public Seq<PartitionedFile> splitFiles(SparkSession sparkSession, FileStatus file, Path filePath, boolean isSplitable, long maxSplitBytes, InternalRow partitionValues) {
        if (isSplitable) {
            return (Seq)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)file.getLen())).by((Object)BoxesRunTime.boxToLong((long)maxSplitBytes)).map((Function1 & Serializable & scala.Serializable)offset -> PartitionedFileUtil$.$anonfun$splitFiles$1(file, maxSplitBytes, partitionValues, filePath, BoxesRunTime.unboxToLong((Object)offset)), IndexedSeq$.MODULE$.canBuildFrom());
        }
        return (Seq)new .colon.colon((Object)this.getPartitionedFile(file, filePath, partitionValues), (List)Nil$.MODULE$);
    }

    public PartitionedFile getPartitionedFile(FileStatus file, Path filePath, InternalRow partitionValues) {
        String[] hosts = this.getBlockHosts(this.getBlockLocations(file), 0L, file.getLen());
        return new PartitionedFile(partitionValues, filePath.toUri().toString(), 0L, file.getLen(), hosts, file.getModificationTime(), file.getLen());
    }

    private BlockLocation[] getBlockLocations(FileStatus file) {
        FileStatus fileStatus = file;
        if (fileStatus instanceof LocatedFileStatus) {
            LocatedFileStatus locatedFileStatus = (LocatedFileStatus)fileStatus;
            return locatedFileStatus.getBlockLocations();
        }
        return (BlockLocation[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(BlockLocation.class));
    }

    private String[] getBlockHosts(BlockLocation[] blockLocations, long offset, long length) {
        Tuple2[] candidates = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blockLocations)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            BlockLocation blockLocation = x0$1;
            if (blockLocation.getOffset() <= offset && offset < blockLocation.getOffset() + blockLocation.getLength()) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)blockLocation.getHosts()), (Object)BoxesRunTime.boxToLong((long)RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(blockLocation.getOffset() + blockLocation.getLength() - offset), length)));
            }
            if (blockLocation.getOffset() < offset + length && offset + length < blockLocation.getOffset() + blockLocation.getLength()) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)blockLocation.getHosts()), (Object)BoxesRunTime.boxToLong((long)(offset + length - blockLocation.getOffset())));
            }
            if (offset <= blockLocation.getOffset() && blockLocation.getOffset() + blockLocation.getLength() <= offset + length) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)blockLocation.getHosts()), (Object)BoxesRunTime.boxToLong((long)blockLocation.getLength()));
            }
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)blockLocation.getHosts()), (Object)BoxesRunTime.boxToLong((long)0L));
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)PartitionedFileUtil$.$anonfun$getBlockHosts$2(x0$2)));
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])candidates)).isEmpty()) {
            return (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
        }
        Tuple2 tuple2 = (Tuple2)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])candidates)).maxBy((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToLong((long)PartitionedFileUtil$.$anonfun$getBlockHosts$3(x0$3)), (Ordering)Ordering.Long$.MODULE$);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String[] hosts = (String[])tuple2._1();
        String[] hosts2 = hosts;
        return hosts2;
    }

    public static final /* synthetic */ PartitionedFile $anonfun$splitFiles$1(FileStatus file$1, long maxSplitBytes$1, InternalRow partitionValues$1, Path filePath$1, long offset) {
        long remaining = file$1.getLen() - offset;
        long size = remaining > maxSplitBytes$1 ? maxSplitBytes$1 : remaining;
        String[] hosts = MODULE$.getBlockHosts(MODULE$.getBlockLocations(file$1), offset, size);
        return new PartitionedFile(partitionValues$1, filePath$1.toUri().toString(), offset, size, hosts, file$1.getModificationTime(), file$1.getLen());
    }

    public static final /* synthetic */ boolean $anonfun$getBlockHosts$2(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            long size = tuple2._2$mcJ$sp();
            return size > 0L;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ long $anonfun$getBlockHosts$3(Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            long size = tuple2._2$mcJ$sp();
            return size;
        }
        throw new MatchError((Object)tuple2);
    }

    private PartitionedFileUtil$() {
        MODULE$ = this;
    }
}

