/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001E2Qa\u0001\u0003\u0002\u0002EAQA\b\u0001\u0005\u0002}AQA\t\u0001\u0007\u0002\r\u0012!d\u00115fG.\u0004x.\u001b8u\r&dW-T1oC\u001e,'\u000fV3tiNT!!\u0002\u0004\u0002\u0013M$(/Z1nS:<'BA\u0004\t\u0003%)\u00070Z2vi&|gN\u0003\u0002\n\u0015\u0005\u00191/\u001d7\u000b\u0005-a\u0011!B:qCJ\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001%Y\u0001\"a\u0005\u000b\u000e\u0003)I!!\u0006\u0006\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\t9B$D\u0001\u0019\u0015\tI\"$A\u0003qY\u0006t7O\u0003\u0002\u001c\u0011\u0005A1-\u0019;bYf\u001cH/\u0003\u0002\u001e1\tI1+\u0015'IK2\u0004XM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0001\u0002\"!\t\u0001\u000e\u0003\u0011\tQb\u0019:fCR,W*\u00198bO\u0016\u0014HC\u0001\u0013(!\t\tS%\u0003\u0002'\t\t)2\t[3dWB|\u0017N\u001c;GS2,W*\u00198bO\u0016\u0014\b\"\u0002\u0015\u0003\u0001\u0004I\u0013\u0001\u00029bi\"\u0004\"AK\u0018\u000e\u0003-R!\u0001L\u0017\u0002\u0005\u0019\u001c(B\u0001\u0018\r\u0003\u0019A\u0017\rZ8pa&\u0011\u0001g\u000b\u0002\u0005!\u0006$\b\u000e")
public abstract class CheckpointFileManagerTests
extends SparkFunSuite
implements SQLHelper {
    private String sparkHome;
    private volatile boolean bitmap$0;

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$((SQLHelper)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    private String sparkHome$lzycompute() {
        CheckpointFileManagerTests checkpointFileManagerTests = this;
        synchronized (checkpointFileManagerTests) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$((SQLHelper)this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    public String sparkHome() {
        if (!this.bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return this.sparkHome;
    }

    public abstract CheckpointFileManager createManager(Path var1);

    public static final /* synthetic */ boolean $anonfun$new$3(FileStatus x$1) {
        String string = x$1.getPath().getName();
        String string2 = "dir";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$8(String n) {
        return n.startsWith(".") && n.endsWith(".crc");
    }

    public static final /* synthetic */ void $anonfun$new$2(CheckpointFileManagerTests $this, File p2) {
        Path basePath = new Path(p2.getAbsolutePath());
        CheckpointFileManager fm = $this.createManager(basePath);
        Path dir = new Path(new StringBuilder(21).append(basePath).append("/dir/subdir/subsubdir").toString());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(fm.exists(dir), "fm.exists(dir)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointFileManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
        fm.mkdirs(dir);
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(fm.exists(dir), "fm.exists(dir)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointFileManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
        fm.mkdirs(dir);
        PathFilter acceptAllFilter = new PathFilter(null){

            public boolean accept(Path path) {
                return true;
            }
        };
        PathFilter rejectAllFilter = new PathFilter(null){

            public boolean accept(Path path) {
                return false;
            }
        };
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fm.list(basePath, acceptAllFilter))).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CheckpointFileManagerTests.$anonfun$new$3(x$1))), "scala.Predef.refArrayOps[org.apache.hadoop.fs.FileStatus](fm.list(basePath, acceptAllFilter)).exists(((x$1: org.apache.hadoop.fs.FileStatus) => x$1.getPath().getName().==(\"dir\")))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointFileManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)fm.list(basePath, rejectAllFilter).length));
        int $org_scalatest_assert_macro_right = 0;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointFileManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
        ObjectRef path = ObjectRef.create((Object)new Path(new StringBuilder(5).append(dir).append("/file").toString()));
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(fm.exists((Path)path.elem), "fm.exists(path)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointFileManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
        fm.createAtomic((Path)path.elem, false).cancel();
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(fm.exists((Path)path.elem), "fm.exists(path)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointFileManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        fm.createAtomic((Path)path.elem, false).close();
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(fm.exists((Path)path.elem), "fm.exists(path)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointFileManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
        package$.MODULE$.quietly((Function0 & Serializable & scala.Serializable)() -> (IOException)$this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> fm.createAtomic((Path)path$1.elem, false).close(), ClassTag$.MODULE$.apply(IOException.class), new Position("CheckpointFileManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66)));
        path.elem = new Path(new StringBuilder(6).append(dir).append("/file2").toString());
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(fm.exists((Path)path.elem), "fm.exists(path)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointFileManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
        fm.createAtomic((Path)path.elem, true).cancel();
        Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(fm.exists((Path)path.elem), "fm.exists(path)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointFileManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
        fm.createAtomic((Path)path.elem, true).close();
        Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(fm.exists((Path)path.elem), "fm.exists(path)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointFileManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
        fm.createAtomic((Path)path.elem, true).close();
        Seq fileNames = (Seq)((TraversableLike)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new File(((Path)path.elem).getParent().toString()).listFiles())).toSeq().filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)p.isFile()))).map((Function1 & Serializable & scala.Serializable)p -> p.getName(), Seq$.MODULE$.canBuildFrom());
        Seq crcFiles = (Seq)fileNames.filter((Function1 & Serializable & scala.Serializable)n -> BoxesRunTime.boxToBoolean((boolean)CheckpointFileManagerTests.$anonfun$new$8(n)));
        Seq originFileNamesForExistingCrcFiles = (Seq)crcFiles.map((Function1 & Serializable & scala.Serializable)name -> name.substring(1, name.length() - 4), Seq$.MODULE$.canBuildFrom());
        Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(originFileNamesForExistingCrcFiles.toSet().subsetOf((GenSet)fileNames.toSet()), "originFileNamesForExistingCrcFiles.toSet[String].subsetOf(fileNames.toSet[String])", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)new StringBuilder(103).append("Some of origin files for crc files don't exist - crc files: ").append(crcFiles).append(" / ").append("expected origin files: ").append(originFileNamesForExistingCrcFiles).append(" / actual files: ").append(fileNames).toString(), Prettifier$.MODULE$.default(), new Position("CheckpointFileManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
        fm.open((Path)path.elem).close();
        fm.delete((Path)path.elem);
        Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(fm.exists((Path)path.elem), "fm.exists(path)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointFileManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
        $this.intercept((Function0 & Serializable & scala.Serializable)() -> fm.open((Path)path$1.elem), ClassTag$.MODULE$.apply(IOException.class), new Position("CheckpointFileManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
        fm.delete((Path)path.elem);
    }

    public CheckpointFileManagerTests() {
        SQLHelper.$init$((SQLHelper)this);
        this.test("mkdirs, list, createAtomic, open, delete, exists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)p -> {
            CheckpointFileManagerTests.$anonfun$new$2(this, p);
            return BoxedUnit.UNIT;
        }), new Position("CheckpointFileManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
    }
}

