/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.history;

import java.io.Serializable;
import java.util.Properties;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.scheduler.JobResult;
import org.apache.spark.scheduler.JobSucceeded$;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerApplicationStart;
import org.apache.spark.scheduler.SparkListenerApplicationStart$;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.scheduler.SparkListenerJobEnd;
import org.apache.spark.scheduler.SparkListenerLogStart;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.SparkPlanInfo;
import org.apache.spark.sql.execution.history.SQLEventFilterBuilder;
import org.apache.spark.sql.execution.ui.SparkListenerSQLExecutionEnd;
import org.apache.spark.sql.execution.ui.SparkListenerSQLExecutionStart;
import org.apache.spark.status.ListenerEventsTestHelper;
import org.apache.spark.status.ListenerEventsTestHelper$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0001\t2Aa\u0001\u0003\u0001#!)a\u0003\u0001C\u0001/!)!\u0004\u0001C)7\tQ2+\u0015'Fm\u0016tGOR5mi\u0016\u0014()^5mI\u0016\u00148+^5uK*\u0011QAB\u0001\bQ&\u001cHo\u001c:z\u0015\t9\u0001\"A\u0005fq\u0016\u001cW\u000f^5p]*\u0011\u0011BC\u0001\u0004gFd'BA\u0006\r\u0003\u0015\u0019\b/\u0019:l\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0005\t\u0003'Qi\u0011AC\u0005\u0003+)\u0011Qb\u00159be.4UO\\*vSR,\u0017A\u0002\u001fj]&$h\bF\u0001\u0019!\tI\u0002!D\u0001\u0005\u0003)\u0011WMZ8sK\u0016\u000b7\r\u001b\u000b\u00029A\u0011Q\u0004I\u0007\u0002=)\tq$A\u0003tG\u0006d\u0017-\u0003\u0002\"=\t!QK\\5u\u0001")
public class SQLEventFilterBuilderSuite
extends SparkFunSuite {
    public void beforeEach() {
        ListenerEventsTestHelper$.MODULE$.reset();
    }

    public SQLEventFilterBuilderSuite() {
        this.test("track live SQL executions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            LongRef time = LongRef.create((long)0L);
            SQLEventFilterBuilder listener = new SQLEventFilterBuilder();
            listener.onOtherEvent((SparkListenerEvent)new SparkListenerLogStart("TestSparkVersion"));
            ++time.elem;
            listener.onApplicationStart(new SparkListenerApplicationStart("name", (Option)new Some((Object)"id"), time.elem, "user", (Option)new Some((Object)"attempt"), (Option)None$.MODULE$, SparkListenerApplicationStart$.MODULE$.apply$default$7()));
            ++time.elem;
            String[] execIds = (String[])((Object[])new String[]{"1", "2"});
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])execIds)).foreach((Function1 & Serializable & scala.Serializable)id -> {
                listener.onExecutorAdded(ListenerEventsTestHelper$.MODULE$.createExecutorAddedEvent(id, time.elem));
                return BoxedUnit.UNIT;
            });
            listener.onOtherEvent((SparkListenerEvent)new SparkListenerSQLExecutionStart(1L, "desc1", "details1", "plan", new SparkPlanInfo("node", "str", (Seq)Nil$.MODULE$, Predef$.MODULE$.Map().empty(), (Seq)Nil$.MODULE$), time.elem, Predef$.MODULE$.Map().empty()));
            ++time.elem;
            Properties jobProp = ListenerEventsTestHelper$.MODULE$.createJobProps();
            Properties jobPropWithSqlExecution = new Properties(jobProp);
            jobPropWithSqlExecution.setProperty(SQLExecution$.MODULE$.EXECUTION_ID_KEY(), "1");
            ListenerEventsTestHelper.JobInfo jobInfoForJob1 = ListenerEventsTestHelper$.MODULE$.pushJobEventsWithoutJobEnd((SparkListener)listener, 1, jobPropWithSqlExecution, execIds, time.elem);
            listener.onJobEnd(new SparkListenerJobEnd(1, time.elem, (JobResult)JobSucceeded$.MODULE$));
            ListenerEventsTestHelper.JobInfo jobInfoForJob2 = ListenerEventsTestHelper$.MODULE$.pushJobEventsWithoutJobEnd((SparkListener)listener, 2, jobPropWithSqlExecution, execIds, time.elem);
            listener.onJobEnd(new SparkListenerJobEnd(2, time.elem, (JobResult)JobSucceeded$.MODULE$));
            ListenerEventsTestHelper$.MODULE$.pushJobEventsWithoutJobEnd((SparkListener)listener, 3, jobProp, execIds, time.elem);
            listener.onJobEnd(new SparkListenerJobEnd(3, time.elem, (JobResult)JobSucceeded$.MODULE$));
            ListenerEventsTestHelper$.MODULE$.pushJobEventsWithoutJobEnd((SparkListener)listener, 4, jobProp, execIds, time.elem);
            listener.onJobEnd(new SparkListenerJobEnd(4, time.elem, (JobResult)JobSucceeded$.MODULE$));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(listener.liveSQLExecutions());
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLEventFilterBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(listener.liveJobs());
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLEventFilterBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(listener.liveStages());
            Set $org_scalatest_assert_macro_right3 = ((TraversableOnce)jobInfoForJob1.stageIds().$plus$plus((GenTraversableOnce)jobInfoForJob2.stageIds(), Seq$.MODULE$.canBuildFrom())).toSet();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLEventFilterBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(listener.liveTasks());
            Set $org_scalatest_assert_macro_right4 = ((TraversableOnce)((TraversableLike)jobInfoForJob1.stageToTaskIds().values().flatten((Function1)Predef$.MODULE$.$conforms())).$plus$plus((GenTraversableOnce)jobInfoForJob2.stageToTaskIds().values().flatten((Function1)Predef$.MODULE$.$conforms()), Iterable$.MODULE$.canBuildFrom())).toSet();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLEventFilterBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(listener.liveRDDs());
            Set $org_scalatest_assert_macro_right5 = ((TraversableOnce)((TraversableLike)jobInfoForJob1.stageToRddIds().values().flatten((Function1)Predef$.MODULE$.$conforms())).$plus$plus((GenTraversableOnce)jobInfoForJob2.stageToRddIds().values().flatten((Function1)Predef$.MODULE$.$conforms()), Iterable$.MODULE$.canBuildFrom())).toSet();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLEventFilterBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
            listener.onOtherEvent((SparkListenerEvent)new SparkListenerSQLExecutionEnd(1L, 0L));
            Set $org_scalatest_assert_macro_left6 = listener.liveSQLExecutions();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left6, "isEmpty", $org_scalatest_assert_macro_left6.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLEventFilterBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
            Set $org_scalatest_assert_macro_left7 = listener.liveJobs();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left7, "isEmpty", $org_scalatest_assert_macro_left7.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLEventFilterBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
            Set $org_scalatest_assert_macro_left8 = listener.liveStages();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left8, "isEmpty", $org_scalatest_assert_macro_left8.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLEventFilterBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
            Set $org_scalatest_assert_macro_left9 = listener.liveTasks();
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left9, "isEmpty", $org_scalatest_assert_macro_left9.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLEventFilterBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
            Set $org_scalatest_assert_macro_left10 = listener.liveRDDs();
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left10, "isEmpty", $org_scalatest_assert_macro_left10.isEmpty(), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLEventFilterBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        }, new Position("SQLEventFilterBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 35));
    }
}

