/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.benchmark;

import java.io.Serializable;
import org.apache.spark.benchmark.Benchmark;
import org.apache.spark.benchmark.Benchmark$;
import org.apache.spark.benchmark.BenchmarkBase;
import org.apache.spark.sql.execution.benchmark.ByteArrayBenchmark;
import org.apache.spark.unsafe.array.ByteArrayMethods;
import org.apache.spark.unsafe.types.ByteArray;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

public final class ByteArrayBenchmark$
extends BenchmarkBase {
    public static ByteArrayBenchmark$ MODULE$;
    private final String chars;
    private final Random randomChar;

    static {
        new ByteArrayBenchmark$();
    }

    private String chars() {
        return this.chars;
    }

    private Random randomChar() {
        return this.randomChar;
    }

    public byte[] randomBytes(int min, int max) {
        int len = this.randomChar().nextInt(max - min) + min;
        byte[] bytes = new byte[len];
        for (int i = 0; i < len; ++i) {
            bytes[i] = (byte)this.chars().charAt(this.randomChar().nextInt(this.chars().length()));
        }
        return bytes;
    }

    public void byteArrayComparisons(long iters) {
        int count = 16000;
        byte[][] dataTiny = (byte[][])((TraversableOnce)Seq$.MODULE$.fill(count, (Function0 & Serializable & scala.Serializable)() -> MODULE$.randomBytes(2, 7))).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        byte[][] dataSmall = (byte[][])((TraversableOnce)Seq$.MODULE$.fill(count, (Function0 & Serializable & scala.Serializable)() -> MODULE$.randomBytes(8, 16))).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        byte[][] dataMedium = (byte[][])((TraversableOnce)Seq$.MODULE$.fill(count, (Function0 & Serializable & scala.Serializable)() -> MODULE$.randomBytes(16, 32))).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        byte[][] dataLarge = (byte[][])((TraversableOnce)Seq$.MODULE$.fill(count, (Function0 & Serializable & scala.Serializable)() -> MODULE$.randomBytes(512, 1024))).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        byte[][] dataLargeSlow = (byte[][])((TraversableOnce)Seq$.MODULE$.fill(count, (Function0 & Serializable & scala.Serializable)() -> (byte[])Array$.MODULE$.tabulate(512, (Function1 & Serializable & scala.Serializable)i -> BoxesRunTime.boxToByte((byte)ByteArrayBenchmark$.$anonfun$byteArrayComparisons$6(BoxesRunTime.unboxToInt((Object)i))), ClassTag$.MODULE$.Byte()))).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        String x$1 = "Byte Array compareTo";
        long x$2 = (long)count * iters;
        int x$3 = 25;
        Option x$4 = this.output();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$3, x$5, x$6, x$7, x$4);
        benchmark.addCase("2-7 byte", benchmark.addCase$default$2(), ByteArrayBenchmark$.compareBinary$1(dataTiny, iters, count));
        benchmark.addCase("8-16 byte", benchmark.addCase$default$2(), ByteArrayBenchmark$.compareBinary$1(dataSmall, iters, count));
        benchmark.addCase("16-32 byte", benchmark.addCase$default$2(), ByteArrayBenchmark$.compareBinary$1(dataMedium, iters, count));
        benchmark.addCase("512-1024 byte", benchmark.addCase$default$2(), ByteArrayBenchmark$.compareBinary$1(dataLarge, iters, count));
        benchmark.addCase("512 byte slow", benchmark.addCase$default$2(), ByteArrayBenchmark$.compareBinary$1(dataLargeSlow, iters, count));
        benchmark.addCase("2-7 byte", benchmark.addCase$default$2(), ByteArrayBenchmark$.compareBinary$1(dataTiny, iters, count));
        benchmark.run();
    }

    public void byteArrayEquals(long iters) {
        int count = 16000;
        Random rand = new Random(0);
        ByteArrayBenchmark.BinaryEqualInfo[] inputs = (ByteArrayBenchmark.BinaryEqualInfo[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), count).map((Function1 & Serializable & scala.Serializable)x$3 -> ByteArrayBenchmark$.$anonfun$byteArrayEquals$4(rand, BoxesRunTime.unboxToInt((Object)x$3)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ByteArrayBenchmark.BinaryEqualInfo.class));
        String x$1 = "Byte Array equals";
        long x$2 = (long)count * iters;
        int x$32 = 25;
        Option x$4 = this.output();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$32, x$5, x$6, x$7, x$4);
        benchmark.addCase("Byte Array equals", benchmark.addCase$default$2(), ByteArrayBenchmark$.binaryEquals$1(inputs, iters));
        benchmark.run();
    }

    public void runBenchmarkSuite(String[] mainArgs) {
        this.runBenchmark("byte array comparisons", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.byteArrayComparisons(4096L));
        this.runBenchmark("byte array equals", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.byteArrayEquals(10000L));
    }

    public static final /* synthetic */ byte $anonfun$byteArrayComparisons$6(int i) {
        if (i < 511) {
            return (byte)0;
        }
        return (byte)1;
    }

    private static final Function1 compareBinary$1(byte[][] data, long iters$1, int count$1) {
        return (JFunction1.mcVI.sp & Serializable & scala.Serializable)x$1 -> {
            LongRef sum = LongRef.create((long)0L);
            new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)iters$1)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)_ -> {
                for (int i = 0; i < count$1; ++i) {
                    sum$1.elem += (long)ByteArray.compareBinary((byte[])data[i], (byte[])data[(i + 1) % count$1]);
                }
            });
        };
    }

    private static final Function1 binaryEquals$1(ByteArrayBenchmark.BinaryEqualInfo[] inputs, long iters$2) {
        return (JFunction1.mcVI.sp & Serializable & scala.Serializable)x$2 -> {
            BooleanRef res = BooleanRef.create((boolean)false);
            new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)iters$2)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)_ -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inputs)).foreach((Function1 & Serializable & scala.Serializable)input -> {
                res.elem = ByteArrayMethods.arrayEquals((Object)input.s1().getBaseObject(), (long)input.s1().getBaseOffset(), (Object)input.s2().getBaseObject(), (long)(input.s2().getBaseOffset() + (long)input.deltaOffset()), (long)input.len());
                return BoxedUnit.UNIT;
            }));
        };
    }

    public static final /* synthetic */ ByteArrayBenchmark.BinaryEqualInfo $anonfun$byteArrayEquals$4(Random rand$1, int x$3) {
        UTF8String s1 = UTF8String.fromBytes((byte[])MODULE$.randomBytes(1, 16));
        UTF8String s2 = UTF8String.fromBytes((byte[])MODULE$.randomBytes(1, 16));
        int len = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(s1.numBytes()), s2.numBytes());
        int deltaOffset = rand$1.nextInt(len);
        return new ByteArrayBenchmark.BinaryEqualInfo(s1, s2, deltaOffset, len);
    }

    private ByteArrayBenchmark$() {
        MODULE$ = this;
        this.chars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        this.randomChar = new Random(0);
    }
}

