/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector;

import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.metric.CustomTaskMetric;
import org.apache.spark.sql.connector.write.DataWriter;
import org.apache.spark.sql.connector.write.WriterCommitMessage;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001Q3AAC\u0006\u0001-!A1\u0006\u0001B\u0001B\u0003%A\u0006\u0003\u00054\u0001\t\u0005\t\u0015!\u00035\u0011\u00159\u0004\u0001\"\u00019\u0011\u001di\u0004A1A\u0005\nyBaA\u0011\u0001!\u0002\u0013y\u0004\"\u0002\u0012\u0001\t\u0003\u001a\u0005\"\u0002'\u0001\t\u0003j\u0005\"B)\u0001\t\u0003\u0012\u0006\"B*\u0001\t\u0003\u0012&!D\"T-\u0012\u000bG/Y,sSR,'O\u0003\u0002\r\u001b\u0005I1m\u001c8oK\u000e$xN\u001d\u0006\u0003\u001d=\t1a]9m\u0015\t\u0001\u0012#A\u0003ta\u0006\u00148N\u0003\u0002\u0013'\u00051\u0011\r]1dQ\u0016T\u0011\u0001F\u0001\u0004_J<7\u0001A\n\u0004\u0001]y\u0002C\u0001\r\u001e\u001b\u0005I\"B\u0001\u000e\u001c\u0003\u0011a\u0017M\\4\u000b\u0003q\tAA[1wC&\u0011a$\u0007\u0002\u0007\u001f\nTWm\u0019;\u0011\u0007\u0001\u001aS%D\u0001\"\u0015\t\u00113\"A\u0003xe&$X-\u0003\u0002%C\tQA)\u0019;b/JLG/\u001a:\u0011\u0005\u0019JS\"A\u0014\u000b\u0005!j\u0011\u0001C2bi\u0006d\u0017p\u001d;\n\u0005):#aC%oi\u0016\u0014h.\u00197S_^\f!AZ:\u0011\u00055\nT\"\u0001\u0018\u000b\u0005-z#B\u0001\u0019\u0012\u0003\u0019A\u0017\rZ8pa&\u0011!G\f\u0002\u000b\r&dWmU=ti\u0016l\u0017\u0001\u00024jY\u0016\u0004\"!L\u001b\n\u0005Yr#\u0001\u0002)bi\"\fa\u0001P5oSRtDcA\u001d<yA\u0011!\bA\u0007\u0002\u0017!)1f\u0001a\u0001Y!)1g\u0001a\u0001i\u0005\u0019q.\u001e;\u0016\u0003}\u0002\"!\f!\n\u0005\u0005s#A\u0005$T\t\u0006$\u0018mT;uaV$8\u000b\u001e:fC6\fAa\\;uAQ\u0011AI\u0013\t\u0003\u000b\"k\u0011A\u0012\u0006\u0002\u000f\u0006)1oY1mC&\u0011\u0011J\u0012\u0002\u0005+:LG\u000fC\u0003L\r\u0001\u0007Q%\u0001\u0004sK\u000e|'\u000fZ\u0001\u0007G>lW.\u001b;\u0015\u00039\u0003\"\u0001I(\n\u0005A\u000b#aE,sSR,'oQ8n[&$X*Z:tC\u001e,\u0017!B1c_J$H#\u0001#\u0002\u000b\rdwn]3")
public class CSVDataWriter
implements DataWriter<InternalRow> {
    private final FileSystem fs;
    private final Path file;
    private final FSDataOutputStream out;

    public CustomTaskMetric[] currentMetricsValues() {
        return super.currentMetricsValues();
    }

    private FSDataOutputStream out() {
        return this.out;
    }

    public void write(InternalRow record) {
        this.out().writeBytes(new StringBuilder(2).append(record.getInt(0)).append(",").append(record.getInt(1)).append("\n").toString());
    }

    public WriterCommitMessage commit() {
        this.out().close();
        return null;
    }

    public void abort() {
        try {
            this.out().close();
        }
        finally {
            this.fs.delete(this.file, false);
        }
    }

    public void close() {
    }

    public CSVDataWriter(FileSystem fs, Path file) {
        this.fs = fs;
        this.file = file;
        this.out = fs.create(file);
    }
}

