/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.continuous;

import java.io.Serializable;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.streaming.ContinuousPartitionReaderFactory;
import org.apache.spark.sql.connector.read.streaming.ContinuousStream;
import org.apache.spark.sql.connector.read.streaming.Offset;
import org.apache.spark.sql.connector.read.streaming.PartitionOffset;
import org.apache.spark.sql.execution.streaming.RateStreamOffset;
import org.apache.spark.sql.execution.streaming.ValueRunTimeMsPair;
import org.apache.spark.sql.execution.streaming.continuous.RateStreamContinuousInputPartition;
import org.apache.spark.sql.execution.streaming.continuous.RateStreamContinuousReaderFactory$;
import org.apache.spark.sql.execution.streaming.continuous.RateStreamPartitionOffset;
import org.json4s.DefaultFormats;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.jackson.Serialization$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-b\u0001\u0002\n\u0014\u0001\tB\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\tw\u0001\u0011\t\u0011)A\u0005y!)q\b\u0001C\u0001\u0001\"9Q\t\u0001b\u0001\n\u00071\u0005BB'\u0001A\u0003%q\tC\u0004O\u0001\t\u0007I\u0011A(\t\rA\u0003\u0001\u0015!\u00036\u0011\u001d\t\u0006A1A\u0005\u0002ICaA\u0016\u0001!\u0002\u0013\u0019\u0006\"B,\u0001\t\u0003B\u0006\"\u00023\u0001\t\u0003*\u0007\"B:\u0001\t\u0003\"\b\"B;\u0001\t\u00032\b\"\u0002@\u0001\t\u0003z\bbBA\u0004\u0001\u0011\u0005\u0013\u0011\u0002\u0005\b\u0003+\u0001A\u0011IA\f\u0011\u001d\tI\u0002\u0001C\u0005\u00037\u0011!DU1uKN#(/Z1n\u0007>tG/\u001b8v_V\u001c8\u000b\u001e:fC6T!\u0001F\u000b\u0002\u0015\r|g\u000e^5ok>,8O\u0003\u0002\u0017/\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u00031e\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005iY\u0012aA:rY*\u0011A$H\u0001\u0006gB\f'o\u001b\u0006\u0003=}\ta!\u00199bG\",'\"\u0001\u0011\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u00193\u0006\u0005\u0002%S5\tQE\u0003\u0002'O\u0005!A.\u00198h\u0015\u0005A\u0013\u0001\u00026bm\u0006L!AK\u0013\u0003\r=\u0013'.Z2u!\ta#'D\u0001.\u0015\t1bF\u0003\u00020a\u0005!!/Z1e\u0015\t\t\u0014$A\u0005d_:tWm\u0019;pe&\u00111'\f\u0002\u0011\u0007>tG/\u001b8v_V\u001c8\u000b\u001e:fC6\fQB]8xgB+'oU3d_:$\u0007C\u0001\u001c:\u001b\u00059$\"\u0001\u001d\u0002\u000bM\u001c\u0017\r\\1\n\u0005i:$\u0001\u0002'p]\u001e\fQB\\;n!\u0006\u0014H/\u001b;j_:\u001c\bC\u0001\u001c>\u0013\tqtGA\u0002J]R\fa\u0001P5oSRtDcA!D\tB\u0011!\tA\u0007\u0002'!)Ag\u0001a\u0001k!)1h\u0001a\u0001y\u0005qA-\u001a4bk2$hi\u001c:nCR\u001cX#A$\u0011\u0005![U\"A%\u000b\u0005){\u0012A\u00026t_:$4/\u0003\u0002M\u0013\nqA)\u001a4bk2$hi\u001c:nCR\u001c\u0018a\u00043fM\u0006,H\u000e\u001e$pe6\fGo\u001d\u0011\u0002\u0019\r\u0014X-\u0019;j_:$\u0016.\\3\u0016\u0003U\nQb\u0019:fCRLwN\u001c+j[\u0016\u0004\u0013\u0001\u00059feB\u000b'\u000f^5uS>t'+\u0019;f+\u0005\u0019\u0006C\u0001\u001cU\u0013\t)vG\u0001\u0004E_V\u0014G.Z\u0001\u0012a\u0016\u0014\b+\u0019:uSRLwN\u001c*bi\u0016\u0004\u0013\u0001D7fe\u001e,wJ\u001a4tKR\u001cHCA-]!\ta#,\u0003\u0002\\[\t1qJ\u001a4tKRDQ!\u0018\u0006A\u0002y\u000bqa\u001c4gg\u0016$8\u000fE\u00027?\u0006L!\u0001Y\u001c\u0003\u000b\u0005\u0013(/Y=\u0011\u00051\u0012\u0017BA2.\u0005=\u0001\u0016M\u001d;ji&|gn\u00144gg\u0016$\u0018!\u00053fg\u0016\u0014\u0018.\u00197ju\u0016|eMZ:fiR\u0011\u0011L\u001a\u0005\u0006O.\u0001\r\u0001[\u0001\u0005UN|g\u000e\u0005\u0002ja:\u0011!N\u001c\t\u0003W^j\u0011\u0001\u001c\u0006\u0003[\u0006\na\u0001\u0010:p_Rt\u0014BA88\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011O\u001d\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005=<\u0014!D5oSRL\u0017\r\\(gMN,G\u000fF\u0001Z\u0003M\u0001H.\u00198J]B,H\u000fU1si&$\u0018n\u001c8t)\t9H\u0010E\u00027?b\u0004\"!\u001f>\u000e\u00039J!a\u001f\u0018\u0003\u001d%s\u0007/\u001e;QCJ$\u0018\u000e^5p]\")Q0\u0004a\u00013\u0006)1\u000f^1si\u0006i2M]3bi\u0016\u001cuN\u001c;j]V|Wo\u001d*fC\u0012,'OR1di>\u0014\u0018\u0010\u0006\u0002\u0002\u0002A\u0019A&a\u0001\n\u0007\u0005\u0015QF\u0001\u0011D_:$\u0018N\\;pkN\u0004\u0016M\u001d;ji&|gNU3bI\u0016\u0014h)Y2u_JL\u0018AB2p[6LG\u000f\u0006\u0003\u0002\f\u0005E\u0001c\u0001\u001c\u0002\u000e%\u0019\u0011qB\u001c\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u0003'y\u0001\u0019A-\u0002\u0007\u0015tG-\u0001\u0003ti>\u0004HCAA\u0006\u0003M\u0019'/Z1uK&s\u0017\u000e^5bY>3gm]3u)\u0019\ti\"!\n\u0002(A!\u0011qDA\u0011\u001b\u0005)\u0012bAA\u0012+\t\u0001\"+\u0019;f'R\u0014X-Y7PM\u001a\u001cX\r\u001e\u0005\u0006wE\u0001\r\u0001\u0010\u0005\u0007\u0003S\t\u0002\u0019A\u001b\u0002\u001d\r\u0014X-\u0019;j_:$\u0016.\\3Ng\u0002")
public class RateStreamContinuousStream
implements ContinuousStream {
    private final int numPartitions;
    private final DefaultFormats defaultFormats;
    private final long creationTime;
    private final double perPartitionRate;

    public boolean needsReconfiguration() {
        return super.needsReconfiguration();
    }

    public DefaultFormats defaultFormats() {
        return this.defaultFormats;
    }

    public long creationTime() {
        return this.creationTime;
    }

    public double perPartitionRate() {
        return this.perPartitionRate;
    }

    public Offset mergeOffsets(PartitionOffset[] offsets) {
        Predef$.MODULE$.assert(offsets.length == this.numPartitions);
        Tuple2[] tuples = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])offsets)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            PartitionOffset partitionOffset = x0$1;
            if (!(partitionOffset instanceof RateStreamPartitionOffset)) {
                throw new MatchError((Object)partitionOffset);
            }
            RateStreamPartitionOffset rateStreamPartitionOffset = (RateStreamPartitionOffset)partitionOffset;
            int i = rateStreamPartitionOffset.partition();
            long currVal = rateStreamPartitionOffset.currentValue();
            long nextRead = rateStreamPartitionOffset.currentTimeMs();
            Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)i), (Object)new ValueRunTimeMsPair(currVal, nextRead));
            return tuple2;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        return new RateStreamOffset((Map<Object, ValueRunTimeMsPair>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuples))));
    }

    public Offset deserializeOffset(String json) {
        return new RateStreamOffset((Map<Object, ValueRunTimeMsPair>)((Map)Serialization$.MODULE$.read(json, (Formats)this.defaultFormats(), ManifestFactory$.MODULE$.classType(Map.class, (Manifest)ManifestFactory$.MODULE$.Int(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.classType(ValueRunTimeMsPair.class)})))));
    }

    public Offset initialOffset() {
        return this.createInitialOffset(this.numPartitions, this.creationTime());
    }

    public InputPartition[] planInputPartitions(Offset start) {
        Offset offset = start;
        if (!(offset instanceof RateStreamOffset)) {
            throw new IllegalArgumentException(new StringBuilder(45).append("invalid offset type ").append(offset.getClass()).append(" for ContinuousRateSource").toString());
        }
        RateStreamOffset rateStreamOffset = (RateStreamOffset)offset;
        Map<Object, ValueRunTimeMsPair> map = rateStreamOffset.partitionToValueAndRunTimeMs();
        Map<Object, ValueRunTimeMsPair> partitionStartMap = map;
        if (partitionStartMap.keySet().size() != this.numPartitions) {
            throw new IllegalArgumentException(new StringBuilder(125).append("The previous run contained ").append(partitionStartMap.keySet().size()).append(" partitions, but").append(" ").append(this.numPartitions).append(" partitions are currently configured. The numPartitions option").append(" cannot be changed.").toString());
        }
        return (InputPartition[])((TraversableOnce)package$.MODULE$.Range().apply(0, this.numPartitions).map((Function1 & Serializable & scala.Serializable)i -> RateStreamContinuousStream.$anonfun$planInputPartitions$1(this, partitionStartMap, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(InputPartition.class));
    }

    public ContinuousPartitionReaderFactory createContinuousReaderFactory() {
        return RateStreamContinuousReaderFactory$.MODULE$;
    }

    public void commit(Offset end) {
    }

    public void stop() {
    }

    private RateStreamOffset createInitialOffset(int numPartitions, long creationTimeMs) {
        return new RateStreamOffset((Map<Object, ValueRunTimeMsPair>)((TraversableOnce)package$.MODULE$.Range().apply(0, numPartitions).map((Function1 & Serializable & scala.Serializable)i -> RateStreamContinuousStream.$anonfun$createInitialOffset$1(numPartitions, creationTimeMs, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
    }

    public static final /* synthetic */ RateStreamContinuousInputPartition $anonfun$planInputPartitions$1(RateStreamContinuousStream $this, Map partitionStartMap$1, int i) {
        ValueRunTimeMsPair start = (ValueRunTimeMsPair)partitionStartMap$1.apply((Object)BoxesRunTime.boxToInteger((int)i));
        return new RateStreamContinuousInputPartition(start.value(), start.runTimeMs(), i, $this.numPartitions, $this.perPartitionRate());
    }

    public static final /* synthetic */ Tuple2 $anonfun$createInitialOffset$1(int numPartitions$1, long creationTimeMs$1, int i) {
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)i), (Object)new ValueRunTimeMsPair(i - numPartitions$1, creationTimeMs$1));
    }

    public RateStreamContinuousStream(long rowsPerSecond, int numPartitions) {
        this.numPartitions = numPartitions;
        this.defaultFormats = DefaultFormats$.MODULE$;
        this.creationTime = System.currentTimeMillis();
        this.perPartitionRate = (double)rowsPerSecond / (double)numPartitions;
    }
}

