/*
 * Decompiled with CFR 0.152.
 */
package test.org.apache.spark.sql;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.QueryTest$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Utils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class JavaSaveLoadSuite {
    private transient SparkSession spark;
    File path;
    Dataset<Row> df;

    private static void checkAnswer(Dataset<Row> actual, List<Row> expected) {
        QueryTest$.MODULE$.checkAnswer(actual, expected);
    }

    @Before
    public void setUp() throws IOException {
        this.spark = SparkSession.builder().master("local[*]").appName("testing").getOrCreate();
        this.path = Utils.createTempDir((String)System.getProperty("java.io.tmpdir"), (String)"datasource").getCanonicalFile();
        if (this.path.exists()) {
            this.path.delete();
        }
        ArrayList<String> jsonObjects = new ArrayList<String>(10);
        for (int i = 0; i < 10; ++i) {
            jsonObjects.add("{\"a\":" + i + ", \"b\":\"str" + i + "\"}");
        }
        Dataset ds = this.spark.createDataset(jsonObjects, Encoders.STRING());
        this.df = this.spark.read().json(ds);
        this.df.createOrReplaceTempView("jsonTable");
    }

    @After
    public void tearDown() {
        this.spark.stop();
        this.spark = null;
    }

    @Test
    public void saveAndLoad() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("path", this.path.toString());
        this.df.write().mode(SaveMode.ErrorIfExists).format("json").options(options).save();
        Dataset loadedDF = this.spark.read().format("json").options(options).load();
        JavaSaveLoadSuite.checkAnswer((Dataset<Row>)loadedDF, this.df.collectAsList());
    }

    @Test
    public void saveAndLoadWithSchema() {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("path", this.path.toString());
        this.df.write().format("json").mode(SaveMode.ErrorIfExists).options(options).save();
        ArrayList<StructField> fields = new ArrayList<StructField>();
        fields.add(DataTypes.createStructField((String)"b", (DataType)DataTypes.StringType, (boolean)true));
        StructType schema = DataTypes.createStructType(fields);
        Dataset loadedDF = this.spark.read().format("json").schema(schema).options(options).load();
        JavaSaveLoadSuite.checkAnswer((Dataset<Row>)loadedDF, this.spark.sql("SELECT b FROM jsonTable").collectAsList());
    }
}

