/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogFunction;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.execution.SQLViewTestSuite;
import org.apache.spark.sql.internal.SQLConf$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001u2Qa\u0001\u0003\u0002\u0002=AQ\u0001\u0006\u0001\u0005\u0002UAQa\u0006\u0001\u0007\u0002a\u0011\u0011\u0003V3naZKWm\u001e+fgR\u001cV/\u001b;f\u0015\t)a!A\u0005fq\u0016\u001cW\u000f^5p]*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0005\t\u0003#Ii\u0011\u0001B\u0005\u0003'\u0011\u0011\u0001cU)M-&,w\u000fV3tiN+\u0018\u000e^3\u0002\rqJg.\u001b;?)\u00051\u0002CA\t\u0001\u0003i\u0019'/Z1uK>\u0013(+\u001a9mC\u000e,G)\u0019;bg\u0016$h+[3x)\rIrd\r\t\u00035ui\u0011a\u0007\u0006\u00029\u0005)1oY1mC&\u0011ad\u0007\u0002\u0005+:LG\u000fC\u0003!\u0005\u0001\u0007\u0011%\u0001\u0002eMB\u0011!\u0005\r\b\u0003G9r!\u0001J\u0017\u000f\u0005\u0015bcB\u0001\u0014,\u001d\t9#&D\u0001)\u0015\tIc\"\u0001\u0004=e>|GOP\u0005\u0002\u001b%\u00111\u0002D\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005=2\u0011a\u00029bG.\fw-Z\u0005\u0003cI\u0012\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0005=2\u0001\"\u0002\u001b\u0003\u0001\u0004)\u0014\u0001\u0003<jK^t\u0015-\\3\u0011\u0005YRdBA\u001c9!\t93$\u0003\u0002:7\u00051\u0001K]3eK\u001aL!a\u000f\u001f\u0003\rM#(/\u001b8h\u0015\tI4\u0004")
public abstract class TempViewTestSuite
extends SQLViewTestSuite {
    public abstract void createOrReplaceDatasetView(Dataset<Row> var1, String var2);

    public TempViewTestSuite() {
        this.test("SPARK-37202: temp view should capture the function registered by catalog API", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String funcName = "tempFunc";
            this.withUserDefinedFunction((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)funcName), (Object)BoxesRunTime.boxToBoolean((boolean)true))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                CatalogFunction catalogFunction = new CatalogFunction(new FunctionIdentifier(funcName, (Option)None$.MODULE$), "org.apache.spark.myFunc", (Seq)Nil$.MODULE$);
                Function1 & Serializable & scala.Serializable functionBuilder = (Function1 & Serializable & scala.Serializable)e -> (Expression)e.head();
                this.spark().sessionState().catalog().registerFunction(catalogFunction, false, (Option)new Some((Object)functionBuilder));
                String query = new StringBuilder(54).append("SELECT ").append(funcName).append("(max(a), min(a)) FROM VALUES (1), (2), (3) t(a)").toString();
                String viewName = this.createView("tempView", query, this.createView$default$3(), this.createView$default$4(), this.createView$default$5());
                this.withView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{viewName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkViewOutput(viewName, (Seq<Row>)Predef$.MODULE$.wrapRefArray((Object[])((Dataset)this.sql().apply((Object)query)).collect())));
            });
        }, new Position("SQLViewTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 416));
        this.test("show create table does not support temp view", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String viewName = "spark_28383";
            this.withView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{viewName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.createView(viewName, "SELECT 1 AS a", this.createView$default$3(), this.createView$default$4(), this.createView$default$5());
                AnalysisException ex = (AnalysisException)((Object)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(18).append("SHOW CREATE TABLE ").append(this.formattedViewName(viewName)).toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("SQLViewTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 436)))));
                String $org_scalatest_assert_macro_left = ex.getMessage();
                String $org_scalatest_assert_macro_right = new StringBuilder(71).append(viewName).append(" is a temp view. 'SHOW CREATE TABLE' expects a table or permanent view.").toString();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SQLViewTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 439));
            });
        }, new Position("SQLViewTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 432));
        this.test("back compatibility: skip cyclic reference check if view is stored as logical plan", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String viewName = this.formattedViewName("v");
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STORE_ANALYZED_PLAN_FOR_VIEW().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{viewName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.createOrReplaceDatasetView((Dataset<Row>)((Dataset)this.sql().apply((Object)"SELECT 1")), "v");
                this.createOrReplaceDatasetView((Dataset<Row>)((Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(viewName).toString())), "v");
                this.checkViewOutput(viewName, (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$)));
            }));
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STORE_ANALYZED_PLAN_FOR_VIEW().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{viewName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.createOrReplaceDatasetView((Dataset<Row>)((Dataset)this.sql().apply((Object)"SELECT 1")), "v");
                this.createOrReplaceDatasetView((Dataset<Row>)((Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(viewName).toString())), "v");
                this.checkViewOutput(viewName, (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$)));
                String x$1 = "v";
                String x$2 = "SELECT 2";
                boolean x$3 = true;
                Seq<String> x$4 = this.createView$default$3();
                Seq<String> x$5 = this.createView$default$4();
                this.createView(x$1, x$2, x$4, x$5, x$3);
                String x$6 = "v";
                String x$7 = new StringBuilder(14).append("SELECT * FROM ").append(viewName).toString();
                boolean x$8 = true;
                Seq<String> x$9 = this.createView$default$3();
                Seq<String> x$10 = this.createView$default$4();
                this.createView(x$6, x$7, x$9, x$10, x$8);
                this.checkViewOutput(viewName, (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)})), (List)Nil$.MODULE$)));
            }));
        }, new Position("SQLViewTestSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 444));
    }
}

