/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.GuardedBy;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.TaskContext$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.execution.streaming.state.AcquiredThreadInfo;
import org.apache.spark.sql.execution.streaming.state.ByteArrayPair;
import org.apache.spark.sql.execution.streaming.state.ByteArrayPair$;
import org.apache.spark.sql.execution.streaming.state.RocksDB$;
import org.apache.spark.sql.execution.streaming.state.RocksDBCheckpointMetadata;
import org.apache.spark.sql.execution.streaming.state.RocksDBConf;
import org.apache.spark.sql.execution.streaming.state.RocksDBFileManager;
import org.apache.spark.sql.execution.streaming.state.RocksDBFileManagerMetrics;
import org.apache.spark.sql.execution.streaming.state.RocksDBFileManagerMetrics$;
import org.apache.spark.sql.execution.streaming.state.RocksDBLoader$;
import org.apache.spark.sql.execution.streaming.state.RocksDBMetrics;
import org.apache.spark.sql.execution.streaming.state.RocksDBNativeHistogram;
import org.apache.spark.sql.execution.streaming.state.RocksDBNativeHistogram$;
import org.apache.spark.util.NextIterator;
import org.apache.spark.util.Utils$;
import org.rocksdb.AbstractImmutableNativeReference;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.BloomFilter;
import org.rocksdb.Cache;
import org.rocksdb.Checkpoint;
import org.rocksdb.Filter;
import org.rocksdb.FlushOptions;
import org.rocksdb.HistogramType;
import org.rocksdb.InfoLogLevel;
import org.rocksdb.LRUCache;
import org.rocksdb.Options;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksIterator;
import org.rocksdb.Statistics;
import org.rocksdb.TableFormatConfig;
import org.rocksdb.TickerType;
import org.rocksdb.WriteBatchWithIndex;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r\u001dd\u0001\u0002,X\u0001\u0019D\u0001b\u001d\u0001\u0003\u0002\u0003\u0006I\u0001\u001e\u0005\n\u007f\u0002\u0011)\u0019!C\u0001\u0003\u0003A!\"a\u0003\u0001\u0005\u0003\u0005\u000b\u0011BA\u0002\u0011)\ti\u0001\u0001B\u0001B\u0003%\u0011q\u0002\u0005\u000b\u0003?\u0001!\u0011!Q\u0001\n\u0005\u0005\u0002\"CA\u0018\u0001\t\u0005\t\u0015!\u0003u\u0011\u001d\t\t\u0004\u0001C\u0001\u0003gA\u0011\"!\u0011\u0001\u0005\u0004%I!a\u0011\t\u0011\u0005E\u0003\u0001)A\u0005\u0003\u000bB\u0011\"a\u0015\u0001\u0005\u0004%I!!\u0016\t\u0011\u0005u\u0003\u0001)A\u0005\u0003/B\u0011\"a\u0018\u0001\u0005\u0004%I!!\u0019\t\u0011\u0005%\u0004\u0001)A\u0005\u0003GB\u0011\"a\u001b\u0001\u0005\u0004%I!!\u001c\t\u0011\u0005U\u0004\u0001)A\u0005\u0003_B\u0011\"a\u001e\u0001\u0005\u0004%I!!\u001f\t\u0011\u0005\u0005\u0005\u0001)A\u0005\u0003wB\u0011\"a!\u0001\u0005\u0004%I!!\"\t\u0011\u00055\u0005\u0001)A\u0005\u0003\u000fC\u0011\"a$\u0001\u0005\u0004%I!!%\t\u0011\u0005e\u0005\u0001)A\u0005\u0003'C\u0011\"a'\u0001\u0005\u0004%I!!(\t\u0011\u0005\u0015\u0006\u0001)A\u0005\u0003?C\u0011\"a*\u0001\u0005\u0004%I!!+\t\u0011\u0005E\u0006\u0001)A\u0005\u0003WC\u0011\"a-\u0001\u0005\u0004%I!!.\t\u0011\u0005]\u0006\u0001)A\u0005\u0003\u001fA\u0011\"!/\u0001\u0005\u0004%I!a/\t\u0011\u0005\r\u0007\u0001)A\u0005\u0003{C\u0011\"!2\u0001\u0005\u0004%I!a2\t\u0011\u0005=\u0007\u0001)A\u0005\u0003\u0013D\u0011\"!5\u0001\u0005\u0004%I!a5\t\u0011\u0005-\b\u0001)A\u0005\u0003+D\u0011\"!<\u0001\u0005\u0004%I!a<\t\u0011\u0005u\b\u0001)A\u0005\u0003cD1\"a@\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0003\u0002!Y!q\u0001\u0001A\u0002\u0003\u0007I\u0011\u0002B\u0005\u0011-\u0011)\u0002\u0001a\u0001\u0002\u0003\u0006KAa\u0001\t\u0013\t}\u0001\u00011A\u0005\n\t\u0005\u0002\"\u0003B\u0012\u0001\u0001\u0007I\u0011\u0002B\u0013\u0011!\u0011I\u0003\u0001Q!\n\u0005\u0015\b\"\u0003B\u0017\u0001\u0001\u0007I\u0011\u0002B\u0011\u0011%\u0011y\u0003\u0001a\u0001\n\u0013\u0011\t\u0004\u0003\u0005\u00036\u0001\u0001\u000b\u0015BAs\u0011%\u0011I\u0004\u0001a\u0001\n\u0013\u0011\t\u0003C\u0005\u0003<\u0001\u0001\r\u0011\"\u0003\u0003>!A!\u0011\t\u0001!B\u0013\t)\u000fC\u0005\u0003F\u0001\u0001\r\u0011\"\u0003\u0003H!I!q\n\u0001A\u0002\u0013%!\u0011\u000b\u0005\t\u0005+\u0002\u0001\u0015)\u0003\u0003J!Y!\u0011\f\u0001A\u0002\u0003\u0007I\u0011\u0002B.\u0011-\u0011\u0019\u0007\u0001a\u0001\u0002\u0004%IA!\u001a\t\u0017\t%\u0004\u00011A\u0001B\u0003&!Q\f\u0005\n\u0005\u000f\u0003!\u0019!C\u0005\u0005\u0013C\u0001Ba(\u0001A\u0003%!1\u0012\u0005\b\u0005C\u0003A\u0011\u0001BR\u0011\u001d\u0011I\u000b\u0001C\u0001\u0005WCqA!0\u0001\t\u0003\u0011y\fC\u0004\u0003F\u0002!\tAa2\t\u000f\t-\u0007\u0001\"\u0001\u0003N\"9!\u0011\u001d\u0001\u0005\n\t\r\bb\u0002Bs\u0001\u0011\u0005!q\u001d\u0005\b\u0005[\u0004A\u0011\u0001Br\u0011\u001d\u0011y\u000f\u0001C\u0001\u0005cDqAa=\u0001\t\u0003\u0011\t\u0010C\u0004\u0003v\u0002!\tA!=\t\u000f\t]\b\u0001\"\u0001\u0003d\"9!\u0011 \u0001\u0005\u0002\tm\bbBB\u0002\u0001\u0011%!\u0011\u001f\u0005\b\u0007\u000b\u0001A\u0011\u0002By\u0011\u001d\u00199\u0001\u0001C\u0005\u0005cDqa!\u0003\u0001\t\u0013\u0019Y\u0001C\u0004\u0004\u0012\u0001!IA!=\t\u000f\rM\u0001\u0001\"\u0003\u0003r\"91Q\u0003\u0001\u0005\n\r]\u0001bBB\r\u0001\u0011%11\u0004\u0005\b\u0007?\u0001A\u0011BB\u0011\u0011\u001d\u0019Y\u0003\u0001C\t\u0007[Aqa!\u000f\u0001\t#\u001aYdB\u0005\u0004>]\u000b\t\u0011#\u0001\u0004@\u0019AakVA\u0001\u0012\u0003\u0019\t\u0005C\u0004\u00022E#\taa\u0011\t\u0013\r\u0015\u0013+%A\u0005\u0002\r\u001d\u0003\"CB.#F\u0005I\u0011AB/\u0011%\u0019\t'UI\u0001\n\u0003\u0019\u0019GA\u0004S_\u000e\\7\u000f\u0012\"\u000b\u0005aK\u0016!B:uCR,'B\u0001.\\\u0003%\u0019HO]3b[&twM\u0003\u0002];\u0006IQ\r_3dkRLwN\u001c\u0006\u0003=~\u000b1a]9m\u0015\t\u0001\u0017-A\u0003ta\u0006\u00148N\u0003\u0002cG\u00061\u0011\r]1dQ\u0016T\u0011\u0001Z\u0001\u0004_J<7\u0001A\n\u0004\u0001\u001dl\u0007C\u00015l\u001b\u0005I'\"\u00016\u0002\u000bM\u001c\u0017\r\\1\n\u00051L'AB!osJ+g\r\u0005\u0002oc6\tqN\u0003\u0002q?\u0006A\u0011N\u001c;fe:\fG.\u0003\u0002s_\n9Aj\\4hS:<\u0017A\u00033ggJ{w\u000e\u001e#jeB\u0011Q\u000f \b\u0003mj\u0004\"a^5\u000e\u0003aT!!_3\u0002\rq\u0012xn\u001c;?\u0013\tY\u0018.\u0001\u0004Qe\u0016$WMZ\u0005\u0003{z\u0014aa\u0015;sS:<'BA>j\u0003\u0011\u0019wN\u001c4\u0016\u0005\u0005\r\u0001\u0003BA\u0003\u0003\u000fi\u0011aV\u0005\u0004\u0003\u00139&a\u0003*pG.\u001cHIQ\"p]\u001a\fQaY8oM\u0002\nA\u0002\\8dC2\u0014vn\u001c;ESJ\u0004B!!\u0005\u0002\u001c5\u0011\u00111\u0003\u0006\u0005\u0003+\t9\"\u0001\u0002j_*\u0011\u0011\u0011D\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u001e\u0005M!\u0001\u0002$jY\u0016\f!\u0002[1e_>\u00048i\u001c8g!\u0011\t\u0019#a\u000b\u000e\u0005\u0005\u0015\"bA@\u0002()\u0019\u0011\u0011F1\u0002\r!\fGm\\8q\u0013\u0011\ti#!\n\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0003%awnZ4j]\u001eLE-\u0001\u0004=S:LGO\u0010\u000b\r\u0003k\t9$!\u000f\u0002<\u0005u\u0012q\b\t\u0004\u0003\u000b\u0001\u0001\"B:\b\u0001\u0004!\bBB@\b\u0001\u0004\t\u0019\u0001C\u0005\u0002\u000e\u001d\u0001\n\u00111\u0001\u0002\u0010!I\u0011qD\u0004\u0011\u0002\u0003\u0007\u0011\u0011\u0005\u0005\t\u0003_9\u0001\u0013!a\u0001i\u0006Y!/Z1e\u001fB$\u0018n\u001c8t+\t\t)\u0005\u0005\u0003\u0002H\u00055SBAA%\u0015\r\tYeY\u0001\be>\u001c7n\u001d3c\u0013\u0011\ty%!\u0013\u0003\u0017I+\u0017\rZ(qi&|gn]\u0001\re\u0016\fGm\u00149uS>t7\u000fI\u0001\roJLG/Z(qi&|gn]\u000b\u0003\u0003/\u0002B!a\u0012\u0002Z%!\u00111LA%\u000519&/\u001b;f\u001fB$\u0018n\u001c8t\u000359(/\u001b;f\u001fB$\u0018n\u001c8tA\u0005aa\r\\;tQ>\u0003H/[8ogV\u0011\u00111\r\t\u0005\u0003\u000f\n)'\u0003\u0003\u0002h\u0005%#\u0001\u0004$mkNDw\n\u001d;j_:\u001c\u0018!\u00044mkNDw\n\u001d;j_:\u001c\b%\u0001\u0006xe&$XMQ1uG\",\"!a\u001c\u0011\t\u0005\u001d\u0013\u0011O\u0005\u0005\u0003g\nIEA\nXe&$XMQ1uG\"<\u0016\u000e\u001e5J]\u0012,\u00070A\u0006xe&$XMQ1uG\"\u0004\u0013a\u00032m_>lg)\u001b7uKJ,\"!a\u001f\u0011\t\u0005\u001d\u0013QP\u0005\u0005\u0003\u007f\nIEA\u0006CY>|WNR5mi\u0016\u0014\u0018\u0001\u00042m_>lg)\u001b7uKJ\u0004\u0013!\u0005;bE2,gi\u001c:nCR\u001cuN\u001c4jOV\u0011\u0011q\u0011\t\u0005\u0003\u000f\nI)\u0003\u0003\u0002\f\u0006%#!\u0006\"m_\u000e\\')Y:fIR\u000b'\r\\3D_:4\u0017nZ\u0001\u0013i\u0006\u0014G.\u001a$pe6\fGoQ8oM&<\u0007%A\u0005eE>\u0003H/[8ogV\u0011\u00111\u0013\t\u0005\u0003\u000f\n)*\u0003\u0003\u0002\u0018\u0006%#aB(qi&|gn]\u0001\u000bI\n|\u0005\u000f^5p]N\u0004\u0013\u0001\u00033c\u0019><w-\u001a:\u0016\u0005\u0005}\u0005\u0003BA$\u0003CKA!a)\u0002J\t1Aj\\4hKJ\f\u0011\u0002\u001a2M_\u001e<WM\u001d\u0011\u0002\u00179\fG/\u001b<f'R\fGo]\u000b\u0003\u0003W\u0003B!a\u0012\u0002.&!\u0011qVA%\u0005)\u0019F/\u0019;jgRL7m]\u0001\r]\u0006$\u0018N^3Ti\u0006$8\u000fI\u0001\u000bo>\u00148.\u001b8h\t&\u0014XCAA\b\u0003-9xN]6j]\u001e$\u0015N\u001d\u0011\u0002\u0017\u0019LG.Z'b]\u0006<WM]\u000b\u0003\u0003{\u0003B!!\u0002\u0002@&\u0019\u0011\u0011Y,\u0003%I{7m[:E\u0005\u001aKG.Z'b]\u0006<WM]\u0001\rM&dW-T1oC\u001e,'\u000fI\u0001\u000eEf$X-\u0011:sCf\u0004\u0016-\u001b:\u0016\u0005\u0005%\u0007\u0003BA\u0003\u0003\u0017L1!!4X\u00055\u0011\u0015\u0010^3BeJ\f\u0017\u0010U1je\u0006q!-\u001f;f\u0003J\u0014\u0018-\u001f)bSJ\u0004\u0013aD2p[6LG\u000fT1uK:\u001c\u00170T:\u0016\u0005\u0005U\u0007cBAl\u0003C$\u0018Q]\u0007\u0003\u00033TA!a7\u0002^\u00069Q.\u001e;bE2,'bAApS\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\r\u0018\u0011\u001c\u0002\b\u0011\u0006\u001c\b.T1q!\rA\u0017q]\u0005\u0004\u0003SL'\u0001\u0002'p]\u001e\f\u0001cY8n[&$H*\u0019;f]\u000eLXj\u001d\u0011\u0002\u0017\u0005\u001c\u0017/^5sK2{7m[\u000b\u0003\u0003c\u0004B!a=\u0002z6\u0011\u0011Q\u001f\u0006\u0005\u0003o\f9\"\u0001\u0003mC:<\u0017\u0002BA~\u0003k\u0014aa\u00142kK\u000e$\u0018\u0001D1dcVL'/\u001a'pG.\u0004\u0013A\u00013c+\t\u0011\u0019\u0001\u0005\u0003\u0002H\t\u0015\u0011b\u0001,\u0002J\u00051AMY0%KF$BAa\u0003\u0003\u0012A\u0019\u0001N!\u0004\n\u0007\t=\u0011N\u0001\u0003V]&$\b\"\u0003B\nK\u0005\u0005\t\u0019\u0001B\u0002\u0003\rAH%M\u0001\u0004I\n\u0004\u0003f\u0001\u0014\u0003\u001aA\u0019\u0001Na\u0007\n\u0007\tu\u0011N\u0001\u0005w_2\fG/\u001b7f\u00035aw.\u00193fIZ+'o]5p]V\u0011\u0011Q]\u0001\u0012Y>\fG-\u001a3WKJ\u001c\u0018n\u001c8`I\u0015\fH\u0003\u0002B\u0006\u0005OA\u0011Ba\u0005)\u0003\u0003\u0005\r!!:\u0002\u001d1|\u0017\rZ3e-\u0016\u00148/[8oA!\u001a\u0011F!\u0007\u0002-9,XnS3zg>sGj\\1eK\u00124VM]:j_:\f!D\\;n\u0017\u0016L8o\u00148M_\u0006$W\r\u001a,feNLwN\\0%KF$BAa\u0003\u00034!I!1C\u0016\u0002\u0002\u0003\u0007\u0011Q]\u0001\u0018]Vl7*Z=t\u001f:du.\u00193fIZ+'o]5p]\u0002B3\u0001\fB\r\u0003]qW/\\&fsN|en\u0016:ji&twMV3sg&|g.A\u000eok6\\U-_:P]^\u0013\u0018\u000e^5oOZ+'o]5p]~#S-\u001d\u000b\u0005\u0005\u0017\u0011y\u0004C\u0005\u0003\u00149\n\t\u00111\u0001\u0002f\u0006Ab.^7LKf\u001cxJ\\,sSRLgn\u001a,feNLwN\u001c\u0011)\u0007=\u0012I\"\u0001\ngS2,W*\u00198bO\u0016\u0014X*\u001a;sS\u000e\u001cXC\u0001B%!\u0011\t)Aa\u0013\n\u0007\t5sKA\rS_\u000e\\7\u000f\u0012\"GS2,W*\u00198bO\u0016\u0014X*\u001a;sS\u000e\u001c\u0018A\u00064jY\u0016l\u0015M\\1hKJlU\r\u001e:jGN|F%Z9\u0015\t\t-!1\u000b\u0005\n\u0005'\t\u0014\u0011!a\u0001\u0005\u0013\n1CZ5mK6\u000bg.Y4fe6+GO]5dg\u0002B3A\rB\r\u0003I\t7-];je\u0016$G\u000b\u001b:fC\u0012LeNZ8\u0016\u0005\tu\u0003\u0003BA\u0003\u0005?J1A!\u0019X\u0005I\t5-];je\u0016$G\u000b\u001b:fC\u0012LeNZ8\u0002-\u0005\u001c\u0017/^5sK\u0012$\u0006N]3bI&sgm\\0%KF$BAa\u0003\u0003h!I!1\u0003\u001b\u0002\u0002\u0003\u0007!QL\u0001\u0014C\u000e\fX/\u001b:fIRC'/Z1e\u0013:4w\u000e\t\u0015\u0004k\te\u0001fB\u001b\u0003p\t\r%Q\u0011\t\u0005\u0005c\u0012y(\u0004\u0002\u0003t)!!Q\u000fB<\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0005s\u0012Y(\u0001\u0006b]:|G/\u0019;j_:T!A! \u0002\u000b)\fg/\u0019=\n\t\t\u0005%1\u000f\u0002\n\u000fV\f'\u000fZ3e\u0005f\fQA^1mk\u0016\f#!!<\u0002'A\u0014XMZ5y'\u000e\fgNU3vg\u0016LE/\u001a:\u0016\u0005\t-\u0005\u0003\u0003BG\u0005+\u000b)O!'\u000e\u0005\t=%\u0002\u0002B;\u0005#SAAa%\u0002\u0018\u0005!Q\u000f^5m\u0013\u0011\u00119Ja$\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000f\u0005\u0003\u0002H\tm\u0015\u0002\u0002BO\u0003\u0013\u0012QBU8dWNLE/\u001a:bi>\u0014\u0018\u0001\u00069sK\u001aL\u0007pU2b]J+Wo]3Ji\u0016\u0014\b%\u0001\u0003m_\u0006$G\u0003BA\u001b\u0005KCqAa*9\u0001\u0004\t)/A\u0004wKJ\u001c\u0018n\u001c8\u0002\u0007\u001d,G\u000f\u0006\u0003\u0003.\ne\u0006#\u00025\u00030\nM\u0016b\u0001BYS\n)\u0011I\u001d:bsB\u0019\u0001N!.\n\u0007\t]\u0016N\u0001\u0003CsR,\u0007b\u0002B^s\u0001\u0007!QV\u0001\u0004W\u0016L\u0018a\u00019viR1!1\u0002Ba\u0005\u0007DqAa/;\u0001\u0004\u0011i\u000bC\u0004\u0003\u0004j\u0002\rA!,\u0002\rI,Wn\u001c<f)\u0011\u0011YA!3\t\u000f\tm6\b1\u0001\u0003.\u0006A\u0011\u000e^3sCR|'\u000f\u0006\u0002\u0003PB1!\u0011\u001bBn\u0003\u0013tAAa5\u0003X:\u0019qO!6\n\u0003)L1A!7j\u0003\u001d\u0001\u0018mY6bO\u0016LAA!8\u0003`\nA\u0011\n^3sCR|'OC\u0002\u0003Z&\f\u0011bY8v]R\\U-_:\u0015\u0005\u0005\u0015\u0018A\u00039sK\u001aL\u0007pU2b]R!!q\u001aBu\u0011\u001d\u0011YO\u0010a\u0001\u0005[\u000ba\u0001\u001d:fM&D\u0018AB2p[6LG/\u0001\u0005s_2d'-Y2l)\t\u0011Y!A\u0004dY\u0016\fg.\u001e9\u0002\u000b\rdwn]3\u0002!\u001d,G\u000fT1uKN$h+\u001a:tS>t\u0017aB7fiJL7m]\u000b\u0003\u0005{\u0004B!!\u0002\u0003\u0000&\u00191\u0011A,\u0003\u001dI{7m[:E\u00056+GO]5dg\u00069\u0011mY9vSJ,\u0017a\u0002:fY\u0016\f7/Z\u0001\u0019G2|7/\u001a)sK\u001aL\u0007pU2b]&#XM]1u_J\u001c\u0018!D4fi\u0012\u0013\u0005K]8qKJ$\u0018\u0010\u0006\u0003\u0002f\u000e5\u0001BBB\b\u0011\u0002\u0007A/\u0001\u0005qe>\u0004XM\u001d;z\u0003\u0019y\u0007/\u001a8E\u0005\u000691\r\\8tK\u0012\u0013\u0015\u0001D2sK\u0006$X\rT8hO\u0016\u0014HCAAP\u00035\u0019'/Z1uKR+W\u000e\u001d#jeR!\u0011qBB\u000f\u0011\u0019\u0011Y\u000f\u0014a\u0001i\u000692/\u001b7f]R$U\r\\3uKJ+7-\u001e:tSZ,G.\u001f\u000b\u0007\u0005\u0017\u0019\u0019ca\n\t\u000f\r\u0015R\n1\u0001\u0002\u0010\u0005!a-\u001b7f\u0011\u0019\u0019I#\u0014a\u0001i\u0006\u0019Qn]4\u0002\u0017QLW.\u001a+bW\u0016tWj\u001d\u000b\u0005\u0003K\u001cy\u0003\u0003\u0005\u000429#\t\u0019AB\u001a\u0003\u0011\u0011w\u000eZ=\u0011\u000b!\u001c)Da\u0003\n\u0007\r]\u0012N\u0001\u0005=Eft\u0017-\\3?\u0003\u001dawn\u001a(b[\u0016,\u0012\u0001^\u0001\b%>\u001c7n\u001d#C!\r\t)!U\n\u0003#\u001e$\"aa\u0010\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\u0019IE\u000b\u0003\u0002\u0010\r-3FAB'!\u0011\u0019yea\u0016\u000e\u0005\rE#\u0002BB*\u0007+\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\te\u0014.\u0003\u0003\u0004Z\rE#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQ*\"aa\u0018+\t\u0005\u000521J\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\r\u0015$f\u0001;\u0004L\u0001")
public class RocksDB
implements Logging {
    private final RocksDBConf conf;
    private final File localRootDir;
    private final String loggingId;
    private final ReadOptions readOptions;
    private final WriteOptions writeOptions;
    private final FlushOptions flushOptions;
    private final WriteBatchWithIndex writeBatch;
    private final BloomFilter bloomFilter;
    private final BlockBasedTableConfig tableFormatConfig;
    private final Options org$apache$spark$sql$execution$streaming$state$RocksDB$$dbOptions;
    private final org.rocksdb.Logger dbLogger;
    private final Statistics nativeStats;
    private final File workingDir;
    private final RocksDBFileManager fileManager;
    private final ByteArrayPair org$apache$spark$sql$execution$streaming$state$RocksDB$$byteArrayPair;
    private final HashMap<String, Object> commitLatencyMs;
    private final Object acquireLock;
    private volatile org.rocksdb.RocksDB db;
    private volatile long loadedVersion;
    private volatile long numKeysOnLoadedVersion;
    private volatile long numKeysOnWritingVersion;
    private volatile RocksDBFileManagerMetrics fileManagerMetrics;
    @GuardedBy(value="acquireLock")
    private volatile AcquiredThreadInfo acquiredThreadInfo;
    private final ConcurrentHashMap<Object, RocksIterator> prefixScanReuseIter;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static String $lessinit$greater$default$5() {
        return RocksDB$.MODULE$.$lessinit$greater$default$5();
    }

    public static Configuration $lessinit$greater$default$4() {
        return RocksDB$.MODULE$.$lessinit$greater$default$4();
    }

    public static File $lessinit$greater$default$3() {
        return RocksDB$.MODULE$.$lessinit$greater$default$3();
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public RocksDBConf conf() {
        return this.conf;
    }

    private ReadOptions readOptions() {
        return this.readOptions;
    }

    private WriteOptions writeOptions() {
        return this.writeOptions;
    }

    private FlushOptions flushOptions() {
        return this.flushOptions;
    }

    private WriteBatchWithIndex writeBatch() {
        return this.writeBatch;
    }

    private BloomFilter bloomFilter() {
        return this.bloomFilter;
    }

    private BlockBasedTableConfig tableFormatConfig() {
        return this.tableFormatConfig;
    }

    public Options org$apache$spark$sql$execution$streaming$state$RocksDB$$dbOptions() {
        return this.org$apache$spark$sql$execution$streaming$state$RocksDB$$dbOptions;
    }

    private org.rocksdb.Logger dbLogger() {
        return this.dbLogger;
    }

    private Statistics nativeStats() {
        return this.nativeStats;
    }

    private File workingDir() {
        return this.workingDir;
    }

    private RocksDBFileManager fileManager() {
        return this.fileManager;
    }

    public ByteArrayPair org$apache$spark$sql$execution$streaming$state$RocksDB$$byteArrayPair() {
        return this.org$apache$spark$sql$execution$streaming$state$RocksDB$$byteArrayPair;
    }

    private HashMap<String, Object> commitLatencyMs() {
        return this.commitLatencyMs;
    }

    private Object acquireLock() {
        return this.acquireLock;
    }

    private org.rocksdb.RocksDB db() {
        return this.db;
    }

    private void db_$eq(org.rocksdb.RocksDB x$1) {
        this.db = x$1;
    }

    private long loadedVersion() {
        return this.loadedVersion;
    }

    private void loadedVersion_$eq(long x$1) {
        this.loadedVersion = x$1;
    }

    private long numKeysOnLoadedVersion() {
        return this.numKeysOnLoadedVersion;
    }

    private void numKeysOnLoadedVersion_$eq(long x$1) {
        this.numKeysOnLoadedVersion = x$1;
    }

    private long numKeysOnWritingVersion() {
        return this.numKeysOnWritingVersion;
    }

    private void numKeysOnWritingVersion_$eq(long x$1) {
        this.numKeysOnWritingVersion = x$1;
    }

    private RocksDBFileManagerMetrics fileManagerMetrics() {
        return this.fileManagerMetrics;
    }

    private void fileManagerMetrics_$eq(RocksDBFileManagerMetrics x$1) {
        this.fileManagerMetrics = x$1;
    }

    private AcquiredThreadInfo acquiredThreadInfo() {
        return this.acquiredThreadInfo;
    }

    private void acquiredThreadInfo_$eq(AcquiredThreadInfo x$1) {
        this.acquiredThreadInfo = x$1;
    }

    private ConcurrentHashMap<Object, RocksIterator> prefixScanReuseIter() {
        return this.prefixScanReuseIter;
    }

    public RocksDB load(long version) {
        Predef$.MODULE$.assert(version >= 0L);
        this.acquire();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(8).append("Loading ").append(version).toString());
        try {
            if (this.loadedVersion() != version) {
                this.closeDB();
                RocksDBCheckpointMetadata metadata = this.fileManager().loadCheckpointFromDfs(version, this.workingDir());
                this.openDB();
                long numKeys = !this.conf().trackTotalNumberOfRows() ? -1L : (metadata.numKeys() < 0L ? this.countKeys() : metadata.numKeys());
                this.numKeysOnWritingVersion_$eq(numKeys);
                this.numKeysOnLoadedVersion_$eq(numKeys);
                this.loadedVersion_$eq(version);
                this.fileManagerMetrics_$eq(this.fileManager().latestLoadCheckpointMetrics());
            }
            if (this.conf().resetStatsOnLoad()) {
                this.nativeStats().reset();
            }
            this.closePrefixScanIterators();
            this.writeBatch().clear();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(7).append("Loaded ").append(version).toString());
        }
        catch (Throwable t) {
            this.loadedVersion_$eq(-1L);
            throw t;
        }
        return this;
    }

    public byte[] get(byte[] key) {
        return this.writeBatch().getFromBatchAndDB(this.db(), this.readOptions(), key);
    }

    public void put(byte[] key, byte[] value) {
        byte[] oldValue;
        if (this.conf().trackTotalNumberOfRows() && (oldValue = this.writeBatch().getFromBatchAndDB(this.db(), this.readOptions(), key)) == null) {
            this.numKeysOnWritingVersion_$eq(this.numKeysOnWritingVersion() + 1L);
        }
        this.writeBatch().put(key, value);
    }

    public void remove(byte[] key) {
        byte[] value;
        if (this.conf().trackTotalNumberOfRows() && (value = this.writeBatch().getFromBatchAndDB(this.db(), this.readOptions(), key)) != null) {
            this.numKeysOnWritingVersion_$eq(this.numKeysOnWritingVersion() - 1L);
        }
        this.writeBatch().remove(key);
    }

    public Iterator<ByteArrayPair> iterator() {
        RocksIterator iter = this.writeBatch().newIteratorWithBase(this.db().newIterator());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Getting iterator from version ").append(this.loadedVersion()).toString());
        iter.seekToFirst();
        Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1 & Serializable & scala.Serializable)tc -> tc.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$1 -> {
            iter.close();
            return BoxedUnit.UNIT;
        }));
        return new NextIterator<ByteArrayPair>(this, iter){
            private final /* synthetic */ RocksDB $outer;
            private final RocksIterator iter$1;

            public ByteArrayPair getNext() {
                ByteArrayPair byteArrayPair;
                if (this.iter$1.isValid()) {
                    this.$outer.org$apache$spark$sql$execution$streaming$state$RocksDB$$byteArrayPair().set(this.iter$1.key(), this.iter$1.value());
                    this.iter$1.next();
                    byteArrayPair = this.$outer.org$apache$spark$sql$execution$streaming$state$RocksDB$$byteArrayPair();
                } else {
                    this.finished_$eq(true);
                    this.iter$1.close();
                    byteArrayPair = null;
                }
                return byteArrayPair;
            }

            public void close() {
                this.iter$1.close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.iter$1 = iter$1;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private long countKeys() {
        void v0;
        try (RocksIterator iter = this.db().newIterator();){
            void var2_2;
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Counting keys - getting iterator from version ").append(this.loadedVersion()).toString());
            iter.seekToFirst();
            long keys = 0L;
            while (iter.isValid()) {
                ++keys;
                iter.next();
            }
            v0 = var2_2;
        }
        return (long)v0;
    }

    public Iterator<ByteArrayPair> prefixScan(byte[] prefix) {
        long threadId = Thread.currentThread().getId();
        RocksIterator iter = this.prefixScanReuseIter().computeIfAbsent(BoxesRunTime.boxToLong((long)threadId), tid -> RocksDB.$anonfun$prefixScan$1(this, BoxesRunTime.unboxToLong((Object)tid)));
        iter.seek(prefix);
        return new NextIterator<ByteArrayPair>(this, iter, prefix){
            private final /* synthetic */ RocksDB $outer;
            private final RocksIterator iter$2;
            private final byte[] prefix$1;

            public ByteArrayPair getNext() {
                ByteArrayPair byteArrayPair;
                if (this.iter$2.isValid() && new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(this.iter$2.key())).take(this.prefix$1.length))).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(this.prefix$1))) {
                    this.$outer.org$apache$spark$sql$execution$streaming$state$RocksDB$$byteArrayPair().set(this.iter$2.key(), this.iter$2.value());
                    this.iter$2.next();
                    byteArrayPair = this.$outer.org$apache$spark$sql$execution$streaming$state$RocksDB$$byteArrayPair();
                } else {
                    this.finished_$eq(true);
                    byteArrayPair = null;
                }
                return byteArrayPair;
            }

            public void close() {
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.iter$2 = iter$2;
                this.prefix$1 = prefix$1;
            }
        };
    }

    public long commit() {
        long l;
        long newVersion = this.loadedVersion() + 1L;
        File checkpointDir = this.createTempDir("checkpoint");
        try {
            try {
                long l2;
                Utils$.MODULE$.deleteRecursively(checkpointDir);
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Writing updates for ").append(newVersion).toString());
                long writeTimeMs = this.timeTakenMs((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.db().write(this.writeOptions(), this.writeBatch()));
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Flushing updates for ").append(newVersion).toString());
                long flushTimeMs = this.timeTakenMs((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.db().flush(this.flushOptions()));
                if (this.conf().compactOnCommit()) {
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Compacting");
                    l2 = this.timeTakenMs((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.db().compactRange());
                } else {
                    l2 = 0L;
                }
                long compactTimeMs = l2;
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Pausing background work");
                long pauseTimeMs = this.timeTakenMs((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.db().pauseBackgroundWork());
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Creating checkpoint for ").append(newVersion).append(" in ").append(checkpointDir).toString());
                long checkpointTimeMs = this.timeTakenMs((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    Checkpoint cp = Checkpoint.create((org.rocksdb.RocksDB)this.db());
                    cp.createCheckpoint(checkpointDir.toString());
                });
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Syncing checkpoint for ").append(newVersion).append(" to DFS").toString());
                long fileSyncTimeMs = this.timeTakenMs((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.fileManager().saveCheckpointToDfs(checkpointDir, newVersion, this.numKeysOnWritingVersion()));
                this.numKeysOnLoadedVersion_$eq(this.numKeysOnWritingVersion());
                this.loadedVersion_$eq(newVersion);
                this.fileManagerMetrics_$eq(this.fileManager().latestSaveCheckpointMetrics());
                this.commitLatencyMs().$plus$plus$eq((TraversableOnce)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"writeBatch"), (Object)BoxesRunTime.boxToLong((long)writeTimeMs)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"flush"), (Object)BoxesRunTime.boxToLong((long)flushTimeMs)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"compact"), (Object)BoxesRunTime.boxToLong((long)compactTimeMs)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pause"), (Object)BoxesRunTime.boxToLong((long)pauseTimeMs)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"checkpoint"), (Object)BoxesRunTime.boxToLong((long)checkpointTimeMs)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fileSync"), (Object)BoxesRunTime.boxToLong((long)fileSyncTimeMs))})));
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Committed ").append(newVersion).append(", stats = ").append(this.metrics().json()).toString());
                l = this.loadedVersion();
            }
            catch (Throwable t) {
                this.loadedVersion_$eq(-1L);
                throw t;
            }
        }
        finally {
            this.db().continueBackgroundWork();
            this.silentDeleteRecursively(checkpointDir, new StringBuilder(11).append("committing ").append(newVersion).toString());
            this.release();
        }
        return l;
    }

    public void rollback() {
        this.closePrefixScanIterators();
        this.writeBatch().clear();
        this.numKeysOnWritingVersion_$eq(this.numKeysOnLoadedVersion());
        this.release();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Rolled back to ").append(this.loadedVersion()).toString());
    }

    public void cleanup() {
        long cleanupTime = this.timeTakenMs((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.fileManager().deleteOldVersions(this.conf().minVersionsToRetain()));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Cleaned old data, time taken: ").append(cleanupTime).append(" ms").toString());
    }

    public void close() {
        this.closePrefixScanIterators();
        try {
            this.closeDB();
            this.writeBatch().clear();
            this.writeBatch().close();
            this.readOptions().close();
            this.writeOptions().close();
            this.flushOptions().close();
            this.org$apache$spark$sql$execution$streaming$state$RocksDB$$dbOptions().close();
            this.dbLogger().close();
            this.silentDeleteRecursively(this.localRootDir, "closing RocksDB");
        }
        catch (Exception e) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error closing RocksDB", e);
        }
    }

    public long getLatestVersion() {
        return this.fileManager().getLatestVersion();
    }

    public RocksDBMetrics metrics() {
        long totalSSTFilesBytes = this.getDBProperty("rocksdb.total-sst-files-size");
        long readerMemUsage = this.getDBProperty("rocksdb.estimate-table-readers-mem");
        long memTableMemUsage = this.getDBProperty("rocksdb.size-all-mem-tables");
        long blockCacheUsage = this.getDBProperty("rocksdb.block-cache-usage");
        long writeBatchMemUsage = this.writeBatch().getWriteBatch().getDataSize();
        scala.collection.immutable.Map nativeOpsHistograms = ((TraversableOnce)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"get"), (Object)HistogramType.DB_GET), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"put"), (Object)HistogramType.DB_WRITE), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"compaction"), (Object)HistogramType.COMPACTION_TIME), (List)Nil$.MODULE$)))).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map nativeOpsLatencyMicros = nativeOpsHistograms.mapValues((Function1 & Serializable & scala.Serializable)typ -> RocksDBNativeHistogram$.MODULE$.apply(this.nativeStats().getHistogramData(typ)));
        scala.collection.immutable.Map nativeOpsMetricTickers = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"readBlockCacheMissCount"), (Object)TickerType.BLOCK_CACHE_MISS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"readBlockCacheHitCount"), (Object)TickerType.BLOCK_CACHE_HIT), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"totalBytesRead"), (Object)TickerType.BYTES_READ), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"totalBytesWritten"), (Object)TickerType.BYTES_WRITTEN), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"totalBytesReadThroughIterator"), (Object)TickerType.ITER_BYTES_READ), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"writerStallDuration"), (Object)TickerType.STALL_MICROS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"totalBytesReadByCompaction"), (Object)TickerType.COMPACT_READ_BYTES), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"totalBytesWrittenByCompaction"), (Object)TickerType.COMPACT_WRITE_BYTES)}))).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map nativeOpsMetrics = nativeOpsMetricTickers.mapValues((Function1 & Serializable & scala.Serializable)typ -> BoxesRunTime.boxToLong((long)RocksDB.$anonfun$metrics$2(this, typ)));
        long x$1 = this.numKeysOnLoadedVersion();
        long x$2 = this.numKeysOnWritingVersion();
        long x$3 = readerMemUsage + memTableMemUsage + blockCacheUsage + writeBatchMemUsage;
        long x$4 = writeBatchMemUsage;
        long x$5 = totalSSTFilesBytes;
        scala.collection.immutable.Map x$6 = nativeOpsLatencyMicros.toMap(Predef$.MODULE$.$conforms());
        HashMap<String, Object> x$7 = this.commitLatencyMs();
        long x$8 = this.fileManagerMetrics().bytesCopied();
        long x$9 = this.fileManagerMetrics().filesCopied();
        long x$10 = this.fileManagerMetrics().filesReused();
        Option<Object> x$11 = this.fileManagerMetrics().zipFileBytesUncompressed();
        scala.collection.immutable.Map x$12 = nativeOpsMetrics.toMap(Predef$.MODULE$.$conforms());
        return new RocksDBMetrics(x$1, x$2, x$3, x$4, x$5, (Map<String, RocksDBNativeHistogram>)x$6, (Map<String, Object>)x$7, x$9, x$8, x$10, x$11, (Map<String, Object>)x$12);
    }

    private void acquire() {
        Object object = this.acquireLock();
        synchronized (object) {
            AcquiredThreadInfo newAcquiredThreadInfo = new AcquiredThreadInfo();
            long waitStartTime = System.currentTimeMillis();
            while (this.isAcquiredByDifferentThread$1(newAcquiredThreadInfo) && RocksDB.timeWaitedMs$1(waitStartTime) < this.conf().lockAcquireTimeoutMs()) {
                this.acquireLock().wait(10L);
            }
            if (this.isAcquiredByDifferentThread$1(newAcquiredThreadInfo)) {
                String stackTraceOutput = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((Thread)this.acquiredThreadInfo().threadRef().get().get()).getStackTrace())).mkString("\n");
                String msg = new StringBuilder(116).append("RocksDB instance could not be acquired by ").append(newAcquiredThreadInfo).append(" as it ").append("was not released by ").append(this.acquiredThreadInfo()).append(" after ").append(RocksDB.timeWaitedMs$1(waitStartTime)).append(" ms.\n").append("Thread holding the lock has trace: ").append(stackTraceOutput).toString();
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg);
                throw new IllegalStateException(new StringBuilder(2).append(this.loggingId).append(": ").append(msg).toString());
            }
            this.acquiredThreadInfo_$eq(newAcquiredThreadInfo);
            Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1 & Serializable & scala.Serializable)x$2 -> x$2.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$3 -> {
                this.release();
                return BoxedUnit.UNIT;
            }));
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("RocksDB instance was acquired by ").append(this.acquiredThreadInfo()).toString());
        }
    }

    private void release() {
        Object object = this.acquireLock();
        synchronized (object) {
            this.acquiredThreadInfo_$eq(null);
            this.acquireLock().notifyAll();
        }
    }

    private void closePrefixScanIterators() {
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(this.prefixScanReuseIter().entrySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            RocksDB.$anonfun$closePrefixScanIterators$1(x$4);
            return BoxedUnit.UNIT;
        });
        this.prefixScanReuseIter().clear();
    }

    private long getDBProperty(String property) {
        return new StringOps(Predef$.MODULE$.augmentString(this.db().getProperty(property))).toLong();
    }

    private void openDB() {
        Predef$.MODULE$.assert(this.db() == null);
        this.db_$eq(org.rocksdb.RocksDB.open((Options)this.org$apache$spark$sql$execution$streaming$state$RocksDB$$dbOptions(), (String)this.workingDir().toString()));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Opened DB with conf ").append(this.conf()).toString());
    }

    private void closeDB() {
        block0: {
            if (this.db() == null) break block0;
            this.db().close();
            this.db_$eq(null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private org.rocksdb.Logger createLogger() {
        void var1_1;
        org.rocksdb.Logger dbLogger = new org.rocksdb.Logger(this){
            private final /* synthetic */ RocksDB $outer;

            public void log(InfoLogLevel infoLogLevel, String logMsg) {
                Function1 & Serializable & scala.Serializable intersect;
                InfoLogLevel infoLogLevel2 = infoLogLevel;
                boolean bl = InfoLogLevel.FATAL_LEVEL.equals(infoLogLevel2) ? true : InfoLogLevel.ERROR_LEVEL.equals(infoLogLevel2);
                if (bl) {
                    intersect = (Function1 & Serializable & scala.Serializable)x$5 -> {
                        $anon$3.$anonfun$log$1(this, x$5);
                        return BoxedUnit.UNIT;
                    };
                } else {
                    boolean bl2 = InfoLogLevel.WARN_LEVEL.equals(infoLogLevel2) ? true : InfoLogLevel.INFO_LEVEL.equals(infoLogLevel2);
                    intersect = bl2 ? (Function1 & Serializable & scala.Serializable)x$6 -> {
                        $anon$3.$anonfun$log$2(this, x$6);
                        return BoxedUnit.UNIT;
                    } : (InfoLogLevel.DEBUG_LEVEL.equals(infoLogLevel2) ? (Function1 & Serializable & scala.Serializable)x$7 -> {
                        $anon$3.$anonfun$log$3(this, x$7);
                        return BoxedUnit.UNIT;
                    } : (Function1 & Serializable & scala.Serializable)x$8 -> {
                        $anon$3.$anonfun$log$4(this, x$8);
                        return BoxedUnit.UNIT;
                    });
                }
                Function1 & Serializable & scala.Serializable loggingFunc = intersect;
                loggingFunc.apply((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("[NativeRocksDB-").append(infoLogLevel.getValue()).append("] ").append(logMsg).toString());
            }

            public static final /* synthetic */ void $anonfun$log$1($anon$3 $this, Function0 x$5) {
                $this.$outer.logError((Function0<String>)x$5);
            }

            public static final /* synthetic */ void $anonfun$log$2($anon$3 $this, Function0 x$6) {
                $this.$outer.logInfo((Function0<String>)x$6);
            }

            public static final /* synthetic */ void $anonfun$log$3($anon$3 $this, Function0 x$7) {
                $this.$outer.logDebug((Function0<String>)x$7);
            }

            public static final /* synthetic */ void $anonfun$log$4($anon$3 $this, Function0 x$8) {
                $this.$outer.logTrace((Function0<String>)x$8);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer.org$apache$spark$sql$execution$streaming$state$RocksDB$$dbOptions());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$log$1$adapted(org.apache.spark.sql.execution.streaming.state.RocksDB$$anon$3 scala.Function0 ), $anonfun$log$2$adapted(org.apache.spark.sql.execution.streaming.state.RocksDB$$anon$3 scala.Function0 ), $anonfun$log$3$adapted(org.apache.spark.sql.execution.streaming.state.RocksDB$$anon$3 scala.Function0 ), $anonfun$log$4$adapted(org.apache.spark.sql.execution.streaming.state.RocksDB$$anon$3 scala.Function0 ), $anonfun$log$5(org.rocksdb.InfoLogLevel java.lang.String )}, serializedLambda);
            }
        };
        ObjectRef dbLogLevel = ObjectRef.create((Object)InfoLogLevel.ERROR_LEVEL);
        if (this.log().isWarnEnabled()) {
            dbLogLevel.elem = InfoLogLevel.WARN_LEVEL;
        }
        if (this.log().isInfoEnabled()) {
            dbLogLevel.elem = InfoLogLevel.INFO_LEVEL;
        }
        if (this.log().isDebugEnabled()) {
            dbLogLevel.elem = InfoLogLevel.DEBUG_LEVEL;
        }
        this.org$apache$spark$sql$execution$streaming$state$RocksDB$$dbOptions().setLogger(dbLogger);
        this.org$apache$spark$sql$execution$streaming$state$RocksDB$$dbOptions().setInfoLogLevel((InfoLogLevel)dbLogLevel.elem);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Set RocksDB native logging level to ").append((InfoLogLevel)dbLogLevel$1.elem).toString());
        return var1_1;
    }

    private File createTempDir(String prefix) {
        return Utils$.MODULE$.createDirectory(this.localRootDir.getAbsolutePath(), prefix);
    }

    private void silentDeleteRecursively(File file, String msg) {
        try {
            Utils$.MODULE$.deleteRecursively(file);
        }
        catch (Exception e) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Error recursively deleting local dir ").append(file).append(" while ").append(msg).toString(), e);
        }
    }

    public long timeTakenMs(Function0<BoxedUnit> body) {
        return Utils$.MODULE$.timeTakenMs(body)._2$mcJ$sp();
    }

    public String logName() {
        return new StringBuilder(1).append(Logging.logName$((Logging)this)).append(" ").append(this.loggingId).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ RocksIterator $anonfun$prefixScan$1(RocksDB $this, long tid) {
        void var3_2;
        RocksIterator it = $this.writeBatch().newIteratorWithBase($this.db().newIterator());
        $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Getting iterator from version ").append($this.loadedVersion()).append(" for prefix scan on ").append("thread ID ").append(tid).toString());
        return var3_2;
    }

    public static final /* synthetic */ long $anonfun$metrics$2(RocksDB $this, TickerType typ) {
        return $this.nativeStats().getTickerCount(typ);
    }

    private static final long timeWaitedMs$1(long waitStartTime$1) {
        return System.currentTimeMillis() - waitStartTime$1;
    }

    private final boolean isAcquiredByDifferentThread$1(AcquiredThreadInfo newAcquiredThreadInfo$1) {
        return this.acquiredThreadInfo() != null && this.acquiredThreadInfo().threadRef().get().isDefined() && ((Thread)newAcquiredThreadInfo$1.threadRef().get().get()).getId() != ((Thread)this.acquiredThreadInfo().threadRef().get().get()).getId();
    }

    public static final /* synthetic */ void $anonfun$closePrefixScanIterators$1(Map.Entry x$4) {
        ((AbstractImmutableNativeReference)x$4.getValue()).close();
    }

    public RocksDB(String dfsRootDir, RocksDBConf conf, File localRootDir, Configuration hadoopConf, String loggingId) {
        this.conf = conf;
        this.localRootDir = localRootDir;
        this.loggingId = loggingId;
        Logging.$init$((Logging)this);
        RocksDBLoader$.MODULE$.loadLibrary();
        this.readOptions = new ReadOptions();
        this.writeOptions = new WriteOptions().setSync(true);
        this.flushOptions = new FlushOptions().setWaitForFlush(true);
        this.writeBatch = new WriteBatchWithIndex(true);
        this.bloomFilter = new BloomFilter();
        this.tableFormatConfig = new BlockBasedTableConfig();
        this.tableFormatConfig().setBlockSize(conf.blockSizeKB() * 1024L);
        this.tableFormatConfig().setBlockCache((Cache)new LRUCache(conf.blockCacheSizeMB() * 1024L * 1024L));
        this.tableFormatConfig().setFilterPolicy((Filter)this.bloomFilter());
        this.tableFormatConfig().setFormatVersion(conf.formatVersion());
        this.org$apache$spark$sql$execution$streaming$state$RocksDB$$dbOptions = new Options();
        this.org$apache$spark$sql$execution$streaming$state$RocksDB$$dbOptions().setCreateIfMissing(true);
        this.org$apache$spark$sql$execution$streaming$state$RocksDB$$dbOptions().setTableFormatConfig((TableFormatConfig)this.tableFormatConfig());
        this.dbLogger = this.createLogger();
        this.org$apache$spark$sql$execution$streaming$state$RocksDB$$dbOptions().setStatistics(new Statistics());
        this.nativeStats = this.org$apache$spark$sql$execution$streaming$state$RocksDB$$dbOptions().statistics();
        this.workingDir = this.createTempDir("workingDir");
        this.fileManager = new RocksDBFileManager(dfsRootDir, this.createTempDir("fileManager"), hadoopConf, loggingId);
        this.org$apache$spark$sql$execution$streaming$state$RocksDB$$byteArrayPair = new ByteArrayPair(ByteArrayPair$.MODULE$.$lessinit$greater$default$1(), ByteArrayPair$.MODULE$.$lessinit$greater$default$2());
        this.commitLatencyMs = new HashMap();
        this.acquireLock = new Object();
        this.loadedVersion = -1L;
        this.numKeysOnLoadedVersion = 0L;
        this.numKeysOnWritingVersion = 0L;
        this.fileManagerMetrics = RocksDBFileManagerMetrics$.MODULE$.EMPTY_METRICS();
        this.prefixScanReuseIter = new ConcurrentHashMap();
    }
}

