/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import java.util.Date;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskOutputFileAlreadyExistException;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.io.FileCommitProtocol;
import org.apache.spark.internal.io.SparkHadoopWriterUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.shuffle.FetchFailedException;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.Ascending$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.AttributeSet$;
import org.apache.spark.sql.catalyst.expressions.BindReferences$;
import org.apache.spark.sql.catalyst.expressions.BitwiseAnd;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.FileSourceMetadataAttribute$;
import org.apache.spark.sql.catalyst.expressions.HiveHash;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.Pmod;
import org.apache.spark.sql.catalyst.expressions.Pmod$;
import org.apache.spark.sql.catalyst.expressions.SortDirection;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.SortOrder$;
import org.apache.spark.sql.catalyst.expressions.package$;
import org.apache.spark.sql.catalyst.plans.physical.HashPartitioning;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.ProjectExec;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.SortExec;
import org.apache.spark.sql.execution.SortExec$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.UnsafeExternalRowSorter;
import org.apache.spark.sql.execution.datasources.BaseDynamicPartitionDataWriter;
import org.apache.spark.sql.execution.datasources.BucketingUtils$;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.DynamicPartitionDataConcurrentWriter;
import org.apache.spark.sql.execution.datasources.DynamicPartitionDataConcurrentWriter$;
import org.apache.spark.sql.execution.datasources.DynamicPartitionDataSingleWriter;
import org.apache.spark.sql.execution.datasources.DynamicPartitionDataSingleWriter$;
import org.apache.spark.sql.execution.datasources.EmptyDirectoryDataWriter;
import org.apache.spark.sql.execution.datasources.EmptyDirectoryDataWriter$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.FileFormatDataWriter;
import org.apache.spark.sql.execution.datasources.FileFormatWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.SingleDirectoryDataWriter;
import org.apache.spark.sql.execution.datasources.SingleDirectoryDataWriter$;
import org.apache.spark.sql.execution.datasources.WriteJobDescription;
import org.apache.spark.sql.execution.datasources.WriteJobStatsTracker;
import org.apache.spark.sql.execution.datasources.WriteTaskResult;
import org.apache.spark.sql.execution.datasources.WriteTaskStats;
import org.apache.spark.sql.execution.datasources.WriterBucketSpec;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class FileFormatWriter$
implements Logging {
    public static FileFormatWriter$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new FileFormatWriter$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Set<String> write(SparkSession sparkSession, SparkPlan plan, FileFormat fileFormat, FileCommitProtocol committer, FileFormatWriter.OutputSpec outputSpec, Configuration hadoopConf, Seq<Attribute> partitionColumns, Option<BucketSpec> bucketSpec, Seq<WriteJobStatsTracker> statsTrackers, Map<String, String> options) {
        Set set;
        Job job = Job.getInstance((Configuration)hadoopConf);
        job.setOutputKeyClass(Void.class);
        job.setOutputValueClass(InternalRow.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(outputSpec.outputPath()));
        AttributeSet partitionSet = AttributeSet$.MODULE$.apply(partitionColumns);
        Seq x$1 = (Seq)outputSpec.outputColumns().map((Function1 & Serializable & scala.Serializable)attr -> FileSourceMetadataAttribute$.MODULE$.cleanupFileSourceMetadataInformation(attr), Seq$.MODULE$.canBuildFrom());
        String x$2 = outputSpec.copy$default$1();
        Map<Map<String, String>, String> x$3 = outputSpec.copy$default$2();
        FileFormatWriter.OutputSpec finalOutputSpec = outputSpec.copy(x$2, x$3, (Seq<Attribute>)x$1);
        Seq dataColumns = (Seq)finalOutputSpec.outputColumns().filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)partitionSet.contains(elem)));
        BooleanRef needConvert = BooleanRef.create((boolean)false);
        Seq projectList = (Seq)plan.output().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Attribute attribute = x0$1;
            if (!partitionSet.contains((NamedExpression)attribute)) return attribute;
            DataType dataType = attribute.dataType();
            StringType$ stringType$ = StringType$.MODULE$;
            if (dataType == null) {
                if (stringType$ != null) {
                    return attribute;
                }
            } else if (!dataType.equals(stringType$)) return attribute;
            if (!attribute.nullable()) return attribute;
            needConvert$1.elem = true;
            FileFormatWriter.Empty2Null x$4 = new FileFormatWriter.Empty2Null((Expression)attribute);
            String x$5 = attribute.name();
            ExprId x$6 = Alias$.MODULE$.apply$default$3((Expression)x$4, x$5);
            Seq x$7 = Alias$.MODULE$.apply$default$4((Expression)x$4, x$5);
            Option x$8 = Alias$.MODULE$.apply$default$5((Expression)x$4, x$5);
            Seq x$9 = Alias$.MODULE$.apply$default$6((Expression)x$4, x$5);
            return new Alias((Expression)x$4, x$5, x$6, x$7, x$8, x$9);
        }, Seq$.MODULE$.canBuildFrom());
        SparkPlan empty2NullPlan = needConvert.elem ? new ProjectExec((Seq<NamedExpression>)projectList, plan) : plan;
        Option writerBucketSpec = bucketSpec.map((Function1 & Serializable & scala.Serializable)spec -> {
            WriterBucketSpec writerBucketSpec;
            Seq bucketColumns = (Seq)spec.bucketColumnNames().map((Function1 & Serializable & scala.Serializable)c -> (Attribute)dataColumns.find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FileFormatWriter$.$anonfun$write$6(c, x$1))).get(), Seq$.MODULE$.canBuildFrom());
            Object object = options.getOrElse((Object)BucketingUtils$.MODULE$.optionForHiveCompatibleBucketWrite(), (Function0 & Serializable & scala.Serializable)() -> "false");
            String string = "true";
            if (!(object != null ? !object.equals(string) : string != null)) {
                BitwiseAnd hashId = new BitwiseAnd((Expression)new HiveHash(bucketColumns), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE)));
                Pmod bucketIdExpression = new Pmod((Expression)hashId, (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)spec.numBuckets())), Pmod$.MODULE$.apply$default$3());
                Function1 & Serializable & scala.Serializable fileNamePrefix = (Function1 & Serializable & scala.Serializable)bucketId -> FileFormatWriter$.$anonfun$write$8(BoxesRunTime.unboxToInt((Object)bucketId));
                writerBucketSpec = new WriterBucketSpec((Expression)bucketIdExpression, (Function1<Object, String>)fileNamePrefix);
            } else {
                Expression bucketIdExpression = new HashPartitioning(bucketColumns, spec.numBuckets()).partitionIdExpression();
                writerBucketSpec = new WriterBucketSpec(bucketIdExpression, (Function1<Object, String>)(Function1 & Serializable & scala.Serializable)x$2 -> FileFormatWriter$.$anonfun$write$9(BoxesRunTime.unboxToInt((Object)x$2)));
            }
            return writerBucketSpec;
        });
        Seq sortColumns = (Seq)Option$.MODULE$.option2Iterable(bucketSpec).toSeq().flatMap((Function1 & Serializable & scala.Serializable)spec -> (Seq)spec.sortColumnNames().map((Function1 & Serializable & scala.Serializable)c -> (Attribute)dataColumns.find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)FileFormatWriter$.$anonfun$write$12(c, x$3))).get(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        CaseInsensitiveMap caseInsensitiveOptions = CaseInsensitiveMap$.MODULE$.apply(options);
        StructType dataSchema = package$.MODULE$.AttributeSeq(dataColumns).toStructType();
        DataSourceUtils$.MODULE$.verifySchema(fileFormat, dataSchema);
        OutputWriterFactory outputWriterFactory = fileFormat.prepareWrite(sparkSession, job, (Map<String, String>)caseInsensitiveOptions, dataSchema);
        WriteJobDescription description = new WriteJobDescription(UUID.randomUUID().toString(), new SerializableConfiguration(job.getConfiguration()), outputWriterFactory, finalOutputSpec.outputColumns(), (Seq<Attribute>)dataColumns, partitionColumns, (Option<WriterBucketSpec>)writerBucketSpec, finalOutputSpec.outputPath(), finalOutputSpec.customPartitionLocations(), BoxesRunTime.unboxToLong((Object)caseInsensitiveOptions.get("maxRecordsPerFile").map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)FileFormatWriter$.$anonfun$write$13(x$4))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> sparkSession.sessionState().conf().maxRecordsPerFile())), (String)caseInsensitiveOptions.get(DateTimeUtils$.MODULE$.TIMEZONE_OPTION()).getOrElse((Function0 & Serializable & scala.Serializable)() -> sparkSession.sessionState().conf().sessionLocalTimeZone()), statsTrackers);
        Seq requiredOrdering = (Seq)((TraversableLike)partitionColumns.$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(writerBucketSpec.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.bucketIdExpression())), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)sortColumns, Seq$.MODULE$.canBuildFrom());
        Seq actualOrdering = (Seq)empty2NullPlan.outputOrdering().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.child(), Seq$.MODULE$.canBuildFrom());
        boolean orderingMatched = requiredOrdering.length() > actualOrdering.length() ? false : ((IterableLike)requiredOrdering.zip((GenIterable)actualOrdering, Seq$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)FileFormatWriter$.$anonfun$write$18(x0$2)));
        SQLExecution$.MODULE$.checkSQLExecutionId(sparkSession);
        job.getConfiguration().set("spark.sql.sources.writeJobUUID", description.uuid());
        committer.setupJob((JobContext)job);
        try {
            long duration;
            Tuple2 tuple2;
            Tuple2 tuple22;
            if (orderingMatched) {
                tuple22 = new Tuple2(empty2NullPlan.execute(), (Object)None$.MODULE$);
            } else {
                Seq orderingExpr = BindReferences$.MODULE$.bindReferences((Seq)requiredOrdering.map((Function1 & Serializable & scala.Serializable)x$7 -> SortOrder$.MODULE$.apply(x$7, (SortDirection)Ascending$.MODULE$, SortOrder$.MODULE$.apply$default$3()), Seq$.MODULE$.canBuildFrom()), package$.MODULE$.AttributeSeq(finalOutputSpec.outputColumns()));
                SortExec sortPlan = new SortExec((Seq<SortOrder>)orderingExpr, false, empty2NullPlan, SortExec$.MODULE$.apply$default$4());
                int maxWriters = sparkSession.sessionState().conf().maxConcurrentOutputFileWriters();
                boolean concurrentWritersEnabled = maxWriters > 0 && sortColumns.isEmpty();
                tuple22 = tuple2 = concurrentWritersEnabled ? new Tuple2(empty2NullPlan.execute(), (Object)new Some((Object)new FileFormatWriter.ConcurrentOutputWriterSpec(maxWriters, (Function0<UnsafeExternalRowSorter>)(Function0 & Serializable & scala.Serializable)() -> sortPlan.createSorter()))) : new Tuple2(sortPlan.execute(), (Object)None$.MODULE$);
            }
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            RDD rdd = (RDD)tuple2._1();
            Option concurrentOutputWriterSpec = (Option)tuple2._2();
            Tuple2 tuple23 = new Tuple2((Object)rdd, (Object)concurrentOutputWriterSpec);
            Tuple2 tuple24 = tuple23;
            RDD rdd2 = (RDD)tuple24._1();
            Option concurrentOutputWriterSpec2 = (Option)tuple24._2();
            RDD rddWithNonEmptyPartitions = rdd2.partitions().length == 0 ? sparkSession.sparkContext().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(InternalRow.class))), 1, ClassTag$.MODULE$.apply(InternalRow.class)) : rdd2;
            long jobIdInstant = new Date().getTime();
            WriteTaskResult[] ret = new WriteTaskResult[rddWithNonEmptyPartitions.partitions().length];
            sparkSession.sparkContext().runJob(rddWithNonEmptyPartitions, (Function2 & Serializable & scala.Serializable)(taskContext, iter) -> MODULE$.executeTask(description, jobIdInstant, taskContext.stageId(), taskContext.partitionId(), (int)taskContext.taskAttemptId() & Integer.MAX_VALUE, committer, (Iterator<InternalRow>)iter, (Option<FileFormatWriter.ConcurrentOutputWriterSpec>)concurrentOutputWriterSpec2), (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rddWithNonEmptyPartitions.partitions())).indices(), (Function2 & Serializable & scala.Serializable)(index, res) -> {
                FileFormatWriter$.$anonfun$write$22(committer, ret, BoxesRunTime.unboxToInt((Object)index), res);
                return BoxedUnit.UNIT;
            }, ClassTag$.MODULE$.apply(WriteTaskResult.class));
            FileCommitProtocol.TaskCommitMessage[] commitMsgs = (FileCommitProtocol.TaskCommitMessage[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ret)).map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.commitMsg(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileCommitProtocol.TaskCommitMessage.class)));
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Start to commit write Job ").append(description.uuid()).append(".").toString());
            Tuple2 tuple25 = Utils$.MODULE$.timeTakenMs((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> committer.commitJob((JobContext)job, (Seq)Predef$.MODULE$.wrapRefArray((Object[])commitMsgs)));
            if (tuple25 == null) {
                throw new MatchError((Object)tuple25);
            }
            long l = duration = tuple25._2$mcJ$sp();
            long duration2 = l;
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Write Job ").append(description.uuid()).append(" committed. Elapsed time: ").append(duration2).append(" ms.").toString());
            this.processStats(description.statsTrackers(), (Seq<Seq<WriteTaskStats>>)((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ret)).map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.summary().stats(), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))), duration2);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Finished processing stats for write job ").append(description.uuid()).append(".").toString());
            set = (Set)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ret)).map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.summary().updatedPartitions(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Set.class))))).reduceOption((Function2 & Serializable & scala.Serializable)(x$12, x$13) -> (Set)x$12.$plus$plus((GenTraversableOnce)x$13)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty());
        }
        catch (Throwable cause) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(14).append("Aborting job ").append(description.uuid()).append(".").toString(), cause);
            committer.abortJob((JobContext)job);
            throw QueryExecutionErrors$.MODULE$.jobAbortedError(cause);
        }
        return set;
    }

    private WriteTaskResult executeTask(WriteJobDescription description, long jobIdInstant, int sparkStageId, int sparkPartitionId, int sparkAttemptNumber, FileCommitProtocol committer, Iterator<InternalRow> iterator, Option<FileFormatWriter.ConcurrentOutputWriterSpec> concurrentOutputWriterSpec) {
        WriteTaskResult writeTaskResult;
        FileFormatDataWriter fileFormatDataWriter;
        JobID jobId = SparkHadoopWriterUtils$.MODULE$.createJobID(new Date(jobIdInstant), sparkStageId);
        TaskID taskId = new TaskID((org.apache.hadoop.mapreduce.JobID)jobId, TaskType.MAP, sparkPartitionId);
        TaskAttemptID taskAttemptId = new TaskAttemptID(taskId, sparkAttemptNumber);
        Configuration hadoopConf = description.serializableHadoopConf().value();
        hadoopConf.set("mapreduce.job.id", jobId.toString());
        hadoopConf.set("mapreduce.task.id", taskAttemptId.getTaskID().toString());
        hadoopConf.set("mapreduce.task.attempt.id", taskAttemptId.toString());
        hadoopConf.setBoolean("mapreduce.task.ismap", true);
        hadoopConf.setInt("mapreduce.task.partition", 0);
        TaskAttemptContextImpl taskAttemptContext = new TaskAttemptContextImpl(hadoopConf, taskAttemptId);
        committer.setupTask((TaskAttemptContext)taskAttemptContext);
        if (sparkPartitionId != 0 && !iterator.hasNext()) {
            fileFormatDataWriter = new EmptyDirectoryDataWriter(description, (TaskAttemptContext)taskAttemptContext, committer, EmptyDirectoryDataWriter$.MODULE$.$lessinit$greater$default$4());
        } else if (description.partitionColumns().isEmpty() && description.bucketSpec().isEmpty()) {
            fileFormatDataWriter = new SingleDirectoryDataWriter(description, (TaskAttemptContext)taskAttemptContext, committer, SingleDirectoryDataWriter$.MODULE$.$lessinit$greater$default$4());
        } else {
            BaseDynamicPartitionDataWriter baseDynamicPartitionDataWriter;
            Option<FileFormatWriter.ConcurrentOutputWriterSpec> option = concurrentOutputWriterSpec;
            if (option instanceof Some) {
                Some some = (Some)option;
                FileFormatWriter.ConcurrentOutputWriterSpec spec = (FileFormatWriter.ConcurrentOutputWriterSpec)some.value();
                baseDynamicPartitionDataWriter = new DynamicPartitionDataConcurrentWriter(description, (TaskAttemptContext)taskAttemptContext, committer, spec, DynamicPartitionDataConcurrentWriter$.MODULE$.$lessinit$greater$default$5());
            } else {
                baseDynamicPartitionDataWriter = new DynamicPartitionDataSingleWriter(description, (TaskAttemptContext)taskAttemptContext, committer, DynamicPartitionDataSingleWriter$.MODULE$.$lessinit$greater$default$4());
            }
            fileFormatDataWriter = baseDynamicPartitionDataWriter;
        }
        FileFormatDataWriter dataWriter = fileFormatDataWriter;
        try {
            writeTaskResult = (WriteTaskResult)Utils$.MODULE$.tryWithSafeFinallyAndFailureCallbacks((Function0 & Serializable & scala.Serializable)() -> {
                dataWriter.writeWithIterator(iterator);
                long waitingTimeForInit = SparkEnv$.MODULE$.get().conf().getLong("spark.mapr.commitDelay", 0L);
                Thread.sleep(waitingTimeForInit);
                return dataWriter.commit();
            }, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                dataWriter.abort();
                MODULE$.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("Job ").append(jobId).append(" aborted.").toString());
            }, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> dataWriter.close());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof FetchFailedException) {
                FetchFailedException fetchFailedException = (FetchFailedException)throwable2;
                throw fetchFailedException;
            }
            if (throwable2 instanceof FileAlreadyExistsException) {
                FileAlreadyExistsException fileAlreadyExistsException = (FileAlreadyExistsException)throwable2;
                if (SQLConf$.MODULE$.get().fastFailFileFormatOutput()) {
                    throw new TaskOutputFileAlreadyExistException((Throwable)fileAlreadyExistsException);
                }
            }
            if (throwable2 != null) {
                Throwable throwable3 = throwable2;
                throw QueryExecutionErrors$.MODULE$.taskFailedWhileWritingRowsError(throwable3);
            }
            throw throwable;
        }
        return writeTaskResult;
    }

    public void processStats(Seq<WriteJobStatsTracker> statsTrackers, Seq<Seq<WriteTaskStats>> statsPerTask, long jobCommitDuration) {
        int numStatsTrackers = statsTrackers.length();
        Predef$.MODULE$.assert(statsPerTask.forall((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)FileFormatWriter$.$anonfun$processStats$1(numStatsTrackers, x$14))), (Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(178).append("Every WriteTask should have produced one `WriteTaskStats` object for every tracker.\n         |There are ").append(numStatsTrackers).append(" statsTrackers, but some task returned\n         |").append(((SeqLike)statsPerTask.find((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)FileFormatWriter$.$anonfun$processStats$3(numStatsTrackers, x$15))).get()).length()).append(" results instead.\n       ").toString())).stripMargin());
        Seq statsPerTracker = statsPerTask.nonEmpty() ? (Seq)statsPerTask.transpose((Function1)Predef$.MODULE$.$conforms()) : (Seq)statsTrackers.map((Function1 & Serializable & scala.Serializable)x$16 -> (Seq)Nil$.MODULE$, Seq$.MODULE$.canBuildFrom());
        ((IterableLike)statsTrackers.zip((GenIterable)statsPerTracker, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            FileFormatWriter$.$anonfun$processStats$5(jobCommitDuration, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$write$6(String c$1, Attribute x$1) {
        String string = x$1.name();
        String string2 = c$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ String $anonfun$write$8(int bucketId) {
        int arg$macro$1 = bucketId;
        return new StringOps("%05d_0_").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$1)}));
    }

    public static final /* synthetic */ String $anonfun$write$9(int x$2) {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$write$12(String c$2, Attribute x$3) {
        String string = x$3.name();
        String string2 = c$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ long $anonfun$write$13(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).toLong();
    }

    public static final /* synthetic */ boolean $anonfun$write$18(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Expression requiredOrder = (Expression)tuple2._1();
        Expression childOutputOrder = (Expression)tuple2._2();
        boolean bl = requiredOrder.semanticEquals(childOutputOrder);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$write$22(FileCommitProtocol committer$1, WriteTaskResult[] ret$1, int index, WriteTaskResult res) {
        committer$1.onTaskCommit(res.commitMsg());
        ret$1[index] = res;
    }

    public static final /* synthetic */ boolean $anonfun$processStats$1(int numStatsTrackers$1, Seq x$14) {
        return x$14.length() == numStatsTrackers$1;
    }

    public static final /* synthetic */ boolean $anonfun$processStats$3(int numStatsTrackers$1, Seq x$15) {
        return x$15.length() != numStatsTrackers$1;
    }

    public static final /* synthetic */ void $anonfun$processStats$5(long jobCommitDuration$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        WriteJobStatsTracker statsTracker = (WriteJobStatsTracker)tuple2._1();
        Seq stats = (Seq)tuple2._2();
        statsTracker.processStats((Seq<WriteTaskStats>)stats, jobCommitDuration$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private FileFormatWriter$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

