/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.benchmark.Benchmark;
import org.apache.spark.benchmark.Benchmark$;
import org.apache.spark.benchmark.BenchmarkBase;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.execution.ColumnarToRowExec;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.benchmark.SqlBasedBenchmark;
import org.apache.spark.sql.execution.columnar.InMemoryTableScanExec;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class InMemoryColumnarBenchmark$
extends BenchmarkBase
implements SqlBasedBenchmark {
    public static InMemoryColumnarBenchmark$ MODULE$;
    private final SparkSession spark;
    private String sparkHome;
    private volatile boolean bitmap$0;

    static {
        new InMemoryColumnarBenchmark$();
    }

    @Override
    public SparkSession getSparkSession() {
        return SqlBasedBenchmark.getSparkSession$(this);
    }

    @Override
    public final void codegenBenchmark(String name, long cardinality, Function0<BoxedUnit> f) {
        SqlBasedBenchmark.codegenBenchmark$(this, name, cardinality, f);
    }

    @Override
    public SqlBasedBenchmark.DatasetToBenchmark DatasetToBenchmark(Dataset<?> ds) {
        return SqlBasedBenchmark.DatasetToBenchmark$(this, ds);
    }

    @Override
    public void prepareDataInfo(Benchmark benchmark) {
        SqlBasedBenchmark.prepareDataInfo$(this, benchmark);
    }

    @Override
    public StructType writeWideRow(String path, int rowsNum, int numCols) {
        return SqlBasedBenchmark.writeWideRow$(this, path, rowsNum, numCols);
    }

    @Override
    public void afterAll() {
        SqlBasedBenchmark.afterAll$(this);
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$((SQLHelper)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void org$apache$spark$sql$execution$benchmark$SqlBasedBenchmark$_setter_$spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    private String sparkHome$lzycompute() {
        InMemoryColumnarBenchmark$ inMemoryColumnarBenchmark$ = this;
        synchronized (inMemoryColumnarBenchmark$) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$((SQLHelper)this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    public String sparkHome() {
        return !this.bitmap$0 ? this.sparkHome$lzycompute() : this.sparkHome;
    }

    public void intCache(int rowsNum, int numIters) {
        Dataset data = this.spark().range(0L, (long)rowsNum, 1L, 1).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"i"})).cache();
        Seq inMemoryScan = data.queryExecution().executedPlan().collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                InMemoryTableScanExec inMemoryTableScanExec;
                A1 A1 = x1;
                Object object = A1 instanceof InMemoryTableScanExec ? (inMemoryTableScanExec = (InMemoryTableScanExec)A1) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x1) {
                SparkPlan sparkPlan2 = x1;
                boolean bl = sparkPlan2 instanceof InMemoryTableScanExec;
                return bl;
            }
        });
        ColumnarToRowExec columnarScan = new ColumnarToRowExec((SparkPlan)inMemoryScan.apply(0));
        InMemoryTableScanExec rowScan = (InMemoryTableScanExec)inMemoryScan.apply(0);
        Predef$.MODULE$.assert(inMemoryScan.size() == 1);
        String x$12 = "Int In-Memory scan";
        long x$22 = rowsNum;
        Option x$3 = this.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$12, x$22, x$4, x$5, x$6, x$7, x$3);
        benchmark.addCase("columnar deserialization + columnar-to-row", numIters, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$1 -> columnarScan.executeCollect());
        benchmark.addCase("row-based deserialization", numIters, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$2 -> rowScan.executeCollect());
        benchmark.run();
    }

    public void runBenchmarkSuite(String[] mainArgs) {
        this.runBenchmark("Int In-memory", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.intCache(1000000, 3));
    }

    private InMemoryColumnarBenchmark$() {
        MODULE$ = this;
        SQLHelper.$init$((SQLHelper)this);
        SqlBasedBenchmark.$init$(this);
    }
}

