/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import org.apache.commons.io.FileUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.execution.BaseSubqueryExec;
import org.apache.spark.sql.execution.ExplainMode;
import org.apache.spark.sql.execution.FormattedMode$;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.ReusedSubqueryExec;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.SubqueryBroadcastExec;
import org.apache.spark.sql.execution.SubqueryExec;
import org.apache.spark.sql.execution.adaptive.DisableAdaptiveExecutionSuite;
import org.apache.spark.sql.execution.exchange.Exchange;
import org.apache.spark.sql.execution.exchange.ReusedExchangeExec;
import org.apache.spark.sql.execution.exchange.ValidateRequirements$;
import org.apache.spark.sql.internal.SQLConf$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.java8.JFunction0;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005=daB\n\u0015!\u0003\r\t!\b\u0005\u0006U\u0001!\ta\u000b\u0005\be\u0001\u0011\r\u0011\"\u00034\u0011\u001d9\u0004A1A\u0005\u0012aBq!\u0011\u0001C\u0002\u0013%!\tC\u0004L\u0001\t\u0007I\u0011\u0002\"\t\u000f1\u0003!\u0019!C\u0005\u001b\")A\u000b\u0001D\u0001+\"9\u0001\r\u0001b\u0001\n\u0013\t\u0007\"B6\u0001\t\u0013a\u0007\"B8\u0001\t\u0013\u0001\b\"B<\u0001\t\u0013A\bbBA\u0003\u0001\u0011%\u0011q\u0001\u0005\b\u0003\u001f\u0001A\u0011BA\t\u0011\u001d\t)\u0002\u0001C\u0005\u0003/Aq!a\u0007\u0001\t\u0013\ti\u0002C\u0004\u0002\"\u0001!\t\"a\t\t\u0013\u0005E\u0002!%A\u0005\u0012\u0005M\u0002BDA%\u0001A\u0005\u0019\u0011!A\u0005\n\u0005-\u00131\u000e\u0002\u0013!2\fgn\u0015;bE&d\u0017\u000e^=Tk&$XM\u0003\u0002\u0016-\u0005\u00191/\u001d7\u000b\u0005]A\u0012!B:qCJ\\'BA\r\u001b\u0003\u0019\t\u0007/Y2iK*\t1$A\u0002pe\u001e\u001c\u0001aE\u0002\u0001=\t\u0002\"a\b\u0011\u000e\u0003YI!!\t\f\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\t\u0019\u0003&D\u0001%\u0015\t)c%\u0001\u0005bI\u0006\u0004H/\u001b<f\u0015\t9C#A\u0005fq\u0016\u001cW\u000f^5p]&\u0011\u0011\u0006\n\u0002\u001e\t&\u001c\u0018M\u00197f\u0003\u0012\f\u0007\u000f^5wK\u0016CXmY;uS>t7+^5uK\u00061A%\u001b8ji\u0012\"\u0012\u0001\f\t\u0003[Aj\u0011A\f\u0006\u0002_\u0005)1oY1mC&\u0011\u0011G\f\u0002\u0005+:LG/A\u000bsK\u001e,g.\u001a:bi\u0016<u\u000e\u001c3f]\u001aKG.Z:\u0016\u0003Q\u0002\"!L\u001b\n\u0005Yr#a\u0002\"p_2,\u0017M\\\u0001\u0011E\u0006\u001cXMU3t_V\u00148-\u001a)bi\",\u0012!\u000f\t\u0003u}j\u0011a\u000f\u0006\u0003yu\n!![8\u000b\u0003y\nAA[1wC&\u0011\u0001i\u000f\u0002\u0005\r&dW-\u0001\bsK\u001a,'/\u001a8dKJ+w-\u001a=\u0016\u0003\r\u0003\"\u0001R%\u000e\u0003\u0015S!AR$\u0002\u00115\fGo\u00195j]\u001eT!\u0001\u0013\u0018\u0002\tU$\u0018\u000e\\\u0005\u0003\u0015\u0016\u0013QAU3hKb\faB\\8s[\u0006d\u0017N_3SK\u001e,\u00070A\u0004dYNt\u0015-\\3\u0016\u00039\u0003\"a\u0014*\u000e\u0003AS!!U\u001f\u0002\t1\fgnZ\u0005\u0003'B\u0013aa\u0015;sS:<\u0017AD4pY\u0012,gNR5mKB\u000bG\u000f[\u000b\u0002-B\u0011qK\u0018\b\u00031r\u0003\"!\u0017\u0018\u000e\u0003iS!a\u0017\u000f\u0002\rq\u0012xn\u001c;?\u0013\tif&\u0001\u0004Qe\u0016$WMZ\u0005\u0003'~S!!\u0018\u0018\u0002#\u0005\u0004\bO]8wK\u0012\fen]5QY\u0006t7/F\u0001c!\r\u0019\u0007N\u0016\b\u0003I\u001at!!W3\n\u0003=J!a\u001a\u0018\u0002\u000fA\f7m[1hK&\u0011\u0011N\u001b\u0002\u0004'\u0016\f(BA4/\u000359W\r\u001e#je\u001a{'\u000fV3tiR\u0011\u0011(\u001c\u0005\u0006]&\u0001\rAV\u0001\u0005]\u0006lW-\u0001\u0006jg\u0006\u0003\bO]8wK\u0012$B\u0001N9tk\")!O\u0003a\u0001s\u0005\u0019A-\u001b:\t\u000bQT\u0001\u0019\u0001,\u0002)\u0005\u001cG/^1m'&l\u0007\u000f\\5gS\u0016$\u0007\u000b\\1o\u0011\u00151(\u00021\u0001W\u00035\t7\r^;bY\u0016C\b\u000f\\1j]\u0006\u0011r-\u001a8fe\u0006$XmR8mI\u0016tg)\u001b7f)\u0015a\u0013p`A\u0001\u0011\u0015Q8\u00021\u0001|\u0003\u0011\u0001H.\u00198\u0011\u0005qlX\"\u0001\u0014\n\u0005y4#!C*qCJ\\\u0007\u000b\\1o\u0011\u0015q7\u00021\u0001W\u0011\u0019\t\u0019a\u0003a\u0001-\u00069Q\r\u001f9mC&t\u0017!E2iK\u000e\\w+\u001b;i\u0003B\u0004(o\u001c<fIR9A&!\u0003\u0002\f\u00055\u0001\"\u0002>\r\u0001\u0004Y\b\"\u00028\r\u0001\u00041\u0006BBA\u0002\u0019\u0001\u0007a+A\thKR\u001c\u0016.\u001c9mS\u001aLW\r\u001a)mC:$2AVA\n\u0011\u0015QX\u00021\u0001|\u00031qwN]7bY&TX-\u00133t)\r1\u0016\u0011\u0004\u0005\u0006u:\u0001\rAV\u0001\u0012]>\u0014X.\u00197ju\u0016dunY1uS>tGc\u0001,\u0002 !)!p\u0004a\u0001-\u0006IA/Z:u#V,'/\u001f\u000b\bY\u0005\u0015\u0012\u0011FA\u0017\u0011\u0019\t9\u0003\u0005a\u0001-\u0006QA\u000f]2eg\u001e\u0013x.\u001e9\t\r\u0005-\u0002\u00031\u0001W\u0003\u0015\tX/\u001a:z\u0011!\ty\u0003\u0005I\u0001\u0002\u00041\u0016AB:vM\u001aL\u00070A\nuKN$\u0018+^3ss\u0012\"WMZ1vYR$3'\u0006\u0002\u00026)\u001aa+a\u000e,\u0005\u0005e\u0002\u0003BA\u001e\u0003\u000bj!!!\u0010\u000b\t\u0005}\u0012\u0011I\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0011/\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u000f\niDA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f!d];qKJ$s-\u001a;X_J\\7\u000f]1dK\u001aKG.\u001a)bi\"$b!!\u0014\u0002^\u0005\u0005\u0004\u0003BA(\u00033j!!!\u0015\u000b\t\u0005M\u0013QK\u0001\u0005M&dWMC\u0002\u0002Xu\n1A\\5p\u0013\u0011\tY&!\u0015\u0003\tA\u000bG\u000f\u001b\u0005\u0007\u0003?\u0012\u0002\u0019\u0001,\u0002\u000b\u0019L'o\u001d;\t\u000f\u0005\r$\u00031\u0001\u0002f\u0005!Qn\u001c:f!\u0011i\u0013q\r,\n\u0007\u0005%dF\u0001\u0006=e\u0016\u0004X-\u0019;fIzJ1!!\u001c!\u0003Q9W\r^,pe.\u001c\b/Y2f\r&dW\rU1uQ\u0002")
public interface PlanStabilitySuite
extends DisableAdaptiveExecutionSuite {
    public void org$apache$spark$sql$PlanStabilitySuite$_setter_$org$apache$spark$sql$PlanStabilitySuite$$regenerateGoldenFiles_$eq(boolean var1);

    public void org$apache$spark$sql$PlanStabilitySuite$_setter_$baseResourcePath_$eq(File var1);

    public void org$apache$spark$sql$PlanStabilitySuite$_setter_$org$apache$spark$sql$PlanStabilitySuite$$referenceRegex_$eq(Regex var1);

    public void org$apache$spark$sql$PlanStabilitySuite$_setter_$org$apache$spark$sql$PlanStabilitySuite$$normalizeRegex_$eq(Regex var1);

    public void org$apache$spark$sql$PlanStabilitySuite$_setter_$org$apache$spark$sql$PlanStabilitySuite$$clsName_$eq(String var1);

    public void org$apache$spark$sql$PlanStabilitySuite$_setter_$org$apache$spark$sql$PlanStabilitySuite$$approvedAnsiPlans_$eq(Seq<String> var1);

    public /* synthetic */ Path org$apache$spark$sql$PlanStabilitySuite$$super$getWorkspaceFilePath(String var1, Seq var2);

    public boolean org$apache$spark$sql$PlanStabilitySuite$$regenerateGoldenFiles();

    public File baseResourcePath();

    public Regex org$apache$spark$sql$PlanStabilitySuite$$referenceRegex();

    public Regex org$apache$spark$sql$PlanStabilitySuite$$normalizeRegex();

    public String org$apache$spark$sql$PlanStabilitySuite$$clsName();

    public String goldenFilePath();

    public Seq<String> org$apache$spark$sql$PlanStabilitySuite$$approvedAnsiPlans();

    private File getDirForTest(String name) {
        String goldenFileName = SQLConf$.MODULE$.get().ansiEnabled() && this.org$apache$spark$sql$PlanStabilitySuite$$approvedAnsiPlans().contains((Object)name) ? new StringBuilder(5).append(name).append(".ansi").toString() : name;
        return new File(this.goldenFilePath(), goldenFileName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isApproved(File dir, String actualSimplifiedPlan, String actualExplain) {
        String expectedSimplified;
        LazyRef explainFile$lzy = new LazyRef();
        LazyRef expectedExplain$lzy = new LazyRef();
        File simplifiedFile = new File(dir, "simplified.txt");
        String string = expectedSimplified = FileUtils.readFileToString((File)simplifiedFile, (Charset)StandardCharsets.UTF_8);
        String string2 = actualSimplifiedPlan;
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = PlanStabilitySuite.expectedExplain$1(expectedExplain$lzy, explainFile$lzy, dir);
        String string4 = actualExplain;
        if (string3 == null) {
            if (string4 == null) return true;
            return false;
        } else {
            if (!string3.equals(string4)) return false;
            return true;
        }
    }

    private void generateGoldenFile(SparkPlan plan, String name, String explain) {
        block0: {
            boolean foundMatch;
            File dir = this.getDirForTest(name);
            String simplified = this.getSimplifiedPlan(plan);
            boolean bl = foundMatch = dir.exists() && this.isApproved(dir, simplified, explain);
            if (foundMatch) break block0;
            FileUtils.deleteDirectory((File)dir);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(dir.mkdirs(), "dir.mkdirs()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PlanStabilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
            File file = new File(dir, "simplified.txt");
            FileUtils.writeStringToFile((File)file, (String)simplified, (Charset)StandardCharsets.UTF_8);
            File fileOriginalPlan = new File(dir, "explain.txt");
            FileUtils.writeStringToFile((File)fileOriginalPlan, (String)explain, (Charset)StandardCharsets.UTF_8);
            this.logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(11).append("APPROVED: ").append(file).append(" ").append(fileOriginalPlan).toString());
        }
    }

    private void checkWithApproved(SparkPlan plan, String name, String explain) {
        File dir = this.getDirForTest(name);
        File tempDir = FileUtils.getTempDirectory();
        String actualSimplified = this.getSimplifiedPlan(plan);
        boolean foundMatch = this.isApproved(dir, actualSimplified, explain);
        if (!foundMatch) {
            File approvedSimplifiedFile = new File(dir, "simplified.txt");
            File approvedExplainFile = new File(dir, "explain.txt");
            File actualSimplifiedFile = new File(tempDir, new StringBuilder(22).append(name).append(".actual.simplified.txt").toString());
            File actualExplainFile = new File(tempDir, new StringBuilder(19).append(name).append(".actual.explain.txt").toString());
            String approvedSimplified = FileUtils.readFileToString((File)approvedSimplifiedFile, (Charset)StandardCharsets.UTF_8);
            FileUtils.writeStringToFile((File)actualSimplifiedFile, (String)actualSimplified, (Charset)StandardCharsets.UTF_8);
            FileUtils.writeStringToFile((File)actualExplainFile, (String)explain, (Charset)StandardCharsets.UTF_8);
            throw ((Assertions)this).fail(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(253).append("\n          |Plans did not match:\n          |last approved simplified plan: ").append(approvedSimplifiedFile.getAbsolutePath()).append("\n          |last approved explain plan: ").append(approvedExplainFile.getAbsolutePath()).append("\n          |\n          |").append(approvedSimplified).append("\n          |\n          |actual simplified plan: ").append(actualSimplifiedFile.getAbsolutePath()).append("\n          |actual explain plan: ").append(actualExplainFile.getAbsolutePath()).append("\n          |\n          |").append(actualSimplified).append("\n        ").toString())).stripMargin(), new Position("PlanStabilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
        }
    }

    private String getSimplifiedPlan(SparkPlan plan) {
        HashMap exchangeIdMap = new HashMap();
        HashMap subqueriesMap = new HashMap();
        return this.simplifyNode$1(plan, 0, exchangeIdMap, subqueriesMap);
    }

    private String normalizeIds(String plan) {
        HashMap map = new HashMap();
        this.org$apache$spark$sql$PlanStabilitySuite$$normalizeRegex().findAllMatchIn((CharSequence)plan).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.toString()).foreach((Function1 & Serializable & scala.Serializable)x$5 -> (String)map.getOrElseUpdate(x$5, (Function0 & Serializable & scala.Serializable)() -> Integer.toString(map.size() + 1)));
        return this.org$apache$spark$sql$PlanStabilitySuite$$normalizeRegex().replaceAllIn((CharSequence)plan, (Function1 & Serializable & scala.Serializable)regexMatch -> new StringBuilder(1).append("#").append(map.apply((Object)regexMatch.toString())).toString());
    }

    private String normalizeLocation(String plan) {
        return plan.replaceAll(new StringBuilder(11).append("Location.*").append(this.org$apache$spark$sql$PlanStabilitySuite$$clsName()).append("/").toString(), "Location [not included in comparison]/{warehouse_dir}/");
    }

    public static /* synthetic */ void testQuery$(PlanStabilitySuite $this, String tpcdsGroup, String query, String suffix) {
        $this.testQuery(tpcdsGroup, query, suffix);
    }

    default public void testQuery(String tpcdsGroup, String query, String suffix) {
        String x$1 = new StringBuilder(5).append(tpcdsGroup).append("/").append(query).append(".sql").toString();
        ClassLoader x$2 = Thread.currentThread().getContextClassLoader();
        String x$3 = package$.MODULE$.resourceToString$default$2();
        String queryString = package$.MODULE$.resourceToString(x$1, x$3, x$2);
        QueryExecution qe = ((Dataset)this.sql().apply((Object)queryString)).queryExecution();
        SparkPlan plan = qe.executedPlan();
        String explain = this.normalizeLocation(this.normalizeIds(qe.explainString((ExplainMode)FormattedMode$.MODULE$)));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(ValidateRequirements$.MODULE$.validate(plan), "org.apache.spark.sql.execution.exchange.ValidateRequirements.validate(plan)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PlanStabilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254));
        if (this.org$apache$spark$sql$PlanStabilitySuite$$regenerateGoldenFiles()) {
            this.generateGoldenFile(plan, new StringBuilder(0).append(query).append(suffix).toString(), explain);
        } else {
            this.checkWithApproved(plan, new StringBuilder(0).append(query).append(suffix).toString(), explain);
        }
    }

    public static /* synthetic */ String testQuery$default$3$(PlanStabilitySuite $this) {
        return $this.testQuery$default$3();
    }

    default public String testQuery$default$3() {
        return "";
    }

    private static /* synthetic */ File explainFile$lzycompute$1(LazyRef explainFile$lzy$1, File dir$1) {
        File file;
        LazyRef lazyRef = explainFile$lzy$1;
        synchronized (lazyRef) {
            file = explainFile$lzy$1.initialized() ? (File)explainFile$lzy$1.value() : (File)explainFile$lzy$1.initialize((Object)new File(dir$1, "explain.txt"));
        }
        return file;
    }

    private static File explainFile$1(LazyRef explainFile$lzy$1, File dir$1) {
        return explainFile$lzy$1.initialized() ? (File)explainFile$lzy$1.value() : PlanStabilitySuite.explainFile$lzycompute$1(explainFile$lzy$1, dir$1);
    }

    private static /* synthetic */ String expectedExplain$lzycompute$1(LazyRef expectedExplain$lzy$1, LazyRef explainFile$lzy$1, File dir$1) {
        String string;
        LazyRef lazyRef = expectedExplain$lzy$1;
        synchronized (lazyRef) {
            string = expectedExplain$lzy$1.initialized() ? (String)expectedExplain$lzy$1.value() : (String)expectedExplain$lzy$1.initialize((Object)FileUtils.readFileToString((File)PlanStabilitySuite.explainFile$1(explainFile$lzy$1, dir$1), (Charset)StandardCharsets.UTF_8));
        }
        return string;
    }

    private static String expectedExplain$1(LazyRef expectedExplain$lzy$1, LazyRef explainFile$lzy$1, File dir$1) {
        return expectedExplain$lzy$1.initialized() ? (String)expectedExplain$lzy$1.value() : PlanStabilitySuite.expectedExplain$lzycompute$1(expectedExplain$lzy$1, explainFile$lzy$1, dir$1);
    }

    private static int getId$1(SparkPlan plan, HashMap exchangeIdMap$1, HashMap subqueriesMap$1) {
        int n;
        SparkPlan sparkPlan2 = plan;
        if (sparkPlan2 instanceof Exchange) {
            Exchange exchange = (Exchange)sparkPlan2;
            n = BoxesRunTime.unboxToInt((Object)exchangeIdMap$1.getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)exchange.id()), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> exchangeIdMap$1.size() + 1));
        } else if (sparkPlan2 instanceof ReusedExchangeExec) {
            ReusedExchangeExec reusedExchangeExec = (ReusedExchangeExec)sparkPlan2;
            Exchange exchange = reusedExchangeExec.child();
            n = BoxesRunTime.unboxToInt((Object)exchangeIdMap$1.getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)exchange.id()), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> exchangeIdMap$1.size() + 1));
        } else if (sparkPlan2 instanceof SubqueryExec) {
            SubqueryExec subqueryExec = (SubqueryExec)sparkPlan2;
            n = BoxesRunTime.unboxToInt((Object)subqueriesMap$1.getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)subqueryExec.id()), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> subqueriesMap$1.size() + 1));
        } else if (sparkPlan2 instanceof SubqueryBroadcastExec) {
            SubqueryBroadcastExec subqueryBroadcastExec = (SubqueryBroadcastExec)sparkPlan2;
            n = BoxesRunTime.unboxToInt((Object)subqueriesMap$1.getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)subqueryBroadcastExec.id()), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> subqueriesMap$1.size() + 1));
        } else if (sparkPlan2 instanceof ReusedSubqueryExec) {
            ReusedSubqueryExec reusedSubqueryExec = (ReusedSubqueryExec)sparkPlan2;
            BaseSubqueryExec subquery = reusedSubqueryExec.child();
            n = BoxesRunTime.unboxToInt((Object)subqueriesMap$1.getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)subquery.id()), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> subqueriesMap$1.size() + 1));
        } else {
            n = -1;
        }
        return n;
    }

    private String cleanUpReferences$1(AttributeSet references) {
        return this.org$apache$spark$sql$PlanStabilitySuite$$referenceRegex().replaceAllIn((CharSequence)((TraversableOnce)references.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Iterable$.MODULE$.canBuildFrom())).mkString(","), "");
    }

    private String simplifyNode$1(SparkPlan node, int depth, HashMap exchangeIdMap$1, HashMap subqueriesMap$1) {
        int id;
        String padding = new StringOps(Predef$.MODULE$.augmentString("  ")).$times(depth);
        String thisNode = node.nodeName();
        if (node.references().nonEmpty()) {
            thisNode = new StringBuilder(3).append(thisNode).append(" [").append(this.cleanUpReferences$1(node.references())).append("]").toString();
        }
        if (node.producedAttributes().nonEmpty()) {
            thisNode = new StringBuilder(3).append(thisNode).append(" [").append(this.cleanUpReferences$1(node.producedAttributes())).append("]").toString();
        }
        if ((id = PlanStabilitySuite.getId$1(node, exchangeIdMap$1, subqueriesMap$1)) > 0) {
            thisNode = new StringBuilder(2).append(thisNode).append(" #").append(id).toString();
        }
        Seq childrenSimplified = (Seq)node.children().map((Function1 & Serializable & scala.Serializable)x$2 -> this.simplifyNode$1((SparkPlan)x$2, depth + 1, exchangeIdMap$1, subqueriesMap$1), Seq$.MODULE$.canBuildFrom());
        Seq subqueriesSimplified = (Seq)node.subqueries().map((Function1 & Serializable & scala.Serializable)x$3 -> this.simplifyNode$1((SparkPlan)x$3, depth + 1, exchangeIdMap$1, subqueriesMap$1), Seq$.MODULE$.canBuildFrom());
        return new StringBuilder(1).append(padding).append(thisNode).append("\n").append(subqueriesSimplified.mkString("")).append(childrenSimplified.mkString("")).toString();
    }

    public static void $init$(PlanStabilitySuite $this) {
        String string = System.getenv("SPARK_GENERATE_GOLDEN_FILES");
        String string2 = "1";
        $this.org$apache$spark$sql$PlanStabilitySuite$_setter_$org$apache$spark$sql$PlanStabilitySuite$$regenerateGoldenFiles_$eq(!(string != null ? !string.equals(string2) : string2 != null));
        $this.org$apache$spark$sql$PlanStabilitySuite$_setter_$baseResourcePath_$eq($this.org$apache$spark$sql$PlanStabilitySuite$$super$getWorkspaceFilePath("sql", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"core", "src", "test", "resources", "tpcds-plan-stability"})).toFile());
        $this.org$apache$spark$sql$PlanStabilitySuite$_setter_$org$apache$spark$sql$PlanStabilitySuite$$referenceRegex_$eq(new StringOps(Predef$.MODULE$.augmentString("#\\d+")).r());
        $this.org$apache$spark$sql$PlanStabilitySuite$_setter_$org$apache$spark$sql$PlanStabilitySuite$$normalizeRegex_$eq(new StringOps(Predef$.MODULE$.augmentString("#\\d+L?")).r());
        $this.org$apache$spark$sql$PlanStabilitySuite$_setter_$org$apache$spark$sql$PlanStabilitySuite$$clsName_$eq($this.getClass().getCanonicalName());
        $this.org$apache$spark$sql$PlanStabilitySuite$_setter_$org$apache$spark$sql$PlanStabilitySuite$$approvedAnsiPlans_$eq((Seq<String>)((Seq)new .colon.colon((Object)"q83", (List)new .colon.colon((Object)"q83.sf100", (List)Nil$.MODULE$))));
    }
}

