/*
 * Decompiled with CFR 0.152.
 */
package test.org.apache.spark.sql.streaming;

import java.io.File;
import java.util.concurrent.TimeoutException;
import org.apache.spark.api.java.function.VoidFunction2;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.ForeachWriter;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.test.TestSparkSession;
import org.apache.spark.util.Utils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class JavaDataStreamReaderWriterSuite {
    private SparkSession spark;
    private String input;

    @Before
    public void setUp() {
        this.spark = new TestSparkSession();
        this.input = Utils.createTempDir((String)System.getProperty("java.io.tmpdir"), (String)"input").toString();
    }

    @After
    public void tearDown() {
        try {
            Utils.deleteRecursively((File)new File(this.input));
        }
        finally {
            this.spark.stop();
            this.spark = null;
        }
    }

    @Test
    public void testForeachBatchAPI() throws TimeoutException {
        StreamingQuery query = this.spark.readStream().textFile(this.input).writeStream().foreachBatch((VoidFunction2)new VoidFunction2<Dataset<String>, Long>(){

            public void call(Dataset<String> v1, Long v2) throws Exception {
            }
        }).start();
        query.stop();
    }

    @Test
    public void testForeachAPI() throws TimeoutException {
        StreamingQuery query = this.spark.readStream().textFile(this.input).writeStream().foreach((ForeachWriter)new ForeachWriter<String>(){

            public boolean open(long partitionId, long epochId) {
                return true;
            }

            public void process(String value) {
            }

            public void close(Throwable errorOrNull) {
            }
        }).start();
        query.stop();
    }
}

