/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector;

import java.io.File;
import java.io.Serializable;
import java.sql.Timestamp;
import java.time.LocalDate;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.CannotReplaceMissingTableException;
import org.apache.spark.sql.catalyst.analysis.NamespaceAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchDatabaseException;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.connector.AlterTableTests;
import org.apache.spark.sql.connector.DataSourceV2SQLSuite$;
import org.apache.spark.sql.connector.DatasourceV2SQLBase;
import org.apache.spark.sql.connector.FakeV2Provider;
import org.apache.spark.sql.connector.InMemoryTableSessionCatalog;
import org.apache.spark.sql.connector.InsertIntoTests;
import org.apache.spark.sql.connector.catalog.BasicInMemoryTableCatalog;
import org.apache.spark.sql.connector.catalog.CatalogManager;
import org.apache.spark.sql.connector.catalog.CatalogManager$;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.CatalogV2Util$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.InMemoryPartitionTable;
import org.apache.spark.sql.connector.catalog.InMemoryTable;
import org.apache.spark.sql.connector.catalog.InMemoryTable$;
import org.apache.spark.sql.connector.catalog.InMemoryTableCatalog;
import org.apache.spark.sql.connector.catalog.InMemoryTableCatalog$;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.V1Table;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.execution.columnar.InMemoryRelation;
import org.apache.spark.sql.execution.streaming.MemoryStream;
import org.apache.spark.sql.execution.streaming.MemoryStream$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.sql.sources.SimpleScanSource;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015c\u0001B\n\u0015\u0001}AQA\u000b\u0001\u0005\u0002-Bq!\f\u0001C\u0002\u0013%a\u0006\u0003\u00048\u0001\u0001\u0006Ia\f\u0005\bq\u0001\u0011\r\u0011\"\u0015/\u0011\u0019I\u0004\u0001)A\u0005_!9!\b\u0001b\u0001\n#r\u0003BB\u001e\u0001A\u0003%q\u0006C\u0004=\u0001\t\u0007I\u0011B\u001f\t\r)\u0003\u0001\u0015!\u0003?\u0011\u0015Y\u0005\u0001\"\u0005M\u0011\u0015Q\u0007\u0001\"\u0011l\u0011\u0015y\u0007\u0001\"\u0011q\u0011\u0015A\b\u0001\"\u0003z\u0011\u001d\tY\u0001\u0001C\u0005\u0003\u001bAq!a\u0006\u0001\t\u0013\tI\u0002C\u0004\u0002 \u0001!I!!\t\t\u000f\u0005-\u0002\u0001\"\u0003\u0002.!9\u0011q\u0007\u0001\u0005\n\u0005e\"\u0001\u0006#bi\u0006\u001cv.\u001e:dKZ\u00134+\u0015'Tk&$XM\u0003\u0002\u0016-\u0005I1m\u001c8oK\u000e$xN\u001d\u0006\u0003/a\t1a]9m\u0015\tI\"$A\u0003ta\u0006\u00148N\u0003\u0002\u001c9\u00051\u0011\r]1dQ\u0016T\u0011!H\u0001\u0004_J<7\u0001A\n\u0005\u0001\u0001\"s\u0005\u0005\u0002\"E5\tA#\u0003\u0002$)\ty\u0011J\\:feRLe\u000e^8UKN$8\u000f\u0005\u0002\"K%\u0011a\u0005\u0006\u0002\u0010\u00032$XM\u001d+bE2,G+Z:ugB\u0011\u0011\u0005K\u0005\u0003SQ\u00111\u0003R1uCN|WO]2f-J\u001a\u0016\u000b\u0014\"bg\u0016\fa\u0001P5oSRtD#\u0001\u0017\u0011\u0005\u0005\u0002\u0011\u0001\u0003<3'>,(oY3\u0016\u0003=\u0002\"\u0001M\u001b\u000e\u0003ER!AM\u001a\u0002\t1\fgn\u001a\u0006\u0002i\u0005!!.\u0019<b\u0013\t1\u0014G\u0001\u0004TiJLgnZ\u0001\nmJ\u001av.\u001e:dK\u0002\n\u0001B\u001e\u001aG_Jl\u0017\r^\u0001\nmJ2uN]7bi\u0002\n1cY1uC2|w-\u00118e\u001d\u0006lWm\u001d9bG\u0016\fAcY1uC2|w-\u00118e\u001d\u0006lWm\u001d9bG\u0016\u0004\u0013a\u00033fM\u0006,H\u000e^+tKJ,\u0012A\u0010\t\u0003\u007f!s!\u0001\u0011$\u0011\u0005\u0005#U\"\u0001\"\u000b\u0005\rs\u0012A\u0002\u001fs_>$hHC\u0001F\u0003\u0015\u00198-\u00197b\u0013\t9E)\u0001\u0004Qe\u0016$WMZ\u0005\u0003m%S!a\u0012#\u0002\u0019\u0011,g-Y;miV\u001bXM\u001d\u0011\u0002\u0011\u0011|\u0017J\\:feR$B!T)TIB\u0011ajT\u0007\u0002\t&\u0011\u0001\u000b\u0012\u0002\u0005+:LG\u000fC\u0003S\u0015\u0001\u0007a(A\u0005uC\ndWMT1nK\")AK\u0003a\u0001+\u00061\u0011N\\:feR\u0004\"AV1\u000f\u0005]{fB\u0001-_\u001d\tIVL\u0004\u0002[9:\u0011\u0011iW\u0005\u0002;%\u00111\u0004H\u0005\u00033iI!a\u0006\r\n\u0005\u00014\u0012a\u00029bG.\fw-Z\u0005\u0003E\u000e\u0014\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0005\u00014\u0002bB3\u000b!\u0003\u0005\rAZ\u0001\u0005[>$W\r\u0005\u0002hQ6\ta#\u0003\u0002j-\tA1+\u0019<f\u001b>$W-A\u0006wKJLg-\u001f+bE2,GcA'm[\")!k\u0003a\u0001}!)an\u0003a\u0001+\u0006AQ\r\u001f9fGR,G-\u0001\thKR$\u0016M\u00197f\u001b\u0016$\u0018\rZ1uCR\u0011\u0011o\u001e\t\u0003eVl\u0011a\u001d\u0006\u0003iR\tqaY1uC2|w-\u0003\u0002wg\n)A+\u00192mK\")!\u000b\u0004a\u0001}\u0005\u0011B/Z:u'\"|wOT1nKN\u0004\u0018mY3t)\ri%\u0010 \u0005\u0006w6\u0001\rAP\u0001\bgFdG+\u001a=u\u0011\u0015qW\u00021\u0001~!\u0011q\u0018Q\u0001 \u000f\u0007}\f\u0019AD\u0002B\u0003\u0003I\u0011!R\u0005\u0003A\u0012KA!a\u0002\u0002\n\t\u00191+Z9\u000b\u0005\u0001$\u0015!F2iK\u000e\\g*Y7fgB\f7-Z\"p[6,g\u000e\u001e\u000b\u0006\u001b\u0006=\u00111\u0003\u0005\u0007\u0003#q\u0001\u0019\u0001 \u0002\u00139\fW.Z:qC\u000e,\u0007BBA\u000b\u001d\u0001\u0007a(A\u0004d_6lWM\u001c;\u0002#\rDWmY6UC\ndWmQ8n[\u0016tG\u000fF\u0003N\u00037\ti\u0002C\u0003S\u001f\u0001\u0007a\b\u0003\u0004\u0002\u0016=\u0001\rAP\u0001\u001ai\u0016\u001cHOT8u'V\u0004\bo\u001c:uK\u00124&gQ8n[\u0006tG\rF\u0003N\u0003G\t9\u0003\u0003\u0004\u0002&A\u0001\rAP\u0001\u000bgFd7i\\7nC:$\u0007BBA\u0015!\u0001\u0007a(A\u0005tc2\u0004\u0016M]1ng\u0006\u0019\u0012m]:feR\fe.\u00197zg&\u001cXI\u001d:peR)Q*a\f\u00024!1\u0011\u0011G\tA\u0002y\nAb]9m'R\fG/Z7f]RDa!!\u000e\u0012\u0001\u0004q\u0014!D3ya\u0016\u001cG/\u001a3FeJ|'/\u0001\thKR\u001c\u0006n\\<De\u0016\fG/\u001a#E\u0019R!\u00111HA!!\u0011q\u0015Q\b \n\u0007\u0005}BIA\u0003BeJ\f\u0017\u0010\u0003\u0004\u0002DI\u0001\rAP\u0001\u0013g\"|wo\u0011:fCR,G+\u00192mKN\u000bH\u000e")
public class DataSourceV2SQLSuite
extends InsertIntoTests
implements AlterTableTests,
DatasourceV2SQLBase {
    private final String v2Source;
    private final String v2Format;
    private final String catalogAndNamespace;
    private final String defaultUser;

    @Override
    public CatalogPlugin catalog(String name) {
        return DatasourceV2SQLBase.catalog$(this, name);
    }

    private String v2Source() {
        return this.v2Source;
    }

    @Override
    public String v2Format() {
        return this.v2Format;
    }

    @Override
    public String catalogAndNamespace() {
        return this.catalogAndNamespace;
    }

    private String defaultUser() {
        return this.defaultUser;
    }

    @Override
    public void doInsert(String tableName, Dataset<Row> insert, SaveMode mode) {
        String tmpView = "tmp_view";
        this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tmpView}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            insert.createOrReplaceTempView(tmpView);
            SaveMode saveMode = mode;
            SaveMode saveMode2 = SaveMode.Overwrite;
            String overwrite = !(saveMode != null ? !saveMode.equals(saveMode2) : saveMode2 != null) ? "OVERWRITE" : "INTO";
            this.sql().apply((Object)new StringBuilder(29).append("INSERT ").append(overwrite).append(" TABLE ").append(tableName).append(" SELECT * FROM ").append(tmpView).toString());
        });
    }

    @Override
    public void verifyTable(String tableName, Dataset<Row> expected) {
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> this.spark().table(tableName), expected);
    }

    @Override
    public Table getTableMetadata(String tableName) {
        Seq nameParts = this.spark().sessionState().sqlParser().parseMultipartIdentifier(tableName);
        TableCatalog v2Catalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog((String)nameParts.head())).asTableCatalog();
        String[] namespace = (String[])((TraversableOnce)((TraversableLike)nameParts.drop(1)).init()).toArray(ClassTag$.MODULE$.apply(String.class));
        return v2Catalog.loadTable(Identifier.of((String[])namespace, (String)((String)nameParts.last())));
    }

    private void testShowNamespaces(String sqlText, Seq<String> expected) {
        StructType schema = new StructType().add("namespace", (DataType)StringType$.MODULE$, false);
        Dataset df = this.spark().sql(sqlText);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(df.schema());
        StructType $org_scalatest_assert_macro_right = schema;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1322));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.collect())).map((Function1 & Serializable & scala.Serializable)x$24 -> (String)x$24.getAs(0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).sorted((Ordering)Ordering.String$.MODULE$));
        Seq $org_scalatest_assert_macro_right2 = (Seq)expected.sorted((Ordering)Ordering.String$.MODULE$);
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1323));
    }

    private void checkNamespaceComment(String namespace, String comment) {
        this.sql().apply((Object)new StringBuilder(25).append("COMMENT ON NAMESPACE ").append(namespace).append(" IS ").append(Option$.MODULE$.apply((Object)comment).map((Function1 & Serializable & scala.Serializable)x$28 -> new StringBuilder(2).append("'").append((String)x$28).append("'").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "NULL")).toString());
        String expectedComment = (String)Option$.MODULE$.apply((Object)comment).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(((Row)((Dataset)this.sql().apply((Object)new StringBuilder(24).append("DESC NAMESPACE extended ").append(namespace).toString())).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k", "v"})).where(new StringBuilder(4).append("k='").append(new StringOps(Predef$.MODULE$.augmentString("comment")).capitalize()).append("'").toString()).head()).getString(1));
        String $org_scalatest_assert_macro_right = expectedComment;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2436));
    }

    private void checkTableComment(String tableName, String comment) {
        this.sql().apply((Object)new StringBuilder(21).append("COMMENT ON TABLE ").append(tableName).append(" IS ").append(Option$.MODULE$.apply((Object)comment).map((Function1 & Serializable & scala.Serializable)x$29 -> new StringBuilder(2).append("'").append((String)x$29).append("'").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "NULL")).toString());
        String expectedComment = (String)Option$.MODULE$.apply((Object)comment).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(((Row)((Dataset)this.sql().apply((Object)new StringBuilder(14).append("DESC extended ").append(tableName).toString())).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k", "v", "c"})).where(new StringBuilder(4).append("k='").append(new StringOps(Predef$.MODULE$.augmentString("comment")).capitalize()).append("'").toString()).head()).getString(1));
        String $org_scalatest_assert_macro_right = expectedComment;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2475));
    }

    private void testNotSupportedV2Command(String sqlCommand, String sqlParams) {
        AnalysisException e = (AnalysisException)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(1).append(sqlCommand).append(" ").append(sqlParams).toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2920)));
        String $org_scalatest_assert_macro_left = e.message();
        String $org_scalatest_assert_macro_right = new StringBuilder(31).append(sqlCommand).append(" is not supported for v2 tables").toString();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2923));
    }

    private void assertAnalysisError(String sqlStatement, String expectedError) {
        String errMsg;
        String $org_scalatest_assert_macro_left = errMsg = ((AnalysisException)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)sqlStatement), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2927)))).getMessage();
        String $org_scalatest_assert_macro_right = expectedError;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2930));
    }

    private String[] getShowCreateDDL(String showCreateTableSql) {
        return (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((Row)((Dataset)this.sql().apply((Object)showCreateTableSql)).head()).getString(0).split("\n"))).map((Function1 & Serializable & scala.Serializable)x$30 -> x$30.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
    }

    public static final /* synthetic */ void $anonfun$new$47(DataSourceV2SQLSuite $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TableCatalog catalog = (TableCatalog)tuple2._1();
        String identifier = (String)tuple2._2();
        $this.spark().sql(new StringBuilder(54).append("CREATE TABLE ").append(identifier).append(" USING foo AS SELECT id, data FROM source").toString());
        Table table = catalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
        String $org_scalatest_assert_macro_left = table.name();
        String $org_scalatest_assert_macro_right = identifier;
        String string = $org_scalatest_assert_macro_left;
        String string2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 364));
        Object[] $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])table.partitioning());
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left2), "isEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left2).isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 365));
        java.util.Map $org_scalatest_assert_macro_left3 = table.properties();
        java.util.Map $org_scalatest_assert_macro_right2 = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)"foo")})))).asJava();
        java.util.Map map = $org_scalatest_assert_macro_left3;
        java.util.Map map2 = $org_scalatest_assert_macro_right2;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(map != null ? !((Object)map).equals(map2) : map2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 366));
        StructType $org_scalatest_assert_macro_left4 = table.schema();
        StructType $org_scalatest_assert_macro_right3 = new StructType().add("id", (DataType)LongType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
        StructType structType = $org_scalatest_assert_macro_left4;
        StructType structType2 = $org_scalatest_assert_macro_right3;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 367));
        SparkContext qual$11 = $this.spark().sparkContext();
        Seq x$26 = ((InMemoryTable)table).rows();
        int x$27 = qual$11.parallelize$default$2();
        RDD rdd = qual$11.parallelize(x$26, x$27, ClassTag$.MODULE$.apply(InternalRow.class));
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> {
            SparkSession qual$12 = $this.spark();
            RDD x$28 = rdd;
            StructType x$29 = table.schema();
            boolean x$30 = qual$12.internalCreateDataFrame$default$3();
            return qual$12.internalCreateDataFrame(x$28, x$29, x$30);
        }, (Dataset<Row>)$this.spark().table("source"));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$50(DataSourceV2SQLSuite $this, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TableCatalog catalog = (TableCatalog)tuple2._1();
        String identifier = (String)tuple2._2();
        Dataset df = $this.spark().sql(new StringBuilder(54).append("CREATE TABLE ").append(identifier).append(" USING foo AS SELECT id, data FROM source").toString());
        df.collect();
        df.take(5);
        df.tail(5);
        df.where("true").collect();
        df.where("true").take(5);
        df.where("true").tail(5);
        Table table = catalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
        String $org_scalatest_assert_macro_left = table.name();
        String $org_scalatest_assert_macro_right = identifier;
        String string = $org_scalatest_assert_macro_left;
        String string2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 395));
        Object[] $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])table.partitioning());
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left2), "isEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left2).isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 396));
        java.util.Map $org_scalatest_assert_macro_left3 = table.properties();
        java.util.Map $org_scalatest_assert_macro_right2 = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)"foo")})))).asJava();
        java.util.Map map = $org_scalatest_assert_macro_left3;
        java.util.Map map2 = $org_scalatest_assert_macro_right2;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(map != null ? !((Object)map).equals(map2) : map2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 397));
        StructType $org_scalatest_assert_macro_left4 = table.schema();
        StructType $org_scalatest_assert_macro_right3 = new StructType().add("id", (DataType)LongType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
        StructType structType = $org_scalatest_assert_macro_left4;
        StructType structType2 = $org_scalatest_assert_macro_right3;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 398));
        SparkContext qual$13 = $this.spark().sparkContext();
        Seq x$31 = ((InMemoryTable)table).rows();
        int x$32 = qual$13.parallelize$default$2();
        RDD rdd = qual$13.parallelize(x$31, x$32, ClassTag$.MODULE$.apply(InternalRow.class));
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> {
            SparkSession qual$14 = $this.spark();
            RDD x$33 = rdd;
            StructType x$34 = table.schema();
            boolean x$35 = qual$14.internalCreateDataFrame$default$3();
            return qual$14.internalCreateDataFrame(x$33, x$34, x$35);
        }, (Dataset<Row>)$this.spark().table("source"));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$53(DataSourceV2SQLSuite $this, Tuple2 x0$3) {
        Table replacedTable;
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TableCatalog catalog = (TableCatalog)tuple2._1();
        String identifier = (String)tuple2._2();
        $this.spark().sql(new StringBuilder(54).append("CREATE TABLE ").append(identifier).append(" USING foo AS SELECT id, data FROM source").toString());
        Table originalTable = catalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
        $this.spark().sql(new StringBuilder(49).append("REPLACE TABLE ").append(identifier).append(" USING foo AS SELECT id FROM source").toString());
        Table $org_scalatest_assert_macro_left = replacedTable = catalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
        Table $org_scalatest_assert_macro_right = originalTable;
        Table table = $org_scalatest_assert_macro_left;
        Table table2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", (Object)$org_scalatest_assert_macro_right, table == null ? table2 != null : !table.equals(table2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Table should have been replaced.", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 421));
        String $org_scalatest_assert_macro_left2 = replacedTable.name();
        String $org_scalatest_assert_macro_right2 = identifier;
        String string = $org_scalatest_assert_macro_left2;
        String string2 = $org_scalatest_assert_macro_right2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 422));
        Object[] $org_scalatest_assert_macro_left3 = Predef$.MODULE$.refArrayOps((Object[])replacedTable.partitioning());
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left3), "isEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left3).isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 423));
        java.util.Map $org_scalatest_assert_macro_left4 = replacedTable.properties();
        java.util.Map $org_scalatest_assert_macro_right3 = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)"foo")})))).asJava();
        java.util.Map map = $org_scalatest_assert_macro_left4;
        java.util.Map map2 = $org_scalatest_assert_macro_right3;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(map != null ? !((Object)map).equals(map2) : map2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 424));
        StructType $org_scalatest_assert_macro_left5 = replacedTable.schema();
        StructType $org_scalatest_assert_macro_right4 = new StructType().add("id", (DataType)LongType$.MODULE$);
        StructType structType = $org_scalatest_assert_macro_left5;
        StructType structType2 = $org_scalatest_assert_macro_right4;
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right4, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 425));
        SparkContext qual$15 = $this.spark().sparkContext();
        Seq x$36 = ((InMemoryTable)replacedTable).rows();
        int x$37 = qual$15.parallelize$default$2();
        RDD rdd = qual$15.parallelize(x$36, x$37, ClassTag$.MODULE$.apply(InternalRow.class));
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> {
            SparkSession qual$16 = $this.spark();
            RDD x$38 = rdd;
            StructType x$39 = replacedTable.schema();
            boolean x$40 = qual$16.internalCreateDataFrame$default$3();
            return qual$16.internalCreateDataFrame(x$38, x$39, x$40);
        }, (Dataset<Row>)$this.spark().table("source").select("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$57(DataSourceV2SQLSuite $this, String cmd$1, Tuple2 x0$4) {
        Table replacedTable;
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TableCatalog catalog = (TableCatalog)tuple2._1();
        String identifier = (String)tuple2._2();
        $this.spark().sql(new StringBuilder(54).append("CREATE TABLE ").append(identifier).append(" USING foo AS SELECT id, data FROM source").toString());
        Table originalTable = catalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
        Dataset df = $this.spark().sql(new StringBuilder(42).append(cmd$1).append(" TABLE ").append(identifier).append(" USING foo AS SELECT id FROM source").toString());
        df.collect();
        df.take(5);
        df.tail(5);
        df.where("true").collect();
        df.where("true").take(5);
        df.where("true").tail(5);
        Table $org_scalatest_assert_macro_left = replacedTable = catalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
        Table $org_scalatest_assert_macro_right = originalTable;
        Table table = $org_scalatest_assert_macro_left;
        Table table2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", (Object)$org_scalatest_assert_macro_right, table == null ? table2 != null : !table.equals(table2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Table should have been replaced.", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 457));
        String $org_scalatest_assert_macro_left2 = replacedTable.name();
        String $org_scalatest_assert_macro_right2 = identifier;
        String string = $org_scalatest_assert_macro_left2;
        String string2 = $org_scalatest_assert_macro_right2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 458));
        Object[] $org_scalatest_assert_macro_left3 = Predef$.MODULE$.refArrayOps((Object[])replacedTable.partitioning());
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left3), "isEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left3).isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 459));
        java.util.Map $org_scalatest_assert_macro_left4 = replacedTable.properties();
        java.util.Map $org_scalatest_assert_macro_right3 = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)"foo")})))).asJava();
        java.util.Map map = $org_scalatest_assert_macro_left4;
        java.util.Map map2 = $org_scalatest_assert_macro_right3;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(map != null ? !((Object)map).equals(map2) : map2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 460));
        StructType $org_scalatest_assert_macro_left5 = replacedTable.schema();
        StructType $org_scalatest_assert_macro_right4 = new StructType().add("id", (DataType)LongType$.MODULE$);
        StructType structType = $org_scalatest_assert_macro_left5;
        StructType structType2 = $org_scalatest_assert_macro_right4;
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right4, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 461));
        SparkContext qual$17 = $this.spark().sparkContext();
        Seq x$41 = ((InMemoryTable)replacedTable).rows();
        int x$42 = qual$17.parallelize$default$2();
        RDD rdd = qual$17.parallelize(x$41, x$42, ClassTag$.MODULE$.apply(InternalRow.class));
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> {
            SparkSession qual$18 = $this.spark();
            RDD x$43 = rdd;
            StructType x$44 = replacedTable.schema();
            boolean x$45 = qual$18.internalCreateDataFrame$default$3();
            return qual$18.internalCreateDataFrame(x$43, x$44, x$45);
        }, (Dataset<Row>)$this.spark().table("source").select("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$88(DataSourceV2SQLSuite $this, Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TableCatalog catalog = (TableCatalog)tuple2._1();
        String identifier = (String)tuple2._2();
        $this.spark().sql(new StringBuilder(37).append("CREATE TABLE ").append(identifier).append(" USING foo AS SELECT 1 i").toString());
        Table table = catalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
        String $org_scalatest_assert_macro_left = table.name();
        String $org_scalatest_assert_macro_right = identifier;
        String string = $org_scalatest_assert_macro_left;
        String string2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 723));
        Object[] $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])table.partitioning());
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left2), "isEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left2).isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 724));
        java.util.Map $org_scalatest_assert_macro_left3 = table.properties();
        java.util.Map $org_scalatest_assert_macro_right2 = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)"foo")})))).asJava();
        java.util.Map map = $org_scalatest_assert_macro_left3;
        java.util.Map map2 = $org_scalatest_assert_macro_right2;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(map != null ? !((Object)map).equals(map2) : map2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 725));
        StructType $org_scalatest_assert_macro_left4 = table.schema();
        StructType $org_scalatest_assert_macro_right3 = new StructType().add("i", "int");
        StructType structType = $org_scalatest_assert_macro_left4;
        StructType structType2 = $org_scalatest_assert_macro_right3;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 726));
        SparkContext qual$31 = $this.spark().sparkContext();
        Seq x$76 = ((InMemoryTable)table).rows();
        int x$77 = qual$31.parallelize$default$2();
        RDD rdd = qual$31.parallelize(x$76, x$77, ClassTag$.MODULE$.apply(InternalRow.class));
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> {
            SparkSession qual$32 = $this.spark();
            RDD x$78 = rdd;
            StructType x$79 = table.schema();
            boolean x$80 = qual$32.internalCreateDataFrame$default$3();
            return qual$32.internalCreateDataFrame(x$78, x$79, x$80);
        }, Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
        $this.sql().apply((Object)new StringBuilder(37).append("INSERT INTO ").append(identifier).append(" SELECT CAST(null AS INT)").toString());
        SparkContext qual$33 = $this.spark().sparkContext();
        Seq x$81 = ((InMemoryTable)table).rows();
        int x$82 = qual$33.parallelize$default$2();
        RDD rdd2 = qual$33.parallelize(x$81, x$82, ClassTag$.MODULE$.apply(InternalRow.class));
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> {
            SparkSession qual$34 = $this.spark();
            RDD x$83 = rdd2;
            StructType x$84 = table.schema();
            boolean x$85 = qual$34.internalCreateDataFrame$default$3();
            return qual$34.internalCreateDataFrame(x$83, x$84, x$85);
        }, (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null})), (List)Nil$.MODULE$))));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$93(DataSourceV2SQLSuite $this, String t) {
        String view = "view";
        $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{view}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(54).append("CREATE TABLE ").append(t).append(" USING foo AS SELECT id, data FROM source").toString());
            $this.sql().apply((Object)new StringBuilder(31).append("CACHE TABLE ").append(view).append(" AS SELECT id FROM ").append(t).toString());
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(t).toString()), (Dataset<Row>)$this.spark().table("source"));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(view).toString()), (Dataset<Row>)$this.spark().table("source").select("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])));
            Dataset oldView = $this.spark().table(view);
            $this.sql().apply((Object)new StringBuilder(35).append("REPLACE TABLE ").append(t).append(" (a bigint) USING foo").toString());
            Option $org_scalatest_assert_macro_left = $this.spark().sharedState().cacheManager().lookupCachedData(oldView);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 767));
        }));
    }

    public static final /* synthetic */ void $anonfun$new$99(DataSourceV2SQLSuite $this, String t) {
        String view = "view";
        $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{view}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(54).append("CREATE TABLE ").append(t).append(" USING foo AS SELECT id, data FROM source").toString());
            $this.sql().apply((Object)new StringBuilder(31).append("CACHE TABLE ").append(view).append(" AS SELECT id FROM ").append(t).toString());
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(t).toString()), (Dataset<Row>)$this.spark().table("source"));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(view).toString()), (Dataset<Row>)$this.spark().table("source").select("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])));
            $this.sql().apply((Object)new StringBuilder(49).append("REPLACE TABLE ").append(t).append(" USING foo AS SELECT id FROM source").toString());
            Option $org_scalatest_assert_macro_left = $this.spark().sharedState().cacheManager().lookupCachedData($this.spark().table(view));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 784));
        }));
    }

    public static final /* synthetic */ void $anonfun$new$127(DataSourceV2SQLSuite $this, String t$9, File checkpointDir) {
        $this.sql().apply((Object)new StringBuilder(48).append("CREATE TABLE ").append(t$9).append(" (id bigint, data string) USING foo").toString());
        $this.sql().apply((Object)new StringBuilder(29).append("INSERT INTO ").append(t$9).append(" VALUES (1L, 'a')").toString());
        $this.sql().apply((Object)new StringBuilder(12).append("CACHE TABLE ").append(t$9).toString());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuite$$typecreator47$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_connector_DataSourceV2SQLSuite$$typecreator47$1(DataSourceV2SQLSuite $outer) {
            }
        }
        MemoryStream inputData = MemoryStream$.MODULE$.apply($this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuite$$typecreator47$1(null))), $this.sqlContext());
        Dataset df = inputData.toDF().toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data"}));
        StreamingQuery query = df.writeStream().option("checkpointLocation", checkpointDir.getAbsolutePath()).toTable(t$9);
        Seq newData = (Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)2L), (Object)"b"), (List)Nil$.MODULE$);
        inputData.addData((TraversableOnce)newData);
        query.processAllAvailable();
        query.stop();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool($this.spark().catalog().isCached("testcat.ns.t"), "DataSourceV2SQLSuite.this.spark.catalog.isCached(\"testcat.ns.t\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 873));
        Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)1L), "a"}));
        Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)2L), "b"}));
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(t$9).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row2).$colon$colon((Object)row));
    }

    private final void check$1(String tbl) {
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(64).append("SELECT testcat.ns1.ns2.tbl.id, testcat.ns1.ns2.tbl.point.x FROM ").append(tbl).toString()), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)10)})));
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(48).append("SELECT ns1.ns2.tbl.id, ns1.ns2.tbl.point.x FROM ").append(tbl).toString()), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)10)})));
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(40).append("SELECT ns2.tbl.id, ns2.tbl.point.x FROM ").append(tbl).toString()), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)10)})));
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(32).append("SELECT tbl.id, tbl.point.x FROM ").append(tbl).toString()), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)10)})));
    }

    public static final /* synthetic */ void $anonfun$new$154(DataSourceV2SQLSuite $this, boolean useV1Table) {
        String format;
        String string = format = useV1Table ? "json" : $this.v2Format();
        if (useV1Table) {
            $this.spark().conf().unset(SQLConf$.MODULE$.V2_SESSION_CATALOG_IMPLEMENTATION().key());
        } else {
            $this.spark().conf().set(SQLConf$.MODULE$.V2_SESSION_CATALOG_IMPLEMENTATION().key(), InMemoryTableSessionCatalog.class.getName());
        }
        $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.sql().apply((Object)new StringBuilder(38).append("CREATE TABLE t USING ").append(format).append(" AS SELECT 1 AS i").toString());
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"select i from t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"select t.i from t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"select default.t.i from t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"select spark_catalog.default.t.i from t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"select t.i from spark_catalog.default.t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"select default.t.i from spark_catalog.default.t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"select spark_catalog.default.t.i from spark_catalog.default.t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
        });
    }

    public static final /* synthetic */ void $anonfun$new$174(DataSourceV2SQLSuite $this, File tmpDir) {
        String path = tmpDir.getCanonicalPath();
        $this.sql().apply((Object)new StringBuilder(41).append("CREATE NAMESPACE testcat.test LOCATION '").append(path).append("'").toString());
        scala.collection.mutable.Map metadata = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(CatalogV2Implicits$.MODULE$.CatalogHelper($this.catalog("testcat")).asNamespaceCatalog().loadNamespaceMetadata((String[])((Object[])new String[]{"test"}))).asScala();
        String catalogPath = (String)metadata.apply((Object)"location");
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(catalogPath.equals(catalogPath), "catalogPath.equals(catalogPath)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1043));
    }

    public static final /* synthetic */ boolean $anonfun$new$180(String x$18) {
        String string = x$18;
        String string2 = "comment";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$184(String x$19) {
        String string = x$19;
        String string2 = "comment";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$190(String x$20) {
        String string = x$20;
        String string2 = "comment";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$new$192(DataSourceV2SQLSuite $this, String key$3, String clause) {
        ((IterableLike)new .colon.colon((Object)"CREATE", (List)new .colon.colon((Object)"REPLACE", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)action -> {
            ParseException e = (ParseException)$this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(59).append((String)action).append(" TABLE testcat.reservedTest (key int) USING foo ").append(clause).append(" ('").append(key$3).append("'='bar')").toString()), ClassTag$.MODULE$.apply(ParseException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1096));
            String $org_scalatest_assert_macro_left = e.getMessage();
            String $org_scalatest_assert_macro_right = new StringBuilder(29).append(key$3).append(" is a reserved table property").toString();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1099));
        });
    }

    public static final /* synthetic */ boolean $anonfun$new$198(String x$21) {
        String string = x$21;
        String string2 = "comment";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$new$199(DataSourceV2SQLSuite $this, String key) {
        ((IterableLike)new .colon.colon((Object)"OPTIONS", (List)new .colon.colon((Object)"TBLPROPERTIES", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)clause -> {
            $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"testcat.reservedTest"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"CREATE", (List)new .colon.colon((Object)"REPLACE", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)action -> {
                String originValue;
                $this.sql().apply((Object)new StringBuilder(59).append((String)action).append(" TABLE testcat.reservedTest (key int) USING foo ").append(clause).append(" ('").append(key$4).append("'='bar')").toString());
                TableCatalog tableCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper($this.catalog("testcat")).asTableCatalog();
                Identifier identifier = Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"reservedTest");
                String $org_scalatest_assert_macro_left = originValue = (String)tableCatalog.loadTable(identifier).properties().get(key$4);
                String $org_scalatest_assert_macro_right = "bar";
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", (Object)$org_scalatest_assert_macro_right, string == null ? string2 != null : !string.equals(string2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"reserved properties should not have side effects", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1123));
                $this.sql().apply((Object)new StringBuilder(66).append("ALTER TABLE testcat.reservedTest SET TBLPROPERTIES ('").append(key$4).append("'='newValue')").toString());
                String $org_scalatest_assert_macro_left2 = (String)tableCatalog.loadTable(identifier).properties().get(key$4);
                String $org_scalatest_assert_macro_right2 = originValue;
                String string3 = $org_scalatest_assert_macro_left2;
                String string4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"reserved properties should not have side effects", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1125));
                $this.sql().apply((Object)new StringBuilder(57).append("ALTER TABLE testcat.reservedTest UNSET TBLPROPERTIES ('").append(key$4).append("')").toString());
                String $org_scalatest_assert_macro_left3 = (String)tableCatalog.loadTable(identifier).properties().get(key$4);
                String $org_scalatest_assert_macro_right3 = originValue;
                String string5 = $org_scalatest_assert_macro_left3;
                String string6 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"reserved properties should not have side effects", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1128));
            }));
            return BoxedUnit.UNIT;
        });
    }

    private final void assertDropFails$1() {
        SparkException e = (SparkException)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"DROP NAMESPACE testcat.ns1"), ClassTag$.MODULE$.apply(SparkException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1192)));
        String $org_scalatest_assert_macro_left = e.getMessage();
        String $org_scalatest_assert_macro_right = "Cannot drop a non-empty namespace: ns1";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1195));
    }

    public static final /* synthetic */ boolean $anonfun$new$223(String x$22) {
        String string = x$22;
        String string2 = "comment";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$228(String x$23) {
        String string = x$23;
        String string2 = "comment";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private final void testShowCurrentNamespace$1(String expectedCatalogName, String expectedNamespace) {
        StructType schema = new StructType().add("catalog", (DataType)StringType$.MODULE$, false).add("namespace", (DataType)StringType$.MODULE$, false);
        Dataset df = (Dataset)this.sql().apply((Object)"SHOW CURRENT NAMESPACE");
        Row[] rows = (Row[])df.collect();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(df.schema());
        StructType $org_scalatest_assert_macro_right = schema;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1410));
        Row[] $org_scalatest_assert_macro_left2 = rows;
        int $org_scalatest_assert_macro_right2 = 1;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1411));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(rows[0].getAs(0));
        String $org_scalatest_assert_macro_right3 = expectedCatalogName;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1412));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(rows[0].getAs(1));
        String $org_scalatest_assert_macro_right4 = expectedNamespace;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1413));
    }

    private final void checkPartitioning$1(TableCatalog cat, String partition) {
        String string = cat.name();
        String string2 = CatalogManager$.MODULE$.SESSION_CATALOG_NAME();
        String[] namespace = !(string != null ? !string.equals(string2) : string2 != null) ? (String[])((Object[])new String[]{"default"}) : (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
        Table table = cat.loadTable(Identifier.of((String[])namespace, (String)"tbl"));
        NamedReference[][] partitions = (NamedReference[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])table.partitioning())).map((Function1 & Serializable & scala.Serializable)x$25 -> x$25.references(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(NamedReference.class))));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)partitions.length));
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1439));
        String[][] fieldNames = (String[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitions)).flatMap((Function1 & Serializable & scala.Serializable)x$26 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$26)).map((Function1 & Serializable & scala.Serializable)x$27 -> x$27.fieldNames(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(fieldNames);
        String[][] $org_scalatest_assert_macro_right2 = (String[][])((Object[])new String[][]{(String[])((Object[])new String[]{partition})});
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1441));
    }

    private final void checkFailure$1(String statement) {
        this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CASE_SENSITIVE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            AnalysisException e = (AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)statement), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1457))));
            String $org_scalatest_assert_macro_left = e.getMessage();
            String $org_scalatest_assert_macro_right = "Couldn't find column";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1460));
        });
    }

    public static final /* synthetic */ void $anonfun$new$251(DataSourceV2SQLSuite $this, String errorMsg$1, Tuple2 x0$6) {
        Tuple2 tuple2;
        boolean caseSensitive;
        block3: {
            Tuple2 tuple22;
            block2: {
                tuple22 = x0$6;
                if (tuple22 == null) break block2;
                caseSensitive = tuple22._1$mcZ$sp();
                tuple2 = (Tuple2)tuple22._2();
                if (tuple2 != null) break block3;
            }
            throw new MatchError((Object)tuple22);
        }
        String c0 = (String)tuple2._1();
        String c1 = (String)tuple2._2();
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CASE_SENSITIVE().key()), (Object)Boolean.toString(caseSensitive))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.assertAnalysisError(new StringBuilder(34).append("CREATE TABLE t (").append(c0).append(" INT, ").append(c1).append(" INT) USING ").append($this.v2Source()).toString(), new StringBuilder(10).append(errorMsg$1).append(" default.t").toString());
            $this.assertAnalysisError(new StringBuilder(42).append("CREATE TABLE testcat.t (").append(c0).append(" INT, ").append(c1).append(" INT) USING ").append($this.v2Source()).toString(), new StringBuilder(2).append(errorMsg$1).append(" t").toString());
            $this.assertAnalysisError(new StringBuilder(45).append("CREATE OR REPLACE TABLE t (").append(c0).append(" INT, ").append(c1).append(" INT) USING ").append($this.v2Source()).toString(), new StringBuilder(10).append(errorMsg$1).append(" default.t").toString());
            $this.assertAnalysisError(new StringBuilder(53).append("CREATE OR REPLACE TABLE testcat.t (").append(c0).append(" INT, ").append(c1).append(" INT) USING ").append($this.v2Source()).toString(), new StringBuilder(2).append(errorMsg$1).append(" t").toString());
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$254(DataSourceV2SQLSuite $this, String errorMsg$2, Tuple2 x0$7) {
        Tuple2 tuple2;
        boolean caseSensitive;
        block3: {
            Tuple2 tuple22;
            block2: {
                tuple22 = x0$7;
                if (tuple22 == null) break block2;
                caseSensitive = tuple22._1$mcZ$sp();
                tuple2 = (Tuple2)tuple22._2();
                if (tuple2 != null) break block3;
            }
            throw new MatchError((Object)tuple22);
        }
        String c0 = (String)tuple2._1();
        String c1 = (String)tuple2._2();
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CASE_SENSITIVE().key()), (Object)Boolean.toString(caseSensitive))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.assertAnalysisError(new StringBuilder(46).append("CREATE TABLE t (d struct<").append(c0).append(": INT, ").append(c1).append(": INT>) USING ").append($this.v2Source()).toString(), new StringBuilder(10).append(errorMsg$2).append(" default.t").toString());
            $this.assertAnalysisError(new StringBuilder(54).append("CREATE TABLE testcat.t (d struct<").append(c0).append(": INT, ").append(c1).append(": INT>) USING ").append($this.v2Source()).toString(), new StringBuilder(2).append(errorMsg$2).append(" t").toString());
            $this.assertAnalysisError(new StringBuilder(57).append("CREATE OR REPLACE TABLE t (d struct<").append(c0).append(": INT, ").append(c1).append(": INT>) USING ").append($this.v2Source()).toString(), new StringBuilder(10).append(errorMsg$2).append(" default.t").toString());
            $this.assertAnalysisError(new StringBuilder(65).append("CREATE OR REPLACE TABLE testcat.t (d struct<").append(c0).append(": INT, ").append(c1).append(": INT>) USING ").append($this.v2Source()).toString(), new StringBuilder(2).append(errorMsg$2).append(" t").toString());
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$261(DataSourceV2SQLSuite $this, String errorMsg$3, Tuple2 x0$8) {
        Tuple2 tuple2;
        boolean caseSensitive;
        block3: {
            Tuple2 tuple22;
            block2: {
                tuple22 = x0$8;
                if (tuple22 == null) break block2;
                caseSensitive = tuple22._1$mcZ$sp();
                tuple2 = (Tuple2)tuple22._2();
                if (tuple2 != null) break block3;
            }
            throw new MatchError((Object)tuple22);
        }
        String c0 = (String)tuple2._1();
        String c1 = (String)tuple2._2();
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CASE_SENSITIVE().key()), (Object)Boolean.toString(caseSensitive))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.assertAnalysisError(new StringBuilder(48).append("CREATE TABLE t (").append(c0).append(" INT) USING ").append($this.v2Source()).append(" PARTITIONED BY (").append(c0).append(", ").append(c1).append(")").toString(), errorMsg$3);
            $this.assertAnalysisError(new StringBuilder(56).append("CREATE TABLE testcat.t (").append(c0).append(" INT) USING ").append($this.v2Source()).append(" PARTITIONED BY (").append(c0).append(", ").append(c1).append(")").toString(), errorMsg$3);
            $this.assertAnalysisError(new StringBuilder(59).append("CREATE OR REPLACE TABLE t (").append(c0).append(" INT) USING ").append($this.v2Source()).append(" PARTITIONED BY (").append(c0).append(", ").append(c1).append(")").toString(), errorMsg$3);
            $this.assertAnalysisError(new StringBuilder(67).append("CREATE OR REPLACE TABLE testcat.t (").append(c0).append(" INT) USING ").append($this.v2Source()).append(" PARTITIONED BY (").append(c0).append(", ").append(c1).append(")").toString(), errorMsg$3);
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$264(DataSourceV2SQLSuite $this, String errorMsg$4, Tuple2 x0$9) {
        Tuple2 tuple2;
        boolean caseSensitive;
        block3: {
            Tuple2 tuple22;
            block2: {
                tuple22 = x0$9;
                if (tuple22 == null) break block2;
                caseSensitive = tuple22._1$mcZ$sp();
                tuple2 = (Tuple2)tuple22._2();
                if (tuple2 != null) break block3;
            }
            throw new MatchError((Object)tuple22);
        }
        String c0 = (String)tuple2._1();
        String c1 = (String)tuple2._2();
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.CASE_SENSITIVE().key()), (Object)Boolean.toString(caseSensitive))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.assertAnalysisError(new StringBuilder(61).append("CREATE TABLE t (").append(c0).append(" INT) USING ").append($this.v2Source()).append(" ").append("CLUSTERED BY (").append(c0).append(", ").append(c1).append(") INTO 2 BUCKETS").toString(), errorMsg$4);
            $this.assertAnalysisError(new StringBuilder(69).append("CREATE TABLE testcat.t (").append(c0).append(" INT) USING ").append($this.v2Source()).append(" ").append("CLUSTERED BY (").append(c0).append(", ").append(c1).append(") INTO 2 BUCKETS").toString(), errorMsg$4);
            $this.assertAnalysisError(new StringBuilder(72).append("CREATE OR REPLACE TABLE t (").append(c0).append(" INT) USING ").append($this.v2Source()).append(" ").append("CLUSTERED BY (").append(c0).append(", ").append(c1).append(") INTO 2 BUCKETS").toString(), errorMsg$4);
            $this.assertAnalysisError(new StringBuilder(80).append("CREATE OR REPLACE TABLE testcat.t (").append(c0).append(" INT) USING ").append($this.v2Source()).append(" ").append("CLUSTERED BY (").append(c0).append(", ").append(c1).append(") INTO 2 BUCKETS").toString(), errorMsg$4);
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final boolean isCached$1(String table) {
        return this.spark().table(table).queryExecution().withCachedData() instanceof InMemoryRelation;
    }

    private final void verify$1(String sql, String t$34) {
        AnalysisException e = (AnalysisException)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.spark().sql(sql), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2303)));
        String $org_scalatest_assert_macro_left = e.message();
        String $org_scalatest_assert_macro_right = new StringBuilder(25).append("Table or view not found: ").append(t$34).toString();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(60).append("Error message did not contain expected text while evaluting ").append(sql).toString(), Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2304));
    }

    private final void verifyView$1(String sql, String t$34) {
        AnalysisException e = (AnalysisException)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.spark().sql(sql), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2309)));
        String $org_scalatest_assert_macro_left = e.message();
        String $org_scalatest_assert_macro_right = new StringBuilder(16).append("View not found: ").append(t$34).toString();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(60).append("Error message did not contain expected text while evaluting ").append(sql).toString(), Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2310));
    }

    private final void verifyTable$1(String sql, String t$34) {
        AnalysisException e = (AnalysisException)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.spark().sql(sql), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2315)));
        String $org_scalatest_assert_macro_left = e.message();
        String $org_scalatest_assert_macro_right = new StringBuilder(17).append("Table not found: ").append(t$34).toString();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(60).append("Error message did not contain expected text while evaluting ").append(sql).toString(), Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2316));
    }

    private final void verifyGeneric$1(String sql, String t$34) {
        AnalysisException e = (AnalysisException)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.spark().sql(sql), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2321)));
        String $org_scalatest_assert_macro_left = e.message();
        String $org_scalatest_assert_macro_right = new StringBuilder(11).append("not found: ").append(t$34).toString();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(60).append("Error message did not contain expected text while evaluting ").append(sql).toString(), Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2322));
    }

    private final void assertWrongTableIdent$1() {
        this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE t USING json AS SELECT 1 AS i");
            String t = "spark_catalog.t";
            this.verify$1(new StringBuilder(14).append("select * from ").append(t).toString(), t);
            this.verify$1(new StringBuilder(14).append("REFRESH TABLE ").append(t).toString(), t);
            this.verify$1(new StringBuilder(11).append("DESCRIBE ").append(t).append(" i").toString(), t);
            this.verify$1(new StringBuilder(11).append("DROP TABLE ").append(t).toString(), t);
            this.verifyView$1(new StringBuilder(10).append("DROP VIEW ").append(t).toString(), t);
            this.verifyGeneric$1(new StringBuilder(33).append("ANALYZE TABLE ").append(t).append(" COMPUTE STATISTICS").toString(), t);
            this.verifyGeneric$1(new StringBuilder(49).append("ANALYZE TABLE ").append(t).append(" COMPUTE STATISTICS FOR ALL COLUMNS").toString(), t);
            this.verifyTable$1(new StringBuilder(18).append("MSCK REPAIR TABLE ").append(t).toString(), t);
            this.verifyTable$1(new StringBuilder(39).append("LOAD DATA INPATH 'filepath' INTO TABLE ").append(t).toString(), t);
            this.verifyGeneric$1(new StringBuilder(18).append("SHOW CREATE TABLE ").append(t).toString(), t);
            this.verifyGeneric$1(new StringBuilder(27).append("SHOW CREATE TABLE ").append(t).append(" AS SERDE").toString(), t);
            this.verifyGeneric$1(new StringBuilder(12).append("CACHE TABLE ").append(t).toString(), t);
            this.verifyGeneric$1(new StringBuilder(14).append("UNCACHE TABLE ").append(t).toString(), t);
            this.verifyGeneric$1(new StringBuilder(15).append("TRUNCATE TABLE ").append(t).toString(), t);
            this.verify$1(new StringBuilder(18).append("SHOW COLUMNS FROM ").append(t).toString(), t);
        });
    }

    private final void check$2(String tbl) {
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(34).append("SELECT testcat.ns1.ns2.tbl.* FROM ").append(tbl).toString()), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "hello"})));
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(26).append("SELECT ns1.ns2.tbl.* FROM ").append(tbl).toString()), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "hello"})));
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(22).append("SELECT ns2.tbl.* FROM ").append(tbl).toString()), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "hello"})));
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(18).append("SELECT tbl.* FROM ").append(tbl).toString()), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "hello"})));
    }

    private static final Timestamp testTimestamp$1(int daysOffset) {
        return Timestamp.valueOf(LocalDate.of(2020, 1, 1 + daysOffset).atStartOfDay());
    }

    private final void validateViewCommand$1(String sql, String catalogName, String viewName, String cmdName) {
        this.assertAnalysisError(sql, new StringBuilder(117).append("Cannot specify catalog `").append(catalogName).append("` for view ").append(viewName).append(" because view support ").append("in v2 catalog has not been implemented yet. ").append(cmdName).append(" expects a view.").toString());
    }

    public DataSourceV2SQLSuite() {
        super(true, true);
        AlterTableTests.$init$(this);
        DatasourceV2SQLBase.$init$(this);
        this.v2Source = FakeV2Provider.class.getName();
        this.v2Format = this.v2Source();
        this.catalogAndNamespace = "testcat.ns1.ns2.";
        this.defaultUser = Utils$.MODULE$.getCurrentUserName();
        this.test("CreateTable: use v2 plan because catalog is set", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql("CREATE TABLE testcat.table_name (id bigint NOT NULL, data string) USING foo");
            TableCatalog testCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            Table table = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            String $org_scalatest_assert_macro_left = table.name();
            String $org_scalatest_assert_macro_right = "testcat.table_name";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
            Object[] $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])table.partitioning());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left2), "isEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left2).isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
            java.util.Map $org_scalatest_assert_macro_left3 = table.properties();
            java.util.Map $org_scalatest_assert_macro_right2 = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)"foo")})))).asJava();
            java.util.Map map = $org_scalatest_assert_macro_left3;
            java.util.Map map2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(map != null ? !((Object)map).equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
            StructType $org_scalatest_assert_macro_left4 = table.schema();
            StructType $org_scalatest_assert_macro_right3 = new StructType().add("id", (DataType)LongType$.MODULE$, false).add("data", (DataType)StringType$.MODULE$);
            StructType structType = $org_scalatest_assert_macro_left4;
            StructType structType2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
            SparkContext qual$1 = this.spark().sparkContext();
            Seq x$1 = ((InMemoryTable)table).rows();
            int x$2 = qual$1.parallelize$default$2();
            RDD rdd = qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(InternalRow.class));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> {
                SparkSession qual$2 = this.spark();
                RDD x$3 = rdd;
                StructType x$4 = table.schema();
                boolean x$5 = qual$2.internalCreateDataFrame$default$3();
                return qual$2.internalCreateDataFrame(x$3, x$4, x$5);
            }, (Seq<Row>)((Seq)Nil$.MODULE$));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        this.test("DescribeTable using v2 catalog", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            this.spark().sql("CREATE TABLE testcat.table_name (id bigint, data string) USING foo PARTITIONED BY (id)");
            Dataset descriptionDf = this.spark().sql("DESCRIBE TABLE testcat.table_name");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(descriptionDf.schema().map((Function1 & Serializable & scala.Serializable)field -> new Tuple2((Object)field.name(), (Object)field.dataType()), Seq$.MODULE$.canBuildFrom()));
            Seq $org_scalatest_assert_macro_right = (Seq)new .colon.colon((Object)new Tuple2((Object)"col_name", (Object)StringType$.MODULE$), (List)new .colon.colon((Object)new Tuple2((Object)"data_type", (Object)StringType$.MODULE$), (List)new .colon.colon((Object)new Tuple2((Object)"comment", (Object)StringType$.MODULE$), (List)Nil$.MODULE$)));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
            Row[] description = (Row[])descriptionDf.collect();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(description);
            Seq $org_scalatest_assert_macro_right2 = (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"id", "bigint", ""})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"data", "string", ""})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"", "", ""})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"# Partitioning", "", ""})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Part 0", "id", ""})), (List)Nil$.MODULE$)))));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
            AnalysisException e = (AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"DESCRIBE TABLE testcat.table_name PARTITION (id = 1)"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110))));
            String $org_scalatest_assert_macro_left3 = e.message();
            String $org_scalatest_assert_macro_right3 = "DESCRIBE does not support partition for v2 tables";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
        this.test("DescribeTable with v2 catalog when table does not exist.", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> (AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.spark().sql("DESCRIBE TABLE testcat.table_name"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117)))), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
        this.test("DescribeTable extended using v2 catalog", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            this.spark().sql("CREATE TABLE testcat.table_name (id bigint, data string) USING foo PARTITIONED BY (id) TBLPROPERTIES ('bar'='baz') COMMENT 'this is a test table' LOCATION '/tmp/testcat/table_name'");
            Dataset descriptionDf = this.spark().sql("DESCRIBE TABLE EXTENDED testcat.table_name");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(descriptionDf.schema().map((Function1 & Serializable & scala.Serializable)field -> new Tuple2((Object)field.name(), (Object)field.dataType()), Seq$.MODULE$.canBuildFrom()));
            Seq $org_scalatest_assert_macro_right = (Seq)new .colon.colon((Object)new Tuple2((Object)"col_name", (Object)StringType$.MODULE$), (List)new .colon.colon((Object)new Tuple2((Object)"data_type", (Object)StringType$.MODULE$), (List)new .colon.colon((Object)new Tuple2((Object)"comment", (Object)StringType$.MODULE$), (List)Nil$.MODULE$)));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])descriptionDf.collect())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toSeq(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Seq.class))))).map((Function1 & Serializable & scala.Serializable)x$2 -> (String[])Predef$.MODULE$.genericArrayOps(x$2.toArray(ClassTag$.MODULE$.Any())).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toString().trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)))));
            String[][] $org_scalatest_assert_macro_right2 = (String[][])((Object[])new String[][]{(String[])((Object[])new String[]{"id", "bigint", ""}), (String[])((Object[])new String[]{"data", "string", ""}), (String[])((Object[])new String[]{"", "", ""}), (String[])((Object[])new String[]{"# Partitioning", "", ""}), (String[])((Object[])new String[]{"Part 0", "id", ""}), (String[])((Object[])new String[]{"", "", ""}), (String[])((Object[])new String[]{"# Metadata Columns", "", ""}), (String[])((Object[])new String[]{"index", "int", "Metadata column used to conflict with a data column"}), (String[])((Object[])new String[]{"_partition", "string", "Partition key used to store the row"}), (String[])((Object[])new String[]{"", "", ""}), (String[])((Object[])new String[]{"# Detailed Table Information", "", ""}), (String[])((Object[])new String[]{"Name", "testcat.table_name", ""}), (String[])((Object[])new String[]{"Comment", "this is a test table", ""}), (String[])((Object[])new String[]{"Location", "/tmp/testcat/table_name", ""}), (String[])((Object[])new String[]{"Provider", "foo", ""}), (String[])((Object[])new String[]{new StringOps(Predef$.MODULE$.augmentString("owner")).capitalize(), this.defaultUser(), ""}), (String[])((Object[])new String[]{"Table Properties", "[bar=baz]", ""})});
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
        this.test("Describe column for v2 catalog", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "testcat.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(64).append("CREATE TABLE ").append(t).append(" (id bigint, data string COMMENT 'hello') USING foo").toString());
                Dataset df1 = (Dataset)this.sql().apply((Object)new StringBuilder(12).append("DESCRIBE ").append(t).append(" id").toString());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(df1.schema().map((Function1 & Serializable & scala.Serializable)field -> new Tuple2((Object)field.name(), (Object)field.dataType()), Seq$.MODULE$.canBuildFrom()));
                Seq $org_scalatest_assert_macro_right = (Seq)new .colon.colon((Object)new Tuple2((Object)"info_name", (Object)StringType$.MODULE$), (List)new .colon.colon((Object)new Tuple2((Object)"info_value", (Object)StringType$.MODULE$), (List)Nil$.MODULE$));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(df1.collect());
                Seq $org_scalatest_assert_macro_right2 = (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"col_name", "id"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"data_type", "bigint"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"comment", "NULL"})), (List)Nil$.MODULE$)));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
                Dataset df2 = (Dataset)this.sql().apply((Object)new StringBuilder(14).append("DESCRIBE ").append(t).append(" data").toString());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(df2.schema().map((Function1 & Serializable & scala.Serializable)field -> new Tuple2((Object)field.name(), (Object)field.dataType()), Seq$.MODULE$.canBuildFrom()));
                Seq $org_scalatest_assert_macro_right3 = (Seq)new .colon.colon((Object)new Tuple2((Object)"info_name", (Object)StringType$.MODULE$), (List)new .colon.colon((Object)new Tuple2((Object)"info_value", (Object)StringType$.MODULE$), (List)Nil$.MODULE$));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(df2.collect());
                Seq $org_scalatest_assert_macro_right4 = (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"col_name", "data"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"data_type", "string"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"comment", "hello"})), (List)Nil$.MODULE$)));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
                this.assertAnalysisError(new StringBuilder(21).append("DESCRIBE ").append(t).append(" invalid_col").toString(), "cannot resolve 'invalid_col' given input columns: [testcat.tbl.data, testcat.tbl.id]");
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
        this.test("Describe column for v2 catalog should work with qualified columns", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "testcat.ns.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(35).append("CREATE TABLE ").append(t).append(" (id bigint) USING foo").toString());
                ((IterableLike)new .colon.colon((Object)"testcat.ns.tbl.id", (List)new .colon.colon((Object)"ns.tbl.id", (List)new .colon.colon((Object)"tbl.id", (List)new .colon.colon((Object)"id", (List)Nil$.MODULE$))))).foreach((Function1 & Serializable & scala.Serializable)col -> {
                    Dataset df = (Dataset)this.sql().apply((Object)new StringBuilder(10).append("DESCRIBE ").append(t).append(" ").append((String)col).toString());
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(df.schema().map((Function1 & Serializable & scala.Serializable)field -> new Tuple2((Object)field.name(), (Object)field.dataType()), Seq$.MODULE$.canBuildFrom()));
                    Seq $org_scalatest_assert_macro_right = (Seq)new .colon.colon((Object)new Tuple2((Object)"info_name", (Object)StringType$.MODULE$), (List)new .colon.colon((Object)new Tuple2((Object)"info_value", (Object)StringType$.MODULE$), (List)Nil$.MODULE$));
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(df.collect());
                    Seq $org_scalatest_assert_macro_right2 = (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"col_name", "id"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"data_type", "bigint"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"comment", "NULL"})), (List)Nil$.MODULE$)));
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
                });
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
        this.test("Describing nested column for v2 catalog is not supported", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "testcat.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(50).append("CREATE TABLE ").append(t).append(" (d struct<a: INT, b: INT>) USING foo").toString());
                this.assertAnalysisError(new StringBuilder(13).append("describe ").append(t).append(" d.a").toString(), "DESC TABLE COLUMN does not support nested column");
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 198));
        this.test("SPARK-33004: Describe column should resolve to a temporary view first", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"testcat.ns.t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE testcat.ns.t (id bigint) USING foo");
            this.sql().apply((Object)"CREATE TEMPORARY VIEW t AS SELECT 2 as i");
            this.sql().apply((Object)"USE testcat.ns");
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"DESCRIBE t i"), (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"col_name", "i"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"data_type", "int"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"comment", "NULL"})), (List)Nil$.MODULE$)))));
        })), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 208));
        this.test("CreateTable: use v2 plan and session catalog when provider is v2", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringBuilder(55).append("CREATE TABLE table_name (id bigint, data string) USING ").append(this.v2Source()).toString());
            TableCatalog testCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog(CatalogManager$.MODULE$.SESSION_CATALOG_NAME())).asTableCatalog();
            Table table = testCatalog.loadTable(Identifier.of((String[])((String[])((Object[])new String[]{"default"})), (String)"table_name"));
            String $org_scalatest_assert_macro_left = table.name();
            String $org_scalatest_assert_macro_right = "default.table_name";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229));
            Object[] $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])table.partitioning());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left2), "isEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left2).isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230));
            java.util.Map $org_scalatest_assert_macro_left3 = table.properties();
            java.util.Map $org_scalatest_assert_macro_right2 = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)this.v2Source())})))).asJava();
            java.util.Map map = $org_scalatest_assert_macro_left3;
            java.util.Map map2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(map != null ? !((Object)map).equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 231));
            StructType $org_scalatest_assert_macro_left4 = table.schema();
            StructType $org_scalatest_assert_macro_right3 = new StructType().add("id", (DataType)LongType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
            StructType structType = $org_scalatest_assert_macro_left4;
            StructType structType2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232));
            SparkContext qual$3 = this.spark().sparkContext();
            Seq x$6 = ((InMemoryTable)table).rows();
            int x$7 = qual$3.parallelize$default$2();
            RDD rdd = qual$3.parallelize(x$6, x$7, ClassTag$.MODULE$.apply(InternalRow.class));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> {
                SparkSession qual$4 = this.spark();
                RDD x$8 = rdd;
                StructType x$9 = table.schema();
                boolean x$10 = qual$4.internalCreateDataFrame$default$3();
                return qual$4.internalCreateDataFrame(x$8, x$9, x$10);
            }, (Seq<Row>)((Seq)Nil$.MODULE$));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 223));
        this.test("CreateTable: fail if table exists", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql("CREATE TABLE testcat.table_name (id bigint, data string) USING foo");
            TableCatalog testCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            Table table = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            String $org_scalatest_assert_macro_left = table.name();
            String $org_scalatest_assert_macro_right = "testcat.table_name";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 244));
            Object[] $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])table.partitioning());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left2), "isEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left2).isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 245));
            java.util.Map $org_scalatest_assert_macro_left3 = table.properties();
            java.util.Map $org_scalatest_assert_macro_right2 = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)"foo")})))).asJava();
            java.util.Map map = $org_scalatest_assert_macro_left3;
            java.util.Map map2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(map != null ? !((Object)map).equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 246));
            StructType $org_scalatest_assert_macro_left4 = table.schema();
            StructType $org_scalatest_assert_macro_right3 = new StructType().add("id", (DataType)LongType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
            StructType structType = $org_scalatest_assert_macro_left4;
            StructType structType2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
            TableAlreadyExistsException exc = (TableAlreadyExistsException)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.spark().sql("CREATE TABLE testcat.table_name (id bigint, data string, id2 bigint) USING bar"), ClassTag$.MODULE$.apply(TableAlreadyExistsException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 250));
            String $org_scalatest_assert_macro_left5 = exc.getMessage();
            String $org_scalatest_assert_macro_right4 = "table_name";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left5.contains($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254));
            Table table2 = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            String $org_scalatest_assert_macro_left6 = table2.name();
            String $org_scalatest_assert_macro_right5 = "testcat.table_name";
            String string3 = $org_scalatest_assert_macro_left6;
            String string4 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right5, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 258));
            Object[] $org_scalatest_assert_macro_left7 = Predef$.MODULE$.refArrayOps((Object[])table2.partitioning());
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left7), "isEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left7).isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 259));
            java.util.Map $org_scalatest_assert_macro_left8 = table2.properties();
            java.util.Map $org_scalatest_assert_macro_right6 = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)"foo")})))).asJava();
            java.util.Map map3 = $org_scalatest_assert_macro_left8;
            java.util.Map map4 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right6, !(map3 != null ? !((Object)map3).equals(map4) : map4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 260));
            StructType $org_scalatest_assert_macro_left9 = table2.schema();
            StructType $org_scalatest_assert_macro_right7 = new StructType().add("id", (DataType)LongType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
            StructType structType3 = $org_scalatest_assert_macro_left9;
            StructType structType4 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right7, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 261));
            SparkContext qual$5 = this.spark().sparkContext();
            Seq x$11 = ((InMemoryTable)table).rows();
            int x$12 = qual$5.parallelize$default$2();
            RDD rdd = qual$5.parallelize(x$11, x$12, ClassTag$.MODULE$.apply(InternalRow.class));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> {
                SparkSession qual$6 = this.spark();
                RDD x$13 = rdd;
                StructType x$14 = table.schema();
                boolean x$15 = qual$6.internalCreateDataFrame$default$3();
                return qual$6.internalCreateDataFrame(x$13, x$14, x$15);
            }, (Seq<Row>)((Seq)Nil$.MODULE$));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238));
        this.test("CreateTable: if not exists", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql("CREATE TABLE IF NOT EXISTS testcat.table_name (id bigint, data string) USING foo");
            TableCatalog testCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            Table table = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            String $org_scalatest_assert_macro_left = table.name();
            String $org_scalatest_assert_macro_right = "testcat.table_name";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 275));
            Object[] $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])table.partitioning());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left2), "isEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left2).isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276));
            java.util.Map $org_scalatest_assert_macro_left3 = table.properties();
            java.util.Map $org_scalatest_assert_macro_right2 = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)"foo")})))).asJava();
            java.util.Map map = $org_scalatest_assert_macro_left3;
            java.util.Map map2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(map != null ? !((Object)map).equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 277));
            StructType $org_scalatest_assert_macro_left4 = table.schema();
            StructType $org_scalatest_assert_macro_right3 = new StructType().add("id", (DataType)LongType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
            StructType structType = $org_scalatest_assert_macro_left4;
            StructType structType2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 278));
            this.spark().sql("CREATE TABLE IF NOT EXISTS testcat.table_name (id bigint, data string) USING bar");
            Table table2 = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            String $org_scalatest_assert_macro_left5 = table2.name();
            String $org_scalatest_assert_macro_right4 = "testcat.table_name";
            String string3 = $org_scalatest_assert_macro_left5;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 284));
            Object[] $org_scalatest_assert_macro_left6 = Predef$.MODULE$.refArrayOps((Object[])table2.partitioning());
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left6), "isEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left6).isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 285));
            java.util.Map $org_scalatest_assert_macro_left7 = table2.properties();
            java.util.Map $org_scalatest_assert_macro_right5 = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)"foo")})))).asJava();
            java.util.Map map3 = $org_scalatest_assert_macro_left7;
            java.util.Map map4 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right5, !(map3 != null ? !((Object)map3).equals(map4) : map4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 286));
            StructType $org_scalatest_assert_macro_left8 = table2.schema();
            StructType $org_scalatest_assert_macro_right6 = new StructType().add("id", (DataType)LongType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
            StructType structType3 = $org_scalatest_assert_macro_left8;
            StructType structType4 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right6, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 287));
            SparkContext qual$7 = this.spark().sparkContext();
            Seq x$16 = ((InMemoryTable)table).rows();
            int x$17 = qual$7.parallelize$default$2();
            RDD rdd2 = qual$7.parallelize(x$16, x$17, ClassTag$.MODULE$.apply(InternalRow.class));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> {
                SparkSession qual$8 = this.spark();
                RDD x$18 = rdd2;
                StructType x$19 = table.schema();
                boolean x$20 = qual$8.internalCreateDataFrame$default$3();
                return qual$8.internalCreateDataFrame(x$18, x$19, x$20);
            }, (Seq<Row>)((Seq)Nil$.MODULE$));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 268));
        this.test("CreateTable: use default catalog for v2 sources when default catalog is set", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().conf().set(SQLConf$.MODULE$.DEFAULT_CATALOG().key(), "testcat");
            this.spark().sql("CREATE TABLE table_name (id bigint, data string) USING foo");
            TableCatalog testCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            Table table = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            String $org_scalatest_assert_macro_left = table.name();
            String $org_scalatest_assert_macro_right = "testcat.table_name";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 301));
            Object[] $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])table.partitioning());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left2), "isEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left2).isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 302));
            java.util.Map $org_scalatest_assert_macro_left3 = table.properties();
            java.util.Map $org_scalatest_assert_macro_right2 = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)"foo")})))).asJava();
            java.util.Map map = $org_scalatest_assert_macro_left3;
            java.util.Map map2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(map != null ? !((Object)map).equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 303));
            StructType $org_scalatest_assert_macro_left4 = table.schema();
            StructType $org_scalatest_assert_macro_right3 = new StructType().add("id", (DataType)LongType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
            StructType structType = $org_scalatest_assert_macro_left4;
            StructType structType2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 304));
            SparkContext qual$9 = this.spark().sparkContext();
            Seq x$21 = ((InMemoryTable)table).rows();
            int x$22 = qual$9.parallelize$default$2();
            RDD rdd = qual$9.parallelize(x$21, x$22, ClassTag$.MODULE$.apply(InternalRow.class));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> {
                SparkSession qual$10 = this.spark();
                RDD x$23 = rdd;
                StructType x$24 = table.schema();
                boolean x$25 = qual$10.internalCreateDataFrame$default$3();
                return qual$10.internalCreateDataFrame(x$23, x$24, x$25);
            }, (Seq<Row>)((Seq)Nil$.MODULE$));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 294));
        this.test("CreateTable: without USING clause", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_CREATE_HIVE_TABLE_BY_DEFAULT().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().conf().unset(SQLConf$.MODULE$.V2_SESSION_CATALOG_IMPLEMENTATION().key());
            TableCatalog testCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            this.sql().apply((Object)"CREATE TABLE testcat.t1 (id int)");
            Table t1 = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"t1"));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(t1.properties().containsKey("provider"), "t1.properties().containsKey(\"provider\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 320));
            this.sql().apply((Object)"CREATE TABLE t2 (id int)");
            V1Table t2 = (V1Table)CatalogV2Implicits$.MODULE$.CatalogHelper(this.spark().sessionState().catalogManager().v2SessionCatalog()).asTableCatalog().loadTable(Identifier.of((String[])((String[])((Object[])new String[]{"default"})), (String)"t2"));
            Option $org_scalatest_assert_macro_left = t2.v1Table().provider();
            Some $org_scalatest_assert_macro_right = new Some((Object)this.conf().defaultDataSourceName());
            Option option = $org_scalatest_assert_macro_left;
            Some some = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 326));
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 311));
        this.test("CreateTable/ReplaceTable: invalid schema if has interval type", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"CREATE", (List)new .colon.colon((Object)"REPLACE", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)action -> {
            AnalysisException e1 = (AnalysisException)((Object)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(49).append((String)action).append(" TABLE table_name (id int, value interval) USING ").append(this.v2Format()).toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 332)))));
            String $org_scalatest_assert_macro_left = e1.getMessage();
            String $org_scalatest_assert_macro_right = "Cannot use interval type in the table schema.";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 334));
            AnalysisException e2 = (AnalysisException)((Object)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(45).append((String)action).append(" TABLE table_name (id array<interval>) USING ").append(this.v2Format()).toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 335)))));
            String $org_scalatest_assert_macro_left2 = e2.getMessage();
            String $org_scalatest_assert_macro_right2 = "Cannot use interval type in the table schema.";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 337));
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 330));
        this.test("CTAS/RTAS: invalid schema if has interval type", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"CREATE", (List)new .colon.colon((Object)"REPLACE", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)action -> {
            AnalysisException e1 = (AnalysisException)((Object)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(49).append((String)action).append(" TABLE table_name USING ").append(this.v2Format()).append(" as select interval 1 day").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 343)))));
            String $org_scalatest_assert_macro_left = e1.getMessage();
            String $org_scalatest_assert_macro_right = "Cannot use interval type in the table schema.";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 345));
            AnalysisException e2 = (AnalysisException)((Object)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(56).append((String)action).append(" TABLE table_name USING ").append(this.v2Format()).append(" as select array(interval 1 day)").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 346)))));
            String $org_scalatest_assert_macro_left2 = e2.getMessage();
            String $org_scalatest_assert_macro_right2 = "Cannot use interval type in the table schema.";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 348));
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 341));
        this.test("CreateTableAsSelect: use v2 plan because catalog is set", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TableCatalog basicCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            TableCatalog atomicCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat_atomic")).asTableCatalog();
            String basicIdentifier = "testcat.table_name";
            String atomicIdentifier = "testcat_atomic.table_name";
            ((IterableLike)new .colon.colon((Object)new Tuple2((Object)basicCatalog, (Object)basicIdentifier), (List)new .colon.colon((Object)new Tuple2((Object)atomicCatalog, (Object)atomicIdentifier), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                DataSourceV2SQLSuite.$anonfun$new$47(this, x0$1);
                return BoxedUnit.UNIT;
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 352));
        this.test("CreateTableAsSelect: do not double execute on collect(), take() and other queries", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TableCatalog basicCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            TableCatalog atomicCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat_atomic")).asTableCatalog();
            String basicIdentifier = "testcat.table_name";
            String atomicIdentifier = "testcat_atomic.table_name";
            ((IterableLike)new .colon.colon((Object)new Tuple2((Object)basicCatalog, (Object)basicIdentifier), (List)new .colon.colon((Object)new Tuple2((Object)atomicCatalog, (Object)atomicIdentifier), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                DataSourceV2SQLSuite.$anonfun$new$50(this, x0$2);
                return BoxedUnit.UNIT;
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 376));
        this.test("ReplaceTableAsSelect: basic v2 implementation.", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TableCatalog basicCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            TableCatalog atomicCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat_atomic")).asTableCatalog();
            String basicIdentifier = "testcat.table_name";
            String atomicIdentifier = "testcat_atomic.table_name";
            ((IterableLike)new .colon.colon((Object)new Tuple2((Object)basicCatalog, (Object)basicIdentifier), (List)new .colon.colon((Object)new Tuple2((Object)atomicCatalog, (Object)atomicIdentifier), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                DataSourceV2SQLSuite.$anonfun$new$53(this, x0$3);
                return BoxedUnit.UNIT;
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 407));
        ((IterableLike)new .colon.colon((Object)"REPLACE", (List)new .colon.colon((Object)"CREATE OR REPLACE", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)cmd -> {
            this.test(new StringBuilder(57).append("ReplaceTableAsSelect: do not double execute ").append(cmd).append(" on collect()").toString(), (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                TableCatalog basicCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper($this.catalog("testcat")).asTableCatalog();
                TableCatalog atomicCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper($this.catalog("testcat_atomic")).asTableCatalog();
                String basicIdentifier = "testcat.table_name";
                String atomicIdentifier = "testcat_atomic.table_name";
                ((IterableLike)new .colon.colon((Object)new Tuple2((Object)basicCatalog, (Object)basicIdentifier), (List)new .colon.colon((Object)new Tuple2((Object)atomicCatalog, (Object)atomicIdentifier), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
                    DataSourceV2SQLSuite.$anonfun$new$57($this, cmd, x0$4);
                    return BoxedUnit.UNIT;
                });
            }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 435));
            return BoxedUnit.UNIT;
        });
        this.test("ReplaceTableAsSelect: Non-atomic catalog drops the table if the write fails.", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            this.spark().sql("CREATE TABLE testcat.table_name USING foo AS SELECT id, data FROM source");
            TableCatalog testCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            Table table = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            Seq $org_scalatest_assert_macro_left = ((InMemoryTable)table).rows();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 475));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> this.spark().sql(new StringBuilder(91).append("REPLACE TABLE testcat.table_name").append(" USING foo TBLPROPERTIES (`").append(InMemoryTable$.MODULE$.SIMULATE_FAILED_WRITE_OPTION()).append("`=true)").append(" AS SELECT id FROM source").toString()), ClassTag$.MODULE$.apply(Exception.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 477));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(testCatalog.tableExists(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name")), "testCatalog.tableExists(org.apache.spark.sql.connector.catalog.Identifier.of(scala.Array.apply[String]()((ClassTag.apply[String](classOf[java.lang.String]): scala.reflect.ClassTag[String])), \"table_name\"))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Table should have been dropped as a result of the replace.", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 483));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 471));
        this.test("ReplaceTableAsSelect: Non-atomic catalog drops the table permanently if the subsequent table creation fails.", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            this.spark().sql("CREATE TABLE testcat.table_name USING foo AS SELECT id, data FROM source");
            TableCatalog testCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            Table table = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            Seq $org_scalatest_assert_macro_left = ((InMemoryTable)table).rows();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 492));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> this.spark().sql(new StringBuilder(91).append("REPLACE TABLE testcat.table_name").append(" USING foo").append(" TBLPROPERTIES (`").append(InMemoryTableCatalog$.MODULE$.SIMULATE_FAILED_CREATE_PROPERTY()).append("`=true)").append(" AS SELECT id FROM source").toString()), ClassTag$.MODULE$.apply(Exception.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 494));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(testCatalog.tableExists(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name")), "testCatalog.tableExists(org.apache.spark.sql.connector.catalog.Identifier.of(scala.Array.apply[String]()((ClassTag.apply[String](classOf[java.lang.String]): scala.reflect.ClassTag[String])), \"table_name\"))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Table should have been dropped and failed to be created.", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 501));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 488));
        this.test("ReplaceTableAsSelect: Atomic catalog does not drop the table when replace fails.", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            this.spark().sql("CREATE TABLE testcat_atomic.table_name USING foo AS SELECT id, data FROM source");
            TableCatalog testCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat_atomic")).asTableCatalog();
            Table table = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> this.spark().sql(new StringBuilder(97).append("REPLACE TABLE testcat_atomic.table_name").append(" USING foo TBLPROPERTIES (`").append(InMemoryTable$.MODULE$.SIMULATE_FAILED_WRITE_OPTION()).append("=true)").append(" AS SELECT id FROM source").toString()), ClassTag$.MODULE$.apply(Exception.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 510));
            Table maybeReplacedTable = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(maybeReplacedTable);
            Table $org_scalatest_assert_macro_right = table;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Table should not have changed.", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 517));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> this.spark().sql(new StringBuilder(98).append("REPLACE TABLE testcat_atomic.table_name").append(" USING foo").append(" TBLPROPERTIES (`").append(InMemoryTableCatalog$.MODULE$.SIMULATE_FAILED_CREATE_PROPERTY()).append("`=true)").append(" AS SELECT id FROM source").toString()), ClassTag$.MODULE$.apply(Exception.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 519));
            maybeReplacedTable = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(maybeReplacedTable);
            Table $org_scalatest_assert_macro_right2 = table;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Table should not have changed.", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 527));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 505));
        this.test("ReplaceTable: Erases the table contents and changes the metadata.", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringBuilder(69).append("CREATE TABLE testcat.table_name USING ").append(this.v2Source()).append(" AS SELECT id, data FROM source").toString());
            TableCatalog testCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            Table table = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            Seq $org_scalatest_assert_macro_left = ((InMemoryTable)table).rows();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 535));
            this.spark().sql("REPLACE TABLE testcat.table_name (id bigint NOT NULL) USING foo");
            Table replaced = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            Seq $org_scalatest_assert_macro_left2 = ((InMemoryTable)replaced).rows();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Replaced table should have no rows after committing.", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 540));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)replaced.schema().fields().length));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"Replaced table should have new schema.", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 542));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(replaced.schema().fields()[0]);
            StructField $org_scalatest_assert_macro_right2 = new StructField("id", (DataType)LongType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"Replaced table should have new schema.", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 544));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 530));
        this.test("ReplaceTableAsSelect: CREATE OR REPLACE new table has same behavior as CTAS.", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"testcat", (List)new .colon.colon((Object)"testcat_atomic", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)catalogName -> {
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(94).append("\n           |CREATE TABLE ").append((String)catalogName).append(".created USING ").append(this.v2Source()).append("\n           |AS SELECT id, data FROM source\n         ").toString())).stripMargin());
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(106).append("\n           |CREATE OR REPLACE TABLE ").append((String)catalogName).append(".replaced USING ").append(this.v2Source()).append("\n           |AS SELECT id, data FROM source\n         ").toString())).stripMargin());
            TableCatalog testCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog((String)catalogName)).asTableCatalog();
            Table createdTable = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"created"));
            Table replacedTable = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"replaced"));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(((InMemoryTable)createdTable).rows());
            Seq $org_scalatest_assert_macro_right = ((InMemoryTable)replacedTable).rows();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 565));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(createdTable.schema());
            StructType $org_scalatest_assert_macro_right2 = replacedTable.schema();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 567));
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 548));
        this.test("ReplaceTableAsSelect: REPLACE TABLE throws exception if table does not exist.", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"testcat", (List)new .colon.colon((Object)"testcat_atomic", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)catalog -> {
            this.spark().sql(new StringBuilder(59).append("CREATE TABLE ").append((String)catalog).append(".created USING ").append(this.v2Source()).append(" AS SELECT id, data FROM source").toString());
            return (CannotReplaceMissingTableException)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.spark().sql(new StringBuilder(61).append("REPLACE TABLE ").append((String)catalog).append(".replaced USING ").append(this.v2Source()).append(" AS SELECT id, data FROM source").toString()), ClassTag$.MODULE$.apply(CannotReplaceMissingTableException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 574));
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 571));
        this.test("ReplaceTableAsSelect: REPLACE TABLE throws exception if table is dropped before commit.", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringBuilder(73).append("CREATE TABLE testcat_atomic.created USING ").append(this.v2Source()).append(" AS SELECT id, data FROM source").toString());
            return (CannotReplaceMissingTableException)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.spark().sql(new StringBuilder(99).append("REPLACE TABLE testcat_atomic.replaced").append(" USING ").append(this.v2Source()).append(" TBLPROPERTIES (`").append(InMemoryTableCatalog$.MODULE$.SIMULATE_DROP_BEFORE_REPLACE_PROPERTY()).append("`=true)").append(" AS SELECT id, data FROM source").toString()), ClassTag$.MODULE$.apply(CannotReplaceMissingTableException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 583));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 580));
        this.test("CreateTableAsSelect: use v2 plan and session catalog when provider is v2", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringBuilder(61).append("CREATE TABLE table_name USING ").append(this.v2Source()).append(" AS SELECT id, data FROM source").toString());
            TableCatalog testCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog(CatalogManager$.MODULE$.SESSION_CATALOG_NAME())).asTableCatalog();
            Table table = testCatalog.loadTable(Identifier.of((String[])((String[])((Object[])new String[]{"default"})), (String)"table_name"));
            String $org_scalatest_assert_macro_left = table.name();
            String $org_scalatest_assert_macro_right = "default.table_name";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 597));
            Object[] $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])table.partitioning());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left2), "isEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left2).isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 598));
            java.util.Map $org_scalatest_assert_macro_left3 = table.properties();
            java.util.Map $org_scalatest_assert_macro_right2 = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)this.v2Source())})))).asJava();
            java.util.Map map = $org_scalatest_assert_macro_left3;
            java.util.Map map2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(map != null ? !((Object)map).equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 599));
            StructType $org_scalatest_assert_macro_left4 = table.schema();
            StructType $org_scalatest_assert_macro_right3 = new StructType().add("id", (DataType)LongType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
            StructType structType = $org_scalatest_assert_macro_left4;
            StructType structType2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 600));
            SparkContext qual$19 = this.spark().sparkContext();
            Seq x$46 = ((InMemoryTable)table).rows();
            int x$47 = qual$19.parallelize$default$2();
            RDD rdd = qual$19.parallelize(x$46, x$47, ClassTag$.MODULE$.apply(InternalRow.class));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> {
                SparkSession qual$20 = this.spark();
                RDD x$48 = rdd;
                StructType x$49 = table.schema();
                boolean x$50 = qual$20.internalCreateDataFrame$default$3();
                return qual$20.internalCreateDataFrame(x$48, x$49, x$50);
            }, (Dataset<Row>)this.spark().table("source"));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 591));
        this.test("CreateTableAsSelect: fail if table exists", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql("CREATE TABLE testcat.table_name USING foo AS SELECT id, data FROM source");
            TableCatalog testCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            Table table = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            String $org_scalatest_assert_macro_left = table.name();
            String $org_scalatest_assert_macro_right = "testcat.table_name";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 614));
            Object[] $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])table.partitioning());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left2), "isEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left2).isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 615));
            java.util.Map $org_scalatest_assert_macro_left3 = table.properties();
            java.util.Map $org_scalatest_assert_macro_right2 = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)"foo")})))).asJava();
            java.util.Map map = $org_scalatest_assert_macro_left3;
            java.util.Map map2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(map != null ? !((Object)map).equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 616));
            StructType $org_scalatest_assert_macro_left4 = table.schema();
            StructType $org_scalatest_assert_macro_right3 = new StructType().add("id", (DataType)LongType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
            StructType structType = $org_scalatest_assert_macro_left4;
            StructType structType2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 617));
            SparkContext qual$21 = this.spark().sparkContext();
            Seq x$51 = ((InMemoryTable)table).rows();
            int x$52 = qual$21.parallelize$default$2();
            RDD rdd = qual$21.parallelize(x$51, x$52, ClassTag$.MODULE$.apply(InternalRow.class));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> {
                SparkSession qual$22 = this.spark();
                RDD x$53 = rdd;
                StructType x$54 = table.schema();
                boolean x$55 = qual$22.internalCreateDataFrame$default$3();
                return qual$22.internalCreateDataFrame(x$53, x$54, x$55);
            }, (Dataset<Row>)this.spark().table("source"));
            TableAlreadyExistsException exc = (TableAlreadyExistsException)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.spark().sql("CREATE TABLE testcat.table_name USING bar AS SELECT id, data, id as id2 FROM source2"), ClassTag$.MODULE$.apply(TableAlreadyExistsException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 625));
            String $org_scalatest_assert_macro_left5 = exc.getMessage();
            String $org_scalatest_assert_macro_right4 = "table_name";
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left5.contains($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 630));
            Table table2 = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            String $org_scalatest_assert_macro_left6 = table2.name();
            String $org_scalatest_assert_macro_right5 = "testcat.table_name";
            String string3 = $org_scalatest_assert_macro_left6;
            String string4 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right5, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 634));
            Object[] $org_scalatest_assert_macro_left7 = Predef$.MODULE$.refArrayOps((Object[])table2.partitioning());
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left7), "isEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left7).isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 635));
            java.util.Map $org_scalatest_assert_macro_left8 = table2.properties();
            java.util.Map $org_scalatest_assert_macro_right6 = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)"foo")})))).asJava();
            java.util.Map map3 = $org_scalatest_assert_macro_left8;
            java.util.Map map4 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right6, !(map3 != null ? !((Object)map3).equals(map4) : map4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 636));
            StructType $org_scalatest_assert_macro_left9 = table2.schema();
            StructType $org_scalatest_assert_macro_right7 = new StructType().add("id", (DataType)LongType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
            StructType structType3 = $org_scalatest_assert_macro_left9;
            StructType structType4 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right7, !(structType3 != null ? !structType3.equals(structType4) : structType4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 637));
            SparkContext qual$23 = this.spark().sparkContext();
            Seq x$56 = ((InMemoryTable)table).rows();
            int x$57 = qual$23.parallelize$default$2();
            RDD rdd2 = qual$23.parallelize(x$56, x$57, ClassTag$.MODULE$.apply(InternalRow.class));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> {
                SparkSession qual$24 = this.spark();
                RDD x$58 = rdd2;
                StructType x$59 = table.schema();
                boolean x$60 = qual$24.internalCreateDataFrame$default$3();
                return qual$24.internalCreateDataFrame(x$58, x$59, x$60);
            }, (Dataset<Row>)this.spark().table("source"));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 608));
        this.test("CreateTableAsSelect: if not exists", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql("CREATE TABLE IF NOT EXISTS testcat.table_name USING foo AS SELECT id, data FROM source");
            TableCatalog testCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            Table table = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            String $org_scalatest_assert_macro_left = table.name();
            String $org_scalatest_assert_macro_right = "testcat.table_name";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 652));
            Object[] $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])table.partitioning());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left2), "isEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left2).isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 653));
            java.util.Map $org_scalatest_assert_macro_left3 = table.properties();
            java.util.Map $org_scalatest_assert_macro_right2 = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)"foo")})))).asJava();
            java.util.Map map = $org_scalatest_assert_macro_left3;
            java.util.Map map2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(map != null ? !((Object)map).equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 654));
            StructType $org_scalatest_assert_macro_left4 = table.schema();
            StructType $org_scalatest_assert_macro_right3 = new StructType().add("id", (DataType)LongType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
            StructType structType = $org_scalatest_assert_macro_left4;
            StructType structType2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 655));
            SparkContext qual$25 = this.spark().sparkContext();
            Seq x$61 = ((InMemoryTable)table).rows();
            int x$62 = qual$25.parallelize$default$2();
            RDD rdd = qual$25.parallelize(x$61, x$62, ClassTag$.MODULE$.apply(InternalRow.class));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> {
                SparkSession qual$26 = this.spark();
                RDD x$63 = rdd;
                StructType x$64 = table.schema();
                boolean x$65 = qual$26.internalCreateDataFrame$default$3();
                return qual$26.internalCreateDataFrame(x$63, x$64, x$65);
            }, (Dataset<Row>)this.spark().table("source"));
            this.spark().sql("CREATE TABLE IF NOT EXISTS testcat.table_name USING foo AS SELECT id, data FROM source2");
            SparkContext qual$27 = this.spark().sparkContext();
            Seq x$66 = ((InMemoryTable)table).rows();
            int x$67 = qual$27.parallelize$default$2();
            RDD rdd2 = qual$27.parallelize(x$66, x$67, ClassTag$.MODULE$.apply(InternalRow.class));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> {
                SparkSession qual$28 = this.spark();
                RDD x$68 = rdd2;
                StructType x$69 = table.schema();
                boolean x$70 = qual$28.internalCreateDataFrame$default$3();
                return qual$28.internalCreateDataFrame(x$68, x$69, x$70);
            }, (Dataset<Row>)this.spark().table("source"));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 645));
        this.test("CreateTableAsSelect: use default catalog for v2 sources when default catalog is set", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().conf().set(SQLConf$.MODULE$.DEFAULT_CATALOG().key(), "testcat");
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuite$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_connector_DataSourceV2SQLSuite$$typecreator1$1(DataSourceV2SQLSuite $outer) {
                }
            }
            Dataset df = this.spark().createDataFrame((Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)1L), (Object)"a"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)2L), (Object)"b"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)3L), (Object)"c"), (List)Nil$.MODULE$))), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuite$$typecreator1$1(null))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data"}));
            df.createOrReplaceTempView("source");
            this.spark().sql("CREATE TABLE table_name USING foo AS SELECT id, data FROM source");
            TableCatalog testCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            Table table = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"));
            String $org_scalatest_assert_macro_left = table.name();
            String $org_scalatest_assert_macro_right = "testcat.table_name";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 683));
            Object[] $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])table.partitioning());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left2), "isEmpty", new ArrayOps.ofRef($org_scalatest_assert_macro_left2).isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 684));
            java.util.Map $org_scalatest_assert_macro_left3 = table.properties();
            java.util.Map $org_scalatest_assert_macro_right2 = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)CatalogV2Util$.MODULE$.withDefaultOwnership((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)"foo")})))).asJava();
            java.util.Map map = $org_scalatest_assert_macro_left3;
            java.util.Map map2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(map != null ? !((Object)map).equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 685));
            StructType $org_scalatest_assert_macro_left4 = table.schema();
            StructType $org_scalatest_assert_macro_right3 = new StructType().add("id", (DataType)LongType$.MODULE$).add("data", (DataType)StringType$.MODULE$);
            StructType structType = $org_scalatest_assert_macro_left4;
            StructType structType2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 686));
            SparkContext qual$29 = this.sparkContext();
            Seq x$71 = ((InMemoryTable)table).rows();
            int x$72 = qual$29.parallelize$default$2();
            RDD rdd = qual$29.parallelize(x$71, x$72, ClassTag$.MODULE$.apply(InternalRow.class));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> {
                SparkSession qual$30 = this.spark();
                RDD x$73 = rdd;
                StructType x$74 = table.schema();
                boolean x$75 = qual$30.internalCreateDataFrame$default$3();
                return qual$30.internalCreateDataFrame(x$73, x$74, x$75);
            }, (Dataset<Row>)this.spark().table("source"));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 670));
        this.test("CreateTableAsSelect: v2 session catalog can load v1 source table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Table t;
            this.spark().conf().unset(SQLConf$.MODULE$.V2_SESSION_CATALOG_IMPLEMENTATION().key());
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuite$$typecreator2$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_connector_DataSourceV2SQLSuite$$typecreator2$1(DataSourceV2SQLSuite $outer) {
                }
            }
            Dataset df = this.spark().createDataFrame((Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)1L), (Object)"a"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)2L), (Object)"b"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)3L), (Object)"c"), (List)Nil$.MODULE$))), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuite$$typecreator2$1(null))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data"}));
            df.createOrReplaceTempView("source");
            this.sql().apply((Object)"CREATE TABLE table_name USING parquet AS SELECT id, data FROM source");
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"TABLE default.table_name"), (Dataset<Row>)this.spark().table("source"));
            Table $org_scalatest_assert_macro_left = t = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog(CatalogManager$.MODULE$.SESSION_CATALOG_NAME())).asTableCatalog().loadTable(Identifier.of((String[])((String[])((Object[])new String[]{"default"})), (String)"table_name"));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "org.apache.spark.sql.connector.catalog.V1Table", $org_scalatest_assert_macro_left instanceof V1Table, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"V1 table wasn't returned as an unresolved table", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 708));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 694));
        this.test("CreateTableAsSelect: nullable schema", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TableCatalog basicCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            TableCatalog atomicCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat_atomic")).asTableCatalog();
            String basicIdentifier = "testcat.table_name";
            String atomicIdentifier = "testcat_atomic.table_name";
            ((IterableLike)new .colon.colon((Object)new Tuple2((Object)basicCatalog, (Object)basicIdentifier), (List)new .colon.colon((Object)new Tuple2((Object)atomicCatalog, (Object)atomicIdentifier), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)x0$5 -> {
                DataSourceV2SQLSuite.$anonfun$new$88(this, x0$5);
                return BoxedUnit.UNIT;
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 711));
        this.ignore("CreateTableAsSelect: without USING clause", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.spark().conf().unset(SQLConf$.MODULE$.V2_SESSION_CATALOG_IMPLEMENTATION().key());
            TableCatalog testCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            this.sql().apply((Object)"CREATE TABLE testcat.t1 AS SELECT 1 i");
            Table t1 = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"t1"));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(t1.properties().containsKey("provider"), "t1.properties().containsKey(\"provider\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 746));
            this.sql().apply((Object)"CREATE TABLE t2 AS SELECT 1 i");
            V1Table t2 = (V1Table)CatalogV2Implicits$.MODULE$.CatalogHelper(this.spark().sessionState().catalogManager().v2SessionCatalog()).asTableCatalog().loadTable(Identifier.of((String[])((String[])((Object[])new String[]{"default"})), (String)"t2"));
            Option $org_scalatest_assert_macro_left = t2.v1Table().provider();
            Some $org_scalatest_assert_macro_right = new Some((Object)this.conf().defaultDataSourceName());
            Option option = $org_scalatest_assert_macro_left;
            Some some = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 752));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 738));
        this.test("SPARK-34039: ReplaceTable (atomic or non-atomic) should invalidate cache", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"testcat.ns.t", (List)new .colon.colon((Object)"testcat_atomic.ns.t", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)t -> {
            DataSourceV2SQLSuite.$anonfun$new$93(this, t);
            return BoxedUnit.UNIT;
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 755));
        this.test("SPARK-33492: ReplaceTableAsSelect (atomic or non-atomic) should invalidate cache", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"testcat.ns.t", (List)new .colon.colon((Object)"testcat_atomic.ns.t", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)t -> {
            DataSourceV2SQLSuite.$anonfun$new$99(this, t);
            return BoxedUnit.UNIT;
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 773));
        this.test("SPARK-33492: AppendData should refresh cache", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "testcat.ns.t";
            String view = "view";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{view}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuite.class.getClassLoader());
                public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuite$$typecreator8$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_sql_connector_DataSourceV2SQLSuite$$typecreator8$1(DataSourceV2SQLSuite $outer) {
                    }
                }
                this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a"), (List)Nil$.MODULE$), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuite$$typecreator8$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"i", "j"})).write().saveAsTable(t);
                this.sql().apply((Object)new StringBuilder(30).append("CACHE TABLE ").append(view).append(" AS SELECT i FROM ").append(t).toString());
                Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a"}));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(t).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row));
                Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(view).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row2));
                JavaUniverse $u2 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuite.class.getClassLoader());
                public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuite$$typecreator18$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_sql_connector_DataSourceV2SQLSuite$$typecreator18$1(DataSourceV2SQLSuite $outer) {
                    }
                }
                this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)2), (Object)"b"), (List)Nil$.MODULE$), this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuite$$typecreator18$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"i", "j"})).write().mode(SaveMode.Append).saveAsTable(t);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.spark().sharedState().cacheManager().lookupCachedData(this.spark().table(view)).isDefined(), "DataSourceV2SQLSuite.this.spark.sharedState.cacheManager.lookupCachedData(DataSourceV2SQLSuite.this.spark.table(view)).isDefined", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 804));
                Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a"}));
                Row row4 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "b"}));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(t).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row4).$colon$colon((Object)row3));
                Row row5 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}));
                Row row6 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)}));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(view).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row6).$colon$colon((Object)row5));
            }));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 790));
        this.test("SPARK-33492: OverwriteByExpression should refresh cache", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "testcat.ns.t";
            String view = "view";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{view}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(54).append("CREATE TABLE ").append(t).append(" USING foo AS SELECT id, data FROM source").toString());
                this.sql().apply((Object)new StringBuilder(31).append("CACHE TABLE ").append(view).append(" AS SELECT id FROM ").append(t).toString());
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(t).toString()), (Dataset<Row>)this.spark().table("source"));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(view).toString()), (Dataset<Row>)this.spark().table("source").select("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])));
                this.sql().apply((Object)new StringBuilder(39).append("INSERT OVERWRITE TABLE ").append(t).append(" VALUES (1, 'a')").toString());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.spark().sharedState().cacheManager().lookupCachedData(this.spark().table(view)).isDefined(), "DataSourceV2SQLSuite.this.spark.sharedState.cacheManager.lookupCachedData(DataSourceV2SQLSuite.this.spark.table(view)).isDefined", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 823));
                Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a"}));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(t).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row));
                Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(view).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row2));
            }));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 811));
        this.test("SPARK-33492: OverwritePartitionsDynamic should refresh cache", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "testcat.ns.t";
            String view = "view";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{view}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuite.class.getClassLoader());
                public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuite$$typecreator28$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                    }

                    public Org_apache_spark_sql_connector_DataSourceV2SQLSuite$$typecreator28$1(DataSourceV2SQLSuite $outer) {
                    }
                }
                this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)"a", (Object)BoxesRunTime.boxToInteger((int)1)), (List)Nil$.MODULE$), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuite$$typecreator28$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"i", "j", "k"})).write().partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k"})).saveAsTable(t);
                this.sql().apply((Object)new StringBuilder(30).append("CACHE TABLE ").append(view).append(" AS SELECT i FROM ").append(t).toString());
                Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a", BoxesRunTime.boxToInteger((int)1)}));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(t).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row));
                Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(view).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row2));
                JavaUniverse $u2 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuite.class.getClassLoader());
                public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuite$$typecreator38$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                    }

                    public Org_apache_spark_sql_connector_DataSourceV2SQLSuite$$typecreator38$1(DataSourceV2SQLSuite $outer) {
                    }
                }
                this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)"b", (Object)BoxesRunTime.boxToInteger((int)1)), (List)Nil$.MODULE$), this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuite$$typecreator38$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"i", "j", "k"})).writeTo(t).overwritePartitions();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.spark().sharedState().cacheManager().lookupCachedData(this.spark().table(view)).isDefined(), "DataSourceV2SQLSuite.this.spark.sharedState.cacheManager.lookupCachedData(DataSourceV2SQLSuite.this.spark.table(view)).isDefined", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 844));
                Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "b", BoxesRunTime.boxToInteger((int)1)}));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(t).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row3));
                Row row4 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)}));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(view).toString()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row4));
            }));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 830));
        this.test("SPARK-34947: micro batch streaming write should invalidate cache", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "testcat.ns.t";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)checkpointDir -> {
                DataSourceV2SQLSuite.$anonfun$new$127(this, t, checkpointDir);
                return BoxedUnit.UNIT;
            }));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 851));
        this.test("Relation: basic", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t1 = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t1}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(54).append("CREATE TABLE ").append(t1).append(" USING foo AS SELECT id, data FROM source").toString());
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(6).append("TABLE ").append(t1).toString()), (Dataset<Row>)this.spark().table("source"));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("SELECT * FROM ").append(t1).toString()), (Dataset<Row>)this.spark().table("source"));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 879));
        this.test("Relation: SparkSession.table()", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t1 = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t1}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(54).append("CREATE TABLE ").append(t1).append(" USING foo AS SELECT id, data FROM source").toString());
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> this.spark().table(String.valueOf(t1)), (Dataset<Row>)this.spark().table("source"));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 888));
        this.test("Relation: CTE", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t1 = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t1}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(54).append("CREATE TABLE ").append(t1).append(" USING foo AS SELECT id, data FROM source").toString());
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(78).append("\n          |WITH cte AS (SELECT * FROM ").append(t1).append(")\n          |SELECT * FROM cte\n        ").toString())).stripMargin()), (Dataset<Row>)this.spark().table("source"));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 896));
        this.test("Relation: view text", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t1 = "testcat.ns1.ns2.tbl";
            String v1 = "view1";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t1}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{v1}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(54).append("CREATE TABLE ").append(t1).append(" USING foo AS SELECT id, data FROM source").toString());
                this.sql().apply((Object)new StringBuilder(30).append("CREATE VIEW ").append(v1).append(" AS SELECT * from ").append(t1).toString());
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(6).append("TABLE ").append(v1).toString()), (Dataset<Row>)this.spark().table("source"));
            }));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 909));
        this.test("Relation: join tables in 2 catalogs", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t1 = "testcat.ns1.ns2.tbl";
            String t2 = "testcat2.v2tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t1, t2}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(54).append("CREATE TABLE ").append(t1).append(" USING foo AS SELECT id, data FROM source").toString());
                this.sql().apply((Object)new StringBuilder(55).append("CREATE TABLE ").append(t2).append(" USING foo AS SELECT id, data FROM source2").toString());
                Dataset df1 = this.spark().table("source");
                Dataset df2 = this.spark().table("source2");
                Dataset df_joined = df1.join(df2).where(df1.apply("id").$plus((Object)BoxesRunTime.boxToInteger((int)1)).$eq$eq$eq((Object)df2.apply("id")));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(89).append("\n          |SELECT *\n          |FROM ").append(t1).append(" t1, ").append(t2).append(" t2\n          |WHERE t1.id + 1 = t2.id\n        ").toString())).stripMargin()), (Dataset<Row>)df_joined);
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 921));
        this.test("qualified column names for v2 tables", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(71).append("CREATE TABLE ").append(t).append(" (id bigint, point struct<x: bigint, y: bigint>) USING foo").toString());
                this.sql().apply((Object)new StringBuilder(33).append("INSERT INTO ").append(t).append(" VALUES (1, (10, 20))").toString());
                this.check$1(t);
                this.sql().apply((Object)"USE testcat.ns1.ns2");
                this.check$1("tbl");
                AnalysisException ex = (AnalysisException)((Object)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(31).append("SELECT ns1.ns2.ns3.tbl.id from ").append(t).toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 962)))));
                String $org_scalatest_assert_macro_left = ex.getMessage();
                String $org_scalatest_assert_macro_right = "cannot resolve 'ns1.ns2.ns3.tbl.id";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 965));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 940));
        this.test("qualified column names for v1 tables", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)useV1Table -> {
            DataSourceV2SQLSuite.$anonfun$new$154(this, BoxesRunTime.unboxToBoolean((Object)useV1Table));
            return BoxedUnit.UNIT;
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 969));
        this.test("InsertInto: append - across catalog", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t1 = "testcat.ns1.ns2.tbl";
            String t2 = "testcat2.db.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t1, t2}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(47).append("CREATE TABLE ").append(t1).append(" USING foo AS SELECT * FROM source").toString());
                this.sql().apply((Object)new StringBuilder(48).append("CREATE TABLE ").append(t2).append(" (id bigint, data string) USING foo").toString());
                this.sql().apply((Object)new StringBuilder(27).append("INSERT INTO ").append(t2).append(" SELECT * FROM ").append(t1).toString());
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> this.spark().table(t2), (Dataset<Row>)this.spark().table("source"));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 993));
        this.test("ShowViews: using v1 catalog, db name with multipartIdentifier ('a.b') is not allowed.", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            AnalysisException exception = (AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SHOW VIEWS FROM a.b"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1005))));
            String $org_scalatest_assert_macro_left = exception.getMessage();
            String $org_scalatest_assert_macro_right = "Nested databases are not supported by v1 session catalog: a.b";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1009));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1004));
        this.test("ShowViews: using v2 catalog, command not supported.", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            AnalysisException exception = (AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SHOW VIEWS FROM testcat"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1014))));
            String $org_scalatest_assert_macro_left = exception.getMessage();
            String $org_scalatest_assert_macro_right = "Catalog testcat doesn't support SHOW VIEWS, only SessionCatalog supports this command.";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1018));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1013));
        this.test("CreateNameSpace: basic tests", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.withNamespace((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ns"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)"CREATE NAMESPACE ns");
                this.testShowNamespaces("SHOW NAMESPACES", (Seq<String>)((Seq)new .colon.colon((Object)"default", (List)new .colon.colon((Object)"ns", (List)Nil$.MODULE$))));
            });
            this.withNamespace((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"testcat.ns1.ns2"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)"CREATE NAMESPACE testcat.ns1.ns2");
                this.testShowNamespaces("SHOW NAMESPACES IN testcat", (Seq<String>)((Seq)new .colon.colon((Object)"ns1", (List)Nil$.MODULE$)));
                this.testShowNamespaces("SHOW NAMESPACES IN testcat.ns1", (Seq<String>)((Seq)new .colon.colon((Object)"ns1.ns2", (List)Nil$.MODULE$)));
            });
            this.withNamespace((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"testcat.test"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmpDir -> {
                DataSourceV2SQLSuite.$anonfun$new$174(this, tmpDir);
                return BoxedUnit.UNIT;
            }));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1022));
        this.test("CreateNameSpace: test handling of 'IF NOT EXIST'", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withNamespace((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"testcat.ns1"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CREATE NAMESPACE IF NOT EXISTS testcat.ns1");
            NamespaceAlreadyExistsException exception = (NamespaceAlreadyExistsException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"CREATE NAMESPACE testcat.ns1"), ClassTag$.MODULE$.apply(NamespaceAlreadyExistsException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1053));
            String $org_scalatest_assert_macro_left = exception.getMessage();
            String $org_scalatest_assert_macro_right = "Namespace 'ns1' already exists";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1056));
            this.sql().apply((Object)"CREATE NAMESPACE IF NOT EXISTS testcat.ns1");
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1048));
        this.test("CreateNameSpace: reserved properties", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SQLConf$.MODULE$.LEGACY_PROPERTY_NON_RESERVED().key(), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)CatalogV2Util$.MODULE$.NAMESPACE_RESERVED_PROPERTIES().filterNot((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)DataSourceV2SQLSuite.$anonfun$new$180(x$18)))).foreach((Function1 & Serializable & scala.Serializable)key -> {
                ParseException exception = (ParseException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(70).append("CREATE NAMESPACE testcat.reservedTest WITH DBPROPERTIES('").append((String)key).append("'='dummyVal')").toString()), ClassTag$.MODULE$.apply(ParseException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1067));
                String $org_scalatest_assert_macro_left = exception.getMessage();
                String $org_scalatest_assert_macro_right = new StringBuilder(33).append((String)key).append(" is a reserved namespace property").toString();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1070));
            }));
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SQLConf$.MODULE$.LEGACY_PROPERTY_NON_RESERVED().key(), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)CatalogV2Util$.MODULE$.NAMESPACE_RESERVED_PROPERTIES().filterNot((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)DataSourceV2SQLSuite.$anonfun$new$184(x$19)))).foreach((Function1 & Serializable & scala.Serializable)key -> {
                this.withNamespace((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"testcat.reservedTest"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    Bool bool;
                    $this.sql().apply((Object)new StringBuilder(65).append("CREATE NAMESPACE testcat.reservedTest WITH DBPROPERTIES('").append(key).append("'='foo')").toString());
                    Dataset $org_scalatest_assert_macro_left = ((Dataset)$this.sql().apply((Object)"DESC NAMESPACE EXTENDED testcat.reservedTest")).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k", "v"})).where("k='Properties'");
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(45).append(key).append(" is a reserved namespace property and ignored").toString(), Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1077));
                    java.util.Map meta = CatalogV2Implicits$.MODULE$.CatalogHelper($this.catalog("testcat")).asNamespaceCatalog().loadNamespaceMetadata((String[])((Object[])new String[]{"reservedTest"}));
                    String $org_scalatest_assert_macro_left2 = (String)meta.get(key);
                    Object $org_scalatest_assert_macro_right = null;
                    String string = $org_scalatest_assert_macro_left2;
                    Object var9_7 = null;
                    Bool $org_scalatest_assert_macro_left3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", null, !(string != null ? !string.equals(var9_7) : var9_7 != null), Prettifier$.MODULE$.default());
                    if ($org_scalatest_assert_macro_left3.value()) {
                        bool = Bool$.MODULE$.simpleMacroBool(true, "", Prettifier$.MODULE$.default());
                    } else {
                        String $org_scalatest_assert_macro_left4 = (String)meta.get(key);
                        String $org_scalatest_assert_macro_right2 = "foo";
                        bool = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left4.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                    }
                    Bool $org_scalatest_assert_macro_right3 = bool;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "||", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$bar$bar((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"reserved properties should not have side effects", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1083));
                });
                return BoxedUnit.UNIT;
            }));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1063));
        this.test("create/replace/alter table - reserved properties", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SQLConf$.MODULE$.LEGACY_PROPERTY_NON_RESERVED().key(), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)CatalogV2Util$.MODULE$.TABLE_RESERVED_PROPERTIES().filterNot((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)DataSourceV2SQLSuite.$anonfun$new$190(x$20)))).foreach((Function1 & Serializable & scala.Serializable)key -> {
                ((IterableLike)new .colon.colon((Object)"OPTIONS", (List)new .colon.colon((Object)"TBLPROPERTIES", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)clause -> {
                    DataSourceV2SQLSuite.$anonfun$new$192(this, key, clause);
                    return BoxedUnit.UNIT;
                });
                ParseException e1 = (ParseException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(61).append("ALTER TABLE testcat.reservedTest SET TBLPROPERTIES ('").append((String)key).append("'='bar')").toString()), ClassTag$.MODULE$.apply(ParseException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1103));
                String $org_scalatest_assert_macro_left = e1.getMessage();
                String $org_scalatest_assert_macro_right = new StringBuilder(29).append((String)key).append(" is a reserved table property").toString();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1106));
                ParseException e2 = (ParseException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(57).append("ALTER TABLE testcat.reservedTest UNSET TBLPROPERTIES ('").append((String)key).append("')").toString()), ClassTag$.MODULE$.apply(ParseException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1108));
                String $org_scalatest_assert_macro_left2 = e2.getMessage();
                String $org_scalatest_assert_macro_right2 = new StringBuilder(29).append((String)key).append(" is a reserved table property").toString();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1111));
            }));
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SQLConf$.MODULE$.LEGACY_PROPERTY_NON_RESERVED().key(), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)CatalogV2Util$.MODULE$.TABLE_RESERVED_PROPERTIES().filterNot((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)DataSourceV2SQLSuite.$anonfun$new$198(x$21)))).foreach((Function1 & Serializable & scala.Serializable)key -> {
                DataSourceV2SQLSuite.$anonfun$new$199(this, key);
                return BoxedUnit.UNIT;
            }));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1090));
        this.test("create/replace - path property", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"true", (List)new .colon.colon((Object)"false", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)conf -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SQLConf$.MODULE$.LEGACY_PROPERTY_NON_RESERVED().key(), (Object)conf)}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"testcat.reservedTest"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"CREATE", (List)new .colon.colon((Object)"REPLACE", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)action -> {
                ParseException e1 = (ParseException)$this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(75).append((String)action).append(" TABLE testcat.reservedTest USING foo LOCATION 'foo' OPTIONS").append(" ('path'='bar')").toString()), ClassTag$.MODULE$.apply(ParseException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1142));
                String $org_scalatest_assert_macro_left = e1.getMessage();
                String $org_scalatest_assert_macro_right = "Duplicated table paths found: 'foo' and 'bar'";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1146));
                ParseException e2 = (ParseException)$this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(74).append((String)action).append(" TABLE testcat.reservedTest USING foo OPTIONS").append(" ('path'='foo', 'PaTh'='bar')").toString()), ClassTag$.MODULE$.apply(ParseException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1148));
                String $org_scalatest_assert_macro_left2 = e2.getMessage();
                String $org_scalatest_assert_macro_right2 = "Duplicated table paths found: 'foo' and 'bar'";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1152));
                $this.sql().apply((Object)new StringBuilder(96).append((String)action).append(" TABLE testcat.reservedTest USING foo LOCATION 'foo' TBLPROPERTIES").append(" ('path'='bar', 'Path'='noop')").toString());
                TableCatalog tableCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper($this.catalog("testcat")).asTableCatalog();
                Identifier identifier = Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"reservedTest");
                String $org_scalatest_assert_macro_left3 = (String)tableCatalog.loadTable(identifier).properties().get("location");
                String $org_scalatest_assert_macro_right3 = "foo";
                String string = $org_scalatest_assert_macro_left3;
                String string2 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"path as a table property should not have side effects", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1158));
                String $org_scalatest_assert_macro_left4 = (String)tableCatalog.loadTable(identifier).properties().get("path");
                String $org_scalatest_assert_macro_right4 = "bar";
                String string3 = $org_scalatest_assert_macro_left4;
                String string4 = $org_scalatest_assert_macro_right4;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"path as a table property should not have side effects", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1161));
                String $org_scalatest_assert_macro_left5 = (String)tableCatalog.loadTable(identifier).properties().get("Path");
                String $org_scalatest_assert_macro_right5 = "noop";
                String string5 = $org_scalatest_assert_macro_left5;
                String string6 = $org_scalatest_assert_macro_right5;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"path as a table property should not have side effects", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1163));
            })));
            return BoxedUnit.UNIT;
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1137));
        this.test("DropNamespace: basic tests", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CREATE NAMESPACE ns");
            this.testShowNamespaces("SHOW NAMESPACES", (Seq<String>)((Seq)new .colon.colon((Object)"default", (List)new .colon.colon((Object)"ns", (List)Nil$.MODULE$))));
            this.sql().apply((Object)"DROP NAMESPACE ns");
            this.testShowNamespaces("SHOW NAMESPACES", (Seq<String>)((Seq)new .colon.colon((Object)"default", (List)Nil$.MODULE$)));
            this.sql().apply((Object)"CREATE NAMESPACE testcat.ns1");
            this.testShowNamespaces("SHOW NAMESPACES IN testcat", (Seq<String>)((Seq)new .colon.colon((Object)"ns1", (List)Nil$.MODULE$)));
            this.sql().apply((Object)"DROP NAMESPACE testcat.ns1");
            this.testShowNamespaces("SHOW NAMESPACES IN testcat", (Seq<String>)((Seq)Nil$.MODULE$));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1171));
        this.test("DropNamespace: drop non-empty namespace with a non-cascading mode", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE testcat.ns1.table (id bigint) USING foo");
            this.sql().apply((Object)"CREATE TABLE testcat.ns1.ns2.table (id bigint) USING foo");
            this.testShowNamespaces("SHOW NAMESPACES IN testcat", (Seq<String>)((Seq)new .colon.colon((Object)"ns1", (List)Nil$.MODULE$)));
            this.testShowNamespaces("SHOW NAMESPACES IN testcat.ns1", (Seq<String>)((Seq)new .colon.colon((Object)"ns1.ns2", (List)Nil$.MODULE$)));
            this.assertDropFails$1();
            this.sql().apply((Object)"DROP TABLE testcat.ns1.table");
            this.assertDropFails$1();
            this.sql().apply((Object)"DROP TABLE testcat.ns1.ns2.table");
            this.assertDropFails$1();
            this.sql().apply((Object)"DROP NAMESPACE testcat.ns1.ns2");
            this.sql().apply((Object)"DROP NAMESPACE testcat.ns1");
            this.testShowNamespaces("SHOW NAMESPACES IN testcat", (Seq<String>)((Seq)Nil$.MODULE$));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1185));
        this.test("DropNamespace: drop non-empty namespace with a cascade mode", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE testcat.ns1.table (id bigint) USING foo");
            this.sql().apply((Object)"CREATE TABLE testcat.ns1.ns2.table (id bigint) USING foo");
            this.testShowNamespaces("SHOW NAMESPACES IN testcat", (Seq<String>)((Seq)new .colon.colon((Object)"ns1", (List)Nil$.MODULE$)));
            this.testShowNamespaces("SHOW NAMESPACES IN testcat.ns1", (Seq<String>)((Seq)new .colon.colon((Object)"ns1.ns2", (List)Nil$.MODULE$)));
            this.sql().apply((Object)"DROP NAMESPACE testcat.ns1 CASCADE");
            this.testShowNamespaces("SHOW NAMESPACES IN testcat", (Seq<String>)((Seq)Nil$.MODULE$));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1215));
        this.test("DropNamespace: test handling of 'IF EXISTS'", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"DROP NAMESPACE IF EXISTS testcat.unknown");
            NoSuchNamespaceException exception = (NoSuchNamespaceException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"DROP NAMESPACE testcat.ns1"), ClassTag$.MODULE$.apply(NoSuchNamespaceException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1228));
            String $org_scalatest_assert_macro_left = exception.getMessage();
            String $org_scalatest_assert_macro_right = "Namespace 'ns1' not found";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1231));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1225));
        this.test("DescribeNamespace using v2 catalog", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withNamespace((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"testcat.ns1.ns2"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CREATE NAMESPACE IF NOT EXISTS testcat.ns1.ns2 COMMENT 'test namespace' LOCATION '/tmp/ns_test'");
            Dataset descriptionDf = (Dataset)this.sql().apply((Object)"DESCRIBE NAMESPACE testcat.ns1.ns2");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(descriptionDf.schema().map((Function1 & Serializable & scala.Serializable)field -> new Tuple2((Object)field.name(), (Object)field.dataType()), Seq$.MODULE$.canBuildFrom()));
            Seq $org_scalatest_assert_macro_right = (Seq)new .colon.colon((Object)new Tuple2((Object)"info_name", (Object)StringType$.MODULE$), (List)new .colon.colon((Object)new Tuple2((Object)"info_value", (Object)StringType$.MODULE$), (List)Nil$.MODULE$));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1239));
            Row[] description = (Row[])descriptionDf.collect();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(description);
            Seq $org_scalatest_assert_macro_right2 = (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Namespace Name", "ns2"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringOps(Predef$.MODULE$.augmentString("comment")).capitalize(), "test namespace"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringOps(Predef$.MODULE$.augmentString("location")).capitalize(), "/tmp/ns_test"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringOps(Predef$.MODULE$.augmentString("owner")).capitalize(), this.defaultUser()})), (List)Nil$.MODULE$))));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1245));
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1234));
        this.test("ALTER NAMESPACE .. SET PROPERTIES using v2 catalog", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withNamespace((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"testcat.ns1.ns2"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CREATE NAMESPACE IF NOT EXISTS testcat.ns1.ns2 COMMENT 'test namespace' LOCATION '/tmp/ns_test' WITH PROPERTIES ('a'='a','b'='b','c'='c')");
            this.sql().apply((Object)"ALTER NAMESPACE testcat.ns1.ns2 SET PROPERTIES ('a'='b','b'='a')");
            Dataset descriptionDf = (Dataset)this.sql().apply((Object)"DESCRIBE NAMESPACE EXTENDED testcat.ns1.ns2");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(descriptionDf.collect());
            Seq $org_scalatest_assert_macro_right = (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Namespace Name", "ns2"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringOps(Predef$.MODULE$.augmentString("comment")).capitalize(), "test namespace"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringOps(Predef$.MODULE$.augmentString("location")).capitalize(), "/tmp/ns_test"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringOps(Predef$.MODULE$.augmentString("owner")).capitalize(), this.defaultUser()})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Properties", "((a,b),(b,a),(c,c))"})), (List)Nil$.MODULE$)))));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1260));
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1254));
        this.test("ALTER NAMESPACE .. SET PROPERTIES reserved properties", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SQLConf$.MODULE$.LEGACY_PROPERTY_NON_RESERVED().key(), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)CatalogV2Util$.MODULE$.NAMESPACE_RESERVED_PROPERTIES().filterNot((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)DataSourceV2SQLSuite.$anonfun$new$223(x$22)))).foreach((Function1 & Serializable & scala.Serializable)key -> {
                this.withNamespace((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"testcat.reservedTest"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    $this.sql().apply((Object)"CREATE NAMESPACE testcat.reservedTest");
                    ParseException exception = (ParseException)$this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)new StringBuilder(67).append("ALTER NAMESPACE testcat.reservedTest SET PROPERTIES ('").append(key).append("'='dummyVal')").toString()), ClassTag$.MODULE$.apply(ParseException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1276));
                    String $org_scalatest_assert_macro_left = exception.getMessage();
                    String $org_scalatest_assert_macro_right = new StringBuilder(33).append(key).append(" is a reserved namespace property").toString();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1279));
                });
                return BoxedUnit.UNIT;
            }));
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SQLConf$.MODULE$.LEGACY_PROPERTY_NON_RESERVED().key(), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)CatalogV2Util$.MODULE$.NAMESPACE_RESERVED_PROPERTIES().filterNot((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)DataSourceV2SQLSuite.$anonfun$new$228(x$23)))).foreach((Function1 & Serializable & scala.Serializable)key -> {
                this.withNamespace((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"testcat.reservedTest"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    Bool bool;
                    $this.sql().apply((Object)"CREATE NAMESPACE testcat.reservedTest");
                    $this.sql().apply((Object)new StringBuilder(62).append("ALTER NAMESPACE testcat.reservedTest SET PROPERTIES ('").append(key).append("'='foo')").toString());
                    Dataset $org_scalatest_assert_macro_left = ((Dataset)$this.sql().apply((Object)"DESC NAMESPACE EXTENDED testcat.reservedTest")).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k", "v"})).where("k='Properties'");
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(45).append(key).append(" is a reserved namespace property and ignored").toString(), Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1288));
                    java.util.Map meta = CatalogV2Implicits$.MODULE$.CatalogHelper($this.catalog("testcat")).asNamespaceCatalog().loadNamespaceMetadata((String[])((Object[])new String[]{"reservedTest"}));
                    String $org_scalatest_assert_macro_left2 = (String)meta.get(key);
                    Object $org_scalatest_assert_macro_right = null;
                    String string = $org_scalatest_assert_macro_left2;
                    Object var9_7 = null;
                    Bool $org_scalatest_assert_macro_left3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", null, !(string != null ? !string.equals(var9_7) : var9_7 != null), Prettifier$.MODULE$.default());
                    if ($org_scalatest_assert_macro_left3.value()) {
                        bool = Bool$.MODULE$.simpleMacroBool(true, "", Prettifier$.MODULE$.default());
                    } else {
                        String $org_scalatest_assert_macro_left4 = (String)meta.get(key);
                        String $org_scalatest_assert_macro_right2 = "foo";
                        bool = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left4.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                    }
                    Bool $org_scalatest_assert_macro_right3 = bool;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "||", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$bar$bar((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"reserved properties should not have side effects", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1294));
                });
                return BoxedUnit.UNIT;
            }));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1270));
        this.test("ALTER NAMESPACE .. SET LOCATION using v2 catalog", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withNamespace((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"testcat.ns1.ns2"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CREATE NAMESPACE IF NOT EXISTS testcat.ns1.ns2 COMMENT 'test namespace' LOCATION '/tmp/ns_test_1'");
            this.sql().apply((Object)"ALTER NAMESPACE testcat.ns1.ns2 SET LOCATION '/tmp/ns_test_2'");
            Dataset descriptionDf = (Dataset)this.sql().apply((Object)"DESCRIBE NAMESPACE EXTENDED testcat.ns1.ns2");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(descriptionDf.collect());
            Seq $org_scalatest_assert_macro_right = (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Namespace Name", "ns2"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringOps(Predef$.MODULE$.augmentString("comment")).capitalize(), "test namespace"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringOps(Predef$.MODULE$.augmentString("location")).capitalize(), "/tmp/ns_test_2"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringOps(Predef$.MODULE$.augmentString("owner")).capitalize(), this.defaultUser()})), (List)Nil$.MODULE$))));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1307));
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1301));
        this.test("Use: basic tests with USE statements", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            CatalogManager catalogManager = this.spark().sessionState().catalogManager();
            String $org_scalatest_assert_macro_left = catalogManager.currentCatalog().name();
            String $org_scalatest_assert_macro_right = CatalogManager$.MODULE$.SESSION_CATALOG_NAME();
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1330));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(catalogManager.currentNamespace());
            String[] $org_scalatest_assert_macro_right2 = (String[])((Object[])new String[]{"default"});
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1331));
            this.sql().apply((Object)"CREATE TABLE testcat.ns1.ns1_1.table (id bigint) USING foo");
            this.sql().apply((Object)"CREATE TABLE testcat2.ns2.ns2_2.table (id bigint) USING foo");
            this.sql().apply((Object)"CREATE TABLE testcat2.ns3.ns3_3.table (id bigint) USING foo");
            this.sql().apply((Object)"CREATE TABLE testcat2.testcat.table (id bigint) USING foo");
            this.sql().apply((Object)"USE testcat.ns1.ns1_1");
            String $org_scalatest_assert_macro_left3 = catalogManager.currentCatalog().name();
            String $org_scalatest_assert_macro_right3 = "testcat";
            String string3 = $org_scalatest_assert_macro_left3;
            String string4 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1341));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(catalogManager.currentNamespace());
            String[] $org_scalatest_assert_macro_right4 = (String[])((Object[])new String[]{"ns1", "ns1_1"});
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1342));
            this.sql().apply((Object)"USE testcat2.ns2.ns2_2");
            String $org_scalatest_assert_macro_left5 = catalogManager.currentCatalog().name();
            String $org_scalatest_assert_macro_right5 = "testcat2";
            String string5 = $org_scalatest_assert_macro_left5;
            String string6 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1346));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(catalogManager.currentNamespace());
            String[] $org_scalatest_assert_macro_right6 = (String[])((Object[])new String[]{"ns2", "ns2_2"});
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1347));
            this.sql().apply((Object)"USE ns3.ns3_3");
            String $org_scalatest_assert_macro_left7 = catalogManager.currentCatalog().name();
            String $org_scalatest_assert_macro_right7 = "testcat2";
            String string7 = $org_scalatest_assert_macro_left7;
            String string8 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right7, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1351));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(catalogManager.currentNamespace());
            String[] $org_scalatest_assert_macro_right8 = (String[])((Object[])new String[]{"ns3", "ns3_3"});
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1352));
            this.sql().apply((Object)"USE NAMESPACE testcat");
            String $org_scalatest_assert_macro_left9 = catalogManager.currentCatalog().name();
            String $org_scalatest_assert_macro_right9 = "testcat2";
            String string9 = $org_scalatest_assert_macro_left9;
            String string10 = $org_scalatest_assert_macro_right9;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right9, !(string9 != null ? !string9.equals(string10) : string10 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1356));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(catalogManager.currentNamespace());
            String[] $org_scalatest_assert_macro_right10 = (String[])((Object[])new String[]{"testcat"});
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1357));
            this.sql().apply((Object)"USE testcat");
            String $org_scalatest_assert_macro_left11 = catalogManager.currentCatalog().name();
            String $org_scalatest_assert_macro_right11 = "testcat";
            String string11 = $org_scalatest_assert_macro_left11;
            String string12 = $org_scalatest_assert_macro_right11;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "==", (Object)$org_scalatest_assert_macro_right11, !(string11 != null ? !string11.equals(string12) : string12 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1361));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.convertToEqualizer(catalogManager.currentNamespace());
            Object[] $org_scalatest_assert_macro_right12 = (Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Nothing());
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)$org_scalatest_assert_macro_right12, $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)$org_scalatest_assert_macro_right12, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1362));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1326));
        this.test("Use: set v2 catalog as a current catalog", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            CatalogManager catalogManager = this.spark().sessionState().catalogManager();
            String $org_scalatest_assert_macro_left = catalogManager.currentCatalog().name();
            String $org_scalatest_assert_macro_right = CatalogManager$.MODULE$.SESSION_CATALOG_NAME();
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1367));
            this.sql().apply((Object)"USE testcat");
            String $org_scalatest_assert_macro_left2 = catalogManager.currentCatalog().name();
            String $org_scalatest_assert_macro_right2 = "testcat";
            String string3 = $org_scalatest_assert_macro_left2;
            String string4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1370));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1365));
        this.test("Use: v2 session catalog is used and namespace does not exist", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            NoSuchDatabaseException exception = (NoSuchDatabaseException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"USE ns1"), ClassTag$.MODULE$.apply(NoSuchDatabaseException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1374));
            String $org_scalatest_assert_macro_left = exception.getMessage();
            String $org_scalatest_assert_macro_right = "Database 'ns1' not found";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1377));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1373));
        this.test("SPARK-31100: Use: v2 catalog that implements SupportsNamespaces is used and namespace not exists", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            NoSuchNamespaceException exception = (NoSuchNamespaceException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"USE testcat.ns1.ns2"), ClassTag$.MODULE$.apply(NoSuchNamespaceException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1383));
            String $org_scalatest_assert_macro_left = exception.getMessage();
            String $org_scalatest_assert_macro_right = "Namespace 'ns1.ns2' not found";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1386));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1381));
        this.test("SPARK-31100: Use: v2 catalog that does not implement SupportsNameSpaces is used and namespace does not exist", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.sql.catalog.dummy"), (Object)BasicInMemoryTableCatalog.class.getName())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            CatalogManager catalogManager = this.spark().sessionState().catalogManager();
            this.sql().apply((Object)"USE dummy.ns1");
            String $org_scalatest_assert_macro_left = catalogManager.currentCatalog().name();
            String $org_scalatest_assert_macro_right = "dummy";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1397));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(catalogManager.currentNamespace());
            String[] $org_scalatest_assert_macro_right2 = (String[])((Object[])new String[]{"ns1"});
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1398));
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1390));
        this.test("ShowCurrentNamespace: basic tests", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.testShowCurrentNamespace$1("spark_catalog", "default");
            this.sql().apply((Object)"USE testcat");
            this.testShowCurrentNamespace$1("testcat", "");
            this.sql().apply((Object)"CREATE NAMESPACE testcat.ns1.ns2");
            this.sql().apply((Object)"USE testcat.ns1.ns2");
            this.testShowCurrentNamespace$1("testcat", "ns1.ns2");
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1402));
        this.test("tableCreation: partition column case insensitive resolution", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TableCatalog testCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            TableCatalog sessionCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog(CatalogManager$.MODULE$.SESSION_CATALOG_NAME())).asTableCatalog();
            this.sql().apply((Object)new StringBuilder(60).append("CREATE TABLE tbl (a int, b string) USING ").append(this.v2Source()).append(" PARTITIONED BY (A)").toString());
            this.checkPartitioning$1(sessionCatalog, "a");
            this.sql().apply((Object)new StringBuilder(68).append("CREATE TABLE testcat.tbl (a int, b string) USING ").append(this.v2Source()).append(" PARTITIONED BY (A)").toString());
            this.checkPartitioning$1(testCatalog, "a");
            this.sql().apply((Object)new StringBuilder(71).append("CREATE OR REPLACE TABLE tbl (a int, b string) USING ").append(this.v2Source()).append(" PARTITIONED BY (B)").toString());
            this.checkPartitioning$1(sessionCatalog, "b");
            this.sql().apply((Object)new StringBuilder(79).append("CREATE OR REPLACE TABLE testcat.tbl (a int, b string) USING ").append(this.v2Source()).append(" PARTITIONED BY (B)").toString());
            this.checkPartitioning$1(testCatalog, "b");
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1427));
        this.test("tableCreation: partition column case sensitive resolution", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkFailure$1(new StringBuilder(60).append("CREATE TABLE tbl (a int, b string) USING ").append(this.v2Source()).append(" PARTITIONED BY (A)").toString());
            this.checkFailure$1(new StringBuilder(68).append("CREATE TABLE testcat.tbl (a int, b string) USING ").append(this.v2Source()).append(" PARTITIONED BY (A)").toString());
            this.checkFailure$1(new StringBuilder(71).append("CREATE OR REPLACE TABLE tbl (a int, b string) USING ").append(this.v2Source()).append(" PARTITIONED BY (B)").toString());
            this.checkFailure$1(new StringBuilder(79).append("CREATE OR REPLACE TABLE testcat.tbl (a int, b string) USING ").append(this.v2Source()).append(" PARTITIONED BY (B)").toString());
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1454));
        this.test("tableCreation: duplicate column names in the table definition", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String errorMsg = "Found duplicate column(s) in the table definition of";
            ((IterableLike)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)new Tuple2((Object)"a", (Object)"a")), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new Tuple2((Object)"aA", (Object)"Aa")), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)x0$6 -> {
                DataSourceV2SQLSuite.$anonfun$new$251(this, errorMsg, x0$6);
                return BoxedUnit.UNIT;
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1472));
        this.test("tableCreation: duplicate nested column names in the table definition", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String errorMsg = "Found duplicate column(s) in the table definition of";
            ((IterableLike)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)new Tuple2((Object)"a", (Object)"a")), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new Tuple2((Object)"aA", (Object)"Aa")), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)x0$7 -> {
                DataSourceV2SQLSuite.$anonfun$new$254(this, errorMsg, x0$7);
                return BoxedUnit.UNIT;
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1496));
        this.test("tableCreation: bucket column names not in table definition", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String errorMsg = "Couldn't find column c in";
            this.assertAnalysisError(new StringBuilder(73).append("CREATE TABLE tbl (a int, b string) USING ").append(this.v2Source()).append(" CLUSTERED BY (c) INTO 4 BUCKETS").toString(), errorMsg);
            this.assertAnalysisError(new StringBuilder(81).append("CREATE TABLE testcat.tbl (a int, b string) USING ").append(this.v2Source()).append(" CLUSTERED BY (c) INTO 4 BUCKETS").toString(), errorMsg);
            this.assertAnalysisError(new StringBuilder(84).append("CREATE OR REPLACE TABLE tbl (a int, b string) USING ").append(this.v2Source()).append(" ").append("CLUSTERED BY (c) INTO 4 BUCKETS").toString(), errorMsg);
            this.assertAnalysisError(new StringBuilder(92).append("CREATE OR REPLACE TABLE testcat.tbl (a int, b string) USING ").append(this.v2Source()).append(" ").append("CLUSTERED BY (c) INTO 4 BUCKETS").toString(), errorMsg);
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1520));
        this.test("tableCreation: bucket column name containing dot", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            NamedReference[] references;
            Bool bool;
            Transform[] partitioning;
            this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("\n          |CREATE TABLE testcat.t (id int, `a.b` string) USING foo\n          |CLUSTERED BY (`a.b`) INTO 4 BUCKETS\n        ")).stripMargin());
            InMemoryTableCatalog testCatalog = (InMemoryTableCatalog)CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            Table table = testCatalog.loadTable(Identifier.of((String[])((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class))), (String)"t"));
            Transform[] $org_scalatest_assert_macro_left = partitioning = table.partitioning();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left2.value()) {
                String $org_scalatest_assert_macro_left3 = ((Transform)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitioning)).head()).name();
                String $org_scalatest_assert_macro_right2 = "bucket";
                String string = $org_scalatest_assert_macro_left3;
                String string2 = $org_scalatest_assert_macro_right2;
                bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            } else {
                bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right3 = bool;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1553));
            NamedReference[] $org_scalatest_assert_macro_left4 = references = ((Transform)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitioning)).head()).references();
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1555));
            Seq $org_scalatest_assert_macro_left5 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((NamedReference)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])references)).head()).fieldNames())).toSeq();
            Seq $org_scalatest_assert_macro_right5 = (Seq)new .colon.colon((Object)"a.b", (List)Nil$.MODULE$);
            Seq seq = $org_scalatest_assert_macro_left5;
            Seq seq2 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1556));
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1542));
        this.test("tableCreation: column repeated in partition columns", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String errorMsg = "Found duplicate column(s) in the partitioning";
            ((IterableLike)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)new Tuple2((Object)"a", (Object)"a")), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new Tuple2((Object)"aA", (Object)"Aa")), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)x0$8 -> {
                DataSourceV2SQLSuite.$anonfun$new$261(this, errorMsg, x0$8);
                return BoxedUnit.UNIT;
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1560));
        this.test("tableCreation: column repeated in bucket columns", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String errorMsg = "Found duplicate column(s) in the bucket definition";
            ((IterableLike)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)new Tuple2((Object)"a", (Object)"a")), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new Tuple2((Object)"aA", (Object)"Aa")), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)x0$9 -> {
                DataSourceV2SQLSuite.$anonfun$new$264(this, errorMsg, x0$9);
                return BoxedUnit.UNIT;
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1584));
        this.test("REFRESH TABLE: v2 table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(48).append("CREATE TABLE ").append(t).append(" (id bigint, data string) USING foo").toString());
                InMemoryTableCatalog testCatalog = (InMemoryTableCatalog)CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
                Identifier identifier = Identifier.of((String[])((String[])((Object[])new String[]{"ns1", "ns2"})), (String)"tbl");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(testCatalog.isTableInvalidated(identifier), "testCatalog.isTableInvalidated(identifier)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1620));
                this.sql().apply((Object)new StringBuilder(14).append("REFRESH TABLE ").append(t).toString());
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(testCatalog.isTableInvalidated(identifier), "testCatalog.isTableInvalidated(identifier)", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1622));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1612));
        this.test("SPARK-32990: REFRESH TABLE should resolve to a temporary view first", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"testcat.ns.t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE testcat.ns.t (id bigint) USING foo");
            this.sql().apply((Object)"CREATE TEMPORARY VIEW t AS SELECT 2");
            this.sql().apply((Object)"USE testcat.ns");
            InMemoryTableCatalog testCatalog = (InMemoryTableCatalog)CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testcat")).asTableCatalog();
            Identifier identifier = Identifier.of((String[])((String[])((Object[])new String[]{"ns"})), (String)"t");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(testCatalog.isTableInvalidated(identifier), "testCatalog.isTableInvalidated(identifier)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1636));
            this.sql().apply((Object)"REFRESH TABLE t");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(testCatalog.isTableInvalidated(identifier), "testCatalog.isTableInvalidated(identifier)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1638));
        })), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1626));
        this.test("SPARK-33435, SPARK-34099: REFRESH TABLE should refresh all caches referencing the table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String tblName = "testcat.ns.t";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tblName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(35).append("CREATE TABLE ").append(tblName).append(" (id bigint) USING foo").toString());
                this.sql().apply((Object)new StringBuilder(21).append("INSERT INTO ").append(tblName).append(" SELECT 0").toString());
                this.sql().apply((Object)new StringBuilder(32).append("CACHE TABLE t AS SELECT id FROM ").append(tblName).toString());
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> this.spark().table(tblName), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)})));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> this.spark().table("t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)})));
                this.sql().apply((Object)new StringBuilder(21).append("INSERT INTO ").append(tblName).append(" SELECT 1").toString());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.spark().sharedState().cacheManager().lookupCachedData(this.spark().table("t")).isDefined(), "DataSourceV2SQLSuite.this.spark.sharedState.cacheManager.lookupCachedData(DataSourceV2SQLSuite.this.spark.table(\"t\")).isDefined", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1655));
                this.sql().apply((Object)new StringBuilder(14).append("REFRESH TABLE ").append(tblName).toString());
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.spark().sharedState().cacheManager().lookupCachedData(this.spark().table("t")).isDefined(), "DataSourceV2SQLSuite.this.spark.sharedState.cacheManager.lookupCachedData(DataSourceV2SQLSuite.this.spark.table(\"t\")).isDefined", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1657));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> this.spark().table(tblName), (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$))));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> this.spark().table("t"), (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$))));
            }));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1643));
        this.test("SPARK-33653: REFRESH TABLE should recache the target table itself", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String tblName = "testcat.ns.t";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tblName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(35).append("CREATE TABLE ").append(tblName).append(" (id bigint) USING foo").toString());
                Option $org_scalatest_assert_macro_left = this.spark().sharedState().cacheManager().lookupCachedData(this.spark().table(tblName));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1670));
                this.sql().apply((Object)new StringBuilder(14).append("REFRESH TABLE ").append(tblName).toString());
                Option $org_scalatest_assert_macro_left2 = this.spark().sharedState().cacheManager().lookupCachedData(this.spark().table(tblName));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1672));
                this.sql().apply((Object)new StringBuilder(12).append("CACHE TABLE ").append(tblName).toString());
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(this.spark().sharedState().cacheManager().lookupCachedData(this.spark().table(tblName)).isDefined(), "DataSourceV2SQLSuite.this.spark.sharedState.cacheManager.lookupCachedData(DataSourceV2SQLSuite.this.spark.table(tblName)).isDefined", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1677));
                this.sql().apply((Object)new StringBuilder(14).append("REFRESH TABLE ").append(tblName).toString());
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(this.spark().sharedState().cacheManager().lookupCachedData(this.spark().table(tblName)).isDefined(), "DataSourceV2SQLSuite.this.spark.sharedState.cacheManager.lookupCachedData(DataSourceV2SQLSuite.this.spark.table(tblName)).isDefined", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1679));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1664));
        this.test("REPLACE TABLE: v1 table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            AnalysisException e = (AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(42).append("CREATE OR REPLACE TABLE tbl (a int) USING ").append(SimpleScanSource.class.getName()).toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1684))));
            String $org_scalatest_assert_macro_left = e.message();
            String $org_scalatest_assert_macro_right = "REPLACE TABLE is only supported with v2 tables";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1687));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1683));
        this.test("DeleteFrom: basic - delete all", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(78).append("CREATE TABLE ").append(t).append(" (id bigint, data string, p int) USING foo PARTITIONED BY (id, p)").toString());
                this.sql().apply((Object)new StringBuilder(60).append("INSERT INTO ").append(t).append(" VALUES (2L, 'a', 2), (2L, 'b', 3), (3L, 'c', 3)").toString());
                this.sql().apply((Object)new StringBuilder(12).append("DELETE FROM ").append(t).toString());
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> this.spark().table(t), (Seq<Row>)((Seq)Nil$.MODULE$));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1690));
        this.test("DeleteFrom: basic - delete with where clause", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(78).append("CREATE TABLE ").append(t).append(" (id bigint, data string, p int) USING foo PARTITIONED BY (id, p)").toString());
                this.sql().apply((Object)new StringBuilder(60).append("INSERT INTO ").append(t).append(" VALUES (2L, 'a', 2), (2L, 'b', 3), (3L, 'c', 3)").toString());
                this.sql().apply((Object)new StringBuilder(25).append("DELETE FROM ").append(t).append(" WHERE id = 2").toString());
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> this.spark().table(t), (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "c", BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$)));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1700));
        this.test("DeleteFrom: delete from aliased target table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(78).append("CREATE TABLE ").append(t).append(" (id bigint, data string, p int) USING foo PARTITIONED BY (id, p)").toString());
                this.sql().apply((Object)new StringBuilder(60).append("INSERT INTO ").append(t).append(" VALUES (2L, 'a', 2), (2L, 'b', 3), (3L, 'c', 3)").toString());
                this.sql().apply((Object)new StringBuilder(36).append("DELETE FROM ").append(t).append(" AS tbl WHERE tbl.id = 2").toString());
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> this.spark().table(t), (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "c", BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$)));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1711));
        this.test("DeleteFrom: normalize attribute names", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(78).append("CREATE TABLE ").append(t).append(" (id bigint, data string, p int) USING foo PARTITIONED BY (id, p)").toString());
                this.sql().apply((Object)new StringBuilder(60).append("INSERT INTO ").append(t).append(" VALUES (2L, 'a', 2), (2L, 'b', 3), (3L, 'c', 3)").toString());
                this.sql().apply((Object)new StringBuilder(36).append("DELETE FROM ").append(t).append(" AS tbl WHERE tbl.ID = 2").toString());
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> this.spark().table(t), (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "c", BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$)));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1722));
        this.test("DeleteFrom: fail if has subquery", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(78).append("CREATE TABLE ").append(t).append(" (id bigint, data string, p int) USING foo PARTITIONED BY (id, p)").toString());
                this.sql().apply((Object)new StringBuilder(60).append("INSERT INTO ").append(t).append(" VALUES (2L, 'a', 2), (2L, 'b', 3), (3L, 'c', 3)").toString());
                AnalysisException exc = (AnalysisException)((Object)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(42).append("DELETE FROM ").append(t).append(" WHERE id IN (SELECT id FROM ").append(t).append(")").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1738)))));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)this.spark().table(t).count()));
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1742));
                String $org_scalatest_assert_macro_left2 = exc.getMessage();
                String $org_scalatest_assert_macro_right2 = "Delete by condition with subquery is not supported";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1743));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1733));
        this.test("DeleteFrom: delete with unsupported predicates", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(55).append("CREATE TABLE ").append(t).append(" (id bigint, data string, p int) USING foo").toString());
                this.sql().apply((Object)new StringBuilder(60).append("INSERT INTO ").append(t).append(" VALUES (2L, 'a', 2), (2L, 'b', 3), (3L, 'c', 3)").toString());
                AnalysisException exc = (AnalysisException)((Object)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(35).append("DELETE FROM ").append(t).append(" WHERE id > 3 AND p > 3").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1752)))));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)this.spark().table(t).count()));
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1756));
                String $org_scalatest_assert_macro_left2 = exc.getMessage();
                String $org_scalatest_assert_macro_right2 = new StringBuilder(25).append("Cannot delete from table ").append(t).toString();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1757));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1747));
        this.test("DeleteFrom: DELETE is only supported with v2 tables", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().conf().unset(SQLConf$.MODULE$.V2_SESSION_CATALOG_IMPLEMENTATION().key());
            String v1Table = "tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{v1Table}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(42).append("CREATE TABLE ").append(v1Table).append(" USING ").append(SimpleScanSource.class.getName()).append(" OPTIONS (from=0,to=1)").toString());
                AnalysisException exc = (AnalysisException)((Object)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(24).append("DELETE FROM ").append(v1Table).append(" WHERE i = 2").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1768)))));
                String $org_scalatest_assert_macro_left = exc.getMessage();
                String $org_scalatest_assert_macro_right = "DELETE is only supported with v2 tables";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1772));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1761));
        this.test("SPARK-33652: DeleteFrom should refresh caches referencing the table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "testcat.ns1.ns2.tbl";
            String view = "view";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{view}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(78).append("CREATE TABLE ").append(t).append(" (id bigint, data string, p int) USING foo PARTITIONED BY (id, p)").toString());
                this.sql().apply((Object)new StringBuilder(60).append("INSERT INTO ").append(t).append(" VALUES (2L, 'a', 2), (2L, 'b', 3), (3L, 'c', 3)").toString());
                this.sql().apply((Object)new StringBuilder(35).append("CACHE TABLE view AS SELECT id FROM ").append(t).toString());
                long $org_scalatest_assert_macro_left = this.spark().table(view).count();
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1784));
                this.sql().apply((Object)new StringBuilder(25).append("DELETE FROM ").append(t).append(" WHERE id = 2").toString());
                long $org_scalatest_assert_macro_left2 = this.spark().table(view).count();
                int $org_scalatest_assert_macro_right2 = 1;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == (long)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1787));
            }));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1776));
        this.test("UPDATE TABLE", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(134).append("\n           |CREATE TABLE ").append(t).append(" (id bigint, name string, age int, p int)\n           |USING foo\n           |PARTITIONED BY (id, p)\n         ").toString())).stripMargin());
                this.assertAnalysisError("UPDATE dummy SET name='abc'", "Table or view not found");
                this.assertAnalysisError(new StringBuilder(23).append("UPDATE ").append(t).append(" SET dummy='abc'").toString(), "cannot resolve");
                this.assertAnalysisError(new StringBuilder(36).append("UPDATE ").append(t).append(" SET name='abc' WHERE dummy=1").toString(), "cannot resolve");
                UnsupportedOperationException e = (UnsupportedOperationException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(43).append("UPDATE ").append(t).append(" SET name='Robert', age=32 WHERE p=1").toString()), ClassTag$.MODULE$.apply(UnsupportedOperationException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1816));
                String $org_scalatest_assert_macro_left = e.getMessage();
                String $org_scalatest_assert_macro_right = "UPDATE TABLE is not supported temporarily";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1819));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1792));
        this.test("MERGE INTO TABLE", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String target = "testcat.ns1.ns2.target";
            String source = "testcat.ns1.ns2.source";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{target, source}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(134).append("\n           |CREATE TABLE ").append(target).append(" (id bigint, name string, age int, p int)\n           |USING foo\n           |PARTITIONED BY (id, p)\n         ").toString())).stripMargin());
                this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(134).append("\n           |CREATE TABLE ").append(source).append(" (id bigint, name string, age int, p int)\n           |USING foo\n           |PARTITIONED BY (id, p)\n         ").toString())).stripMargin());
                this.assertAnalysisError(new StringOps(Predef$.MODULE$.augmentString("\n           |MERGE INTO testcat.ns1.ns2.dummy AS target\n           |USING testcat.ns1.ns2.source AS source\n           |ON target.id = source.id\n           |WHEN MATCHED AND (target.age < 10) THEN DELETE\n           |WHEN MATCHED AND (target.age > 10) THEN UPDATE SET *\n           |WHEN NOT MATCHED AND (target.col2='insert')\n           |THEN INSERT *\n         ")).stripMargin(), "Table or view not found");
                this.assertAnalysisError(new StringOps(Predef$.MODULE$.augmentString("\n           |MERGE INTO testcat.ns1.ns2.target AS target\n           |USING testcat.ns1.ns2.dummy AS source\n           |ON target.id = source.id\n           |WHEN MATCHED AND (target.age < 10) THEN DELETE\n           |WHEN MATCHED AND (target.age > 10) THEN UPDATE SET *\n           |WHEN NOT MATCHED AND (target.col2='insert')\n           |THEN INSERT *\n         ")).stripMargin(), "Table or view not found");
                this.assertAnalysisError(new StringOps(Predef$.MODULE$.augmentString("\n           |MERGE INTO testcat.ns1.ns2.target AS target\n           |USING testcat.ns1.ns2.source AS source\n           |ON target.id = source.id\n           |WHEN MATCHED AND (target.age < 10) THEN DELETE\n           |WHEN MATCHED AND (target.age > 10) THEN UPDATE SET target.dummy = source.age\n           |WHEN NOT MATCHED AND (target.col2='insert')\n           |THEN INSERT *\n         ")).stripMargin(), "cannot resolve");
                this.assertAnalysisError(new StringOps(Predef$.MODULE$.augmentString("\n           |MERGE INTO testcat.ns1.ns2.target AS target\n           |USING testcat.ns1.ns2.source AS source\n           |ON target.id = source.id\n           |WHEN MATCHED AND (target.age < 10) THEN DELETE\n           |WHEN MATCHED AND (target.age > 10) THEN UPDATE SET target.age = source.dummy\n           |WHEN NOT MATCHED AND (target.col2='insert')\n           |THEN INSERT *\n         ")).stripMargin(), "cannot resolve");
                UnsupportedOperationException e = (UnsupportedOperationException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString("\n             |MERGE INTO testcat.ns1.ns2.target AS target\n             |USING testcat.ns1.ns2.source AS source\n             |ON target.id = source.id\n             |WHEN MATCHED AND (target.p < 0) THEN DELETE\n             |WHEN MATCHED AND (target.p > 0) THEN UPDATE SET *\n             |WHEN NOT MATCHED THEN INSERT *\n           ")).stripMargin()), ClassTag$.MODULE$.apply(UnsupportedOperationException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1893));
                String $org_scalatest_assert_macro_left = e.getMessage();
                String $org_scalatest_assert_macro_right = "MERGE INTO TABLE is not supported temporarily";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1904));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1823));
        this.test("rename table by ALTER VIEW", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"testcat.ns1.new"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE testcat.ns1.ns2.old USING foo AS SELECT id, data FROM source");
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SHOW TABLES FROM testcat.ns1.ns2"), (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"ns1.ns2", "old", BoxesRunTime.boxToBoolean((boolean)false)})), (List)Nil$.MODULE$)));
            AnalysisException e = (AnalysisException)((Object)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"ALTER VIEW testcat.ns1.ns2.old RENAME TO ns1.new"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1913)))));
            String $org_scalatest_assert_macro_left = e.getMessage();
            String $org_scalatest_assert_macro_right = "Cannot rename a table with ALTER VIEW. Please use ALTER TABLE instead";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1916));
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1908));
        this.test("AlterTable: renaming views are not supported", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            AnalysisException e = (AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"ALTER VIEW testcat.ns.tbl RENAME TO ns.view"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1922))));
            String $org_scalatest_assert_macro_left = e.getMessage();
            String $org_scalatest_assert_macro_right = "Table or view not found: testcat.ns.tbl";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1925));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1921));
        this.test("ANALYZE TABLE", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.spark().sql(new StringBuilder(48).append("CREATE TABLE ").append(t).append(" (id bigint, data string) USING foo").toString());
                this.testNotSupportedV2Command("ANALYZE TABLE", new StringBuilder(19).append(t).append(" COMPUTE STATISTICS").toString());
                this.testNotSupportedV2Command("ANALYZE TABLE", new StringBuilder(35).append(t).append(" COMPUTE STATISTICS FOR ALL COLUMNS").toString());
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1929));
        this.test("MSCK REPAIR TABLE", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.spark().sql(new StringBuilder(48).append("CREATE TABLE ").append(t).append(" (id bigint, data string) USING foo").toString());
                this.testNotSupportedV2Command("MSCK REPAIR TABLE", t);
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1938));
        this.test("LOAD DATA INTO TABLE", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(115).append("\n           |CREATE TABLE ").append(t).append(" (id bigint, data string)\n           |USING foo\n           |PARTITIONED BY (id)\n         ").toString())).stripMargin());
                this.testNotSupportedV2Command("LOAD DATA", new StringBuilder(29).append("INPATH 'filepath' INTO TABLE ").append(t).toString());
                this.testNotSupportedV2Command("LOAD DATA", new StringBuilder(35).append("LOCAL INPATH 'filepath' INTO TABLE ").append(t).toString());
                this.testNotSupportedV2Command("LOAD DATA", new StringBuilder(45).append("LOCAL INPATH 'filepath' OVERWRITE INTO TABLE ").append(t).toString());
                this.testNotSupportedV2Command("LOAD DATA", new StringBuilder(61).append("LOCAL INPATH 'filepath' OVERWRITE INTO TABLE ").append(t).append(" PARTITION(id=1)").toString());
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1946));
        this.test("SPARK-33898: SHOW CREATE TABLE AS SERDE", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.spark().sql(new StringBuilder(48).append("CREATE TABLE ").append(t).append(" (id bigint, data string) USING foo").toString());
                AnalysisException e = (AnalysisException)((Object)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(27).append("SHOW CREATE TABLE ").append(t).append(" AS SERDE").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1968)))));
                String $org_scalatest_assert_macro_left = e.message();
                String $org_scalatest_assert_macro_right = "SHOW CREATE TABLE AS SERDE is not supported for v2 tables.";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1971));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1964));
        this.test("SPARK-33898: SHOW CREATE TABLE", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(525).append("\n           |CREATE TABLE ").append(t).append(" (\n           |  a bigint NOT NULL,\n           |  b bigint,\n           |  c bigint,\n           |  `extra col` ARRAY<INT>,\n           |  `<another>` STRUCT<x: INT, y: ARRAY<BOOLEAN>>\n           |)\n           |USING foo\n           |OPTIONS (\n           |  from = 0,\n           |  to = 1,\n           |  via = 2)\n           |COMMENT 'This is a comment'\n           |TBLPROPERTIES ('prop1' = '1', 'prop2' = '2', 'prop3' = 3, 'prop4' = 4)\n           |PARTITIONED BY (a)\n           |LOCATION '/tmp'\n        ").toString())).stripMargin());
                String[] showDDL = this.getShowCreateDDL(new StringBuilder(18).append("SHOW CREATE TABLE ").append(t).toString());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(showDDL);
                String[] $org_scalatest_assert_macro_right = (String[])((Object[])new String[]{"CREATE TABLE testcat.ns1.ns2.tbl (", "`a` BIGINT NOT NULL,", "`b` BIGINT,", "`c` BIGINT,", "`extra col` ARRAY<INT>,", "`<another>` STRUCT<`x`: INT, `y`: ARRAY<BOOLEAN>>)", "USING foo", "OPTIONS(", "'from' = '0',", "'to' = '1',", "'via' = '2')", "PARTITIONED BY (a)", "COMMENT 'This is a comment'", "LOCATION '/tmp'", "TBLPROPERTIES(", "'prop1' = '1',", "'prop2' = '2',", "'prop3' = '3',", "'prop4' = '4')"});
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1998));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1975));
        this.test("SPARK-33898: SHOW CREATE TABLE WITH AS SELECT", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(99).append("\n           |CREATE TABLE ").append(t).append("\n           |USING foo\n           |AS SELECT 1 AS a, \"foo\" AS b\n         ").toString())).stripMargin());
                String[] showDDL = this.getShowCreateDDL(new StringBuilder(18).append("SHOW CREATE TABLE ").append(t).toString());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(showDDL);
                String[] $org_scalatest_assert_macro_right = (String[])((Object[])new String[]{"CREATE TABLE testcat.ns1.ns2.tbl (", "`a` INT,", "`b` STRING)", "USING foo"});
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2032));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2022));
        this.test("SPARK-33898: SHOW CREATE TABLE PARTITIONED BY Transforms", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(265).append("\n           |CREATE TABLE ").append(t).append(" (a INT, b STRING, ts TIMESTAMP) USING foo\n           |PARTITIONED BY (\n           |    a,\n           |    bucket(16, b),\n           |    years(ts),\n           |    months(ts),\n           |    days(ts),\n           |    hours(ts))\n         ").toString())).stripMargin());
                String[] showDDL = this.getShowCreateDDL(new StringBuilder(18).append("SHOW CREATE TABLE ").append(t).toString());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(showDDL);
                String[] $org_scalatest_assert_macro_right = (String[])((Object[])new String[]{"CREATE TABLE testcat.ns1.ns2.tbl (", "`a` INT,", "`b` STRING,", "`ts` TIMESTAMP)", "USING foo", "PARTITIONED BY (a, bucket(16, b), years(ts), months(ts), days(ts), hours(ts))"});
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2056));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2041));
        this.test("CACHE/UNCACHE TABLE", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String t = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.spark().sql(new StringBuilder(48).append("CREATE TABLE ").append(t).append(" (id bigint, data string) USING foo").toString());
                this.sql().apply((Object)new StringBuilder(12).append("CACHE TABLE ").append(t).toString());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.isCached$1(t), "isCached(t)", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2076));
                this.sql().apply((Object)new StringBuilder(14).append("UNCACHE TABLE ").append(t).toString());
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.isCached$1(t), "isCached(t)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2079));
            });
            AnalysisException e = (AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("UNCACHE TABLE ").append(t).toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2083))));
            String $org_scalatest_assert_macro_left = e.message();
            String $org_scalatest_assert_macro_right = "Table or view not found: testcat.ns1.ns2.tbl";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2086));
            return (Dataset)this.sql().apply((Object)new StringBuilder(24).append("UNCACHE TABLE IF EXISTS ").append(t).toString());
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2067));
        this.test("SHOW COLUMNS", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.spark().sql(new StringBuilder(48).append("CREATE TABLE ").append(t).append(" (id bigint, data string) USING foo").toString());
                this.testNotSupportedV2Command("SHOW COLUMNS", new StringBuilder(5).append("FROM ").append(t).toString());
                this.testNotSupportedV2Command("SHOW COLUMNS", new StringBuilder(3).append("IN ").append(t).toString());
                this.testNotSupportedV2Command("SHOW COLUMNS", "FROM tbl IN testcat.ns1.ns2");
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2092));
        this.test("ALTER TABLE SerDe properties", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.spark().sql(new StringBuilder(68).append("CREATE TABLE ").append(t).append(" (id bigint, data string) USING foo PARTITIONED BY (id)").toString());
                AnalysisException e = (AnalysisException)((Object)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(75).append("ALTER TABLE ").append(t).append(" SET SERDEPROPERTIES ('columns'='foo,bar', 'field.delim' = ',')").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2107)))));
                String $org_scalatest_assert_macro_left = e.message();
                String $org_scalatest_assert_macro_right = "ALTER TABLE ... SET [SERDE|SERDEPROPERTIES] is not supported for v2 tables";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2110));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2103));
        this.test("CREATE VIEW", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String v = "testcat.ns1.ns2.v";
            AnalysisException e = (AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(24).append("CREATE VIEW ").append(v).append(" AS SELECT 1").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2117))));
            String $org_scalatest_assert_macro_left = e.message();
            String $org_scalatest_assert_macro_right = "CREATE VIEW is only supported with v1 tables";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2120));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2115));
        this.test("SHOW TBLPROPERTIES: v2 table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                String user = "andrew";
                String status = "new";
                String provider = "foo";
                this.spark().sql(new StringBuilder(84).append("CREATE TABLE ").append(t).append(" (id bigint, data string) USING ").append(provider).append(" ").append("TBLPROPERTIES ('user'='").append(user).append("', 'status'='").append(status).append("')").toString());
                Dataset properties = (Dataset)this.sql().apply((Object)new StringBuilder(19).append("SHOW TBLPROPERTIES ").append(t).toString());
                StructType schema = new StructType().add("key", (DataType)StringType$.MODULE$, false).add("value", (DataType)StringType$.MODULE$, false);
                Seq expected = (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"status", status})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"user", user})), (List)Nil$.MODULE$));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(properties.schema());
                StructType $org_scalatest_assert_macro_right = schema;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2142));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(expected);
                Row[] $org_scalatest_assert_macro_right2 = (Row[])properties.collect();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2143));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2123));
        this.test("SHOW TBLPROPERTIES(key): v2 table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                String user = "andrew";
                String status = "new";
                String provider = "foo";
                this.spark().sql(new StringBuilder(84).append("CREATE TABLE ").append(t).append(" (id bigint, data string) USING ").append(provider).append(" ").append("TBLPROPERTIES ('user'='").append(user).append("', 'status'='").append(status).append("')").toString());
                Dataset properties = (Dataset)this.sql().apply((Object)new StringBuilder(30).append("SHOW TBLPROPERTIES ").append(t).append(" ('status')").toString());
                Seq expected = (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"status", status})), (List)Nil$.MODULE$);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(expected);
                Row[] $org_scalatest_assert_macro_right = (Row[])properties.collect();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2160));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2147));
        this.test("SHOW TBLPROPERTIES(key): v2 table, key not found", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                String nonExistingKey = "nonExistingKey";
                this.spark().sql(new StringBuilder(96).append("CREATE TABLE ").append(t).append(" (id bigint, data string) USING foo ").append("TBLPROPERTIES ('user'='andrew', 'status'='new')").toString());
                Dataset properties = (Dataset)this.sql().apply((Object)new StringBuilder(24).append("SHOW TBLPROPERTIES ").append(t).append(" ('").append(nonExistingKey).append("')").toString());
                Seq expected = (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{nonExistingKey, new StringBuilder(31).append("Table ").append(t).append(" does not have property: ").append(nonExistingKey).toString()})), (List)Nil$.MODULE$);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(expected);
                Row[] $org_scalatest_assert_macro_right = (Row[])properties.collect();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2175));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2164));
        this.test("DESCRIBE FUNCTION: only support session catalog", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            AnalysisException e = (AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"DESCRIBE FUNCTION testcat.ns1.ns2.fun"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2180))));
            String $org_scalatest_assert_macro_left = e.message();
            String $org_scalatest_assert_macro_right = "function is only supported in v1 catalog";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2183));
            AnalysisException e1 = (AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"DESCRIBE FUNCTION default.ns1.ns2.fun"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2185))));
            String $org_scalatest_assert_macro_left2 = e1.message();
            String $org_scalatest_assert_macro_right2 = "Unsupported function name 'default.ns1.ns2.fun'";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2188));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2179));
        this.test("SHOW FUNCTIONS not valid v1 namespace", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String function = "testcat.ns1.ns2.fun";
            AnalysisException e = (AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(20).append("SHOW FUNCTIONS LIKE ").append(function).toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2194))));
            String $org_scalatest_assert_macro_left = e.message();
            String $org_scalatest_assert_macro_right = "function is only supported in v1 catalog";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2197));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2191));
        this.test("DROP FUNCTION: only support session catalog", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            AnalysisException e = (AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"DROP FUNCTION testcat.ns1.ns2.fun"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2201))));
            String $org_scalatest_assert_macro_left = e.message();
            String $org_scalatest_assert_macro_right = "function is only supported in v1 catalog";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2204));
            AnalysisException e1 = (AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"DROP FUNCTION default.ns1.ns2.fun"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2206))));
            String $org_scalatest_assert_macro_left2 = e1.message();
            String $org_scalatest_assert_macro_right2 = "Unsupported function name 'default.ns1.ns2.fun'";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2209));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2200));
        this.test("CREATE FUNCTION: only support session catalog", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            AnalysisException e = (AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"CREATE FUNCTION testcat.ns1.ns2.fun as 'f'"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2213))));
            String $org_scalatest_assert_macro_left = e.message();
            String $org_scalatest_assert_macro_right = "function is only supported in v1 catalog";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2216));
            AnalysisException e1 = (AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"CREATE FUNCTION default.ns1.ns2.fun as 'f'"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2218))));
            String $org_scalatest_assert_macro_left2 = e1.message();
            String $org_scalatest_assert_macro_right2 = "Unsupported function name 'default.ns1.ns2.fun'";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2221));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2212));
        this.test("REFRESH FUNCTION: only support session catalog", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            AnalysisException e = (AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"REFRESH FUNCTION testcat.ns1.ns2.fun"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2225))));
            String $org_scalatest_assert_macro_left = e.message();
            String $org_scalatest_assert_macro_right = "function is only supported in v1 catalog";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2228));
            AnalysisException e1 = (AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"REFRESH FUNCTION default.ns1.ns2.fun"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2230))));
            String $org_scalatest_assert_macro_left2 = e1.message();
            String $org_scalatest_assert_macro_right2 = "Unsupported function name 'default.ns1.ns2.fun'";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2233));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2224));
        this.test("global temp view should not be masked by v2 catalog", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            String globalTempDB = (String)this.spark().sessionState().conf().getConf(StaticSQLConf$.MODULE$.GLOBAL_TEMP_DATABASE());
            this.spark().conf().set(new StringBuilder(18).append("spark.sql.catalog.").append(globalTempDB).toString(), InMemoryTableCatalog.class.getName());
            try {
                this.sql().apply((Object)"create global temp view v as select 1");
                this.sql().apply((Object)new StringBuilder(26).append("alter view ").append(globalTempDB).append(".v rename to v2").toString());
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> this.spark().table(new StringBuilder(3).append(globalTempDB).append(".v2").toString()), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
                object = this.sql().apply((Object)new StringBuilder(13).append("drop view ").append(globalTempDB).append(".v2").toString());
            }
            finally {
                this.spark().sharedState().globalTempViewManager().clear();
            }
            return object;
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2237));
        this.test("SPARK-30104: global temp db is used as a table name under v2 catalog", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String globalTempDB = (String)this.spark().sessionState().conf().getConf(StaticSQLConf$.MODULE$.GLOBAL_TEMP_DATABASE());
            String t = new StringBuilder(8).append("testcat.").append(globalTempDB).toString();
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(48).append("CREATE TABLE ").append(t).append(" (id bigint, data string) USING foo").toString());
                this.sql().apply((Object)"USE testcat");
                this.sql().apply((Object)new StringBuilder(15).append("DESCRIBE TABLE ").append(globalTempDB).toString());
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2251));
        this.test("SPARK-30104: v2 catalog named global_temp will be masked", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String globalTempDB = (String)this.spark().sessionState().conf().getConf(StaticSQLConf$.MODULE$.GLOBAL_TEMP_DATABASE());
            this.spark().conf().set(new StringBuilder(18).append("spark.sql.catalog.").append(globalTempDB).toString(), InMemoryTableCatalog.class.getName());
            AnalysisException e = (AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(61).append("CREATE TABLE ").append(globalTempDB).append(".ns1.ns2.tbl (id bigint, data string) USING json").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2266))));
            String $org_scalatest_assert_macro_left = e.message();
            String $org_scalatest_assert_macro_right = "global_temp.ns1.ns2.tbl is not a valid TableIdentifier as it has more than 2 name parts.";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2271));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2262));
        this.test("table name same as catalog can be used", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"testcat.testcat"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE testcat.testcat (id bigint, data string) USING foo");
            this.sql().apply((Object)"USE testcat");
            this.sql().apply((Object)"DESCRIBE TABLE testcat");
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2275));
        this.test("SPARK-30001: session catalog name can be specified in SQL statements", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().conf().unset(SQLConf$.MODULE$.V2_SESSION_CATALOG_IMPLEMENTATION().key());
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)"CREATE TABLE t USING json AS SELECT 1 AS i");
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"select * from t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"select * from spark_catalog.default.t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2284));
        this.test("SPARK-30885: v1 table name should be fully qualified", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertWrongTableIdent$1();
            this.spark().conf().unset(SQLConf$.MODULE$.V2_SESSION_CATALOG_IMPLEMENTATION().key());
            this.assertWrongTableIdent$1();
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2295));
        this.test("SPARK-30259: session catalog can be specified in CREATE TABLE AS SELECT command", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Identifier ident = Identifier.of((String[])((String[])((Object[])new String[]{"default"})), (String)"tbl");
            this.sql().apply((Object)"CREATE TABLE spark_catalog.default.tbl USING json AS SELECT 1 AS i");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("spark_catalog")).asTableCatalog().tableExists(ident)));
            boolean $org_scalatest_assert_macro_right = true;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2355));
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2351));
        this.test("SPARK-30259: session catalog can be specified in CREATE TABLE command", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Identifier ident = Identifier.of((String[])((String[])((Object[])new String[]{"default"})), (String)"tbl");
            this.sql().apply((Object)"CREATE TABLE spark_catalog.default.tbl (col string) USING json");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("spark_catalog")).asTableCatalog().tableExists(ident)));
            boolean $org_scalatest_assert_macro_right = true;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2363));
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2359));
        this.test("SPARK-30094: current namespace is used during table resolution", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().conf().unset(SQLConf$.MODULE$.V2_SESSION_CATALOG_IMPLEMENTATION().key());
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark_catalog.default.t", "testcat.ns.t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)"CREATE TABLE t USING parquet AS SELECT 1");
                this.sql().apply((Object)"CREATE TABLE testcat.ns.t USING parquet AS SELECT 2");
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
                this.sql().apply((Object)"USE testcat.ns");
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)})));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2367));
        this.test("SPARK-30284: CREATE VIEW should track the current catalog and namespace", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().conf().unset(SQLConf$.MODULE$.V2_SESSION_CATALOG_IMPLEMENTATION().key());
            String sessionCatalogName = CatalogManager$.MODULE$.SESSION_CATALOG_NAME();
            this.sql().apply((Object)"CREATE NAMESPACE testcat.ns1.ns2");
            this.sql().apply((Object)"USE testcat.ns1.ns2");
            this.sql().apply((Object)"CREATE TABLE t USING foo AS SELECT 1 col");
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> this.spark().table("t"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
            this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.spark().range(10L).createTempView("t");
                this.withView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(10).append(sessionCatalogName).append(".default.v").toString()}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    AnalysisException e = (AnalysisException)((Object)((Object)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(41).append("CREATE VIEW ").append(sessionCatalogName).append(".default.v AS SELECT * FROM t").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2395))))));
                    String $org_scalatest_assert_macro_left = e.message();
                    String $org_scalatest_assert_macro_right = "referencing a temporary view";
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2398));
                });
            });
            this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(10).append(sessionCatalogName).append(".default.v").toString()}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(67).append("CREATE VIEW ").append(sessionCatalogName).append(".default.v ").append("AS SELECT t1.col FROM t t1 JOIN ns1.ns2.t t2").toString());
                this.sql().apply((Object)new StringBuilder(4).append("USE ").append(sessionCatalogName).toString());
                this.spark().range(10L).createTempView("t");
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> this.spark().table("v"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
            }));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2382));
        this.test("COMMENT ON NAMESPACE", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            this.spark().conf().unset(SQLConf$.MODULE$.V2_SESSION_CATALOG_IMPLEMENTATION().key());
            this.sql().apply((Object)"CREATE NAMESPACE ns");
            this.checkNamespaceComment("ns", "minor revision");
            this.checkNamespaceComment("ns", null);
            this.checkNamespaceComment("ns", "NULL");
            this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"COMMENT ON NAMESPACE abc IS NULL"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2422));
            this.sql().apply((Object)"CREATE NAMESPACE testcat.ns1");
            this.checkNamespaceComment("testcat.ns1", "minor revision");
            this.checkNamespaceComment("testcat.ns1", null);
            this.checkNamespaceComment("testcat.ns1", "NULL");
            return (AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"COMMENT ON NAMESPACE testcat.abc IS NULL"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2429))));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2414));
        this.test("COMMENT ON TABLE", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().conf().unset(SQLConf$.MODULE$.V2_SESSION_CATALOG_IMPLEMENTATION().key());
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)"CREATE TABLE t(k int) USING json");
                this.checkTableComment("t", "minor revision");
                this.checkTableComment("t", null);
                this.checkTableComment("t", "NULL");
            });
            this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"COMMENT ON TABLE abc IS NULL"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2451));
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"testcat.ns1.ns2.t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)"CREATE TABLE testcat.ns1.ns2.t(k int) USING foo");
                this.checkTableComment("testcat.ns1.ns2.t", "minor revision");
                this.checkTableComment("testcat.ns1.ns2.t", null);
                this.checkTableComment("testcat.ns1.ns2.t", "NULL");
            });
            this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"COMMENT ON TABLE testcat.abc IS NULL"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2460));
            String globalTempDB = (String)this.spark().sessionState().conf().getConf(StaticSQLConf$.MODULE$.GLOBAL_TEMP_DATABASE());
            this.spark().conf().set(new StringBuilder(18).append("spark.sql.catalog.").append(globalTempDB).toString(), InMemoryTableCatalog.class.getName());
            this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"v"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)"create global temp view v as select 1");
                AnalysisException e = (AnalysisException)((Object)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"COMMENT ON TABLE global_temp.v IS NULL"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2466)))));
                String $org_scalatest_assert_macro_left = e.getMessage();
                String $org_scalatest_assert_macro_right = "global_temp.v is a temp view. 'COMMENT ON TABLE' expects a table";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2467));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2441));
        this.test("SPARK-30799: temp view name can't contain catalog name", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String sessionCatalogName = CatalogManager$.MODULE$.SESSION_CATALOG_NAME();
            this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"v"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.spark().range(10L).createTempView("v");
                AnalysisException e1 = (AnalysisException)((Object)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("CACHE TABLE ").append(sessionCatalogName).append(".v").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2484)))));
                String $org_scalatest_assert_macro_left = e1.message();
                String $org_scalatest_assert_macro_right = "Table or view not found: spark_catalog.v";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2487));
            });
            AnalysisException e2 = (AnalysisException)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(31).append("CREATE TEMP VIEW ").append(sessionCatalogName).append(".v AS SELECT 1").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2490))));
            String $org_scalatest_assert_macro_left = e2.message();
            String $org_scalatest_assert_macro_right = "It is not allowed to add database prefix";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2493));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2480));
        this.test("SPARK-31015: star expression should work for qualified column names for v2 tables", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(48).append("CREATE TABLE ").append(t).append(" (id bigint, name string) USING foo").toString());
                this.sql().apply((Object)new StringBuilder(32).append("INSERT INTO ").append(t).append(" VALUES (1, 'hello')").toString());
                this.check$2(t);
                this.sql().apply((Object)"USE testcat.ns1.ns2");
                this.check$2("tbl");
                AnalysisException ex = (AnalysisException)((Object)((Object)((Object)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(30).append("SELECT ns1.ns2.ns3.tbl.* from ").append(t).toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2516)))));
                String $org_scalatest_assert_macro_left = ex.getMessage();
                String $org_scalatest_assert_macro_right = "cannot resolve 'ns1.ns2.ns3.tbl.*";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2519));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2496));
        this.test("SPARK-32168: INSERT OVERWRITE - hidden days partition - dynamic mode", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARTITION_OVERWRITE_MODE().key()), (Object)SQLConf.PartitionOverwriteMode$.MODULE$.DYNAMIC().toString())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t1 = new StringBuilder(3).append(this.catalogAndNamespace()).append("tbl").toString();
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t1}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuite.class.getClassLoader());
                public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuite$$typecreator48$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.sql.Timestamp").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_sql_connector_DataSourceV2SQLSuite$$typecreator48$1(DataSourceV2SQLSuite $outer) {
                    }
                }
                Dataset df = this.spark().createDataFrame((Seq)new .colon.colon((Object)new Tuple2((Object)DataSourceV2SQLSuite.testTimestamp$1(1), (Object)"a"), (List)new .colon.colon((Object)new Tuple2((Object)DataSourceV2SQLSuite.testTimestamp$1(2), (Object)"b"), (List)new .colon.colon((Object)new Tuple2((Object)DataSourceV2SQLSuite.testTimestamp$1(3), (Object)"c"), (List)Nil$.MODULE$))), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuite$$typecreator48$1(null))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ts", "data"}));
                df.createOrReplaceTempView("source_view");
                this.sql().apply((Object)new StringBuilder(74).append("CREATE TABLE ").append(t1).append(" (ts timestamp, data string) ").append("USING ").append(this.v2Format()).append(" PARTITIONED BY (days(ts))").toString());
                this.sql().apply((Object)new StringBuilder(131).append("INSERT INTO ").append(t1).append(" VALUES ").append("(CAST(date_add('2020-01-01', 2) AS timestamp), 'dummy'), ").append("(CAST(date_add('2020-01-01', 4) AS timestamp), 'keep')").toString());
                this.sql().apply((Object)new StringBuilder(56).append("INSERT OVERWRITE TABLE ").append(t1).append(" SELECT ts, data FROM source_view").toString());
                JavaUniverse $u2 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(DataSourceV2SQLSuite.class.getClassLoader());
                public final class Org_apache_spark_sql_connector_DataSourceV2SQLSuite$$typecreator49$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.sql.Timestamp").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_sql_connector_DataSourceV2SQLSuite$$typecreator49$1(DataSourceV2SQLSuite $outer) {
                    }
                }
                Dataset expected = this.spark().createDataFrame((Seq)new .colon.colon((Object)new Tuple2((Object)DataSourceV2SQLSuite.testTimestamp$1(1), (Object)"a"), (List)new .colon.colon((Object)new Tuple2((Object)DataSourceV2SQLSuite.testTimestamp$1(2), (Object)"b"), (List)new .colon.colon((Object)new Tuple2((Object)DataSourceV2SQLSuite.testTimestamp$1(3), (Object)"c"), (List)new .colon.colon((Object)new Tuple2((Object)DataSourceV2SQLSuite.testTimestamp$1(4), (Object)"keep"), (List)Nil$.MODULE$)))), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2SQLSuite$$typecreator49$1(null))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ts", "data"}));
                this.verifyTable(t1, (Dataset<Row>)expected);
            });
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2523));
        this.test("SPARK-31255: Project a metadata column", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t1 = new StringBuilder(5).append(this.catalogAndNamespace()).append("table").toString();
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t1}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(80).append("CREATE TABLE ").append(t1).append(" (id bigint, data string) USING ").append(this.v2Format()).append(" ").append("PARTITIONED BY (bucket(4, id), id)").toString());
                this.sql().apply((Object)new StringBuilder(48).append("INSERT INTO ").append(t1).append(" VALUES (1, 'a'), (2, 'b'), (3, 'c')").toString());
                Dataset sqlQuery = this.spark().sql(new StringBuilder(40).append("SELECT id, data, index, _partition FROM ").append(t1).toString());
                Dataset dfQuery = this.spark().table(t1).select("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"data", "index", "_partition"}));
                ((IterableLike)new .colon.colon((Object)sqlQuery, (List)new .colon.colon((Object)dfQuery, (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)query -> {
                    this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> query, (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a", BoxesRunTime.boxToInteger((int)0), "3/1"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "b", BoxesRunTime.boxToInteger((int)0), "0/2"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "c", BoxesRunTime.boxToInteger((int)0), "1/3"})), (List)Nil$.MODULE$)))));
                    return BoxedUnit.UNIT;
                });
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2555));
        this.test("SPARK-31255: Projects data column when metadata column has the same name", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t1 = new StringBuilder(5).append(this.catalogAndNamespace()).append("table").toString();
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t1}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(89).append("CREATE TABLE ").append(t1).append(" (index bigint, data string) USING ").append(this.v2Format()).append(" ").append("PARTITIONED BY (bucket(4, index), index)").toString());
                this.sql().apply((Object)new StringBuilder(48).append("INSERT INTO ").append(t1).append(" VALUES (3, 'c'), (2, 'b'), (1, 'a')").toString());
                Dataset sqlQuery = this.spark().sql(new StringBuilder(36).append("SELECT index, data, _partition FROM ").append(t1).toString());
                Dataset dfQuery = this.spark().table(t1).select("index", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"data", "_partition"}));
                ((IterableLike)new .colon.colon((Object)sqlQuery, (List)new .colon.colon((Object)dfQuery, (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)query -> {
                    this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> query, (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "c", "1/3"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "b", "0/2"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a", "3/1"})), (List)Nil$.MODULE$)))));
                    return BoxedUnit.UNIT;
                });
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2571));
        this.test("SPARK-31255: * expansion does not include metadata columns", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t1 = new StringBuilder(5).append(this.catalogAndNamespace()).append("table").toString();
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t1}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(80).append("CREATE TABLE ").append(t1).append(" (id bigint, data string) USING ").append(this.v2Format()).append(" ").append("PARTITIONED BY (bucket(4, id), id)").toString());
                this.sql().apply((Object)new StringBuilder(48).append("INSERT INTO ").append(t1).append(" VALUES (3, 'c'), (2, 'b'), (1, 'a')").toString());
                Dataset sqlQuery = this.spark().sql(new StringBuilder(14).append("SELECT * FROM ").append(t1).toString());
                Dataset dfQuery = this.spark().table(t1);
                ((IterableLike)new .colon.colon((Object)sqlQuery, (List)new .colon.colon((Object)dfQuery, (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)query -> {
                    this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> query, (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "c"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "b"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a"})), (List)Nil$.MODULE$)))));
                    return BoxedUnit.UNIT;
                });
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2587));
        this.test("SPARK-31255: metadata column should only be produced when necessary", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t1 = new StringBuilder(5).append(this.catalogAndNamespace()).append("table").toString();
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t1}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(80).append("CREATE TABLE ").append(t1).append(" (id bigint, data string) USING ").append(this.v2Format()).append(" ").append("PARTITIONED BY (bucket(4, id), id)").toString());
                Dataset sqlQuery = this.spark().sql(new StringBuilder(30).append("SELECT * FROM ").append(t1).append(" WHERE index = 0").toString());
                Dataset dfQuery = this.spark().table(t1).filter("index = 0");
                ((IterableLike)new .colon.colon((Object)sqlQuery, (List)new .colon.colon((Object)dfQuery, (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)query -> {
                    Seq $org_scalatest_assert_macro_left = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])query.schema().fieldNames())).toSeq();
                    Seq $org_scalatest_assert_macro_right = (Seq)new .colon.colon((Object)"id", (List)new .colon.colon((Object)"data", (List)Nil$.MODULE$));
                    Seq seq = $org_scalatest_assert_macro_left;
                    Seq seq2 = $org_scalatest_assert_macro_right;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2613));
                });
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2603));
        this.test("SPARK-34547: metadata columns are resolved last", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t1 = new StringBuilder(8).append(this.catalogAndNamespace()).append("tableOne").toString();
            String t2 = "t2";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t1}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(80).append("CREATE TABLE ").append(t1).append(" (id bigint, data string) USING ").append(this.v2Format()).append(" ").append("PARTITIONED BY (bucket(4, id), id)").toString());
                this.sql().apply((Object)new StringBuilder(48).append("INSERT INTO ").append(t1).append(" VALUES (1, 'a'), (2, 'b'), (3, 'c')").toString());
                this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t2}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    this.sql().apply((Object)new StringBuilder(87).append("CREATE TEMPORARY VIEW ").append(t2).append(" AS SELECT * FROM ").append("VALUES (1, -1), (2, -2), (3, -3) AS ").append(t2).append("(id, index)").toString());
                    Dataset sqlQuery = this.spark().sql(new StringBuilder(72).append("SELECT ").append(t1).append(".id, ").append(t2).append(".id, data, index, ").append(t1).append(".index, ").append(t2).append(".index FROM ").append(t1).append(" JOIN ").append(t2).append(" WHERE ").append(t1).append(".id = ").append(t2).append(".id").toString());
                    Dataset t1Table = this.spark().table(t1);
                    Dataset t2Table = this.spark().table(t2);
                    Dataset dfQuery = t1Table.join(t2Table, t1Table.col("id").$eq$eq$eq((Object)t2Table.col("id"))).select(new StringBuilder(3).append(t1).append(".id").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(3).append(t2).append(".id").toString(), "data", "index", new StringBuilder(6).append(t1).append(".index").toString(), new StringBuilder(6).append(t2).append(".index").toString()}));
                    ((IterableLike)new .colon.colon((Object)sqlQuery, (List)new .colon.colon((Object)dfQuery, (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)query -> {
                        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> query, (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)1), "a", BoxesRunTime.boxToInteger((int)-1), BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)-1)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)2), "b", BoxesRunTime.boxToInteger((int)-2), BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)-2)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)3), "c", BoxesRunTime.boxToInteger((int)-3), BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)-3)})), (List)Nil$.MODULE$)))));
                        return BoxedUnit.UNIT;
                    });
                });
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2618));
        this.test("SPARK-33505: insert into partitioned table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "testpart.ns1.ns2.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(115).append("\n        |CREATE TABLE ").append(t).append(" (id bigint, city string, data string)\n        |USING foo\n        |PARTITIONED BY (id, city)").toString())).stripMargin());
                InMemoryPartitionTable partTable = (InMemoryPartitionTable)CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testpart")).asTableCatalog().loadTable(Identifier.of((String[])((String[])((Object[])new String[]{"ns1", "ns2"})), (String)"tbl"));
                InternalRow expectedPartitionIdent = InternalRow$.MODULE$.fromSeq((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), UTF8String.fromString((String)"NY")})));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(partTable.partitionExists(expectedPartitionIdent), "partTable.partitionExists(expectedPartitionIdent)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2659));
                this.sql().apply((Object)new StringBuilder(56).append("INSERT INTO ").append(t).append(" PARTITION(id = 1, city = 'NY') SELECT 'abc'").toString());
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(partTable.partitionExists(expectedPartitionIdent), "partTable.partitionExists(expectedPartitionIdent)", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2661));
                this.sql().apply((Object)new StringBuilder(56).append("INSERT INTO ").append(t).append(" PARTITION(id = 1, city = 'NY') SELECT 'def'").toString());
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(partTable.partitionExists(expectedPartitionIdent), "partTable.partitionExists(expectedPartitionIdent)", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2664));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2649));
        this.test("View commands are not supported in v2 catalogs", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.validateViewCommand$1("DROP VIEW testcat.v", "testcat", "v", "DROP VIEW");
            this.validateViewCommand$1("ALTER VIEW testcat.v SET TBLPROPERTIES ('key' = 'val')", "testcat", "v", "ALTER VIEW ... SET TBLPROPERTIES");
            this.validateViewCommand$1("ALTER VIEW testcat.v UNSET TBLPROPERTIES ('key')", "testcat", "v", "ALTER VIEW ... UNSET TBLPROPERTIES");
            this.validateViewCommand$1("ALTER VIEW testcat.v AS SELECT 1", "testcat", "v", "ALTER VIEW ... AS");
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2668));
        this.test("SPARK-33924: INSERT INTO .. PARTITION preserves the partition location", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t = "testpart.ns1.ns2.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(115).append("\n        |CREATE TABLE ").append(t).append(" (id bigint, city string, data string)\n        |USING foo\n        |PARTITIONED BY (id, city)").toString())).stripMargin());
                InMemoryPartitionTable partTable = (InMemoryPartitionTable)CatalogV2Implicits$.MODULE$.CatalogHelper(this.catalog("testpart")).asTableCatalog().loadTable(Identifier.of((String[])((String[])((Object[])new String[]{"ns1", "ns2"})), (String)"tbl"));
                String loc = "partition_location";
                this.sql().apply((Object)new StringBuilder(60).append("ALTER TABLE ").append(t).append(" ADD PARTITION (id = 1, city = 'NY') LOCATION '").append(loc).append("'").toString());
                InternalRow ident = InternalRow$.MODULE$.fromSeq((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), UTF8String.fromString((String)"NY")})));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(partTable.loadPartitionMetadata(ident).get("location"));
                String $org_scalatest_assert_macro_right = loc;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2712));
                this.sql().apply((Object)new StringBuilder(56).append("INSERT INTO ").append(t).append(" PARTITION(id = 1, city = 'NY') SELECT 'abc'").toString());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(partTable.loadPartitionMetadata(ident).get("location"));
                String $org_scalatest_assert_macro_right2 = loc;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2715));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2698));
        this.test("SPARK-34468: rename table in place when the destination name has single part", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String tbl = new StringBuilder(7).append(this.catalogAndNamespace()).append("src_tbl").toString();
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tbl}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(29).append("CREATE TABLE ").append(tbl).append(" (c0 INT) USING ").append(this.v2Format()).toString());
                this.sql().apply((Object)new StringBuilder(21).append("INSERT INTO ").append(tbl).append(" SELECT 0").toString());
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SHOW TABLES FROM testcat.ns1.ns2 LIKE 'new_tbl'"), (Seq<Row>)Nil$.MODULE$);
                this.sql().apply((Object)new StringBuilder(30).append("ALTER TABLE ").append(tbl).append(" RENAME TO new_tbl").toString());
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SHOW TABLES FROM testcat.ns1.ns2 LIKE 'new_tbl'"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"ns1.ns2", "new_tbl", BoxesRunTime.boxToBoolean((boolean)false)})));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(22).append("SELECT c0 FROM ").append(this.catalogAndNamespace()).append("new_tbl").toString()), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)})));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2719));
        this.test("SPARK-34555: Resolve DataFrame metadata column", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String tbl = new StringBuilder(5).append(this.catalogAndNamespace()).append("table").toString();
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tbl}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(80).append("CREATE TABLE ").append(tbl).append(" (id bigint, data string) USING ").append(this.v2Format()).append(" ").append("PARTITIONED BY (bucket(4, id), id)").toString());
                this.sql().apply((Object)new StringBuilder(48).append("INSERT INTO ").append(tbl).append(" VALUES (1, 'a'), (2, 'b'), (3, 'c')").toString());
                Dataset table = this.spark().table(tbl);
                Dataset dfQuery = table.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{table.col("id"), table.col("data"), table.col("index"), table.col("_partition")}));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> dfQuery, (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a", BoxesRunTime.boxToInteger((int)0), "3/1"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "b", BoxesRunTime.boxToInteger((int)0), "0/2"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "c", BoxesRunTime.boxToInteger((int)0), "1/3"})), (List)Nil$.MODULE$)))));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2733));
        this.test("SPARK-34561: drop/add columns to a dataset of `DESCRIBE TABLE`", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String tbl = new StringBuilder(3).append(this.catalogAndNamespace()).append("tbl").toString();
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tbl}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(29).append("CREATE TABLE ").append(tbl).append(" (c0 INT) USING ").append(this.v2Format()).toString());
                Dataset description = (Dataset)this.sql().apply((Object)new StringBuilder(15).append("DESCRIBE TABLE ").append(tbl).toString());
                Dataset noCommentDataset = description.drop("comment");
                StructType expectedSchema = new StructType().add("col_name", (DataType)StringType$.MODULE$, false, new MetadataBuilder().putString("comment", "name of the column").build()).add("data_type", (DataType)StringType$.MODULE$, false, new MetadataBuilder().putString("comment", "data type of the column").build());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(noCommentDataset.schema());
                StructType $org_scalatest_assert_macro_right = expectedSchema;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2771));
                Dataset isNullDataset = noCommentDataset.withColumn("is_null", noCommentDataset.apply("col_name").isNull());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(isNullDataset.schema());
                StructType $org_scalatest_assert_macro_right2 = expectedSchema.add("is_null", (DataType)BooleanType$.MODULE$, false);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2774));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2754));
        this.test("SPARK-34576: drop/add columns to a dataset of `DESCRIBE COLUMN`", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String tbl = new StringBuilder(3).append(this.catalogAndNamespace()).append("tbl").toString();
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tbl}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(29).append("CREATE TABLE ").append(tbl).append(" (c0 INT) USING ").append(this.v2Format()).toString());
                Dataset description = (Dataset)this.sql().apply((Object)new StringBuilder(18).append("DESCRIBE TABLE ").append(tbl).append(" c0").toString());
                Dataset noCommentDataset = description.drop("info_value");
                StructType expectedSchema = new StructType().add("info_name", (DataType)StringType$.MODULE$, false, new MetadataBuilder().putString("comment", "name of the column info").build());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(noCommentDataset.schema());
                StructType $org_scalatest_assert_macro_right = expectedSchema;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2790));
                Dataset isNullDataset = noCommentDataset.withColumn("is_null", noCommentDataset.apply("info_name").isNull());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(isNullDataset.schema());
                StructType $org_scalatest_assert_macro_right2 = expectedSchema.add("is_null", (DataType)BooleanType$.MODULE$, false);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2793));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2778));
        this.test("SPARK-34577: drop/add columns to a dataset of `DESCRIBE NAMESPACE`", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withNamespace((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ns"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CREATE NAMESPACE ns");
            Dataset description = (Dataset)this.sql().apply((Object)"DESCRIBE NAMESPACE ns");
            Dataset noCommentDataset = description.drop("info_name");
            StructType expectedSchema = new StructType().add("info_value", (DataType)StringType$.MODULE$, true, new MetadataBuilder().putString("comment", "value of the namespace info").build());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(noCommentDataset.schema());
            StructType $org_scalatest_assert_macro_right = expectedSchema;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2809));
            Dataset isNullDataset = noCommentDataset.withColumn("is_null", noCommentDataset.apply("info_value").isNull());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(isNullDataset.schema());
            StructType $org_scalatest_assert_macro_right2 = expectedSchema.add("is_null", (DataType)BooleanType$.MODULE$, false);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2812));
        }), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2797));
        this.test("SPARK-34923: do not propagate metadata columns through Project", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t1 = new StringBuilder(5).append(this.catalogAndNamespace()).append("table").toString();
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t1}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(80).append("CREATE TABLE ").append(t1).append(" (id bigint, data string) USING ").append(this.v2Format()).append(" ").append("PARTITIONED BY (bucket(4, id), id)").toString());
                this.sql().apply((Object)new StringBuilder(48).append("INSERT INTO ").append(t1).append(" VALUES (1, 'a'), (2, 'b'), (3, 'c')").toString());
                this.assertThrows((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(53).append("SELECT index, _partition from (SELECT id, data FROM ").append(t1).append(")").toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2823));
                this.assertThrows((Function0 & Serializable & scala.Serializable)() -> this.spark().table(t1).select("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"data"})).select("index", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_partition"})), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2826));
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2816));
        this.test("SPARK-34923: do not propagate metadata columns through View", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t1 = new StringBuilder(5).append(this.catalogAndNamespace()).append("table").toString();
            String view = "view";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t1}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{view}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(80).append("CREATE TABLE ").append(t1).append(" (id bigint, data string) USING ").append(this.v2Format()).append(" ").append("PARTITIONED BY (bucket(4, id), id)").toString());
                this.sql().apply((Object)new StringBuilder(48).append("INSERT INTO ").append(t1).append(" VALUES (1, 'a'), (2, 'b'), (3, 'c')").toString());
                this.sql().apply((Object)new StringBuilder(30).append("CACHE TABLE ").append(view).append(" AS SELECT * FROM ").append(t1).toString());
                this.assertThrows((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(30).append("SELECT index, _partition FROM ").append(view).toString()), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2842));
            }));
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2832));
        this.test("SPARK-34923: propagate metadata columns through Filter", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t1 = new StringBuilder(5).append(this.catalogAndNamespace()).append("table").toString();
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t1}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(80).append("CREATE TABLE ").append(t1).append(" (id bigint, data string) USING ").append(this.v2Format()).append(" ").append("PARTITIONED BY (bucket(4, id), id)").toString());
                this.sql().apply((Object)new StringBuilder(48).append("INSERT INTO ").append(t1).append(" VALUES (1, 'a'), (2, 'b'), (3, 'c')").toString());
                Dataset sqlQuery = this.spark().sql(new StringBuilder(53).append("SELECT id, data, index, _partition FROM ").append(t1).append(" WHERE id > 1").toString());
                Dataset dfQuery = this.spark().table(t1).where("id > 1").select("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"data", "index", "_partition"}));
                ((IterableLike)new .colon.colon((Object)sqlQuery, (List)new .colon.colon((Object)dfQuery, (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)query -> {
                    this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> query, (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "b", BoxesRunTime.boxToInteger((int)0), "0/2"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "c", BoxesRunTime.boxToInteger((int)0), "1/3"})), (List)Nil$.MODULE$))));
                    return BoxedUnit.UNIT;
                });
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2849));
        this.test("SPARK-34923: propagate metadata columns through Sort", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t1 = new StringBuilder(5).append(this.catalogAndNamespace()).append("table").toString();
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t1}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(80).append("CREATE TABLE ").append(t1).append(" (id bigint, data string) USING ").append(this.v2Format()).append(" ").append("PARTITIONED BY (bucket(4, id), id)").toString());
                this.sql().apply((Object)new StringBuilder(48).append("INSERT INTO ").append(t1).append(" VALUES (1, 'a'), (2, 'b'), (3, 'c')").toString());
                Dataset sqlQuery = this.spark().sql(new StringBuilder(52).append("SELECT id, data, index, _partition FROM ").append(t1).append(" ORDER BY id").toString());
                Dataset dfQuery = this.spark().table(t1).orderBy("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).select("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"data", "index", "_partition"}));
                ((IterableLike)new .colon.colon((Object)sqlQuery, (List)new .colon.colon((Object)dfQuery, (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)query -> {
                    this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> query, (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a", BoxesRunTime.boxToInteger((int)0), "3/1"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "b", BoxesRunTime.boxToInteger((int)0), "0/2"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "c", BoxesRunTime.boxToInteger((int)0), "1/3"})), (List)Nil$.MODULE$)))));
                    return BoxedUnit.UNIT;
                });
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2865));
        this.test("SPARK-34923: propagate metadata columns through RepartitionBy", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t1 = new StringBuilder(5).append(this.catalogAndNamespace()).append("table").toString();
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t1}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(80).append("CREATE TABLE ").append(t1).append(" (id bigint, data string) USING ").append(this.v2Format()).append(" ").append("PARTITIONED BY (bucket(4, id), id)").toString());
                this.sql().apply((Object)new StringBuilder(48).append("INSERT INTO ").append(t1).append(" VALUES (1, 'a'), (2, 'b'), (3, 'c')").toString());
                Dataset sqlQuery = this.spark().sql(new StringBuilder(75).append("SELECT /*+ REPARTITION_BY_RANGE(3, id) */ id, data, index, _partition FROM ").append(t1).toString());
                Dataset tbl = this.spark().table(t1);
                Dataset dfQuery = tbl.repartitionByRange(3, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{tbl.col("id")})).select("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"data", "index", "_partition"}));
                ((IterableLike)new .colon.colon((Object)sqlQuery, (List)new .colon.colon((Object)dfQuery, (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)query -> {
                    this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> query, (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a", BoxesRunTime.boxToInteger((int)0), "3/1"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "b", BoxesRunTime.boxToInteger((int)0), "0/2"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "c", BoxesRunTime.boxToInteger((int)0), "1/3"})), (List)Nil$.MODULE$)))));
                    return BoxedUnit.UNIT;
                });
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2881));
        this.test("SPARK-34923: propagate metadata columns through SubqueryAlias", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t1 = new StringBuilder(5).append(this.catalogAndNamespace()).append("table").toString();
            String sbq = "sbq";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t1}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(80).append("CREATE TABLE ").append(t1).append(" (id bigint, data string) USING ").append(this.v2Format()).append(" ").append("PARTITIONED BY (bucket(4, id), id)").toString());
                this.sql().apply((Object)new StringBuilder(48).append("INSERT INTO ").append(t1).append(" VALUES (1, 'a'), (2, 'b'), (3, 'c')").toString());
                Dataset sqlQuery = this.spark().sql(new StringBuilder(48).append("SELECT ").append(sbq).append(".id, ").append(sbq).append(".data, ").append(sbq).append(".index, ").append(sbq).append("._partition FROM ").append(t1).append(" as ").append(sbq).toString());
                Dataset dfQuery = this.spark().table(t1).as(sbq).select(new StringBuilder(3).append(sbq).append(".id").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(5).append(sbq).append(".data").toString(), new StringBuilder(6).append(sbq).append(".index").toString(), new StringBuilder(11).append(sbq).append("._partition").toString()}));
                ((IterableLike)new .colon.colon((Object)sqlQuery, (List)new .colon.colon((Object)dfQuery, (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)query -> {
                    this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> query, (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a", BoxesRunTime.boxToInteger((int)0), "3/1"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "b", BoxesRunTime.boxToInteger((int)0), "0/2"})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "c", BoxesRunTime.boxToInteger((int)0), "1/3"})), (List)Nil$.MODULE$)))));
                    return BoxedUnit.UNIT;
                });
            });
        }, new Position("DataSourceV2SQLSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2900));
    }
}

