/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sources;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.QueryTest;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.physical.HashPartitioning;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.datasources.BucketingUtils$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.BucketedWriteSuite$;
import org.apache.spark.sql.test.SQLTestData;
import org.apache.spark.sql.test.SQLTestData$internalImplicits$;
import org.apache.spark.sql.test.SQLTestUtils;
import org.apache.spark.sql.test.SQLTestUtilsBase;
import org.apache.spark.sql.test.SQLTestUtilsBase$testImplicits$;
import org.apache.spark.sql.types.DataType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.scalatest.concurrent.AbstractPatienceConfiguration;
import org.scalatest.concurrent.AbstractPatienceConfiguration$PatienceConfig$;
import org.scalatest.concurrent.Eventually;
import org.scalatest.concurrent.PatienceConfiguration;
import org.scalatest.concurrent.ScaledTimeSpans;
import org.scalatest.enablers.Retrying;
import org.scalatest.funsuite.AnyFunSuiteLike;
import org.scalatest.time.Span;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001-4Qa\u0002\u0005\u0002\u0002MAQA\b\u0001\u0005\u0002}AQA\t\u0001\u0007\u0012\rB\u0001B\u000f\u0001\t\u0006\u0004%Ia\u000f\u0005\u0006\u0005\u0002!\ta\u0011\u0005\u0006\u0019\u0002!I!\u0014\u0005\b?\u0002\t\n\u0011\"\u0003a\u0005I\u0011UoY6fi\u0016$wK]5uKN+\u0018\u000e^3\u000b\u0005%Q\u0011aB:pkJ\u001cWm\u001d\u0006\u0003\u00171\t1a]9m\u0015\tia\"A\u0003ta\u0006\u00148N\u0003\u0002\u0010!\u00051\u0011\r]1dQ\u0016T\u0011!E\u0001\u0004_J<7\u0001A\n\u0004\u0001QA\u0002CA\u000b\u0017\u001b\u0005Q\u0011BA\f\u000b\u0005%\tV/\u001a:z)\u0016\u001cH\u000f\u0005\u0002\u001a95\t!D\u0003\u0002\u001c\u0015\u0005!A/Z:u\u0013\ti\"D\u0001\u0007T#2#Vm\u001d;Vi&d7/\u0001\u0004=S:LGO\u0010\u000b\u0002AA\u0011\u0011\u0005A\u0007\u0002\u0011\u0005\tb-\u001b7f\r>\u0014X.\u0019;t)>$Vm\u001d;\u0016\u0003\u0011\u00022!J\u00183\u001d\t1CF\u0004\u0002(U5\t\u0001F\u0003\u0002*%\u00051AH]8pizJ\u0011aK\u0001\u0006g\u000e\fG.Y\u0005\u0003[9\nq\u0001]1dW\u0006<WMC\u0001,\u0013\t\u0001\u0014GA\u0002TKFT!!\f\u0018\u0011\u0005M:dB\u0001\u001b6!\t9c&\u0003\u00027]\u00051\u0001K]3eK\u001aL!\u0001O\u001d\u0003\rM#(/\u001b8h\u0015\t1d&\u0001\u0002eMV\tA\b\u0005\u0002>\u007f9\u0011QCP\u0005\u0003[)I!\u0001Q!\u0003\u0013\u0011\u000bG/\u0019$sC6,'BA\u0017\u000b\u0003!!\u0018M\u00197f\t&\u0014X#\u0001#\u0011\u0005\u0015SU\"\u0001$\u000b\u0005\u001dC\u0015AA5p\u0015\u0005I\u0015\u0001\u00026bm\u0006L!a\u0013$\u0003\t\u0019KG.Z\u0001\u000ei\u0016\u001cHOQ;dW\u0016$\u0018N\\4\u0015\r9\u0013FKV.^!\ty\u0005+D\u0001/\u0013\t\tfF\u0001\u0003V]&$\b\"B*\u0006\u0001\u0004!\u0015a\u00023bi\u0006$\u0015N\u001d\u0005\u0006+\u0016\u0001\rAM\u0001\u0007g>,(oY3\t\u000b]+\u0001\u0019\u0001-\u0002\u00159,XNQ;dW\u0016$8\u000f\u0005\u0002P3&\u0011!L\f\u0002\u0004\u0013:$\b\"\u0002/\u0006\u0001\u0004!\u0013A\u00032vG.,GoQ8mg\"9a,\u0002I\u0001\u0002\u0004!\u0013\u0001C:peR\u001cu\u000e\\:\u0002/Q,7\u000f\u001e\"vG.,G/\u001b8hI\u0011,g-Y;mi\u0012*T#A1+\u0005\u0011\u00127&A2\u0011\u0005\u0011LW\"A3\u000b\u0005\u0019<\u0017!C;oG\",7m[3e\u0015\tAg&\u0001\u0006b]:|G/\u0019;j_:L!A[3\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public abstract class BucketedWriteSuite
extends QueryTest
implements SQLTestUtils {
    private Dataset<Row> df;
    private boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    private Function1<String, Dataset<Row>> sql;
    private volatile SQLTestUtilsBase$testImplicits$ testImplicits$module;
    private volatile SQLTestData$internalImplicits$ internalImplicits$module;
    private Dataset<Row> emptyTestData;
    private Dataset<Row> testData;
    private Dataset<Row> testData2;
    private Dataset<Row> testData3;
    private Dataset<Row> negativeData;
    private Dataset<Row> largeAndSmallInts;
    private Dataset<Row> decimalData;
    private Dataset<Row> binaryData;
    private Dataset<Row> upperCaseData;
    private Dataset<Row> lowerCaseData;
    private Dataset<Row> lowerCaseDataWithDuplicates;
    private RDD<SQLTestData.ArrayData> arrayData;
    private RDD<SQLTestData.MapData> mapData;
    private RDD<SQLTestData.IntervalData> calendarIntervalData;
    private RDD<SQLTestData.StringData> repeatedData;
    private RDD<SQLTestData.StringData> nullableRepeatedData;
    private Dataset<Row> nullInts;
    private Dataset<Row> allNulls;
    private Dataset<Row> nullStrings;
    private Dataset<Row> tableName;
    private RDD<String> unparsedStrings;
    private RDD<SQLTestData.IntField> withEmptyParts;
    private Dataset<Row> person;
    private Dataset<Row> salary;
    private Dataset<Row> complexData;
    private Dataset<Row> courseSales;
    private Dataset<Row> trainingSales;
    private Dataset<Row> intervalData;
    private final AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    private volatile AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig$module;
    private volatile int bitmap$0;

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$withTempDir(Function1 f) {
        super.withTempDir(f);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$test(String testName, Seq testTags, Function0 testFun, Position pos) {
        AnyFunSuiteLike.test$((AnyFunSuiteLike)this, (String)testName, (Seq)testTags, (Function0)testFun, (Position)pos);
    }

    @Override
    public void beforeAll() {
        SQLTestUtils.beforeAll$(this);
    }

    @Override
    public void withTempDir(Function1<File, BoxedUnit> f) {
        SQLTestUtils.withTempDir$(this, f);
    }

    @Override
    public void testWithWholeStageCodegenOnAndOff(String testName, Function1<String, BoxedUnit> f) {
        SQLTestUtils.testWithWholeStageCodegenOnAndOff$(this, testName, f);
    }

    @Override
    public void setupTestData() {
        SQLTestUtils.setupTestData$(this);
    }

    @Override
    public void testQuietly(String name, Function0<BoxedUnit> f) {
        SQLTestUtils.testQuietly$(this, name, f);
    }

    @Override
    public void test(String testName, Seq<Tag> testTags, Function0<Object> testFun, Position pos) {
        SQLTestUtils.test$(this, testName, testTags, testFun, pos);
    }

    @Override
    public void testWithUninterruptibleThread(String name, boolean quietly, Function0<BoxedUnit> body) {
        SQLTestUtils.testWithUninterruptibleThread$(this, name, quietly, body);
    }

    @Override
    public boolean testWithUninterruptibleThread$default$2() {
        return SQLTestUtils.testWithUninterruptibleThread$default$2$(this);
    }

    @Override
    public void withResourceTempPath(String resourcePath, Function1<File, BoxedUnit> f) {
        SQLTestUtils.withResourceTempPath$(this, resourcePath, f);
    }

    @Override
    public void waitForTasksToFinish() {
        SQLTestUtils.waitForTasksToFinish$(this);
    }

    @Override
    public void withTempPaths(int numPaths, Function1<Seq<File>, BoxedUnit> f) {
        SQLTestUtils.withTempPaths$(this, numPaths, f);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtilsBase$$super$withSQLConf(Seq pairs, Function0 f) {
        SQLHelper.withSQLConf$((SQLHelper)this, (Seq)pairs, (Function0)f);
    }

    @Override
    public SparkContext sparkContext() {
        return SQLTestUtilsBase.sparkContext$(this);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withUserDefinedFunction(Seq<Tuple2<String, Object>> functions2, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withUserDefinedFunction$(this, functions2, f);
    }

    @Override
    public void withTempView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withTempView$(this, viewNames, f);
    }

    @Override
    public void withGlobalTempView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withGlobalTempView$(this, viewNames, f);
    }

    @Override
    public void withTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withTable$(this, tableNames, f);
    }

    @Override
    public void withView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withView$(this, viewNames, f);
    }

    @Override
    public void withCache(Seq<String> cacheNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withCache$(this, cacheNames, f);
    }

    @Override
    public void uncacheTable(String tableName) {
        SQLTestUtilsBase.uncacheTable$(this, tableName);
    }

    @Override
    public void withTempDatabase(Function1<String, BoxedUnit> f) {
        SQLTestUtilsBase.withTempDatabase$(this, f);
    }

    @Override
    public void withDatabase(Seq<String> dbNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withDatabase$(this, dbNames, f);
    }

    @Override
    public void withNamespace(Seq<String> namespaces, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withNamespace$(this, namespaces, f);
    }

    @Override
    public void withLocale(String language, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withLocale$(this, language, f);
    }

    @Override
    public void activateDatabase(String db, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.activateDatabase$(this, db, f);
    }

    @Override
    public Dataset<Row> stripSparkFilter(Dataset<Row> df) {
        return SQLTestUtilsBase.stripSparkFilter$(this, df);
    }

    @Override
    public Dataset<Row> logicalPlanToSparkQuery(LogicalPlan plan) {
        return SQLTestUtilsBase.logicalPlanToSparkQuery$(this, plan);
    }

    @Override
    public URI makeQualifiedPath(String path) {
        return SQLTestUtilsBase.makeQualifiedPath$(this, path);
    }

    @Override
    public String testFile(String fileName) {
        return SQLTestUtilsBase.testFile$(this, fileName);
    }

    @Override
    public long getLocalDirSize(File file) {
        return SQLTestUtilsBase.getLocalDirSize$(this, file);
    }

    @Override
    public void loadTestData() {
        SQLTestData.loadTestData$(this);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, PatienceConfiguration.Interval interval, Function0<T> fun, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, (PatienceConfiguration.Interval)interval, fun, retrying, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Interval interval, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Interval)interval, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public <T> T eventually(Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public AbstractPatienceConfiguration.PatienceConfig patienceConfig() {
        return PatienceConfiguration.patienceConfig$((PatienceConfiguration)this);
    }

    public PatienceConfiguration.Timeout timeout(Span value) {
        return PatienceConfiguration.timeout$((PatienceConfiguration)this, (Span)value);
    }

    public PatienceConfiguration.Interval interval(Span value) {
        return PatienceConfiguration.interval$((PatienceConfiguration)this, (Span)value);
    }

    public final Span scaled(Span span) {
        return ScaledTimeSpans.scaled$((ScaledTimeSpans)this, (Span)span);
    }

    public double spanScaleFactor() {
        return ScaledTimeSpans.spanScaleFactor$((ScaledTimeSpans)this);
    }

    @Override
    public boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests() {
        return this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    }

    @Override
    public void org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests_$eq(boolean x$1) {
        this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests = x$1;
    }

    private Function1<String, Dataset<Row>> sql$lzycompute() {
        BucketedWriteSuite bucketedWriteSuite = this;
        synchronized (bucketedWriteSuite) {
            if ((this.bitmap$0 & 2) == 0) {
                this.sql = SQLTestUtilsBase.sql$(this);
                this.bitmap$0 |= 2;
            }
        }
        return this.sql;
    }

    @Override
    public Function1<String, Dataset<Row>> sql() {
        return (this.bitmap$0 & 2) == 0 ? this.sql$lzycompute() : this.sql;
    }

    @Override
    public SQLTestUtilsBase$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public SQLTestData$internalImplicits$ org$apache$spark$sql$test$SQLTestData$$internalImplicits() {
        if (this.internalImplicits$module == null) {
            this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute$1();
        }
        return this.internalImplicits$module;
    }

    private Dataset<Row> emptyTestData$lzycompute() {
        BucketedWriteSuite bucketedWriteSuite = this;
        synchronized (bucketedWriteSuite) {
            if ((this.bitmap$0 & 4) == 0) {
                this.emptyTestData = SQLTestData.emptyTestData$(this);
                this.bitmap$0 |= 4;
            }
        }
        return this.emptyTestData;
    }

    @Override
    public Dataset<Row> emptyTestData() {
        return (this.bitmap$0 & 4) == 0 ? this.emptyTestData$lzycompute() : this.emptyTestData;
    }

    private Dataset<Row> testData$lzycompute() {
        BucketedWriteSuite bucketedWriteSuite = this;
        synchronized (bucketedWriteSuite) {
            if ((this.bitmap$0 & 8) == 0) {
                this.testData = SQLTestData.testData$(this);
                this.bitmap$0 |= 8;
            }
        }
        return this.testData;
    }

    @Override
    public Dataset<Row> testData() {
        return (this.bitmap$0 & 8) == 0 ? this.testData$lzycompute() : this.testData;
    }

    private Dataset<Row> testData2$lzycompute() {
        BucketedWriteSuite bucketedWriteSuite = this;
        synchronized (bucketedWriteSuite) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.testData2 = SQLTestData.testData2$(this);
                this.bitmap$0 |= 0x10;
            }
        }
        return this.testData2;
    }

    @Override
    public Dataset<Row> testData2() {
        return (this.bitmap$0 & 0x10) == 0 ? this.testData2$lzycompute() : this.testData2;
    }

    private Dataset<Row> testData3$lzycompute() {
        BucketedWriteSuite bucketedWriteSuite = this;
        synchronized (bucketedWriteSuite) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.testData3 = SQLTestData.testData3$(this);
                this.bitmap$0 |= 0x20;
            }
        }
        return this.testData3;
    }

    @Override
    public Dataset<Row> testData3() {
        return (this.bitmap$0 & 0x20) == 0 ? this.testData3$lzycompute() : this.testData3;
    }

    private Dataset<Row> negativeData$lzycompute() {
        BucketedWriteSuite bucketedWriteSuite = this;
        synchronized (bucketedWriteSuite) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.negativeData = SQLTestData.negativeData$(this);
                this.bitmap$0 |= 0x40;
            }
        }
        return this.negativeData;
    }

    @Override
    public Dataset<Row> negativeData() {
        return (this.bitmap$0 & 0x40) == 0 ? this.negativeData$lzycompute() : this.negativeData;
    }

    private Dataset<Row> largeAndSmallInts$lzycompute() {
        BucketedWriteSuite bucketedWriteSuite = this;
        synchronized (bucketedWriteSuite) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.largeAndSmallInts = SQLTestData.largeAndSmallInts$(this);
                this.bitmap$0 |= 0x80;
            }
        }
        return this.largeAndSmallInts;
    }

    @Override
    public Dataset<Row> largeAndSmallInts() {
        return (this.bitmap$0 & 0x80) == 0 ? this.largeAndSmallInts$lzycompute() : this.largeAndSmallInts;
    }

    private Dataset<Row> decimalData$lzycompute() {
        BucketedWriteSuite bucketedWriteSuite = this;
        synchronized (bucketedWriteSuite) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.decimalData = SQLTestData.decimalData$(this);
                this.bitmap$0 |= 0x100;
            }
        }
        return this.decimalData;
    }

    @Override
    public Dataset<Row> decimalData() {
        return (this.bitmap$0 & 0x100) == 0 ? this.decimalData$lzycompute() : this.decimalData;
    }

    private Dataset<Row> binaryData$lzycompute() {
        BucketedWriteSuite bucketedWriteSuite = this;
        synchronized (bucketedWriteSuite) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.binaryData = SQLTestData.binaryData$(this);
                this.bitmap$0 |= 0x200;
            }
        }
        return this.binaryData;
    }

    @Override
    public Dataset<Row> binaryData() {
        return (this.bitmap$0 & 0x200) == 0 ? this.binaryData$lzycompute() : this.binaryData;
    }

    private Dataset<Row> upperCaseData$lzycompute() {
        BucketedWriteSuite bucketedWriteSuite = this;
        synchronized (bucketedWriteSuite) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.upperCaseData = SQLTestData.upperCaseData$(this);
                this.bitmap$0 |= 0x400;
            }
        }
        return this.upperCaseData;
    }

    @Override
    public Dataset<Row> upperCaseData() {
        return (this.bitmap$0 & 0x400) == 0 ? this.upperCaseData$lzycompute() : this.upperCaseData;
    }

    private Dataset<Row> lowerCaseData$lzycompute() {
        BucketedWriteSuite bucketedWriteSuite = this;
        synchronized (bucketedWriteSuite) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.lowerCaseData = SQLTestData.lowerCaseData$(this);
                this.bitmap$0 |= 0x800;
            }
        }
        return this.lowerCaseData;
    }

    @Override
    public Dataset<Row> lowerCaseData() {
        return (this.bitmap$0 & 0x800) == 0 ? this.lowerCaseData$lzycompute() : this.lowerCaseData;
    }

    private Dataset<Row> lowerCaseDataWithDuplicates$lzycompute() {
        BucketedWriteSuite bucketedWriteSuite = this;
        synchronized (bucketedWriteSuite) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.lowerCaseDataWithDuplicates = SQLTestData.lowerCaseDataWithDuplicates$(this);
                this.bitmap$0 |= 0x1000;
            }
        }
        return this.lowerCaseDataWithDuplicates;
    }

    @Override
    public Dataset<Row> lowerCaseDataWithDuplicates() {
        return (this.bitmap$0 & 0x1000) == 0 ? this.lowerCaseDataWithDuplicates$lzycompute() : this.lowerCaseDataWithDuplicates;
    }

    private RDD<SQLTestData.ArrayData> arrayData$lzycompute() {
        BucketedWriteSuite bucketedWriteSuite = this;
        synchronized (bucketedWriteSuite) {
            if ((this.bitmap$0 & 0x2000) == 0) {
                this.arrayData = SQLTestData.arrayData$(this);
                this.bitmap$0 |= 0x2000;
            }
        }
        return this.arrayData;
    }

    @Override
    public RDD<SQLTestData.ArrayData> arrayData() {
        return (this.bitmap$0 & 0x2000) == 0 ? this.arrayData$lzycompute() : this.arrayData;
    }

    private RDD<SQLTestData.MapData> mapData$lzycompute() {
        BucketedWriteSuite bucketedWriteSuite = this;
        synchronized (bucketedWriteSuite) {
            if ((this.bitmap$0 & 0x4000) == 0) {
                this.mapData = SQLTestData.mapData$(this);
                this.bitmap$0 |= 0x4000;
            }
        }
        return this.mapData;
    }

    @Override
    public RDD<SQLTestData.MapData> mapData() {
        return (this.bitmap$0 & 0x4000) == 0 ? this.mapData$lzycompute() : this.mapData;
    }

    private RDD<SQLTestData.IntervalData> calendarIntervalData$lzycompute() {
        BucketedWriteSuite bucketedWriteSuite = this;
        synchronized (bucketedWriteSuite) {
            if ((this.bitmap$0 & 0x8000) == 0) {
                this.calendarIntervalData = SQLTestData.calendarIntervalData$(this);
                this.bitmap$0 |= 0x8000;
            }
        }
        return this.calendarIntervalData;
    }

    @Override
    public RDD<SQLTestData.IntervalData> calendarIntervalData() {
        return (this.bitmap$0 & 0x8000) == 0 ? this.calendarIntervalData$lzycompute() : this.calendarIntervalData;
    }

    private RDD<SQLTestData.StringData> repeatedData$lzycompute() {
        BucketedWriteSuite bucketedWriteSuite = this;
        synchronized (bucketedWriteSuite) {
            if ((this.bitmap$0 & 0x10000) == 0) {
                this.repeatedData = SQLTestData.repeatedData$(this);
                this.bitmap$0 |= 0x10000;
            }
        }
        return this.repeatedData;
    }

    @Override
    public RDD<SQLTestData.StringData> repeatedData() {
        return (this.bitmap$0 & 0x10000) == 0 ? this.repeatedData$lzycompute() : this.repeatedData;
    }

    private RDD<SQLTestData.StringData> nullableRepeatedData$lzycompute() {
        BucketedWriteSuite bucketedWriteSuite = this;
        synchronized (bucketedWriteSuite) {
            if ((this.bitmap$0 & 0x20000) == 0) {
                this.nullableRepeatedData = SQLTestData.nullableRepeatedData$(this);
                this.bitmap$0 |= 0x20000;
            }
        }
        return this.nullableRepeatedData;
    }

    @Override
    public RDD<SQLTestData.StringData> nullableRepeatedData() {
        return (this.bitmap$0 & 0x20000) == 0 ? this.nullableRepeatedData$lzycompute() : this.nullableRepeatedData;
    }

    private Dataset<Row> nullInts$lzycompute() {
        BucketedWriteSuite bucketedWriteSuite = this;
        synchronized (bucketedWriteSuite) {
            if ((this.bitmap$0 & 0x40000) == 0) {
                this.nullInts = SQLTestData.nullInts$(this);
                this.bitmap$0 |= 0x40000;
            }
        }
        return this.nullInts;
    }

    @Override
    public Dataset<Row> nullInts() {
        return (this.bitmap$0 & 0x40000) == 0 ? this.nullInts$lzycompute() : this.nullInts;
    }

    private Dataset<Row> allNulls$lzycompute() {
        BucketedWriteSuite bucketedWriteSuite = this;
        synchronized (bucketedWriteSuite) {
            if ((this.bitmap$0 & 0x80000) == 0) {
                this.allNulls = SQLTestData.allNulls$(this);
                this.bitmap$0 |= 0x80000;
            }
        }
        return this.allNulls;
    }

    @Override
    public Dataset<Row> allNulls() {
        return (this.bitmap$0 & 0x80000) == 0 ? this.allNulls$lzycompute() : this.allNulls;
    }

    private Dataset<Row> nullStrings$lzycompute() {
        BucketedWriteSuite bucketedWriteSuite = this;
        synchronized (bucketedWriteSuite) {
            if ((this.bitmap$0 & 0x100000) == 0) {
                this.nullStrings = SQLTestData.nullStrings$(this);
                this.bitmap$0 |= 0x100000;
            }
        }
        return this.nullStrings;
    }

    @Override
    public Dataset<Row> nullStrings() {
        return (this.bitmap$0 & 0x100000) == 0 ? this.nullStrings$lzycompute() : this.nullStrings;
    }

    private Dataset<Row> tableName$lzycompute() {
        BucketedWriteSuite bucketedWriteSuite = this;
        synchronized (bucketedWriteSuite) {
            if ((this.bitmap$0 & 0x200000) == 0) {
                this.tableName = SQLTestData.tableName$(this);
                this.bitmap$0 |= 0x200000;
            }
        }
        return this.tableName;
    }

    @Override
    public Dataset<Row> tableName() {
        return (this.bitmap$0 & 0x200000) == 0 ? this.tableName$lzycompute() : this.tableName;
    }

    private RDD<String> unparsedStrings$lzycompute() {
        BucketedWriteSuite bucketedWriteSuite = this;
        synchronized (bucketedWriteSuite) {
            if ((this.bitmap$0 & 0x400000) == 0) {
                this.unparsedStrings = SQLTestData.unparsedStrings$(this);
                this.bitmap$0 |= 0x400000;
            }
        }
        return this.unparsedStrings;
    }

    @Override
    public RDD<String> unparsedStrings() {
        return (this.bitmap$0 & 0x400000) == 0 ? this.unparsedStrings$lzycompute() : this.unparsedStrings;
    }

    private RDD<SQLTestData.IntField> withEmptyParts$lzycompute() {
        BucketedWriteSuite bucketedWriteSuite = this;
        synchronized (bucketedWriteSuite) {
            if ((this.bitmap$0 & 0x800000) == 0) {
                this.withEmptyParts = SQLTestData.withEmptyParts$(this);
                this.bitmap$0 |= 0x800000;
            }
        }
        return this.withEmptyParts;
    }

    @Override
    public RDD<SQLTestData.IntField> withEmptyParts() {
        return (this.bitmap$0 & 0x800000) == 0 ? this.withEmptyParts$lzycompute() : this.withEmptyParts;
    }

    private Dataset<Row> person$lzycompute() {
        BucketedWriteSuite bucketedWriteSuite = this;
        synchronized (bucketedWriteSuite) {
            if ((this.bitmap$0 & 0x1000000) == 0) {
                this.person = SQLTestData.person$(this);
                this.bitmap$0 |= 0x1000000;
            }
        }
        return this.person;
    }

    @Override
    public Dataset<Row> person() {
        return (this.bitmap$0 & 0x1000000) == 0 ? this.person$lzycompute() : this.person;
    }

    private Dataset<Row> salary$lzycompute() {
        BucketedWriteSuite bucketedWriteSuite = this;
        synchronized (bucketedWriteSuite) {
            if ((this.bitmap$0 & 0x2000000) == 0) {
                this.salary = SQLTestData.salary$(this);
                this.bitmap$0 |= 0x2000000;
            }
        }
        return this.salary;
    }

    @Override
    public Dataset<Row> salary() {
        return (this.bitmap$0 & 0x2000000) == 0 ? this.salary$lzycompute() : this.salary;
    }

    private Dataset<Row> complexData$lzycompute() {
        BucketedWriteSuite bucketedWriteSuite = this;
        synchronized (bucketedWriteSuite) {
            if ((this.bitmap$0 & 0x4000000) == 0) {
                this.complexData = SQLTestData.complexData$(this);
                this.bitmap$0 |= 0x4000000;
            }
        }
        return this.complexData;
    }

    @Override
    public Dataset<Row> complexData() {
        return (this.bitmap$0 & 0x4000000) == 0 ? this.complexData$lzycompute() : this.complexData;
    }

    private Dataset<Row> courseSales$lzycompute() {
        BucketedWriteSuite bucketedWriteSuite = this;
        synchronized (bucketedWriteSuite) {
            if ((this.bitmap$0 & 0x8000000) == 0) {
                this.courseSales = SQLTestData.courseSales$(this);
                this.bitmap$0 |= 0x8000000;
            }
        }
        return this.courseSales;
    }

    @Override
    public Dataset<Row> courseSales() {
        return (this.bitmap$0 & 0x8000000) == 0 ? this.courseSales$lzycompute() : this.courseSales;
    }

    private Dataset<Row> trainingSales$lzycompute() {
        BucketedWriteSuite bucketedWriteSuite = this;
        synchronized (bucketedWriteSuite) {
            if ((this.bitmap$0 & 0x10000000) == 0) {
                this.trainingSales = SQLTestData.trainingSales$(this);
                this.bitmap$0 |= 0x10000000;
            }
        }
        return this.trainingSales;
    }

    @Override
    public Dataset<Row> trainingSales() {
        return (this.bitmap$0 & 0x10000000) == 0 ? this.trainingSales$lzycompute() : this.trainingSales;
    }

    private Dataset<Row> intervalData$lzycompute() {
        BucketedWriteSuite bucketedWriteSuite = this;
        synchronized (bucketedWriteSuite) {
            if ((this.bitmap$0 & 0x20000000) == 0) {
                this.intervalData = SQLTestData.intervalData$(this);
                this.bitmap$0 |= 0x20000000;
            }
        }
        return this.intervalData;
    }

    @Override
    public Dataset<Row> intervalData() {
        return (this.bitmap$0 & 0x20000000) == 0 ? this.intervalData$lzycompute() : this.intervalData;
    }

    public AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig() {
        return this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    }

    public final void org$scalatest$concurrent$PatienceConfiguration$_setter_$org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig_$eq(AbstractPatienceConfiguration.PatienceConfig x$1) {
        this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig = x$1;
    }

    public AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig() {
        if (this.PatienceConfig$module == null) {
            this.PatienceConfig$lzycompute$1();
        }
        return this.PatienceConfig$module;
    }

    public abstract Seq<String> fileFormatsToTest();

    private Dataset<Row> df$lzycompute() {
        BucketedWriteSuite bucketedWriteSuite = this;
        synchronized (bucketedWriteSuite) {
            if ((this.bitmap$0 & 1) == 0) {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(BucketedWriteSuite.class.getClassLoader());
                public final class Org_apache_spark_sql_sources_BucketedWriteSuite$$typecreator6$2
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
                    }

                    public Org_apache_spark_sql_sources_BucketedWriteSuite$$typecreator6$2(BucketedWriteSuite $outer) {
                    }
                }
                this.df = this.testImplicits().localSeqToDatasetHolder((Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).map((Function1 & Serializable & scala.Serializable)i -> BucketedWriteSuite.$anonfun$df$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom()), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_sources_BucketedWriteSuite$$typecreator6$2(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"i", "j", "k"}));
                this.bitmap$0 |= 1;
            }
        }
        return this.df;
    }

    private Dataset<Row> df() {
        return (this.bitmap$0 & 1) == 0 ? this.df$lzycompute() : this.df;
    }

    public File tableDir() {
        TableIdentifier identifier = this.spark().sessionState().sqlParser().parseTableIdentifier("bucketed_table");
        return new File(this.spark().sessionState().catalog().defaultTablePath(identifier));
    }

    private void testBucketing(File dataDir, String source, int numBuckets, Seq<String> bucketCols, Seq<String> sortCols) {
        File[] allBucketFiles = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataDir.listFiles())).filterNot((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)BucketedWriteSuite.$anonfun$testBucketing$1(f)));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allBucketFiles)).foreach((Function1 & Serializable & scala.Serializable)bucketFile -> {
            BucketedWriteSuite.$anonfun$testBucketing$2(this, bucketCols, sortCols, source, numBuckets, bucketFile);
            return BoxedUnit.UNIT;
        });
    }

    private Seq<String> testBucketing$default$5() {
        return Nil$.MODULE$;
    }

    private final void testImplicits$lzycompute$1() {
        BucketedWriteSuite bucketedWriteSuite = this;
        synchronized (bucketedWriteSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new SQLTestUtilsBase$testImplicits$(this);
            }
        }
    }

    private final void org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute$1() {
        BucketedWriteSuite bucketedWriteSuite = this;
        synchronized (bucketedWriteSuite) {
            if (this.internalImplicits$module == null) {
                this.internalImplicits$module = new SQLTestData$internalImplicits$(this);
            }
        }
    }

    private final void PatienceConfig$lzycompute$1() {
        BucketedWriteSuite bucketedWriteSuite = this;
        synchronized (bucketedWriteSuite) {
            if (this.PatienceConfig$module == null) {
                this.PatienceConfig$module = new AbstractPatienceConfiguration$PatienceConfig$((AbstractPatienceConfiguration)this);
            }
        }
    }

    public static final /* synthetic */ Assertion $anonfun$new$4(BucketedWriteSuite $this, Dataset df$2, int numBuckets) {
        AnalysisException e = (AnalysisException)((Object)$this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> df$2.write().bucketBy(numBuckets, "i", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).saveAsTable("tt"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("BucketedWriteSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56)));
        String $org_scalatest_assert_macro_left = e.getMessage();
        String $org_scalatest_assert_macro_right = "Number of buckets should be greater than 0 but less than";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BucketedWriteSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
    }

    public static final /* synthetic */ Tuple3 $anonfun$df$1(int i) {
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)(i % 5)), (Object)BoxesRunTime.boxToInteger((int)(i % 13)), (Object)Integer.toString(i));
    }

    public static final /* synthetic */ boolean $anonfun$testBucketing$1(File f) {
        return f.getName().startsWith(".") || f.getName().startsWith("_");
    }

    public static final /* synthetic */ void $anonfun$testBucketing$2(BucketedWriteSuite $this, Seq bucketCols$1, Seq sortCols$1, String source$1, int numBuckets$3, File bucketFile) {
        int bucketId = BoxesRunTime.unboxToInt((Object)BucketingUtils$.MODULE$.getBucketId(bucketFile.getName()).getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.fail("Unable to find the related bucket files.", new Position("BucketedWriteSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162))));
        Seq selectedColumns = (Seq)((SeqLike)bucketCols$1.$plus$plus((GenTraversableOnce)sortCols$1, Seq$.MODULE$.canBuildFrom())).distinct();
        Seq types = (Seq)$this.df().select((Seq)selectedColumns.map((Function1 & Serializable & scala.Serializable)colName -> functions$.MODULE$.col(colName), Seq$.MODULE$.canBuildFrom())).schema().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.dataType(), Seq$.MODULE$.canBuildFrom());
        Seq columns = (Seq)((TraversableLike)selectedColumns.zip((GenIterable)types, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String colName = (String)tuple2._1();
            DataType dt = (DataType)tuple2._2();
            Column column = functions$.MODULE$.col(colName).cast(dt);
            return column;
        }, Seq$.MODULE$.canBuildFrom());
        Dataset readBack = $this.spark().read().format(source$1).load(bucketFile.getAbsolutePath()).select(columns);
        if (sortCols$1.nonEmpty()) {
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> readBack.sort((Seq)sortCols$1.map((Function1 & Serializable & scala.Serializable)colName -> functions$.MODULE$.col(colName), Seq$.MODULE$.canBuildFrom())), (Seq<Row>)Predef$.MODULE$.wrapRefArray((Object[])readBack.collect()));
        }
        QueryExecution qe = readBack.select((Seq)bucketCols$1.map((Function1 & Serializable & scala.Serializable)colName -> functions$.MODULE$.col(colName), Seq$.MODULE$.canBuildFrom())).queryExecution();
        InternalRow[] rows = (InternalRow[])qe.toRdd().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.copy(), ClassTag$.MODULE$.apply(InternalRow.class)).collect();
        Expression expression = new HashPartitioning(qe.analyzed().output(), numBuckets$3).partitionIdExpression();
        UnsafeProjection getBucketId = UnsafeProjection$.MODULE$.create((Seq)Nil$.MODULE$.$colon$colon((Object)expression), qe.analyzed().output());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rows)).foreach((Function1 & Serializable & scala.Serializable)row -> {
            int actualBucketId;
            int $org_scalatest_assert_macro_left = actualBucketId = getBucketId.apply(row).getInt(0);
            int $org_scalatest_assert_macro_right = bucketId;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BucketedWriteSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
        });
    }

    public BucketedWriteSuite() {
        ScaledTimeSpans.$init$((ScaledTimeSpans)this);
        AbstractPatienceConfiguration.$init$((AbstractPatienceConfiguration)this);
        PatienceConfiguration.$init$((PatienceConfiguration)this);
        Eventually.$init$((Eventually)this);
        SQLTestData.$init$(this);
        SQLTestUtilsBase.$init$(this);
        SQLTestUtils.$init$(this);
        this.test("bucketed by non-existing column", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(BucketedWriteSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_sources_BucketedWriteSuite$$typecreator6$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_sources_BucketedWriteSuite$$typecreator6$1(BucketedWriteSuite $outer) {
                }
            }
            Dataset df = this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"a"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"b"), (List)Nil$.MODULE$)), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_sources_BucketedWriteSuite$$typecreator6$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"i", "j"}));
            return (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> df.write().bucketBy(2, "k", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).saveAsTable("tt"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("BucketedWriteSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49))));
        }, new Position("BucketedWriteSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
        this.test("numBuckets be greater than 0 but less/eq than default bucketing.maxBuckets (100000)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(BucketedWriteSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_sources_BucketedWriteSuite$$typecreator16$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_sources_BucketedWriteSuite$$typecreator16$1(BucketedWriteSuite $outer) {
                }
            }
            Dataset df = this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"a"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"b"), (List)Nil$.MODULE$)), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_sources_BucketedWriteSuite$$typecreator16$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"i", "j"}));
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{-1, 0, 100001}))).foreach((Function1 & Serializable & scala.Serializable)numBuckets -> BucketedWriteSuite.$anonfun$new$4(this, df, BoxesRunTime.unboxToInt((Object)numBuckets)));
        }, new Position("BucketedWriteSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
        this.test("numBuckets be greater than 0 but less/eq than overridden bucketing.maxBuckets (200000)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int maxNrBuckets = 200000;
            SessionCatalog catalog = this.spark().sessionState().catalog();
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.BUCKETING_MAX_BUCKETS().key()), (Object)Integer.toString(maxNrBuckets))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100001, maxNrBuckets}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)numBuckets -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    this.df().write().bucketBy(numBuckets, "i", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).saveAsTable("t");
                    CatalogTable table = catalog.getTableMetadata(TableIdentifier$.MODULE$.apply("t"));
                    Option $org_scalatest_assert_macro_left = table.bucketSpec();
                    Option $org_scalatest_assert_macro_right = Option$.MODULE$.apply((Object)new BucketSpec(numBuckets, (Seq)new .colon.colon((Object)"i", (List)Nil$.MODULE$), (Seq)Nil$.MODULE$));
                    Option option = $org_scalatest_assert_macro_left;
                    Option option2 = $org_scalatest_assert_macro_right;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(option2) : option2 != null), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BucketedWriteSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
                }));
                this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    AnalysisException e = (AnalysisException)((Object)((Object)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.df().write().bucketBy(maxNrBuckets + 1, "i", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).saveAsTable("t"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("BucketedWriteSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78))))));
                    String $org_scalatest_assert_macro_left = e.getMessage();
                    String $org_scalatest_assert_macro_right = "Number of buckets should be greater than 0 but less than";
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BucketedWriteSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
                });
            });
        }, new Position("BucketedWriteSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        this.test("specify sorting columns without bucketing columns", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(BucketedWriteSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_sources_BucketedWriteSuite$$typecreator26$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_sources_BucketedWriteSuite$$typecreator26$1(BucketedWriteSuite $outer) {
                }
            }
            Dataset df = this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"a"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"b"), (List)Nil$.MODULE$)), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_sources_BucketedWriteSuite$$typecreator26$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"i", "j"}));
            AnalysisException e = (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> df.write().sortBy("j", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).saveAsTable("tt"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("BucketedWriteSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88))));
            String $org_scalatest_assert_macro_left = e.getMessage();
            String $org_scalatest_assert_macro_right = "sortBy must be used together with bucketBy";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BucketedWriteSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
        }, new Position("BucketedWriteSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
        this.test("sorting by non-orderable column", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(BucketedWriteSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_sources_BucketedWriteSuite$$typecreator36$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.Map"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_sources_BucketedWriteSuite$$typecreator36$1(BucketedWriteSuite $outer) {
                }
            }
            Dataset df = this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)1))}))), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToInteger((int)2))}))), (List)Nil$.MODULE$)), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_sources_BucketedWriteSuite$$typecreator36$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"i", "j"}));
            return (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> df.write().bucketBy(2, "i", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).sortBy("j", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).saveAsTable("tt"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("BucketedWriteSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96))));
        }, new Position("BucketedWriteSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
        this.test("write bucketed data using save()", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(BucketedWriteSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_sources_BucketedWriteSuite$$typecreator46$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_sources_BucketedWriteSuite$$typecreator46$1(BucketedWriteSuite $outer) {
                }
            }
            Dataset df = this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"a"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"b"), (List)Nil$.MODULE$)), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_sources_BucketedWriteSuite$$typecreator46$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"i", "j"}));
            AnalysisException e = (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> df.write().bucketBy(2, "i", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).parquet("/tmp/path"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("BucketedWriteSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102))));
            String $org_scalatest_assert_macro_left = e.getMessage();
            String $org_scalatest_assert_macro_right = "'save' does not support bucketBy right now";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BucketedWriteSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        }, new Position("BucketedWriteSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        this.test("write bucketed and sorted data using save()", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(BucketedWriteSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_sources_BucketedWriteSuite$$typecreator56$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_sources_BucketedWriteSuite$$typecreator56$1(BucketedWriteSuite $outer) {
                }
            }
            Dataset df = this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"a"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"b"), (List)Nil$.MODULE$)), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_sources_BucketedWriteSuite$$typecreator56$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"i", "j"}));
            AnalysisException e = (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> df.write().bucketBy(2, "i", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).sortBy("i", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).parquet("/tmp/path"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("BucketedWriteSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111))));
            String $org_scalatest_assert_macro_left = e.getMessage();
            String $org_scalatest_assert_macro_right = "'save' does not support bucketBy and sortBy right now";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BucketedWriteSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
        }, new Position("BucketedWriteSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
        this.test("write bucketed data using insertInto()", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(BucketedWriteSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_sources_BucketedWriteSuite$$typecreator66$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_sources_BucketedWriteSuite$$typecreator66$1(BucketedWriteSuite $outer) {
                }
            }
            Dataset df = this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"a"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"b"), (List)Nil$.MODULE$)), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_sources_BucketedWriteSuite$$typecreator66$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"i", "j"}));
            AnalysisException e = (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> df.write().bucketBy(2, "i", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).insertInto("tt"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("BucketedWriteSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120))));
            String $org_scalatest_assert_macro_left = e.getMessage();
            String $org_scalatest_assert_macro_right = "'insertInto' does not support bucketBy right now";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BucketedWriteSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
        }, new Position("BucketedWriteSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
        this.test("write bucketed and sorted data using insertInto()", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(BucketedWriteSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_sources_BucketedWriteSuite$$typecreator76$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_sources_BucketedWriteSuite$$typecreator76$1(BucketedWriteSuite $outer) {
                }
            }
            Dataset df = this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"a"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"b"), (List)Nil$.MODULE$)), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_sources_BucketedWriteSuite$$typecreator76$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"i", "j"}));
            AnalysisException e = (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> df.write().bucketBy(2, "i", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).sortBy("i", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).insertInto("tt"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("BucketedWriteSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129))));
            String $org_scalatest_assert_macro_left = e.getMessage();
            String $org_scalatest_assert_macro_right = "'insertInto' does not support bucketBy and sortBy right now";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BucketedWriteSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
        }, new Position("BucketedWriteSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
        this.test("write bucketed data", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.fileFormatsToTest().foreach((Function1 & Serializable & scala.Serializable)source -> {
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bucketed_table"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.df().write().format(source).partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"i"})).bucketBy(8, "j", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k"})).saveAsTable("bucketed_table");
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> $this.testBucketing(new File($this.tableDir(), new StringBuilder(2).append("i=").append(i).toString()), source, 8, (Seq<String>)((Seq)new .colon.colon((Object)"j", (List)new .colon.colon((Object)"k", (List)Nil$.MODULE$))), $this.testBucketing$default$5()));
            });
            return BoxedUnit.UNIT;
        }), new Position("BucketedWriteSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
        this.test("write bucketed data with sortBy", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.fileFormatsToTest().foreach((Function1 & Serializable & scala.Serializable)source -> {
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bucketed_table"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.df().write().format(source).partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"i"})).bucketBy(8, "j", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).sortBy("k", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).saveAsTable("bucketed_table");
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> $this.testBucketing(new File($this.tableDir(), new StringBuilder(2).append("i=").append(i).toString()), source, 8, (Seq<String>)((Seq)new .colon.colon((Object)"j", (List)Nil$.MODULE$)), (Seq<String>)((Seq)new .colon.colon((Object)"k", (List)Nil$.MODULE$))));
            });
            return BoxedUnit.UNIT;
        }), new Position("BucketedWriteSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
        this.test("write bucketed data with the overlapping bucketBy/sortBy and partitionBy columns", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            AnalysisException e1 = (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.df().write().partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"i", "j"})).bucketBy(8, "j", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k"})).sortBy("k", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).saveAsTable("bucketed_table"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("BucketedWriteSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235))));
            String $org_scalatest_assert_macro_left = e1.message();
            String $org_scalatest_assert_macro_right = "bucketing column 'j' should not be part of partition columns";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BucketedWriteSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 240));
            AnalysisException e2 = (AnalysisException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.df().write().partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"i", "j"})).bucketBy(8, "k", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).sortBy("i", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).saveAsTable("bucketed_table"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("BucketedWriteSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242))));
            String $org_scalatest_assert_macro_left2 = e2.message();
            String $org_scalatest_assert_macro_right2 = "bucket sorting column 'i' should not be part of partition columns";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BucketedWriteSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
        }, new Position("BucketedWriteSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 234));
        this.test("write bucketed data without partitionBy", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.fileFormatsToTest().foreach((Function1 & Serializable & scala.Serializable)source -> {
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bucketed_table"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.df().write().format(source).bucketBy(8, "i", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"j"})).saveAsTable("bucketed_table");
                $this.testBucketing($this.tableDir(), source, 8, (Seq<String>)((Seq)new .colon.colon((Object)"i", (List)new .colon.colon((Object)"j", (List)Nil$.MODULE$))), $this.testBucketing$default$5());
            });
            return BoxedUnit.UNIT;
        }), new Position("BucketedWriteSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 250));
        this.test("write bucketed data without partitionBy with sortBy", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.fileFormatsToTest().foreach((Function1 & Serializable & scala.Serializable)source -> {
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bucketed_table"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.df().write().format(source).bucketBy(8, "i", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"j"})).sortBy("k", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).saveAsTable("bucketed_table");
                $this.testBucketing($this.tableDir(), source, 8, (Seq<String>)((Seq)new .colon.colon((Object)"i", (List)new .colon.colon((Object)"j", (List)Nil$.MODULE$))), (Seq<String>)((Seq)new .colon.colon((Object)"k", (List)Nil$.MODULE$)));
            });
            return BoxedUnit.UNIT;
        }), new Position("BucketedWriteSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 263));
        this.test("write bucketed data with bucketing disabled", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.BUCKETING_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.fileFormatsToTest().foreach((Function1 & Serializable & scala.Serializable)source -> {
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bucketed_table"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.df().write().format(source).partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"i"})).bucketBy(8, "j", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k"})).saveAsTable("bucketed_table");
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> $this.testBucketing(new File($this.tableDir(), new StringBuilder(2).append("i=").append(i).toString()), source, 8, (Seq<String>)((Seq)new .colon.colon((Object)"j", (List)new .colon.colon((Object)"k", (List)Nil$.MODULE$))), $this.testBucketing$default$5()));
            });
            return BoxedUnit.UNIT;
        })), new Position("BucketedWriteSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 277));
    }
}

