/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.benchmark;

import java.io.File;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.benchmark.Benchmark;
import org.apache.spark.benchmark.Benchmark$;
import org.apache.spark.benchmark.BenchmarkBase;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.execution.benchmark.SqlBasedBenchmark;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Tuple2;
import scala.collection.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

public final class BloomFilterBenchmark$
extends BenchmarkBase
implements SqlBasedBenchmark {
    public static BloomFilterBenchmark$ MODULE$;
    private final int scaleFactor;
    private final int N;
    private final Dataset<Object> df;
    private final SparkSession spark;
    private String sparkHome;
    private volatile boolean bitmap$0;

    static {
        new BloomFilterBenchmark$();
    }

    @Override
    public SparkSession getSparkSession() {
        return SqlBasedBenchmark.getSparkSession$(this);
    }

    @Override
    public final void codegenBenchmark(String name, long cardinality, Function0<BoxedUnit> f) {
        SqlBasedBenchmark.codegenBenchmark$(this, name, cardinality, f);
    }

    @Override
    public SqlBasedBenchmark.DatasetToBenchmark DatasetToBenchmark(Dataset<?> ds) {
        return SqlBasedBenchmark.DatasetToBenchmark$(this, ds);
    }

    @Override
    public void prepareDataInfo(Benchmark benchmark) {
        SqlBasedBenchmark.prepareDataInfo$(this, benchmark);
    }

    @Override
    public StructType writeWideRow(String path, int rowsNum, int numCols) {
        return SqlBasedBenchmark.writeWideRow$(this, path, rowsNum, numCols);
    }

    @Override
    public void afterAll() {
        SqlBasedBenchmark.afterAll$(this);
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$((SQLHelper)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void org$apache$spark$sql$execution$benchmark$SqlBasedBenchmark$_setter_$spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    private String sparkHome$lzycompute() {
        BloomFilterBenchmark$ bloomFilterBenchmark$ = this;
        synchronized (bloomFilterBenchmark$) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$((SQLHelper)this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    public String sparkHome() {
        return !this.bitmap$0 ? this.sparkHome$lzycompute() : this.sparkHome;
    }

    private int scaleFactor() {
        return this.scaleFactor;
    }

    private int N() {
        return this.N;
    }

    private Dataset<Object> df() {
        return this.df;
    }

    private void writeBenchmark() {
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            BloomFilterBenchmark$.$anonfun$writeBenchmark$1(dir);
            return BoxedUnit.UNIT;
        });
    }

    private void readBenchmark() {
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            BloomFilterBenchmark$.$anonfun$readBenchmark$1(dir);
            return BoxedUnit.UNIT;
        });
    }

    public void runBenchmarkSuite(String[] mainArgs) {
        this.writeBenchmark();
        this.readBenchmark();
    }

    public static final /* synthetic */ void $anonfun$writeBenchmark$1(File dir) {
        String path = dir.getCanonicalPath();
        MODULE$.runBenchmark("ORC Write", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String x$1 = new StringBuilder(12).append("Write ").append(MODULE$.scaleFactor()).append("M rows").toString();
            long x$22 = MODULE$.N();
            Option x$32 = MODULE$.output();
            int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
            FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
            FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
            boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
            Benchmark benchmark = new Benchmark(x$1, x$22, x$4, x$5, x$6, x$7, x$32);
            benchmark.addCase("Without bloom filter", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$2 -> MODULE$.df().write().mode("overwrite").orc(new StringBuilder(10).append(path).append("/withoutBF").toString()));
            benchmark.addCase("With bloom filter", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$3 -> MODULE$.df().write().mode("overwrite").option("orc.bloom.filter.columns", "value").orc(new StringBuilder(7).append(path).append("/withBF").toString()));
            benchmark.run();
        });
    }

    public static final /* synthetic */ void $anonfun$readBenchmark$1(File dir) {
        String path = dir.getCanonicalPath();
        MODULE$.df().write().orc(new StringBuilder(10).append(path).append("/withoutBF").toString());
        MODULE$.df().write().option("orc.bloom.filter.columns", "value").orc(new StringBuilder(7).append(path).append("/withBF").toString());
        MODULE$.runBenchmark("ORC Read", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String x$1 = new StringBuilder(22).append("Read a row from ").append(MODULE$.scaleFactor()).append("M rows").toString();
            long x$2 = MODULE$.N();
            Option x$3 = MODULE$.output();
            int x$42 = Benchmark$.MODULE$.$lessinit$greater$default$3();
            FiniteDuration x$52 = Benchmark$.MODULE$.$lessinit$greater$default$4();
            FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
            boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
            Benchmark benchmark = new Benchmark(x$1, x$2, x$42, x$52, x$6, x$7, x$3);
            benchmark.addCase("Without bloom filter", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$4 -> MODULE$.DatasetToBenchmark(MODULE$.spark().read().orc(new StringBuilder(10).append(path).append("/withoutBF").toString()).where("value = 0")).noop());
            benchmark.addCase("With bloom filter", benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$5 -> MODULE$.DatasetToBenchmark(MODULE$.spark().read().orc(new StringBuilder(7).append(path).append("/withBF").toString()).where("value = 0")).noop());
            benchmark.run();
        });
    }

    private BloomFilterBenchmark$() {
        MODULE$ = this;
        SQLHelper.$init$((SQLHelper)this);
        SqlBasedBenchmark.$init$(this);
        this.scaleFactor = 100;
        this.N = this.scaleFactor() * 1000 * 1000;
        this.df = this.spark().range((long)this.N()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)Random$.MODULE$.nextInt()), this.spark().implicits().newIntEncoder());
    }
}

