/*
 * Decompiled with CFR 0.152.
 */
package test.org.apache.spark.sql.connector.catalog.functions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.catalog.functions.BoundFunction;
import org.apache.spark.sql.connector.catalog.functions.ScalarFunction;
import org.apache.spark.sql.connector.catalog.functions.UnboundFunction;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class JavaLongAdd
implements UnboundFunction {
    private final ScalarFunction<Long> impl;

    public JavaLongAdd(ScalarFunction<Long> impl) {
        this.impl = impl;
    }

    public String name() {
        return "long_add";
    }

    public BoundFunction bind(StructType inputType) {
        if (inputType.fields().length != 2) {
            throw new UnsupportedOperationException("Expect two arguments");
        }
        for (StructField field : inputType.fields()) {
            JavaLongAdd.checkInputType(field.dataType());
        }
        return this.impl;
    }

    private static void checkInputType(DataType type) {
        if (!(type instanceof IntegerType || type instanceof LongType || type instanceof DayTimeIntervalType)) {
            throw new UnsupportedOperationException("Expect one of [IntegerType|LongType|DateTimeIntervalType] but found " + type);
        }
    }

    public String description() {
        return "long_add";
    }

    public static class JavaLongAddMismatchMagic
    extends JavaLongAddBase {
        public JavaLongAddMismatchMagic() {
            super(false);
        }

        public String name() {
            return "long_add_mismatch_magic";
        }

        public long invoke(int left, int right) {
            return left + right;
        }
    }

    public static class JavaLongAddStaticMagic
    extends JavaLongAddBase {
        public JavaLongAddStaticMagic(boolean isResultNullable) {
            super(isResultNullable);
        }

        public String name() {
            return "long_add_static_magic";
        }

        public static long invoke(long left, long right) {
            return left + right;
        }
    }

    public static class JavaLongAddMagic
    extends JavaLongAddBase {
        public JavaLongAddMagic(boolean isResultNullable) {
            super(isResultNullable);
        }

        public String name() {
            return "long_add_magic";
        }

        public long invoke(long left, long right) {
            return left + right;
        }
    }

    public static class JavaLongAddDefault
    extends JavaLongAddBase {
        public JavaLongAddDefault(boolean isResultNullable) {
            super(isResultNullable);
        }

        public String name() {
            return "long_add_default";
        }

        public Long produceResult(InternalRow input) {
            return input.getLong(0) + input.getLong(1);
        }
    }

    private static abstract class JavaLongAddBase
    implements ScalarFunction<Long> {
        private final boolean isResultNullable;

        JavaLongAddBase(boolean isResultNullable) {
            this.isResultNullable = isResultNullable;
        }

        public DataType[] inputTypes() {
            return new DataType[]{DataTypes.LongType, DataTypes.LongType};
        }

        public DataType resultType() {
            return DataTypes.LongType;
        }

        public boolean isResultNullable() {
            return this.isResultNullable;
        }
    }
}

