/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.orc;

import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.vectorized.ColumnVector;

public abstract class OrcColumnVector
extends ColumnVector {
    private final org.apache.hadoop.hive.ql.exec.vector.ColumnVector baseData;
    private int batchSize;

    OrcColumnVector(DataType type, org.apache.hadoop.hive.ql.exec.vector.ColumnVector vector) {
        super(type);
        this.baseData = vector;
    }

    public void close() {
    }

    public boolean hasNull() {
        return !this.baseData.noNulls;
    }

    public int numNulls() {
        if (this.baseData.isRepeating) {
            if (this.baseData.isNull[0]) {
                return this.batchSize;
            }
            return 0;
        }
        if (this.baseData.noNulls) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < this.batchSize; ++i) {
            if (!this.baseData.isNull[i]) continue;
            ++count;
        }
        return count;
    }

    public boolean isNullAt(int rowId) {
        return this.baseData.isNull[this.getRowIndex(rowId)];
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    protected int getRowIndex(int rowId) {
        return this.baseData.isRepeating ? 0 : rowId;
    }
}

