/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.Serializable;
import java.net.URI;
import java.time.ZoneOffset;
import java.util.Locale;
import java.util.TimeZone;
import javax.ws.rs.core.UriBuilder;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat$;
import org.apache.spark.sql.catalyst.catalog.CatalogUtils$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.parser.AstBuilder;
import org.apache.spark.sql.catalyst.parser.ParserUtils$;
import org.apache.spark.sql.catalyst.parser.SqlBaseParser;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.RepartitionByExpression;
import org.apache.spark.sql.catalyst.plans.logical.ScriptInputOutputSchema;
import org.apache.spark.sql.catalyst.plans.logical.SerdeInfo;
import org.apache.spark.sql.errors.QueryParsingErrors$;
import org.apache.spark.sql.execution.CodegenMode$;
import org.apache.spark.sql.execution.CostMode$;
import org.apache.spark.sql.execution.ExtendedMode$;
import org.apache.spark.sql.execution.FormattedMode$;
import org.apache.spark.sql.execution.SimpleMode$;
import org.apache.spark.sql.execution.command.AddArchivesCommand;
import org.apache.spark.sql.execution.command.AddFilesCommand;
import org.apache.spark.sql.execution.command.AddJarsCommand;
import org.apache.spark.sql.execution.command.ClearCacheCommand$;
import org.apache.spark.sql.execution.command.CreateTableLikeCommand;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.DescribeQueryCommand;
import org.apache.spark.sql.execution.command.ExplainCommand;
import org.apache.spark.sql.execution.command.ListArchivesCommand;
import org.apache.spark.sql.execution.command.ListArchivesCommand$;
import org.apache.spark.sql.execution.command.ListFilesCommand;
import org.apache.spark.sql.execution.command.ListFilesCommand$;
import org.apache.spark.sql.execution.command.ListJarsCommand;
import org.apache.spark.sql.execution.command.ListJarsCommand$;
import org.apache.spark.sql.execution.command.ResetCommand;
import org.apache.spark.sql.execution.command.SetCommand;
import org.apache.spark.sql.execution.datasources.CreateTempViewUsing;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.RefreshResource;
import org.apache.spark.sql.internal.HiveSerDe;
import org.apache.spark.sql.internal.HiveSerDe$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.CalendarInterval;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple8;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\t5e\u0001\u0002\u0012$\u00019BQa\u000e\u0001\u0005\u0002aBqa\u000f\u0001C\u0002\u0013%A\b\u0003\u0004H\u0001\u0001\u0006I!\u0010\u0005\b\u0011\u0002\u0011\r\u0011\"\u0003=\u0011\u0019I\u0005\u0001)A\u0005{!9!\n\u0001b\u0001\n\u0013a\u0004BB&\u0001A\u0003%Q\bC\u0004M\u0001\t\u0007I\u0011\u0002\u001f\t\r5\u0003\u0001\u0015!\u0003>\u0011\u0015q\u0005\u0001\"\u0011P\u0011\u0015\u0001\b\u0001\"\u0011r\u0011\u00151\b\u0001\"\u0011x\u0011\u0015a\b\u0001\"\u0011~\u0011\u001d\t)\u0001\u0001C!\u0003\u000fAq!!\u0005\u0001\t\u0003\n\u0019\u0002C\u0004\u0002\u001e\u0001!I!a\b\t\u000f\u0005M\u0002\u0001\"\u0011\u00026!9\u0011q\b\u0001\u0005B\u0005\u0005\u0003bBA&\u0001\u0011\u0005\u0013Q\n\u0005\b\u0003/\u0002A\u0011AA-\u0011\u001d\t\u0019\n\u0001C!\u0003+Cq!a(\u0001\t\u0003\n\t\u000bC\u0004\u0002,\u0002!\t%!,\t\u000f\u0005e\u0006\u0001\"\u0011\u0002<\"9\u0011Q\u0019\u0001\u0005B\u0005\u001d\u0007bBAi\u0001\u0011\u0005\u00131\u001b\u0005\b\u0003;\u0004A\u0011BAp\u0011\u001d\u00119\u0001\u0001C!\u0005\u0013AqAa\u0005\u0001\t#\u0012)\u0002C\u0004\u0003F\u0001!\tFa\u0012\t\u000f\t\u0015\u0004\u0001\"\u0011\u0003h!9!\u0011\u0010\u0001\u0005B\tm\u0004B\u0004BC\u0001A\u0005\u0019\u0011!A\u0005\n\t\u001d%1\u0012\u0002\u0013'B\f'o[*rY\u0006\u001bHOQ;jY\u0012,'O\u0003\u0002%K\u0005IQ\r_3dkRLwN\u001c\u0006\u0003M\u001d\n1a]9m\u0015\tA\u0013&A\u0003ta\u0006\u00148N\u0003\u0002+W\u00051\u0011\r]1dQ\u0016T\u0011\u0001L\u0001\u0004_J<7\u0001A\n\u0003\u0001=\u0002\"\u0001M\u001b\u000e\u0003ER!AM\u001a\u0002\rA\f'o]3s\u0015\t!T%\u0001\u0005dCR\fG._:u\u0013\t1\u0014G\u0001\u0006BgR\u0014U/\u001b7eKJ\fa\u0001P5oSRtD#A\u001d\u0011\u0005i\u0002Q\"A\u0012\u0002#\r|gNZ5h\u0017\u0016Lh+\u00197vK\u0012+g-F\u0001>!\tqT)D\u0001@\u0015\t\u0001\u0015)\u0001\u0005nCR\u001c\u0007.\u001b8h\u0015\t\u00115)\u0001\u0003vi&d'\"\u0001#\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019{$!\u0002*fO\u0016D\u0018AE2p]\u001aLwmS3z-\u0006dW/\u001a#fM\u0002\nAbY8oM&<7*Z=EK\u001a\fQbY8oM&<7*Z=EK\u001a\u0004\u0013AD2p]\u001aLwMV1mk\u0016$UMZ\u0001\u0010G>tg-[4WC2,X\rR3gA\u0005i1\u000f\u001e:MSR,'/\u00197EK\u001a\fab\u001d;s\u0019&$XM]1m\t\u00164\u0007%A\u000bwSNLGoU3u\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0015\u0005AC\u0006CA)W\u001b\u0005\u0011&BA*U\u0003\u001dawnZ5dC2T!!V\u001a\u0002\u000bAd\u0017M\\:\n\u0005]\u0013&a\u0003'pO&\u001c\u0017\r\u001c)mC:DQ!\u0017\u0006A\u0002i\u000b1a\u0019;y!\tYVN\u0004\u0002]W:\u0011QL\u001b\b\u0003=&t!a\u00185\u000f\u0005\u0001<gBA1g\u001d\t\u0011W-D\u0001d\u0015\t!W&\u0001\u0004=e>|GOP\u0005\u0002Y%\u0011!fK\u0005\u0003Q%J!AJ\u0014\n\u0005Q*\u0013B\u0001\u001a4\u0013\ta\u0017'A\u0007Tc2\u0014\u0015m]3QCJ\u001cXM]\u0005\u0003]>\u0014qcU3u\u0007>tg-[4ve\u0006$\u0018n\u001c8D_:$X\r\u001f;\u000b\u00051\f\u0014a\u0007<jg&$8+\u001a;Rk>$X\rZ\"p]\u001aLw-\u001e:bi&|g\u000e\u0006\u0002Qe\")\u0011l\u0003a\u0001gB\u00111\f^\u0005\u0003k>\u0014QdU3u#V|G/\u001a3D_:4\u0017nZ;sCRLwN\\\"p]R,\u0007\u0010^\u0001\u0018m&\u001c\u0018\u000e\u001e*fg\u0016$8i\u001c8gS\u001e,(/\u0019;j_:$\"\u0001\u0015=\t\u000bec\u0001\u0019A=\u0011\u0005mS\u0018BA>p\u0005e\u0011Vm]3u\u0007>tg-[4ve\u0006$\u0018n\u001c8D_:$X\r\u001f;\u0002;YL7/\u001b;SKN,G/U;pi\u0016$7i\u001c8gS\u001e,(/\u0019;j_:$\"\u0001\u0015@\t\u000bek\u0001\u0019A@\u0011\u0007m\u000b\t!C\u0002\u0002\u0004=\u0014qDU3tKR\fVo\u001c;fI\u000e{gNZ5hkJ\fG/[8o\u0007>tG/\u001a=u\u0003A1\u0018n]5u'\u0016$H+[7f5>tW\rF\u0002Q\u0003\u0013Aa!\u0017\bA\u0002\u0005-\u0001cA.\u0002\u000e%\u0019\u0011qB8\u0003%M+G\u000fV5nKj{g.Z\"p]R,\u0007\u0010^\u0001\u0015m&\u001c\u0018\u000e\u001e*fMJ,7\u000f\u001b*fg>,(oY3\u0015\u0007A\u000b)\u0002\u0003\u0004Z\u001f\u0001\u0007\u0011q\u0003\t\u00047\u0006e\u0011bAA\u000e_\n1\"+\u001a4sKND'+Z:pkJ\u001cWmQ8oi\u0016DH/A\u000efqR\u0014\u0018m\u0019;V]F,x\u000e^3e%\u0016\u001cx.\u001e:dKB\u000bG\u000f\u001b\u000b\u0005\u0003C\t\t\u0004\u0005\u0003\u0002$\u0005-b\u0002BA\u0013\u0003O\u0001\"AY\"\n\u0007\u0005%2)\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003[\tyC\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003S\u0019\u0005BB-\u0011\u0001\u0004\t9\"A\bwSNLGo\u00117fCJ\u001c\u0015m\u00195f)\r\u0001\u0016q\u0007\u0005\u00073F\u0001\r!!\u000f\u0011\u0007m\u000bY$C\u0002\u0002>=\u0014\u0011c\u00117fCJ\u001c\u0015m\u00195f\u0007>tG/\u001a=u\u000311\u0018n]5u\u000bb\u0004H.Y5o)\r\u0001\u00161\t\u0005\u00073J\u0001\r!!\u0012\u0011\u0007m\u000b9%C\u0002\u0002J=\u0014a\"\u0012=qY\u0006LgnQ8oi\u0016DH/\u0001\nwSNLG\u000fR3tGJL'-Z)vKJLHc\u0001)\u0002P!1\u0011l\u0005a\u0001\u0003#\u00022aWA*\u0013\r\t)f\u001c\u0002\u0015\t\u0016\u001c8M]5cKF+XM]=D_:$X\r\u001f;\u0002\u001fQ\f'\r\\3JI\u0016tG/\u001b4jKJ$\u0002\"a\u0017\u0002d\u0005e\u0014Q\u0010\t\u0005\u0003;\ny&D\u00014\u0013\r\t\tg\r\u0002\u0010)\u0006\u0014G.Z%eK:$\u0018NZ5fe\"9\u0011Q\r\u000bA\u0002\u0005\u001d\u0014!C7vYRL\u0007/\u0019:u!\u0019\tI'a\u001d\u0002\"9!\u00111NA8\u001d\r\u0011\u0017QN\u0005\u0002\t&\u0019\u0011\u0011O\"\u0002\u000fA\f7m[1hK&!\u0011QOA<\u0005\r\u0019V-\u001d\u0006\u0004\u0003c\u001a\u0005bBA>)\u0001\u0007\u0011\u0011E\u0001\bG>lW.\u00198e\u0011\u0019IF\u00031\u0001\u0002\u0000A!\u0011\u0011QAH\u001b\t\t\u0019I\u0003\u0003\u0002\u0006\u0006\u001d\u0015a\u0002:v]RLW.\u001a\u0006\u0005\u0003\u0013\u000bY)\u0001\u0002wi)\u0019\u0011QR\u0016\u0002\u000b\u0005tG\u000f\u001c:\n\t\u0005E\u00151\u0011\u0002\u0012!\u0006\u00148/\u001a:Sk2,7i\u001c8uKb$\u0018\u0001\u0005<jg&$8I]3bi\u0016$\u0016M\u00197f)\r\u0001\u0016q\u0013\u0005\u00073V\u0001\r!!'\u0011\u0007m\u000bY*C\u0002\u0002\u001e>\u0014!c\u0011:fCR,G+\u00192mK\u000e{g\u000e^3yi\u0006Ab/[:ji\u000e\u0013X-\u0019;f)\u0016l\u0007OV5foV\u001b\u0018N\\4\u0015\u0007A\u000b\u0019\u000b\u0003\u0004Z-\u0001\u0007\u0011Q\u0015\t\u00047\u0006\u001d\u0016bAAU_\nQ2I]3bi\u0016$V-\u001c9WS\u0016<Xk]5oO\u000e{g\u000e^3yi\u00069b/[:ji:+7\u000f^3e\u0007>t7\u000f^1oi2K7\u000f\u001e\u000b\u0005\u0003_\u000b\t\f\u0005\u0004\u0002j\u0005M\u0014q\r\u0005\u00073^\u0001\r!a-\u0011\u0007m\u000b),C\u0002\u00028>\u0014\u0011DT3ti\u0016$7i\u001c8ti\u0006tG\u000fT5ti\u000e{g\u000e^3yi\u0006\tb/[:ji\u000e{gn\u001d;b]Rd\u0015n\u001d;\u0015\t\u0005\u001d\u0014Q\u0018\u0005\u00073b\u0001\r!a0\u0011\u0007m\u000b\t-C\u0002\u0002D>\u00141cQ8ogR\fg\u000e\u001e'jgR\u001cuN\u001c;fqR\faC^5tSR4\u0015-\u001b7OCRLg/Z\"p[6\fg\u000e\u001a\u000b\u0004!\u0006%\u0007BB-\u001a\u0001\u0004\tY\rE\u0002\\\u0003\u001bL1!a4p\u0005a1\u0015-\u001b7OCRLg/Z\"p[6\fg\u000eZ\"p]R,\u0007\u0010^\u0001\u0014m&\u001c\u0018\u000e^'b]\u0006<WMU3t_V\u00148-\u001a\u000b\u0004!\u0006U\u0007BB-\u001b\u0001\u0004\t9\u000eE\u0002\\\u00033L1!a7p\u0005Ui\u0015M\\1hKJ+7o\\;sG\u0016\u001cuN\u001c;fqR\fq\u0002^8Ti>\u0014\u0018mZ3G_Jl\u0017\r\u001e\u000b\t\u0003C\fi/!?\u0003\u0006A!\u00111]Au\u001b\t\t)OC\u0002\u0002hN\nqaY1uC2|w-\u0003\u0003\u0002l\u0006\u0015(\u0001F\"bi\u0006dwnZ*u_J\fw-\u001a$pe6\fG\u000fC\u0004\u0002pn\u0001\r!!=\u0002\u00111|7-\u0019;j_:\u0004b!a=\u0002v\u0006\u0005R\"A\"\n\u0007\u0005]8I\u0001\u0004PaRLwN\u001c\u0005\b\u0003w\\\u0002\u0019AA\u007f\u00039i\u0017-\u001f2f'\u0016\u0014H-Z%oM>\u0004b!a=\u0002v\u0006}\bcA)\u0003\u0002%\u0019!1\u0001*\u0003\u0013M+'\u000fZ3J]\u001a|\u0007BB-\u001c\u0001\u0004\ty(\u0001\u000bwSNLGo\u0011:fCR,G+\u00192mK2K7.\u001a\u000b\u0004!\n-\u0001BB-\u001d\u0001\u0004\u0011i\u0001E\u0002\\\u0005\u001fI1A!\u0005p\u0005Y\u0019%/Z1uKR\u000b'\r\\3MS.,7i\u001c8uKb$\u0018AE<ji\"\u001c6M]5qi&{5k\u00195f[\u0006$bBa\u0006\u0003\u001e\t}!\u0011\u0006B\u001a\u0005o\u0011Y\u0004E\u0002R\u00053I1Aa\u0007S\u0005]\u00196M]5qi&s\u0007/\u001e;PkR\u0004X\u000f^*dQ\u0016l\u0017\r\u0003\u0004Z;\u0001\u0007\u0011q\u0010\u0005\b\u0005Ci\u0002\u0019\u0001B\u0012\u0003-IgNU8x\r>\u0014X.\u0019;\u0011\u0007m\u0013)#C\u0002\u0003(=\u0014\u0001CU8x\r>\u0014X.\u0019;D_:$X\r\u001f;\t\u000f\t-R\u00041\u0001\u0003.\u0005a!/Z2pe\u0012<&/\u001b;feB!\u0011\u0011\u0011B\u0018\u0013\u0011\u0011\t$a!\u0003\u000bQ{7.\u001a8\t\u000f\tUR\u00041\u0001\u0003$\u0005aq.\u001e;S_^4uN]7bi\"9!\u0011H\u000fA\u0002\t5\u0012\u0001\u0004:fG>\u0014HMU3bI\u0016\u0014\bb\u0002B\u001f;\u0001\u0007!qH\u0001\u000bg\u000eDW-\\1MKN\u001c\b\u0003BAz\u0005\u0003J1Aa\u0011D\u0005\u001d\u0011un\u001c7fC:\f1d^5uQJ+\u0007/\u0019:uSRLwN\u001c\"z\u000bb\u0004(/Z:tS>tGc\u0002)\u0003J\tE#\u0011\r\u0005\u00073z\u0001\rAa\u0013\u0011\u0007m\u0013i%C\u0002\u0003P=\u0014\u0001$U;fef|%oZ1oSj\fG/[8o\u0007>tG/\u001a=u\u0011\u001d\u0011\u0019F\ba\u0001\u0005+\n1\"\u001a=qe\u0016\u001c8/[8ogB1\u0011\u0011NA:\u0005/\u0002BA!\u0017\u0003^5\u0011!1\f\u0006\u0004\u0005'\u001a\u0014\u0002\u0002B0\u00057\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0011\u0019\u0011\u0019G\ba\u0001!\u0006)\u0011/^3ss\u00069b/[:ji&s7/\u001a:u\u001fZ,'o\u001e:ji\u0016$\u0015N\u001d\u000b\u0005\u0005S\u0012\t\b\u0005\u0003\u0003l\t5T\"\u0001\u0001\n\u0007\t=TGA\bJ]N,'\u000f\u001e#jeB\u000b'/Y7t\u0011\u0019Iv\u00041\u0001\u0003tA\u00191L!\u001e\n\u0007\t]tNA\rJ]N,'\u000f^(wKJ<(/\u001b;f\t&\u00148i\u001c8uKb$\u0018a\u0007<jg&$\u0018J\\:feR|e/\u001a:xe&$X\rS5wK\u0012K'\u000f\u0006\u0003\u0003j\tu\u0004BB-!\u0001\u0004\u0011y\bE\u0002\\\u0005\u0003K1Aa!p\u0005uIen]3si>3XM]<sSR,\u0007*\u001b<f\t&\u00148i\u001c8uKb$\u0018AF:va\u0016\u0014HE^5tSR\u001c%/Z1uKR\u000b'\r\\3\u0015\u0007A\u0013I\t\u0003\u0004ZC\u0001\u0007\u0011\u0011T\u0005\u0004\u0003'+\u0004")
public class SparkSqlAstBuilder
extends AstBuilder {
    private final Regex configKeyValueDef = new StringOps(Predef$.MODULE$.augmentString("([a-zA-Z_\\d\\\\.:]+)\\s*=([^;]*);*")).r();
    private final Regex configKeyDef = new StringOps(Predef$.MODULE$.augmentString("([a-zA-Z_\\d\\\\.:]+)$")).r();
    private final Regex configValueDef = new StringOps(Predef$.MODULE$.augmentString("([^;]*);*")).r();
    private final Regex strLiteralDef = new StringOps(Predef$.MODULE$.augmentString("(\".*?[^\\\\]\"|'.*?[^\\\\]'|[^ \\n\\r\\t\"']+)")).r();

    private /* synthetic */ LogicalPlan super$visitCreateTable(SqlBaseParser.CreateTableContext ctx) {
        return super.visitCreateTable(ctx);
    }

    private Regex configKeyValueDef() {
        return this.configKeyValueDef;
    }

    private Regex configKeyDef() {
        return this.configKeyDef;
    }

    private Regex configValueDef() {
        return this.configValueDef;
    }

    private Regex strLiteralDef() {
        return this.strLiteralDef;
    }

    public LogicalPlan visitSetConfiguration(SqlBaseParser.SetConfigurationContext ctx) {
        return (LogicalPlan)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> {
            SetCommand setCommand;
            String string = ParserUtils$.MODULE$.remainder(ctx.SET().getSymbol()).trim();
            Option option = this.configKeyValueDef().unapplySeq((CharSequence)string);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
                String key = (String)((LinearSeqOptimized)option.get()).apply(0);
                String value = (String)((LinearSeqOptimized)option.get()).apply(1);
                setCommand = new SetCommand((Option<Tuple2<String, Option<String>>>)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)Option$.MODULE$.apply((Object)value.trim()))));
            } else {
                Option option2 = this.configKeyDef().unapplySeq((CharSequence)string);
                if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(1) == 0) {
                    String key = (String)((LinearSeqOptimized)option2.get()).apply(0);
                    setCommand = new SetCommand((Option<Tuple2<String, Option<String>>>)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)None$.MODULE$)));
                } else {
                    String string2 = string;
                    String string3 = "-v";
                    if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                        setCommand = new SetCommand((Option<Tuple2<String, Option<String>>>)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"-v"), (Object)None$.MODULE$)));
                    } else if (string.isEmpty()) {
                        setCommand = new SetCommand((Option<Tuple2<String, Option<String>>>)None$.MODULE$);
                    } else {
                        throw QueryParsingErrors$.MODULE$.unexpectedFomatForSetConfigurationError(ctx);
                    }
                }
            }
            return setCommand;
        });
    }

    public LogicalPlan visitSetQuotedConfiguration(SqlBaseParser.SetQuotedConfigurationContext ctx) {
        return (LogicalPlan)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> {
            SetCommand setCommand;
            if (ctx.configValue() != null && ctx.configKey() != null) {
                setCommand = new SetCommand((Option<Tuple2<String, Option<String>>>)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ctx.configKey().getText()), (Object)Option$.MODULE$.apply((Object)ctx.configValue().getText()))));
            } else if (ctx.configValue() != null) {
                String keyCandidate;
                String valueStr = ctx.configValue().getText();
                String string = keyCandidate = ParserUtils$.MODULE$.interval(ctx.SET().getSymbol(), ctx.EQ().getSymbol()).trim();
                Option option = this.configKeyDef().unapplySeq((CharSequence)string);
                if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) {
                    throw QueryParsingErrors$.MODULE$.invalidPropertyKeyForSetQuotedConfigurationError(keyCandidate, valueStr, ctx);
                }
                String key = (String)((LinearSeqOptimized)option.get()).apply(0);
                SetCommand setCommand2 = new SetCommand((Option<Tuple2<String, Option<String>>>)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)Option$.MODULE$.apply((Object)valueStr))));
                setCommand = setCommand2;
            } else {
                String keyStr = ctx.configKey().getText();
                if (ctx.EQ() != null) {
                    String string = ParserUtils$.MODULE$.remainder(ctx.EQ().getSymbol()).trim();
                    Option option = this.configValueDef().unapplySeq((CharSequence)string);
                    if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) {
                        throw QueryParsingErrors$.MODULE$.invalidPropertyValueForSetQuotedConfigurationError(string, keyStr, ctx);
                    }
                    String valueStr = (String)((LinearSeqOptimized)option.get()).apply(0);
                    SetCommand setCommand3 = new SetCommand((Option<Tuple2<String, Option<String>>>)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)keyStr), (Object)Option$.MODULE$.apply((Object)valueStr))));
                    setCommand = setCommand3;
                } else {
                    setCommand = new SetCommand((Option<Tuple2<String, Option<String>>>)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)keyStr), (Object)None$.MODULE$)));
                }
            }
            return setCommand;
        });
    }

    public LogicalPlan visitResetConfiguration(SqlBaseParser.ResetConfigurationContext ctx) {
        return (LogicalPlan)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> {
            ResetCommand resetCommand;
            String string = ParserUtils$.MODULE$.remainder(ctx.RESET().getSymbol()).trim();
            Option option = this.configKeyDef().unapplySeq((CharSequence)string);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                String key = (String)((LinearSeqOptimized)option.get()).apply(0);
                resetCommand = new ResetCommand((Option<String>)new Some((Object)key));
            } else if (string.trim().isEmpty()) {
                resetCommand = new ResetCommand((Option<String>)None$.MODULE$);
            } else {
                throw QueryParsingErrors$.MODULE$.unexpectedFormatForResetConfigurationError(ctx);
            }
            return resetCommand;
        });
    }

    public LogicalPlan visitResetQuotedConfiguration(SqlBaseParser.ResetQuotedConfigurationContext ctx) {
        return (LogicalPlan)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> new ResetCommand((Option<String>)new Some((Object)ctx.configKey().getText())));
    }

    public LogicalPlan visitSetTimeZone(SqlBaseParser.SetTimeZoneContext ctx) {
        return (LogicalPlan)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> {
            SetCommand setCommand;
            String key = SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key();
            if (ctx.interval() != null) {
                CalendarInterval interval = this.parseIntervalLiteral(ctx.interval());
                if (interval.months != 0 || interval.days != 0 || package$.MODULE$.abs(interval.microseconds) > 64800000000L || interval.microseconds % 1000000L != 0L) {
                    throw QueryParsingErrors$.MODULE$.intervalValueOutOfRangeError(ctx.interval());
                }
                int seconds = (int)(interval.microseconds / 1000000L);
                setCommand = new SetCommand((Option<Tuple2<String, Option<String>>>)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)new Some((Object)ZoneOffset.ofTotalSeconds(seconds).toString()))));
            } else if (ctx$5.timezone != null) {
                int n = ctx$5.timezone.getType();
                switch (n) {
                    case 138: {
                        setCommand = new SetCommand((Option<Tuple2<String, Option<String>>>)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)new Some((Object)TimeZone.getDefault().getID()))));
                        break;
                    }
                    default: {
                        setCommand = new SetCommand((Option<Tuple2<String, Option<String>>>)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)new Some((Object)ParserUtils$.MODULE$.string(ctx.STRING())))));
                        break;
                    }
                }
            } else {
                throw QueryParsingErrors$.MODULE$.invalidTimeZoneDisplacementValueError(ctx);
            }
            return setCommand;
        });
    }

    public LogicalPlan visitRefreshResource(SqlBaseParser.RefreshResourceContext ctx) {
        return (LogicalPlan)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> {
            String path = ctx.STRING() != null ? ParserUtils$.MODULE$.string(ctx.STRING()) : this.extractUnquotedResourcePath(ctx);
            return new RefreshResource(path);
        });
    }

    private String extractUnquotedResourcePath(SqlBaseParser.RefreshResourceContext ctx) {
        return (String)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> {
            void var1_1;
            String unquotedPath = ParserUtils$.MODULE$.remainder(ctx.REFRESH().getSymbol()).trim();
            ParserUtils$.MODULE$.validate((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> unquotedPath != null && !unquotedPath.isEmpty(), "Resource paths cannot be empty in REFRESH statements. Use / to match everything", (ParserRuleContext)ctx);
            Seq forbiddenSymbols = (Seq)new .colon.colon((Object)" ", (List)new .colon.colon((Object)"\n", (List)new .colon.colon((Object)"\r", (List)new .colon.colon((Object)"\t", (List)Nil$.MODULE$))));
            ParserUtils$.MODULE$.validate((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !forbiddenSymbols.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)unquotedPath.contains(x$1))), "REFRESH statements cannot contain ' ', '\\n', '\\r', '\\t' inside unquoted resource paths", (ParserRuleContext)ctx);
            return var1_1;
        });
    }

    public LogicalPlan visitClearCache(SqlBaseParser.ClearCacheContext ctx) {
        return (LogicalPlan)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> ClearCacheCommand$.MODULE$);
    }

    public LogicalPlan visitExplain(SqlBaseParser.ExplainContext ctx) {
        return (LogicalPlan)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> {
            if (ctx.LOGICAL() != null) {
                throw ParserUtils$.MODULE$.operationNotAllowed("EXPLAIN LOGICAL", (ParserRuleContext)ctx);
            }
            LogicalPlan statement = this.plan((ParserRuleContext)ctx.statement());
            return statement == null ? null : new ExplainCommand(statement, ctx.EXTENDED() != null ? ExtendedMode$.MODULE$ : (ctx.CODEGEN() != null ? CodegenMode$.MODULE$ : (ctx.COST() != null ? CostMode$.MODULE$ : (ctx.FORMATTED() != null ? FormattedMode$.MODULE$ : SimpleMode$.MODULE$))));
        });
    }

    public LogicalPlan visitDescribeQuery(SqlBaseParser.DescribeQueryContext ctx) {
        return (LogicalPlan)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> new DescribeQueryCommand(ParserUtils$.MODULE$.source((ParserRuleContext)ctx.query()), this.visitQuery(ctx.query())));
    }

    public TableIdentifier tableIdentifier(Seq<String> multipart, String command, ParserRuleContext ctx) {
        TableIdentifier tableIdentifier;
        Seq<String> seq = multipart;
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0) {
            String tableName = (String)((SeqLike)some.get()).apply(0);
            tableIdentifier = TableIdentifier$.MODULE$.apply(tableName);
        } else {
            Some some2 = Seq$.MODULE$.unapplySeq(seq);
            if (!some2.isEmpty() && some2.get() != null && ((SeqLike)some2.get()).lengthCompare(2) == 0) {
                String database = (String)((SeqLike)some2.get()).apply(0);
                String tableName = (String)((SeqLike)some2.get()).apply(1);
                tableIdentifier = new TableIdentifier(tableName, (Option)new Some((Object)database));
            } else {
                throw ParserUtils$.MODULE$.operationNotAllowed(new StringBuilder(40).append(command).append(" does not support multi-part identifiers").toString(), ctx);
            }
        }
        return tableIdentifier;
    }

    public LogicalPlan visitCreateTable(SqlBaseParser.CreateTableContext ctx) {
        return (LogicalPlan)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> {
            LogicalPlan logicalPlan2;
            Tuple4 tuple4 = this.visitCreateTableHeader(ctx.createTableHeader());
            if (tuple4 == null) {
                throw new MatchError((Object)tuple4);
            }
            Seq ident = (Seq)tuple4._1();
            boolean temp = BoxesRunTime.unboxToBoolean((Object)tuple4._2());
            boolean ifNotExists = BoxesRunTime.unboxToBoolean((Object)tuple4._3());
            boolean external = BoxesRunTime.unboxToBoolean((Object)tuple4._4());
            Tuple4 tuple42 = new Tuple4((Object)ident, (Object)BoxesRunTime.boxToBoolean((boolean)temp), (Object)BoxesRunTime.boxToBoolean((boolean)ifNotExists), (Object)BoxesRunTime.boxToBoolean((boolean)external));
            Tuple4 tuple43 = tuple42;
            Seq ident2 = (Seq)tuple43._1();
            boolean temp2 = BoxesRunTime.unboxToBoolean((Object)tuple43._2());
            boolean ifNotExists2 = BoxesRunTime.unboxToBoolean((Object)tuple43._3());
            boolean external2 = BoxesRunTime.unboxToBoolean((Object)tuple43._4());
            if (!temp2 || ctx.query() != null) {
                logicalPlan2 = this.super$visitCreateTable(ctx);
            } else {
                if (external2) {
                    throw ParserUtils$.MODULE$.operationNotAllowed("CREATE EXTERNAL TABLE ... USING", (ParserRuleContext)ctx);
                }
                if (ifNotExists2) {
                    throw ParserUtils$.MODULE$.operationNotAllowed("CREATE TEMPORARY TABLE IF NOT EXISTS", (ParserRuleContext)ctx);
                }
                Tuple8 tuple8 = this.visitCreateTableClauses(ctx.createTableClauses());
                if (tuple8 == null) {
                    throw new MatchError((Object)tuple8);
                }
                Map options = (Map)tuple8._5();
                Option location = (Option)tuple8._6();
                Tuple2 tuple2 = new Tuple2((Object)options, (Object)location);
                Tuple2 tuple22 = tuple2;
                Map options2 = (Map)tuple22._1();
                Option location2 = (Option)tuple22._2();
                String provider = (String)Option$.MODULE$.apply((Object)ctx.tableProvider()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.multipartIdentifier().getText()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw QueryParsingErrors$.MODULE$.createTempTableNotSpecifyProviderError(ctx);
                });
                Option schema = Option$.MODULE$.apply((Object)ctx.colTypeList()).map((Function1 & Serializable & scala.Serializable)ctx -> this.createSchema((SqlBaseParser.ColTypeListContext)ctx));
                this.logWarning((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(106).append("CREATE TEMPORARY TABLE ... USING ... is deprecated, please use ").append("CREATE TEMPORARY VIEW ... USING ... instead").toString());
                TableIdentifier table = this.tableIdentifier((Seq<String>)ident2, "CREATE TEMPORARY VIEW", (ParserRuleContext)ctx);
                Map optionsWithLocation = (Map)location2.map((Function1 & Serializable & scala.Serializable)l -> options2.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), l))).getOrElse((Function0 & Serializable & scala.Serializable)() -> options2);
                logicalPlan2 = new CreateTempViewUsing(table, (Option<StructType>)schema, false, false, provider, (Map<String, String>)optionsWithLocation);
            }
            return logicalPlan2;
        });
    }

    public LogicalPlan visitCreateTempViewUsing(SqlBaseParser.CreateTempViewUsingContext ctx) {
        return (LogicalPlan)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> new CreateTempViewUsing(this.visitTableIdentifier(ctx.tableIdentifier()), (Option<StructType>)Option$.MODULE$.apply((Object)ctx.colTypeList()).map((Function1 & Serializable & scala.Serializable)ctx -> this.createSchema((SqlBaseParser.ColTypeListContext)ctx)), ctx.REPLACE() != null, ctx.GLOBAL() != null, ctx.tableProvider().multipartIdentifier().getText(), (Map<String, String>)((Map)Option$.MODULE$.apply((Object)ctx.tablePropertyList()).map((Function1 & Serializable & scala.Serializable)ctx -> this.visitPropertyKeyValues((SqlBaseParser.TablePropertyListContext)ctx)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty()))));
    }

    public Seq<Seq<String>> visitNestedConstantList(SqlBaseParser.NestedConstantListContext ctx) {
        return (Seq)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> ((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(ctx.constantList()).asScala()).map((Function1 & Serializable & scala.Serializable)ctx -> this.visitConstantList((SqlBaseParser.ConstantListContext)ctx), Buffer$.MODULE$.canBuildFrom())).toSeq());
    }

    public Seq<String> visitConstantList(SqlBaseParser.ConstantListContext ctx) {
        return (Seq)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> ((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(ctx.constant()).asScala()).map((Function1 & Serializable & scala.Serializable)v -> this.visitStringConstant((SqlBaseParser.ConstantContext)v, false), Buffer$.MODULE$.canBuildFrom())).toSeq());
    }

    public LogicalPlan visitFailNativeCommand(SqlBaseParser.FailNativeCommandContext ctx) {
        return (LogicalPlan)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> {
            String keywords = ctx.unsupportedHiveNativeCommands() != null ? ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(ctx$14.unsupportedHiveNativeCommands().children).asScala()).collect((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends ParseTree, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof TerminalNode) {
                        TerminalNode terminalNode = (TerminalNode)A1;
                        object = terminalNode.getText();
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(ParseTree x1) {
                    ParseTree parseTree = x1;
                    boolean bl = parseTree instanceof TerminalNode;
                    return bl;
                }
            }, Buffer$.MODULE$.canBuildFrom())).mkString(" ") : "SET ROLE";
            return ParserUtils$.MODULE$.operationNotAllowed(keywords, (ParserRuleContext)ctx);
        });
    }

    public LogicalPlan visitManageResource(SqlBaseParser.ManageResourceContext ctx) {
        return (LogicalPlan)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> {
            LogicalPlan logicalPlan2;
            String rawArg = ParserUtils$.MODULE$.remainder((ParserRuleContext)ctx.identifier()).trim();
            Seq maybePaths = (Seq)this.strLiteralDef().findAllIn((CharSequence)rawArg).toSeq().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                String string = x0$1;
                String string2 = string.startsWith("\"") || string.startsWith("'") ? ParserUtils$.MODULE$.unescapeSQLString(string) : string;
                return string2;
            }, Seq$.MODULE$.canBuildFrom());
            int n = ctx$15.op.getType();
            switch (n) {
                case 12: {
                    LogicalPlan logicalPlan3;
                    String string = ctx.identifier().getText().toLowerCase(Locale.ROOT);
                    boolean bl = "files".equals(string) ? true : "file".equals(string);
                    if (bl) {
                        logicalPlan3 = new AddFilesCommand((Seq<String>)maybePaths);
                    } else {
                        boolean bl2 = "jars".equals(string) ? true : "jar".equals(string);
                        if (bl2) {
                            logicalPlan3 = new AddJarsCommand((Seq<String>)maybePaths);
                        } else {
                            boolean bl3 = "archives".equals(string) ? true : "archive".equals(string);
                            if (bl3) {
                                logicalPlan3 = new AddArchivesCommand((Seq<String>)maybePaths);
                            } else {
                                throw ParserUtils$.MODULE$.operationNotAllowed(new StringBuilder(25).append("ADD with resource type '").append(string).append("'").toString(), (ParserRuleContext)ctx);
                            }
                        }
                    }
                    logicalPlan2 = logicalPlan3;
                    break;
                }
                case 136: {
                    LogicalPlan logicalPlan4;
                    String string = ctx.identifier().getText().toLowerCase(Locale.ROOT);
                    boolean bl = "files".equals(string) ? true : "file".equals(string);
                    if (bl) {
                        logicalPlan4 = maybePaths.length() > 0 ? new ListFilesCommand((Seq<String>)maybePaths) : new ListFilesCommand(ListFilesCommand$.MODULE$.apply$default$1());
                    } else {
                        boolean bl4 = "jars".equals(string) ? true : "jar".equals(string);
                        if (bl4) {
                            logicalPlan4 = maybePaths.length() > 0 ? new ListJarsCommand((Seq<String>)maybePaths) : new ListJarsCommand(ListJarsCommand$.MODULE$.apply$default$1());
                        } else {
                            boolean bl5 = "archives".equals(string) ? true : "archive".equals(string);
                            if (bl5) {
                                logicalPlan4 = maybePaths.length() > 0 ? new ListArchivesCommand((Seq<String>)maybePaths) : new ListArchivesCommand(ListArchivesCommand$.MODULE$.apply$default$1());
                            } else {
                                throw ParserUtils$.MODULE$.operationNotAllowed(new StringBuilder(26).append("LIST with resource type '").append(string).append("'").toString(), (ParserRuleContext)ctx);
                            }
                        }
                    }
                    logicalPlan2 = logicalPlan4;
                    break;
                }
                default: {
                    throw ParserUtils$.MODULE$.operationNotAllowed("Other types of operation on resources", (ParserRuleContext)ctx);
                }
            }
            return logicalPlan2;
        });
    }

    private CatalogStorageFormat toStorageFormat(Option<String> location, Option<SerdeInfo> maybeSerdeInfo, ParserRuleContext ctx) {
        CatalogStorageFormat catalogStorageFormat;
        if (maybeSerdeInfo.isEmpty()) {
            catalogStorageFormat = CatalogStorageFormat$.MODULE$.empty().copy(location.map((Function1 & Serializable & scala.Serializable)str -> CatalogUtils$.MODULE$.stringToURI(str)), CatalogStorageFormat$.MODULE$.empty().copy$default$2(), CatalogStorageFormat$.MODULE$.empty().copy$default$3(), CatalogStorageFormat$.MODULE$.empty().copy$default$4(), CatalogStorageFormat$.MODULE$.empty().copy$default$5(), CatalogStorageFormat$.MODULE$.empty().copy$default$6());
        } else {
            SerdeInfo serdeInfo = (SerdeInfo)maybeSerdeInfo.get();
            if (serdeInfo.storedAs().isEmpty()) {
                Option x$1 = location.map((Function1 & Serializable & scala.Serializable)str -> CatalogUtils$.MODULE$.stringToURI(str));
                Option x$2 = serdeInfo.formatClasses().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.input());
                Option x$3 = serdeInfo.formatClasses().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.output());
                Option x$4 = serdeInfo.serde();
                Map x$52 = serdeInfo.serdeProperties();
                boolean x$62 = CatalogStorageFormat$.MODULE$.empty().copy$default$5();
                catalogStorageFormat = CatalogStorageFormat$.MODULE$.empty().copy(x$1, x$2, x$3, x$4, x$62, x$52);
            } else {
                Option<HiveSerDe> option = HiveSerDe$.MODULE$.sourceToSerDe((String)serdeInfo.storedAs().get());
                if (!(option instanceof Some)) {
                    throw ParserUtils$.MODULE$.operationNotAllowed(new StringBuilder(29).append("STORED AS with file format '").append(serdeInfo.storedAs().get()).append("'").toString(), ctx);
                }
                Some some = (Some)option;
                HiveSerDe hiveSerde = (HiveSerDe)some.value();
                Option x$7 = location.map((Function1 & Serializable & scala.Serializable)str -> CatalogUtils$.MODULE$.stringToURI(str));
                Option<String> x$8 = hiveSerde.inputFormat();
                Option<String> x$9 = hiveSerde.outputFormat();
                Option x$10 = serdeInfo.serde().orElse((Function0 & Serializable & scala.Serializable)() -> hiveSerde.serde());
                Map x$11 = serdeInfo.serdeProperties();
                boolean x$12 = CatalogStorageFormat$.MODULE$.empty().copy$default$5();
                CatalogStorageFormat catalogStorageFormat2 = CatalogStorageFormat$.MODULE$.empty().copy(x$7, x$8, x$9, x$10, x$12, x$11);
                catalogStorageFormat = catalogStorageFormat2;
            }
        }
        return catalogStorageFormat;
    }

    public LogicalPlan visitCreateTableLike(SqlBaseParser.CreateTableLikeContext ctx) {
        return (LogicalPlan)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> {
            Some some;
            SerdeInfo serdeInfo;
            TableIdentifier targetTable = this.visitTableIdentifier(ctx$16.target);
            TableIdentifier sourceTable = this.visitTableIdentifier(ctx$16.source);
            ParserUtils$.MODULE$.checkDuplicateClauses(ctx.tableProvider(), "PROVIDER", (ParserRuleContext)ctx);
            ParserUtils$.MODULE$.checkDuplicateClauses(ctx.createFileFormat(), "STORED AS/BY", (ParserRuleContext)ctx);
            ParserUtils$.MODULE$.checkDuplicateClauses(ctx.rowFormat(), "ROW FORMAT", (ParserRuleContext)ctx);
            ParserUtils$.MODULE$.checkDuplicateClauses(ctx.locationSpec(), "LOCATION", (ParserRuleContext)ctx);
            ParserUtils$.MODULE$.checkDuplicateClauses(ctx.TBLPROPERTIES(), "TBLPROPERTIES", (ParserRuleContext)ctx);
            Option provider = ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(ctx.tableProvider()).asScala()).headOption().map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.multipartIdentifier().getText());
            Option location = this.visitLocationSpecList(ctx.locationSpec());
            Option serdeInfo2 = this.getSerdeInfo(((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(ctx.rowFormat()).asScala()).toSeq(), ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(ctx.createFileFormat()).asScala()).toSeq(), (ParserRuleContext)ctx);
            if (provider.isDefined() && serdeInfo2.isDefined()) {
                throw ParserUtils$.MODULE$.operationNotAllowed(new StringBuilder(32).append("CREATE TABLE LIKE ... USING ... ").append(((SerdeInfo)serdeInfo2.get()).describe()).toString(), (ParserRuleContext)ctx);
            }
            Option option = serdeInfo2;
            if (option instanceof Some && (serdeInfo = (SerdeInfo)(some = (Some)option).value()) != null) {
                Option storedAs = serdeInfo.storedAs();
                Option formatClasses = serdeInfo.formatClasses();
                Option serde = serdeInfo.serde();
                if (storedAs.isEmpty() && formatClasses.isEmpty() && serde.isDefined()) {
                    throw QueryParsingErrors$.MODULE$.rowFormatNotUsedWithStoredAsError(ctx);
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            CatalogStorageFormat storage = this.toStorageFormat((Option<String>)location, (Option<SerdeInfo>)serdeInfo2, (ParserRuleContext)ctx);
            Map properties = (Map)Option$.MODULE$.apply((Object)ctx$16.tableProps).map((Function1 & Serializable & scala.Serializable)ctx -> this.visitPropertyKeyValues((SqlBaseParser.TablePropertyListContext)ctx)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
            Map cleanedProperties = this.cleanTableProperties((ParserRuleContext)ctx, properties);
            return new CreateTableLikeCommand(targetTable, sourceTable, storage, (Option<String>)provider, (Map<String, String>)cleanedProperties, ctx.EXISTS() != null);
        });
    }

    public ScriptInputOutputSchema withScriptIOSchema(ParserRuleContext ctx, SqlBaseParser.RowFormatContext inRowFormat, Token recordWriter, SqlBaseParser.RowFormatContext outRowFormat, Token recordReader, boolean schemaLess) {
        ScriptInputOutputSchema scriptInputOutputSchema;
        if (recordWriter != null || recordReader != null) {
            throw QueryParsingErrors$.MODULE$.useDefinedRecordReaderOrWriterClassesError(ctx);
        }
        if (!((String)this.conf().getConf(StaticSQLConf$.MODULE$.CATALOG_IMPLEMENTATION())).equals("hive")) {
            scriptInputOutputSchema = super.withScriptIOSchema(ctx, inRowFormat, recordWriter, outRowFormat, recordReader, schemaLess);
        } else {
            Tuple4 tuple4 = this.format$1(inRowFormat, "hive.script.recordreader", "org.apache.hadoop.hive.ql.exec.TextRecordReader");
            if (tuple4 == null) {
                throw new MatchError((Object)tuple4);
            }
            Seq inFormat = (Seq)tuple4._1();
            Option inSerdeClass = (Option)tuple4._2();
            Seq inSerdeProps = (Seq)tuple4._3();
            Option reader = (Option)tuple4._4();
            Tuple4 tuple42 = new Tuple4((Object)inFormat, (Object)inSerdeClass, (Object)inSerdeProps, (Object)reader);
            Tuple4 tuple43 = tuple42;
            Seq inFormat2 = (Seq)tuple43._1();
            Option inSerdeClass2 = (Option)tuple43._2();
            Seq inSerdeProps2 = (Seq)tuple43._3();
            Option reader2 = (Option)tuple43._4();
            Tuple4 tuple44 = this.format$1(outRowFormat, "hive.script.recordwriter", "org.apache.hadoop.hive.ql.exec.TextRecordWriter");
            if (tuple44 == null) {
                throw new MatchError((Object)tuple44);
            }
            Seq outFormat = (Seq)tuple44._1();
            Option outSerdeClass = (Option)tuple44._2();
            Seq outSerdeProps = (Seq)tuple44._3();
            Option writer = (Option)tuple44._4();
            Tuple4 tuple45 = new Tuple4((Object)outFormat, (Object)outSerdeClass, (Object)outSerdeProps, (Object)writer);
            Tuple4 tuple46 = tuple45;
            Seq outFormat2 = (Seq)tuple46._1();
            Option outSerdeClass2 = (Option)tuple46._2();
            Seq outSerdeProps2 = (Seq)tuple46._3();
            Option writer2 = (Option)tuple46._4();
            scriptInputOutputSchema = new ScriptInputOutputSchema(inFormat2, outFormat2, inSerdeClass2, outSerdeClass2, inSerdeProps2, outSerdeProps2, reader2, writer2, schemaLess);
        }
        return scriptInputOutputSchema;
    }

    public LogicalPlan withRepartitionByExpression(SqlBaseParser.QueryOrganizationContext ctx, Seq<Expression> expressions, LogicalPlan query) {
        return new RepartitionByExpression(expressions, query, (Option)None$.MODULE$);
    }

    public Tuple3<Object, CatalogStorageFormat, Option<String>> visitInsertOverwriteDir(SqlBaseParser.InsertOverwriteDirContext ctx) {
        return (Tuple3)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> {
            Map options = (Map)Option$.MODULE$.apply((Object)ctx$17.options).map((Function1 & Serializable & scala.Serializable)ctx -> this.visitPropertyKeyValues((SqlBaseParser.TablePropertyListContext)ctx)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
            CatalogStorageFormat storage = DataSource$.MODULE$.buildStorageFormatFromOptions((Map<String, String>)options);
            String path = (String)Option$.MODULE$.apply((Object)ctx$17.path).map((Function1 & Serializable & scala.Serializable)token -> ParserUtils$.MODULE$.string(token)).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
            if (!(path.isEmpty() ^ storage.locationUri().isEmpty())) {
                throw QueryParsingErrors$.MODULE$.directoryPathAndOptionsPathBothSpecifiedError(ctx);
            }
            if (!path.isEmpty()) {
                Some customLocation = new Some((Object)CatalogUtils$.MODULE$.stringToURI(path));
                CatalogStorageFormat qual$1 = storage;
                Some x$1 = customLocation;
                Option x$2 = qual$1.copy$default$2();
                Option x$3 = qual$1.copy$default$3();
                Option x$4 = qual$1.copy$default$4();
                boolean x$5 = qual$1.copy$default$5();
                Map x$6 = qual$1.copy$default$6();
                storage = qual$1.copy((Option)x$1, x$2, x$3, x$4, x$5, x$6);
            }
            if (ctx.LOCAL() != null) {
                Some some;
                String pathScheme;
                Option scheme = Option$.MODULE$.apply((Object)((URI)storage.locationUri().get()).getScheme());
                Option option = scheme;
                if (option instanceof Some && !(pathScheme = (String)(some = (Some)option).value()).equals("file")) {
                    throw QueryParsingErrors$.MODULE$.unsupportedLocalFileSchemeError(ctx);
                }
                Some loc = new Some((Object)UriBuilder.fromUri((URI)CatalogUtils$.MODULE$.stringToURI(path)).scheme("file").build(new Object[0]));
                CatalogStorageFormat qual$2 = storage;
                Some x$7 = loc;
                Option x$8 = qual$2.copy$default$2();
                Option x$9 = qual$2.copy$default$3();
                Option x$10 = qual$2.copy$default$4();
                boolean x$11 = qual$2.copy$default$5();
                Map x$12 = qual$2.copy$default$6();
                storage = qual$2.copy((Option)x$7, x$8, x$9, x$10, x$11, x$12);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            String provider = ctx.tableProvider().multipartIdentifier().getText();
            return new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)storage, (Object)new Some((Object)provider));
        });
    }

    public Tuple3<Object, CatalogStorageFormat, Option<String>> visitInsertOverwriteHiveDir(SqlBaseParser.InsertOverwriteHiveDirContext ctx) {
        return (Tuple3)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> {
            Option serdeInfo = this.getSerdeInfo(Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)ctx.rowFormat())).toSeq(), Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)ctx.createFileFormat())).toSeq(), (ParserRuleContext)ctx);
            String path = ParserUtils$.MODULE$.string(ctx$18.path);
            if (path.isEmpty()) {
                throw ParserUtils$.MODULE$.operationNotAllowed("INSERT OVERWRITE DIRECTORY must be accompanied by path", (ParserRuleContext)ctx);
            }
            CatalogStorageFormat catalogStorageFormat = HiveSerDe$.MODULE$.getDefaultStorage(this.conf());
            CatalogStorageFormat storage = this.toStorageFormat((Option<String>)new Some((Object)path), (Option<SerdeInfo>)serdeInfo, (ParserRuleContext)ctx);
            Option x$1 = storage.inputFormat().orElse((Function0 & Serializable & scala.Serializable)() -> catalogStorageFormat.inputFormat());
            Option x$2 = storage.outputFormat().orElse((Function0 & Serializable & scala.Serializable)() -> catalogStorageFormat.outputFormat());
            Option x$3 = storage.serde().orElse((Function0 & Serializable & scala.Serializable)() -> catalogStorageFormat.serde());
            Option x$4 = storage.copy$default$1();
            boolean x$5 = storage.copy$default$5();
            Map x$6 = storage.copy$default$6();
            CatalogStorageFormat finalStorage = storage.copy(x$4, x$1, x$2, x$3, x$5, x$6);
            return new Tuple3((Object)BoxesRunTime.boxToBoolean((ctx.LOCAL() != null ? 1 : 0) != 0), (Object)finalStorage, (Object)new Some((Object)DDLUtils$.MODULE$.HIVE_PROVIDER()));
        });
    }

    private final Tuple4 format$1(SqlBaseParser.RowFormatContext fmt, String configKey, String defaultConfigValue) {
        Tuple4 tuple4;
        block6: {
            SqlBaseParser.RowFormatContext rowFormatContext;
            block7: {
                Map props;
                Option option;
                block9: {
                    SerdeInfo serdeInfo;
                    block8: {
                        block5: {
                            rowFormatContext = fmt;
                            if (!(rowFormatContext instanceof SqlBaseParser.RowFormatDelimitedContext)) break block5;
                            SqlBaseParser.RowFormatDelimitedContext rowFormatDelimitedContext = (SqlBaseParser.RowFormatDelimitedContext)rowFormatContext;
                            tuple4 = this.getRowFormatDelimited(rowFormatDelimitedContext);
                            break block6;
                        }
                        if (!(rowFormatContext instanceof SqlBaseParser.RowFormatSerdeContext)) break block7;
                        SqlBaseParser.RowFormatSerdeContext rowFormatSerdeContext = (SqlBaseParser.RowFormatSerdeContext)rowFormatContext;
                        serdeInfo = this.visitRowFormatSerde(rowFormatSerdeContext);
                        if (serdeInfo == null) break block8;
                        Option option2 = serdeInfo.storedAs();
                        Option option3 = serdeInfo.formatClasses();
                        option = serdeInfo.serde();
                        props = serdeInfo.serdeProperties();
                        if (None$.MODULE$.equals(option2) && None$.MODULE$.equals(option3) && option instanceof Some) break block9;
                    }
                    throw new MatchError((Object)serdeInfo);
                }
                Some some = (Some)option;
                String name = (String)some.value();
                Tuple2 tuple2 = new Tuple2((Object)name, (Object)props);
                Tuple2 tuple22 = tuple2;
                String name2 = (String)tuple22._1();
                Map props2 = (Map)tuple22._2();
                String string = name2;
                String string2 = "org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe";
                None$ recordHandler = !(string != null ? !string.equals(string2) : string2 != null) ? Option$.MODULE$.apply((Object)this.conf().getConfString(configKey, defaultConfigValue)) : None$.MODULE$;
                Map finalProps = props2.$plus$plus((GenTraversableOnce)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"field.delim"), props2.getOrElse((Object)"field.delim", (Function0 & Serializable & scala.Serializable)() -> "\t")), (List)Nil$.MODULE$));
                tuple4 = new Tuple4((Object)Nil$.MODULE$, (Object)Option$.MODULE$.apply((Object)name2), (Object)finalProps.toSeq(), (Object)recordHandler);
                break block6;
            }
            if (rowFormatContext == null) {
                String name = this.conf().getConfString("hive.script.serde", "org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe");
                Seq props = (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"field.delim"), (Object)"\t"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"serialization.last.column.takes.rest"), (Object)"true"), (List)Nil$.MODULE$));
                Option recordHandler = Option$.MODULE$.apply((Object)this.conf().getConfString(configKey, defaultConfigValue));
                tuple4 = new Tuple4((Object)Nil$.MODULE$, (Object)Option$.MODULE$.apply((Object)name), (Object)props, (Object)recordHandler);
            } else {
                throw new MatchError((Object)rowFormatContext);
            }
        }
        return tuple4;
    }
}

