/*
 * Decompiled with CFR 0.152.
 */
package test.org.apache.spark.sql.connector;

import java.io.IOException;
import java.util.Arrays;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.connector.TestingV2Source;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.expressions.Expressions;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.sql.connector.read.ScanBuilder;
import org.apache.spark.sql.connector.read.SupportsReportPartitioning;
import org.apache.spark.sql.connector.read.partitioning.ClusteredDistribution;
import org.apache.spark.sql.connector.read.partitioning.Distribution;
import org.apache.spark.sql.connector.read.partitioning.Partitioning;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import test.org.apache.spark.sql.connector.JavaSimpleBatchTable;
import test.org.apache.spark.sql.connector.JavaSimpleScanBuilder;

public class JavaPartitionAwareDataSource
implements TestingV2Source {
    @Override
    public Table getTable(CaseInsensitiveStringMap options) {
        return new JavaSimpleBatchTable(){

            public Transform[] partitioning() {
                return new Transform[]{Expressions.identity((String)"i")};
            }

            public ScanBuilder newScanBuilder(CaseInsensitiveStringMap options) {
                return new MyScanBuilder();
            }
        };
    }

    static class SpecificReaderFactory
    implements PartitionReaderFactory {
        SpecificReaderFactory() {
        }

        public PartitionReader<InternalRow> createReader(InputPartition partition) {
            final SpecificInputPartition p = (SpecificInputPartition)partition;
            return new PartitionReader<InternalRow>(){
                private int current = -1;

                public boolean next() throws IOException {
                    ++this.current;
                    return this.current < p.i.length;
                }

                public InternalRow get() {
                    return new GenericInternalRow(new Object[]{p.i[this.current], p.j[this.current]});
                }

                public void close() throws IOException {
                }
            };
        }
    }

    static class SpecificInputPartition
    implements InputPartition {
        int[] i;
        int[] j;

        SpecificInputPartition(int[] i, int[] j) {
            assert (i.length == j.length);
            this.i = i;
            this.j = j;
        }
    }

    static class MyPartitioning
    implements Partitioning {
        MyPartitioning() {
        }

        public int numPartitions() {
            return 2;
        }

        public boolean satisfy(Distribution distribution) {
            if (distribution instanceof ClusteredDistribution) {
                String[] clusteredCols = ((ClusteredDistribution)distribution).clusteredColumns;
                return Arrays.asList(clusteredCols).contains("i");
            }
            return false;
        }
    }

    class MyScanBuilder
    extends JavaSimpleScanBuilder
    implements SupportsReportPartitioning {
        MyScanBuilder() {
        }

        public InputPartition[] planInputPartitions() {
            InputPartition[] partitions = new InputPartition[]{new SpecificInputPartition(new int[]{1, 1, 3}, new int[]{4, 4, 6}), new SpecificInputPartition(new int[]{2, 4, 4}, new int[]{6, 2, 2})};
            return partitions;
        }

        @Override
        public PartitionReaderFactory createReaderFactory() {
            return new SpecificReaderFactory();
        }

        public Partitioning outputPartitioning() {
            return new MyPartitioning();
        }
    }
}

