/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.ExplainSuiteHelper;
import org.apache.spark.sql.QueryTest;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.CannotReplaceMissingTableException;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.ExplainMode;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2ScanRelation;
import org.apache.spark.sql.execution.datasources.v2.jdbc.JDBCTableCatalog;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.jdbc.JDBCV2Suite$;
import org.apache.spark.sql.test.SQLTestData;
import org.apache.spark.sql.test.SQLTestData$internalImplicits$;
import org.apache.spark.sql.test.SQLTestUtils;
import org.apache.spark.sql.test.SQLTestUtilsBase;
import org.apache.spark.sql.test.SQLTestUtilsBase$testImplicits$;
import org.apache.spark.sql.test.SharedSparkSession;
import org.apache.spark.sql.test.SharedSparkSessionBase;
import org.apache.spark.sql.test.TestSparkSession;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Tag;
import org.scalatest.concurrent.AbstractPatienceConfiguration;
import org.scalatest.concurrent.AbstractPatienceConfiguration$PatienceConfig$;
import org.scalatest.concurrent.Eventually;
import org.scalatest.concurrent.PatienceConfiguration;
import org.scalatest.concurrent.ScaledTimeSpans;
import org.scalatest.enablers.Retrying;
import org.scalatest.funsuite.AnyFunSuiteLike;
import org.scalatest.time.Span;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.PartialFunction;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001I4A!\u0004\b\u00013!)q\u0005\u0001C\u0001Q!91\u0006\u0001b\u0001\n\u0003a\u0003BB\u001b\u0001A\u0003%Q\u0006C\u00047\u0001\t\u0007I\u0011A\u001c\t\r\u0015\u0003\u0001\u0015!\u00039\u0011\u001d1\u0005\u00011A\u0005\u0002\u001dCq!\u0014\u0001A\u0002\u0013\u0005a\n\u0003\u0004V\u0001\u0001\u0006K\u0001\u0013\u0005\u0006-\u0002!\te\u0016\u0005\u00069\u0002!I!\u0018\u0005\u0006_\u0002!\t\u0005\u001d\u0005\u0006c\u0002!\t\u0005\u001d\u0002\f\u0015\u0012\u00135I\u0016\u001aTk&$XM\u0003\u0002\u0010!\u0005!!\u000e\u001a2d\u0015\t\t\"#A\u0002tc2T!a\u0005\u000b\u0002\u000bM\u0004\u0018M]6\u000b\u0005U1\u0012AB1qC\u000eDWMC\u0001\u0018\u0003\ry'oZ\u0002\u0001'\u0011\u0001!D\b\u0013\u0011\u0005maR\"\u0001\t\n\u0005u\u0001\"!C)vKJLH+Z:u!\ty\"%D\u0001!\u0015\t\t\u0003#\u0001\u0003uKN$\u0018BA\u0012!\u0005I\u0019\u0006.\u0019:fIN\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005m)\u0013B\u0001\u0014\u0011\u0005I)\u0005\u0010\u001d7bS:\u001cV/\u001b;f\u0011\u0016d\u0007/\u001a:\u0002\rqJg.\u001b;?)\u0005I\u0003C\u0001\u0016\u0001\u001b\u0005q\u0011a\u0002;f[B$\u0015N]\u000b\u0002[A\u0011afM\u0007\u0002_)\u0011\u0001'M\u0001\u0003S>T\u0011AM\u0001\u0005U\u00064\u0018-\u0003\u00025_\t!a)\u001b7f\u0003!!X-\u001c9ESJ\u0004\u0013aA;sYV\t\u0001\b\u0005\u0002:\u0005:\u0011!\b\u0011\t\u0003wyj\u0011\u0001\u0010\u0006\u0003{a\ta\u0001\u0010:p_Rt$\"A \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005s\u0014A\u0002)sK\u0012,g-\u0003\u0002D\t\n11\u000b\u001e:j]\u001eT!!\u0011 \u0002\tU\u0014H\u000eI\u0001\u0005G>tg.F\u0001I!\tI5*D\u0001K\u0015\t\t\u0012'\u0003\u0002M\u0015\nQ1i\u001c8oK\u000e$\u0018n\u001c8\u0002\u0011\r|gN\\0%KF$\"aT*\u0011\u0005A\u000bV\"\u0001 \n\u0005Is$\u0001B+oSRDq\u0001V\u0004\u0002\u0002\u0003\u0007\u0001*A\u0002yIE\nQaY8o]\u0002\n\u0011b\u001d9be.\u001cuN\u001c4\u0016\u0003a\u0003\"!\u0017.\u000e\u0003II!a\u0017\n\u0003\u0013M\u0003\u0018M]6D_:4\u0017AD<ji\"\u001cuN\u001c8fGRLwN\\\u000b\u0003=\u0006$\"a\u00186\u0011\u0005\u0001\fG\u0002\u0001\u0003\u0006E*\u0011\ra\u0019\u0002\u0002)F\u0011Am\u001a\t\u0003!\u0016L!A\u001a \u0003\u000f9{G\u000f[5oOB\u0011\u0001\u000b[\u0005\u0003Sz\u00121!\u00118z\u0011\u0015Y'\u00021\u0001m\u0003\u00051\u0007\u0003\u0002)n\u0011~K!A\u001c \u0003\u0013\u0019+hn\u0019;j_:\f\u0014!\u00032fM>\u0014X-\u00117m)\u0005y\u0015\u0001C1gi\u0016\u0014\u0018\t\u001c7")
public class JDBCV2Suite
extends QueryTest
implements ExplainSuiteHelper {
    private final File tempDir;
    private final String url;
    private Connection conn;
    private final boolean enableAutoThreadAudit;
    private TestSparkSession org$apache$spark$sql$test$SharedSparkSessionBase$$_spark;
    private boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    private Function1<String, Dataset<Row>> sql;
    private volatile SQLTestUtilsBase$testImplicits$ testImplicits$module;
    private volatile SQLTestData$internalImplicits$ internalImplicits$module;
    private Dataset<Row> emptyTestData;
    private Dataset<Row> testData;
    private Dataset<Row> testData2;
    private Dataset<Row> testData3;
    private Dataset<Row> negativeData;
    private Dataset<Row> largeAndSmallInts;
    private Dataset<Row> decimalData;
    private Dataset<Row> binaryData;
    private Dataset<Row> upperCaseData;
    private Dataset<Row> lowerCaseData;
    private Dataset<Row> lowerCaseDataWithDuplicates;
    private RDD<SQLTestData.ArrayData> arrayData;
    private RDD<SQLTestData.MapData> mapData;
    private RDD<SQLTestData.IntervalData> calendarIntervalData;
    private RDD<SQLTestData.StringData> repeatedData;
    private RDD<SQLTestData.StringData> nullableRepeatedData;
    private Dataset<Row> nullInts;
    private Dataset<Row> allNulls;
    private Dataset<Row> nullStrings;
    private Dataset<Row> tableName;
    private RDD<String> unparsedStrings;
    private RDD<SQLTestData.IntField> withEmptyParts;
    private Dataset<Row> person;
    private Dataset<Row> salary;
    private Dataset<Row> complexData;
    private Dataset<Row> courseSales;
    private Dataset<Row> trainingSales;
    private Dataset<Row> intervalData;
    private final AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    private volatile AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig$module;
    private volatile int bitmap$0;

    @Override
    public String getNormalizedExplain(Dataset<Row> df, ExplainMode mode) {
        return ExplainSuiteHelper.getNormalizedExplain$(this, df, mode);
    }

    @Override
    public void withNormalizedExplain(Dataset<Row> df, ExplainMode mode, Function1<String, BoxedUnit> f) {
        ExplainSuiteHelper.withNormalizedExplain$(this, df, mode, f);
    }

    @Override
    public void withNormalizedExplain(String queryText, Function1<String, BoxedUnit> f) {
        ExplainSuiteHelper.withNormalizedExplain$(this, queryText, f);
    }

    @Override
    public void checkKeywordsExistsInExplain(Dataset<Row> df, ExplainMode mode, Seq<String> keywords) {
        ExplainSuiteHelper.checkKeywordsExistsInExplain$(this, df, mode, keywords);
    }

    @Override
    public void checkKeywordsExistsInExplain(Dataset<Row> df, Seq<String> keywords) {
        ExplainSuiteHelper.checkKeywordsExistsInExplain$(this, df, keywords);
    }

    @Override
    public void checkKeywordsNotExistsInExplain(Dataset<Row> df, ExplainMode mode, Seq<String> keywords) {
        ExplainSuiteHelper.checkKeywordsNotExistsInExplain$(this, df, mode, keywords);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$beforeAll() {
        SharedSparkSessionBase.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$afterAll() {
        SharedSparkSessionBase.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$beforeAll() {
        SQLTestUtils.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    @Override
    public SparkSession spark() {
        return SharedSparkSessionBase.spark$(this);
    }

    @Override
    public SQLContext sqlContext() {
        return SharedSparkSessionBase.sqlContext$(this);
    }

    @Override
    public TestSparkSession createSparkSession() {
        return SharedSparkSessionBase.createSparkSession$(this);
    }

    @Override
    public void initializeSession() {
        SharedSparkSessionBase.initializeSession$(this);
    }

    @Override
    public void beforeEach() {
        SharedSparkSessionBase.beforeEach$(this);
    }

    @Override
    public void afterEach() {
        SharedSparkSessionBase.afterEach$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$withTempDir(Function1 f) {
        super.withTempDir(f);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$test(String testName, Seq testTags, Function0 testFun, Position pos) {
        AnyFunSuiteLike.test$((AnyFunSuiteLike)this, (String)testName, (Seq)testTags, (Function0)testFun, (Position)pos);
    }

    @Override
    public void withTempDir(Function1<File, BoxedUnit> f) {
        SQLTestUtils.withTempDir$(this, f);
    }

    @Override
    public void testWithWholeStageCodegenOnAndOff(String testName, Function1<String, BoxedUnit> f) {
        SQLTestUtils.testWithWholeStageCodegenOnAndOff$(this, testName, f);
    }

    @Override
    public void setupTestData() {
        SQLTestUtils.setupTestData$(this);
    }

    @Override
    public void testQuietly(String name, Function0<BoxedUnit> f) {
        SQLTestUtils.testQuietly$(this, name, f);
    }

    @Override
    public void test(String testName, Seq<Tag> testTags, Function0<Object> testFun, Position pos) {
        SQLTestUtils.test$(this, testName, testTags, testFun, pos);
    }

    @Override
    public void testWithUninterruptibleThread(String name, boolean quietly, Function0<BoxedUnit> body) {
        SQLTestUtils.testWithUninterruptibleThread$(this, name, quietly, body);
    }

    @Override
    public boolean testWithUninterruptibleThread$default$2() {
        return SQLTestUtils.testWithUninterruptibleThread$default$2$(this);
    }

    @Override
    public void withResourceTempPath(String resourcePath, Function1<File, BoxedUnit> f) {
        SQLTestUtils.withResourceTempPath$(this, resourcePath, f);
    }

    @Override
    public void waitForTasksToFinish() {
        SQLTestUtils.waitForTasksToFinish$(this);
    }

    @Override
    public void withTempPaths(int numPaths, Function1<Seq<File>, BoxedUnit> f) {
        SQLTestUtils.withTempPaths$(this, numPaths, f);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtilsBase$$super$withSQLConf(Seq pairs, Function0 f) {
        SQLHelper.withSQLConf$((SQLHelper)this, (Seq)pairs, (Function0)f);
    }

    @Override
    public SparkContext sparkContext() {
        return SQLTestUtilsBase.sparkContext$(this);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withUserDefinedFunction(Seq<Tuple2<String, Object>> functions, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withUserDefinedFunction$(this, functions, f);
    }

    @Override
    public void withTempView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withTempView$(this, viewNames, f);
    }

    @Override
    public void withGlobalTempView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withGlobalTempView$(this, viewNames, f);
    }

    @Override
    public void withTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withTable$(this, tableNames, f);
    }

    @Override
    public void withView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withView$(this, viewNames, f);
    }

    @Override
    public void withCache(Seq<String> cacheNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withCache$(this, cacheNames, f);
    }

    @Override
    public void uncacheTable(String tableName) {
        SQLTestUtilsBase.uncacheTable$(this, tableName);
    }

    @Override
    public void withTempDatabase(Function1<String, BoxedUnit> f) {
        SQLTestUtilsBase.withTempDatabase$(this, f);
    }

    @Override
    public void withDatabase(Seq<String> dbNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withDatabase$(this, dbNames, f);
    }

    @Override
    public void withNamespace(Seq<String> namespaces, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withNamespace$(this, namespaces, f);
    }

    @Override
    public void withLocale(String language, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withLocale$(this, language, f);
    }

    @Override
    public void activateDatabase(String db, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.activateDatabase$(this, db, f);
    }

    @Override
    public Dataset<Row> stripSparkFilter(Dataset<Row> df) {
        return SQLTestUtilsBase.stripSparkFilter$(this, df);
    }

    @Override
    public Dataset<Row> logicalPlanToSparkQuery(LogicalPlan plan) {
        return SQLTestUtilsBase.logicalPlanToSparkQuery$(this, plan);
    }

    @Override
    public URI makeQualifiedPath(String path) {
        return SQLTestUtilsBase.makeQualifiedPath$(this, path);
    }

    @Override
    public String testFile(String fileName) {
        return SQLTestUtilsBase.testFile$(this, fileName);
    }

    @Override
    public long getLocalDirSize(File file) {
        return SQLTestUtilsBase.getLocalDirSize$(this, file);
    }

    @Override
    public void loadTestData() {
        SQLTestData.loadTestData$(this);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, PatienceConfiguration.Interval interval, Function0<T> fun, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, (PatienceConfiguration.Interval)interval, fun, retrying, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Interval interval, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Interval)interval, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public <T> T eventually(Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public AbstractPatienceConfiguration.PatienceConfig patienceConfig() {
        return PatienceConfiguration.patienceConfig$((PatienceConfiguration)this);
    }

    public PatienceConfiguration.Timeout timeout(Span value) {
        return PatienceConfiguration.timeout$((PatienceConfiguration)this, (Span)value);
    }

    public PatienceConfiguration.Interval interval(Span value) {
        return PatienceConfiguration.interval$((PatienceConfiguration)this, (Span)value);
    }

    public final Span scaled(Span span) {
        return ScaledTimeSpans.scaled$((ScaledTimeSpans)this, (Span)span);
    }

    public double spanScaleFactor() {
        return ScaledTimeSpans.spanScaleFactor$((ScaledTimeSpans)this);
    }

    @Override
    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSparkSession$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    @Override
    public TestSparkSession org$apache$spark$sql$test$SharedSparkSessionBase$$_spark() {
        return this.org$apache$spark$sql$test$SharedSparkSessionBase$$_spark;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSparkSessionBase$$_spark_$eq(TestSparkSession x$1) {
        this.org$apache$spark$sql$test$SharedSparkSessionBase$$_spark = x$1;
    }

    @Override
    public boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests() {
        return this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    }

    @Override
    public void org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests_$eq(boolean x$1) {
        this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests = x$1;
    }

    private Function1<String, Dataset<Row>> sql$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 1) == 0) {
                this.sql = SQLTestUtilsBase.sql$(this);
                this.bitmap$0 |= 1;
            }
        }
        return this.sql;
    }

    @Override
    public Function1<String, Dataset<Row>> sql() {
        return (this.bitmap$0 & 1) == 0 ? this.sql$lzycompute() : this.sql;
    }

    @Override
    public SQLTestUtilsBase$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public SQLTestData$internalImplicits$ org$apache$spark$sql$test$SQLTestData$$internalImplicits() {
        if (this.internalImplicits$module == null) {
            this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute$1();
        }
        return this.internalImplicits$module;
    }

    private Dataset<Row> emptyTestData$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 2) == 0) {
                this.emptyTestData = SQLTestData.emptyTestData$(this);
                this.bitmap$0 |= 2;
            }
        }
        return this.emptyTestData;
    }

    @Override
    public Dataset<Row> emptyTestData() {
        return (this.bitmap$0 & 2) == 0 ? this.emptyTestData$lzycompute() : this.emptyTestData;
    }

    private Dataset<Row> testData$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 4) == 0) {
                this.testData = SQLTestData.testData$(this);
                this.bitmap$0 |= 4;
            }
        }
        return this.testData;
    }

    @Override
    public Dataset<Row> testData() {
        return (this.bitmap$0 & 4) == 0 ? this.testData$lzycompute() : this.testData;
    }

    private Dataset<Row> testData2$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 8) == 0) {
                this.testData2 = SQLTestData.testData2$(this);
                this.bitmap$0 |= 8;
            }
        }
        return this.testData2;
    }

    @Override
    public Dataset<Row> testData2() {
        return (this.bitmap$0 & 8) == 0 ? this.testData2$lzycompute() : this.testData2;
    }

    private Dataset<Row> testData3$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.testData3 = SQLTestData.testData3$(this);
                this.bitmap$0 |= 0x10;
            }
        }
        return this.testData3;
    }

    @Override
    public Dataset<Row> testData3() {
        return (this.bitmap$0 & 0x10) == 0 ? this.testData3$lzycompute() : this.testData3;
    }

    private Dataset<Row> negativeData$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.negativeData = SQLTestData.negativeData$(this);
                this.bitmap$0 |= 0x20;
            }
        }
        return this.negativeData;
    }

    @Override
    public Dataset<Row> negativeData() {
        return (this.bitmap$0 & 0x20) == 0 ? this.negativeData$lzycompute() : this.negativeData;
    }

    private Dataset<Row> largeAndSmallInts$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.largeAndSmallInts = SQLTestData.largeAndSmallInts$(this);
                this.bitmap$0 |= 0x40;
            }
        }
        return this.largeAndSmallInts;
    }

    @Override
    public Dataset<Row> largeAndSmallInts() {
        return (this.bitmap$0 & 0x40) == 0 ? this.largeAndSmallInts$lzycompute() : this.largeAndSmallInts;
    }

    private Dataset<Row> decimalData$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.decimalData = SQLTestData.decimalData$(this);
                this.bitmap$0 |= 0x80;
            }
        }
        return this.decimalData;
    }

    @Override
    public Dataset<Row> decimalData() {
        return (this.bitmap$0 & 0x80) == 0 ? this.decimalData$lzycompute() : this.decimalData;
    }

    private Dataset<Row> binaryData$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.binaryData = SQLTestData.binaryData$(this);
                this.bitmap$0 |= 0x100;
            }
        }
        return this.binaryData;
    }

    @Override
    public Dataset<Row> binaryData() {
        return (this.bitmap$0 & 0x100) == 0 ? this.binaryData$lzycompute() : this.binaryData;
    }

    private Dataset<Row> upperCaseData$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.upperCaseData = SQLTestData.upperCaseData$(this);
                this.bitmap$0 |= 0x200;
            }
        }
        return this.upperCaseData;
    }

    @Override
    public Dataset<Row> upperCaseData() {
        return (this.bitmap$0 & 0x200) == 0 ? this.upperCaseData$lzycompute() : this.upperCaseData;
    }

    private Dataset<Row> lowerCaseData$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.lowerCaseData = SQLTestData.lowerCaseData$(this);
                this.bitmap$0 |= 0x400;
            }
        }
        return this.lowerCaseData;
    }

    @Override
    public Dataset<Row> lowerCaseData() {
        return (this.bitmap$0 & 0x400) == 0 ? this.lowerCaseData$lzycompute() : this.lowerCaseData;
    }

    private Dataset<Row> lowerCaseDataWithDuplicates$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.lowerCaseDataWithDuplicates = SQLTestData.lowerCaseDataWithDuplicates$(this);
                this.bitmap$0 |= 0x800;
            }
        }
        return this.lowerCaseDataWithDuplicates;
    }

    @Override
    public Dataset<Row> lowerCaseDataWithDuplicates() {
        return (this.bitmap$0 & 0x800) == 0 ? this.lowerCaseDataWithDuplicates$lzycompute() : this.lowerCaseDataWithDuplicates;
    }

    private RDD<SQLTestData.ArrayData> arrayData$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.arrayData = SQLTestData.arrayData$(this);
                this.bitmap$0 |= 0x1000;
            }
        }
        return this.arrayData;
    }

    @Override
    public RDD<SQLTestData.ArrayData> arrayData() {
        return (this.bitmap$0 & 0x1000) == 0 ? this.arrayData$lzycompute() : this.arrayData;
    }

    private RDD<SQLTestData.MapData> mapData$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 0x2000) == 0) {
                this.mapData = SQLTestData.mapData$(this);
                this.bitmap$0 |= 0x2000;
            }
        }
        return this.mapData;
    }

    @Override
    public RDD<SQLTestData.MapData> mapData() {
        return (this.bitmap$0 & 0x2000) == 0 ? this.mapData$lzycompute() : this.mapData;
    }

    private RDD<SQLTestData.IntervalData> calendarIntervalData$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 0x4000) == 0) {
                this.calendarIntervalData = SQLTestData.calendarIntervalData$(this);
                this.bitmap$0 |= 0x4000;
            }
        }
        return this.calendarIntervalData;
    }

    @Override
    public RDD<SQLTestData.IntervalData> calendarIntervalData() {
        return (this.bitmap$0 & 0x4000) == 0 ? this.calendarIntervalData$lzycompute() : this.calendarIntervalData;
    }

    private RDD<SQLTestData.StringData> repeatedData$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 0x8000) == 0) {
                this.repeatedData = SQLTestData.repeatedData$(this);
                this.bitmap$0 |= 0x8000;
            }
        }
        return this.repeatedData;
    }

    @Override
    public RDD<SQLTestData.StringData> repeatedData() {
        return (this.bitmap$0 & 0x8000) == 0 ? this.repeatedData$lzycompute() : this.repeatedData;
    }

    private RDD<SQLTestData.StringData> nullableRepeatedData$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 0x10000) == 0) {
                this.nullableRepeatedData = SQLTestData.nullableRepeatedData$(this);
                this.bitmap$0 |= 0x10000;
            }
        }
        return this.nullableRepeatedData;
    }

    @Override
    public RDD<SQLTestData.StringData> nullableRepeatedData() {
        return (this.bitmap$0 & 0x10000) == 0 ? this.nullableRepeatedData$lzycompute() : this.nullableRepeatedData;
    }

    private Dataset<Row> nullInts$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 0x20000) == 0) {
                this.nullInts = SQLTestData.nullInts$(this);
                this.bitmap$0 |= 0x20000;
            }
        }
        return this.nullInts;
    }

    @Override
    public Dataset<Row> nullInts() {
        return (this.bitmap$0 & 0x20000) == 0 ? this.nullInts$lzycompute() : this.nullInts;
    }

    private Dataset<Row> allNulls$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 0x40000) == 0) {
                this.allNulls = SQLTestData.allNulls$(this);
                this.bitmap$0 |= 0x40000;
            }
        }
        return this.allNulls;
    }

    @Override
    public Dataset<Row> allNulls() {
        return (this.bitmap$0 & 0x40000) == 0 ? this.allNulls$lzycompute() : this.allNulls;
    }

    private Dataset<Row> nullStrings$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 0x80000) == 0) {
                this.nullStrings = SQLTestData.nullStrings$(this);
                this.bitmap$0 |= 0x80000;
            }
        }
        return this.nullStrings;
    }

    @Override
    public Dataset<Row> nullStrings() {
        return (this.bitmap$0 & 0x80000) == 0 ? this.nullStrings$lzycompute() : this.nullStrings;
    }

    private Dataset<Row> tableName$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 0x100000) == 0) {
                this.tableName = SQLTestData.tableName$(this);
                this.bitmap$0 |= 0x100000;
            }
        }
        return this.tableName;
    }

    @Override
    public Dataset<Row> tableName() {
        return (this.bitmap$0 & 0x100000) == 0 ? this.tableName$lzycompute() : this.tableName;
    }

    private RDD<String> unparsedStrings$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 0x200000) == 0) {
                this.unparsedStrings = SQLTestData.unparsedStrings$(this);
                this.bitmap$0 |= 0x200000;
            }
        }
        return this.unparsedStrings;
    }

    @Override
    public RDD<String> unparsedStrings() {
        return (this.bitmap$0 & 0x200000) == 0 ? this.unparsedStrings$lzycompute() : this.unparsedStrings;
    }

    private RDD<SQLTestData.IntField> withEmptyParts$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 0x400000) == 0) {
                this.withEmptyParts = SQLTestData.withEmptyParts$(this);
                this.bitmap$0 |= 0x400000;
            }
        }
        return this.withEmptyParts;
    }

    @Override
    public RDD<SQLTestData.IntField> withEmptyParts() {
        return (this.bitmap$0 & 0x400000) == 0 ? this.withEmptyParts$lzycompute() : this.withEmptyParts;
    }

    private Dataset<Row> person$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 0x800000) == 0) {
                this.person = SQLTestData.person$(this);
                this.bitmap$0 |= 0x800000;
            }
        }
        return this.person;
    }

    @Override
    public Dataset<Row> person() {
        return (this.bitmap$0 & 0x800000) == 0 ? this.person$lzycompute() : this.person;
    }

    private Dataset<Row> salary$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 0x1000000) == 0) {
                this.salary = SQLTestData.salary$(this);
                this.bitmap$0 |= 0x1000000;
            }
        }
        return this.salary;
    }

    @Override
    public Dataset<Row> salary() {
        return (this.bitmap$0 & 0x1000000) == 0 ? this.salary$lzycompute() : this.salary;
    }

    private Dataset<Row> complexData$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 0x2000000) == 0) {
                this.complexData = SQLTestData.complexData$(this);
                this.bitmap$0 |= 0x2000000;
            }
        }
        return this.complexData;
    }

    @Override
    public Dataset<Row> complexData() {
        return (this.bitmap$0 & 0x2000000) == 0 ? this.complexData$lzycompute() : this.complexData;
    }

    private Dataset<Row> courseSales$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 0x4000000) == 0) {
                this.courseSales = SQLTestData.courseSales$(this);
                this.bitmap$0 |= 0x4000000;
            }
        }
        return this.courseSales;
    }

    @Override
    public Dataset<Row> courseSales() {
        return (this.bitmap$0 & 0x4000000) == 0 ? this.courseSales$lzycompute() : this.courseSales;
    }

    private Dataset<Row> trainingSales$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 0x8000000) == 0) {
                this.trainingSales = SQLTestData.trainingSales$(this);
                this.bitmap$0 |= 0x8000000;
            }
        }
        return this.trainingSales;
    }

    @Override
    public Dataset<Row> trainingSales() {
        return (this.bitmap$0 & 0x8000000) == 0 ? this.trainingSales$lzycompute() : this.trainingSales;
    }

    private Dataset<Row> intervalData$lzycompute() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if ((this.bitmap$0 & 0x10000000) == 0) {
                this.intervalData = SQLTestData.intervalData$(this);
                this.bitmap$0 |= 0x10000000;
            }
        }
        return this.intervalData;
    }

    @Override
    public Dataset<Row> intervalData() {
        return (this.bitmap$0 & 0x10000000) == 0 ? this.intervalData$lzycompute() : this.intervalData;
    }

    public AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig() {
        return this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    }

    public final void org$scalatest$concurrent$PatienceConfiguration$_setter_$org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig_$eq(AbstractPatienceConfiguration.PatienceConfig x$1) {
        this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig = x$1;
    }

    public AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig() {
        if (this.PatienceConfig$module == null) {
            this.PatienceConfig$lzycompute$1();
        }
        return this.PatienceConfig$module;
    }

    public File tempDir() {
        return this.tempDir;
    }

    public String url() {
        return this.url;
    }

    public Connection conn() {
        return this.conn;
    }

    public void conn_$eq(Connection x$1) {
        this.conn = x$1;
    }

    @Override
    public SparkConf sparkConf() {
        return SharedSparkSessionBase.sparkConf$(this).set("spark.sql.catalog.h2", JDBCTableCatalog.class.getName()).set("spark.sql.catalog.h2.url", this.url()).set("spark.sql.catalog.h2.driver", "org.h2.Driver").set("spark.sql.catalog.h2.pushDownAggregate", "true");
    }

    private <T> T withConnection(Function1<Connection, T> f) {
        Object object;
        try (Connection conn = DriverManager.getConnection(this.url(), new Properties());){
            object = f.apply((Object)conn);
        }
        return (T)object;
    }

    @Override
    public void beforeAll() {
        SharedSparkSession.beforeAll$(this);
        Utils$.MODULE$.classForName("org.h2.Driver", Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3());
        this.withConnection((Function1 & Serializable & scala.Serializable)conn -> BoxesRunTime.boxToInteger((int)JDBCV2Suite.$anonfun$beforeAll$1(conn)));
    }

    @Override
    public void afterAll() {
        Utils$.MODULE$.deleteRecursively(this.tempDir());
        SharedSparkSession.afterAll$(this);
    }

    private final void testImplicits$lzycompute$1() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new SQLTestUtilsBase$testImplicits$(this);
            }
        }
    }

    private final void org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute$1() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if (this.internalImplicits$module == null) {
                this.internalImplicits$module = new SQLTestData$internalImplicits$(this);
            }
        }
    }

    private final void PatienceConfig$lzycompute$1() {
        JDBCV2Suite jDBCV2Suite = this;
        synchronized (jDBCV2Suite) {
            if (this.PatienceConfig$module == null) {
                this.PatienceConfig$module = new AbstractPatienceConfiguration$PatienceConfig$((AbstractPatienceConfiguration)this);
            }
        }
    }

    public static final /* synthetic */ int $anonfun$beforeAll$1(Connection conn) {
        conn.prepareStatement("CREATE SCHEMA \"test\"").executeUpdate();
        conn.prepareStatement("CREATE TABLE \"test\".\"empty_table\" (name TEXT(32) NOT NULL, id INTEGER NOT NULL)").executeUpdate();
        conn.prepareStatement("CREATE TABLE \"test\".\"people\" (name TEXT(32) NOT NULL, id INTEGER NOT NULL)").executeUpdate();
        conn.prepareStatement("INSERT INTO \"test\".\"people\" VALUES ('fred', 1)").executeUpdate();
        conn.prepareStatement("INSERT INTO \"test\".\"people\" VALUES ('mary', 2)").executeUpdate();
        conn.prepareStatement("CREATE TABLE \"test\".\"employee\" (dept INTEGER, name TEXT(32), salary NUMERIC(20, 2), bonus DOUBLE)").executeUpdate();
        conn.prepareStatement("INSERT INTO \"test\".\"employee\" VALUES (1, 'amy', 10000, 1000)").executeUpdate();
        conn.prepareStatement("INSERT INTO \"test\".\"employee\" VALUES (2, 'alex', 12000, 1200)").executeUpdate();
        conn.prepareStatement("INSERT INTO \"test\".\"employee\" VALUES (1, 'cathy', 9000, 1200)").executeUpdate();
        conn.prepareStatement("INSERT INTO \"test\".\"employee\" VALUES (2, 'david', 10000, 1300)").executeUpdate();
        return conn.prepareStatement("INSERT INTO \"test\".\"employee\" VALUES (6, 'jen', 12000, 1200)").executeUpdate();
    }

    public JDBCV2Suite() {
        ScaledTimeSpans.$init$((ScaledTimeSpans)this);
        AbstractPatienceConfiguration.$init$((AbstractPatienceConfiguration)this);
        PatienceConfiguration.$init$((PatienceConfiguration)this);
        Eventually.$init$((Eventually)this);
        SQLTestData.$init$(this);
        SQLTestUtilsBase.$init$(this);
        SQLTestUtils.$init$(this);
        SharedSparkSessionBase.$init$(this);
        SharedSparkSession.$init$(this);
        ExplainSuiteHelper.$init$(this);
        this.tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
        this.url = new StringBuilder(40).append("jdbc:h2:").append(this.tempDir().getCanonicalPath()).append(";user=testUser;password=testPass").toString();
        this.conn = null;
        this.test("simple scan", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM h2.test.empty_table"), (Seq<Row>)((Seq)Nil$.MODULE$));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT * FROM h2.test.people"), (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"fred", BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"mary", BoxesRunTime.boxToInteger((int)2)})), (List)Nil$.MODULE$))));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT name, id FROM h2.test.people"), (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"fred", BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"mary", BoxesRunTime.boxToInteger((int)2)})), (List)Nil$.MODULE$))));
        }, new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
        this.test("scan with filter push-down", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq filters;
            Dataset df = this.spark().table("h2.test.people").filter(this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$).$greater((Object)BoxesRunTime.boxToInteger((int)1)));
            Seq $org_scalatest_assert_macro_left = filters = df.queryExecution().optimizedPlan().collect((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Filter filter;
                    A1 A1 = x1;
                    Object object = A1 instanceof Filter ? (filter = (Filter)A1) : function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(LogicalPlan x1) {
                    LogicalPlan logicalPlan = x1;
                    boolean bl = logicalPlan instanceof Filter;
                    return bl;
                }
            });
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
            df.queryExecution().optimizedPlan().collect((PartialFunction)new scala.Serializable(this, df){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JDBCV2Suite $outer;
                private final Dataset df$1;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x2;
                    if (A1 instanceof DataSourceV2ScanRelation) {
                        String expected_plan_fragment = "PushedFilters: [IsNotNull(ID), GreaterThan(ID,1)]";
                        this.$outer.checkKeywordsExistsInExplain((Dataset<Row>)this.df$1, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{expected_plan_fragment}));
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x2);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(LogicalPlan x2) {
                    LogicalPlan logicalPlan = x2;
                    boolean bl = logicalPlan instanceof DataSourceV2ScanRelation;
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.df$1 = df$1;
                }
            });
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> df, Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"mary", BoxesRunTime.boxToInteger((int)2)})));
        }, new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
        this.test("scan with column pruning", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Dataset df = this.spark().table("h2.test.people").select("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            DataSourceV2ScanRelation scan = (DataSourceV2ScanRelation)df.queryExecution().optimizedPlan().collectFirst((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                    DataSourceV2ScanRelation dataSourceV2ScanRelation;
                    A1 A1 = x3;
                    Object object = A1 instanceof DataSourceV2ScanRelation ? (dataSourceV2ScanRelation = (DataSourceV2ScanRelation)A1) : function1.apply(x3);
                    return (B1)object;
                }

                public final boolean isDefinedAt(LogicalPlan x3) {
                    LogicalPlan logicalPlan = x3;
                    boolean bl = logicalPlan instanceof DataSourceV2ScanRelation;
                    return bl;
                }
            }).get();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])scan.schema().names())).sameElements((GenIterable)new .colon.colon((Object)"ID", (List)Nil$.MODULE$)), "scala.Predef.refArrayOps[String](scan.schema.names).sameElements[String](scala.collection.Seq.apply[String](\"ID\"))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> df, (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)})), (List)Nil$.MODULE$))));
        }, new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
        this.test("scan with filter push-down and column pruning", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq filters;
            Dataset df = this.spark().table("h2.test.people").filter(this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$).$greater((Object)BoxesRunTime.boxToInteger((int)1))).select("name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            Seq $org_scalatest_assert_macro_left = filters = df.queryExecution().optimizedPlan().collect((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                    Filter filter;
                    A1 A1 = x4;
                    Object object = A1 instanceof Filter ? (filter = (Filter)A1) : function1.apply(x4);
                    return (B1)object;
                }

                public final boolean isDefinedAt(LogicalPlan x4) {
                    LogicalPlan logicalPlan = x4;
                    boolean bl = logicalPlan instanceof Filter;
                    return bl;
                }
            });
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
            DataSourceV2ScanRelation scan = (DataSourceV2ScanRelation)df.queryExecution().optimizedPlan().collectFirst((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                    DataSourceV2ScanRelation dataSourceV2ScanRelation;
                    A1 A1 = x5;
                    Object object = A1 instanceof DataSourceV2ScanRelation ? (dataSourceV2ScanRelation = (DataSourceV2ScanRelation)A1) : function1.apply(x5);
                    return (B1)object;
                }

                public final boolean isDefinedAt(LogicalPlan x5) {
                    LogicalPlan logicalPlan = x5;
                    boolean bl = logicalPlan instanceof DataSourceV2ScanRelation;
                    return bl;
                }
            }).get();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])scan.schema().names())).sameElements((GenIterable)new .colon.colon((Object)"NAME", (List)Nil$.MODULE$)), "scala.Predef.refArrayOps[String](scan.schema.names).sameElements[String](scala.collection.Seq.apply[String](\"NAME\"))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> df, Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"mary"})));
        }, new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
        this.test("read/write with partition info", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"h2.test.abc"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String e;
            this.sql().apply((Object)"CREATE TABLE h2.test.abc AS SELECT * FROM h2.test.people");
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(JDBCV2Suite.class.getClassLoader());
            public final class Org_apache_spark_sql_jdbc_JDBCV2Suite$$typecreator6$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_jdbc_JDBCV2Suite$$typecreator6$1(JDBCV2Suite $outer) {
                }
            }
            Dataset df1 = this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple2((Object)"evan", (Object)BoxesRunTime.boxToInteger((int)3)), (List)new .colon.colon((Object)new Tuple2((Object)"cathy", (Object)BoxesRunTime.boxToInteger((int)4)), (List)new .colon.colon((Object)new Tuple2((Object)"alex", (Object)BoxesRunTime.boxToInteger((int)5)), (List)Nil$.MODULE$))), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_jdbc_JDBCV2Suite$$typecreator6$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"NAME", "ID"}));
            String $org_scalatest_assert_macro_left = e = ((Throwable)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> df1.write().option("partitionColumn", "id").option("lowerBound", "0").option("upperBound", "3").option("numPartitions", "0").insertInto("h2.test.abc"), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138))).getMessage();
            String $org_scalatest_assert_macro_right = "Invalid value `0` for parameter `numPartitions` in table writing via JDBC. The minimum value is 1.";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
            df1.write().option("partitionColumn", "id").option("lowerBound", "0").option("upperBound", "3").option("numPartitions", "3").insertInto("h2.test.abc");
            Dataset df2 = this.spark().read().option("partitionColumn", "id").option("lowerBound", "0").option("upperBound", "3").option("numPartitions", "2").table("h2.test.abc");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)df2.rdd().getNumPartitions()));
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)df2.count()));
            int $org_scalatest_assert_macro_right3 = 5;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
        }), new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
        this.test("show tables", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SHOW TABLES IN h2.test"), (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"test", "people", BoxesRunTime.boxToBoolean((boolean)false)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"test", "empty_table", BoxesRunTime.boxToBoolean((boolean)false)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"test", "employee", BoxesRunTime.boxToBoolean((boolean)false)})), (List)Nil$.MODULE$))))), new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
        this.test("SQL API: create table as select", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"h2.test.abc"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE h2.test.abc AS SELECT * FROM h2.test.people");
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT name, id FROM h2.test.abc"), (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"fred", BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"mary", BoxesRunTime.boxToInteger((int)2)})), (List)Nil$.MODULE$))));
        }), new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
        this.test("DataFrameWriterV2: create table as select", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"h2.test.abc"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().table("h2.test.people").writeTo("h2.test.abc").create();
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT name, id FROM h2.test.abc"), (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"fred", BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"mary", BoxesRunTime.boxToInteger((int)2)})), (List)Nil$.MODULE$))));
        }), new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
        this.test("SQL API: replace table as select", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"h2.test.abc"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"REPLACE TABLE h2.test.abc AS SELECT 1 as col"), ClassTag$.MODULE$.apply(CannotReplaceMissingTableException.class), new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
            this.sql().apply((Object)"CREATE OR REPLACE TABLE h2.test.abc AS SELECT 1 as col");
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT col FROM h2.test.abc"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
            this.sql().apply((Object)"REPLACE TABLE h2.test.abc AS SELECT * FROM h2.test.people");
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT name, id FROM h2.test.abc"), (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"fred", BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"mary", BoxesRunTime.boxToInteger((int)2)})), (List)Nil$.MODULE$))));
        }), new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
        this.test("DataFrameWriterV2: replace table as select", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"h2.test.abc"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Dataset)this.sql().apply((Object)"SELECT 1 AS col")).writeTo("h2.test.abc").replace(), ClassTag$.MODULE$.apply(CannotReplaceMissingTableException.class), new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
            ((Dataset)this.sql().apply((Object)"SELECT 1 AS col")).writeTo("h2.test.abc").createOrReplace();
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT col FROM h2.test.abc"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})));
            this.spark().table("h2.test.people").writeTo("h2.test.abc").replace();
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT name, id FROM h2.test.abc"), (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"fred", BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"mary", BoxesRunTime.boxToInteger((int)2)})), (List)Nil$.MODULE$))));
        }), new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
        this.test("SQL API: insert and overwrite", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"h2.test.abc"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE h2.test.abc AS SELECT * FROM h2.test.people");
            this.sql().apply((Object)"INSERT INTO h2.test.abc SELECT 'lucy', 3");
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT name, id FROM h2.test.abc"), (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"fred", BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"mary", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"lucy", BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$)))));
            this.sql().apply((Object)"INSERT OVERWRITE h2.test.abc SELECT 'bob', 4");
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT name, id FROM h2.test.abc"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"bob", BoxesRunTime.boxToInteger((int)4)})));
        }), new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
        this.test("DataFrameWriterV2: insert and overwrite", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"h2.test.abc"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE h2.test.abc AS SELECT * FROM h2.test.people");
            ((Dataset)this.sql().apply((Object)"SELECT 3 AS ID, 'lucy' AS NAME")).writeTo("h2.test.abc").append();
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT name, id FROM h2.test.abc"), (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"fred", BoxesRunTime.boxToInteger((int)1)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"mary", BoxesRunTime.boxToInteger((int)2)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"lucy", BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$)))));
            ((Dataset)this.sql().apply((Object)"SELECT 'bob' AS NAME, 4 AS ID")).writeTo("h2.test.abc").overwrite(functions$.MODULE$.lit((Object)BoxesRunTime.boxToBoolean((boolean)true)));
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT name, id FROM h2.test.abc"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"bob", BoxesRunTime.boxToInteger((int)4)})));
        }), new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 226));
        this.test("scan with aggregate push-down: MAX MIN with filter and group by", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq filters;
            Dataset df = (Dataset)this.sql().apply((Object)"select MAX(SaLaRY), MIN(BONUS) FROM h2.test.employee where dept > 0 group by DePt");
            Seq $org_scalatest_assert_macro_left = filters = df.queryExecution().optimizedPlan().collect((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x6, Function1<A1, B1> function1) {
                    Filter filter;
                    A1 A1 = x6;
                    Object object = A1 instanceof Filter ? (filter = (Filter)A1) : function1.apply(x6);
                    return (B1)object;
                }

                public final boolean isDefinedAt(LogicalPlan x6) {
                    LogicalPlan logicalPlan = x6;
                    boolean bl = logicalPlan instanceof Filter;
                    return bl;
                }
            });
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
            df.queryExecution().optimizedPlan().collect((PartialFunction)new scala.Serializable(this, df){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JDBCV2Suite $outer;
                private final Dataset df$4;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x7, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x7;
                    if (A1 instanceof DataSourceV2ScanRelation) {
                        String expected_plan_fragment = "PushedAggregates: [MAX(SALARY), MIN(BONUS)], PushedFilters: [IsNotNull(DEPT), GreaterThan(DEPT,0)], PushedGroupby: [DEPT]";
                        this.$outer.checkKeywordsExistsInExplain((Dataset<Row>)this.df$4, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{expected_plan_fragment}));
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x7);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(LogicalPlan x7) {
                    LogicalPlan logicalPlan = x7;
                    boolean bl = logicalPlan instanceof DataSourceV2ScanRelation;
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.df$4 = df$4;
                }
            });
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> df, (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)10000), BoxesRunTime.boxToInteger((int)1000)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)12000), BoxesRunTime.boxToInteger((int)1200)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)12000), BoxesRunTime.boxToInteger((int)1200)})), (List)Nil$.MODULE$)))));
        }, new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241));
        this.test("scan with aggregate push-down: MAX MIN with filter without group by", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq filters;
            Dataset df = (Dataset)this.sql().apply((Object)"select MAX(ID), MIN(ID) FROM h2.test.people where id > 0");
            Seq $org_scalatest_assert_macro_left = filters = df.queryExecution().optimizedPlan().collect((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x8, Function1<A1, B1> function1) {
                    Filter filter;
                    A1 A1 = x8;
                    Object object = A1 instanceof Filter ? (filter = (Filter)A1) : function1.apply(x8);
                    return (B1)object;
                }

                public final boolean isDefinedAt(LogicalPlan x8) {
                    LogicalPlan logicalPlan = x8;
                    boolean bl = logicalPlan instanceof Filter;
                    return bl;
                }
            });
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 264));
            df.queryExecution().optimizedPlan().collect((PartialFunction)new scala.Serializable(this, df){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JDBCV2Suite $outer;
                private final Dataset df$5;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x9, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x9;
                    if (A1 instanceof DataSourceV2ScanRelation) {
                        String expected_plan_fragment = "PushedAggregates: [MAX(ID), MIN(ID)], PushedFilters: [IsNotNull(ID), GreaterThan(ID,0)], PushedGroupby: []";
                        this.$outer.checkKeywordsExistsInExplain((Dataset<Row>)this.df$5, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{expected_plan_fragment}));
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x9);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(LogicalPlan x9) {
                    LogicalPlan logicalPlan = x9;
                    boolean bl = logicalPlan instanceof DataSourceV2ScanRelation;
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.df$5 = df$5;
                }
            });
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> df, (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$)));
        }, new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 259));
        this.test("scan with aggregate push-down: aggregate + number", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Dataset df = (Dataset)this.sql().apply((Object)"select MAX(SALARY) + 1 FROM h2.test.employee");
            df.queryExecution().optimizedPlan().collect((PartialFunction)new scala.Serializable(this, df){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JDBCV2Suite $outer;
                private final Dataset df$6;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x10, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x10;
                    if (A1 instanceof DataSourceV2ScanRelation) {
                        String expected_plan_fragment = "PushedAggregates: [MAX(SALARY)]";
                        this.$outer.checkKeywordsExistsInExplain((Dataset<Row>)this.df$6, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{expected_plan_fragment}));
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x10);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(LogicalPlan x10) {
                    LogicalPlan logicalPlan = x10;
                    boolean bl = logicalPlan instanceof DataSourceV2ScanRelation;
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.df$6 = df$6;
                }
            });
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> df, (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)12001)})), (List)Nil$.MODULE$)));
        }, new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276));
        this.test("scan with aggregate push-down: COUNT(*)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Dataset df = (Dataset)this.sql().apply((Object)"select COUNT(*) FROM h2.test.employee");
            df.queryExecution().optimizedPlan().collect((PartialFunction)new scala.Serializable(this, df){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JDBCV2Suite $outer;
                private final Dataset df$7;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x11, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x11;
                    if (A1 instanceof DataSourceV2ScanRelation) {
                        String expected_plan_fragment = "PushedAggregates: [COUNT(*)]";
                        this.$outer.checkKeywordsExistsInExplain((Dataset<Row>)this.df$7, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{expected_plan_fragment}));
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x11);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(LogicalPlan x11) {
                    LogicalPlan logicalPlan = x11;
                    boolean bl = logicalPlan instanceof DataSourceV2ScanRelation;
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.df$7 = df$7;
                }
            });
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> df, (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5)})), (List)Nil$.MODULE$)));
        }, new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 287));
        this.test("scan with aggregate push-down: COUNT(col)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Dataset df = (Dataset)this.sql().apply((Object)"select COUNT(DEPT) FROM h2.test.employee");
            df.queryExecution().optimizedPlan().collect((PartialFunction)new scala.Serializable(this, df){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JDBCV2Suite $outer;
                private final Dataset df$8;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x12, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x12;
                    if (A1 instanceof DataSourceV2ScanRelation) {
                        String expected_plan_fragment = "PushedAggregates: [COUNT(DEPT)]";
                        this.$outer.checkKeywordsExistsInExplain((Dataset<Row>)this.df$8, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{expected_plan_fragment}));
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x12);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(LogicalPlan x12) {
                    LogicalPlan logicalPlan = x12;
                    boolean bl = logicalPlan instanceof DataSourceV2ScanRelation;
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.df$8 = df$8;
                }
            });
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> df, (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5)})), (List)Nil$.MODULE$)));
        }, new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 298));
        this.test("scan with aggregate push-down: COUNT(DISTINCT col)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Dataset df = (Dataset)this.sql().apply((Object)"select COUNT(DISTINCT DEPT) FROM h2.test.employee");
            df.queryExecution().optimizedPlan().collect((PartialFunction)new scala.Serializable(this, df){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JDBCV2Suite $outer;
                private final Dataset df$9;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x13, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x13;
                    if (A1 instanceof DataSourceV2ScanRelation) {
                        String expected_plan_fragment = "PushedAggregates: [COUNT(DISTINCT DEPT)]";
                        this.$outer.checkKeywordsExistsInExplain((Dataset<Row>)this.df$9, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{expected_plan_fragment}));
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x13);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(LogicalPlan x13) {
                    LogicalPlan logicalPlan = x13;
                    boolean bl = logicalPlan instanceof DataSourceV2ScanRelation;
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.df$9 = df$9;
                }
            });
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> df, (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3)})), (List)Nil$.MODULE$)));
        }, new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 309));
        this.test("scan with aggregate push-down: SUM without filer and group by", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Dataset df = (Dataset)this.sql().apply((Object)"SELECT SUM(SALARY) FROM h2.test.employee");
            df.queryExecution().optimizedPlan().collect((PartialFunction)new scala.Serializable(this, df){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JDBCV2Suite $outer;
                private final Dataset df$10;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x14, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x14;
                    if (A1 instanceof DataSourceV2ScanRelation) {
                        String expected_plan_fragment = "PushedAggregates: [SUM(SALARY)]";
                        this.$outer.checkKeywordsExistsInExplain((Dataset<Row>)this.df$10, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{expected_plan_fragment}));
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x14);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(LogicalPlan x14) {
                    LogicalPlan logicalPlan = x14;
                    boolean bl = logicalPlan instanceof DataSourceV2ScanRelation;
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.df$10 = df$10;
                }
            });
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> df, (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)53000)})), (List)Nil$.MODULE$)));
        }, new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 320));
        this.test("scan with aggregate push-down: DISTINCT SUM without filer and group by", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Dataset df = (Dataset)this.sql().apply((Object)"SELECT SUM(DISTINCT SALARY) FROM h2.test.employee");
            df.queryExecution().optimizedPlan().collect((PartialFunction)new scala.Serializable(this, df){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JDBCV2Suite $outer;
                private final Dataset df$11;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x15, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x15;
                    if (A1 instanceof DataSourceV2ScanRelation) {
                        String expected_plan_fragment = "PushedAggregates: [SUM(DISTINCT SALARY)]";
                        this.$outer.checkKeywordsExistsInExplain((Dataset<Row>)this.df$11, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{expected_plan_fragment}));
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x15);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(LogicalPlan x15) {
                    LogicalPlan logicalPlan = x15;
                    boolean bl = logicalPlan instanceof DataSourceV2ScanRelation;
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.df$11 = df$11;
                }
            });
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> df, (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)31000)})), (List)Nil$.MODULE$)));
        }, new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 331));
        this.test("scan with aggregate push-down: SUM with group by", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Dataset df = (Dataset)this.sql().apply((Object)"SELECT SUM(SALARY) FROM h2.test.employee GROUP BY DEPT");
            df.queryExecution().optimizedPlan().collect((PartialFunction)new scala.Serializable(this, df){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JDBCV2Suite $outer;
                private final Dataset df$12;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x16, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x16;
                    if (A1 instanceof DataSourceV2ScanRelation) {
                        String expected_plan_fragment = "PushedAggregates: [SUM(SALARY)], PushedFilters: [], PushedGroupby: [DEPT]";
                        this.$outer.checkKeywordsExistsInExplain((Dataset<Row>)this.df$12, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{expected_plan_fragment}));
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x16);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(LogicalPlan x16) {
                    LogicalPlan logicalPlan = x16;
                    boolean bl = logicalPlan instanceof DataSourceV2ScanRelation;
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.df$12 = df$12;
                }
            });
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> df, (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)19000)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)22000)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)12000)})), (List)Nil$.MODULE$)))));
        }, new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 342));
        this.test("scan with aggregate push-down: DISTINCT SUM with group by", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Dataset df = (Dataset)this.sql().apply((Object)"SELECT SUM(DISTINCT SALARY) FROM h2.test.employee GROUP BY DEPT");
            df.queryExecution().optimizedPlan().collect((PartialFunction)new scala.Serializable(this, df){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JDBCV2Suite $outer;
                private final Dataset df$13;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x17, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x17;
                    if (A1 instanceof DataSourceV2ScanRelation) {
                        String expected_plan_fragment = "PushedAggregates: [SUM(DISTINCT SALARY)], PushedFilters: [], PushedGroupby: [DEPT]";
                        this.$outer.checkKeywordsExistsInExplain((Dataset<Row>)this.df$13, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{expected_plan_fragment}));
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x17);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(LogicalPlan x17) {
                    LogicalPlan logicalPlan = x17;
                    boolean bl = logicalPlan instanceof DataSourceV2ScanRelation;
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.df$13 = df$13;
                }
            });
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> df, (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)19000)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)22000)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)12000)})), (List)Nil$.MODULE$)))));
        }, new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 355));
        this.test("scan with aggregate push-down: with multiple group by columns", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq filters11;
            Dataset df = (Dataset)this.sql().apply((Object)"select MAX(SALARY), MIN(BONUS) FROM h2.test.employee where dept > 0 group by DEPT, NAME");
            Seq $org_scalatest_assert_macro_left = filters11 = df.queryExecution().optimizedPlan().collect((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x18, Function1<A1, B1> function1) {
                    Filter filter;
                    A1 A1 = x18;
                    Object object = A1 instanceof Filter ? (filter = (Filter)A1) : function1.apply(x18);
                    return (B1)object;
                }

                public final boolean isDefinedAt(LogicalPlan x18) {
                    LogicalPlan logicalPlan = x18;
                    boolean bl = logicalPlan instanceof Filter;
                    return bl;
                }
            });
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 374));
            df.queryExecution().optimizedPlan().collect((PartialFunction)new scala.Serializable(this, df){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JDBCV2Suite $outer;
                private final Dataset df$14;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x19, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x19;
                    if (A1 instanceof DataSourceV2ScanRelation) {
                        String expected_plan_fragment = "PushedAggregates: [MAX(SALARY), MIN(BONUS)], PushedFilters: [IsNotNull(DEPT), GreaterThan(DEPT,0)], PushedGroupby: [DEPT, NAME]";
                        this.$outer.checkKeywordsExistsInExplain((Dataset<Row>)this.df$14, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{expected_plan_fragment}));
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x19);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(LogicalPlan x19) {
                    LogicalPlan logicalPlan = x19;
                    boolean bl = logicalPlan instanceof DataSourceV2ScanRelation;
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.df$14 = df$14;
                }
            });
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> df, (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)9000), BoxesRunTime.boxToInteger((int)1200)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)12000), BoxesRunTime.boxToInteger((int)1200)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)10000), BoxesRunTime.boxToInteger((int)1300)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)10000), BoxesRunTime.boxToInteger((int)1000)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)12000), BoxesRunTime.boxToInteger((int)1200)})), (List)Nil$.MODULE$)))))));
        }, new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 368));
        this.test("scan with aggregate push-down: with having clause", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq filters;
            Dataset df = (Dataset)this.sql().apply((Object)"select MAX(SALARY), MIN(BONUS) FROM h2.test.employee where dept > 0 group by DEPT having MIN(BONUS) > 1000");
            Seq $org_scalatest_assert_macro_left = filters = df.queryExecution().optimizedPlan().collect((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x20, Function1<A1, B1> function1) {
                    Filter filter;
                    A1 A1 = x20;
                    Object object = A1 instanceof Filter ? (filter = (Filter)A1) : function1.apply(x20);
                    return (B1)object;
                }

                public final boolean isDefinedAt(LogicalPlan x20) {
                    LogicalPlan logicalPlan = x20;
                    boolean bl = logicalPlan instanceof Filter;
                    return bl;
                }
            });
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 393));
            df.queryExecution().optimizedPlan().collect((PartialFunction)new scala.Serializable(this, df){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JDBCV2Suite $outer;
                private final Dataset df$15;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x21, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x21;
                    if (A1 instanceof DataSourceV2ScanRelation) {
                        String expected_plan_fragment = "PushedAggregates: [MAX(SALARY), MIN(BONUS)], PushedFilters: [IsNotNull(DEPT), GreaterThan(DEPT,0)], PushedGroupby: [DEPT]";
                        this.$outer.checkKeywordsExistsInExplain((Dataset<Row>)this.df$15, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{expected_plan_fragment}));
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x21);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(LogicalPlan x21) {
                    LogicalPlan logicalPlan = x21;
                    boolean bl = logicalPlan instanceof DataSourceV2ScanRelation;
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.df$15 = df$15;
                }
            });
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> df, (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)12000), BoxesRunTime.boxToInteger((int)1200)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)12000), BoxesRunTime.boxToInteger((int)1200)})), (List)Nil$.MODULE$))));
        }, new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 387));
        this.test("scan with aggregate push-down: alias over aggregate", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Dataset df = ((Dataset)this.sql().apply((Object)"select * from h2.test.employee")).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DEPT"}))).$((Seq)Nil$.MODULE$)})).min((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SALARY"})).as("total");
            df.queryExecution().optimizedPlan().collect((PartialFunction)new scala.Serializable(this, df){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JDBCV2Suite $outer;
                private final Dataset df$16;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x22, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x22;
                    if (A1 instanceof DataSourceV2ScanRelation) {
                        String expected_plan_fragment = "PushedAggregates: [MIN(SALARY)], PushedFilters: [], PushedGroupby: [DEPT]";
                        this.$outer.checkKeywordsExistsInExplain((Dataset<Row>)this.df$16, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{expected_plan_fragment}));
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x22);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(LogicalPlan x22) {
                    LogicalPlan logicalPlan = x22;
                    boolean bl = logicalPlan instanceof DataSourceV2ScanRelation;
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.df$16 = df$16;
                }
            });
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> df, (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)9000)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)10000)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)12000)})), (List)Nil$.MODULE$)))));
        }, new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 405));
        this.test("scan with aggregate push-down: order by alias over aggregate", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq filters;
            Dataset df = this.spark().table("h2.test.employee");
            Dataset query = df.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DEPT"}))).$((Seq)Nil$.MODULE$), this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SALARY"}))).$((Seq)Nil$.MODULE$)})).filter(this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DEPT"}))).$((Seq)Nil$.MODULE$).$greater((Object)BoxesRunTime.boxToInteger((int)0))).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DEPT"}))).$((Seq)Nil$.MODULE$)})).agg(functions$.MODULE$.sum((Column)this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SALARY"}))).$((Seq)Nil$.MODULE$)).as("total"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0])).filter(this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"total"}))).$((Seq)Nil$.MODULE$).$greater((Object)BoxesRunTime.boxToInteger((int)1000))).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"total"}))).$((Seq)Nil$.MODULE$)}));
            Seq $org_scalatest_assert_macro_left = filters = query.queryExecution().optimizedPlan().collect((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x23, Function1<A1, B1> function1) {
                    Filter filter;
                    A1 A1 = x23;
                    Object object = A1 instanceof Filter ? (filter = (Filter)A1) : function1.apply(x23);
                    return (B1)object;
                }

                public final boolean isDefinedAt(LogicalPlan x23) {
                    LogicalPlan logicalPlan = x23;
                    boolean bl = logicalPlan instanceof Filter;
                    return bl;
                }
            });
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 431));
            query.queryExecution().optimizedPlan().collect((PartialFunction)new scala.Serializable(this, query){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JDBCV2Suite $outer;
                private final Dataset query$1;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x24, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x24;
                    if (A1 instanceof DataSourceV2ScanRelation) {
                        String expected_plan_fragment = "PushedAggregates: [SUM(SALARY)], PushedFilters: [IsNotNull(DEPT), GreaterThan(DEPT,0)], PushedGroupby: [DEPT]";
                        this.$outer.checkKeywordsExistsInExplain((Dataset<Row>)this.query$1, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{expected_plan_fragment}));
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x24);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(LogicalPlan x24) {
                    LogicalPlan logicalPlan = x24;
                    boolean bl = logicalPlan instanceof DataSourceV2ScanRelation;
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.query$1 = query$1;
                }
            });
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> query, (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)6), BoxesRunTime.boxToInteger((int)12000)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)19000)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)22000)})), (List)Nil$.MODULE$)))));
        }, new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 420));
        this.test("scan with aggregate push-down: udf over aggregate", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Dataset df = this.spark().table("h2.test.employee");
            UserDefinedFunction decrease = functions$.MODULE$.udf((Function2)(JFunction2.mcDDD.sp & Serializable & scala.Serializable)(x, y) -> x - y, ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double());
            Dataset query = df.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{decrease.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.sum((Column)this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SALARY"}))).$((Seq)Nil$.MODULE$)), functions$.MODULE$.sum((Column)this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"BONUS"}))).$((Seq)Nil$.MODULE$))})).as("value")}));
            query.queryExecution().optimizedPlan().collect((PartialFunction)new scala.Serializable(this, query){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JDBCV2Suite $outer;
                private final Dataset query$2;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x25, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x25;
                    if (A1 instanceof DataSourceV2ScanRelation) {
                        String expected_plan_fragment = "PushedAggregates: [SUM(SALARY), SUM(BONUS)";
                        this.$outer.checkKeywordsExistsInExplain((Dataset<Row>)this.query$2, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{expected_plan_fragment}));
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x25);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(LogicalPlan x25) {
                    LogicalPlan logicalPlan = x25;
                    boolean bl = logicalPlan instanceof DataSourceV2ScanRelation;
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.query$2 = query$2;
                }
            });
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> query, (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)47100.0)})), (List)Nil$.MODULE$)));
        }, new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 443));
        this.test("scan with aggregate push-down: aggregate over alias NOT push down", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Seq cols = (Seq)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)new .colon.colon((Object)"c", (List)new .colon.colon((Object)"d", (List)Nil$.MODULE$))));
            Dataset df1 = ((Dataset)this.sql().apply((Object)"select * from h2.test.employee")).toDF(cols);
            Dataset df2 = df1.groupBy((Seq)Nil$.MODULE$).sum((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}));
            df2.queryExecution().optimizedPlan().collect((PartialFunction)new scala.Serializable(this, df2){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ JDBCV2Suite $outer;
                private final Dataset df2$1;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x26, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x26;
                    if (A1 instanceof DataSourceV2ScanRelation) {
                        String expected_plan_fragment = "PushedAggregates: []";
                        this.$outer.checkKeywordsExistsInExplain((Dataset<Row>)this.df2$1, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{expected_plan_fragment}));
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x26);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(LogicalPlan x26) {
                    LogicalPlan logicalPlan = x26;
                    boolean bl = logicalPlan instanceof DataSourceV2ScanRelation;
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.df2$1 = df2$1;
                }
            });
            this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> df2, (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)53000.0)})), (List)Nil$.MODULE$)));
        }, new Position("JDBCV2Suite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 456));
    }
}

