/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector;

import java.io.Serializable;
import java.util.Collections;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.DataFrameWriterV2;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.catalyst.plans.logical.AppendData;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.connector.DataSourceV2DataFrameSuite$;
import org.apache.spark.sql.connector.FakeV2Provider;
import org.apache.spark.sql.connector.InsertIntoTests;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.InMemoryTableCatalog;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.sql.util.QueryExecutionListener;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001I3A\u0001C\u0005\u0001)!)\u0011\u0004\u0001C\u00015!9A\u0004\u0001b\u0001\n#j\u0002BB\u0016\u0001A\u0003%a\u0004C\u0004-\u0001\t\u0007I\u0011K\u000f\t\r5\u0002\u0001\u0015!\u0003\u001f\u0011\u0015q\u0003\u0001\"\u00110\u0011\u00159\u0005\u0001\"\u0015I\u0005i!\u0015\r^1T_V\u00148-\u001a,3\t\u0006$\u0018M\u0012:b[\u0016\u001cV/\u001b;f\u0015\tQ1\"A\u0005d_:tWm\u0019;pe*\u0011A\"D\u0001\u0004gFd'B\u0001\b\u0010\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0001\u0012#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002%\u0005\u0019qN]4\u0004\u0001M\u0011\u0001!\u0006\t\u0003-]i\u0011!C\u0005\u00031%\u0011q\"\u00138tKJ$\u0018J\u001c;p)\u0016\u001cHo]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0001\"A\u0006\u0001\u0002'\r\fG/\u00197pO\u0006sGMT1nKN\u0004\u0018mY3\u0016\u0003y\u0001\"a\b\u0015\u000f\u0005\u00012\u0003CA\u0011%\u001b\u0005\u0011#BA\u0012\u0014\u0003\u0019a$o\\8u})\tQ%A\u0003tG\u0006d\u0017-\u0003\u0002(I\u00051\u0001K]3eK\u001aL!!\u000b\u0016\u0003\rM#(/\u001b8h\u0015\t9C%\u0001\u000bdCR\fGn\\4B]\u0012t\u0015-\\3ta\u0006\u001cW\rI\u0001\tmJ2uN]7bi\u0006IaO\r$pe6\fG\u000fI\u0001\fm\u0016\u0014\u0018NZ=UC\ndW\rF\u00021iY\u0002\"!\r\u001a\u000e\u0003\u0011J!a\r\u0013\u0003\tUs\u0017\u000e\u001e\u0005\u0006k\u0019\u0001\rAH\u0001\ni\u0006\u0014G.\u001a(b[\u0016DQa\u000e\u0004A\u0002a\n\u0001\"\u001a=qK\u000e$X\r\u001a\t\u0003s\u0011s!A\u000f\"\u000f\u0005m\neB\u0001\u001fA\u001d\titH\u0004\u0002\"}%\t!#\u0003\u0002\u0011#%\u0011abD\u0005\u0003\u00195I!aQ\u0006\u0002\u000fA\f7m[1hK&\u0011QI\u0012\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T!aQ\u0006\u0002\u0011\u0011|\u0017J\\:feR$B\u0001M%K\u0019\")Qg\u0002a\u0001=!)1j\u0002a\u0001q\u00051\u0011N\\:feRDq!T\u0004\u0011\u0002\u0003\u0007a*\u0001\u0003n_\u0012,\u0007CA(Q\u001b\u0005Y\u0011BA)\f\u0005!\u0019\u0016M^3N_\u0012,\u0007")
public class DataSourceV2DataFrameSuite
extends InsertIntoTests {
    private final String catalogAndNamespace;
    private final String v2Format;

    @Override
    public String catalogAndNamespace() {
        return this.catalogAndNamespace;
    }

    @Override
    public String v2Format() {
        return this.v2Format;
    }

    @Override
    public void verifyTable(String tableName, Dataset<Row> expected) {
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> this.spark().table(tableName), expected);
    }

    @Override
    public void doInsert(String tableName, Dataset<Row> insert, SaveMode mode) {
        DataFrameWriter dfw = insert.write().format(this.v2Format());
        Object object = mode != null ? dfw.mode(mode) : BoxedUnit.UNIT;
        dfw.insertInto(tableName);
    }

    public DataSourceV2DataFrameSuite() {
        super(true, false);
        this.before((Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().conf().set("spark.sql.catalog.testcat", InMemoryTableCatalog.class.getName());
            this.spark().conf().set("spark.sql.catalog.testcat2", InMemoryTableCatalog.class.getName());
        }, new Position("DataSourceV2DataFrameSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
        this.after((Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sessionState().catalogManager().reset();
            this.spark().sessionState().conf().clear();
        }, new Position("DataSourceV2DataFrameSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
        this.catalogAndNamespace = "testcat.ns1.ns2.tbls";
        this.v2Format = FakeV2Provider.class.getName();
        this.test("insertInto: append across catalog", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t1 = "testcat.ns1.ns2.tbl";
            String t2 = "testcat2.db.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t1, t2}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(48).append("CREATE TABLE ").append(t1).append(" (id bigint, data string) USING foo").toString());
                this.sql().apply((Object)new StringBuilder(48).append("CREATE TABLE ").append(t2).append(" (id bigint, data string) USING foo").toString());
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DataSourceV2DataFrameSuite.class.getClassLoader());
                public final class Org_apache_spark_sql_connector_DataSourceV2DataFrameSuite$$typecreator6$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_sql_connector_DataSourceV2DataFrameSuite$$typecreator6$1(DataSourceV2DataFrameSuite $outer) {
                    }
                }
                Dataset df = this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)1L), (Object)"a"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)2L), (Object)"b"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)3L), (Object)"c"), (List)Nil$.MODULE$))), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2DataFrameSuite$$typecreator6$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data"}));
                df.write().insertInto(t1);
                this.spark().table(t1).write().insertInto(t2);
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> this.spark().table(t2), (Dataset<Row>)df);
            });
        }, new Position("DataSourceV2DataFrameSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        this.testQuietly("saveAsTable: table doesn't exist => create table", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t1 = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t1}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DataSourceV2DataFrameSuite.class.getClassLoader());
                public final class Org_apache_spark_sql_connector_DataSourceV2DataFrameSuite$$typecreator16$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_sql_connector_DataSourceV2DataFrameSuite$$typecreator16$1(DataSourceV2DataFrameSuite $outer) {
                    }
                }
                Dataset df = this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)1L), (Object)"a"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)2L), (Object)"b"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)3L), (Object)"c"), (List)Nil$.MODULE$))), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2DataFrameSuite$$typecreator16$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data"}));
                df.write().saveAsTable(t1);
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> this.spark().table(t1), (Dataset<Row>)df);
            });
        });
        this.testQuietly("saveAsTable: table exists => append by name", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t1 = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t1}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(48).append("CREATE TABLE ").append(t1).append(" (id bigint, data string) USING foo").toString());
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DataSourceV2DataFrameSuite.class.getClassLoader());
                public final class Org_apache_spark_sql_connector_DataSourceV2DataFrameSuite$$typecreator26$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_sql_connector_DataSourceV2DataFrameSuite$$typecreator26$1(DataSourceV2DataFrameSuite $outer) {
                    }
                }
                Dataset df = this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)1L), (Object)"a"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)2L), (Object)"b"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)3L), (Object)"c"), (List)Nil$.MODULE$))), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2DataFrameSuite$$typecreator26$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data"}));
                this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> df.write().saveAsTable(t1), ClassTag$.MODULE$.apply(TableAlreadyExistsException.class), new Position("DataSourceV2DataFrameSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)this.spark().table(t1).count()));
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2DataFrameSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
                df.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "data")), this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "id"))})).write().mode("append").saveAsTable(t1);
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> this.spark().table(t1), (Dataset<Row>)df);
            });
        });
        this.testQuietly("saveAsTable: table overwrite and table doesn't exist => create table", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t1 = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t1}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DataSourceV2DataFrameSuite.class.getClassLoader());
                public final class Org_apache_spark_sql_connector_DataSourceV2DataFrameSuite$$typecreator36$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_sql_connector_DataSourceV2DataFrameSuite$$typecreator36$1(DataSourceV2DataFrameSuite $outer) {
                    }
                }
                Dataset df = this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)1L), (Object)"a"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)2L), (Object)"b"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)3L), (Object)"c"), (List)Nil$.MODULE$))), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2DataFrameSuite$$typecreator36$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data"}));
                df.write().mode("overwrite").saveAsTable(t1);
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> this.spark().table(t1), (Dataset<Row>)df);
            });
        });
        this.testQuietly("saveAsTable: table overwrite and table exists => replace table", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t1 = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t1}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                this.sql().apply((Object)new StringBuilder(42).append("CREATE TABLE ").append(t1).append(" USING foo AS SELECT 'c', 'd'").toString());
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DataSourceV2DataFrameSuite.class.getClassLoader());
                public final class Org_apache_spark_sql_connector_DataSourceV2DataFrameSuite$$typecreator46$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_sql_connector_DataSourceV2DataFrameSuite$$typecreator46$1(DataSourceV2DataFrameSuite $outer) {
                    }
                }
                Dataset df = this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)1L), (Object)"a"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)2L), (Object)"b"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)3L), (Object)"c"), (List)Nil$.MODULE$))), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2DataFrameSuite$$typecreator46$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data"}));
                df.write().mode("overwrite").saveAsTable(t1);
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> this.spark().table(t1), (Dataset<Row>)df);
            });
        });
        this.testQuietly("saveAsTable: ignore mode and table doesn't exist => create table", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t1 = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t1}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DataSourceV2DataFrameSuite.class.getClassLoader());
                public final class Org_apache_spark_sql_connector_DataSourceV2DataFrameSuite$$typecreator56$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_sql_connector_DataSourceV2DataFrameSuite$$typecreator56$1(DataSourceV2DataFrameSuite $outer) {
                    }
                }
                Dataset df = this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)1L), (Object)"a"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)2L), (Object)"b"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)3L), (Object)"c"), (List)Nil$.MODULE$))), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2DataFrameSuite$$typecreator56$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data"}));
                df.write().mode("ignore").saveAsTable(t1);
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> this.spark().table(t1), (Dataset<Row>)df);
            });
        });
        this.testQuietly("saveAsTable: ignore mode and table exists => do nothing", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t1 = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t1}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DataSourceV2DataFrameSuite.class.getClassLoader());
                public final class Org_apache_spark_sql_connector_DataSourceV2DataFrameSuite$$typecreator66$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_sql_connector_DataSourceV2DataFrameSuite$$typecreator66$1(DataSourceV2DataFrameSuite $outer) {
                    }
                }
                Dataset df = this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)1L), (Object)"a"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)2L), (Object)"b"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)3L), (Object)"c"), (List)Nil$.MODULE$))), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2DataFrameSuite$$typecreator66$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data"}));
                this.sql().apply((Object)new StringBuilder(42).append("CREATE TABLE ").append(t1).append(" USING foo AS SELECT 'c', 'd'").toString());
                df.write().mode("ignore").saveAsTable(t1);
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> this.spark().table(t1), (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"c", "d"})), (List)Nil$.MODULE$)));
            });
        });
        this.testQuietly("SPARK-29778: saveAsTable: append mode takes write options", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ObjectRef plan = ObjectRef.create(null);
            QueryExecutionListener listener = new QueryExecutionListener(null, plan){
                private final ObjectRef plan$1;

                public void onSuccess(String funcName, QueryExecution qe, long durationNs) {
                    this.plan$1.elem = qe.analyzed();
                }

                public void onFailure(String funcName, QueryExecution qe, Exception exception) {
                }
                {
                    this.plan$1 = plan$1;
                }
            };
            try {
                this.spark().listenerManager().register(listener);
                String t1 = "testcat.ns1.ns2.tbl";
                this.sql().apply((Object)new StringBuilder(48).append("CREATE TABLE ").append(t1).append(" (id bigint, data string) USING foo").toString());
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DataSourceV2DataFrameSuite.class.getClassLoader());
                public final class Org_apache_spark_sql_connector_DataSourceV2DataFrameSuite$$typecreator76$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_sql_connector_DataSourceV2DataFrameSuite$$typecreator76$1(DataSourceV2DataFrameSuite $outer) {
                    }
                }
                Dataset df = this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)1L), (Object)"a"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)2L), (Object)"b"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)3L), (Object)"c"), (List)Nil$.MODULE$))), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2DataFrameSuite$$typecreator76$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data"}));
                df.write().option("other", "20").mode("append").saveAsTable(t1);
                this.sparkContext().listenerBus().waitUntilEmpty();
                LogicalPlan logicalPlan = (LogicalPlan)plan.elem;
                if (!(logicalPlan instanceof AppendData)) {
                    throw this.fail(new StringBuilder(36).append("Expected to parse ").append(AppendData.class.getName()).append(" from query,").append("got ").append(logicalPlan.getClass().getName()).append(": ").append((LogicalPlan)plan.elem).toString(), new Position("DataSourceV2DataFrameSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
                }
                AppendData appendData = (AppendData)logicalPlan;
                Map $org_scalatest_assert_macro_left = appendData.writeOptions();
                Map $org_scalatest_assert_macro_right = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"other"), (Object)"20")}));
                Map map = $org_scalatest_assert_macro_left;
                Map map2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(map != null ? !map.equals(map2) : map2 != null), Prettifier$.MODULE$.default());
                Assertion assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2DataFrameSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
                this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> this.spark().table(t1), (Dataset<Row>)df);
            }
            finally {
                this.spark().listenerManager().unregister(listener);
            }
        });
        this.test("Cannot write data with intervals to v2", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.LEGACY_INTERVAL_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"testcat.table_name"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TableCatalog testCatalog = CatalogV2Implicits$.MODULE$.CatalogHelper(this.spark().sessionState().catalogManager().catalog("testcat")).asTableCatalog();
            testCatalog.createTable(Identifier.of((String[])((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))), (String)"table_name"), new StructType().add("i", "interval"), (Transform[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Transform.class)), Collections.emptyMap());
            Dataset df = (Dataset)this.sql().apply((Object)"select interval 1 millisecond as i");
            DataFrameWriterV2 v2Writer = df.writeTo("testcat.table_name");
            AnalysisException e1 = (AnalysisException)((Object)((Object)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> v2Writer.append(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2DataFrameSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184))))));
            String $org_scalatest_assert_macro_left = e1.getMessage();
            String $org_scalatest_assert_macro_right = "Cannot use interval type in the table schema.";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2DataFrameSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 185));
            AnalysisException e2 = (AnalysisException)((Object)((Object)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> v2Writer.overwrite(df.apply("i")), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2DataFrameSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186))))));
            String $org_scalatest_assert_macro_left2 = e2.getMessage();
            String $org_scalatest_assert_macro_right2 = "Cannot use interval type in the table schema.";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2DataFrameSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
            AnalysisException e3 = (AnalysisException)((Object)((Object)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> v2Writer.overwritePartitions(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("DataSourceV2DataFrameSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188))))));
            String $org_scalatest_assert_macro_left3 = e3.getMessage();
            String $org_scalatest_assert_macro_right3 = "Cannot use interval type in the table schema.";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2DataFrameSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
        })), new Position("DataSourceV2DataFrameSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
        this.test("options to scan v2 table should be passed to DataSourceV2Relation", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String t1 = "testcat.ns1.ns2.tbl";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{t1}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DataSourceV2DataFrameSuite.class.getClassLoader());
                public final class Org_apache_spark_sql_connector_DataSourceV2DataFrameSuite$$typecreator86$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_sql_connector_DataSourceV2DataFrameSuite$$typecreator86$1(DataSourceV2DataFrameSuite $outer) {
                    }
                }
                Dataset df1 = this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)1L), (Object)"a"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)2L), (Object)"b"), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)3L), (Object)"c"), (List)Nil$.MODULE$))), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connector_DataSourceV2DataFrameSuite$$typecreator86$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "data"}));
                df1.write().saveAsTable(t1);
                String optionName = "fakeOption";
                Dataset df2 = this.spark().read().option(optionName, false).table(t1);
                CaseInsensitiveStringMap options = (CaseInsensitiveStringMap)df2.queryExecution().analyzed().collectFirst((PartialFunction)new scala.Serializable(null){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (A1 instanceof DataSourceV2Relation) {
                            DataSourceV2Relation dataSourceV2Relation = (DataSourceV2Relation)A1;
                            object = dataSourceV2Relation.options();
                        } else {
                            object = function1.apply(x1);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(LogicalPlan x1) {
                        LogicalPlan logicalPlan = x1;
                        boolean bl = logicalPlan instanceof DataSourceV2Relation;
                        return bl;
                    }
                }).get();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(options.get((Object)optionName));
                String $org_scalatest_assert_macro_right = "false";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DataSourceV2DataFrameSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 207));
            });
        }, new Position("DataSourceV2DataFrameSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
    }
}

