/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.orc;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeProjection$;
import org.apache.spark.sql.execution.WholeStageCodegenExec$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.RecordReaderIterator;
import org.apache.spark.sql.execution.datasources.orc.OrcColumnarBatchReader;
import org.apache.spark.sql.execution.datasources.orc.OrcDeserializer;
import org.apache.spark.sql.execution.datasources.orc.OrcFileFormat$;
import org.apache.spark.sql.execution.datasources.orc.OrcFilters$;
import org.apache.spark.sql.execution.datasources.orc.OrcOptions;
import org.apache.spark.sql.execution.datasources.orc.OrcOutputWriter;
import org.apache.spark.sql.execution.datasources.orc.OrcUtils$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.AnsiIntervalType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.Utils$;
import org.eep_custom.orc.OrcConf;
import org.eep_custom.orc.OrcFile;
import org.eep_custom.orc.Reader;
import org.eep_custom.orc.TypeDescription;
import org.eep_custom.orc.mapred.OrcOutputFormat;
import org.eep_custom.orc.mapred.OrcStruct;
import org.eep_custom.orc.mapreduce.OrcInputFormat;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005]wAB\n\u0015\u0011\u0003Q\"E\u0002\u0004%)!\u0005!$\n\u0005\u0006_\u0005!\t!\r\u0005\u0006e\u0005!\ta\r\u0005\b\u000f\u0006\t\t\u0011\"\u0003I\r\u0011!C\u0003A)\t\u000b=*A\u0011A1\t\u000b\r,A\u0011\t3\t\u000b\u0015,A\u0011\t3\t\u000b\u0019,A\u0011I4\t\u000b-,A\u0011\t7\t\u000bU,A\u0011\t<\t\u000f\u0005]R\u0001\"\u0011\u0002:!9\u0011\u0011L\u0003\u0005\n\u0005m\u0003bBA2\u000b\u0011\u0005\u0013Q\r\u0005\b\u0003W*A\u0011IA7\u0011\u001d\ti(\u0002C!\u0003\u007fBq!!3\u0006\t\u0003\nY\rC\u0004\u0002P\u0016!\t%!5\u0002\u001b=\u00138MR5mK\u001a{'/\\1u\u0015\t)b#A\u0002pe\u000eT!a\u0006\r\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u00033i\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005ma\u0012aA:rY*\u0011QDH\u0001\u0006gB\f'o\u001b\u0006\u0003?\u0001\na!\u00199bG\",'\"A\u0011\u0002\u0007=\u0014x\r\u0005\u0002$\u00035\tACA\u0007Pe\u000e4\u0015\u000e\\3G_Jl\u0017\r^\n\u0004\u0003\u0019b\u0003CA\u0014+\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#AB!osJ+g\r\u0005\u0002([%\u0011a\u0006\u000b\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\t!%A\u000bhKR\fVo\u001c;fIN\u001b\u0007.Z7b'R\u0014\u0018N\\4\u0015\u0005Qz\u0004CA\u001b=\u001d\t1$\b\u0005\u00028Q5\t\u0001H\u0003\u0002:a\u00051AH]8pizJ!a\u000f\u0015\u0002\rA\u0013X\rZ3g\u0013\tidH\u0001\u0004TiJLgn\u001a\u0006\u0003w!BQ\u0001Q\u0002A\u0002\u0005\u000b\u0001\u0002Z1uCRK\b/\u001a\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0003\tj\tQ\u0001^=qKNL!AR\"\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f1B]3bIJ+7o\u001c7wKR\t\u0011\n\u0005\u0002K\u001f6\t1J\u0003\u0002M\u001b\u0006!A.\u00198h\u0015\u0005q\u0015\u0001\u00026bm\u0006L!\u0001U&\u0003\r=\u0013'.Z2u'\u0015)aE\u0015,]!\t\u0019F+D\u0001\u0017\u0013\t)fC\u0001\u0006GS2,gi\u001c:nCR\u0004\"a\u0016.\u000e\u0003aS!!\u0017\u000e\u0002\u000fM|WO]2fg&\u00111\f\u0017\u0002\u0013\t\u0006$\u0018mU8ve\u000e,'+Z4jgR,'\u000f\u0005\u0002^A6\taL\u0003\u0002`\u001b\u0006\u0011\u0011n\\\u0005\u0003]y#\u0012A\u0019\t\u0003G\u0015\t\u0011b\u001d5peRt\u0015-\\3\u0015\u0003Q\n\u0001\u0002^8TiJLgnZ\u0001\tQ\u0006\u001c\bnQ8eKR\t\u0001\u000e\u0005\u0002(S&\u0011!\u000e\u000b\u0002\u0004\u0013:$\u0018AB3rk\u0006d7\u000f\u0006\u0002naB\u0011qE\\\u0005\u0003_\"\u0012qAQ8pY\u0016\fg\u000eC\u0003r\u0015\u0001\u0007!/A\u0003pi\",'\u000f\u0005\u0002(g&\u0011A\u000f\u000b\u0002\u0004\u0003:L\u0018aC5oM\u0016\u00148k\u00195f[\u0006$ba^?\u0002\b\u0005E\u0001cA\u0014yu&\u0011\u0011\u0010\u000b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\t[\u0018B\u0001?D\u0005)\u0019FO];diRK\b/\u001a\u0005\u0006}.\u0001\ra`\u0001\rgB\f'o[*fgNLwN\u001c\t\u0005\u0003\u0003\t\u0019!D\u0001\u001b\u0013\r\t)A\u0007\u0002\r'B\f'o[*fgNLwN\u001c\u0005\b\u0003\u0013Y\u0001\u0019AA\u0006\u0003\u001dy\u0007\u000f^5p]N\u0004R!NA\u0007iQJ1!a\u0004?\u0005\ri\u0015\r\u001d\u0005\b\u0003'Y\u0001\u0019AA\u000b\u0003\u00151\u0017\u000e\\3t!\u0019\t9\"!\t\u0002(9!\u0011\u0011DA\u000f\u001d\r9\u00141D\u0005\u0002S%\u0019\u0011q\u0004\u0015\u0002\u000fA\f7m[1hK&!\u00111EA\u0013\u0005\r\u0019V-\u001d\u0006\u0004\u0003?A\u0003\u0003BA\u0015\u0003gi!!a\u000b\u000b\t\u00055\u0012qF\u0001\u0003MNT1!!\r\u001f\u0003\u0019A\u0017\rZ8pa&!\u0011QGA\u0016\u0005)1\u0015\u000e\\3Ti\u0006$Xo]\u0001\raJ,\u0007/\u0019:f/JLG/\u001a\u000b\u000b\u0003w\t\t%a\u0011\u0002T\u0005U\u0003cA*\u0002>%\u0019\u0011q\b\f\u0003'=+H\u000f];u/JLG/\u001a:GC\u000e$xN]=\t\u000byd\u0001\u0019A@\t\u000f\u0005\u0015C\u00021\u0001\u0002H\u0005\u0019!n\u001c2\u0011\t\u0005%\u0013qJ\u0007\u0003\u0003\u0017RA!!\u0014\u00020\u0005IQ.\u00199sK\u0012,8-Z\u0005\u0005\u0003#\nYEA\u0002K_\nDq!!\u0003\r\u0001\u0004\tY\u0001\u0003\u0004\u0002X1\u0001\rA_\u0001\u000bI\u0006$\u0018mU2iK6\f\u0017aG:vaB|'\u000f\u001e\"bi\u000eDgi\u001c:OKN$X\rZ\"pYVlg\u000eF\u0003n\u0003;\ny\u0006C\u0003\u007f\u001b\u0001\u0007q\u0010\u0003\u0004\u0002b5\u0001\rA_\u0001\u0007g\u000eDW-\\1\u0002\u0019M,\b\u000f]8si\n\u000bGo\u00195\u0015\u000b5\f9'!\u001b\t\u000byt\u0001\u0019A@\t\r\u0005\u0005d\u00021\u0001{\u0003-I7o\u00159mSR\f'\r\\3\u0015\u000f5\fy'!\u001d\u0002t!)ap\u0004a\u0001\u007f\"9\u0011\u0011B\bA\u0002\u0005-\u0001bBA;\u001f\u0001\u0007\u0011qO\u0001\u0005a\u0006$\b\u000e\u0005\u0003\u0002*\u0005e\u0014\u0002BA>\u0003W\u0011A\u0001U1uQ\u0006q\"-^5mIJ+\u0017\rZ3s/&$\b\u000eU1si&$\u0018n\u001c8WC2,Xm\u001d\u000b\u0011\u0003\u0003\u000by*!)\u0002$\u0006\u001d\u00161VA\\\u0003s\u0003raJAB\u0003\u000f\u000bi)C\u0002\u0002\u0006\"\u0012\u0011BR;oGRLwN\\\u0019\u0011\u0007M\u000bI)C\u0002\u0002\fZ\u0011q\u0002U1si&$\u0018n\u001c8fI\u001aKG.\u001a\t\u0007\u0003/\ty)a%\n\t\u0005E\u0015Q\u0005\u0002\t\u0013R,'/\u0019;peB!\u0011QSAN\u001b\t\t9JC\u0002\u0002\u001aj\t\u0001bY1uC2L8\u000f^\u0005\u0005\u0003;\u000b9JA\u0006J]R,'O\\1m%><\b\"\u0002@\u0011\u0001\u0004y\bBBA,!\u0001\u0007!\u0010\u0003\u0004\u0002&B\u0001\rA_\u0001\u0010a\u0006\u0014H/\u001b;j_:\u001c6\r[3nC\"1\u0011\u0011\u0016\tA\u0002i\faB]3rk&\u0014X\rZ*dQ\u0016l\u0017\rC\u0004\u0002.B\u0001\r!a,\u0002\u000f\u0019LG\u000e^3sgB1\u0011qCA\u0011\u0003c\u00032aVAZ\u0013\r\t)\f\u0017\u0002\u0007\r&dG/\u001a:\t\u000f\u0005%\u0001\u00031\u0001\u0002\f!9\u00111\u0018\tA\u0002\u0005u\u0016A\u00035bI>|\u0007oQ8oMB!\u0011qXAc\u001b\t\t\tM\u0003\u0003\u0002D\u0006=\u0012\u0001B2p]\u001aLA!a2\u0002B\ni1i\u001c8gS\u001e,(/\u0019;j_:\fqb];qa>\u0014H\u000fR1uCRK\b/\u001a\u000b\u0004[\u00065\u0007\"\u0002!\u0012\u0001\u0004\t\u0015\u0001E:vaB|'\u000f\u001e$jK2$g*Y7f)\ri\u00171\u001b\u0005\u0007\u0003+\u0014\u0002\u0019\u0001\u001b\u0002\t9\fW.\u001a")
public class OrcFileFormat
implements FileFormat,
DataSourceRegister,
Serializable {
    public static String getQuotedSchemaString(DataType dataType) {
        return OrcFileFormat$.MODULE$.getQuotedSchemaString(dataType);
    }

    @Override
    public Option<Seq<String>> vectorTypes(StructType requiredSchema, StructType partitionSchema, SQLConf sqlConf) {
        return FileFormat.vectorTypes$(this, requiredSchema, partitionSchema, sqlConf);
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        return FileFormat.buildReader$(this, sparkSession, dataSchema, partitionSchema, requiredSchema, filters, options, hadoopConf);
    }

    @Override
    public String shortName() {
        return "orc";
    }

    public String toString() {
        return "ORC";
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof OrcFileFormat;
    }

    @Override
    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        return OrcUtils$.MODULE$.inferSchema(sparkSession, files, options);
    }

    @Override
    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        OrcOptions orcOptions = new OrcOptions(options, sparkSession.sessionState().conf());
        Configuration conf = job.getConfiguration();
        conf.set(OrcConf.MAPRED_OUTPUT_SCHEMA.getAttribute(), OrcFileFormat$.MODULE$.getQuotedSchemaString((DataType)dataSchema));
        conf.set(OrcConf.COMPRESS.getAttribute(), orcOptions.compressionCodec());
        ((JobConf)conf).setOutputFormat(OrcOutputFormat.class);
        return new OutputWriterFactory(null){

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new OrcOutputWriter(path, dataSchema, context);
            }

            public String getFileExtension(TaskAttemptContext context) {
                String name = context.getConfiguration().get(OrcConf.COMPRESS.getAttribute());
                String compressionExtension = (String)OrcUtils$.MODULE$.extensionsForCompressionCodecNames().getOrElse((Object)name, (Function0 & Serializable & scala.Serializable)() -> "");
                return new StringBuilder(4).append(compressionExtension).append(".orc").toString();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$getFileExtension$1()}, serializedLambda);
            }
        };
    }

    private boolean supportBatchForNestedColumn(SparkSession sparkSession, StructType schema) {
        boolean hasNestedColumn = ((IterableLike)schema.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.dataType(), Seq$.MODULE$.canBuildFrom())).exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)OrcFileFormat.$anonfun$supportBatchForNestedColumn$2(x0$1)));
        return hasNestedColumn ? sparkSession.sessionState().conf().orcVectorizedReaderNestedColumnEnabled() : true;
    }

    @Override
    public boolean supportBatch(SparkSession sparkSession, StructType schema) {
        SQLConf conf = sparkSession.sessionState().conf();
        return conf.orcVectorizedReaderEnabled() && conf.wholeStageEnabled() && !WholeStageCodegenExec$.MODULE$.isTooManyFields(conf, (DataType)schema) && schema.forall((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)OrcFileFormat.$anonfun$supportBatch$1(this, s))) && this.supportBatchForNestedColumn(sparkSession, schema);
    }

    @Override
    public boolean isSplitable(SparkSession sparkSession, Map<String, String> options, Path path) {
        return true;
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        StructType resultSchema = new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredSchema.fields())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        SQLConf sqlConf = sparkSession.sessionState().conf();
        boolean enableVectorizedReader = this.supportBatch(sparkSession, resultSchema);
        int capacity = sqlConf.orcVectorizedReaderBatchSize();
        OrcConf.IS_SCHEMA_EVOLUTION_CASE_SENSITIVE.setBoolean(hadoopConf, sqlConf.caseSensitiveAnalysis());
        Broadcast broadcastedConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        boolean isCaseSensitive = sparkSession.sessionState().conf().caseSensitiveAnalysis();
        boolean orcFilterPushDown = sparkSession.sessionState().conf().orcFilterPushDown();
        boolean ignoreCorruptFiles = sparkSession.sessionState().conf().ignoreCorruptFiles();
        return (Function1 & Serializable & scala.Serializable)file -> {
            Iterator iterator;
            Configuration conf = ((SerializableConfiguration)broadcastedConf.value()).value();
            Path filePath = new Path(new URI(file.filePath()));
            FileSystem fs = filePath.getFileSystem(conf);
            OrcFile.ReaderOptions readerOptions = OrcFile.readerOptions(conf).filesystem(fs);
            Option resultedColPruneInfo = (Option)Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> OrcFile.createReader(filePath, readerOptions), (Function1 & Serializable & scala.Serializable)reader -> OrcUtils$.MODULE$.requestedColumnIds(isCaseSensitive, dataSchema, requiredSchema, (Reader)reader, conf));
            if (resultedColPruneInfo.isEmpty()) {
                iterator = package$.MODULE$.Iterator().empty();
            } else {
                Tuple2 tuple2;
                if (orcFilterPushDown && filters.nonEmpty()) {
                    OrcUtils$.MODULE$.readCatalystSchema(filePath, conf, ignoreCorruptFiles).foreach((Function1 & Serializable & scala.Serializable)fileSchema -> {
                        OrcFileFormat.$anonfun$buildReaderWithPartitionValues$4(filters, conf, fileSchema);
                        return BoxedUnit.UNIT;
                    });
                }
                if ((tuple2 = (Tuple2)resultedColPruneInfo.get()) == null) {
                    throw new MatchError((Object)tuple2);
                }
                int[] requestedColIds = (int[])tuple2._1();
                boolean canPruneCols = tuple2._2$mcZ$sp();
                Tuple2 tuple22 = new Tuple2((Object)requestedColIds, (Object)BoxesRunTime.boxToBoolean((boolean)canPruneCols));
                Tuple2 tuple23 = tuple22;
                int[] requestedColIds2 = (int[])tuple23._1();
                boolean canPruneCols2 = tuple23._2$mcZ$sp();
                String resultSchemaString = OrcUtils$.MODULE$.orcResultSchemaString(canPruneCols2, dataSchema, resultSchema, partitionSchema, conf);
                Predef$.MODULE$.assert(requestedColIds2.length == requiredSchema.length(), (Function0 & Serializable & scala.Serializable)() -> "[BUG] requested column IDs do not match required schema");
                Configuration taskConf = new Configuration(conf);
                String includeColumns = new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(requestedColIds2)).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$3 -> x$3 != -1))).sorted((Ordering)Ordering.Int$.MODULE$))).mkString(",");
                taskConf.set(OrcConf.INCLUDE_COLUMNS.getAttribute(), includeColumns);
                FileSplit fileSplit = new FileSplit(filePath, file.start(), file.length(), (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
                TaskAttemptID attemptId = new TaskAttemptID(new TaskID(new JobID(), TaskType.MAP, 0), 0);
                TaskAttemptContextImpl taskAttemptContext = new TaskAttemptContextImpl(taskConf, attemptId);
                if (enableVectorizedReader) {
                    OrcColumnarBatchReader batchReader = new OrcColumnarBatchReader(capacity);
                    RecordReaderIterator<ColumnarBatch> iter = new RecordReaderIterator<ColumnarBatch>(batchReader);
                    Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1 & Serializable & scala.Serializable)x$4 -> x$4.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$5 -> {
                        iter.close();
                        return BoxedUnit.UNIT;
                    }));
                    int[] requestedDataColIds = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(requestedColIds2)).$plus$plus((GenTraversableOnce)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])Array$.MODULE$.fill(partitionSchema.length(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1, ClassTag$.MODULE$.Int()))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
                    int[] requestedPartitionColIds = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])Array$.MODULE$.fill(requiredSchema.length(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1, ClassTag$.MODULE$.Int()))).$plus$plus((GenTraversableOnce)package$.MODULE$.Range().apply(0, partitionSchema.length()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
                    batchReader.initialize((InputSplit)fileSplit, (TaskAttemptContext)taskAttemptContext);
                    batchReader.initBatch(TypeDescription.fromString(resultSchemaString), resultSchema.fields(), requestedDataColIds, requestedPartitionColIds, file.partitionValues());
                    iterator = iter;
                } else {
                    RecordReader orcRecordReader = new OrcInputFormat().createRecordReader((InputSplit)fileSplit, (TaskAttemptContext)taskAttemptContext);
                    RecordReaderIterator iter = new RecordReaderIterator(orcRecordReader);
                    Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1 & Serializable & scala.Serializable)x$6 -> x$6.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$7 -> {
                        iter.close();
                        return BoxedUnit.UNIT;
                    }));
                    Seq fullSchema = (Seq)requiredSchema.toAttributes().$plus$plus((GenTraversableOnce)partitionSchema.toAttributes(), Seq$.MODULE$.canBuildFrom());
                    UnsafeProjection unsafeProjection = (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)fullSchema, fullSchema);
                    OrcDeserializer deserializer = new OrcDeserializer(requiredSchema, requestedColIds2);
                    if (partitionSchema.length() == 0) {
                        iterator = iter.map((Function1 & Serializable & scala.Serializable)value -> unsafeProjection.apply(deserializer.deserialize((OrcStruct)value)));
                    } else {
                        JoinedRow joinedRow = new JoinedRow();
                        iterator = iter.map((Function1 & Serializable & scala.Serializable)value -> unsafeProjection.apply((InternalRow)joinedRow.apply(deserializer.deserialize((OrcStruct)value), file.partitionValues())));
                    }
                }
            }
            return iterator;
        };
    }

    @Override
    public boolean supportDataType(DataType dataType) {
        boolean bl;
        DataType dataType2 = dataType;
        if (dataType2 instanceof AnsiIntervalType) {
            bl = false;
        } else if (dataType2 instanceof AtomicType) {
            bl = true;
        } else if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            bl = structType.forall((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)this.supportDataType(f.dataType())));
        } else if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType elementType = arrayType.elementType();
            bl = this.supportDataType(elementType);
        } else if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            bl = this.supportDataType(keyType) && this.supportDataType(valueType);
        } else if (dataType2 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            bl = this.supportDataType(userDefinedType.sqlType());
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean supportFieldName(String name) {
        boolean bl;
        try {
            TypeDescription.fromString(new StringBuilder(14).append("struct<`").append(name).append("`:int>").toString());
            bl = true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$supportBatchForNestedColumn$2(DataType x0$1) {
        DataType dataType = x0$1;
        boolean bl = dataType instanceof ArrayType ? true : (dataType instanceof MapType ? true : dataType instanceof StructType);
        boolean bl2 = bl;
        return bl2;
    }

    public static final /* synthetic */ boolean $anonfun$supportBatch$1(OrcFileFormat $this, StructField s) {
        return $this.supportDataType(s.dataType()) && !(s.dataType() instanceof UserDefinedType);
    }

    public static final /* synthetic */ void $anonfun$buildReaderWithPartitionValues$5(Configuration conf$1, StructType fileSchema$1, SearchArgument f) {
        OrcInputFormat.setSearchArgument(conf$1, f, fileSchema$1.fieldNames());
    }

    public static final /* synthetic */ void $anonfun$buildReaderWithPartitionValues$4(Seq filters$1, Configuration conf$1, StructType fileSchema) {
        OrcFilters$.MODULE$.createFilter(fileSchema, (Seq<Filter>)filters$1).foreach((Function1 & Serializable & scala.Serializable)f -> {
            OrcFileFormat.$anonfun$buildReaderWithPartitionValues$5(conf$1, fileSchema, f);
            return BoxedUnit.UNIT;
        });
    }

    public OrcFileFormat() {
        FileFormat.$init$(this);
    }
}

