/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.spark.SparkEnv;
import org.apache.spark.TaskContext;
import org.apache.spark.internal.config.package$;
import org.apache.spark.memory.TaskMemoryManager;
import org.apache.spark.serializer.SerializerManager;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.BaseOrdering;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateOrdering;
import org.apache.spark.sql.execution.SortPrefixUtils;
import org.apache.spark.sql.execution.UnsafeExternalRowSorter;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.unsafe.KVIterator;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.UnsafeAlignedOffset;
import org.apache.spark.unsafe.array.LongArray;
import org.apache.spark.unsafe.map.BytesToBytesMap;
import org.apache.spark.unsafe.memory.MemoryBlock;
import org.apache.spark.util.collection.unsafe.sort.PrefixComparator;
import org.apache.spark.util.collection.unsafe.sort.RecordComparator;
import org.apache.spark.util.collection.unsafe.sort.UnsafeExternalSorter;
import org.apache.spark.util.collection.unsafe.sort.UnsafeInMemorySorter;
import org.apache.spark.util.collection.unsafe.sort.UnsafeSorterIterator;

public final class UnsafeKVExternalSorter {
    private final StructType keySchema;
    private final StructType valueSchema;
    private final UnsafeExternalRowSorter.PrefixComputer prefixComputer;
    private final UnsafeExternalSorter sorter;

    public UnsafeKVExternalSorter(StructType keySchema, StructType valueSchema, BlockManager blockManager, SerializerManager serializerManager, long pageSizeBytes, int numElementsForSpillThreshold) throws IOException {
        this(keySchema, valueSchema, blockManager, serializerManager, pageSizeBytes, numElementsForSpillThreshold, null);
    }

    public UnsafeKVExternalSorter(StructType keySchema, StructType valueSchema, BlockManager blockManager, SerializerManager serializerManager, long pageSizeBytes, int numElementsForSpillThreshold, @Nullable BytesToBytesMap map) throws IOException {
        this.keySchema = keySchema;
        this.valueSchema = valueSchema;
        TaskContext taskContext = TaskContext.get();
        this.prefixComputer = SortPrefixUtils.createPrefixGenerator(keySchema);
        PrefixComparator prefixComparator = SortPrefixUtils.getPrefixComparator(keySchema);
        BaseOrdering ordering = GenerateOrdering.create((StructType)keySchema);
        Supplier<RecordComparator> comparatorSupplier = () -> new KVComparator(ordering, keySchema.length());
        boolean canUseRadixSort = keySchema.length() == 1 && SortPrefixUtils.canSortFullyWithPrefix(keySchema.apply(0));
        TaskMemoryManager taskMemoryManager = taskContext.taskMemoryManager();
        if (map == null) {
            this.sorter = UnsafeExternalSorter.create((TaskMemoryManager)taskMemoryManager, (BlockManager)blockManager, (SerializerManager)serializerManager, (TaskContext)taskContext, comparatorSupplier, (PrefixComparator)prefixComparator, (int)((int)((Long)SparkEnv.get().conf().get(package$.MODULE$.SHUFFLE_SORT_INIT_BUFFER_SIZE())).longValue()), (long)pageSizeBytes, (int)numElementsForSpillThreshold, (boolean)canUseRadixSort);
        } else {
            LongArray pointerArray = map.getArray();
            if ((long)map.numValues() > pointerArray.size() / 4L) {
                pointerArray = map.allocateArray((long)map.numValues() * 4L);
            }
            UnsafeInMemorySorter inMemSorter = new UnsafeInMemorySorter(null, taskMemoryManager, comparatorSupplier.get(), prefixComparator, pointerArray, canUseRadixSort);
            BytesToBytesMap.MapIterator iter = map.iterator();
            int numKeyFields = keySchema.size();
            UnsafeRow row = new UnsafeRow(numKeyFields);
            while (iter.hasNext()) {
                BytesToBytesMap.Location loc = iter.next();
                Object baseObject = loc.getKeyBase();
                long baseOffset = loc.getKeyOffset();
                MemoryBlock page = loc.getMemoryPage();
                long address = taskMemoryManager.encodePageNumberAndOffset(page, baseOffset - (long)(2 * UnsafeAlignedOffset.getUaoSize()));
                row.pointTo(baseObject, baseOffset, loc.getKeyLength());
                UnsafeExternalRowSorter.PrefixComputer.Prefix prefix = this.prefixComputer.computePrefix((InternalRow)row);
                inMemSorter.insertRecord(address, prefix.value, prefix.isNull);
            }
            this.sorter = UnsafeExternalSorter.createWithExistingInMemorySorter((TaskMemoryManager)taskMemoryManager, (BlockManager)blockManager, (SerializerManager)serializerManager, (TaskContext)taskContext, comparatorSupplier, (PrefixComparator)prefixComparator, (int)((int)((Long)SparkEnv.get().conf().get(package$.MODULE$.SHUFFLE_SORT_INIT_BUFFER_SIZE())).longValue()), (long)pageSizeBytes, (int)numElementsForSpillThreshold, (UnsafeInMemorySorter)inMemSorter, (long)map.getTotalMemoryConsumption());
            map.reset();
        }
    }

    public void insertKV(UnsafeRow key, UnsafeRow value) throws IOException {
        UnsafeExternalRowSorter.PrefixComputer.Prefix prefix = this.prefixComputer.computePrefix((InternalRow)key);
        this.sorter.insertKVRecord(key.getBaseObject(), key.getBaseOffset(), key.getSizeInBytes(), value.getBaseObject(), value.getBaseOffset(), value.getSizeInBytes(), prefix.value, prefix.isNull);
    }

    public void merge(UnsafeKVExternalSorter other) throws IOException {
        this.sorter.merge(other.sorter);
    }

    public KVSorterIterator sortedIterator() throws IOException {
        try {
            UnsafeSorterIterator underlying = this.sorter.getSortedIterator();
            if (!underlying.hasNext()) {
                this.cleanupResources();
            }
            return new KVSorterIterator(underlying);
        }
        catch (IOException e) {
            this.cleanupResources();
            throw e;
        }
    }

    public long getSpillSize() {
        return this.sorter.getSpillSize();
    }

    public long getPeakMemoryUsedBytes() {
        return this.sorter.getPeakMemoryUsedBytes();
    }

    @VisibleForTesting
    void closeCurrentPage() {
        this.sorter.closeCurrentPage();
    }

    public void cleanupResources() {
        this.sorter.cleanupResources();
    }

    public class KVSorterIterator
    extends KVIterator<UnsafeRow, UnsafeRow> {
        private UnsafeRow key;
        private UnsafeRow value;
        private final UnsafeSorterIterator underlying;

        private KVSorterIterator(UnsafeSorterIterator underlying) {
            this.key = new UnsafeRow(UnsafeKVExternalSorter.this.keySchema.size());
            this.value = new UnsafeRow(UnsafeKVExternalSorter.this.valueSchema.size());
            this.underlying = underlying;
        }

        public boolean next() throws IOException {
            try {
                if (this.underlying.hasNext()) {
                    this.underlying.loadNext();
                    Object baseObj = this.underlying.getBaseObject();
                    long recordOffset = this.underlying.getBaseOffset();
                    int recordLen = this.underlying.getRecordLength();
                    int uaoSize = UnsafeAlignedOffset.getUaoSize();
                    int keyLen = Platform.getInt((Object)baseObj, (long)recordOffset);
                    int valueLen = recordLen - keyLen - uaoSize;
                    this.key.pointTo(baseObj, recordOffset + (long)uaoSize, keyLen);
                    this.value.pointTo(baseObj, recordOffset + (long)uaoSize + (long)keyLen, valueLen);
                    return true;
                }
                this.key = null;
                this.value = null;
                UnsafeKVExternalSorter.this.cleanupResources();
                return false;
            }
            catch (IOException e) {
                UnsafeKVExternalSorter.this.cleanupResources();
                throw e;
            }
        }

        public UnsafeRow getKey() {
            return this.key;
        }

        public UnsafeRow getValue() {
            return this.value;
        }

        public void close() {
            UnsafeKVExternalSorter.this.cleanupResources();
        }
    }

    private static final class KVComparator
    extends RecordComparator {
        private final BaseOrdering ordering;
        private final UnsafeRow row1;
        private final UnsafeRow row2;

        KVComparator(BaseOrdering ordering, int numKeyFields) {
            this.row1 = new UnsafeRow(numKeyFields);
            this.row2 = new UnsafeRow(numKeyFields);
            this.ordering = ordering;
        }

        public int compare(Object baseObj1, long baseOff1, int baseLen1, Object baseObj2, long baseOff2, int baseLen2) {
            int uaoSize = UnsafeAlignedOffset.getUaoSize();
            this.row1.pointTo(baseObj1, baseOff1 + (long)uaoSize, 0);
            this.row2.pointTo(baseObj2, baseOff2 + (long)uaoSize, 0);
            return this.ordering.compare((InternalRow)this.row1, (InternalRow)this.row2);
        }
    }
}

