/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.streaming.CompactibleFileStreamLog$;
import org.apache.spark.sql.execution.streaming.FileStreamOptions;
import org.apache.spark.sql.execution.streaming.FileStreamSink$;
import org.apache.spark.sql.execution.streaming.FileStreamSource;
import org.apache.spark.sql.execution.streaming.FileStreamSourceLog;
import org.apache.spark.sql.execution.streaming.FileStreamSourceLog$;
import org.apache.spark.sql.execution.streaming.FileStreamSourceOffset;
import org.apache.spark.sql.execution.streaming.FileStreamSourceOffset$;
import org.apache.spark.sql.execution.streaming.MemorySink;
import org.apache.spark.sql.execution.streaming.MemoryStream;
import org.apache.spark.sql.execution.streaming.MemoryStream$;
import org.apache.spark.sql.execution.streaming.Offset;
import org.apache.spark.sql.execution.streaming.SerializedOffset;
import org.apache.spark.sql.execution.streaming.StreamExecution;
import org.apache.spark.sql.execution.streaming.StreamingQueryWrapper;
import org.apache.spark.sql.execution.streaming.StreamingRelation;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.streaming.DataStreamReader;
import org.apache.spark.sql.streaming.DataStreamWriter;
import org.apache.spark.sql.streaming.ExistsThrowsExceptionFileSystem;
import org.apache.spark.sql.streaming.ExistsThrowsExceptionFileSystem$;
import org.apache.spark.sql.streaming.FileStreamSourceSuite$;
import org.apache.spark.sql.streaming.FileStreamSourceTest;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.streaming.ProcessingTime;
import org.apache.spark.sql.streaming.StreamTest;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.streaming.StreamingQueryException;
import org.apache.spark.sql.streaming.StreamingQueryProgress;
import org.apache.spark.sql.streaming.Trigger;
import org.apache.spark.sql.streaming.util.StreamManualClock;
import org.apache.spark.sql.streaming.util.StreamManualClock$;
import org.apache.spark.sql.test.SharedSQLContext;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.Clock;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.PrivateMethodTester;
import org.scalatest.Tag;
import org.scalatest.enablers.Timed$;
import org.scalatest.time.Span;
import org.scalatest.time.SpanSugar$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005mc\u0001\u0002\b\u0010\u0001iAQa\b\u0001\u0005\u0002\u0001BqA\t\u0001C\u0002\u0013\u00053\u0005\u0003\u0004-\u0001\u0001\u0006I\u0001\n\u0005\u0006[\u0001!IA\f\u0005\b'\u0002\t\n\u0011\"\u0003U\u0011\u0015y\u0006\u0001\"\u0003a\u0011\u001d)\u0007!%A\u0005\nQCQA\u001a\u0001\u0005B\u001dDQa\u001b\u0001\u0005B\u001dDQ\u0001\u001c\u0001\u0005\n5Dq!!\u0007\u0001\t\u0013\tY\u0002C\u0004\u0002(\u0001!I!!\u000b\t\u0013\u0005U\u0003!%A\u0005\n\u0005]#!\u0006$jY\u0016\u001cFO]3b[N{WO]2f'VLG/\u001a\u0006\u0003!E\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005I\u0019\u0012aA:rY*\u0011A#F\u0001\u0006gB\f'o\u001b\u0006\u0003-]\ta!\u00199bG\",'\"\u0001\r\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001Y\u0002C\u0001\u000f\u001e\u001b\u0005y\u0011B\u0001\u0010\u0010\u0005Q1\u0015\u000e\\3TiJ,\u0017-\\*pkJ\u001cW\rV3ti\u00061A(\u001b8jiz\"\u0012!\t\t\u00039\u0001\t\u0001c\u001d;sK\u0006l\u0017N\\4US6,w.\u001e;\u0016\u0003\u0011\u0002\"!\n\u0016\u000e\u0003\u0019R!a\n\u0015\u0002\tQLW.\u001a\u0006\u0003S]\t\u0011b]2bY\u0006$Xm\u001d;\n\u0005-2#\u0001B*qC:\f\u0011c\u001d;sK\u0006l\u0017N\\4US6,w.\u001e;!\u0003Y\u0019'/Z1uK\u001aKG.Z*ue\u0016\fWnU8ve\u000e,G\u0003B\u00187\u000b\u001e\u0003\"\u0001\r\u001b\u000e\u0003ER!\u0001\u0005\u001a\u000b\u0005M\n\u0012!C3yK\u000e,H/[8o\u0013\t)\u0014G\u0001\tGS2,7\u000b\u001e:fC6\u001cv.\u001e:dK\")q\u0007\u0002a\u0001q\u00051am\u001c:nCR\u0004\"!\u000f\"\u000f\u0005i\u0002\u0005CA\u001e?\u001b\u0005a$BA\u001f\u001a\u0003\u0019a$o\\8u})\tq(A\u0003tG\u0006d\u0017-\u0003\u0002B}\u00051\u0001K]3eK\u001aL!a\u0011#\u0003\rM#(/\u001b8h\u0015\t\te\bC\u0003G\t\u0001\u0007\u0001(\u0001\u0003qCRD\u0007b\u0002%\u0005!\u0003\u0005\r!S\u0001\u0007g\u000eDW-\\1\u0011\u0007)[U*D\u0001?\u0013\taeH\u0001\u0004PaRLwN\u001c\t\u0003\u001dFk\u0011a\u0014\u0006\u0003!F\tQ\u0001^=qKNL!AU(\u0003\u0015M#(/^2u)f\u0004X-\u0001\u0011de\u0016\fG/\u001a$jY\u0016\u001cFO]3b[N{WO]2fI\u0011,g-Y;mi\u0012\u001aT#A++\u0005%36&A,\u0011\u0005akV\"A-\u000b\u0005i[\u0016!C;oG\",7m[3e\u0015\taf(\u0001\u0006b]:|G/\u0019;j_:L!AX-\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0012de\u0016\fG/\u001a$jY\u0016\u001cFO]3b[N{WO]2f\u0003:$w)\u001a;TG\",W.\u0019\u000b\u0005\u001b\u0006\u001cG\rC\u00038\r\u0001\u0007!\rE\u0002K\u0017bBQA\u0012\u0004A\u0002\tDq\u0001\u0013\u0004\u0011\u0002\u0003\u0007\u0011*\u0001\u0017de\u0016\fG/\u001a$jY\u0016\u001cFO]3b[N{WO]2f\u0003:$w)\u001a;TG\",W.\u0019\u0013eK\u001a\fW\u000f\u001c;%g\u0005I!-\u001a4pe\u0016\fE\u000e\u001c\u000b\u0002QB\u0011!*[\u0005\u0003Uz\u0012A!\u00168ji\u0006A\u0011M\u001a;fe\u0006cG.A\nsK\u0006$Gj\\4Ge>l'+Z:pkJ\u001cW\rF\u0002o\u0003+\u00012a\u001c;x\u001d\t\u0001(O\u0004\u0002<c&\tq(\u0003\u0002t}\u00059\u0001/Y2lC\u001e,\u0017BA;w\u0005\r\u0019V-\u001d\u0006\u0003gz\u00022\u0001_A\b\u001d\rI\u00181\u0002\b\u0004u\u0006%abA>\u0002\b9\u0019A0!\u0002\u000f\u0007u\f\u0019AD\u0002\u007f\u0003\u0003q!aO@\n\u0003aI!AF\f\n\u0005Q)\u0012B\u0001\n\u0014\u0013\t\u0019\u0014#\u0003\u0002\u0011e%\u0019\u0011QB\u0019\u0002!\u0019KG.Z*ue\u0016\fWnU8ve\u000e,\u0017\u0002BA\t\u0003'\u0011\u0011BR5mK\u0016sGO]=\u000b\u0007\u00055\u0011\u0007\u0003\u0004\u0002\u0018)\u0001\r\u0001O\u0001\u0004I&\u0014\u0018A\u0006:fC\u0012|eMZ:fi\u001a\u0013x.\u001c*fg>,(oY3\u0015\t\u0005u\u00111\u0005\t\u0004a\u0005}\u0011bAA\u0011c\t\u00012+\u001a:jC2L'0\u001a3PM\u001a\u001cX\r\u001e\u0005\u0007\u0003KY\u0001\u0019\u0001\u001d\u0002\t\u0019LG.Z\u0001\u001eeVtGk^8CCR\u001c\u0007.Z:B]\u00124VM]5gsJ+7/\u001e7ugRY\u0001.a\u000b\u0002@\u0005%\u0013QJA)\u0011\u001d\ti\u0003\u0004a\u0001\u0003_\t1a\u001d:d!\u0011\t\t$a\u000f\u000e\u0005\u0005M\"\u0002BA\u001b\u0003o\t!![8\u000b\u0005\u0005e\u0012\u0001\u00026bm\u0006LA!!\u0010\u00024\t!a)\u001b7f\u0011\u001d\t\t\u0005\u0004a\u0001\u0003\u0007\n1\u0002\\1uKN$h)\u001b:tiB\u0019!*!\u0012\n\u0007\u0005\u001dcHA\u0004C_>dW-\u00198\t\r\u0005-C\u00021\u00019\u0003)1\u0017N]:u\u0005\u0006$8\r\u001b\u0005\u0007\u0003\u001fb\u0001\u0019\u0001\u001d\u0002\u0017M,7m\u001c8e\u0005\u0006$8\r\u001b\u0005\t\u0003'b\u0001\u0013!a\u0001E\u0006QQ.\u0019=GS2,\u0017iZ3\u0002OI,h\u000eV<p\u0005\u0006$8\r[3t\u0003:$g+\u001a:jMf\u0014Vm];miN$C-\u001a4bk2$H%N\u000b\u0003\u00033R#A\u0019,")
public class FileStreamSourceSuite
extends FileStreamSourceTest {
    private final Span streamingTimeout = SpanSugar$.MODULE$.convertIntToGrainOfTime(80).seconds();

    @Override
    public Span streamingTimeout() {
        return this.streamingTimeout;
    }

    private FileStreamSource createFileStreamSource(String format, String path, Option<StructType> schema) {
        return this.getSourceFromFileStream(this.createFileStream(format, path, schema, this.createFileStream$default$4()));
    }

    private Option<StructType> createFileStreamSource$default$3() {
        return None$.MODULE$;
    }

    private StructType createFileStreamSourceAndGetSchema(Option<String> format, Option<String> path, Option<StructType> schema2) {
        DataStreamReader reader = this.spark().readStream();
        format.foreach((Function1 & Serializable & scala.Serializable)source -> reader.format(source));
        schema2.foreach((Function1 & Serializable & scala.Serializable)schema -> reader.schema(schema));
        Dataset df = path.isDefined() ? reader.load((String)path.get()) : reader.load();
        return (StructType)df.queryExecution().analyzed().collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof StreamingRelation) {
                    StreamingRelation streamingRelation = (StreamingRelation)A1;
                    object = streamingRelation.schema();
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                boolean bl = logicalPlan instanceof StreamingRelation;
                return bl;
            }
        }).head();
    }

    private Option<StructType> createFileStreamSourceAndGetSchema$default$3() {
        return None$.MODULE$;
    }

    @Override
    public void beforeAll() {
        SharedSQLContext.beforeAll$(this);
        this.spark().sessionState().conf().setConf(SQLConf$.MODULE$.ORC_IMPLEMENTATION(), (Object)"native");
    }

    @Override
    public void afterAll() {
        try {
            this.spark().sessionState().conf().unsetConf(SQLConf$.MODULE$.ORC_IMPLEMENTATION());
        }
        finally {
            StreamTest.afterAll$(this);
        }
    }

    private Seq<FileStreamSource.FileEntry> readLogFromResource(String dir) {
        URL input = this.getClass().getResource(new StringBuilder(22).append("/structured-streaming/").append(dir).toString());
        FileStreamSourceLog log = new FileStreamSourceLog(FileStreamSourceLog$.MODULE$.VERSION(), this.spark(), input.toString());
        return Predef$.MODULE$.wrapRefArray(log.allFiles());
    }

    private SerializedOffset readOffsetFromResource(String file) {
        String str = Source$.MODULE$.fromFile(this.getClass().getResource(new StringBuilder(22).append("/structured-streaming/").append(file).toString()).toURI(), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        return new SerializedOffset(str.trim());
    }

    private void runTwoBatchesAndVerifyResults(File src, boolean latestFirst, String firstBatch, String secondBatch, Option<String> maxFileAge) {
        Map srcOptions = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"latestFirst"), (Object)((Object)BoxesRunTime.boxToBoolean((boolean)latestFirst)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxFilesPerTrigger"), (Object)"1")}))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(maxFileAge.map((Function1 & Serializable & scala.Serializable)x$25 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxFileAge"), x$25))));
        String x$1 = "text";
        String x$2 = src.getCanonicalPath();
        Map x$3 = srcOptions;
        Option<StructType> x$4 = this.createFileStream$default$3();
        Dataset<Row> fileStream = this.createFileStream(x$1, x$2, x$4, (Map<String, String>)x$3);
        StreamManualClock clock = new StreamManualClock(StreamManualClock$.MODULE$.$lessinit$greater$default$1());
        this.testStream(fileStream, this.testStream$default$2(), this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new StreamTest.StartStream(this, (Trigger)new ProcessingTime(10L), (Clock)clock, this.StartStream().apply$default$3(), this.StartStream().apply$default$4()), this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$runTwoBatchesAndVerifyResults$2(this, clock, x$26)), this.AssertOnQuery().apply$default$2()), this.CheckLastBatch().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{firstBatch}), this.testImplicits().newStringEncoder()), new StreamTest.AdvanceManualClock(this, 10L), this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$runTwoBatchesAndVerifyResults$4(this, clock, x$27)), this.AssertOnQuery().apply$default$2()), this.CheckLastBatch().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{secondBatch}), this.testImplicits().newStringEncoder())}));
    }

    private Option<String> runTwoBatchesAndVerifyResults$default$5() {
        return None$.MODULE$;
    }

    private final void testError$1() {
        IllegalArgumentException e = (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.createFileStreamSourceAndGetSchema((Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<StructType>)None$.MODULE$), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
        String $org_scalatest_assert_macro_left = e.getMessage();
        String $org_scalatest_assert_macro_right = "path";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 245));
    }

    public static final /* synthetic */ void $anonfun$new$12(FileStreamSourceSuite $this, File src) {
        StructType schema = $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"text"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)None$.MODULE$);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(schema);
        StructType $org_scalatest_assert_macro_right = new StructType().add("value", (DataType)StringType$.MODULE$);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 278));
    }

    public static final /* synthetic */ void $anonfun$new$14(FileStreamSourceSuite $this, File src) {
        org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(new File(src, "1"), "a\nb\nc");
        StructType schema = $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"text"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)None$.MODULE$);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(schema);
        StructType $org_scalatest_assert_macro_right = new StructType().add("value", (DataType)StringType$.MODULE$);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 287));
    }

    public static final /* synthetic */ void $anonfun$new$16(FileStreamSourceSuite $this, File src) {
        org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(new File(src, "1"), "a\nb\nc");
        StructType userSchema = new StructType().add("userColumn", (DataType)StringType$.MODULE$);
        StructType schema = $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"text"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)new Some((Object)userSchema));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(schema);
        StructType $org_scalatest_assert_macro_right = userSchema;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 297));
    }

    public static final /* synthetic */ void $anonfun$new$18(FileStreamSourceSuite $this, File src) {
        $this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"})), $this.testImplicits().newStringEncoder()).toDS().as("userColumn").toDF().write().mode(SaveMode.Overwrite).orc(src.getCanonicalPath());
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.intercept((Function0 & Serializable & scala.Serializable)() -> $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"orc"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)None$.MODULE$), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 311)));
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            StructType schema = $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"orc"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)None$.MODULE$);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(schema);
            StructType $org_scalatest_assert_macro_right = new StructType().add("value", (DataType)StringType$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 321));
        });
    }

    public static final /* synthetic */ void $anonfun$new$23(FileStreamSourceSuite $this, File src) {
        $this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"})), $this.testImplicits().newStringEncoder()).toDS().as("oldUserColumn").toDF().write().orc(new File(src, "1").getCanonicalPath());
        StructType userSchema = new StructType().add("userColumn", (DataType)StringType$.MODULE$);
        StructType schema = $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"orc"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)new Some((Object)userSchema));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(schema);
        StructType $org_scalatest_assert_macro_right = userSchema;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 333));
    }

    public static final /* synthetic */ void $anonfun$new$25(FileStreamSourceSuite $this, File src) {
        $this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"})), $this.testImplicits().newStringEncoder()).toDS().as("userColumn").toDF().write().mode(SaveMode.Overwrite).parquet(src.getCanonicalPath());
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.intercept((Function0 & Serializable & scala.Serializable)() -> $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"parquet"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)None$.MODULE$), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 347)));
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            StructType schema = $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"parquet"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)None$.MODULE$);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(schema);
            StructType $org_scalatest_assert_macro_right = new StructType().add("value", (DataType)StringType$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 357));
        });
    }

    public static final /* synthetic */ void $anonfun$new$30(FileStreamSourceSuite $this, File src) {
        $this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"})), $this.testImplicits().newStringEncoder()).toDS().as("oldUserColumn").toDF().write().parquet(new File(src, "1").getCanonicalPath());
        StructType userSchema = new StructType().add("userColumn", (DataType)StringType$.MODULE$);
        StructType schema = $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"parquet"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)new Some((Object)userSchema));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(schema);
        StructType $org_scalatest_assert_macro_right = userSchema;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 369));
    }

    public static final /* synthetic */ void $anonfun$new$36(FileStreamSourceSuite $this, File src) {
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.intercept((Function0 & Serializable & scala.Serializable)() -> $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"json"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)None$.MODULE$), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 393)));
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(new File(src, "1"), "{'c': '1'}\n{'c': '2'}\n{'c': '3'}");
            StructType schema = $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"json"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)None$.MODULE$);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(schema);
            StructType $org_scalatest_assert_macro_right = new StructType().add("c", (DataType)StringType$.MODULE$);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 404));
        });
    }

    public static final /* synthetic */ void $anonfun$new$41(FileStreamSourceSuite $this, File src) {
        org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(new File(src, "1"), "{'c': '1'}\n{'c': '2'}\n{'c', '3'}");
        StructType userSchema = new StructType().add("userColumn", (DataType)StringType$.MODULE$);
        StructType schema = $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"json"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)new Some((Object)userSchema));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(schema);
        StructType $org_scalatest_assert_macro_right = userSchema;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 415));
    }

    public static final /* synthetic */ void $anonfun$new$43(FileStreamSourceSuite $this, File x0$1, File x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        Dataset<Row> textStream = $this.createFileStream("text", src.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
        Dataset filtered = textStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
        $this.testStream(filtered, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "drop1\nkeep2\nkeep3", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), $this.testImplicits().newStringEncoder()), $this.StopStream(), new FileStreamSourceTest.AddTextFileData($this, "drop4\nkeep5\nkeep6", src, tmp, $this.AddTextFileData().apply$default$4()), new StreamTest.StartStream($this, $this.StartStream().apply$default$1(), $this.StartStream().apply$default$2(), $this.StartStream().apply$default$3(), $this.StartStream().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "drop7\nkeep8\nkeep9", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6", "keep8", "keep9"}), $this.testImplicits().newStringEncoder())}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$45(FileStreamSourceSuite $this, File x0$2, File x1$2) {
        Tuple2 tuple2 = new Tuple2((Object)x0$2, (Object)x1$2);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        Dataset<Row> textStream = $this.createFileStream("text", src.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
        Dataset filtered = textStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
        $this.testStream(filtered, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "drop1\nkeep2\nkeep3", src, tmp, "text text"), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), $this.testImplicits().newStringEncoder())}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$48(FileStreamSourceSuite $this, String testTableName$1, File x0$3, File x1$3) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = new Tuple2((Object)x0$3, (Object)x1$3);
        if (tuple2 != null) {
            File src = (File)tuple2._1();
            File checkpoint = (File)tuple2._2();
            File output = new File(src, "text text");
            MemoryStream inputData = MemoryStream$.MODULE$.apply($this.testImplicits().newStringEncoder(), $this.sqlContext());
            Dataset ds = inputData.toDS();
            StreamingQuery query = ds.writeStream().option("checkpointLocation", checkpoint.getCanonicalPath()).format("text").start(output.getCanonicalPath());
            try {
                inputData.addData((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"}));
                $this.failAfter($this.streamingTimeout(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> query.processAllAvailable(), $this.defaultSignaler(), Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 466), Timed$.MODULE$.timed());
            }
            finally {
                query.stop();
            }
            Dataset df2 = $this.spark().readStream().format("text").load(output.getCanonicalPath());
            StreamingQuery query2 = df2.writeStream().format("memory").queryName(testTableName$1).start();
            try {
                query2.processAllAvailable();
                $this.checkDatasetUnorderly((Function0 & Serializable & scala.Serializable)() -> $this.spark().table(testTableName$1).as($this.testImplicits().newStringEncoder()), Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"}), Ordering.String$.MODULE$);
                boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                query2.stop();
            }
        }
        throw new MatchError((Object)tuple2);
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$new$52(FileStreamSourceSuite $this, File x0$4, File x1$4) {
        Tuple2 tuple2 = new Tuple2((Object)x0$4, (Object)x1$4);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        Dataset textStream = $this.spark().readStream().textFile(src.getCanonicalPath());
        Dataset filtered = textStream.filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.contains("keep")));
        $this.testStream(filtered, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "drop1\nkeep2\nkeep3", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), $this.testImplicits().newStringEncoder()), $this.StopStream(), new FileStreamSourceTest.AddTextFileData($this, "drop4\nkeep5\nkeep6", src, tmp, $this.AddTextFileData().apply$default$4()), new StreamTest.StartStream($this, $this.StartStream().apply$default$1(), $this.StartStream().apply$default$2(), $this.StartStream().apply$default$3(), $this.StartStream().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "drop7\nkeep8\nkeep9", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6", "keep8", "keep9"}), $this.testImplicits().newStringEncoder())}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$new$56(StreamExecution x$3) {
        Thread.sleep(1000L);
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$new$57(FileStreamSourceSuite $this, StreamExecution streamExecution) {
        FileStreamSource source = (FileStreamSource)$this.getSourcesFromStreamingQuery(streamExecution).head();
        FileStreamSource.SeenFilesMap $org_scalatest_assert_macro_left = source.seenFiles();
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 530));
        return true;
    }

    public static final /* synthetic */ void $anonfun$new$55(FileStreamSourceSuite $this, File x0$5, File x1$5) {
        Tuple2 tuple2 = new Tuple2((Object)x0$5, (Object)x1$5);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        String x$1 = "text";
        String x$2 = src.getCanonicalPath();
        Map x$32 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxFileAge"), (Object)"5ms")}));
        Option<StructType> x$4 = $this.createFileStream$default$3();
        Dataset<Row> textStream = $this.createFileStream(x$1, x$2, x$4, (Map<String, String>)x$32);
        $this.testStream(textStream, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "a\nb", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"}), $this.testImplicits().newStringEncoder()), $this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$56(x$3)), $this.AssertOnQuery().apply$default$2()), new FileStreamSourceTest.AddTextFileData($this, "c\nd", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c", "d"}), $this.testImplicits().newStringEncoder()), $this.AssertOnQuery().apply("seen files should contain only one entry", (Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)streamExecution -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$57($this, streamExecution)))}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$59(FileStreamSourceSuite $this, File dir) {
        String message;
        String path = dir.getCanonicalPath();
        String defaultFs = "nonexistFS://nonexistFS";
        String expectMessage = "No FileSystem for scheme: nonexistFS";
        String $org_scalatest_assert_macro_left = message = ((Throwable)$this.intercept((Function0 & Serializable & scala.Serializable)() -> $this.spark().readStream().option("fs.defaultFS", defaultFs).text(path), ClassTag$.MODULE$.apply(IOException.class), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 542))).getMessage();
        String $org_scalatest_assert_macro_right = expectMessage;
        String string = $org_scalatest_assert_macro_left;
        String string2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 545));
    }

    public static final /* synthetic */ void $anonfun$new$62(FileStreamSourceSuite $this, File x0$6, File x1$6) {
        Tuple2 tuple2 = new Tuple2((Object)x0$6, (Object)x1$6);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        Dataset<Row> fileStream = $this.createFileStream("json", src.getCanonicalPath(), (Option<StructType>)new Some((Object)$this.valueSchema()), $this.createFileStream$default$4());
        Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
        $this.testStream(filtered, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "{'value': 'drop1'}\n{'value': 'keep2'}\n{'value': 'keep3'}", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), $this.testImplicits().newStringEncoder()), $this.StopStream(), new FileStreamSourceTest.AddTextFileData($this, "{'value': 'drop4'}\n{'value': 'keep5'}\n{'value': 'keep6'}", src, tmp, $this.AddTextFileData().apply$default$4()), new StreamTest.StartStream($this, $this.StartStream().apply$default$1(), $this.StartStream().apply$default$2(), $this.StartStream().apply$default$3(), $this.StartStream().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "{'value': 'drop7'}\n{'value': 'keep8'}\n{'value': 'keep9'}", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6", "keep8", "keep9"}), $this.testImplicits().newStringEncoder())}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$64(FileStreamSourceSuite $this, File x0$7, File x1$7) {
        Tuple2 tuple2 = new Tuple2((Object)x0$7, (Object)x1$7);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(new File(src, "existing"), "{'c': 'drop1'}\n{'c': 'keep2'}\n{'c': 'keep3'}");
            Dataset<Row> fileStream = $this.createFileStream("json", src.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(fileStream.schema());
            StructType $org_scalatest_assert_macro_right = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("c", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 586));
            Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
            $this.testStream(filtered, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "{'c': 'drop4'}\n{'c': 'keep5'}\n{'c': 'keep6'}", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6"}), $this.testImplicits().newStringEncoder())}));
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$67(FileStreamSourceSuite $this, File x0$8, File x1$8) {
        Tuple2 tuple2 = new Tuple2((Object)x0$8, (Object)x1$8);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File baseSrc = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            File src = new File(baseSrc, "type=X");
            src.mkdirs();
            org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(new File(src, "existing"), "{'c': 'drop1'}\n{'c': 'keep2'}\n{'c': 'keep3'}");
            Dataset<Row> fileStream = $this.createFileStream("json", src.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
            Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
            $this.testStream(filtered, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "{'c': 'drop4'}\n{'c': 'keep5'}\n{'c': 'keep6'}", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6"}), $this.testImplicits().newStringEncoder())}));
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$70(FileStreamSourceSuite $this, File x0$9, File x1$9) {
        Tuple2 tuple2 = new Tuple2((Object)x0$9, (Object)x1$9);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(new File(src, "existing"), "{'k': 'value0'}");
            Dataset<Row> fileStream = $this.createFileStream("json", src.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(fileStream.schema());
            StructType $org_scalatest_assert_macro_right = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("k", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 631));
            org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(new File(src, "existing2"), "{'k': 'value1', 'v': 'new'}");
            $this.testStream(fileStream, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "{'k': 'value2'}", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value0", "value1", "value2"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "{'k': 'value3', 'v': 'new'}", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value0", "value1", "value2", "value3"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "{'v': 'value4'}", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value0", "value1", "value2", "value3", null}), $this.testImplicits().newStringEncoder())}));
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$73(FileStreamSourceSuite $this, File x0$10, File x1$10) {
        Tuple2 tuple2 = new Tuple2((Object)x0$10, (Object)x1$10);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        Dataset<Row> fileStream = $this.createFileStream("orc", src.getCanonicalPath(), (Option<StructType>)new Some((Object)$this.valueSchema()), $this.createFileStream$default$4());
        Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
        $this.testStream(filtered, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{$this.AddOrcFileData().apply((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop1", "keep2", "keep3"}))), src, tmp), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), $this.testImplicits().newStringEncoder()), $this.StopStream(), $this.AddOrcFileData().apply((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop4", "keep5", "keep6"}))), src, tmp), new StreamTest.StartStream($this, $this.StartStream().apply$default$1(), $this.StartStream().apply$default$2(), $this.StartStream().apply$default$3(), $this.StartStream().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6"}), $this.testImplicits().newStringEncoder()), $this.AddOrcFileData().apply((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop7", "keep8", "keep9"}))), src, tmp), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6", "keep8", "keep9"}), $this.testImplicits().newStringEncoder())}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$75(FileStreamSourceSuite $this, File x0$11, File x1$11) {
        Tuple2 tuple2 = new Tuple2((Object)x0$11, (Object)x1$11);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.AddOrcFileData().writeToFile((Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value0"})), $this.testImplicits().newStringEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k"})), src, tmp);
            Dataset<Row> fileStream = $this.createFileStream("orc", src.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(fileStream.schema());
            StructType $org_scalatest_assert_macro_right = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("k", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 684));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator101$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator101$1(FileStreamSourceSuite $outer) {
                }
            }
            $this.AddOrcFileData().writeToFile((Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"value1", (Object)BoxesRunTime.boxToInteger((int)0))})), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator101$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k", "v"})), src, tmp);
            StreamTest.StreamAction[] streamActionArray = new StreamTest.StreamAction[6];
            streamActionArray[0] = new FileStreamSourceTest.AddOrcFileData($this, (Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value2"})), $this.testImplicits().newStringEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k"})), src, tmp);
            streamActionArray[1] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value0", "value1", "value2"}), $this.testImplicits().newStringEncoder());
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator118$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator118$1(FileStreamSourceSuite $outer) {
                }
            }
            streamActionArray[2] = new FileStreamSourceTest.AddOrcFileData($this, (Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"value3", (Object)BoxesRunTime.boxToInteger((int)1))})), $this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator118$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k", "v"})), src, tmp);
            streamActionArray[3] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value0", "value1", "value2", "value3"}), $this.testImplicits().newStringEncoder());
            streamActionArray[4] = new FileStreamSourceTest.AddOrcFileData($this, (Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value5"})), $this.testImplicits().newStringEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"v"})), src, tmp);
            streamActionArray[5] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value0", "value1", "value2", "value3", null}), $this.testImplicits().newStringEncoder());
            $this.testStream(fileStream, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])streamActionArray));
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$78(FileStreamSourceSuite $this, File x0$12, File x1$12) {
        Tuple2 tuple2 = new Tuple2((Object)x0$12, (Object)x1$12);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        Dataset<Row> fileStream = $this.createFileStream("parquet", src.getCanonicalPath(), (Option<StructType>)new Some((Object)$this.valueSchema()), $this.createFileStream$default$4());
        Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
        $this.testStream(filtered, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{$this.AddParquetFileData().apply((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop1", "keep2", "keep3"}))), src, tmp), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), $this.testImplicits().newStringEncoder()), $this.StopStream(), $this.AddParquetFileData().apply((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop4", "keep5", "keep6"}))), src, tmp), new StreamTest.StartStream($this, $this.StartStream().apply$default$1(), $this.StartStream().apply$default$2(), $this.StartStream().apply$default$3(), $this.StartStream().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6"}), $this.testImplicits().newStringEncoder()), $this.AddParquetFileData().apply((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop7", "keep8", "keep9"}))), src, tmp), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6", "keep8", "keep9"}), $this.testImplicits().newStringEncoder())}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$80(FileStreamSourceSuite $this, File x0$13, File x1$13) {
        Tuple2 tuple2 = new Tuple2((Object)x0$13, (Object)x1$13);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.AddParquetFileData().writeToFile((Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value0"})), $this.testImplicits().newStringEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k"})), src, tmp);
            Dataset<Row> fileStream = $this.createFileStream("parquet", src.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(fileStream.schema());
            StructType $org_scalatest_assert_macro_right = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("k", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 738));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator153$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator153$1(FileStreamSourceSuite $outer) {
                }
            }
            $this.AddParquetFileData().writeToFile((Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"value1", (Object)BoxesRunTime.boxToInteger((int)0))})), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator153$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k", "v"})), src, tmp);
            StreamTest.StreamAction[] streamActionArray = new StreamTest.StreamAction[6];
            streamActionArray[0] = new FileStreamSourceTest.AddParquetFileData($this, (Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value2"})), $this.testImplicits().newStringEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k"})), src, tmp);
            streamActionArray[1] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value0", "value1", "value2"}), $this.testImplicits().newStringEncoder());
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator170$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator170$1(FileStreamSourceSuite $outer) {
                }
            }
            streamActionArray[2] = new FileStreamSourceTest.AddParquetFileData($this, (Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"value3", (Object)BoxesRunTime.boxToInteger((int)1))})), $this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator170$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k", "v"})), src, tmp);
            streamActionArray[3] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value0", "value1", "value2", "value3"}), $this.testImplicits().newStringEncoder());
            streamActionArray[4] = new FileStreamSourceTest.AddParquetFileData($this, (Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value5"})), $this.testImplicits().newStringEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"v"})), src, tmp);
            streamActionArray[5] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value0", "value1", "value2", "value3", null}), $this.testImplicits().newStringEncoder());
            $this.testStream(fileStream, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])streamActionArray));
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$83(FileStreamSourceSuite $this, File x0$14, File x1$14) {
        Tuple2 tuple2 = new Tuple2((Object)x0$14, (Object)x1$14);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File dir = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        Dataset<Row> fileStream = $this.createFileStream("text", new StringBuilder(4).append(dir.getCanonicalPath()).append("/*/*").toString(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
        Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
        File subDir = new File(dir, "subdir");
        File subSubDir = new File(subDir, "subsubdir");
        File subSubSubDir = new File(subSubDir, "subsubsubdir");
        Predef$.MODULE$.require(!subDir.exists());
        Predef$.MODULE$.require(!subSubDir.exists());
        $this.testStream(filtered, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "drop1\nkeep2", subDir, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "keep3", subDir, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "keep4", subSubDir, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep4"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "keep5", subSubDir, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep4", "keep5"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "keep6", dir, tmp, $this.AddTextFileData().apply$default$4()), new FileStreamSourceTest.AddTextFileData($this, "keep7", subSubSubDir, tmp, $this.AddTextFileData().apply$default$4()), new FileStreamSourceTest.AddTextFileData($this, "keep8", subDir, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep4", "keep5", "keep8"}), $this.testImplicits().newStringEncoder())}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$85(FileStreamSourceSuite $this, File x0$15, File x1$15) {
        Tuple2 tuple2 = new Tuple2((Object)x0$15, (Object)x1$15);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File dir = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        File partitionFooSubDir = new File(dir, "partition=foo");
        File partitionBarSubDir = new File(dir, "partition=bar");
        StructType schema = new StructType().add("value", (DataType)StringType$.MODULE$).add("partition", (DataType)StringType$.MODULE$);
        Dataset<Row> fileStream = $this.createFileStream("json", new StringBuilder(4).append(dir.getCanonicalPath()).append("/*/*").toString(), (Option<StructType>)new Some((Object)schema), $this.createFileStream$default$4());
        Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
        Object nullStr = null;
        StreamTest.StreamAction[] streamActionArray = new StreamTest.StreamAction[8];
        streamActionArray[0] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'drop1'}\n{'value': 'keep2'}", partitionFooSubDir, tmp, $this.AddTextFileData().apply$default$4());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator201$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator201$1(FileStreamSourceSuite $outer) {
            }
        }
        streamActionArray[1] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", nullStr)}), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator201$1(null))));
        streamActionArray[2] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'keep3'}", partitionFooSubDir, tmp, $this.AddTextFileData().apply$default$4());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator205$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator205$1(FileStreamSourceSuite $outer) {
            }
        }
        streamActionArray[3] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", nullStr), new Tuple2((Object)"keep3", nullStr)}), $this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator205$1(null))));
        streamActionArray[4] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'keep4'}", partitionBarSubDir, tmp, $this.AddTextFileData().apply$default$4());
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator209$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator209$1(FileStreamSourceSuite $outer) {
            }
        }
        streamActionArray[5] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", nullStr), new Tuple2((Object)"keep3", nullStr), new Tuple2((Object)"keep4", nullStr)}), $this.testImplicits().newProductEncoder(((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator209$1(null))));
        streamActionArray[6] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'keep5'}", partitionBarSubDir, tmp, $this.AddTextFileData().apply$default$4());
        JavaUniverse $u4 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m4 = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator213$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator213$1(FileStreamSourceSuite $outer) {
            }
        }
        streamActionArray[7] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", nullStr), new Tuple2((Object)"keep3", nullStr), new Tuple2((Object)"keep4", nullStr), new Tuple2((Object)"keep5", nullStr)}), $this.testImplicits().newProductEncoder(((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator213$1(null))));
        $this.testStream(filtered, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])streamActionArray));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$87(FileStreamSourceSuite $this, File x0$16, File x1$16) {
        Tuple2 tuple2 = new Tuple2((Object)x0$16, (Object)x1$16);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File dir = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        File partitionFooSubDir = new File(dir, "partition=foo");
        File partitionBarSubDir = new File(dir, "partition=bar");
        StructType schema = new StructType().add("value", (DataType)StringType$.MODULE$).add("partition", (DataType)StringType$.MODULE$);
        Dataset<Row> fileStream = $this.createFileStream("json", String.valueOf(dir.getCanonicalPath()), (Option<StructType>)new Some((Object)schema), $this.createFileStream$default$4());
        Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
        StreamTest.StreamAction[] streamActionArray = new StreamTest.StreamAction[8];
        streamActionArray[0] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'drop1'}\n{'value': 'keep2'}", partitionFooSubDir, tmp, $this.AddTextFileData().apply$default$4());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator217$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator217$1(FileStreamSourceSuite $outer) {
            }
        }
        streamActionArray[1] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", (Object)"foo")}), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator217$1(null))));
        streamActionArray[2] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'keep3'}", partitionFooSubDir, tmp, $this.AddTextFileData().apply$default$4());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator221$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator221$1(FileStreamSourceSuite $outer) {
            }
        }
        streamActionArray[3] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", (Object)"foo"), new Tuple2((Object)"keep3", (Object)"foo")}), $this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator221$1(null))));
        streamActionArray[4] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'keep4'}", partitionBarSubDir, tmp, $this.AddTextFileData().apply$default$4());
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator225$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator225$1(FileStreamSourceSuite $outer) {
            }
        }
        streamActionArray[5] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", (Object)"foo"), new Tuple2((Object)"keep3", (Object)"foo"), new Tuple2((Object)"keep4", (Object)"bar")}), $this.testImplicits().newProductEncoder(((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator225$1(null))));
        streamActionArray[6] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'keep5'}", partitionBarSubDir, tmp, $this.AddTextFileData().apply$default$4());
        JavaUniverse $u4 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m4 = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator229$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator229$1(FileStreamSourceSuite $outer) {
            }
        }
        streamActionArray[7] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", (Object)"foo"), new Tuple2((Object)"keep3", (Object)"foo"), new Tuple2((Object)"keep4", (Object)"bar"), new Tuple2((Object)"keep5", (Object)"bar")}), $this.testImplicits().newProductEncoder(((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator229$1(null))));
        $this.testStream(filtered, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])streamActionArray));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$91(MemoryStream q1Source$1, Seq data$1, StreamingQuery q1$1, StreamExecution x$4) {
        q1Source$1.addData((TraversableOnce)data$1);
        q1$1.processAllAvailable();
    }

    private final StreamTest.StreamAction q1AddData$1(Seq data, MemoryStream q1Source$1, StreamingQuery q1$1) {
        return this.Execute().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$4 -> {
            FileStreamSourceSuite.$anonfun$new$91(q1Source$1, data, q1$1, x$4);
            return BoxedUnit.UNIT;
        });
    }

    private final StreamTest.StreamAction q2ProcessAllAvailable$1() {
        return this.Execute().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)q2 -> {
            q2.processAllAvailable();
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$90(FileStreamSourceSuite $this, File x0$17, File x1$17) {
        Tuple2 tuple2 = new Tuple2((Object)x0$17, (Object)x1$17);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File outputDir = (File)tuple2._1();
        File checkpointDir = (File)tuple2._2();
        MemoryStream q1Source = MemoryStream$.MODULE$.apply($this.testImplicits().newStringEncoder(), $this.sqlContext());
        StreamingQuery q1 = q1Source.toDF().writeStream().option("checkpointLocation", checkpointDir.getCanonicalPath()).format("text").start(outputDir.getCanonicalPath());
        Dataset q2 = $this.createFileStream("text", outputDir.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4()).filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
        $this.testStream(q2, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{$this.q1AddData$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop1", "keep2"}), q1Source, q1), $this.q2ProcessAllAvailable$1(), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2"}), $this.testImplicits().newStringEncoder()), $this.Assert().apply((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            File shouldNotKeep = new File(outputDir, "should_not_keep.txt");
            org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(shouldNotKeep, "should_not_keep!!!");
            return shouldNotKeep.exists();
        }, $this.Assert().apply$default$2()), $this.q1AddData$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep3"}), q1Source, q1), $this.q2ProcessAllAvailable$1(), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), $this.testImplicits().newStringEncoder()), $this.q1AddData$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep4"}), q1Source, q1), $this.Assert().apply((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> new File(outputDir, new StringBuilder(10).append(FileStreamSink$.MODULE$.metadataDir()).append("/2.compact").toString()).exists(), $this.Assert().apply$default$2()), $this.q2ProcessAllAvailable$1(), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep4"}), $this.testImplicits().newStringEncoder()), $this.Execute().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$5 -> {
            q1.stop();
            return BoxedUnit.UNIT;
        })}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$new$98(FileStreamSourceSuite $this, StreamExecution q2) {
        FileStreamSource fileSource = (FileStreamSource)$this.getSourcesFromStreamingQuery(q2).head();
        return $this.convertToEqualizer(fileSource.sourceHasMetadata()).$eq$eq$eq((Object)None$.MODULE$, Equality$.MODULE$.default());
    }

    public static final /* synthetic */ void $anonfun$new$99(ObjectRef q1$2, DataStreamWriter q1Write$1, File outputDir$2, MemoryStream q1Source$2, StreamExecution x$6) {
        q1$2.elem = q1Write$1.start(outputDir$2.getCanonicalPath());
        q1Source$2.addData((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drop1", "keep2"}));
        ((StreamingQuery)q1$2.elem).processAllAvailable();
    }

    public static final /* synthetic */ boolean $anonfun$new$100(FileStreamSourceSuite $this, StreamExecution q2) {
        q2.processAllAvailable();
        FileStreamSource fileSource = (FileStreamSource)$this.getSourcesFromStreamingQuery(q2).head();
        return $this.convertToEqualizer(fileSource.sourceHasMetadata()).$eq$eq$eq((Object)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)), Equality$.MODULE$.default());
    }

    public static final /* synthetic */ void $anonfun$new$101(ObjectRef q1$2, StreamExecution x$7) {
        ((StreamingQuery)q1$2.elem).stop();
    }

    public static final /* synthetic */ void $anonfun$new$97(FileStreamSourceSuite $this, File x0$18, File x1$18) {
        Tuple2 tuple2 = new Tuple2((Object)x0$18, (Object)x1$18);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File outputDir = (File)tuple2._1();
        File checkpointDir = (File)tuple2._2();
        MemoryStream q1Source = MemoryStream$.MODULE$.apply($this.testImplicits().newStringEncoder(), $this.sqlContext());
        DataStreamWriter q1Write = q1Source.toDF().writeStream().option("checkpointLocation", checkpointDir.getCanonicalPath()).format("text");
        ObjectRef q1 = ObjectRef.create(null);
        Dataset q22 = $this.createFileStream("text", outputDir.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4()).filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
        $this.testStream(q22, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{$this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)q2 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$98($this, q2)), $this.AssertOnQuery().apply$default$2()), $this.Execute().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$6 -> {
            FileStreamSourceSuite.$anonfun$new$99(q1, q1Write, outputDir, q1Source, x$6);
            return BoxedUnit.UNIT;
        }), $this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)q2 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$100($this, q2)), $this.AssertOnQuery().apply$default$2()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2"}), $this.testImplicits().newStringEncoder()), $this.Execute().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$7 -> {
            FileStreamSourceSuite.$anonfun$new$101(q1, x$7);
            return BoxedUnit.UNIT;
        })}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private static final void createFile$1(String content, File src, File tmp) {
        File tempFile = Utils$.MODULE$.tempFileWith(new File(tmp, "text"));
        File finalFile = new File(src, tempFile.getName());
        Predef$.MODULE$.require(!src.exists(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append(src).append(" exists, dir: ").append(src.isDirectory()).append(", file: ").append(src.isFile()).toString());
        Predef$.MODULE$.require(src.mkdirs(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(14).append("Cannot create ").append(src).toString());
        Predef$.MODULE$.require(src.isDirectory(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append(src).append(" is not a directory").toString());
        Predef$.MODULE$.require(org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(tempFile, content).renameTo(finalFile));
    }

    public static final /* synthetic */ void $anonfun$new$107(FileStreamSourceSuite $this, File x0$19, File x1$19) {
        Tuple2 tuple2 = new Tuple2((Object)x0$19, (Object)x1$19);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File dir = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        File partitionFooSubDir = new File(dir, "partition=foo");
        File partitionBarSubDir = new File(dir, "partition=bar");
        FileStreamSourceSuite.createFile$1("{'value': 'drop0'}", partitionFooSubDir, tmp);
        Dataset<Row> fileStream = $this.createFileStream("json", String.valueOf(dir.getCanonicalPath()), $this.createFileStream$default$3(), $this.createFileStream$default$4());
        Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
        StreamTest.StreamAction[] streamActionArray = new StreamTest.StreamAction[10];
        streamActionArray[0] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'drop1'}\n{'value': 'keep2'}", partitionFooSubDir, tmp, $this.AddTextFileData().apply$default$4());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator251$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator251$1(FileStreamSourceSuite $outer) {
            }
        }
        streamActionArray[1] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", (Object)"foo")}), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator251$1(null))));
        streamActionArray[2] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'keep3'}", partitionFooSubDir, tmp, $this.AddTextFileData().apply$default$4());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator255$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator255$1(FileStreamSourceSuite $outer) {
            }
        }
        streamActionArray[3] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", (Object)"foo"), new Tuple2((Object)"keep3", (Object)"foo")}), $this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator255$1(null))));
        streamActionArray[4] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'keep4'}", partitionBarSubDir, tmp, $this.AddTextFileData().apply$default$4());
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator259$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator259$1(FileStreamSourceSuite $outer) {
            }
        }
        streamActionArray[5] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", (Object)"foo"), new Tuple2((Object)"keep3", (Object)"foo"), new Tuple2((Object)"keep4", (Object)"bar")}), $this.testImplicits().newProductEncoder(((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator259$1(null))));
        streamActionArray[6] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'keep5'}", partitionBarSubDir, tmp, $this.AddTextFileData().apply$default$4());
        JavaUniverse $u4 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m4 = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator263$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator263$1(FileStreamSourceSuite $outer) {
            }
        }
        streamActionArray[7] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", (Object)"foo"), new Tuple2((Object)"keep3", (Object)"foo"), new Tuple2((Object)"keep4", (Object)"bar"), new Tuple2((Object)"keep5", (Object)"bar")}), $this.testImplicits().newProductEncoder(((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator263$1(null))));
        streamActionArray[8] = new FileStreamSourceTest.AddTextFileData($this, "{'value': 'keep6'}", partitionBarSubDir, tmp, $this.AddTextFileData().apply$default$4());
        JavaUniverse $u5 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m5 = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator267$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator267$1(FileStreamSourceSuite $outer) {
            }
        }
        streamActionArray[9] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"keep2", (Object)"foo"), new Tuple2((Object)"keep3", (Object)"foo"), new Tuple2((Object)"keep4", (Object)"bar"), new Tuple2((Object)"keep5", (Object)"bar"), new Tuple2((Object)"keep6", (Object)"bar")}), $this.testImplicits().newProductEncoder(((TypeTags)$u5).TypeTag().apply((Mirror)$m5, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator267$1(null))));
        $this.testStream(filtered, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])streamActionArray));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$109(FileStreamSourceSuite $this, File x0$20, File x1$20) {
        Tuple2 tuple2 = new Tuple2((Object)x0$20, (Object)x1$20);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        Dataset<Row> fileStream = $this.createFileStream("text", src.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
        Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
        $this.testStream(filtered, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "drop1\nkeep2\nkeep3", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), $this.testImplicits().newStringEncoder()), $this.StopStream(), new FileStreamSourceTest.AddTextFileData($this, "drop4\nkeep5\nkeep6", src, tmp, $this.AddTextFileData().apply$default$4()), new StreamTest.StartStream($this, $this.StartStream().apply$default$1(), $this.StartStream().apply$default$2(), $this.StartStream().apply$default$3(), $this.StartStream().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "drop7\nkeep8\nkeep9", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6", "keep8", "keep9"}), $this.testImplicits().newStringEncoder())}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * WARNING - void declaration
     */
    private static final File createFile$2(int data, File x1$1, ObjectRef lastFileModTime$1) {
        void var3_3;
        File file = org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(new File(x1$1, new StringBuilder(4).append(data).append(".txt").toString()), ((Object)BoxesRunTime.boxToInteger((int)data)).toString());
        Object object = ((Option)lastFileModTime$1.elem).nonEmpty() ? BoxesRunTime.boxToBoolean((boolean)file.setLastModified(BoxesRunTime.unboxToLong((Object)((Option)lastFileModTime$1.elem).get()) + 1000L)) : BoxedUnit.UNIT;
        lastFileModTime$1.elem = new Some((Object)BoxesRunTime.boxToLong((long)file.lastModified()));
        return var3_3;
    }

    public static final /* synthetic */ String $anonfun$new$113(int x$8) {
        return ((Object)BoxesRunTime.boxToInteger((int)x$8)).toString();
    }

    private final void checkLastBatchData$1(Seq data, MemorySink memorySink$1) {
        StructType schema = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("value", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
        SparkContext qual$1 = this.spark().sparkContext();
        Seq x$1 = memorySink$1.latestBatchData();
        int x$2 = qual$1.makeRDD$default$2();
        Dataset df = this.spark().createDataFrame(qual$1.makeRDD(x$1, x$2, ClassTag$.MODULE$.apply(Row.class)), schema);
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> df, (Dataset<Row>)this.testImplicits().localSeqToDatasetHolder((Seq)data.map((Function1 & Serializable & scala.Serializable)x$8 -> FileStreamSourceSuite.$anonfun$new$113(BoxesRunTime.unboxToInt((Object)x$8)), Seq$.MODULE$.canBuildFrom()), this.testImplicits().newStringEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"})));
    }

    public static final /* synthetic */ String $anonfun$new$115(int x$9) {
        return ((Object)BoxesRunTime.boxToInteger((int)x$9)).toString();
    }

    private final void checkAllData$1(Seq data, MemorySink memorySink$1) {
        StructType schema = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("value", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
        SparkContext qual$1 = this.spark().sparkContext();
        Seq x$1 = memorySink$1.allData();
        int x$2 = qual$1.makeRDD$default$2();
        Dataset df = this.spark().createDataFrame(qual$1.makeRDD(x$1, x$2, ClassTag$.MODULE$.apply(Row.class)), schema);
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> df, (Dataset<Row>)this.testImplicits().localSeqToDatasetHolder((Seq)data.map((Function1 & Serializable & scala.Serializable)x$9 -> FileStreamSourceSuite.$anonfun$new$115(BoxesRunTime.unboxToInt((Object)x$9)), Seq$.MODULE$.canBuildFrom()), this.testImplicits().newStringEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"})));
    }

    private final void checkNumBatchesSinceLastCheck$1(int numBatches, LongRef lastBatchId$1, MemorySink memorySink$1) {
        Predef$.MODULE$.require(lastBatchId$1.elem >= 0L);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(memorySink$1.latestBatchId().get());
        long $org_scalatest_assert_macro_right = lastBatchId$1.elem + (long)numBatches;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1075));
        lastBatchId$1.elem = BoxesRunTime.unboxToLong((Object)memorySink$1.latestBatchId().get());
    }

    public static final /* synthetic */ void $anonfun$new$111(FileStreamSourceSuite $this, File x0$21) {
        File file = x0$21;
        ObjectRef lastFileModTime = ObjectRef.create((Object)None$.MODULE$);
        FileStreamSourceSuite.createFile$2(1, file, lastFileModTime);
        FileStreamSourceSuite.createFile$2(2, file, lastFileModTime);
        FileStreamSourceSuite.createFile$2(3, file, lastFileModTime);
        Dataset df = $this.spark().readStream().option("maxFilesPerTrigger", 2L).text(file.getCanonicalPath());
        StreamExecution q = ((StreamingQueryWrapper)df.writeStream().format("memory").queryName("file_data").start()).streamingQuery();
        q.processAllAvailable();
        MemorySink memorySink = (MemorySink)q.sink();
        FileStreamSource fileSource = (FileStreamSource)$this.getSourcesFromStreamingQuery(q).head();
        LongRef lastBatchId = LongRef.create((long)-1L);
        $this.checkLastBatchData$1((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3}), memorySink);
        $this.checkAllData$1((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3), memorySink);
        lastBatchId.elem = BoxesRunTime.unboxToLong((Object)memorySink.latestBatchId().get());
        fileSource.withBatchingLocked((Function0 & Serializable & scala.Serializable)() -> {
            FileStreamSourceSuite.createFile$2(4, file, lastFileModTime);
            FileStreamSourceSuite.createFile$2(5, file, lastFileModTime);
            FileStreamSourceSuite.createFile$2(6, file, lastFileModTime);
            return FileStreamSourceSuite.createFile$2(7, file, lastFileModTime);
        });
        q.processAllAvailable();
        $this.checkNumBatchesSinceLastCheck$1(2, lastBatchId, memorySink);
        $this.checkLastBatchData$1((Seq)Predef$.MODULE$.wrapIntArray(new int[]{6, 7}), memorySink);
        $this.checkAllData$1((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 7), memorySink);
        fileSource.withBatchingLocked((Function0 & Serializable & scala.Serializable)() -> {
            FileStreamSourceSuite.createFile$2(8, file, lastFileModTime);
            FileStreamSourceSuite.createFile$2(9, file, lastFileModTime);
            FileStreamSourceSuite.createFile$2(10, file, lastFileModTime);
            FileStreamSourceSuite.createFile$2(11, file, lastFileModTime);
            return FileStreamSourceSuite.createFile$2(12, file, lastFileModTime);
        });
        q.processAllAvailable();
        $this.checkNumBatchesSinceLastCheck$1(3, lastBatchId, memorySink);
        $this.checkLastBatchData$1((Seq)Predef$.MODULE$.wrapIntArray(new int[]{12}), memorySink);
        $this.checkAllData$1((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 12), memorySink);
        q.stop();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final void testMaxFilePerTriggerValue$1(String value, File x1$2, String testTable$1) {
        Dataset df = this.spark().readStream().option("maxFilesPerTrigger", value).text(x1$2.getCanonicalPath());
        StreamingQueryException e = (StreamingQueryException)this.intercept((Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            StreamingQuery q = df.writeStream().format("memory").queryName(testTable$1).start();
            try {
                q.processAllAvailable();
                boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                q.stop();
            }
            return boxedUnit;
        }, ClassTag$.MODULE$.apply(StreamingQueryException.class), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1116));
        Throwable $org_scalatest_assert_macro_left = e.getCause();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left, "isInstanceOf", "scala.IllegalArgumentException", $org_scalatest_assert_macro_left instanceof IllegalArgumentException, Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1125));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"maxFilesPerTrigger", value, "positive integer"}))).foreach((Function1 & Serializable & scala.Serializable)s -> {
            String $org_scalatest_assert_macro_left = e.getMessage();
            String $org_scalatest_assert_macro_right = s;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1127));
        });
    }

    public static final /* synthetic */ void $anonfun$new$120(FileStreamSourceSuite $this, String testTable$1, File x0$22) {
        File file = x0$22;
        $this.testMaxFilePerTriggerValue$1("not-a-integer", file, testTable$1);
        $this.testMaxFilePerTriggerValue$1("-1", file, testTable$1);
        $this.testMaxFilePerTriggerValue$1("0", file, testTable$1);
        $this.testMaxFilePerTriggerValue$1("10.1", file, testTable$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$124(FileStreamSourceSuite $this, File x0$23, File x1$21) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = new Tuple2((Object)x0$23, (Object)x1$21);
        if (tuple2 != null) {
            File src = (File)tuple2._1();
            File tmp = (File)tuple2._2();
            src.mkdirs();
            Dataset df = $this.spark().readStream().format("text").load(src.getCanonicalPath()).map((Function1 & Serializable & scala.Serializable)x$10 -> Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd(x$10), "-x"), $this.testImplicits().newStringEncoder());
            df.explain();
            StreamExecution q = ((StreamingQueryWrapper)df.writeStream().queryName("file_explain").format("memory").start()).streamingQuery();
            try {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer("No physical plan. Waiting for data.");
                String $org_scalatest_assert_macro_right = q.explainInternal(false);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1151));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer("No physical plan. Waiting for data.");
                String $org_scalatest_assert_macro_right2 = q.explainInternal(true);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1152));
                File tempFile = Utils$.MODULE$.tempFileWith(new File(tmp, "text"));
                File finalFile = new File(src, tempFile.getName());
                Predef$.MODULE$.require(org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(tempFile, "foo").renameTo(finalFile));
                q.processAllAvailable();
                String explainWithoutExtended = q.explainInternal(false);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString("Relation.*text")).r().findAllMatchIn((CharSequence)explainWithoutExtended).size()));
                int $org_scalatest_assert_macro_right3 = 0;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1162));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(": Text")).r().findAllMatchIn((CharSequence)explainWithoutExtended).size()));
                int $org_scalatest_assert_macro_right4 = 1;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1163));
                String explainWithExtended = q.explainInternal(true);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString("Relation.*text")).r().findAllMatchIn((CharSequence)explainWithExtended).size()));
                int $org_scalatest_assert_macro_right5 = 3;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1168));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(": Text")).r().findAllMatchIn((CharSequence)explainWithExtended).size()));
                int $org_scalatest_assert_macro_right6 = 1;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1169));
                boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                q.stop();
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ String $anonfun$new$128(int x$11) {
        return ((Object)BoxesRunTime.boxToInteger((int)x$11)).toString();
    }

    public static final /* synthetic */ void $anonfun$new$127(FileStreamSourceSuite $this, int numFiles$1, File x0$24, File x1$22) {
        Tuple2 tuple2 = new Tuple2((Object)x0$24, (Object)x1$22);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File root = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        File src = new File(root, "a=1");
        src.mkdirs();
        ((IterableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numFiles$1).map((Function1 & Serializable & scala.Serializable)x$11 -> FileStreamSourceSuite.$anonfun$new$128(BoxesRunTime.unboxToInt((Object)x$11)), IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)i -> {
            File tempFile = Utils$.MODULE$.tempFileWith(new File(tmp, "text"));
            File finalFile = new File(src, tempFile.getName());
            return org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(finalFile, i);
        });
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])src.listFiles())).size()));
        int $org_scalatest_assert_macro_right = numFiles$1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1197));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(FileStreamSourceSuite.class.getClassLoader());
        public final class Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator283$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator283$1(FileStreamSourceSuite $outer) {
            }
        }
        Dataset files = $this.spark().readStream().text(root.getCanonicalPath()).as($this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_streaming_FileStreamSourceSuite$$typecreator283$1(null))));
        Dataset df = files.filter("1 == 0").groupBy((Seq)Nil$.MODULE$).count();
        $this.testStream(df, OutputMode.Complete(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "0", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapIntArray(new int[]{0}), $this.testImplicits().newIntEncoder())}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final boolean verify$1(StreamExecution execution, long batchId, int expectedBatches, int expectedCompactInterval, PrivateMethodTester.PrivateMethod _metadataLog$1) {
        BoxedUnit boxedUnit;
        FileStreamSource fileSource = (FileStreamSource)this.getSourcesFromStreamingQuery(execution).head();
        FileStreamSourceLog metadataLog = (FileStreamSourceLog)this.anyRefToInvoker(fileSource).invokePrivate(_metadataLog$1.apply((Seq)Nil$.MODULE$));
        if (CompactibleFileStreamLog$.MODULE$.isCompactionBatch(batchId, expectedCompactInterval)) {
            Path path = metadataLog.batchIdToPath(batchId);
            String $org_scalatest_assert_macro_left = path.getName();
            String $org_scalatest_assert_macro_right = CompactibleFileStreamLog$.MODULE$.COMPACT_FILE_SUFFIX();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "endsWith", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.endsWith($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"path does not end with compact file suffix", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1230));
            Option entries = metadataLog.get(batchId);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(entries.isDefined(), "entries.isDefined", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Entries not defined", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1235));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((FileStreamSource.FileEntry[])entries.get()).length));
            int $org_scalatest_assert_macro_right2 = ((FileStreamSource.FileEntry[])metadataLog.allFiles()).length;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"clean up check", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1236));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((FileStreamSource.FileEntry[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])metadataLog.get((Option)None$.MODULE$, (Option)new Some((Object)BoxesRunTime.boxToLong((long)batchId))))).flatMap((Function1 & Serializable & scala.Serializable)x$12 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$12._2())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileStreamSource.FileEntry.class)))).length));
            int $org_scalatest_assert_macro_right3 = ((FileStreamSource.FileEntry[])entries.get()).length;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            boxedUnit = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"Length check", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1237));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(metadataLog.allFiles())).sortBy((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)x$13.batchId()), (Ordering)Ordering.Long$.MODULE$));
        FileStreamSource.FileEntry[] $org_scalatest_assert_macro_right = (FileStreamSource.FileEntry[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])metadataLog.get((Option)None$.MODULE$, (Option)new Some((Object)BoxesRunTime.boxToLong((long)batchId))))).flatMap((Function1 & Serializable & scala.Serializable)x$14 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$14._2())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileStreamSource.FileEntry.class))))).sortBy((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToLong((long)x$15.batchId()), (Ordering)Ordering.Long$.MODULE$);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Batch id mismatch", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1241));
        return this.convertToEqualizer(BoxesRunTime.boxToInteger((int)((FileStreamSource.FileEntry[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])metadataLog.get((Option)None$.MODULE$, (Option)new Some((Object)BoxesRunTime.boxToLong((long)batchId))))).flatMap((Function1 & Serializable & scala.Serializable)x$16 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$16._2())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileStreamSource.FileEntry.class)))).length)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)expectedBatches), Equality$.MODULE$.default());
    }

    public static final /* synthetic */ void $anonfun$new$136(FileStreamSourceSuite $this, PrivateMethodTester.PrivateMethod _metadataLog$1, File x0$25, File x1$23) {
        Tuple2 tuple2 = new Tuple2((Object)x0$25, (Object)x1$23);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SOURCE_LOG_COMPACT_INTERVAL().key()), (Object)"2")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Dataset<Row> fileStream = $this.createFileStream("text", src.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
            Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
            Map updateConf = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SOURCE_LOG_COMPACT_INTERVAL().key()), (Object)"5")}));
            StreamTest.StreamAction[] streamActionArray = new StreamTest.StreamAction[18];
            streamActionArray[0] = new FileStreamSourceTest.AddTextFileData($this, "drop1\nkeep2\nkeep3", src, tmp, $this.AddTextFileData().apply$default$4());
            streamActionArray[1] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), $this.testImplicits().newStringEncoder());
            streamActionArray[2] = $this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)$this.verify$1(x$17, 0L, 1, 2, _metadataLog$1)), $this.AssertOnQuery().apply$default$2());
            streamActionArray[3] = new FileStreamSourceTest.AddTextFileData($this, "drop4\nkeep5\nkeep6", src, tmp, $this.AddTextFileData().apply$default$4());
            streamActionArray[4] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6"}), $this.testImplicits().newStringEncoder());
            streamActionArray[5] = $this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)$this.verify$1(x$18, 1L, 2, 2, _metadataLog$1)), $this.AssertOnQuery().apply$default$2());
            streamActionArray[6] = new FileStreamSourceTest.AddTextFileData($this, "drop7\nkeep8\nkeep9", src, tmp, $this.AddTextFileData().apply$default$4());
            streamActionArray[7] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6", "keep8", "keep9"}), $this.testImplicits().newStringEncoder());
            streamActionArray[8] = $this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)$this.verify$1(x$19, 2L, 3, 2, _metadataLog$1)), $this.AssertOnQuery().apply$default$2());
            streamActionArray[9] = $this.StopStream();
            Map x$5 = updateConf;
            Trigger x$6 = $this.StartStream().apply$default$1();
            Clock x$7 = $this.StartStream().apply$default$2();
            String x$8 = $this.StartStream().apply$default$4();
            streamActionArray[10] = new StreamTest.StartStream($this, x$6, x$7, (Map<String, String>)x$5, x$8);
            streamActionArray[11] = $this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)$this.verify$1(x$20, 2L, 3, 2, _metadataLog$1)), $this.AssertOnQuery().apply$default$2());
            streamActionArray[12] = new FileStreamSourceTest.AddTextFileData($this, "drop10\nkeep11", src, tmp, $this.AddTextFileData().apply$default$4());
            streamActionArray[13] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6", "keep8", "keep9", "keep11"}), $this.testImplicits().newStringEncoder());
            streamActionArray[14] = $this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)$this.verify$1(x$21, 3L, 4, 2, _metadataLog$1)), $this.AssertOnQuery().apply$default$2());
            streamActionArray[15] = new FileStreamSourceTest.AddTextFileData($this, "drop12\nkeep13", src, tmp, $this.AddTextFileData().apply$default$4());
            streamActionArray[16] = $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3", "keep5", "keep6", "keep8", "keep9", "keep11", "keep13"}), $this.testImplicits().newStringEncoder());
            streamActionArray[17] = $this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)$this.verify$1(x$22, 4L, 5, 2, _metadataLog$1)), $this.AssertOnQuery().apply$default$2());
            $this.testStream(filtered, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])streamActionArray));
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ FileStreamSourceOffset $anonfun$new$148(int x$23) {
        return new FileStreamSourceOffset((long)x$23);
    }

    private final void verify$2(Option startId, int endId, Seq expected, FileStreamSource fileSource$1) {
        Option start = startId.map((Function1 & Serializable & scala.Serializable)x$23 -> FileStreamSourceSuite.$anonfun$new$148(BoxesRunTime.unboxToInt((Object)x$23)));
        FileStreamSourceOffset end = new FileStreamSourceOffset((long)endId);
        this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.sql.streaming.unsupportedOperationCheck"), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileSource$1.getBatch(start, (Offset)end).as(this.testImplicits().newStringEncoder()).collect())).toSeq());
            Seq $org_scalatest_assert_macro_right = expected;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1306));
        });
    }

    public static final /* synthetic */ boolean $anonfun$new$147(FileStreamSourceSuite $this, StreamExecution execution) {
        PrivateMethodTester.PrivateMethod _sources = $this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "sources"));
        FileStreamSource fileSource = (FileStreamSource)$this.getSourcesFromStreamingQuery(execution).head();
        $this.verify$2((Option)None$.MODULE$, 2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep1", "keep2", "keep3"}), fileSource);
        $this.verify$2((Option)new Some((Object)BoxesRunTime.boxToInteger((int)0)), 1, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2"}), fileSource);
        $this.verify$2((Option)new Some((Object)BoxesRunTime.boxToInteger((int)0)), 2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep2", "keep3"}), fileSource);
        $this.verify$2((Option)new Some((Object)BoxesRunTime.boxToInteger((int)1)), 2, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep3"}), fileSource);
        return true;
    }

    public static final /* synthetic */ void $anonfun$new$145(FileStreamSourceSuite $this, File x0$26, File x1$24) {
        Tuple2 tuple2 = new Tuple2((Object)x0$26, (Object)x1$24);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SOURCE_LOG_COMPACT_INTERVAL().key()), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SOURCE_LOG_CLEANUP_DELAY().key()), (Object)"1")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Dataset<Row> fileStream = $this.createFileStream("text", src.getCanonicalPath(), $this.createFileStream$default$3(), $this.createFileStream$default$4());
            Dataset filtered = fileStream.filter($this.testImplicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).contains((Object)"keep"));
            $this.testStream(filtered, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "keep1", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep1"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "keep2", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep1", "keep2"}), $this.testImplicits().newStringEncoder()), new FileStreamSourceTest.AddTextFileData($this, "keep3", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keep1", "keep2", "keep3"}), $this.testImplicits().newStringEncoder()), $this.AssertOnQuery().apply("check getBatch", (Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)execution -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$147($this, execution)))}));
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$new$153(StreamingQueryProgress x$24) {
        return x$24.numInputRows() > 0L;
    }

    public static final /* synthetic */ boolean $anonfun$new$152(FileStreamSourceSuite $this, StreamExecution query) {
        StreamingQueryProgress actualProgress = (StreamingQueryProgress)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])query.recentProgress())).find((Function1 & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$153(x$24))).getOrElse((Function0 & Serializable & scala.Serializable)() -> scala.sys.package$.MODULE$.error("Could not find records with data."));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)actualProgress.numInputRows()));
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1331));
        double $org_scalatest_assert_macro_left2 = actualProgress.sources()[0].processedRowsPerSecond();
        double $org_scalatest_assert_macro_right2 = 0.0;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), ">", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 > $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1332));
        return true;
    }

    public static final /* synthetic */ void $anonfun$new$151(FileStreamSourceSuite $this, File x0$27, File x1$25) {
        Tuple2 tuple2 = new Tuple2((Object)x0$27, (Object)x1$25);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File src = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        Dataset input = $this.spark().readStream().format("text").load(src.getCanonicalPath());
        $this.testStream(input, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new FileStreamSourceTest.AddTextFileData($this, "100", src, tmp, $this.AddTextFileData().apply$default$4()), $this.CheckAnswer().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"100"}), $this.testImplicits().newStringEncoder()), $this.AssertOnQuery().apply((Function1<StreamExecution, Object>)(Function1 & Serializable & scala.Serializable)query -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$152($this, query)), $this.AssertOnQuery().apply$default$2())}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$runTwoBatchesAndVerifyResults$2(FileStreamSourceSuite $this, StreamManualClock clock$1, StreamExecution x$26) {
        $this.eventually($this.timeout($this.streamingTimeout()), (Function0 & Serializable & scala.Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(clock$1.isStreamWaitingAt(0L), "clock.isStreamWaitingAt(0L)", Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1394));
        }, $this.patienceConfig(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1393));
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$runTwoBatchesAndVerifyResults$4(FileStreamSourceSuite $this, StreamManualClock clock$1, StreamExecution x$27) {
        $this.eventually($this.timeout($this.streamingTimeout()), (Function0 & Serializable & scala.Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(clock$1.isStreamWaitingAt(10L), "clock.isStreamWaitingAt(10L)", Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1403));
        }, $this.patienceConfig(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1402));
        return true;
    }

    public static final /* synthetic */ void $anonfun$new$160(FileStreamSourceSuite $this, File src) {
        File f1 = org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(new File(src, "1.txt"), "1");
        File f2 = org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(new File(src, "2.txt"), "2");
        f2.setLastModified(f1.lastModified() + 1000L);
        $this.runTwoBatchesAndVerifyResults(src, false, "1", "2", $this.runTwoBatchesAndVerifyResults$default$5());
        $this.runTwoBatchesAndVerifyResults(src, true, "2", "1", $this.runTwoBatchesAndVerifyResults$default$5());
    }

    public static final /* synthetic */ void $anonfun$new$162(FileStreamSourceSuite $this, File src) {
        File f1 = org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(new File(src, "1.txt"), "1");
        File f2 = org.apache.spark.sql.catalyst.util.package$.MODULE$.stringToFile(new File(src, "2.txt"), "2");
        f2.setLastModified(f1.lastModified() + 3600000L);
        $this.runTwoBatchesAndVerifyResults(src, true, "2", "1", (Option<String>)new Some((Object)"1m"));
    }

    public static final /* synthetic */ void $anonfun$new$167(FileStreamSourceSuite $this, File temp) {
        $this.spark().conf().set(new StringBuilder(8).append("fs.").append(ExistsThrowsExceptionFileSystem$.MODULE$.scheme()).append(".impl").toString(), ExistsThrowsExceptionFileSystem.class.getName());
        File dir = new File(temp, "dir");
        FileStreamSourceLog metadataLog = new FileStreamSourceLog(FileStreamSourceLog$.MODULE$.VERSION(), $this.spark(), dir.getAbsolutePath());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(metadataLog.add(0L, (FileStreamSource.FileEntry[])((Object[])new FileStreamSource.FileEntry[]{new FileStreamSource.FileEntry(new StringBuilder(9).append(ExistsThrowsExceptionFileSystem$.MODULE$.scheme()).append(":///file1").toString(), 100L, 0L)})), "metadataLog.add(0L, scala.Array.apply[org.apache.spark.sql.execution.streaming.FileStreamSource.FileEntry](org.apache.spark.sql.execution.streaming.FileStreamSource.FileEntry.apply(scala.StringContext.apply(\"\", \":///file1\").s(org.apache.spark.sql.streaming.ExistsThrowsExceptionFileSystem.scheme), 100L, 0L))((ClassTag.apply[org.apache.spark.sql.execution.streaming.FileStreamSource.FileEntry](classOf[org.apache.spark.sql.execution.streaming.FileStreamSource$$FileEntry]): scala.reflect.ClassTag[org.apache.spark.sql.execution.streaming.FileStreamSource.FileEntry])))", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1515));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(metadataLog.add(1L, (FileStreamSource.FileEntry[])((Object[])new FileStreamSource.FileEntry[]{new FileStreamSource.FileEntry(new StringBuilder(9).append(ExistsThrowsExceptionFileSystem$.MODULE$.scheme()).append(":///file2").toString(), 200L, 0L)})), "metadataLog.add(1L, scala.Array.apply[org.apache.spark.sql.execution.streaming.FileStreamSource.FileEntry](org.apache.spark.sql.execution.streaming.FileStreamSource.FileEntry.apply(scala.StringContext.apply(\"\", \":///file2\").s(org.apache.spark.sql.streaming.ExistsThrowsExceptionFileSystem.scheme), 200L, 0L))((ClassTag.apply[org.apache.spark.sql.execution.streaming.FileStreamSource.FileEntry](classOf[org.apache.spark.sql.execution.streaming.FileStreamSource$$FileEntry]): scala.reflect.ClassTag[org.apache.spark.sql.execution.streaming.FileStreamSource.FileEntry])))", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1516));
        FileStreamSource newSource = new FileStreamSource($this.spark(), new StringBuilder(4).append(ExistsThrowsExceptionFileSystem$.MODULE$.scheme()).append(":///").toString(), "parquet", StructType$.MODULE$.apply((Seq)Nil$.MODULE$), (Seq)Nil$.MODULE$, dir.getAbsolutePath(), Predef$.MODULE$.Map().empty());
        newSource.getBatch((Option)None$.MODULE$, (Offset)new FileStreamSourceOffset(1L));
    }

    public static final /* synthetic */ boolean $anonfun$new$170(FileStreamSourceTest.AddTextFileData x$28) {
        return x$28.content() != null;
    }

    private final StreamTest.StreamAction addMultiTextFileData$1(String source1Content, String source2Content, File sourceDir1$1, File tmp$9, File sourceDir2$1) {
        Seq actions = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FileStreamSourceTest.AddTextFileData[]{new FileStreamSourceTest.AddTextFileData(this, source1Content, sourceDir1$1, tmp$9, this.AddTextFileData().apply$default$4()), new FileStreamSourceTest.AddTextFileData(this, source2Content, sourceDir2$1, tmp$9, this.AddTextFileData().apply$default$4())}))).filter((Function1 & Serializable & scala.Serializable)x$28 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSourceSuite.$anonfun$new$170(x$28)));
        return new StreamTest.StreamProgressLockedActions(this, (Seq<StreamTest.StreamAction>)actions, actions.mkString("[ ", " | ", " ]"));
    }

    public static final /* synthetic */ void $anonfun$new$169(FileStreamSourceSuite $this, File x0$28, File x1$26) {
        Tuple2 tuple2 = new Tuple2((Object)x0$28, (Object)x1$26);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File dir = (File)tuple2._1();
        File tmp = (File)tuple2._2();
        File sourceDir1 = new File(dir, "source1");
        File sourceDir2 = new File(dir, "source2");
        sourceDir1.mkdirs();
        sourceDir2.mkdirs();
        Dataset<Row> source1 = $this.createFileStream("text", String.valueOf(sourceDir1.getCanonicalPath()), $this.createFileStream$default$3(), $this.createFileStream$default$4());
        Dataset<Row> source2 = $this.createFileStream("text", String.valueOf(sourceDir2.getCanonicalPath()), $this.createFileStream$default$3(), $this.createFileStream$default$4());
        Dataset unioned = source1.union(source2);
        $this.testStream(unioned, $this.testStream$default$2(), $this.testStream$default$3(), (Seq<StreamTest.StreamAction>)Predef$.MODULE$.wrapRefArray((Object[])new StreamTest.StreamAction[]{new StreamTest.StartStream($this, $this.StartStream().apply$default$1(), $this.StartStream().apply$default$2(), $this.StartStream().apply$default$3(), $this.StartStream().apply$default$4()), $this.addMultiTextFileData$1("source1_0", "source2_0", sourceDir1, tmp, sourceDir2), $this.CheckNewAnswer().apply("source1_0", Predef$.MODULE$.wrapRefArray((Object[])new String[]{"source2_0"}), $this.testImplicits().newStringEncoder()), $this.StopStream(), new StreamTest.StartStream($this, $this.StartStream().apply$default$1(), $this.StartStream().apply$default$2(), $this.StartStream().apply$default$3(), $this.StartStream().apply$default$4()), $this.addMultiTextFileData$1("source1_1", null, sourceDir1, tmp, sourceDir2), $this.CheckNewAnswer().apply("source1_1", Predef$.MODULE$.wrapRefArray((Object[])new String[0]), $this.testImplicits().newStringEncoder()), $this.StopStream(), new StreamTest.StartStream($this, $this.StartStream().apply$default$1(), $this.StartStream().apply$default$2(), $this.StartStream().apply$default$3(), $this.StartStream().apply$default$4()), $this.addMultiTextFileData$1(null, "source2_2", sourceDir1, tmp, sourceDir2), $this.CheckNewAnswer().apply("source2_2", Predef$.MODULE$.wrapRefArray((Object[])new String[0]), $this.testImplicits().newStringEncoder()), $this.StopStream(), new StreamTest.StartStream($this, $this.StartStream().apply$default$1(), $this.StartStream().apply$default$2(), $this.StartStream().apply$default$3(), $this.StartStream().apply$default$4()), $this.addMultiTextFileData$1("source1_3", "source2_3", sourceDir1, tmp, sourceDir2), $this.CheckNewAnswer().apply("source1_3", Predef$.MODULE$.wrapRefArray((Object[])new String[]{"source2_3"}), $this.testImplicits().newStringEncoder()), $this.StopStream()}));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public FileStreamSourceSuite() {
        this.test("FileStreamSource schema: no path", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testError$1());
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testError$1());
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 240));
        this.test("FileStreamSource schema: path doesn't exist (without schema) should throw exception", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                StructType userSchema = new StructType().add(new StructField("value", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.$lessinit$greater$default$3(), StructField$.MODULE$.$lessinit$greater$default$4()));
                StructType structType = $this.createFileStreamSourceAndGetSchema((Option<String>)None$.MODULE$, (Option<String>)new Some((Object)new File(dir, "1").getAbsolutePath()), (Option<StructType>)None$.MODULE$);
            }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 253));
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 251));
        this.test("FileStreamSource schema: path doesn't exist (with schema) should throw exception", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                StructType userSchema = new StructType().add(new StructField("value", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.$lessinit$greater$default$3(), StructField$.MODULE$.$lessinit$greater$default$4()));
                StructType structType = $this.createFileStreamSourceAndGetSchema((Option<String>)None$.MODULE$, (Option<String>)new Some((Object)new File(dir, "1").getAbsolutePath()), (Option<StructType>)new Some((Object)userSchema));
            }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 263));
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 261));
        this.test("FileStreamSource schema: text, no existing files, no schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$12(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 274));
        this.test("FileStreamSource schema: text, existing files, no schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$14(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 282));
        this.test("FileStreamSource schema: text, existing files, schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$16(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 291));
        this.test("FileStreamSource schema: orc, existing files, no schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$18(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 303));
        this.test("FileStreamSource schema: orc, existing files, schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$23(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 326));
        this.test("FileStreamSource schema: parquet, existing files, no schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$25(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 339));
        this.test("FileStreamSource schema: parquet, existing files, schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$30(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 362));
        this.test("FileStreamSource schema: json, no existing files, no schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)src -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                AnalysisException e = (AnalysisException)((Object)((Object)$this.intercept((Function0 & Serializable & scala.Serializable)() -> $this.createFileStreamSourceAndGetSchema((Option<String>)new Some((Object)"json"), (Option<String>)new Some((Object)src.getCanonicalPath()), (Option<StructType>)None$.MODULE$), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 379))));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer("Unable to infer schema for JSON. It must be specified manually.;");
                String $org_scalatest_assert_macro_right = e.getMessage();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 383));
            });
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 375));
        this.test("FileStreamSource schema: json, existing files, no schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$36(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 388));
        this.test("FileStreamSource schema: json, existing files, schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$41(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 409));
        this.test("read from text files", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            FileStreamSourceSuite.$anonfun$new$43(this, x0$1, x1$1);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 421));
        this.test("SPARK-21996 read from text files -- file name has space", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$2, x1$2) -> {
            FileStreamSourceSuite.$anonfun$new$45(this, x0$2, x1$2);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 439));
        this.test("SPARK-21996 read from text files generated by file sink -- file name has space", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String testTableName = "FileStreamSourceTest";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{testTableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$3, x1$3) -> {
                FileStreamSourceSuite.$anonfun$new$48(this, testTableName, x0$3, x1$3);
                return BoxedUnit.UNIT;
            }));
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 451));
        this.test("read from textfile", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$4, x1$4) -> {
            FileStreamSourceSuite.$anonfun$new$52(this, x0$4, x1$4);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 485));
        this.test("SPARK-17165 should not track the list of seen files indefinitely", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$5, x1$5) -> {
            FileStreamSourceSuite.$anonfun$new$55(this, x0$5, x1$5);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 503));
        this.test("SPARK-31935: Hadoop file system config should be effective in data source options", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            FileStreamSourceSuite.$anonfun$new$59(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 537));
        this.test("read from json files", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$6, x1$6) -> {
            FileStreamSourceSuite.$anonfun$new$62(this, x0$6, x1$6);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 551));
        this.test("read from json files with inferring schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$7, x1$7) -> {
            FileStreamSourceSuite.$anonfun$new$64(this, x0$7, x1$7);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 578));
        this.test("reading from json files inside partitioned directory", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$8, x1$8) -> {
            FileStreamSourceSuite.$anonfun$new$67(this, x0$8, x1$8);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 599));
        this.test("reading from json files with changing schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$9, x1$9) -> {
            FileStreamSourceSuite.$anonfun$new$70(this, x0$9, x1$9);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 621));
        this.test("read from orc files", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$10, x1$10) -> {
            FileStreamSourceSuite.$anonfun$new$73(this, x0$10, x1$10);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 656));
        this.test("read from orc files with changing schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$11, x1$11) -> {
            FileStreamSourceSuite.$anonfun$new$75(this, x0$11, x1$11);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 674));
        this.test("read from parquet files", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$12, x1$12) -> {
            FileStreamSourceSuite.$anonfun$new$78(this, x0$12, x1$12);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 709));
        this.test("read from parquet files with changing schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$13, x1$13) -> {
            FileStreamSourceSuite.$anonfun$new$80(this, x0$13, x1$13);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 727));
        this.test("read new files in nested directories with globbing", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$14, x1$14) -> {
            FileStreamSourceSuite.$anonfun$new$83(this, x0$14, x1$14);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 763));
        this.test("read new files in partitioned table with globbing, should not read partition data", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$15, x1$15) -> {
            FileStreamSourceSuite.$anonfun$new$85(this, x0$15, x1$15);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 807));
        this.test("read new files in partitioned table without globbing, should read partition data", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$16, x1$16) -> {
            FileStreamSourceSuite.$anonfun$new$87(this, x0$16, x1$16);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 838));
        this.test("read data from outputs of another streaming query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SINK_LOG_COMPACT_INTERVAL().key()), (Object)"3")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$17, x1$17) -> {
            FileStreamSourceSuite.$anonfun$new$90(this, x0$17, x1$17);
            return BoxedUnit.UNIT;
        })), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 866));
        this.test("start before another streaming query, and read its output", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$18, x1$18) -> {
            FileStreamSourceSuite.$anonfun$new$97(this, x0$18, x1$18);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 923));
        this.test("when schema inference is turned on, should read partition data", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.STREAMING_SCHEMA_INFERENCE().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$19, x1$19) -> {
            FileStreamSourceSuite.$anonfun$new$107(this, x0$19, x1$19);
            return BoxedUnit.UNIT;
        })), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 961));
        this.test("fault tolerance", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$20, x1$20) -> {
            FileStreamSourceSuite.$anonfun$new$109(this, x0$20, x1$20);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1006));
        this.test("max files per trigger", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x0$21 -> {
            FileStreamSourceSuite.$anonfun$new$111(this, x0$21);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1024));
        this.testQuietly("max files per trigger - incorrect values", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String testTable = "maxFilesPerTrigger_test";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{testTable}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)x0$22 -> {
                FileStreamSourceSuite.$anonfun$new$120(this, testTable, x0$22);
                return BoxedUnit.UNIT;
            }));
        });
        this.test("explain", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$23, x1$21) -> {
            FileStreamSourceSuite.$anonfun$new$124(this, x0$23, x1$21);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1139));
        this.test("SPARK-17372 - write file names to WAL as Array[String]", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int numFiles = 10000;
            this.spark().sessionState().conf().setConf(SQLConf$.MODULE$.PARALLEL_PARTITION_DISCOVERY_THRESHOLD(), (Object)BoxesRunTime.boxToInteger((int)(numFiles * 2)));
            this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$24, x1$22) -> {
                FileStreamSourceSuite.$anonfun$new$127(this, numFiles, x0$24, x1$22);
                return BoxedUnit.UNIT;
            });
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1176));
        this.test("compact interval metadata log", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            PrivateMethodTester.PrivateMethod _sources = this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "sources"));
            PrivateMethodTester.PrivateMethod _metadataLog = this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "metadataLog"));
            this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$25, x1$23) -> {
                FileStreamSourceSuite.$anonfun$new$136(this, _metadataLog, x0$25, x1$23);
                return BoxedUnit.UNIT;
            });
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1212));
        this.test("get arbitrary batch from FileStreamSource", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$26, x1$24) -> {
            FileStreamSourceSuite.$anonfun$new$145(this, x0$26, x1$24);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1280));
        this.test("input row metrics", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$27, x1$25) -> {
            FileStreamSourceSuite.$anonfun$new$151(this, x0$27, x1$25);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1321));
        this.test("SPARK-18433: Improve DataSource option keys to be more case-insensitive", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            FileStreamOptions options = new FileStreamOptions((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxfilespertrigger"), (Object)"1")})));
            Option $org_scalatest_assert_macro_left = options.maxFilesPerTrigger();
            Some $org_scalatest_assert_macro_right = new Some((Object)BoxesRunTime.boxToInteger((int)1));
            Option option = $org_scalatest_assert_macro_left;
            Some some = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1341));
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1339));
        this.test("FileStreamSource offset - read Spark 2.1.0 offset json format", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SerializedOffset offset = this.readOffsetFromResource("file-source-offset-version-2.1.0-json.txt");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(FileStreamSourceOffset$.MODULE$.apply((Offset)offset));
            FileStreamSourceOffset $org_scalatest_assert_macro_right = new FileStreamSourceOffset(345L);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1346));
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1344));
        this.test("FileStreamSource offset - read Spark 2.1.0 offset long format", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SerializedOffset offset = this.readOffsetFromResource("file-source-offset-version-2.1.0-long.txt");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(FileStreamSourceOffset$.MODULE$.apply((Offset)offset));
            FileStreamSourceOffset $org_scalatest_assert_macro_right = new FileStreamSourceOffset(345L);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1351));
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1349));
        this.test("FileStreamSourceLog - read Spark 2.1.0 log format", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.readLogFromResource("file-source-log-version-2.1.0"));
            Seq $org_scalatest_assert_macro_right = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FileStreamSource.FileEntry[]{new FileStreamSource.FileEntry("/a/b/0", 1480730949000L, 0L), new FileStreamSource.FileEntry("/a/b/1", 1480730950000L, 1L), new FileStreamSource.FileEntry("/a/b/2", 1480730950000L, 2L), new FileStreamSource.FileEntry("/a/b/3", 1480730950000L, 3L), new FileStreamSource.FileEntry("/a/b/4", 1480730951000L, 4L)}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1355));
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1354));
        this.test("FileStreamSource - latestFirst", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$160(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1411));
        this.test("SPARK-19813: Ignore maxFileAge when maxFilesPerTrigger and latestFirst is used", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)src -> {
            FileStreamSourceSuite.$anonfun$new$162(this, src);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1426));
        this.test("SeenFilesMap", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            FileStreamSource.SeenFilesMap map = new FileStreamSource.SeenFilesMap(10L, false);
            map.add("a", 5L);
            FileStreamSource.SeenFilesMap $org_scalatest_assert_macro_left = map;
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1442));
            map.purge();
            FileStreamSource.SeenFilesMap $org_scalatest_assert_macro_left2 = map;
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1444));
            map.add("b", 15L);
            FileStreamSource.SeenFilesMap $org_scalatest_assert_macro_left3 = map;
            int $org_scalatest_assert_macro_right3 = 2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1448));
            map.purge();
            FileStreamSource.SeenFilesMap $org_scalatest_assert_macro_left4 = map;
            int $org_scalatest_assert_macro_right4 = 2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1450));
            map.add("c", 16L);
            FileStreamSource.SeenFilesMap $org_scalatest_assert_macro_left5 = map;
            int $org_scalatest_assert_macro_right5 = 3;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left5, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1454));
            map.purge();
            FileStreamSource.SeenFilesMap $org_scalatest_assert_macro_left6 = map;
            int $org_scalatest_assert_macro_right6 = 2;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1456));
            map.add("c", 25L);
            FileStreamSource.SeenFilesMap $org_scalatest_assert_macro_left7 = map;
            int $org_scalatest_assert_macro_right7 = 2;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left7, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1460));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(map.isNewFile("c", 20L), "map.isNewFile(\"c\", 20L)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1463));
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(map.isNewFile("d", 5L), "map.isNewFile(\"d\", 5L)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1466));
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(map.isNewFile("e", 20L), "map.isNewFile(\"e\", 20L)", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1469));
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1438));
        this.test("SeenFilesMap with fileNameOnly = true", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            FileStreamSource.SeenFilesMap map = new FileStreamSource.SeenFilesMap(10L, true);
            map.add("file:///a/b/c/d", 5L);
            map.add("file:///a/b/c/e", 5L);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)map.size()));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1477));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(map.isNewFile("d", 5L), "map.isNewFile(\"d\", 5L)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1479));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(map.isNewFile("file:///d", 5L), "map.isNewFile(\"file:///d\", 5L)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1480));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(map.isNewFile("file:///x/d", 5L), "map.isNewFile(\"file:///x/d\", 5L)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1481));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(map.isNewFile("file:///x/y/d", 5L), "map.isNewFile(\"file:///x/y/d\", 5L)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1482));
            map.add("s3:///bucket/d", 5L);
            map.add("s3n:///bucket/d", 5L);
            map.add("s3a:///bucket/d", 5L);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)map.size()));
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1487));
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1472));
        this.test("SeenFilesMap should only consider a file old if it is earlier than last purge time", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            FileStreamSource.SeenFilesMap map = new FileStreamSource.SeenFilesMap(10L, false);
            map.add("a", 20L);
            FileStreamSource.SeenFilesMap $org_scalatest_assert_macro_left = map;
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1494));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(map.isNewFile("b", 9L), "map.isNewFile(\"b\", 9L)", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1497));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(map.isNewFile("b", 10L), "map.isNewFile(\"b\", 10L)", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1498));
            map.purge();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(map.isNewFile("b", 9L), "map.isNewFile(\"b\", 9L)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1502));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(map.isNewFile("b", 10L), "map.isNewFile(\"b\", 10L)", Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1503));
        }, new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1490));
        this.test("do not recheck that files exist during getBatch", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)temp -> {
            FileStreamSourceSuite.$anonfun$new$167(this, temp);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1506));
        this.test("SPARK-26629: multiple file sources work with restarts when a source does not have data", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDirs((Function2<File, File, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(x0$28, x1$26) -> {
            FileStreamSourceSuite.$anonfun$new$169(this, x0$28, x1$26);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1525));
    }
}

