/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sources.v2;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.sources.v2.CSVDataWriterFactory;
import org.apache.spark.sql.sources.v2.DataSourceOptions;
import org.apache.spark.sql.sources.v2.ReadSupport;
import org.apache.spark.sql.sources.v2.SessionConfigSupport;
import org.apache.spark.sql.sources.v2.SimpleCSVInputPartitionReader;
import org.apache.spark.sql.sources.v2.SimpleCounter$;
import org.apache.spark.sql.sources.v2.WriteSupport;
import org.apache.spark.sql.sources.v2.reader.DataSourceReader;
import org.apache.spark.sql.sources.v2.reader.InputPartition;
import org.apache.spark.sql.sources.v2.writer.DataSourceWriter;
import org.apache.spark.sql.sources.v2.writer.DataWriterFactory;
import org.apache.spark.sql.sources.v2.writer.WriterCommitMessage;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Md\u0001B\u000b\u0017\u0001\rBQ!\u000f\u0001\u0005\u0002iBQ\u0001\u0010\u0001\u0005\u0012uBQ\u0001\u0012\u0001\u0005B\u00153Aa\u0015\u0001\u0001)\"A1\f\u0002B\u0001B\u0003%a\t\u0003\u0005]\t\t\u0005\t\u0015!\u0003^\u0011\u0015ID\u0001\"\u0001e\u0011\u0015IG\u0001\"\u0011>\u0011\u0015QG\u0001\"\u0011l\r\u0011Y\b\u0001\u0001?\t\u0013\u0005\u001d!B!A!\u0002\u00131\u0005\u0002C.\u000b\u0005\u0003\u0005\u000b\u0011\u0002$\t\u0011qS!\u0011!Q\u0001\nuCa!\u000f\u0006\u0005\u0002\u0005%\u0001bBA\n\u0015\u0011\u0005\u0013Q\u0003\u0005\b\u0003;QA\u0011IA\u0010\u0011\u001d\t\u0019D\u0003C!\u0003kAq!!\u0011\u000b\t\u0003\n\u0019\u0005C\u0004\u0002H\u0001!\t%!\u0013\t\u000f\u0005U\u0003\u0001\"\u0011\u0002X\tA2+[7qY\u0016<&/\u001b;bE2,G)\u0019;b'>,(oY3\u000b\u0005]A\u0012A\u0001<3\u0015\tI\"$A\u0004t_V\u00148-Z:\u000b\u0005ma\u0012aA:rY*\u0011QDH\u0001\u0006gB\f'o\u001b\u0006\u0003?\u0001\na!\u00199bG\",'\"A\u0011\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001!C\u0006M\u001a7!\t)#&D\u0001'\u0015\t9\u0003&\u0001\u0003mC:<'\"A\u0015\u0002\t)\fg/Y\u0005\u0003W\u0019\u0012aa\u00142kK\u000e$\bCA\u0017/\u001b\u00051\u0012BA\u0018\u0017\u00051!\u0015\r^1T_V\u00148-\u001a,3!\ti\u0013'\u0003\u00023-\tY!+Z1e'V\u0004\bo\u001c:u!\tiC'\u0003\u00026-\taqK]5uKN+\b\u000f]8siB\u0011QfN\u0005\u0003qY\u0011AcU3tg&|gnQ8oM&<7+\u001e9q_J$\u0018A\u0002\u001fj]&$h\bF\u0001<!\ti\u0003!\u0001\u0006gk2d7k\u00195f[\u0006$\u0012A\u0010\t\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0003\u0003j\tQ\u0001^=qKNL!a\u0011!\u0003\u0015M#(/^2u)f\u0004X-A\u0005lKf\u0004&/\u001a4jqR\ta\t\u0005\u0002H!:\u0011\u0001J\u0014\t\u0003\u00132k\u0011A\u0013\u0006\u0003\u0017\n\na\u0001\u0010:p_Rt$\"A'\u0002\u000bM\u001c\u0017\r\\1\n\u0005=c\u0015A\u0002)sK\u0012,g-\u0003\u0002R%\n11\u000b\u001e:j]\u001eT!a\u0014'\u0003\rI+\u0017\rZ3s'\r!A%\u0016\t\u0003-fk\u0011a\u0016\u0006\u00031Z\taA]3bI\u0016\u0014\u0018B\u0001.X\u0005A!\u0015\r^1T_V\u00148-\u001a*fC\u0012,'/\u0001\u0003qCRD\u0017\u0001B2p]\u001a\u0004\"A\u00182\u000e\u0003}S!\u0001\u00181\u000b\u0005\u0005t\u0012A\u00025bI>|\u0007/\u0003\u0002d?\ni1i\u001c8gS\u001e,(/\u0019;j_:$2!Z4i!\t1G!D\u0001\u0001\u0011\u0015Yv\u00011\u0001G\u0011\u0015av\u00011\u0001^\u0003)\u0011X-\u00193TG\",W.Y\u0001\u0014a2\fg.\u00138qkR\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0002YB\u0019Q\u000e\u001d:\u000e\u00039T!a\u001c\u0015\u0002\tU$\u0018\u000e\\\u0005\u0003c:\u0014A\u0001T5tiB\u0019ak];\n\u0005Q<&AD%oaV$\b+\u0019:uSRLwN\u001c\t\u0003mfl\u0011a\u001e\u0006\u0003qj\t\u0001bY1uC2L8\u000f^\u0005\u0003u^\u00141\"\u00138uKJt\u0017\r\u001c*po\n1qK]5uKJ\u001c2A\u0003\u0013~!\rq\u00181A\u0007\u0002\u007f*\u0019\u0011\u0011\u0001\f\u0002\r]\u0014\u0018\u000e^3s\u0013\r\t)a \u0002\u0011\t\u0006$\u0018mU8ve\u000e,wK]5uKJ\fQA[8c\u0013\u0012$\u0002\"a\u0003\u0002\u000e\u0005=\u0011\u0011\u0003\t\u0003M*Aa!a\u0002\u000f\u0001\u00041\u0005\"B.\u000f\u0001\u00041\u0005\"\u0002/\u000f\u0001\u0004i\u0016aE2sK\u0006$Xm\u0016:ji\u0016\u0014h)Y2u_JLHCAA\f!\u0011q\u0018\u0011D;\n\u0007\u0005mqPA\tECR\fwK]5uKJ4\u0015m\u0019;pef\f!c\u001c8ECR\fwK]5uKJ\u001cu.\\7jiR!\u0011\u0011EA\u0015!\u0011\t\u0019#!\n\u000e\u00031K1!a\nM\u0005\u0011)f.\u001b;\t\u000f\u0005-\u0002\u00031\u0001\u0002.\u00059Q.Z:tC\u001e,\u0007c\u0001@\u00020%\u0019\u0011\u0011G@\u0003']\u0013\u0018\u000e^3s\u0007>lW.\u001b;NKN\u001c\u0018mZ3\u0002\r\r|W.\\5u)\u0011\t\t#a\u000e\t\u000f\u0005e\u0012\u00031\u0001\u0002<\u0005AQ.Z:tC\u001e,7\u000f\u0005\u0004\u0002$\u0005u\u0012QF\u0005\u0004\u0003\u007fa%!B!se\u0006L\u0018!B1c_J$H\u0003BA\u0011\u0003\u000bBq!!\u000f\u0013\u0001\u0004\tY$\u0001\u0007de\u0016\fG/\u001a*fC\u0012,'\u000fF\u0002V\u0003\u0017Bq!!\u0014\u0014\u0001\u0004\ty%A\u0004paRLwN\\:\u0011\u00075\n\t&C\u0002\u0002TY\u0011\u0011\u0003R1uCN{WO]2f\u001fB$\u0018n\u001c8t\u00031\u0019'/Z1uK^\u0013\u0018\u000e^3s))\tI&a\u0018\u0002b\u0005\u0015\u0014\u0011\u000f\t\u0005[\u0006mS0C\u0002\u0002^9\u0014\u0001b\u00149uS>t\u0017\r\u001c\u0005\u0007\u0003\u000f!\u0002\u0019\u0001$\t\r\u0005\rD\u00031\u0001?\u0003\u0019\u00198\r[3nC\"9\u0011q\r\u000bA\u0002\u0005%\u0014\u0001B7pI\u0016\u0004B!a\u001b\u0002n5\t!$C\u0002\u0002pi\u0011\u0001bU1wK6{G-\u001a\u0005\b\u0003\u001b\"\u0002\u0019AA(\u0001")
public class SimpleWritableDataSource
implements ReadSupport,
WriteSupport,
SessionConfigSupport {
    public DataSourceReader createReader(StructType x$1, DataSourceOptions x$2) {
        return super.createReader(x$1, x$2);
    }

    public StructType fullSchema() {
        return new StructType().add("i", "long").add("j", "long");
    }

    public String keyPrefix() {
        return "simpleWritableDataSource";
    }

    public DataSourceReader createReader(DataSourceOptions options) {
        Path path = new Path((String)options.get("path").get());
        Configuration conf = ((SparkContext)SparkContext$.MODULE$.getActive().get()).hadoopConfiguration();
        return new Reader(this, path.toUri().toString(), conf);
    }

    public Optional<DataSourceWriter> createWriter(String jobId, StructType schema, SaveMode mode, DataSourceOptions options) {
        Predef$.MODULE$.assert(!((SparkContext)SparkContext$.MODULE$.getActive().get()).conf().getBoolean("spark.speculation", false));
        Path path = new Path((String)options.get("path").get());
        Configuration conf = ((SparkContext)SparkContext$.MODULE$.getActive().get()).hadoopConfiguration();
        FileSystem fs = path.getFileSystem(conf);
        SaveMode saveMode = mode;
        SaveMode saveMode2 = SaveMode.ErrorIfExists;
        if (!(saveMode != null ? !saveMode.equals(saveMode2) : saveMode2 != null) && fs.exists(path)) {
            throw new RuntimeException("data already exists.");
        }
        SaveMode saveMode3 = mode;
        SaveMode saveMode4 = SaveMode.Ignore;
        if (!(saveMode3 != null ? !saveMode3.equals(saveMode4) : saveMode4 != null) && fs.exists(path)) {
            return Optional.empty();
        }
        SaveMode saveMode5 = mode;
        SaveMode saveMode6 = SaveMode.Overwrite;
        Object object = !(saveMode5 != null ? !saveMode5.equals(saveMode6) : saveMode6 != null) ? BoxesRunTime.boxToBoolean((boolean)fs.delete(path, true)) : BoxedUnit.UNIT;
        String pathStr = path.toUri().toString();
        return Optional.of(new Writer(this, jobId, pathStr, conf));
    }

    public class Reader
    implements DataSourceReader {
        private final String path;
        private final Configuration conf;
        public final /* synthetic */ SimpleWritableDataSource $outer;

        public StructType readSchema() {
            return this.org$apache$spark$sql$sources$v2$SimpleWritableDataSource$Reader$$$outer().fullSchema();
        }

        public List<InputPartition<InternalRow>> planInputPartitions() {
            Path dataPath = new Path(this.path);
            FileSystem fs = dataPath.getFileSystem(this.conf);
            return fs.exists(dataPath) ? (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(dataPath))).filterNot((Function1 & Serializable & scala.Serializable)status -> BoxesRunTime.boxToBoolean((boolean)Reader.$anonfun$planInputPartitions$1(status))))).map((Function1 & Serializable & scala.Serializable)f -> {
                SerializableConfiguration serializableConf = new SerializableConfiguration($this.conf);
                return new SimpleCSVInputPartitionReader(f.getPath().toUri().toString(), serializableConf);
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InputPartition.class))))).toList()).asJava() : Collections.emptyList();
        }

        public /* synthetic */ SimpleWritableDataSource org$apache$spark$sql$sources$v2$SimpleWritableDataSource$Reader$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ boolean $anonfun$planInputPartitions$1(FileStatus status) {
            String name = status.getPath().getName();
            return name.startsWith("_") || name.startsWith(".");
        }

        public Reader(SimpleWritableDataSource $outer, String path, Configuration conf) {
            this.path = path;
            this.conf = conf;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    public class Writer
    implements DataSourceWriter {
        private final String jobId;
        private final String path;
        private final Configuration conf;
        public final /* synthetic */ SimpleWritableDataSource $outer;

        public boolean useCommitCoordinator() {
            return super.useCommitCoordinator();
        }

        public DataWriterFactory<InternalRow> createWriterFactory() {
            SimpleCounter$.MODULE$.resetCounter();
            return new CSVDataWriterFactory(this.path, this.jobId, new SerializableConfiguration(this.conf));
        }

        public void onDataWriterCommit(WriterCommitMessage message) {
            SimpleCounter$.MODULE$.increaseCounter();
        }

        public void commit(WriterCommitMessage[] messages) {
            Path finalPath = new Path(this.path);
            Path jobPath = new Path(new Path(finalPath, "_temporary"), this.jobId);
            FileSystem fs = jobPath.getFileSystem(this.conf);
            try {
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(jobPath))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getPath(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class))))).foreach((Function1 & Serializable & scala.Serializable)file -> {
                    Writer.$anonfun$commit$2(finalPath, fs, file);
                    return BoxedUnit.UNIT;
                });
            }
            finally {
                fs.delete(jobPath, true);
            }
        }

        public void abort(WriterCommitMessage[] messages) {
            Path jobPath = new Path(new Path(this.path, "_temporary"), this.jobId);
            FileSystem fs = jobPath.getFileSystem(this.conf);
            fs.delete(jobPath, true);
        }

        public /* synthetic */ SimpleWritableDataSource org$apache$spark$sql$sources$v2$SimpleWritableDataSource$Writer$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$commit$2(Path finalPath$1, FileSystem fs$1, Path file) {
            Path dest = new Path(finalPath$1, file.getName());
            if (!fs$1.rename(file, dest)) {
                throw new IOException(new StringBuilder(20).append("failed to rename(").append(file).append(", ").append(dest).append(")").toString());
            }
        }

        public Writer(SimpleWritableDataSource $outer, String jobId, String path, Configuration conf) {
            this.jobId = jobId;
            this.path = path;
            this.conf = conf;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

