/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.File;
import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.spark.LocalSparkContext$;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.execution.streaming.MemoryStream;
import org.apache.spark.sql.execution.streaming.MemoryStream$;
import org.apache.spark.sql.execution.streaming.state.HDFSBackedStateStoreProvider;
import org.apache.spark.sql.execution.streaming.state.RenameLikeHDFSFileSystem;
import org.apache.spark.sql.execution.streaming.state.RenameReturnsFalseFileSystem;
import org.apache.spark.sql.execution.streaming.state.RenameReturnsFalseFileSystem$;
import org.apache.spark.sql.execution.streaming.state.StateStore;
import org.apache.spark.sql.execution.streaming.state.StateStore$;
import org.apache.spark.sql.execution.streaming.state.StateStoreConf;
import org.apache.spark.sql.execution.streaming.state.StateStoreConf$;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorRef;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorSuite$;
import org.apache.spark.sql.execution.streaming.state.StateStoreId;
import org.apache.spark.sql.execution.streaming.state.StateStoreId$;
import org.apache.spark.sql.execution.streaming.state.StateStoreProvider;
import org.apache.spark.sql.execution.streaming.state.StateStoreProviderId;
import org.apache.spark.sql.execution.streaming.state.StateStoreSuiteBase;
import org.apache.spark.sql.execution.streaming.state.StateStoreTestsHelper$;
import org.apache.spark.sql.execution.streaming.state.UnsafeRowPair;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.PrivateMethodTester;
import org.scalatest.PrivateMethodTester$PrivateMethod$;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.time.Span;
import org.scalatest.time.SpanSugar$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001B\n\u0015\u0001\rBQ\u0001\u000e\u0001\u0005\u0002U*Aa\u000e\u0001\u0001q!9!\n\u0001b\u0001\n\u0003Y\u0005B\u0002*\u0001A\u0003%A\nC\u0004T\u0001\t\u0007I\u0011A&\t\rQ\u0003\u0001\u0015!\u0003M\u0011\u0015)\u0006\u0001\"\u0011W\u0011\u0015)\u0006\u0001\"\u0011X\u0011\u0015i\u0006\u0001\"\u0011_\u0011\u00151\b\u0001\"\u0011x\u0011\u001da\b!%A\u0005\u0002uDa!\u0016\u0001\u0005\u0002\u0005E\u0001\"CA\u001f\u0001E\u0005I\u0011AA \u0011!\t\u0019\u0005AI\u0001\n\u0003i\b\"CA#\u0001E\u0005I\u0011AA$\u0011\u001d\tY\u0005\u0001C\u0001\u0003\u001bBq!!\u0018\u0001\t\u0003\ty\u0006C\u0004\u0002l\u0001!\t!!\u001c\u0003\u001fM#\u0018\r^3Ti>\u0014XmU;ji\u0016T!!\u0006\f\u0002\u000bM$\u0018\r^3\u000b\u0005]A\u0012!C:ue\u0016\fW.\u001b8h\u0015\tI\"$A\u0005fq\u0016\u001cW\u000f^5p]*\u00111\u0004H\u0001\u0004gFd'BA\u000f\u001f\u0003\u0015\u0019\b/\u0019:l\u0015\ty\u0002%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002C\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001J\u00162!\r)c\u0005K\u0007\u0002)%\u0011q\u0005\u0006\u0002\u0014'R\fG/Z*u_J,7+^5uK\n\u000b7/\u001a\t\u0003K%J!A\u000b\u000b\u00039!#ei\u0015\"bG.,Gm\u0015;bi\u0016\u001cFo\u001c:f!J|g/\u001b3feB\u0011AfL\u0007\u0002[)\u0011a\u0006I\u0001\ng\u000e\fG.\u0019;fgRL!\u0001M\u0017\u0003\u001d\t+gm\u001c:f\u0003:$\u0017I\u001a;feB\u0011AFM\u0005\u0003g5\u00121\u0003\u0015:jm\u0006$X-T3uQ>$G+Z:uKJ\fa\u0001P5oSRtD#\u0001\u001c\u0011\u0005\u0015\u0002!aB'baRK\b/\u001a\t\u0005s\u0001\u0013%)D\u0001;\u0015\tYD(A\u0004nkR\f'\r\\3\u000b\u0005ur\u0014AC2pY2,7\r^5p]*\tq(A\u0003tG\u0006d\u0017-\u0003\u0002Bu\t9\u0001*Y:i\u001b\u0006\u0004\bCA\"I\u001b\u0005!%BA#G\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u001dS\u0012\u0001C2bi\u0006d\u0017p\u001d;\n\u0005%#%!C+og\u00064WMU8x\u0003%YW-_*dQ\u0016l\u0017-F\u0001M!\ti\u0005+D\u0001O\u0015\ty%$A\u0003usB,7/\u0003\u0002R\u001d\nQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\u0015-,\u0017pU2iK6\f\u0007%A\u0006wC2,XmU2iK6\f\u0017\u0001\u0004<bYV,7k\u00195f[\u0006\u0004\u0013\u0001\u00058foN#xN]3Qe>4\u0018\u000eZ3s)\u0005ACC\u0001\u0015Y\u0011\u0015I\u0006\u00021\u0001[\u0003\u001d\u0019Ho\u001c:f\u0013\u0012\u0004\"!J.\n\u0005q#\"\u0001D*uCR,7\u000b^8sK&#\u0017!D4fi2\u000bG/Z:u\t\u0006$\u0018\r\u0006\u0002`iB\u0019\u0001m\u001a6\u000f\u0005\u0005,\u0007C\u00012?\u001b\u0005\u0019'B\u00013#\u0003\u0019a$o\\8u}%\u0011aMP\u0001\u0007!J,G-\u001a4\n\u0005!L'aA*fi*\u0011aM\u0010\t\u0005W2t\u0017/D\u0001?\u0013\tigH\u0001\u0004UkBdWM\r\t\u0003A>L!\u0001]5\u0003\rM#(/\u001b8h!\tY'/\u0003\u0002t}\t\u0019\u0011J\u001c;\t\u000bUL\u0001\u0019\u0001\u0015\u0002\u001bM$xN]3Qe>4\u0018\u000eZ3s\u0003\u001d9W\r\u001e#bi\u0006$2a\u0018={\u0011\u0015I(\u00021\u0001)\u0003!\u0001(o\u001c<jI\u0016\u0014\bbB>\u000b!\u0003\u0005\r!]\u0001\bm\u0016\u00148/[8o\u0003E9W\r\u001e#bi\u0006$C-\u001a4bk2$HEM\u000b\u0002}*\u0012\u0011o`\u0016\u0003\u0003\u0003\u0001B!a\u0001\u0002\u000e5\u0011\u0011Q\u0001\u0006\u0005\u0003\u000f\tI!A\u0005v]\u000eDWmY6fI*\u0019\u00111\u0002 \u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0010\u0005\u0015!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dKRY\u0001&a\u0005\u0002\u001e\u0005\u0005\u0012QEA\u0015\u0011\u001d\t)\u0002\u0004a\u0001\u0003/\tAa\u001c9JIB\u00191.!\u0007\n\u0007\u0005maH\u0001\u0003M_:<\u0007BBA\u0010\u0019\u0001\u0007\u0011/A\u0005qCJ$\u0018\u000e^5p]\"A\u00111\u0005\u0007\u0011\u0002\u0003\u0007a.A\u0002eSJD\u0001\"a\n\r!\u0003\u0005\r!]\u0001\u0015[&tG)\u001a7uCN4uN]*oCB\u001c\bn\u001c;\t\u0013\u0005-B\u0002%AA\u0002\u00055\u0012A\u00035bI>|\u0007oQ8oMB!\u0011qFA\u001d\u001b\t\t\tD\u0003\u0003\u00024\u0005U\u0012\u0001B2p]\u001aT1!a\u000e\u001f\u0003\u0019A\u0017\rZ8pa&!\u00111HA\u0019\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u0006Qb.Z<Ti>\u0014X\r\u0015:pm&$WM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011\u0011\t\u0016\u0003]~\f!D\\3x'R|'/\u001a)s_ZLG-\u001a:%I\u00164\u0017-\u001e7uIQ\n!D\\3x'R|'/\u001a)s_ZLG-\u001a:%I\u00164\u0017-\u001e7uIU*\"!!\u0013+\u0007\u00055r0\u0001\u0006gS2,W\t_5tiN$\u0002\"a\u0014\u0002V\u0005]\u0013\u0011\f\t\u0004W\u0006E\u0013bAA*}\t9!i\\8mK\u0006t\u0007\"B=\u0011\u0001\u0004A\u0003BB>\u0011\u0001\u0004\t9\u0002C\u0004\u0002\\A\u0001\r!a\u0014\u0002\u0015%\u001c8K\\1qg\"|G/A\u000feK2,G/\u001a$jY\u0016\u001cX)\u0019:mS\u0016\u0014H\u000b[1o-\u0016\u00148/[8o)\u0019\t\t'a\u001a\u0002jA\u00191.a\u0019\n\u0007\u0005\u0015dH\u0001\u0003V]&$\b\"B=\u0012\u0001\u0004A\u0003BB>\u0012\u0001\u0004\t9\"A\u0006d_J\u0014X\u000f\u001d;GS2,G\u0003CA1\u0003_\n\t(a\u001d\t\u000be\u0014\u0002\u0019\u0001\u0015\t\rm\u0014\u0002\u0019AA\f\u0011\u001d\tYF\u0005a\u0001\u0003\u001f\u0002")
public class StateStoreSuite
extends StateStoreSuiteBase<HDFSBackedStateStoreProvider>
implements BeforeAndAfter,
PrivateMethodTester {
    private final StructType keySchema;
    private final StructType valueSchema;
    private volatile PrivateMethodTester$PrivateMethod$ PrivateMethod$module;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public PrivateMethodTester.Invoker anyRefToInvoker(Object target) {
        return PrivateMethodTester.anyRefToInvoker$((PrivateMethodTester)this, (Object)target);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    public PrivateMethodTester$PrivateMethod$ PrivateMethod() {
        if (this.PrivateMethod$module == null) {
            this.PrivateMethod$lzycompute$1();
        }
        return this.PrivateMethod$module;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public StructType keySchema() {
        return this.keySchema;
    }

    public StructType valueSchema() {
        return this.valueSchema;
    }

    @Override
    public HDFSBackedStateStoreProvider newStoreProvider() {
        return this.newStoreProvider(Random$.MODULE$.nextInt(), 0, this.newStoreProvider$default$3(), this.newStoreProvider$default$4(), this.newStoreProvider$default$5());
    }

    @Override
    public HDFSBackedStateStoreProvider newStoreProvider(StateStoreId storeId) {
        return this.newStoreProvider(storeId.operatorId(), storeId.partitionId(), storeId.checkpointRootLocation(), this.newStoreProvider$default$4(), this.newStoreProvider$default$5());
    }

    @Override
    public Set<Tuple2<String, Object>> getLatestData(HDFSBackedStateStoreProvider storeProvider) {
        return this.getData(storeProvider, this.getData$default$2());
    }

    @Override
    public Set<Tuple2<String, Object>> getData(HDFSBackedStateStoreProvider provider, int version) {
        HDFSBackedStateStoreProvider reloadedProvider = this.newStoreProvider(provider.stateStoreId());
        return version < 0 ? reloadedProvider.latestIterator().map((Function1 & Serializable & scala.Serializable)row -> StateStoreTestsHelper$.MODULE$.rowsToStringInt((UnsafeRowPair)row)).toSet() : reloadedProvider.getStore((long)version).iterator().map((Function1 & Serializable & scala.Serializable)row -> StateStoreTestsHelper$.MODULE$.rowsToStringInt((UnsafeRowPair)row)).toSet();
    }

    public int getData$default$2() {
        return -1;
    }

    public HDFSBackedStateStoreProvider newStoreProvider(long opId, int partition, String dir, int minDeltasForSnapshot, Configuration hadoopConf) {
        SQLConf sqlConf = new SQLConf();
        sqlConf.setConf(SQLConf$.MODULE$.STATE_STORE_MIN_DELTAS_FOR_SNAPSHOT(), (Object)BoxesRunTime.boxToInteger((int)minDeltasForSnapshot));
        sqlConf.setConf(SQLConf$.MODULE$.MIN_BATCHES_TO_RETAIN(), (Object)BoxesRunTime.boxToInteger((int)2));
        HDFSBackedStateStoreProvider provider = new HDFSBackedStateStoreProvider();
        provider.init(new StateStoreId(dir, opId, partition, StateStoreId$.MODULE$.apply$default$4()), this.keySchema(), this.valueSchema(), (Option)None$.MODULE$, new StateStoreConf(sqlConf), hadoopConf);
        return provider;
    }

    public String newStoreProvider$default$3() {
        return StateStoreTestsHelper$.MODULE$.newDir();
    }

    public int newStoreProvider$default$4() {
        return BoxesRunTime.unboxToInt((Object)SQLConf$.MODULE$.STATE_STORE_MIN_DELTAS_FOR_SNAPSHOT().defaultValue().get());
    }

    public Configuration newStoreProvider$default$5() {
        return new Configuration();
    }

    public boolean fileExists(HDFSBackedStateStoreProvider provider, long version, boolean isSnapshot) {
        PrivateMethodTester.PrivateMethod method = this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "baseDir"));
        Path basePath = (Path)this.anyRefToInvoker(provider).invokePrivate(method.apply((Seq)Nil$.MODULE$));
        String fileName = isSnapshot ? new StringBuilder(9).append(version).append(".snapshot").toString() : new StringBuilder(6).append(version).append(".delta").toString();
        File filePath = new File(basePath.toString(), fileName);
        return filePath.exists();
    }

    public void deleteFilesEarlierThanVersion(HDFSBackedStateStoreProvider provider, long version2) {
        PrivateMethodTester.PrivateMethod method = this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "baseDir"));
        Path basePath = (Path)this.anyRefToInvoker(provider).invokePrivate(method.apply((Seq)Nil$.MODULE$));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)version2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)version -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)isSnapshot -> StateStoreSuite.$anonfun$deleteFilesEarlierThanVersion$2(version, basePath, BoxesRunTime.unboxToBoolean((Object)isSnapshot))));
    }

    public void corruptFile(HDFSBackedStateStoreProvider provider, long version, boolean isSnapshot) {
        PrivateMethodTester.PrivateMethod method = this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "baseDir"));
        Path basePath = (Path)this.anyRefToInvoker(provider).invokePrivate(method.apply((Seq)Nil$.MODULE$));
        String fileName = isSnapshot ? new StringBuilder(9).append(version).append(".snapshot").toString() : new StringBuilder(6).append(version).append(".delta").toString();
        File filePath = new File(basePath.toString(), fileName);
        filePath.delete();
        filePath.createNewFile();
    }

    private final void PrivateMethod$lzycompute$1() {
        StateStoreSuite stateStoreSuite = this;
        synchronized (stateStoreSuite) {
            if (this.PrivateMethod$module == null) {
                this.PrivateMethod$module = new PrivateMethodTester$PrivateMethod$((PrivateMethodTester)this);
            }
        }
    }

    private final void updateVersionTo$1(int targetVersion, IntRef currentVersion$1, HDFSBackedStateStoreProvider provider$1) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(currentVersion$1.elem + 1), targetVersion).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            StateStore store = provider$1.getStore((long)currentVersion$1.elem);
            StateStoreTestsHelper$.MODULE$.put(store, "a", i);
            store.commit();
            ++currentVersion$1.elem;
        });
        Predef$.MODULE$.require(this.convertToEqualizer(BoxesRunTime.boxToInteger((int)currentVersion$1.elem)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)targetVersion), Equality$.MODULE$.default()));
    }

    public static final /* synthetic */ Assertion $anonfun$new$5(StateStoreSuite $this, HDFSBackedStateStoreProvider provider$1, int i) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool($this.fileExists(provider$1, i, false), "StateStoreSuite.this.fileExists(provider, i.toLong, false)", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool($this.fileExists(provider$1, i, true), "StateStoreSuite.this.fileExists(provider, i.toLong, true)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
    }

    public static final /* synthetic */ boolean $anonfun$new$14(File x$1) {
        return x$1.getName().startsWith("temp-");
    }

    private final void generateStoreVersions$1(StateStoreProviderId storeProviderId$1, IntRef latestStoreVersion$1, StateStoreConf storeConf$2, Configuration hadoopConf$2) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            StateStore store = StateStore$.MODULE$.get(storeProviderId$1, this.keySchema(), this.valueSchema(), (Option)None$.MODULE$, (long)latestStoreVersion$1.elem, storeConf$2, hadoopConf$2);
            StateStoreTestsHelper$.MODULE$.put(store, "a", i);
            store.commit();
            ++latestStoreVersion$1.elem;
        });
    }

    public static final /* synthetic */ void $anonfun$new$31(StateStoreSuite $this, Span timeoutDuration$1, StateStoreProviderId storeProviderId$1, IntRef latestStoreVersion$1, HDFSBackedStateStoreProvider provider$4, StateStoreConf storeConf$2, Configuration hadoopConf$2, StateStoreCoordinatorRef coordinatorRef) {
        Predef$.MODULE$.require(!StateStore$.MODULE$.isMaintenanceRunning(), (Function0 & Serializable & scala.Serializable)() -> "StateStore is unexpectedly running");
        $this.generateStoreVersions$1(storeProviderId$1, latestStoreVersion$1, storeConf$2, hadoopConf$2);
        Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(timeoutDuration$1), (Function0 & Serializable & scala.Serializable)() -> {
            IndexedSeq snapshotVersions;
            Option $org_scalatest_assert_macro_left = coordinatorRef.getLocation(storeProviderId$1);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"active instance was not reported", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 291));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isMaintenanceRunning(), "StateStore.isMaintenanceRunning", Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Maintenance task is not running", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 295));
            IndexedSeq $org_scalatest_assert_macro_left2 = snapshotVersions = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), latestStoreVersion$1.elem).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)version -> $this.fileExists(provider$4, version, true));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "nonEmpty", $org_scalatest_assert_macro_left2.nonEmpty(), Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"no snapshot file found", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 301));
        }, Eventually$.MODULE$.patienceConfig(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 289));
        $this.generateStoreVersions$1(storeProviderId$1, latestStoreVersion$1, storeConf$2, hadoopConf$2);
        Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(timeoutDuration$1), (Function0 & Serializable & scala.Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool($this.fileExists(provider$4, 1L, false), "StateStoreSuite.this.fileExists(provider, 1L, false)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"earliest file not deleted", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 310));
        }, Eventually$.MODULE$.patienceConfig(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 309));
        coordinatorRef.deactivateInstances(storeProviderId$1.queryRunId());
        Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(timeoutDuration$1), (Function0 & Serializable & scala.Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeProviderId$1), "StateStore.isLoaded(storeProviderId)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 317));
        }, Eventually$.MODULE$.patienceConfig(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 316));
        StateStore$.MODULE$.get(storeProviderId$1, $this.keySchema(), $this.valueSchema(), (Option)None$.MODULE$, (long)latestStoreVersion$1.elem, storeConf$2, hadoopConf$2);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeProviderId$1), "StateStore.isLoaded(storeProviderId)", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 323));
        coordinatorRef.reportActiveInstance(storeProviderId$1, "other-host", "other-exec");
        Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(timeoutDuration$1), (Function0 & Serializable & scala.Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeProviderId$1), "StateStore.isLoaded(storeProviderId)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 328));
        }, Eventually$.MODULE$.patienceConfig(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 327));
        StateStore$.MODULE$.get(storeProviderId$1, $this.keySchema(), $this.valueSchema(), (Option)None$.MODULE$, (long)latestStoreVersion$1.elem, storeConf$2, hadoopConf$2);
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeProviderId$1), "StateStore.isLoaded(storeProviderId)", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 334));
    }

    public static final /* synthetic */ boolean $anonfun$new$43(String n) {
        return n.contains("temp") && !n.startsWith(".");
    }

    private static final int numTempFiles$1(File deltaFileDir$1) {
        return deltaFileDir$1.exists() ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])deltaFileDir$1.listFiles())).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).count((Function1 & Serializable & scala.Serializable)n -> BoxesRunTime.boxToBoolean((boolean)StateStoreSuite.$anonfun$new$43(n))) : 0;
    }

    public static final /* synthetic */ boolean $anonfun$new$45(String n) {
        return n.contains(".delta") && !n.startsWith(".");
    }

    private static final int numDeltaFiles$1(File deltaFileDir$1) {
        return deltaFileDir$1.exists() ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])deltaFileDir$1.listFiles())).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).count((Function1 & Serializable & scala.Serializable)n -> BoxesRunTime.boxToBoolean((boolean)StateStoreSuite.$anonfun$new$45(n))) : 0;
    }

    private final Object shouldNotCreateTempFile$1(Function0 body, File deltaFileDir$1) {
        int before = StateStoreSuite.numTempFiles$1(deltaFileDir$1);
        Object result = body.apply();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numTempFiles$1(deltaFileDir$1)));
        int $org_scalatest_assert_macro_right = before;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 382));
        return result;
    }

    public static final /* synthetic */ boolean $anonfun$new$48(String x$4) {
        String string = x$4;
        String string2 = "a";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private final Seq runQueryAndGetLoadedProviders$1(MemoryStream inputData$1, File checkpointLocation$1) {
        Seq seq;
        HashMap loadedProvidersMap;
        Dataset aggregated = inputData$1.toDF().groupBy("value", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).agg((Column)functions$.MODULE$.count("*"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0]));
        StreamingQuery query = aggregated.writeStream().format("memory").outputMode("complete").queryName("query").option("checkpointLocation", checkpointLocation$1.toString()).start();
        inputData$1.addData((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        query.processAllAvailable();
        Predef$.MODULE$.require(query.lastProgress() != null);
        PrivateMethodTester.PrivateMethod loadedProvidersMethod = this.PrivateMethod().apply((Symbol)SymbolLiteral.bootstrap("apply", "loadedProviders"));
        HashMap hashMap = loadedProvidersMap = (HashMap)this.anyRefToInvoker(StateStore$.MODULE$).invokePrivate(loadedProvidersMethod.apply((Seq)Nil$.MODULE$));
        synchronized (hashMap) {
            seq = loadedProvidersMap.values().toSeq();
        }
        Seq loadedProviders = seq;
        query.stop();
        return loadedProviders;
    }

    public static final /* synthetic */ void $anonfun$new$51(SparkSession spark) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])spark.streams().active())).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            x$5.stop();
            return BoxedUnit.UNIT;
        });
        spark.stop();
    }

    public static final /* synthetic */ Object $anonfun$deleteFilesEarlierThanVersion$2(int version$1, Path basePath$1, boolean isSnapshot) {
        String fileName = isSnapshot ? new StringBuilder(9).append(version$1).append(".snapshot").toString() : new StringBuilder(6).append(version$1).append(".delta").toString();
        File filePath = new File(basePath$1.toString(), fileName);
        return filePath.exists() ? BoxesRunTime.boxToBoolean((boolean)filePath.delete()) : BoxedUnit.UNIT;
    }

    public StateStoreSuite() {
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        PrivateMethodTester.$init$((PrivateMethodTester)this);
        this.keySchema = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("key", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4())})));
        this.valueSchema = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("value", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4())})));
        this.before((Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            StateStore$.MODULE$.stop();
            Predef$.MODULE$.require(!StateStore$.MODULE$.isMaintenanceRunning());
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
        this.after((Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            StateStore$.MODULE$.stop();
            Predef$.MODULE$.require(!StateStore$.MODULE$.isMaintenanceRunning());
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        this.test("snapshotting", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Option latestSnapshotVersion;
            Option snapshotVersion;
            long x$1 = Random$.MODULE$.nextInt();
            int x$2 = 0;
            int x$3 = 5;
            String x$4 = this.newStoreProvider$default$3();
            Configuration x$5 = this.newStoreProvider$default$5();
            HDFSBackedStateStoreProvider provider = this.newStoreProvider(x$1, x$2, x$4, x$3, x$5);
            IntRef currentVersion = IntRef.create((int)0);
            this.updateVersionTo$1(2, currentVersion, provider);
            Predef$.MODULE$.require(this.convertToEqualizer(this.getData(provider, this.getData$default$2())).$eq$eq$eq((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)2))})), Equality$.MODULE$.default()));
            provider.doMaintenance();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.getData(provider, this.getData$default$2()));
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)2))}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), currentVersion.elem).foreach((Function1 & Serializable & scala.Serializable)i -> StateStoreSuite.$anonfun$new$5(this, provider, BoxesRunTime.unboxToInt((Object)i)));
            this.updateVersionTo$1(6, currentVersion, provider);
            Predef$.MODULE$.require(this.convertToEqualizer(this.getData(provider, this.getData$default$2())).$eq$eq$eq((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)6))})), Equality$.MODULE$.default()), (Function0 & Serializable & scala.Serializable)() -> "store not updated correctly");
            provider.doMaintenance();
            Option $org_scalatest_assert_macro_left2 = snapshotVersion = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 6).find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)version -> this.fileExists(provider, version, true));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "nonEmpty", $org_scalatest_assert_macro_left2.nonEmpty(), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"snapshot file not generated", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
            this.deleteFilesEarlierThanVersion(provider, BoxesRunTime.unboxToInt((Object)snapshotVersion.get()));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(this.getData(provider, BoxesRunTime.unboxToInt((Object)snapshotVersion.get())));
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), snapshotVersion.get())}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"snapshotting messed up the data of the snapshotted version", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(this.getData(provider, this.getData$default$2()));
            Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)6))}));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"snapshotting messed up the data of the final version", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
            this.updateVersionTo$1(20, currentVersion, provider);
            Predef$.MODULE$.require(this.convertToEqualizer(this.getData(provider, this.getData$default$2())).$eq$eq$eq((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)20))})), Equality$.MODULE$.default()), (Function0 & Serializable & scala.Serializable)() -> "store not updated correctly");
            provider.doMaintenance();
            Option $org_scalatest_assert_macro_left5 = latestSnapshotVersion = ((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 20).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)version -> this.fileExists(provider, version, true))).lastOption();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left5, "nonEmpty", $org_scalatest_assert_macro_left5.nonEmpty(), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"no snapshot file found", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
            int $org_scalatest_assert_macro_left6 = BoxesRunTime.unboxToInt((Object)latestSnapshotVersion.get());
            int $org_scalatest_assert_macro_right4 = BoxesRunTime.unboxToInt((Object)snapshotVersion.get());
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left6 > $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"newer snapshot not generated", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
            this.deleteFilesEarlierThanVersion(provider, BoxesRunTime.unboxToInt((Object)latestSnapshotVersion.get()));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(this.getData(provider, this.getData$default$2()));
            Set $org_scalatest_assert_macro_right5 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)20))}));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"snapshotting messed up the data", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        this.test("cleaning", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            long x$6 = Random$.MODULE$.nextInt();
            int x$7 = 0;
            int x$8 = 5;
            String x$9 = this.newStoreProvider$default$3();
            Configuration x$10 = this.newStoreProvider$default$5();
            HDFSBackedStateStoreProvider provider = this.newStoreProvider(x$6, x$7, x$9, x$8, x$10);
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                StateStore store = provider.getStore((long)(i - 1));
                StateStoreTestsHelper$.MODULE$.put(store, "a", i);
                store.commit();
                provider.doMaintenance();
            });
            Predef$.MODULE$.require(this.convertToEqualizer(StateStoreTestsHelper$.MODULE$.rowsToSet((Iterator<UnsafeRowPair>)provider.latestIterator())).$eq$eq$eq((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)20))})), Equality$.MODULE$.default()), (Function0 & Serializable & scala.Serializable)() -> "store not updated correctly");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.fileExists(provider, 1L, false), "StateStoreSuite.this.fileExists(provider, 1L, false)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.getData(provider, 20));
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)20))}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.getData(provider, 19));
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)19))}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
        this.test("SPARK-19677: Committing a delta file atop an existing one should not fail on HDFS", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Iterable tempFiles;
            Configuration conf = new Configuration();
            conf.set("fs.fake.impl", RenameLikeHDFSFileSystem.class.getName());
            conf.set("fs.defaultFS", "fake:///");
            long x$11 = Random$.MODULE$.nextInt();
            int x$12 = 0;
            Configuration x$13 = conf;
            String x$14 = this.newStoreProvider$default$3();
            int x$15 = this.newStoreProvider$default$4();
            HDFSBackedStateStoreProvider provider = this.newStoreProvider(x$11, x$12, x$14, x$15, x$13);
            provider.getStore(0L).commit();
            provider.getStore(0L).commit();
            Iterable $org_scalatest_assert_macro_left = tempFiles = (Iterable)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(FileUtils.listFiles((File)new File(provider.stateStoreId().checkpointRootLocation()), null, (boolean)true)).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StateStoreSuite.$anonfun$new$14(x$1)));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
        this.test("corrupted file handling", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            long x$16 = Random$.MODULE$.nextInt();
            int x$17 = 0;
            int x$18 = 5;
            String x$19 = this.newStoreProvider$default$3();
            Configuration x$20 = this.newStoreProvider$default$5();
            HDFSBackedStateStoreProvider provider = this.newStoreProvider(x$16, x$17, x$19, x$18, x$20);
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 6).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                StateStore store = provider.getStore((long)(i - 1));
                StateStoreTestsHelper$.MODULE$.put(store, "a", i);
                store.commit();
                provider.doMaintenance();
            });
            int snapshotVersion = BoxesRunTime.unboxToInt((Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 10).find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)version -> this.fileExists(provider, version, true)).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.fail("snapshot file not found", new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165))));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.getData(provider, snapshotVersion));
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)snapshotVersion))}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
            this.corruptFile(provider, snapshotVersion, true);
            this.intercept((Function0 & Serializable & scala.Serializable)() -> this.getData(provider, snapshotVersion), ClassTag$.MODULE$.apply(Exception.class), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(this.getData(provider, snapshotVersion - 1));
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)(snapshotVersion - 1)))}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
            this.corruptFile(provider, snapshotVersion - 1, false);
            this.intercept((Function0 & Serializable & scala.Serializable)() -> this.getData(provider, snapshotVersion - 1), ClassTag$.MODULE$.apply(Exception.class), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
            this.deleteFilesEarlierThanVersion(provider, snapshotVersion);
            return (Exception)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.getData(provider, snapshotVersion - 1), ClassTag$.MODULE$.apply(Exception.class), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
        this.test("reports memory usage", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            HDFSBackedStateStoreProvider provider = this.newStoreProvider();
            StateStore store = provider.getStore(0L);
            long noDataMemoryUsed = store.metrics().memoryUsedBytes();
            StateStoreTestsHelper$.MODULE$.put(store, "a", 1);
            store.commit();
            long $org_scalatest_assert_macro_left = store.metrics().memoryUsedBytes();
            long $org_scalatest_assert_macro_right = noDataMemoryUsed;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
        this.test("StateStore.get", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (Assertion)package$.MODULE$.quietly((Function0 & Serializable & scala.Serializable)() -> {
            String dir = StateStoreTestsHelper$.MODULE$.newDir();
            StateStoreProviderId storeId = new StateStoreProviderId(new StateStoreId(dir, 0L, 0, StateStoreId$.MODULE$.apply$default$4()), UUID.randomUUID());
            StateStoreConf storeConf = StateStoreConf$.MODULE$.empty();
            Configuration hadoopConf = new Configuration();
            this.intercept((Function0 & Serializable & scala.Serializable)() -> StateStore$.MODULE$.get(storeId, this.keySchema(), this.valueSchema(), (Option)None$.MODULE$, -1L, storeConf, hadoopConf), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 205));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeId), "StateStore.isLoaded(storeId)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> StateStore$.MODULE$.get(storeId, this.keySchema(), this.valueSchema(), (Option)None$.MODULE$, 1L, storeConf, hadoopConf), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 211));
            StateStore store0 = StateStore$.MODULE$.get(storeId, this.keySchema(), this.valueSchema(), (Option)None$.MODULE$, 0L, storeConf, hadoopConf);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)store0.version()));
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219));
            StateStoreTestsHelper$.MODULE$.put(store0, "a", 1);
            store0.commit();
            StateStore store1 = StateStore$.MODULE$.get(storeId, this.keySchema(), this.valueSchema(), (Option)None$.MODULE$, 1L, storeConf, hadoopConf);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeId), "StateStore.isLoaded(storeId)", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 225));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)store1.version()));
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 226));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(StateStoreTestsHelper$.MODULE$.rowsToSet((Iterator<UnsafeRowPair>)store1.iterator()));
            Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)1))}));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 227));
            StateStore store0reloaded = StateStore$.MODULE$.get(storeId, this.keySchema(), this.valueSchema(), (Option)None$.MODULE$, 0L, storeConf, hadoopConf);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)store0reloaded.version()));
            int $org_scalatest_assert_macro_right4 = 0;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(StateStoreTestsHelper$.MODULE$.rowsToSet((Iterator<UnsafeRowPair>)store0reloaded.iterator()));
            Set $org_scalatest_assert_macro_right5 = Predef$.MODULE$.Set().empty();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
            StateStore$.MODULE$.unload(storeId);
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeId), "StateStore.isLoaded(storeId)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 237));
            StateStore store1reloaded = StateStore$.MODULE$.get(storeId, this.keySchema(), this.valueSchema(), (Option)None$.MODULE$, 1L, storeConf, hadoopConf);
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeId), "StateStore.isLoaded(storeId)", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)store1reloaded.version()));
            int $org_scalatest_assert_macro_right6 = 1;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
            StateStoreTestsHelper$.MODULE$.put(store1reloaded, "a", 2);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)store1reloaded.commit()));
            int $org_scalatest_assert_macro_right7 = 2;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 244));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(StateStoreTestsHelper$.MODULE$.rowsToSet((Iterator<UnsafeRowPair>)store1reloaded.iterator()));
            Set $org_scalatest_assert_macro_right8 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)2))}));
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 245));
        }), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 197));
        this.test("maintenance", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkConf conf = new SparkConf().setMaster("local").setAppName("test").set(StateStore$.MODULE$.MAINTENANCE_INTERVAL_CONFIG(), "10ms").set("spark.rpc.numRetries", "1");
            int opId = 0;
            String dir = StateStoreTestsHelper$.MODULE$.newDir();
            StateStoreProviderId storeProviderId = new StateStoreProviderId(new StateStoreId(dir, (long)opId, 0, StateStoreId$.MODULE$.apply$default$4()), UUID.randomUUID());
            SQLConf sqlConf = new SQLConf();
            sqlConf.setConf(SQLConf$.MODULE$.MIN_BATCHES_TO_RETAIN(), (Object)BoxesRunTime.boxToInteger((int)2));
            StateStoreConf storeConf = StateStoreConf$.MODULE$.apply(sqlConf);
            Configuration hadoopConf = new Configuration();
            HDFSBackedStateStoreProvider provider = this.newStoreProvider(storeProviderId.storeId());
            IntRef latestStoreVersion = IntRef.create((int)0);
            Span timeoutDuration = SpanSugar$.MODULE$.convertIntToGrainOfTime(60).seconds();
            return (Assertion)package$.MODULE$.quietly((Function0 & Serializable & scala.Serializable)() -> {
                LocalSparkContext$.MODULE$.withSpark(new SparkContext(conf), (Function1 & Serializable & scala.Serializable)sc -> {
                    StateStoreCoordinatorSuite$.MODULE$.withCoordinatorRef(sc, (Function1<StateStoreCoordinatorRef, BoxedUnit>)(Function1 & Serializable & scala.Serializable)coordinatorRef -> {
                        StateStoreSuite.$anonfun$new$31($this, timeoutDuration$1, storeProviderId$1, latestStoreVersion$1, provider$4, storeConf$2, hadoopConf$2, coordinatorRef);
                        return BoxedUnit.UNIT;
                    });
                    return BoxedUnit.UNIT;
                });
                return (Assertion)Eventually$.MODULE$.eventually(Eventually$.MODULE$.timeout(timeoutDuration), (Function0 & Serializable & scala.Serializable)() -> {
                    Predef$.MODULE$.require(this.convertToEqualizer(SparkEnv$.MODULE$.get()).$eq$eq$eq(null));
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isLoaded(storeProviderId), "StateStore.isLoaded(storeProviderId)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                    this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 341));
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(StateStore$.MODULE$.isMaintenanceRunning(), "StateStore.isMaintenanceRunning", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 342));
                }, Eventually$.MODULE$.patienceConfig(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 339));
            });
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 249));
        this.test("SPARK-18342: commit fails when rename fails", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String dir = new StringBuilder(3).append(RenameReturnsFalseFileSystem$.MODULE$.scheme()).append("://").append(StateStoreTestsHelper$.MODULE$.newDir()).toString();
            Configuration conf = new Configuration();
            conf.set(new StringBuilder(8).append("fs.").append(RenameReturnsFalseFileSystem$.MODULE$.scheme()).append(".impl").toString(), RenameReturnsFalseFileSystem.class.getName());
            long x$21 = Random$.MODULE$.nextInt();
            int x$22 = 0;
            String x$23 = dir;
            Configuration x$24 = conf;
            int x$25 = this.newStoreProvider$default$4();
            HDFSBackedStateStoreProvider provider = this.newStoreProvider(x$21, x$22, x$23, x$25, x$24);
            StateStore store = provider.getStore(0L);
            StateStoreTestsHelper$.MODULE$.put(store, "a", 0);
            IllegalStateException e = (IllegalStateException)this.intercept((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> store.commit(), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 356));
            String $org_scalatest_assert_macro_left = e.getCause().getMessage();
            String $org_scalatest_assert_macro_right = "Failed to rename";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 357));
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 347));
        this.test("SPARK-18416: do not create temp delta file until the store is updated", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String dir = StateStoreTestsHelper$.MODULE$.newDir();
            StateStoreProviderId storeId = new StateStoreProviderId(new StateStoreId(dir, 0L, 0, StateStoreId$.MODULE$.apply$default$4()), UUID.randomUUID());
            StateStoreConf storeConf = StateStoreConf$.MODULE$.empty();
            Configuration hadoopConf = new Configuration();
            File deltaFileDir = new File(new StringBuilder(5).append(dir).append("/0/0/").toString());
            StateStore store0 = (StateStore)this.shouldNotCreateTempFile$1((Function0 & Serializable & scala.Serializable)() -> StateStore$.MODULE$.get(storeId, this.keySchema(), this.valueSchema(), (Option)None$.MODULE$, 0L, storeConf, hadoopConf), deltaFileDir);
            StateStoreTestsHelper$.MODULE$.put(store0, "a", 1);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numTempFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 394));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numDeltaFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 395));
            store0.commit();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numTempFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right3 = 0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 399));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numDeltaFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 400));
            StateStore store1 = (StateStore)this.shouldNotCreateTempFile$1((Function0 & Serializable & scala.Serializable)() -> StateStore$.MODULE$.get(storeId, this.keySchema(), this.valueSchema(), (Option)None$.MODULE$, 1L, storeConf, hadoopConf), deltaFileDir);
            StateStoreTestsHelper$.MODULE$.remove(store1, (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)StateStoreSuite.$anonfun$new$48(x$4)));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numTempFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right5 = 1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 408));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numDeltaFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right6 = 1;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 409));
            store1.commit();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numTempFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right7 = 0;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 413));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numDeltaFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right8 = 2;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 414));
            StateStore store2 = (StateStore)this.shouldNotCreateTempFile$1((Function0 & Serializable & scala.Serializable)() -> StateStore$.MODULE$.get(storeId, this.keySchema(), this.valueSchema(), (Option)None$.MODULE$, 2L, storeConf, hadoopConf), deltaFileDir);
            store2.commit();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numTempFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right9 = 0;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 422));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)StateStoreSuite.numDeltaFiles$1(deltaFileDir)));
            int $org_scalatest_assert_macro_right10 = 3;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 423));
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 360));
        this.test("SPARK-21145: Restarted queries create new provider instances", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            try {
                File checkpointLocation = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).getAbsoluteFile();
                SparkSession spark2 = SparkSession$.MODULE$.builder().master("local[2]").getOrCreate();
                SparkSession$.MODULE$.setActiveSession(spark2);
                SQLContext sqlContext = spark2.sqlContext();
                spark2.conf().set("spark.sql.shuffle.partitions", "1");
                MemoryStream inputData = MemoryStream$.MODULE$.apply(spark2.implicits().newIntEncoder(), sqlContext);
                Seq loadedProvidersAfterRun1 = this.runQueryAndGetLoadedProviders$1(inputData, checkpointLocation);
                Predef$.MODULE$.require(this.convertToEqualizer(BoxesRunTime.boxToInteger((int)loadedProvidersAfterRun1.length())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1), Equality$.MODULE$.default()));
                Seq loadedProvidersAfterRun2 = this.runQueryAndGetLoadedProviders$1(inputData, checkpointLocation);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)loadedProvidersAfterRun2.length()));
                int $org_scalatest_assert_macro_right = 2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 460));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(((StateStoreProvider)loadedProvidersAfterRun2.apply(0)).stateStoreId());
                StateStoreId $org_scalatest_assert_macro_right2 = ((StateStoreProvider)loadedProvidersAfterRun2.apply(1)).stateStoreId();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 463));
                StateStoreProvider $org_scalatest_assert_macro_left3 = (StateStoreProvider)loadedProvidersAfterRun2.apply(0);
                StateStoreProvider $org_scalatest_assert_macro_right3 = (StateStoreProvider)loadedProvidersAfterRun2.apply(1);
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "ne", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3 != $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
                assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 464));
            }
            finally {
                SparkSession$.MODULE$.getActiveSession().foreach((Function1 & Serializable & scala.Serializable)spark -> {
                    StateStoreSuite.$anonfun$new$51(spark);
                    return BoxedUnit.UNIT;
                });
            }
            return assertion;
        }, new Position("StateStoreSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 426));
    }
}

