/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.rdd.RDD;
import org.apache.spark.scheduler.ExecutorCacheTaskLocation;
import org.apache.spark.sql.LocalSparkSession$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.streaming.StatefulOperatorStateInfo;
import org.apache.spark.sql.execution.streaming.state.StateStore;
import org.apache.spark.sql.execution.streaming.state.StateStore$;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorRef;
import org.apache.spark.sql.execution.streaming.state.StateStoreId;
import org.apache.spark.sql.execution.streaming.state.StateStoreId$;
import org.apache.spark.sql.execution.streaming.state.StateStoreProviderId;
import org.apache.spark.sql.execution.streaming.state.StateStoreRDD;
import org.apache.spark.sql.execution.streaming.state.StateStoreTestsHelper$;
import org.apache.spark.sql.execution.streaming.state.UnsafeRowPair;
import org.apache.spark.sql.execution.streaming.state.package$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.CompletionIterator$;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rd\u0001B\t\u0013\u0001\u0005BQa\f\u0001\u0005\u0002ABqa\r\u0001C\u0002\u0013%A\u0007\u0003\u00049\u0001\u0001\u0006I!\u000e\u0005\bs\u0001\u0011\r\u0011\"\u0003;\u0011\u0019\u0019\u0005\u0001)A\u0005w!9A\t\u0001b\u0001\n\u0013)\u0005B\u0002'\u0001A\u0003%a\tC\u0004N\u0001\t\u0007I\u0011B#\t\r9\u0003\u0001\u0015!\u0003G\u0011\u0015y\u0005\u0001\"\u0011Q\u0011\u00159\u0006\u0001\"\u0003Y\u0011\u0015I\b\u0001\"\u0003{\u0011%\ti\u0002AI\u0001\n\u0013\ty\u0002C\u0005\u00026\u0001\t\n\u0011\"\u0003\u00028!I\u00111\b\u0001C\u0002\u0013%\u0011Q\b\u0005\t\u0003C\u0002\u0001\u0015!\u0003\u0002@\t\u00112\u000b^1uKN#xN]3S\t\u0012\u001bV/\u001b;f\u0015\t\u0019B#A\u0003ti\u0006$XM\u0003\u0002\u0016-\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003/a\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005eQ\u0012aA:rY*\u00111\u0004H\u0001\u0006gB\f'o\u001b\u0006\u0003;y\ta!\u00199bG\",'\"A\u0010\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\u0011c\u0005\f\t\u0003G\u0011j\u0011AG\u0005\u0003Ki\u0011Qb\u00159be.4UO\\*vSR,\u0007CA\u0014+\u001b\u0005A#BA\u0015\u001f\u0003%\u00198-\u00197bi\u0016\u001cH/\u0003\u0002,Q\tq!)\u001a4pe\u0016\fe\u000eZ!gi\u0016\u0014\bCA\u0014.\u0013\tq\u0003FA\tCK\u001a|'/Z!oI\u00063G/\u001a:BY2\fa\u0001P5oSRtD#A\u0019\u0011\u0005I\u0002Q\"\u0001\n\u0002\u0013M\u0004\u0018M]6D_:4W#A\u001b\u0011\u0005\r2\u0014BA\u001c\u001b\u0005%\u0019\u0006/\u0019:l\u0007>tg-\u0001\u0006ta\u0006\u00148nQ8oM\u0002\nq\u0001^3na\u0012K'/F\u0001<!\ta\u0014)D\u0001>\u0015\tqt(\u0001\u0003mC:<'\"\u0001!\u0002\t)\fg/Y\u0005\u0003\u0005v\u0012aa\u0015;sS:<\u0017\u0001\u0003;f[B$\u0015N\u001d\u0011\u0002\u0013-,\u0017pU2iK6\fW#\u0001$\u0011\u0005\u001dSU\"\u0001%\u000b\u0005%C\u0012!\u0002;za\u0016\u001c\u0018BA&I\u0005)\u0019FO];diRK\b/Z\u0001\u000bW\u0016L8k\u00195f[\u0006\u0004\u0013a\u0003<bYV,7k\u00195f[\u0006\fAB^1mk\u0016\u001c6\r[3nC\u0002\n\u0001\"\u00194uKJ\fE\u000e\u001c\u000b\u0002#B\u0011!+V\u0007\u0002'*\tA+A\u0003tG\u0006d\u0017-\u0003\u0002W'\n!QK\\5u\u0003\u001di\u0017m[3S\t\u0012#2!W5o!\rQVlX\u0007\u00027*\u0011ALG\u0001\u0004e\u0012$\u0017B\u00010\\\u0005\r\u0011F\t\u0012\t\u0003A\u001et!!Y3\u0011\u0005\t\u001cV\"A2\u000b\u0005\u0011\u0004\u0013A\u0002\u001fs_>$h(\u0003\u0002g'\u00061\u0001K]3eK\u001aL!A\u00115\u000b\u0005\u0019\u001c\u0006\"\u00026\f\u0001\u0004Y\u0017AA:d!\t\u0019C.\u0003\u0002n5\ta1\u000b]1sW\u000e{g\u000e^3yi\")qn\u0003a\u0001a\u0006\u00191/Z9\u0011\u0007E4xL\u0004\u0002si:\u0011!m]\u0005\u0002)&\u0011QoU\u0001\ba\u0006\u001c7.Y4f\u0013\t9\bPA\u0002TKFT!!^*\u0002#=\u0004XM]1u_J\u001cF/\u0019;f\u0013:4w\u000e\u0006\u0004|\u007f\u0006\r\u00111\u0003\t\u0003yvl\u0011\u0001F\u0005\u0003}R\u0011\u0011d\u0015;bi\u00164W\u000f\\(qKJ\fGo\u001c:Ti\u0006$X-\u00138g_\"1\u0011\u0011\u0001\u0007A\u0002}\u000bA\u0001]1uQ\"I\u0011Q\u0001\u0007\u0011\u0002\u0003\u0007\u0011qA\u0001\u000bcV,'/\u001f*v]&#\u0007\u0003BA\u0005\u0003\u001fi!!a\u0003\u000b\u0007\u00055q(\u0001\u0003vi&d\u0017\u0002BA\t\u0003\u0017\u0011A!V+J\t\"I\u0011Q\u0003\u0007\u0011\u0002\u0003\u0007\u0011qC\u0001\bm\u0016\u00148/[8o!\r\u0011\u0016\u0011D\u0005\u0004\u00037\u0019&aA%oi\u0006Yr\u000e]3sCR|'o\u0015;bi\u0016LeNZ8%I\u00164\u0017-\u001e7uII*\"!!\t+\t\u0005\u001d\u00111E\u0016\u0003\u0003K\u0001B!a\n\u000225\u0011\u0011\u0011\u0006\u0006\u0005\u0003W\ti#A\u0005v]\u000eDWmY6fI*\u0019\u0011qF*\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00024\u0005%\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006Yr\u000e]3sCR|'o\u0015;bi\u0016LeNZ8%I\u00164\u0017-\u001e7uIM*\"!!\u000f+\t\u0005]\u00111E\u0001\nS:\u001c'/Z7f]R,\"!a\u0010\u0011\u0013I\u000b\t%!\u0012\u0002L\u0005E\u0013bAA\"'\nIa)\u001e8di&|gN\r\t\u0004e\u0005\u001d\u0013bAA%%\tQ1\u000b^1uKN#xN]3\u0011\tE\fieX\u0005\u0004\u0003\u001fB(\u0001C%uKJ\fGo\u001c:\u0011\r\u0005M\u0013\u0011LA.\u001b\t\t)FC\u0002\u0002XM\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\ty%!\u0016\u0011\rI\u000bifXA\f\u0013\r\tyf\u0015\u0002\u0007)V\u0004H.\u001a\u001a\u0002\u0015%t7M]3nK:$\b\u0005")
public class StateStoreRDDSuite
extends SparkFunSuite
implements BeforeAndAfter {
    private final SparkConf sparkConf;
    private final String tempDir;
    private final StructType keySchema;
    private final StructType valueSchema;
    private final Function2<StateStore, Iterator<String>, Iterator<Tuple2<String, Object>>> increment;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    private SparkConf sparkConf() {
        return this.sparkConf;
    }

    private String tempDir() {
        return this.tempDir;
    }

    private StructType keySchema() {
        return this.keySchema;
    }

    private StructType valueSchema() {
        return this.valueSchema;
    }

    public void afterAll() {
        super.afterAll();
        Utils$.MODULE$.deleteRecursively(new File(this.tempDir()));
    }

    private RDD<String> makeRDD(SparkContext sc, Seq<String> seq) {
        return sc.makeRDD(seq, 2, ClassTag$.MODULE$.apply(String.class)).groupBy((Function1 & Serializable & scala.Serializable)x -> x, ClassTag$.MODULE$.apply(String.class)).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> (Iterable)x$1._2(), ClassTag$.MODULE$.apply(String.class));
    }

    private StatefulOperatorStateInfo operatorStateInfo(String path, UUID queryRunId, int version) {
        return new StatefulOperatorStateInfo(path, queryRunId, 0L, (long)version, 5);
    }

    private UUID operatorStateInfo$default$2() {
        return UUID.randomUUID();
    }

    private int operatorStateInfo$default$3() {
        return 0;
    }

    private Function2<StateStore, Iterator<String>, Iterator<Tuple2<String, Object>>> increment() {
        return this.increment;
    }

    private final RDD makeStoreRDD$1(SparkSession spark, Seq seq, int storeVersion, String path$1) {
        SQLContext sqlContext = spark.sqlContext();
        String x$1 = path$1;
        int x$2 = storeVersion;
        UUID x$3 = this.operatorStateInfo$default$2();
        return package$.MODULE$.StateStoreOps(this.makeRDD(spark.sparkContext(), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})))), ClassTag$.MODULE$.apply(String.class)).mapPartitionsWithStateStore(sqlContext, this.operatorStateInfo(x$1, x$3, x$2), this.keySchema(), this.valueSchema(), (Option)None$.MODULE$, this.increment(), ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public static final /* synthetic */ void $anonfun$new$5(StateStoreRDDSuite $this, String path$1, SparkSession spark) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> Predef$.MODULE$.require($this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.makeStoreRDD$1(spark, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), i - 1, path$1).collect())).toSet()).$eq$eq$eq((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)i))})), Equality$.MODULE$.default())));
    }

    private static final Iterator iteratorOfPuts$1(StateStore store, Iterator iter) {
        Iterator resIterator = iter.map((Function1 & Serializable & scala.Serializable)s -> {
            UnsafeRow key = StateStoreTestsHelper$.MODULE$.stringToRow((String)s);
            int oldValue = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)store.get(key)).map((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToInteger((int)StateStoreTestsHelper$.MODULE$.rowToInt(row))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
            int newValue = oldValue + 1;
            store.put(key, StateStoreTestsHelper$.MODULE$.intToRow(newValue));
            return new Tuple2(s, (Object)BoxesRunTime.boxToInteger((int)newValue));
        });
        return CompletionIterator$.MODULE$.apply(resIterator, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> store.commit());
    }

    private static final Iterator iteratorOfGets$1(StateStore store, Iterator iter) {
        return iter.map((Function1 & Serializable & scala.Serializable)s -> {
            UnsafeRow key = StateStoreTestsHelper$.MODULE$.stringToRow((String)s);
            Option value = Option$.MODULE$.apply((Object)store.get(key)).map((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToInteger((int)StateStoreTestsHelper$.MODULE$.rowToInt(row)));
            return new Tuple2(s, (Object)value);
        });
    }

    public static final /* synthetic */ void $anonfun$increment$2(StateStore store$3, String s) {
        UnsafeRow key = StateStoreTestsHelper$.MODULE$.stringToRow(s);
        int oldValue = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)store$3.get(key)).map((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToInteger((int)StateStoreTestsHelper$.MODULE$.rowToInt(row))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        store$3.put(key, StateStoreTestsHelper$.MODULE$.intToRow(oldValue + 1));
    }

    public StateStoreRDDSuite() {
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        this.sparkConf = new SparkConf().setMaster("local").setAppName(this.getClass().getSimpleName());
        this.tempDir = ((Object)Files.createTempDirectory("StateStoreRDDSuite", new FileAttribute[0])).toString();
        this.keySchema = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("key", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4())})));
        this.valueSchema = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("value", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4())})));
        this.after((Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> StateStore$.MODULE$.stop(), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
        this.test("versioning and immutability", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (Assertion)LocalSparkSession$.MODULE$.withSparkSession(SparkSession$.MODULE$.builder().config(this.sparkConf()).getOrCreate(), (Function1 & Serializable & scala.Serializable)spark -> {
            String path = Utils$.MODULE$.createDirectory(this.tempDir(), ((Object)BoxesRunTime.boxToFloat((float)Random$.MODULE$.nextFloat())).toString()).toString();
            String x$1 = path;
            int x$2 = 0;
            UUID x$3 = this.operatorStateInfo$default$2();
            StateStoreRDD rdd1 = package$.MODULE$.StateStoreOps(this.makeRDD(spark.sparkContext(), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "a"})))), ClassTag$.MODULE$.apply(String.class)).mapPartitionsWithStateStore(spark.sqlContext(), this.operatorStateInfo(x$1, x$3, x$2), this.keySchema(), this.valueSchema(), (Option)None$.MODULE$, this.increment(), ClassTag$.MODULE$.apply(Tuple2.class));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd1.collect())).toSet());
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)BoxesRunTime.boxToInteger((int)1))}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
            String x$4 = path;
            int x$5 = 1;
            UUID x$6 = this.operatorStateInfo$default$2();
            StateStoreRDD rdd2 = package$.MODULE$.StateStoreOps(this.makeRDD(spark.sparkContext(), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "c"})))), ClassTag$.MODULE$.apply(String.class)).mapPartitionsWithStateStore(spark.sqlContext(), this.operatorStateInfo(x$4, x$6, x$5), this.keySchema(), this.valueSchema(), (Option)None$.MODULE$, this.increment(), ClassTag$.MODULE$.apply(Tuple2.class));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd2.collect())).toSet());
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)BoxesRunTime.boxToInteger((int)1))}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd1.collect())).toSet());
            Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)BoxesRunTime.boxToInteger((int)1))}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        }), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
        this.test("recovering from files", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String path = Utils$.MODULE$.createDirectory(this.tempDir(), ((Object)BoxesRunTime.boxToFloat((float)Random$.MODULE$.nextFloat())).toString()).toString();
            LocalSparkSession$.MODULE$.withSparkSession(SparkSession$.MODULE$.builder().config(this.sparkConf()).getOrCreate(), (Function1 & Serializable & scala.Serializable)spark -> {
                StateStoreRDDSuite.$anonfun$new$5(this, path, spark);
                return BoxedUnit.UNIT;
            });
            return (Assertion)LocalSparkSession$.MODULE$.withSparkSession(SparkSession$.MODULE$.builder().config(this.sparkConf()).getOrCreate(), (Function1 & Serializable & scala.Serializable)spark -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.makeStoreRDD$1((SparkSession)spark, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), 20, path).collect())).toSet());
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)21))}));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
            });
        }, new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        this.test("usage with iterators - only gets and only puts", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (Assertion)LocalSparkSession$.MODULE$.withSparkSession(SparkSession$.MODULE$.builder().config(this.sparkConf()).getOrCreate(), (Function1 & Serializable & scala.Serializable)spark -> {
            SQLContext sqlContext = spark.sqlContext();
            String path = Utils$.MODULE$.createDirectory(this.tempDir(), ((Object)BoxesRunTime.boxToFloat((float)Random$.MODULE$.nextFloat())).toString()).toString();
            boolean opId = false;
            String x$7 = path;
            int x$8 = 0;
            UUID x$9 = this.operatorStateInfo$default$2();
            StateStoreRDD rddOfGets1 = package$.MODULE$.StateStoreOps(this.makeRDD(spark.sparkContext(), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"})))), ClassTag$.MODULE$.apply(String.class)).mapPartitionsWithStateStore(spark.sqlContext(), this.operatorStateInfo(x$7, x$9, x$8), this.keySchema(), this.valueSchema(), (Option)None$.MODULE$, (Function2 & Serializable & scala.Serializable)(store, iter) -> StateStoreRDDSuite.iteratorOfGets$1(store, iter), ClassTag$.MODULE$.apply(Tuple2.class));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rddOfGets1.collect())).toSet());
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)None$.MODULE$)}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
            String x$10 = path;
            int x$11 = 0;
            UUID x$12 = this.operatorStateInfo$default$2();
            StateStoreRDD rddOfPuts = package$.MODULE$.StateStoreOps(this.makeRDD(spark.sparkContext(), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "a"})))), ClassTag$.MODULE$.apply(String.class)).mapPartitionsWithStateStore(sqlContext, this.operatorStateInfo(x$10, x$12, x$11), this.keySchema(), this.valueSchema(), (Option)None$.MODULE$, (Function2 & Serializable & scala.Serializable)(store, iter) -> StateStoreRDDSuite.iteratorOfPuts$1(store, iter), ClassTag$.MODULE$.apply(Tuple2.class));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rddOfPuts.collect())).toSet());
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)BoxesRunTime.boxToInteger((int)1))}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
            String x$13 = path;
            int x$14 = 1;
            UUID x$15 = this.operatorStateInfo$default$2();
            StateStoreRDD rddOfGets2 = package$.MODULE$.StateStoreOps(this.makeRDD(spark.sparkContext(), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"})))), ClassTag$.MODULE$.apply(String.class)).mapPartitionsWithStateStore(sqlContext, this.operatorStateInfo(x$13, x$15, x$14), this.keySchema(), this.valueSchema(), (Option)None$.MODULE$, (Function2 & Serializable & scala.Serializable)(store, iter) -> StateStoreRDDSuite.iteratorOfGets$1(store, iter), ClassTag$.MODULE$.apply(Tuple2.class));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rddOfGets2.collect())).toSet());
            Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)2))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)1))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)None$.MODULE$)}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
        }), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
        this.test("preferred locations using StateStoreCoordinator", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (Tuple2[])org.apache.spark.sql.catalyst.util.package$.MODULE$.quietly((Function0 & Serializable & scala.Serializable)() -> {
            UUID queryRunId = UUID.randomUUID();
            int opId = 0;
            String path = Utils$.MODULE$.createDirectory(this.tempDir(), ((Object)BoxesRunTime.boxToFloat((float)Random$.MODULE$.nextFloat())).toString()).toString();
            return (Tuple2[])LocalSparkSession$.MODULE$.withSparkSession(SparkSession$.MODULE$.builder().config(this.sparkConf()).getOrCreate(), (Function1 & Serializable & scala.Serializable)spark -> {
                SQLContext sqlContext = spark.sqlContext();
                StateStoreCoordinatorRef coordinatorRef = sqlContext.streams().stateStoreCoordinator();
                StateStoreProviderId storeProviderId1 = new StateStoreProviderId(new StateStoreId(path, (long)opId, 0, StateStoreId$.MODULE$.apply$default$4()), queryRunId);
                StateStoreProviderId storeProviderId2 = new StateStoreProviderId(new StateStoreId(path, (long)opId, 1, StateStoreId$.MODULE$.apply$default$4()), queryRunId);
                coordinatorRef.reportActiveInstance(storeProviderId1, "host1", "exec1");
                coordinatorRef.reportActiveInstance(storeProviderId2, "host2", "exec2");
                Predef$.MODULE$.require(this.convertToEqualizer(coordinatorRef.getLocation(storeProviderId1)).$eq$eq$eq((Object)new Some((Object)new ExecutorCacheTaskLocation("host1", "exec1").toString()), Equality$.MODULE$.default()));
                StateStoreRDD rdd = package$.MODULE$.StateStoreOps(this.makeRDD(spark.sparkContext(), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "a"})))), ClassTag$.MODULE$.apply(String.class)).mapPartitionsWithStateStore(sqlContext, this.operatorStateInfo(path, queryRunId, this.operatorStateInfo$default$3()), this.keySchema(), this.valueSchema(), (Option)None$.MODULE$, this.increment(), ClassTag$.MODULE$.apply(Tuple2.class));
                Predef$.MODULE$.require(this.convertToEqualizer(BoxesRunTime.boxToInteger((int)rdd.partitions().length)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2), Equality$.MODULE$.default()));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(rdd.preferredLocations(rdd.partitions()[0]));
                Seq $org_scalatest_assert_macro_right = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new ExecutorCacheTaskLocation("host1", "exec1").toString()}));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(rdd.preferredLocations(rdd.partitions()[1]));
                Seq $org_scalatest_assert_macro_right2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new ExecutorCacheTaskLocation("host2", "exec2").toString()}));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
                return (Tuple2[])rdd.collect();
            });
        }), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
        this.ignore("distributed test", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (Assertion)org.apache.spark.sql.catalyst.util.package$.MODULE$.quietly((Function0 & Serializable & scala.Serializable)() -> (Assertion)LocalSparkSession$.MODULE$.withSparkSession(SparkSession$.MODULE$.builder().config(this.sparkConf().setMaster("local-cluster[2, 1, 1024]")).getOrCreate(), (Function1 & Serializable & scala.Serializable)spark -> {
            SQLContext sqlContext = spark.sqlContext();
            String path = Utils$.MODULE$.createDirectory(this.tempDir(), ((Object)BoxesRunTime.boxToFloat((float)Random$.MODULE$.nextFloat())).toString()).toString();
            boolean opId = false;
            String x$16 = path;
            int x$17 = 0;
            UUID x$18 = this.operatorStateInfo$default$2();
            StateStoreRDD rdd1 = package$.MODULE$.StateStoreOps(this.makeRDD(spark.sparkContext(), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "a"})))), ClassTag$.MODULE$.apply(String.class)).mapPartitionsWithStateStore(sqlContext, this.operatorStateInfo(x$16, x$18, x$17), this.keySchema(), this.valueSchema(), (Option)None$.MODULE$, this.increment(), ClassTag$.MODULE$.apply(Tuple2.class));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd1.collect())).toSet());
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)BoxesRunTime.boxToInteger((int)1))}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 197));
            String x$19 = path;
            int x$20 = 1;
            UUID x$21 = this.operatorStateInfo$default$2();
            StateStoreRDD rdd2 = package$.MODULE$.StateStoreOps(this.makeRDD(spark.sparkContext(), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "c"})))), ClassTag$.MODULE$.apply(String.class)).mapPartitionsWithStateStore(sqlContext, this.operatorStateInfo(x$19, x$21, x$20), this.keySchema(), this.valueSchema(), (Option)None$.MODULE$, this.increment(), ClassTag$.MODULE$.apply(Tuple2.class));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd2.collect())).toSet());
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)BoxesRunTime.boxToInteger((int)1))}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd1.collect())).toSet());
            Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)BoxesRunTime.boxToInteger((int)1))}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 205));
        })), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 185));
        this.increment = (Function2 & Serializable & scala.Serializable)(store, iter) -> {
            iter.foreach((Function1 & Serializable & scala.Serializable)s -> {
                StateStoreRDDSuite.$anonfun$increment$2(store, s);
                return BoxedUnit.UNIT;
            });
            store.commit();
            return store.iterator().map((Function1 & Serializable & scala.Serializable)row -> StateStoreTestsHelper$.MODULE$.rowsToStringInt((UnsafeRowPair)row));
        };
    }
}

