/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.fs.FileSystem;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.streaming.CompactibleFileStreamLog$;
import org.apache.spark.sql.execution.streaming.FileStreamSinkLog;
import org.apache.spark.sql.execution.streaming.FileStreamSinkLog$;
import org.apache.spark.sql.execution.streaming.SinkFileStatus;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.test.SQLTestData;
import org.apache.spark.sql.test.SQLTestData$internalImplicits$;
import org.apache.spark.sql.test.SQLTestUtils;
import org.apache.spark.sql.test.SQLTestUtilsBase;
import org.apache.spark.sql.test.SQLTestUtilsBase$testImplicits$;
import org.apache.spark.sql.test.SharedSQLContext;
import org.apache.spark.sql.test.SharedSparkSession;
import org.apache.spark.sql.test.TestSparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Tag;
import org.scalatest.concurrent.AbstractPatienceConfiguration;
import org.scalatest.concurrent.AbstractPatienceConfiguration$PatienceConfig$;
import org.scalatest.concurrent.Eventually;
import org.scalatest.concurrent.PatienceConfiguration;
import org.scalatest.concurrent.ScaledTimeSpans;
import org.scalatest.time.Span;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001M3A!\u0002\u0004\u0001'!)a\u0004\u0001C\u0001?!)!\u0005\u0001C\u0005G!)\u0001\b\u0001C\u0005s!)a\t\u0001C\u0005\u000f\n1b)\u001b7f'R\u0014X-Y7TS:\\Gj\\4Tk&$XM\u0003\u0002\b\u0011\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u0013)\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005-a\u0011aA:rY*\u0011QBD\u0001\u0006gB\f'o\u001b\u0006\u0003\u001fA\ta!\u00199bG\",'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001!\u0002\u0004\u0005\u0002\u0016-5\tA\"\u0003\u0002\u0018\u0019\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"!\u0007\u000f\u000e\u0003iQ!a\u0007\u0006\u0002\tQ,7\u000f^\u0005\u0003;i\u0011\u0001c\u00155be\u0016$7+\u0015'D_:$X\r\u001f;\u0002\rqJg.\u001b;?)\u0005\u0001\u0003CA\u0011\u0001\u001b\u00051\u0011!\u00068fo\u001a\u000b7.Z*j].4\u0015\u000e\\3Ti\u0006$Xo\u001d\u000b\u0004I\u001d2\u0004CA\u0011&\u0013\t1cA\u0001\bTS:\\g)\u001b7f'R\fG/^:\t\u000b!\u0012\u0001\u0019A\u0015\u0002\tA\fG\u000f\u001b\t\u0003UMr!aK\u0019\u0011\u00051zS\"A\u0017\u000b\u00059\u0012\u0012A\u0002\u001fs_>$hHC\u00011\u0003\u0015\u00198-\u00197b\u0013\t\u0011t&\u0001\u0004Qe\u0016$WMZ\u0005\u0003iU\u0012aa\u0015;sS:<'B\u0001\u001a0\u0011\u00159$\u00011\u0001*\u0003\u0019\t7\r^5p]\u0006)r/\u001b;i\r&dWm\u0015;sK\u0006l7+\u001b8l\u0019><GC\u0001\u001e?!\tYD(D\u00010\u0013\titF\u0001\u0003V]&$\b\"B \u0004\u0001\u0004\u0001\u0015!\u00014\u0011\tm\n5IO\u0005\u0003\u0005>\u0012\u0011BR;oGRLwN\\\u0019\u0011\u0005\u0005\"\u0015BA#\u0007\u0005E1\u0015\u000e\\3TiJ,\u0017-\\*j].dunZ\u0001\u0011e\u0016\fGM\u0012:p[J+7o\\;sG\u0016$\"\u0001S)\u0011\u0007%sEE\u0004\u0002K\u0019:\u0011AfS\u0005\u0002a%\u0011QjL\u0001\ba\u0006\u001c7.Y4f\u0013\ty\u0005KA\u0002TKFT!!T\u0018\t\u000bI#\u0001\u0019A\u0015\u0002\u0007\u0011L'\u000f")
public class FileStreamSinkLogSuite
extends SparkFunSuite
implements SharedSQLContext {
    private final boolean enableAutoThreadAudit;
    private TestSparkSession org$apache$spark$sql$test$SharedSparkSession$$_spark;
    private boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    private Function1<String, Dataset<Row>> sql;
    private volatile SQLTestUtilsBase$testImplicits$ testImplicits$module;
    private volatile SQLTestData$internalImplicits$ internalImplicits$module;
    private Dataset<Row> emptyTestData;
    private Dataset<Row> testData;
    private Dataset<Row> testData2;
    private Dataset<Row> testData3;
    private Dataset<Row> negativeData;
    private Dataset<Row> largeAndSmallInts;
    private Dataset<Row> decimalData;
    private Dataset<Row> binaryData;
    private Dataset<Row> upperCaseData;
    private Dataset<Row> lowerCaseData;
    private Dataset<Row> lowerCaseDataWithDuplicates;
    private RDD<SQLTestData.ArrayData> arrayData;
    private RDD<SQLTestData.MapData> mapData;
    private RDD<SQLTestData.StringData> repeatedData;
    private RDD<SQLTestData.StringData> nullableRepeatedData;
    private Dataset<Row> nullInts;
    private Dataset<Row> allNulls;
    private Dataset<Row> nullStrings;
    private Dataset<Row> tableName;
    private RDD<String> unparsedStrings;
    private RDD<SQLTestData.IntField> withEmptyParts;
    private Dataset<Row> person;
    private Dataset<Row> salary;
    private Dataset<Row> complexData;
    private Dataset<Row> courseSales;
    private Dataset<Row> trainingSales;
    private final AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    private volatile AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig$module;
    private volatile int bitmap$0;

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSQLContext$$super$beforeAll() {
        SharedSparkSession.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSQLContext$$super$afterAll() {
        SharedSparkSession.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        SharedSQLContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        SharedSQLContext.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$beforeAll() {
        SQLTestUtils.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    @Override
    public SparkConf sparkConf() {
        return SharedSparkSession.sparkConf$(this);
    }

    @Override
    public SparkSession spark() {
        return SharedSparkSession.spark$(this);
    }

    @Override
    public SQLContext sqlContext() {
        return SharedSparkSession.sqlContext$(this);
    }

    @Override
    public TestSparkSession createSparkSession() {
        return SharedSparkSession.createSparkSession$(this);
    }

    @Override
    public void initializeSession() {
        SharedSparkSession.initializeSession$(this);
    }

    @Override
    public void beforeEach() {
        SharedSparkSession.beforeEach$(this);
    }

    @Override
    public void afterEach() {
        SharedSparkSession.afterEach$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public void setupTestData() {
        SQLTestUtils.setupTestData$(this);
    }

    @Override
    public void testQuietly(String name, Function0<BoxedUnit> f) {
        SQLTestUtils.testQuietly$(this, name, f);
    }

    @Override
    public void testWithUninterruptibleThread(String name, boolean quietly, Function0<BoxedUnit> body) {
        SQLTestUtils.testWithUninterruptibleThread$(this, name, quietly, body);
    }

    @Override
    public boolean testWithUninterruptibleThread$default$2() {
        return SQLTestUtils.testWithUninterruptibleThread$default$2$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtilsBase$$super$withSQLConf(Seq pairs, Function0 f) {
        PlanTestBase.withSQLConf$((PlanTestBase)this, (Seq)pairs, (Function0)f);
    }

    @Override
    public SparkContext sparkContext() {
        return SQLTestUtilsBase.sparkContext$(this);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLTestUtilsBase.withTempPath$(this, f);
    }

    @Override
    public void withResourceTempPath(String resourcePath, Function1<File, BoxedUnit> f) {
        SQLTestUtilsBase.withResourceTempPath$(this, resourcePath, f);
    }

    @Override
    public void waitForTasksToFinish() {
        SQLTestUtilsBase.waitForTasksToFinish$(this);
    }

    @Override
    public void withTempDir(Function1<File, BoxedUnit> f) {
        SQLTestUtilsBase.withTempDir$(this, f);
    }

    @Override
    public void withTempPaths(int numPaths, Function1<Seq<File>, BoxedUnit> f) {
        SQLTestUtilsBase.withTempPaths$(this, numPaths, f);
    }

    @Override
    public void withUserDefinedFunction(Seq<Tuple2<String, Object>> functions2, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withUserDefinedFunction$(this, functions2, f);
    }

    @Override
    public void withTempView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withTempView$(this, viewNames, f);
    }

    @Override
    public void withGlobalTempView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withGlobalTempView$(this, viewNames, f);
    }

    @Override
    public void withTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withTable$(this, tableNames, f);
    }

    @Override
    public void withView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withView$(this, viewNames, f);
    }

    @Override
    public void withTempDatabase(Function1<String, BoxedUnit> f) {
        SQLTestUtilsBase.withTempDatabase$(this, f);
    }

    @Override
    public void withDatabase(Seq<String> dbNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withDatabase$(this, dbNames, f);
    }

    @Override
    public void withLocale(String language, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withLocale$(this, language, f);
    }

    @Override
    public void activateDatabase(String db, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.activateDatabase$(this, db, f);
    }

    @Override
    public Dataset<Row> stripSparkFilter(Dataset<Row> df) {
        return SQLTestUtilsBase.stripSparkFilter$(this, df);
    }

    @Override
    public Dataset<Row> logicalPlanToSparkQuery(LogicalPlan plan) {
        return SQLTestUtilsBase.logicalPlanToSparkQuery$(this, plan);
    }

    @Override
    public URI makeQualifiedPath(String path) {
        return SQLTestUtilsBase.makeQualifiedPath$(this, path);
    }

    @Override
    public String testFile(String fileName) {
        return SQLTestUtilsBase.testFile$(this, fileName);
    }

    public SQLConf conf() {
        return PlanTestBase.conf$((PlanTestBase)this);
    }

    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$((PlanTestBase)this, (LogicalPlan)plan);
    }

    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$((PlanTestBase)this, (LogicalPlan)plan);
    }

    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$((PlanTestBase)this, (LogicalPlan)plan1, (LogicalPlan)plan2, (boolean)checkAnalysis);
    }

    public boolean comparePlans$default$3() {
        return PlanTestBase.comparePlans$default$3$((PlanTestBase)this);
    }

    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$((PlanTestBase)this, (Expression)e1, (Expression)e2);
    }

    public void compareJoinOrder(LogicalPlan plan1, LogicalPlan plan2) {
        PlanTestBase.compareJoinOrder$((PlanTestBase)this, (LogicalPlan)plan1, (LogicalPlan)plan2);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression replaceAlias(Expression condition, AttributeMap<Expression> aliases) {
        return PredicateHelper.replaceAlias$((PredicateHelper)this, (Expression)condition, aliases);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    @Override
    public void loadTestData() {
        SQLTestData.loadTestData$(this);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, PatienceConfiguration.Interval interval, Function0<T> fun, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, (PatienceConfiguration.Interval)interval, fun, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, fun, (AbstractPatienceConfiguration.PatienceConfig)config, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Interval interval, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Interval)interval, fun, (AbstractPatienceConfiguration.PatienceConfig)config, (Position)pos);
    }

    public <T> T eventually(Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, fun, (AbstractPatienceConfiguration.PatienceConfig)config, (Position)pos);
    }

    public AbstractPatienceConfiguration.PatienceConfig patienceConfig() {
        return PatienceConfiguration.patienceConfig$((PatienceConfiguration)this);
    }

    public PatienceConfiguration.Timeout timeout(Span value) {
        return PatienceConfiguration.timeout$((PatienceConfiguration)this, (Span)value);
    }

    public PatienceConfiguration.Interval interval(Span value) {
        return PatienceConfiguration.interval$((PatienceConfiguration)this, (Span)value);
    }

    public final Span scaled(Span span) {
        return ScaledTimeSpans.scaled$((ScaledTimeSpans)this, (Span)span);
    }

    public double spanScaleFactor() {
        return ScaledTimeSpans.spanScaleFactor$((ScaledTimeSpans)this);
    }

    @Override
    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSQLContext$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    @Override
    public TestSparkSession org$apache$spark$sql$test$SharedSparkSession$$_spark() {
        return this.org$apache$spark$sql$test$SharedSparkSession$$_spark;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSparkSession$$_spark_$eq(TestSparkSession x$1) {
        this.org$apache$spark$sql$test$SharedSparkSession$$_spark = x$1;
    }

    @Override
    public boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests() {
        return this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    }

    @Override
    public void org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests_$eq(boolean x$1) {
        this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests = x$1;
    }

    private Function1<String, Dataset<Row>> sql$lzycompute() {
        FileStreamSinkLogSuite fileStreamSinkLogSuite = this;
        synchronized (fileStreamSinkLogSuite) {
            if ((this.bitmap$0 & 1) == 0) {
                this.sql = SQLTestUtilsBase.sql$(this);
                this.bitmap$0 |= 1;
            }
        }
        return this.sql;
    }

    @Override
    public Function1<String, Dataset<Row>> sql() {
        return (this.bitmap$0 & 1) == 0 ? this.sql$lzycompute() : this.sql;
    }

    @Override
    public SQLTestUtilsBase$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public SQLTestData$internalImplicits$ org$apache$spark$sql$test$SQLTestData$$internalImplicits() {
        if (this.internalImplicits$module == null) {
            this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute$1();
        }
        return this.internalImplicits$module;
    }

    private Dataset<Row> emptyTestData$lzycompute() {
        FileStreamSinkLogSuite fileStreamSinkLogSuite = this;
        synchronized (fileStreamSinkLogSuite) {
            if ((this.bitmap$0 & 2) == 0) {
                this.emptyTestData = SQLTestData.emptyTestData$(this);
                this.bitmap$0 |= 2;
            }
        }
        return this.emptyTestData;
    }

    @Override
    public Dataset<Row> emptyTestData() {
        return (this.bitmap$0 & 2) == 0 ? this.emptyTestData$lzycompute() : this.emptyTestData;
    }

    private Dataset<Row> testData$lzycompute() {
        FileStreamSinkLogSuite fileStreamSinkLogSuite = this;
        synchronized (fileStreamSinkLogSuite) {
            if ((this.bitmap$0 & 4) == 0) {
                this.testData = SQLTestData.testData$(this);
                this.bitmap$0 |= 4;
            }
        }
        return this.testData;
    }

    @Override
    public Dataset<Row> testData() {
        return (this.bitmap$0 & 4) == 0 ? this.testData$lzycompute() : this.testData;
    }

    private Dataset<Row> testData2$lzycompute() {
        FileStreamSinkLogSuite fileStreamSinkLogSuite = this;
        synchronized (fileStreamSinkLogSuite) {
            if ((this.bitmap$0 & 8) == 0) {
                this.testData2 = SQLTestData.testData2$(this);
                this.bitmap$0 |= 8;
            }
        }
        return this.testData2;
    }

    @Override
    public Dataset<Row> testData2() {
        return (this.bitmap$0 & 8) == 0 ? this.testData2$lzycompute() : this.testData2;
    }

    private Dataset<Row> testData3$lzycompute() {
        FileStreamSinkLogSuite fileStreamSinkLogSuite = this;
        synchronized (fileStreamSinkLogSuite) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.testData3 = SQLTestData.testData3$(this);
                this.bitmap$0 |= 0x10;
            }
        }
        return this.testData3;
    }

    @Override
    public Dataset<Row> testData3() {
        return (this.bitmap$0 & 0x10) == 0 ? this.testData3$lzycompute() : this.testData3;
    }

    private Dataset<Row> negativeData$lzycompute() {
        FileStreamSinkLogSuite fileStreamSinkLogSuite = this;
        synchronized (fileStreamSinkLogSuite) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.negativeData = SQLTestData.negativeData$(this);
                this.bitmap$0 |= 0x20;
            }
        }
        return this.negativeData;
    }

    @Override
    public Dataset<Row> negativeData() {
        return (this.bitmap$0 & 0x20) == 0 ? this.negativeData$lzycompute() : this.negativeData;
    }

    private Dataset<Row> largeAndSmallInts$lzycompute() {
        FileStreamSinkLogSuite fileStreamSinkLogSuite = this;
        synchronized (fileStreamSinkLogSuite) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.largeAndSmallInts = SQLTestData.largeAndSmallInts$(this);
                this.bitmap$0 |= 0x40;
            }
        }
        return this.largeAndSmallInts;
    }

    @Override
    public Dataset<Row> largeAndSmallInts() {
        return (this.bitmap$0 & 0x40) == 0 ? this.largeAndSmallInts$lzycompute() : this.largeAndSmallInts;
    }

    private Dataset<Row> decimalData$lzycompute() {
        FileStreamSinkLogSuite fileStreamSinkLogSuite = this;
        synchronized (fileStreamSinkLogSuite) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.decimalData = SQLTestData.decimalData$(this);
                this.bitmap$0 |= 0x80;
            }
        }
        return this.decimalData;
    }

    @Override
    public Dataset<Row> decimalData() {
        return (this.bitmap$0 & 0x80) == 0 ? this.decimalData$lzycompute() : this.decimalData;
    }

    private Dataset<Row> binaryData$lzycompute() {
        FileStreamSinkLogSuite fileStreamSinkLogSuite = this;
        synchronized (fileStreamSinkLogSuite) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.binaryData = SQLTestData.binaryData$(this);
                this.bitmap$0 |= 0x100;
            }
        }
        return this.binaryData;
    }

    @Override
    public Dataset<Row> binaryData() {
        return (this.bitmap$0 & 0x100) == 0 ? this.binaryData$lzycompute() : this.binaryData;
    }

    private Dataset<Row> upperCaseData$lzycompute() {
        FileStreamSinkLogSuite fileStreamSinkLogSuite = this;
        synchronized (fileStreamSinkLogSuite) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.upperCaseData = SQLTestData.upperCaseData$(this);
                this.bitmap$0 |= 0x200;
            }
        }
        return this.upperCaseData;
    }

    @Override
    public Dataset<Row> upperCaseData() {
        return (this.bitmap$0 & 0x200) == 0 ? this.upperCaseData$lzycompute() : this.upperCaseData;
    }

    private Dataset<Row> lowerCaseData$lzycompute() {
        FileStreamSinkLogSuite fileStreamSinkLogSuite = this;
        synchronized (fileStreamSinkLogSuite) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.lowerCaseData = SQLTestData.lowerCaseData$(this);
                this.bitmap$0 |= 0x400;
            }
        }
        return this.lowerCaseData;
    }

    @Override
    public Dataset<Row> lowerCaseData() {
        return (this.bitmap$0 & 0x400) == 0 ? this.lowerCaseData$lzycompute() : this.lowerCaseData;
    }

    private Dataset<Row> lowerCaseDataWithDuplicates$lzycompute() {
        FileStreamSinkLogSuite fileStreamSinkLogSuite = this;
        synchronized (fileStreamSinkLogSuite) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.lowerCaseDataWithDuplicates = SQLTestData.lowerCaseDataWithDuplicates$(this);
                this.bitmap$0 |= 0x800;
            }
        }
        return this.lowerCaseDataWithDuplicates;
    }

    @Override
    public Dataset<Row> lowerCaseDataWithDuplicates() {
        return (this.bitmap$0 & 0x800) == 0 ? this.lowerCaseDataWithDuplicates$lzycompute() : this.lowerCaseDataWithDuplicates;
    }

    private RDD<SQLTestData.ArrayData> arrayData$lzycompute() {
        FileStreamSinkLogSuite fileStreamSinkLogSuite = this;
        synchronized (fileStreamSinkLogSuite) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.arrayData = SQLTestData.arrayData$(this);
                this.bitmap$0 |= 0x1000;
            }
        }
        return this.arrayData;
    }

    @Override
    public RDD<SQLTestData.ArrayData> arrayData() {
        return (this.bitmap$0 & 0x1000) == 0 ? this.arrayData$lzycompute() : this.arrayData;
    }

    private RDD<SQLTestData.MapData> mapData$lzycompute() {
        FileStreamSinkLogSuite fileStreamSinkLogSuite = this;
        synchronized (fileStreamSinkLogSuite) {
            if ((this.bitmap$0 & 0x2000) == 0) {
                this.mapData = SQLTestData.mapData$(this);
                this.bitmap$0 |= 0x2000;
            }
        }
        return this.mapData;
    }

    @Override
    public RDD<SQLTestData.MapData> mapData() {
        return (this.bitmap$0 & 0x2000) == 0 ? this.mapData$lzycompute() : this.mapData;
    }

    private RDD<SQLTestData.StringData> repeatedData$lzycompute() {
        FileStreamSinkLogSuite fileStreamSinkLogSuite = this;
        synchronized (fileStreamSinkLogSuite) {
            if ((this.bitmap$0 & 0x4000) == 0) {
                this.repeatedData = SQLTestData.repeatedData$(this);
                this.bitmap$0 |= 0x4000;
            }
        }
        return this.repeatedData;
    }

    @Override
    public RDD<SQLTestData.StringData> repeatedData() {
        return (this.bitmap$0 & 0x4000) == 0 ? this.repeatedData$lzycompute() : this.repeatedData;
    }

    private RDD<SQLTestData.StringData> nullableRepeatedData$lzycompute() {
        FileStreamSinkLogSuite fileStreamSinkLogSuite = this;
        synchronized (fileStreamSinkLogSuite) {
            if ((this.bitmap$0 & 0x8000) == 0) {
                this.nullableRepeatedData = SQLTestData.nullableRepeatedData$(this);
                this.bitmap$0 |= 0x8000;
            }
        }
        return this.nullableRepeatedData;
    }

    @Override
    public RDD<SQLTestData.StringData> nullableRepeatedData() {
        return (this.bitmap$0 & 0x8000) == 0 ? this.nullableRepeatedData$lzycompute() : this.nullableRepeatedData;
    }

    private Dataset<Row> nullInts$lzycompute() {
        FileStreamSinkLogSuite fileStreamSinkLogSuite = this;
        synchronized (fileStreamSinkLogSuite) {
            if ((this.bitmap$0 & 0x10000) == 0) {
                this.nullInts = SQLTestData.nullInts$(this);
                this.bitmap$0 |= 0x10000;
            }
        }
        return this.nullInts;
    }

    @Override
    public Dataset<Row> nullInts() {
        return (this.bitmap$0 & 0x10000) == 0 ? this.nullInts$lzycompute() : this.nullInts;
    }

    private Dataset<Row> allNulls$lzycompute() {
        FileStreamSinkLogSuite fileStreamSinkLogSuite = this;
        synchronized (fileStreamSinkLogSuite) {
            if ((this.bitmap$0 & 0x20000) == 0) {
                this.allNulls = SQLTestData.allNulls$(this);
                this.bitmap$0 |= 0x20000;
            }
        }
        return this.allNulls;
    }

    @Override
    public Dataset<Row> allNulls() {
        return (this.bitmap$0 & 0x20000) == 0 ? this.allNulls$lzycompute() : this.allNulls;
    }

    private Dataset<Row> nullStrings$lzycompute() {
        FileStreamSinkLogSuite fileStreamSinkLogSuite = this;
        synchronized (fileStreamSinkLogSuite) {
            if ((this.bitmap$0 & 0x40000) == 0) {
                this.nullStrings = SQLTestData.nullStrings$(this);
                this.bitmap$0 |= 0x40000;
            }
        }
        return this.nullStrings;
    }

    @Override
    public Dataset<Row> nullStrings() {
        return (this.bitmap$0 & 0x40000) == 0 ? this.nullStrings$lzycompute() : this.nullStrings;
    }

    private Dataset<Row> tableName$lzycompute() {
        FileStreamSinkLogSuite fileStreamSinkLogSuite = this;
        synchronized (fileStreamSinkLogSuite) {
            if ((this.bitmap$0 & 0x80000) == 0) {
                this.tableName = SQLTestData.tableName$(this);
                this.bitmap$0 |= 0x80000;
            }
        }
        return this.tableName;
    }

    @Override
    public Dataset<Row> tableName() {
        return (this.bitmap$0 & 0x80000) == 0 ? this.tableName$lzycompute() : this.tableName;
    }

    private RDD<String> unparsedStrings$lzycompute() {
        FileStreamSinkLogSuite fileStreamSinkLogSuite = this;
        synchronized (fileStreamSinkLogSuite) {
            if ((this.bitmap$0 & 0x100000) == 0) {
                this.unparsedStrings = SQLTestData.unparsedStrings$(this);
                this.bitmap$0 |= 0x100000;
            }
        }
        return this.unparsedStrings;
    }

    @Override
    public RDD<String> unparsedStrings() {
        return (this.bitmap$0 & 0x100000) == 0 ? this.unparsedStrings$lzycompute() : this.unparsedStrings;
    }

    private RDD<SQLTestData.IntField> withEmptyParts$lzycompute() {
        FileStreamSinkLogSuite fileStreamSinkLogSuite = this;
        synchronized (fileStreamSinkLogSuite) {
            if ((this.bitmap$0 & 0x200000) == 0) {
                this.withEmptyParts = SQLTestData.withEmptyParts$(this);
                this.bitmap$0 |= 0x200000;
            }
        }
        return this.withEmptyParts;
    }

    @Override
    public RDD<SQLTestData.IntField> withEmptyParts() {
        return (this.bitmap$0 & 0x200000) == 0 ? this.withEmptyParts$lzycompute() : this.withEmptyParts;
    }

    private Dataset<Row> person$lzycompute() {
        FileStreamSinkLogSuite fileStreamSinkLogSuite = this;
        synchronized (fileStreamSinkLogSuite) {
            if ((this.bitmap$0 & 0x400000) == 0) {
                this.person = SQLTestData.person$(this);
                this.bitmap$0 |= 0x400000;
            }
        }
        return this.person;
    }

    @Override
    public Dataset<Row> person() {
        return (this.bitmap$0 & 0x400000) == 0 ? this.person$lzycompute() : this.person;
    }

    private Dataset<Row> salary$lzycompute() {
        FileStreamSinkLogSuite fileStreamSinkLogSuite = this;
        synchronized (fileStreamSinkLogSuite) {
            if ((this.bitmap$0 & 0x800000) == 0) {
                this.salary = SQLTestData.salary$(this);
                this.bitmap$0 |= 0x800000;
            }
        }
        return this.salary;
    }

    @Override
    public Dataset<Row> salary() {
        return (this.bitmap$0 & 0x800000) == 0 ? this.salary$lzycompute() : this.salary;
    }

    private Dataset<Row> complexData$lzycompute() {
        FileStreamSinkLogSuite fileStreamSinkLogSuite = this;
        synchronized (fileStreamSinkLogSuite) {
            if ((this.bitmap$0 & 0x1000000) == 0) {
                this.complexData = SQLTestData.complexData$(this);
                this.bitmap$0 |= 0x1000000;
            }
        }
        return this.complexData;
    }

    @Override
    public Dataset<Row> complexData() {
        return (this.bitmap$0 & 0x1000000) == 0 ? this.complexData$lzycompute() : this.complexData;
    }

    private Dataset<Row> courseSales$lzycompute() {
        FileStreamSinkLogSuite fileStreamSinkLogSuite = this;
        synchronized (fileStreamSinkLogSuite) {
            if ((this.bitmap$0 & 0x2000000) == 0) {
                this.courseSales = SQLTestData.courseSales$(this);
                this.bitmap$0 |= 0x2000000;
            }
        }
        return this.courseSales;
    }

    @Override
    public Dataset<Row> courseSales() {
        return (this.bitmap$0 & 0x2000000) == 0 ? this.courseSales$lzycompute() : this.courseSales;
    }

    private Dataset<Row> trainingSales$lzycompute() {
        FileStreamSinkLogSuite fileStreamSinkLogSuite = this;
        synchronized (fileStreamSinkLogSuite) {
            if ((this.bitmap$0 & 0x4000000) == 0) {
                this.trainingSales = SQLTestData.trainingSales$(this);
                this.bitmap$0 |= 0x4000000;
            }
        }
        return this.trainingSales;
    }

    @Override
    public Dataset<Row> trainingSales() {
        return (this.bitmap$0 & 0x4000000) == 0 ? this.trainingSales$lzycompute() : this.trainingSales;
    }

    public AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig() {
        return this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    }

    public final void org$scalatest$concurrent$PatienceConfiguration$_setter_$org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig_$eq(AbstractPatienceConfiguration.PatienceConfig x$1) {
        this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig = x$1;
    }

    public AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig() {
        if (this.PatienceConfig$module == null) {
            this.PatienceConfig$lzycompute$1();
        }
        return this.PatienceConfig$module;
    }

    private SinkFileStatus newFakeSinkFileStatus(String path, String action) {
        return new SinkFileStatus(path, 100L, false, 100L, 1, 100L, action);
    }

    private void withFileStreamSinkLog(Function1<FileStreamSinkLog, BoxedUnit> f) {
        this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)file -> {
            FileStreamSinkLogSuite.$anonfun$withFileStreamSinkLog$1(this, f, file);
            return BoxedUnit.UNIT;
        });
    }

    private Seq<SinkFileStatus> readFromResource(String dir) {
        URL input = this.getClass().getResource(new StringBuilder(22).append("/structured-streaming/").append(dir).toString());
        FileStreamSinkLog log = new FileStreamSinkLog(FileStreamSinkLog$.MODULE$.VERSION(), this.spark(), input.toString());
        return Predef$.MODULE$.wrapRefArray(log.allFiles());
    }

    private final void testImplicits$lzycompute$1() {
        FileStreamSinkLogSuite fileStreamSinkLogSuite = this;
        synchronized (fileStreamSinkLogSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new SQLTestUtilsBase$testImplicits$(this);
            }
        }
    }

    private final void org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute$1() {
        FileStreamSinkLogSuite fileStreamSinkLogSuite = this;
        synchronized (fileStreamSinkLogSuite) {
            if (this.internalImplicits$module == null) {
                this.internalImplicits$module = new SQLTestData$internalImplicits$(this);
            }
        }
    }

    private final void PatienceConfig$lzycompute$1() {
        FileStreamSinkLogSuite fileStreamSinkLogSuite = this;
        synchronized (fileStreamSinkLogSuite) {
            if (this.PatienceConfig$module == null) {
                this.PatienceConfig$module = new AbstractPatienceConfiguration$PatienceConfig$((AbstractPatienceConfiguration)this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$new$2(FileStreamSinkLogSuite $this, FileStreamSinkLog sinkLog) {
        Seq logs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SinkFileStatus[]{$this.newFakeSinkFileStatus("/a/b/x", FileStreamSinkLog$.MODULE$.ADD_ACTION()), $this.newFakeSinkFileStatus("/a/b/y", FileStreamSinkLog$.MODULE$.ADD_ACTION()), $this.newFakeSinkFileStatus("/a/b/z", FileStreamSinkLog$.MODULE$.ADD_ACTION())}));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(logs);
        Seq $org_scalatest_assert_macro_right = sinkLog.compactLogs(logs);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSinkLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
        Seq logs2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SinkFileStatus[]{$this.newFakeSinkFileStatus("/a/b/m", FileStreamSinkLog$.MODULE$.ADD_ACTION()), $this.newFakeSinkFileStatus("/a/b/n", FileStreamSinkLog$.MODULE$.ADD_ACTION()), $this.newFakeSinkFileStatus("/a/b/z", FileStreamSinkLog$.MODULE$.DELETE_ACTION())}));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(((TraversableLike)logs.dropRight(1)).$plus$plus((GenTraversableOnce)logs2.dropRight(1), Seq$.MODULE$.canBuildFrom()));
        Seq $org_scalatest_assert_macro_right2 = sinkLog.compactLogs((Seq)logs.$plus$plus((GenTraversableOnce)logs2, Seq$.MODULE$.canBuildFrom()));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSinkLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
    }

    public static final /* synthetic */ void $anonfun$new$4(FileStreamSinkLogSuite $this, FileStreamSinkLog sinkLog) {
        SinkFileStatus[] logs = (SinkFileStatus[])((Object[])new SinkFileStatus[]{new SinkFileStatus("/a/b/x", 100L, false, 1000L, 1, 10000L, FileStreamSinkLog$.MODULE$.ADD_ACTION()), new SinkFileStatus("/a/b/y", 200L, false, 2000L, 2, 20000L, FileStreamSinkLog$.MODULE$.DELETE_ACTION()), new SinkFileStatus("/a/b/z", 300L, false, 3000L, 3, 30000L, FileStreamSinkLog$.MODULE$.ADD_ACTION())});
        String expected = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(400).append("v").append(FileStreamSinkLog$.MODULE$.VERSION()).append("\n          |{\"path\":\"/a/b/x\",\"size\":100,\"isDir\":false,\"modificationTime\":1000,\"blockReplication\":1,\"blockSize\":10000,\"action\":\"add\"}\n          |{\"path\":\"/a/b/y\",\"size\":200,\"isDir\":false,\"modificationTime\":2000,\"blockReplication\":2,\"blockSize\":20000,\"action\":\"delete\"}\n          |{\"path\":\"/a/b/z\",\"size\":300,\"isDir\":false,\"modificationTime\":3000,\"blockReplication\":3,\"blockSize\":30000,\"action\":\"add\"}").toString())).stripMargin();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        sinkLog.serialize((Object[])logs, (OutputStream)baos);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(expected);
        String $org_scalatest_assert_macro_right = baos.toString(StandardCharsets.UTF_8.name());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSinkLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
        baos.reset();
        sinkLog.serialize((Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(SinkFileStatus.class)), (OutputStream)baos);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(new StringBuilder(1).append("v").append(FileStreamSinkLog$.MODULE$.VERSION()).toString());
        String $org_scalatest_assert_macro_right2 = baos.toString(StandardCharsets.UTF_8.name());
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSinkLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
    }

    public static final /* synthetic */ void $anonfun$new$6(FileStreamSinkLogSuite $this, FileStreamSinkLog sinkLog) {
        String logs = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(400).append("v").append(FileStreamSinkLog$.MODULE$.VERSION()).append("\n          |{\"path\":\"/a/b/x\",\"size\":100,\"isDir\":false,\"modificationTime\":1000,\"blockReplication\":1,\"blockSize\":10000,\"action\":\"add\"}\n          |{\"path\":\"/a/b/y\",\"size\":200,\"isDir\":false,\"modificationTime\":2000,\"blockReplication\":2,\"blockSize\":20000,\"action\":\"delete\"}\n          |{\"path\":\"/a/b/z\",\"size\":300,\"isDir\":false,\"modificationTime\":3000,\"blockReplication\":3,\"blockSize\":30000,\"action\":\"add\"}").toString())).stripMargin();
        Seq expected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SinkFileStatus[]{new SinkFileStatus("/a/b/x", 100L, false, 1000L, 1, 10000L, FileStreamSinkLog$.MODULE$.ADD_ACTION()), new SinkFileStatus("/a/b/y", 200L, false, 2000L, 2, 20000L, FileStreamSinkLog$.MODULE$.DELETE_ACTION()), new SinkFileStatus("/a/b/z", 300L, false, 3000L, 3, 30000L, FileStreamSinkLog$.MODULE$.ADD_ACTION())}));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(expected);
        SinkFileStatus[] $org_scalatest_assert_macro_right = (SinkFileStatus[])sinkLog.deserialize((InputStream)new ByteArrayInputStream(logs.getBytes(StandardCharsets.UTF_8)));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSinkLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(Nil$.MODULE$);
        SinkFileStatus[] $org_scalatest_assert_macro_right2 = (SinkFileStatus[])sinkLog.deserialize((InputStream)new ByteArrayInputStream(new StringBuilder(1).append("v").append(FileStreamSinkLog$.MODULE$.VERSION()).toString().getBytes(StandardCharsets.UTF_8)));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSinkLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
    }

    public static final /* synthetic */ Object $anonfun$new$10(FileStreamSinkLogSuite $this, FileStreamSinkLog sinkLog$1, int batchId) {
        BoxedUnit boxedUnit;
        sinkLog$1.add((long)batchId, (Object[])new SinkFileStatus[]{$this.newFakeSinkFileStatus(new StringBuilder(5).append("/a/b/").append(batchId).toString(), FileStreamSinkLog$.MODULE$.ADD_ACTION())});
        IndexedSeq expectedFiles = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), batchId).map((Function1 & Serializable & scala.Serializable)id -> $this.newFakeSinkFileStatus(new StringBuilder(5).append("/a/b/").append(BoxesRunTime.unboxToInt((Object)id)).toString(), FileStreamSinkLog$.MODULE$.ADD_ACTION()), IndexedSeq$.MODULE$.canBuildFrom());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(sinkLog$1.allFiles());
        IndexedSeq $org_scalatest_assert_macro_right = expectedFiles;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSinkLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
        if (CompactibleFileStreamLog$.MODULE$.isCompactionBatch((long)batchId, 3)) {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(sinkLog$1.get((long)batchId).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$));
            IndexedSeq $org_scalatest_assert_macro_right2 = expectedFiles;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            boxedUnit = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSinkLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$new$9(FileStreamSinkLogSuite $this, FileStreamSinkLog sinkLog) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable & scala.Serializable)batchId -> FileStreamSinkLogSuite.$anonfun$new$10($this, sinkLog, BoxesRunTime.unboxToInt((Object)batchId)));
    }

    public static final /* synthetic */ boolean $anonfun$new$17(String fileName) {
        boolean bl;
        try {
            CompactibleFileStreamLog$.MODULE$.getBatchIdFromFileName(fileName);
            bl = true;
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    private static final Set listBatchFiles$1(FileSystem fs$1, FileStreamSinkLog sinkLog$2) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fs$1.listStatus(sinkLog$2.metadataPath()))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getPath().getName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).filter((Function1 & Serializable & scala.Serializable)fileName -> BoxesRunTime.boxToBoolean((boolean)FileStreamSinkLogSuite.$anonfun$new$17(fileName))))).toSet();
    }

    public static final /* synthetic */ void $anonfun$new$15(FileStreamSinkLogSuite $this, FileStreamSinkLog sinkLog) {
        FileSystem fs = sinkLog.metadataPath().getFileSystem($this.spark().sessionState().newHadoopConf());
        sinkLog.add(0L, (Object[])new SinkFileStatus[]{$this.newFakeSinkFileStatus("/a/b/0", FileStreamSinkLog$.MODULE$.ADD_ACTION())});
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0"})));
        Set $org_scalatest_assert_macro_right = FileStreamSinkLogSuite.listBatchFiles$1(fs, sinkLog);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSinkLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
        sinkLog.add(1L, (Object[])new SinkFileStatus[]{$this.newFakeSinkFileStatus("/a/b/1", FileStreamSinkLog$.MODULE$.ADD_ACTION())});
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0", "1"})));
        Set $org_scalatest_assert_macro_right2 = FileStreamSinkLogSuite.listBatchFiles$1(fs, sinkLog);
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSinkLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
        sinkLog.add(2L, (Object[])new SinkFileStatus[]{$this.newFakeSinkFileStatus("/a/b/2", FileStreamSinkLog$.MODULE$.ADD_ACTION())});
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0", "1", "2.compact"})));
        Set $org_scalatest_assert_macro_right3 = FileStreamSinkLogSuite.listBatchFiles$1(fs, sinkLog);
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSinkLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
        sinkLog.add(3L, (Object[])new SinkFileStatus[]{$this.newFakeSinkFileStatus("/a/b/3", FileStreamSinkLog$.MODULE$.ADD_ACTION())});
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2.compact", "3"})));
        Set $org_scalatest_assert_macro_right4 = FileStreamSinkLogSuite.listBatchFiles$1(fs, sinkLog);
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSinkLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
        sinkLog.add(4L, (Object[])new SinkFileStatus[]{$this.newFakeSinkFileStatus("/a/b/4", FileStreamSinkLog$.MODULE$.ADD_ACTION())});
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = $this.convertToEqualizer(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2.compact", "3", "4"})));
        Set $org_scalatest_assert_macro_right5 = FileStreamSinkLogSuite.listBatchFiles$1(fs, sinkLog);
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSinkLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
        sinkLog.add(5L, (Object[])new SinkFileStatus[]{$this.newFakeSinkFileStatus("/a/b/5", FileStreamSinkLog$.MODULE$.ADD_ACTION())});
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = $this.convertToEqualizer(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2.compact", "3", "4", "5.compact"})));
        Set $org_scalatest_assert_macro_right6 = FileStreamSinkLogSuite.listBatchFiles$1(fs, sinkLog);
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSinkLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
        sinkLog.add(6L, (Object[])new SinkFileStatus[]{$this.newFakeSinkFileStatus("/a/b/6", FileStreamSinkLog$.MODULE$.ADD_ACTION())});
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = $this.convertToEqualizer(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"5.compact", "6"})));
        Set $org_scalatest_assert_macro_right7 = FileStreamSinkLogSuite.listBatchFiles$1(fs, sinkLog);
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSinkLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
    }

    public static final /* synthetic */ boolean $anonfun$new$21(String fileName) {
        boolean bl;
        try {
            CompactibleFileStreamLog$.MODULE$.getBatchIdFromFileName(fileName);
            bl = true;
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    private static final Set listBatchFiles$2(FileSystem fs$2, FileStreamSinkLog sinkLog$3) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fs$2.listStatus(sinkLog$3.metadataPath()))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getPath().getName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).filter((Function1 & Serializable & scala.Serializable)fileName -> BoxesRunTime.boxToBoolean((boolean)FileStreamSinkLogSuite.$anonfun$new$21(fileName))))).toSet();
    }

    public static final /* synthetic */ void $anonfun$new$19(FileStreamSinkLogSuite $this, FileStreamSinkLog sinkLog) {
        FileSystem fs = sinkLog.metadataPath().getFileSystem($this.spark().sessionState().newHadoopConf());
        sinkLog.add(0L, (Object[])new SinkFileStatus[]{$this.newFakeSinkFileStatus("/a/b/0", FileStreamSinkLog$.MODULE$.ADD_ACTION())});
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0"})));
        Set $org_scalatest_assert_macro_right = FileStreamSinkLogSuite.listBatchFiles$2(fs, sinkLog);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSinkLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
        sinkLog.add(1L, (Object[])new SinkFileStatus[]{$this.newFakeSinkFileStatus("/a/b/1", FileStreamSinkLog$.MODULE$.ADD_ACTION())});
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0", "1"})));
        Set $org_scalatest_assert_macro_right2 = FileStreamSinkLogSuite.listBatchFiles$2(fs, sinkLog);
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSinkLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 211));
        sinkLog.add(2L, (Object[])new SinkFileStatus[]{$this.newFakeSinkFileStatus("/a/b/2", FileStreamSinkLog$.MODULE$.ADD_ACTION())});
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0", "1", "2.compact"})));
        Set $org_scalatest_assert_macro_right3 = FileStreamSinkLogSuite.listBatchFiles$2(fs, sinkLog);
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSinkLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 213));
        sinkLog.add(3L, (Object[])new SinkFileStatus[]{$this.newFakeSinkFileStatus("/a/b/3", FileStreamSinkLog$.MODULE$.ADD_ACTION())});
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0", "1", "2.compact", "3"})));
        Set $org_scalatest_assert_macro_right4 = FileStreamSinkLogSuite.listBatchFiles$2(fs, sinkLog);
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSinkLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 215));
        sinkLog.add(4L, (Object[])new SinkFileStatus[]{$this.newFakeSinkFileStatus("/a/b/4", FileStreamSinkLog$.MODULE$.ADD_ACTION())});
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = $this.convertToEqualizer(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2.compact", "3", "4"})));
        Set $org_scalatest_assert_macro_right5 = FileStreamSinkLogSuite.listBatchFiles$2(fs, sinkLog);
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSinkLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
        sinkLog.add(5L, (Object[])new SinkFileStatus[]{$this.newFakeSinkFileStatus("/a/b/5", FileStreamSinkLog$.MODULE$.ADD_ACTION())});
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = $this.convertToEqualizer(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2.compact", "3", "4", "5.compact"})));
        Set $org_scalatest_assert_macro_right6 = FileStreamSinkLogSuite.listBatchFiles$2(fs, sinkLog);
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSinkLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219));
        sinkLog.add(6L, (Object[])new SinkFileStatus[]{$this.newFakeSinkFileStatus("/a/b/6", FileStreamSinkLog$.MODULE$.ADD_ACTION())});
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = $this.convertToEqualizer(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2.compact", "3", "4", "5.compact", "6"})));
        Set $org_scalatest_assert_macro_right7 = FileStreamSinkLogSuite.listBatchFiles$2(fs, sinkLog);
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSinkLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221));
        sinkLog.add(7L, (Object[])new SinkFileStatus[]{$this.newFakeSinkFileStatus("/a/b/7", FileStreamSinkLog$.MODULE$.ADD_ACTION())});
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = $this.convertToEqualizer(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"5.compact", "6", "7"})));
        Set $org_scalatest_assert_macro_right8 = FileStreamSinkLogSuite.listBatchFiles$2(fs, sinkLog);
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSinkLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 223));
    }

    public static final /* synthetic */ void $anonfun$withFileStreamSinkLog$1(FileStreamSinkLogSuite $this, Function1 f$1, File file) {
        FileStreamSinkLog sinkLog = new FileStreamSinkLog(FileStreamSinkLog$.MODULE$.VERSION(), $this.spark(), file.getCanonicalPath());
        f$1.apply((Object)sinkLog);
    }

    public FileStreamSinkLogSuite() {
        ScaledTimeSpans.$init$((ScaledTimeSpans)this);
        AbstractPatienceConfiguration.$init$((AbstractPatienceConfiguration)this);
        PatienceConfiguration.$init$((PatienceConfiguration)this);
        Eventually.$init$((Eventually)this);
        SQLTestData.$init$(this);
        PredicateHelper.$init$((PredicateHelper)this);
        PlanTestBase.$init$((PlanTestBase)this);
        SQLTestUtilsBase.$init$(this);
        SQLTestUtils.$init$(this);
        SharedSparkSession.$init$(this);
        SharedSQLContext.$init$(this);
        this.test("compactLogs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withFileStreamSinkLog((Function1<FileStreamSinkLog, BoxedUnit>)(Function1 & Serializable & scala.Serializable)sinkLog -> {
            FileStreamSinkLogSuite.$anonfun$new$2(this, sinkLog);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSinkLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 32));
        this.test("serialize", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withFileStreamSinkLog((Function1<FileStreamSinkLog, BoxedUnit>)(Function1 & Serializable & scala.Serializable)sinkLog -> {
            FileStreamSinkLogSuite.$anonfun$new$4(this, sinkLog);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSinkLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
        this.test("deserialize", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withFileStreamSinkLog((Function1<FileStreamSinkLog, BoxedUnit>)(Function1 & Serializable & scala.Serializable)sinkLog -> {
            FileStreamSinkLogSuite.$anonfun$new$6(this, sinkLog);
            return BoxedUnit.UNIT;
        }), new Position("FileStreamSinkLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
        this.test("compact", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SINK_LOG_COMPACT_INTERVAL().key()), (Object)"3")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withFileStreamSinkLog((Function1<FileStreamSinkLog, BoxedUnit>)(Function1 & Serializable & scala.Serializable)sinkLog -> {
            FileStreamSinkLogSuite.$anonfun$new$9(this, sinkLog);
            return BoxedUnit.UNIT;
        })), new Position("FileStreamSinkLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
        this.test("delete expired file", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SINK_LOG_COMPACT_INTERVAL().key()), (Object)"3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SINK_LOG_CLEANUP_DELAY().key()), (Object)"0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.MIN_BATCHES_TO_RETAIN().key()), (Object)"1")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withFileStreamSinkLog((Function1<FileStreamSinkLog, BoxedUnit>)(Function1 & Serializable & scala.Serializable)sinkLog -> {
                FileStreamSinkLogSuite.$anonfun$new$15(this, sinkLog);
                return BoxedUnit.UNIT;
            }));
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SINK_LOG_COMPACT_INTERVAL().key()), (Object)"3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.FILE_SINK_LOG_CLEANUP_DELAY().key()), (Object)"0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.MIN_BATCHES_TO_RETAIN().key()), (Object)"2")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withFileStreamSinkLog((Function1<FileStreamSinkLog, BoxedUnit>)(Function1 & Serializable & scala.Serializable)sinkLog -> {
                FileStreamSinkLogSuite.$anonfun$new$19(this, sinkLog);
                return BoxedUnit.UNIT;
            }));
        }, new Position("FileStreamSinkLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
        this.test("read Spark 2.1.0 log format", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.readFromResource("file-sink-log-version-2.1.0"));
            Seq $org_scalatest_assert_macro_right = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SinkFileStatus[]{new SinkFileStatus("/a/b/1", 100L, false, 100L, 1, 100L, FileStreamSinkLog$.MODULE$.ADD_ACTION()), new SinkFileStatus("/a/b/2", 200L, false, 200L, 1, 100L, FileStreamSinkLog$.MODULE$.ADD_ACTION()), new SinkFileStatus("/a/b/3", 300L, false, 300L, 1, 100L, FileStreamSinkLog$.MODULE$.ADD_ACTION()), new SinkFileStatus("/a/b/4", 400L, false, 400L, 1, 100L, FileStreamSinkLog$.MODULE$.ADD_ACTION()), new SinkFileStatus("/a/b/5", 500L, false, 500L, 1, 100L, FileStreamSinkLog$.MODULE$.ADD_ACTION()), new SinkFileStatus("/a/b/6", 600L, false, 600L, 1, 100L, FileStreamSinkLog$.MODULE$.ADD_ACTION()), new SinkFileStatus("/a/b/7", 700L, false, 700L, 1, 100L, FileStreamSinkLog$.MODULE$.ADD_ACTION()), new SinkFileStatus("/a/b/8", 800L, false, 800L, 1, 100L, FileStreamSinkLog$.MODULE$.ADD_ACTION()), new SinkFileStatus("/a/b/9", 900L, false, 900L, 3, 200L, FileStreamSinkLog$.MODULE$.ADD_ACTION())}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FileStreamSinkLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229));
        }, new Position("FileStreamSinkLogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 228));
    }
}

