/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.GenSet;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001}2Q\u0001B\u0003\u0002\u0002IAQa\u0006\u0001\u0005\u0002aAQa\u0007\u0001\u0007\u0002qAQA\u000b\u0001\u0005\u0012-\u0012!d\u00115fG.\u0004x.\u001b8u\r&dW-T1oC\u001e,'\u000fV3tiNT!AB\u0004\u0002\u0013M$(/Z1nS:<'B\u0001\u0005\n\u0003%)\u00070Z2vi&|gN\u0003\u0002\u000b\u0017\u0005\u00191/\u001d7\u000b\u00051i\u0011!B:qCJ\\'B\u0001\b\u0010\u0003\u0019\t\u0007/Y2iK*\t\u0001#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001'A\u0011A#F\u0007\u0002\u0017%\u0011ac\u0003\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0002\rqJg.\u001b;?)\u0005I\u0002C\u0001\u000e\u0001\u001b\u0005)\u0011!D2sK\u0006$X-T1oC\u001e,'\u000f\u0006\u0002\u001eAA\u0011!DH\u0005\u0003?\u0015\u0011Qc\u00115fG.\u0004x.\u001b8u\r&dW-T1oC\u001e,'\u000fC\u0003\"\u0005\u0001\u0007!%\u0001\u0003qCRD\u0007CA\u0012)\u001b\u0005!#BA\u0013'\u0003\t17O\u0003\u0002(\u001b\u00051\u0001.\u00193p_BL!!\u000b\u0013\u0003\tA\u000bG\u000f[\u0001\ro&$\b\u000eV3naB\u000bG\u000f\u001b\u000b\u0003YI\u0002\"!\f\u0019\u000e\u00039R\u0011aL\u0001\u0006g\u000e\fG.Y\u0005\u0003c9\u0012A!\u00168ji\")1g\u0001a\u0001i\u0005\ta\r\u0005\u0003.k]b\u0013B\u0001\u001c/\u0005%1UO\\2uS>t\u0017\u0007\u0005\u00029{5\t\u0011H\u0003\u0002;w\u0005\u0011\u0011n\u001c\u0006\u0002y\u0005!!.\u0019<b\u0013\tq\u0014H\u0001\u0003GS2,\u0007")
public abstract class CheckpointFileManagerTests
extends SparkFunSuite {
    public abstract CheckpointFileManager createManager(Path var1);

    public void withTempPath(Function1<File, BoxedUnit> f) {
        File path = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
        path.delete();
        try {
            f.apply((Object)path);
        }
        finally {
            Utils$.MODULE$.deleteRecursively(path);
        }
    }

    public static final /* synthetic */ boolean $anonfun$new$3(FileStatus x$1) {
        String string = x$1.getPath().getName();
        String string2 = "dir";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$8(String n) {
        return n.startsWith(".") && n.endsWith(".crc");
    }

    public static final /* synthetic */ void $anonfun$new$2(CheckpointFileManagerTests $this, File p2) {
        Path basePath = new Path(p2.getAbsolutePath());
        CheckpointFileManager fm = $this.createManager(basePath);
        Path dir = new Path(new StringBuilder(21).append(basePath).append("/dir/subdir/subsubdir").toString());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(fm.exists(dir), "fm.exists(dir)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointFileManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
        fm.mkdirs(dir);
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(fm.exists(dir), "fm.exists(dir)", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointFileManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
        fm.mkdirs(dir);
        PathFilter acceptAllFilter = new PathFilter(null){

            public boolean accept(Path path) {
                return true;
            }
        };
        PathFilter rejectAllFilter = new PathFilter(null){

            public boolean accept(Path path) {
                return false;
            }
        };
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fm.list(basePath, acceptAllFilter))).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CheckpointFileManagerTests.$anonfun$new$3(x$1))), "scala.Predef.refArrayOps[org.apache.hadoop.fs.FileStatus](fm.list(basePath, acceptAllFilter)).exists(((x$1: org.apache.hadoop.fs.FileStatus) => x$1.getPath().getName().==(\"dir\")))", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointFileManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)fm.list(basePath, rejectAllFilter).length));
        int $org_scalatest_assert_macro_right = 0;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointFileManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
        ObjectRef path = ObjectRef.create((Object)new Path(new StringBuilder(5).append(dir).append("/file").toString()));
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(fm.exists((Path)path.elem), "fm.exists(path)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointFileManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
        fm.createAtomic((Path)path.elem, false).cancel();
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(fm.exists((Path)path.elem), "fm.exists(path)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointFileManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        fm.createAtomic((Path)path.elem, false).close();
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(fm.exists((Path)path.elem), "fm.exists(path)", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointFileManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
        package$.MODULE$.quietly((Function0 & Serializable & scala.Serializable)() -> (IOException)$this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> fm.createAtomic((Path)path$1.elem, false).close(), ClassTag$.MODULE$.apply(IOException.class), new Position("CheckpointFileManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66)));
        path.elem = new Path(new StringBuilder(6).append(dir).append("/file2").toString());
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(fm.exists((Path)path.elem), "fm.exists(path)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointFileManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
        fm.createAtomic((Path)path.elem, true).cancel();
        Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(fm.exists((Path)path.elem), "fm.exists(path)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointFileManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
        fm.createAtomic((Path)path.elem, true).close();
        Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(fm.exists((Path)path.elem), "fm.exists(path)", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointFileManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
        fm.createAtomic((Path)path.elem, true).close();
        Seq fileNames = (Seq)((TraversableLike)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new File(((Path)path.elem).getParent().toString()).listFiles())).toSeq().filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)p.isFile()))).map((Function1 & Serializable & scala.Serializable)p -> p.getName(), Seq$.MODULE$.canBuildFrom());
        Seq crcFiles = (Seq)fileNames.filter((Function1 & Serializable & scala.Serializable)n -> BoxesRunTime.boxToBoolean((boolean)CheckpointFileManagerTests.$anonfun$new$8(n)));
        Seq originFileNamesForExistingCrcFiles = (Seq)crcFiles.map((Function1 & Serializable & scala.Serializable)name -> name.substring(1, name.length() - 4), Seq$.MODULE$.canBuildFrom());
        Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(originFileNamesForExistingCrcFiles.toSet().subsetOf((GenSet)fileNames.toSet()), "originFileNamesForExistingCrcFiles.toSet[String].subsetOf(fileNames.toSet[String])", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)new StringBuilder(103).append("Some of origin files for crc files don't exist - crc files: ").append(crcFiles).append(" / ").append("expected origin files: ").append(originFileNamesForExistingCrcFiles).append(" / actual files: ").append(fileNames).toString(), Prettifier$.MODULE$.default(), new Position("CheckpointFileManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
        fm.open((Path)path.elem).close();
        fm.delete((Path)path.elem);
        Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(fm.exists((Path)path.elem), "fm.exists(path)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("CheckpointFileManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
        $this.intercept((Function0 & Serializable & scala.Serializable)() -> fm.open((Path)path$1.elem), ClassTag$.MODULE$.apply(IOException.class), new Position("CheckpointFileManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
        fm.delete((Path)path.elem);
    }

    public CheckpointFileManagerTests() {
        this.test("mkdirs, list, createAtomic, open, delete, exists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)p -> {
            CheckpointFileManagerTests.$anonfun$new$2(this, p);
            return BoxedUnit.UNIT;
        }), new Position("CheckpointFileManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
    }
}

