/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.hadoop.Footer;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.apache.parquet.schema.Type;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.ScalaReflection$;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.parquet.ParquetTest;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter;
import org.apache.spark.sql.execution.datasources.parquet.SparkToParquetSchemaConverter;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.test.SQLTestData;
import org.apache.spark.sql.test.SQLTestData$internalImplicits$;
import org.apache.spark.sql.test.SQLTestUtils;
import org.apache.spark.sql.test.SQLTestUtilsBase;
import org.apache.spark.sql.test.SQLTestUtilsBase$testImplicits$;
import org.apache.spark.sql.test.SharedSQLContext;
import org.apache.spark.sql.test.SharedSparkSession;
import org.apache.spark.sql.test.TestSparkSession;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Tag;
import org.scalatest.concurrent.AbstractPatienceConfiguration;
import org.scalatest.concurrent.AbstractPatienceConfiguration$PatienceConfig$;
import org.scalatest.concurrent.Eventually;
import org.scalatest.concurrent.PatienceConfiguration;
import org.scalatest.concurrent.ScaledTimeSpans;
import org.scalatest.time.Span;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.reflect.api.TypeTags;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dd!\u0002\u0005\n\u0003\u0003A\u0002\"B\u0014\u0001\t\u0003A\u0003\"\u0002\u0016\u0001\t#Y\u0003\"B<\u0001\t#A\bbBA\u0007\u0001\u0011E\u0011q\u0002\u0005\n\u0003w\u0001\u0011\u0013!C\t\u0003{Aq!a\u0015\u0001\t#\t)\u0006C\u0005\u0002f\u0001\t\n\u0011\"\u0005\u0002>\t\t\u0002+\u0019:rk\u0016$8k\u00195f[\u0006$Vm\u001d;\u000b\u0005)Y\u0011a\u00029beF,X\r\u001e\u0006\u0003\u00195\t1\u0002Z1uCN|WO]2fg*\u0011abD\u0001\nKb,7-\u001e;j_:T!\u0001E\t\u0002\u0007M\fHN\u0003\u0002\u0013'\u0005)1\u000f]1sW*\u0011A#F\u0001\u0007CB\f7\r[3\u000b\u0003Y\t1a\u001c:h\u0007\u0001\u0019B\u0001A\r\u001eCA\u0011!dG\u0007\u0002#%\u0011A$\u0005\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005yyR\"A\u0005\n\u0005\u0001J!a\u0003)beF,X\r\u001e+fgR\u0004\"AI\u0013\u000e\u0003\rR!\u0001J\b\u0002\tQ,7\u000f^\u0005\u0003M\r\u0012\u0001c\u00155be\u0016$7+\u0015'D_:$X\r\u001f;\u0002\rqJg.\u001b;?)\u0005I\u0003C\u0001\u0010\u0001\u0003M!Xm\u001d;TG\",W.Y%oM\u0016\u0014XM\\2f+\tac\b\u0006\u0004.E2t7/\u001e\u000b\u0004]Q:\u0005CA\u00183\u001b\u0005\u0001$\"A\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0002$\u0001B+oSRDq!\u000e\u0002\u0002\u0002\u0003\u000fa'\u0001\u0006fm&$WM\\2fIE\u00022a\u000e\u001e=\u001b\u0005A$BA\u001d1\u0003\u001d\u0011XM\u001a7fGRL!a\u000f\u001d\u0003\u0011\rc\u0017m]:UC\u001e\u0004\"!\u0010 \r\u0001\u0011)qH\u0001b\u0001\u0001\n\tA+\u0005\u0002B\tB\u0011qFQ\u0005\u0003\u0007B\u0012qAT8uQ&tw\r\u0005\u00020\u000b&\u0011a\t\r\u0002\b!J|G-^2u\u0011\u001dA%!!AA\u0004%\u000b!\"\u001a<jI\u0016t7-\u001a\u00133!\rQE\f\u0010\b\u0003\u0017fs!\u0001\u0014,\u000f\u00055#fB\u0001(T\u001d\ty%+D\u0001Q\u0015\t\tv#\u0001\u0004=e>|GOP\u0005\u0002c%\u0011\u0011\bM\u0005\u0003+b\nqA];oi&lW-\u0003\u0002X1\u00069\u0001/Y2lC\u001e,'BA+9\u0013\tQ6,\u0001\u0005v]&4XM]:f\u0015\t9\u0006,\u0003\u0002^=\n9A+\u001f9f)\u0006<\u0017BA0a\u0005!!\u0016\u0010]3UC\u001e\u001c(BA19\u0003\r\t\u0007/\u001b\u0005\u0006G\n\u0001\r\u0001Z\u0001\ti\u0016\u001cHOT1nKB\u0011Q-\u001b\b\u0003M\u001e\u0004\"a\u0014\u0019\n\u0005!\u0004\u0014A\u0002)sK\u0012,g-\u0003\u0002kW\n11\u000b\u001e:j]\u001eT!\u0001\u001b\u0019\t\u000b5\u0014\u0001\u0019\u00013\u0002\u00175,7o]1hKRK\b/\u001a\u0005\u0006_\n\u0001\r\u0001]\u0001\u000fE&t\u0017M]=BgN#(/\u001b8h!\ty\u0013/\u0003\u0002sa\t9!i\\8mK\u0006t\u0007\"\u0002;\u0003\u0001\u0004\u0001\u0018\u0001E5oif2\u0014i\u001d+j[\u0016\u001cH/Y7q\u0011\u00151(\u00011\u0001q\u0003a9(/\u001b;f\u0019\u0016<\u0017mY=QCJ\fX/\u001a;G_Jl\u0017\r^\u0001\u0016i\u0016\u001cH\u000fU1scV,G\u000fV8DCR\fG._:u)%q\u0013P_A\u0003\u0003\u0013\tY\u0001C\u0003d\u0007\u0001\u0007A\rC\u0003|\u0007\u0001\u0007A0A\u0005tc2\u001c6\r[3nCB\u0019Q0!\u0001\u000e\u0003yT!a`\b\u0002\u000bQL\b/Z:\n\u0007\u0005\raP\u0001\u0006TiJ,8\r\u001e+za\u0016Da!a\u0002\u0004\u0001\u0004!\u0017!\u00049beF,X\r^*dQ\u0016l\u0017\rC\u0003p\u0007\u0001\u0007\u0001\u000fC\u0003u\u0007\u0001\u0007\u0001/A\u000buKN$8)\u0019;bYf\u001cH\u000fV8QCJ\fX/\u001a;\u0015\u00179\n\t\"a\u0005\u0002\u0016\u0005]\u0011\u0011\u0004\u0005\u0006G\u0012\u0001\r\u0001\u001a\u0005\u0006w\u0012\u0001\r\u0001 \u0005\u0007\u0003\u000f!\u0001\u0019\u00013\t\u000bY$\u0001\u0019\u00019\t\u0013\u0005mA\u0001%AA\u0002\u0005u\u0011aE8viB,H\u000fV5nKN$\u0018-\u001c9UsB,\u0007\u0003BA\u0010\u0003gqA!!\t\u0002.9!\u00111EA\u0015\u001b\t\t)CC\u0002\u0002(=\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0005\u0003W\t)#A\u0004T#2\u001buN\u001c4\n\t\u0005=\u0012\u0011G\u0001\u001b!\u0006\u0014\u0018/^3u\u001fV$\b/\u001e;US6,7\u000f^1naRK\b/\u001a\u0006\u0005\u0003W\t)#\u0003\u0003\u00026\u0005]\"!\u0002,bYV,\u0017bAA\u001da\tYQI\\;nKJ\fG/[8o\u0003}!Xm\u001d;DCR\fG._:u)>\u0004\u0016M]9vKR$C-\u001a4bk2$H%N\u000b\u0003\u0003\u007fQC!!\b\u0002B-\u0012\u00111\t\t\u0005\u0003\u000b\ny%\u0004\u0002\u0002H)!\u0011\u0011JA&\u0003%)hn\u00195fG.,GMC\u0002\u0002NA\n!\"\u00198o_R\fG/[8o\u0013\u0011\t\t&a\u0012\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0006uKN$8k\u00195f[\u0006$rBLA,\u00033\nY&!\u0018\u0002`\u0005\u0005\u00141\r\u0005\u0006G\u001a\u0001\r\u0001\u001a\u0005\u0006w\u001a\u0001\r\u0001 \u0005\u0007\u0003\u000f1\u0001\u0019\u00013\t\u000b=4\u0001\u0019\u00019\t\u000bQ4\u0001\u0019\u00019\t\u000bY4\u0001\u0019\u00019\t\u0013\u0005ma\u0001%AA\u0002\u0005u\u0011\u0001\u0006;fgR\u001c6\r[3nC\u0012\"WMZ1vYR$s\u0007")
public abstract class ParquetSchemaTest
extends SparkFunSuite
implements ParquetTest,
SharedSQLContext {
    private final boolean enableAutoThreadAudit;
    private TestSparkSession org$apache$spark$sql$test$SharedSparkSession$$_spark;
    private boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    private Function1<String, Dataset<Row>> sql;
    private volatile SQLTestUtilsBase$testImplicits$ testImplicits$module;
    private volatile SQLTestData$internalImplicits$ internalImplicits$module;
    private Dataset<Row> emptyTestData;
    private Dataset<Row> testData;
    private Dataset<Row> testData2;
    private Dataset<Row> testData3;
    private Dataset<Row> negativeData;
    private Dataset<Row> largeAndSmallInts;
    private Dataset<Row> decimalData;
    private Dataset<Row> binaryData;
    private Dataset<Row> upperCaseData;
    private Dataset<Row> lowerCaseData;
    private Dataset<Row> lowerCaseDataWithDuplicates;
    private RDD<SQLTestData.ArrayData> arrayData;
    private RDD<SQLTestData.MapData> mapData;
    private RDD<SQLTestData.StringData> repeatedData;
    private RDD<SQLTestData.StringData> nullableRepeatedData;
    private Dataset<Row> nullInts;
    private Dataset<Row> allNulls;
    private Dataset<Row> nullStrings;
    private Dataset<Row> tableName;
    private RDD<String> unparsedStrings;
    private RDD<SQLTestData.IntField> withEmptyParts;
    private Dataset<Row> person;
    private Dataset<Row> salary;
    private Dataset<Row> complexData;
    private Dataset<Row> courseSales;
    private Dataset<Row> trainingSales;
    private final AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    private volatile AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig$module;
    private volatile int bitmap$0;

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSQLContext$$super$beforeAll() {
        SharedSparkSession.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSQLContext$$super$afterAll() {
        SharedSparkSession.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        SharedSQLContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        SharedSQLContext.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$beforeAll() {
        SQLTestUtils.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    @Override
    public SparkConf sparkConf() {
        return SharedSparkSession.sparkConf$(this);
    }

    @Override
    public SparkSession spark() {
        return SharedSparkSession.spark$(this);
    }

    @Override
    public SQLContext sqlContext() {
        return SharedSparkSession.sqlContext$(this);
    }

    @Override
    public TestSparkSession createSparkSession() {
        return SharedSparkSession.createSparkSession$(this);
    }

    @Override
    public void initializeSession() {
        SharedSparkSession.initializeSession$(this);
    }

    @Override
    public void beforeEach() {
        SharedSparkSession.beforeEach$(this);
    }

    @Override
    public void afterEach() {
        SharedSparkSession.afterEach$(this);
    }

    @Override
    public void readParquetFile(String path, boolean testVectorized, Function1<Dataset<Row>, BoxedUnit> f) {
        ParquetTest.readParquetFile$(this, path, testVectorized, f);
    }

    @Override
    public boolean readParquetFile$default$2() {
        return ParquetTest.readParquetFile$default$2$(this);
    }

    @Override
    public <T extends Product> void withParquetFile(Seq<T> data, Function1<String, BoxedUnit> f, ClassTag<T> evidence$1, TypeTags.TypeTag<T> evidence$2) {
        ParquetTest.withParquetFile$(this, data, f, evidence$1, evidence$2);
    }

    @Override
    public <T extends Product> void withParquetDataFrame(Seq<T> data, boolean testVectorized, Function1<Dataset<Row>, BoxedUnit> f, ClassTag<T> evidence$3, TypeTags.TypeTag<T> evidence$4) {
        ParquetTest.withParquetDataFrame$(this, data, testVectorized, f, evidence$3, evidence$4);
    }

    @Override
    public <T extends Product> boolean withParquetDataFrame$default$2() {
        return ParquetTest.withParquetDataFrame$default$2$(this);
    }

    @Override
    public <T extends Product> void withParquetTable(Seq<T> data, String tableName, boolean testVectorized, Function0<BoxedUnit> f, ClassTag<T> evidence$5, TypeTags.TypeTag<T> evidence$6) {
        ParquetTest.withParquetTable$(this, data, tableName, testVectorized, f, evidence$5, evidence$6);
    }

    @Override
    public <T extends Product> boolean withParquetTable$default$3() {
        return ParquetTest.withParquetTable$default$3$(this);
    }

    @Override
    public <T extends Product> void makeParquetFile(Seq<T> data, File path, ClassTag<T> evidence$7, TypeTags.TypeTag<T> evidence$8) {
        ParquetTest.makeParquetFile$((ParquetTest)this, data, path, evidence$7, evidence$8);
    }

    @Override
    public <T extends Product> void makeParquetFile(Dataset<Row> df, File path, ClassTag<T> evidence$9, TypeTags.TypeTag<T> evidence$10) {
        ParquetTest.makeParquetFile$((ParquetTest)this, df, path, evidence$9, evidence$10);
    }

    @Override
    public File makePartitionDir(File basePath, String defaultPartitionName, Seq<Tuple2<String, Object>> partitionCols) {
        return ParquetTest.makePartitionDir$(this, basePath, defaultPartitionName, partitionCols);
    }

    @Override
    public void writeMetadata(StructType schema, Path path, Configuration configuration) {
        ParquetTest.writeMetadata$(this, schema, path, configuration);
    }

    @Override
    public void writeMetadata(MessageType parquetSchema, Path path, Configuration configuration, Map<String, String> extraMetadata) {
        ParquetTest.writeMetadata$(this, parquetSchema, path, configuration, extraMetadata);
    }

    @Override
    public Map<String, String> writeMetadata$default$4() {
        return ParquetTest.writeMetadata$default$4$(this);
    }

    @Override
    public Seq<Footer> readAllFootersWithoutSummaryFiles(Path path, Configuration configuration) {
        return ParquetTest.readAllFootersWithoutSummaryFiles$(this, path, configuration);
    }

    @Override
    public ParquetMetadata readFooter(Path path, Configuration configuration) {
        return ParquetTest.readFooter$(this, path, configuration);
    }

    @Override
    public void testStandardAndLegacyModes(String testName, Function0<BoxedUnit> f) {
        ParquetTest.testStandardAndLegacyModes$(this, testName, f);
    }

    @Override
    public Dataset<Row> readResourceParquetFile(String name) {
        return ParquetTest.readResourceParquetFile$(this, name);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public void setupTestData() {
        SQLTestUtils.setupTestData$(this);
    }

    @Override
    public void testQuietly(String name, Function0<BoxedUnit> f) {
        SQLTestUtils.testQuietly$(this, name, f);
    }

    @Override
    public void testWithUninterruptibleThread(String name, boolean quietly, Function0<BoxedUnit> body) {
        SQLTestUtils.testWithUninterruptibleThread$(this, name, quietly, body);
    }

    @Override
    public boolean testWithUninterruptibleThread$default$2() {
        return SQLTestUtils.testWithUninterruptibleThread$default$2$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtilsBase$$super$withSQLConf(Seq pairs, Function0 f) {
        PlanTestBase.withSQLConf$((PlanTestBase)this, (Seq)pairs, (Function0)f);
    }

    @Override
    public SparkContext sparkContext() {
        return SQLTestUtilsBase.sparkContext$(this);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLTestUtilsBase.withTempPath$(this, f);
    }

    @Override
    public void withResourceTempPath(String resourcePath, Function1<File, BoxedUnit> f) {
        SQLTestUtilsBase.withResourceTempPath$(this, resourcePath, f);
    }

    @Override
    public void waitForTasksToFinish() {
        SQLTestUtilsBase.waitForTasksToFinish$(this);
    }

    @Override
    public void withTempDir(Function1<File, BoxedUnit> f) {
        SQLTestUtilsBase.withTempDir$(this, f);
    }

    @Override
    public void withTempPaths(int numPaths, Function1<Seq<File>, BoxedUnit> f) {
        SQLTestUtilsBase.withTempPaths$(this, numPaths, f);
    }

    @Override
    public void withUserDefinedFunction(Seq<Tuple2<String, Object>> functions2, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withUserDefinedFunction$(this, functions2, f);
    }

    @Override
    public void withTempView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withTempView$(this, viewNames, f);
    }

    @Override
    public void withGlobalTempView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withGlobalTempView$(this, viewNames, f);
    }

    @Override
    public void withTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withTable$(this, tableNames, f);
    }

    @Override
    public void withView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withView$(this, viewNames, f);
    }

    @Override
    public void withTempDatabase(Function1<String, BoxedUnit> f) {
        SQLTestUtilsBase.withTempDatabase$(this, f);
    }

    @Override
    public void withDatabase(Seq<String> dbNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withDatabase$(this, dbNames, f);
    }

    @Override
    public void withLocale(String language, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withLocale$(this, language, f);
    }

    @Override
    public void activateDatabase(String db, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.activateDatabase$(this, db, f);
    }

    @Override
    public Dataset<Row> stripSparkFilter(Dataset<Row> df) {
        return SQLTestUtilsBase.stripSparkFilter$(this, df);
    }

    @Override
    public Dataset<Row> logicalPlanToSparkQuery(LogicalPlan plan) {
        return SQLTestUtilsBase.logicalPlanToSparkQuery$(this, plan);
    }

    @Override
    public URI makeQualifiedPath(String path) {
        return SQLTestUtilsBase.makeQualifiedPath$(this, path);
    }

    @Override
    public String testFile(String fileName) {
        return SQLTestUtilsBase.testFile$(this, fileName);
    }

    public SQLConf conf() {
        return PlanTestBase.conf$((PlanTestBase)this);
    }

    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$((PlanTestBase)this, (LogicalPlan)plan);
    }

    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$((PlanTestBase)this, (LogicalPlan)plan);
    }

    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$((PlanTestBase)this, (LogicalPlan)plan1, (LogicalPlan)plan2, (boolean)checkAnalysis);
    }

    public boolean comparePlans$default$3() {
        return PlanTestBase.comparePlans$default$3$((PlanTestBase)this);
    }

    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$((PlanTestBase)this, (Expression)e1, (Expression)e2);
    }

    public void compareJoinOrder(LogicalPlan plan1, LogicalPlan plan2) {
        PlanTestBase.compareJoinOrder$((PlanTestBase)this, (LogicalPlan)plan1, (LogicalPlan)plan2);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression replaceAlias(Expression condition, AttributeMap<Expression> aliases) {
        return PredicateHelper.replaceAlias$((PredicateHelper)this, (Expression)condition, aliases);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    @Override
    public void loadTestData() {
        SQLTestData.loadTestData$(this);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, PatienceConfiguration.Interval interval, Function0<T> fun, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, (PatienceConfiguration.Interval)interval, fun, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, fun, (AbstractPatienceConfiguration.PatienceConfig)config, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Interval interval, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Interval)interval, fun, (AbstractPatienceConfiguration.PatienceConfig)config, (Position)pos);
    }

    public <T> T eventually(Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, fun, (AbstractPatienceConfiguration.PatienceConfig)config, (Position)pos);
    }

    public AbstractPatienceConfiguration.PatienceConfig patienceConfig() {
        return PatienceConfiguration.patienceConfig$((PatienceConfiguration)this);
    }

    public PatienceConfiguration.Timeout timeout(Span value) {
        return PatienceConfiguration.timeout$((PatienceConfiguration)this, (Span)value);
    }

    public PatienceConfiguration.Interval interval(Span value) {
        return PatienceConfiguration.interval$((PatienceConfiguration)this, (Span)value);
    }

    public final Span scaled(Span span) {
        return ScaledTimeSpans.scaled$((ScaledTimeSpans)this, (Span)span);
    }

    public double spanScaleFactor() {
        return ScaledTimeSpans.spanScaleFactor$((ScaledTimeSpans)this);
    }

    @Override
    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSQLContext$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    @Override
    public TestSparkSession org$apache$spark$sql$test$SharedSparkSession$$_spark() {
        return this.org$apache$spark$sql$test$SharedSparkSession$$_spark;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSparkSession$$_spark_$eq(TestSparkSession x$1) {
        this.org$apache$spark$sql$test$SharedSparkSession$$_spark = x$1;
    }

    @Override
    public boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests() {
        return this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    }

    @Override
    public void org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests_$eq(boolean x$1) {
        this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests = x$1;
    }

    private Function1<String, Dataset<Row>> sql$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 1) == 0) {
                this.sql = SQLTestUtilsBase.sql$(this);
                this.bitmap$0 |= 1;
            }
        }
        return this.sql;
    }

    @Override
    public Function1<String, Dataset<Row>> sql() {
        return (this.bitmap$0 & 1) == 0 ? this.sql$lzycompute() : this.sql;
    }

    @Override
    public SQLTestUtilsBase$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public SQLTestData$internalImplicits$ org$apache$spark$sql$test$SQLTestData$$internalImplicits() {
        if (this.internalImplicits$module == null) {
            this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute$1();
        }
        return this.internalImplicits$module;
    }

    private Dataset<Row> emptyTestData$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 2) == 0) {
                this.emptyTestData = SQLTestData.emptyTestData$(this);
                this.bitmap$0 |= 2;
            }
        }
        return this.emptyTestData;
    }

    @Override
    public Dataset<Row> emptyTestData() {
        return (this.bitmap$0 & 2) == 0 ? this.emptyTestData$lzycompute() : this.emptyTestData;
    }

    private Dataset<Row> testData$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 4) == 0) {
                this.testData = SQLTestData.testData$(this);
                this.bitmap$0 |= 4;
            }
        }
        return this.testData;
    }

    @Override
    public Dataset<Row> testData() {
        return (this.bitmap$0 & 4) == 0 ? this.testData$lzycompute() : this.testData;
    }

    private Dataset<Row> testData2$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 8) == 0) {
                this.testData2 = SQLTestData.testData2$(this);
                this.bitmap$0 |= 8;
            }
        }
        return this.testData2;
    }

    @Override
    public Dataset<Row> testData2() {
        return (this.bitmap$0 & 8) == 0 ? this.testData2$lzycompute() : this.testData2;
    }

    private Dataset<Row> testData3$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.testData3 = SQLTestData.testData3$(this);
                this.bitmap$0 |= 0x10;
            }
        }
        return this.testData3;
    }

    @Override
    public Dataset<Row> testData3() {
        return (this.bitmap$0 & 0x10) == 0 ? this.testData3$lzycompute() : this.testData3;
    }

    private Dataset<Row> negativeData$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.negativeData = SQLTestData.negativeData$(this);
                this.bitmap$0 |= 0x20;
            }
        }
        return this.negativeData;
    }

    @Override
    public Dataset<Row> negativeData() {
        return (this.bitmap$0 & 0x20) == 0 ? this.negativeData$lzycompute() : this.negativeData;
    }

    private Dataset<Row> largeAndSmallInts$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.largeAndSmallInts = SQLTestData.largeAndSmallInts$(this);
                this.bitmap$0 |= 0x40;
            }
        }
        return this.largeAndSmallInts;
    }

    @Override
    public Dataset<Row> largeAndSmallInts() {
        return (this.bitmap$0 & 0x40) == 0 ? this.largeAndSmallInts$lzycompute() : this.largeAndSmallInts;
    }

    private Dataset<Row> decimalData$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.decimalData = SQLTestData.decimalData$(this);
                this.bitmap$0 |= 0x80;
            }
        }
        return this.decimalData;
    }

    @Override
    public Dataset<Row> decimalData() {
        return (this.bitmap$0 & 0x80) == 0 ? this.decimalData$lzycompute() : this.decimalData;
    }

    private Dataset<Row> binaryData$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.binaryData = SQLTestData.binaryData$(this);
                this.bitmap$0 |= 0x100;
            }
        }
        return this.binaryData;
    }

    @Override
    public Dataset<Row> binaryData() {
        return (this.bitmap$0 & 0x100) == 0 ? this.binaryData$lzycompute() : this.binaryData;
    }

    private Dataset<Row> upperCaseData$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.upperCaseData = SQLTestData.upperCaseData$(this);
                this.bitmap$0 |= 0x200;
            }
        }
        return this.upperCaseData;
    }

    @Override
    public Dataset<Row> upperCaseData() {
        return (this.bitmap$0 & 0x200) == 0 ? this.upperCaseData$lzycompute() : this.upperCaseData;
    }

    private Dataset<Row> lowerCaseData$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.lowerCaseData = SQLTestData.lowerCaseData$(this);
                this.bitmap$0 |= 0x400;
            }
        }
        return this.lowerCaseData;
    }

    @Override
    public Dataset<Row> lowerCaseData() {
        return (this.bitmap$0 & 0x400) == 0 ? this.lowerCaseData$lzycompute() : this.lowerCaseData;
    }

    private Dataset<Row> lowerCaseDataWithDuplicates$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.lowerCaseDataWithDuplicates = SQLTestData.lowerCaseDataWithDuplicates$(this);
                this.bitmap$0 |= 0x800;
            }
        }
        return this.lowerCaseDataWithDuplicates;
    }

    @Override
    public Dataset<Row> lowerCaseDataWithDuplicates() {
        return (this.bitmap$0 & 0x800) == 0 ? this.lowerCaseDataWithDuplicates$lzycompute() : this.lowerCaseDataWithDuplicates;
    }

    private RDD<SQLTestData.ArrayData> arrayData$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.arrayData = SQLTestData.arrayData$(this);
                this.bitmap$0 |= 0x1000;
            }
        }
        return this.arrayData;
    }

    @Override
    public RDD<SQLTestData.ArrayData> arrayData() {
        return (this.bitmap$0 & 0x1000) == 0 ? this.arrayData$lzycompute() : this.arrayData;
    }

    private RDD<SQLTestData.MapData> mapData$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 0x2000) == 0) {
                this.mapData = SQLTestData.mapData$(this);
                this.bitmap$0 |= 0x2000;
            }
        }
        return this.mapData;
    }

    @Override
    public RDD<SQLTestData.MapData> mapData() {
        return (this.bitmap$0 & 0x2000) == 0 ? this.mapData$lzycompute() : this.mapData;
    }

    private RDD<SQLTestData.StringData> repeatedData$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 0x4000) == 0) {
                this.repeatedData = SQLTestData.repeatedData$(this);
                this.bitmap$0 |= 0x4000;
            }
        }
        return this.repeatedData;
    }

    @Override
    public RDD<SQLTestData.StringData> repeatedData() {
        return (this.bitmap$0 & 0x4000) == 0 ? this.repeatedData$lzycompute() : this.repeatedData;
    }

    private RDD<SQLTestData.StringData> nullableRepeatedData$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 0x8000) == 0) {
                this.nullableRepeatedData = SQLTestData.nullableRepeatedData$(this);
                this.bitmap$0 |= 0x8000;
            }
        }
        return this.nullableRepeatedData;
    }

    @Override
    public RDD<SQLTestData.StringData> nullableRepeatedData() {
        return (this.bitmap$0 & 0x8000) == 0 ? this.nullableRepeatedData$lzycompute() : this.nullableRepeatedData;
    }

    private Dataset<Row> nullInts$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 0x10000) == 0) {
                this.nullInts = SQLTestData.nullInts$(this);
                this.bitmap$0 |= 0x10000;
            }
        }
        return this.nullInts;
    }

    @Override
    public Dataset<Row> nullInts() {
        return (this.bitmap$0 & 0x10000) == 0 ? this.nullInts$lzycompute() : this.nullInts;
    }

    private Dataset<Row> allNulls$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 0x20000) == 0) {
                this.allNulls = SQLTestData.allNulls$(this);
                this.bitmap$0 |= 0x20000;
            }
        }
        return this.allNulls;
    }

    @Override
    public Dataset<Row> allNulls() {
        return (this.bitmap$0 & 0x20000) == 0 ? this.allNulls$lzycompute() : this.allNulls;
    }

    private Dataset<Row> nullStrings$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 0x40000) == 0) {
                this.nullStrings = SQLTestData.nullStrings$(this);
                this.bitmap$0 |= 0x40000;
            }
        }
        return this.nullStrings;
    }

    @Override
    public Dataset<Row> nullStrings() {
        return (this.bitmap$0 & 0x40000) == 0 ? this.nullStrings$lzycompute() : this.nullStrings;
    }

    private Dataset<Row> tableName$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 0x80000) == 0) {
                this.tableName = SQLTestData.tableName$(this);
                this.bitmap$0 |= 0x80000;
            }
        }
        return this.tableName;
    }

    @Override
    public Dataset<Row> tableName() {
        return (this.bitmap$0 & 0x80000) == 0 ? this.tableName$lzycompute() : this.tableName;
    }

    private RDD<String> unparsedStrings$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 0x100000) == 0) {
                this.unparsedStrings = SQLTestData.unparsedStrings$(this);
                this.bitmap$0 |= 0x100000;
            }
        }
        return this.unparsedStrings;
    }

    @Override
    public RDD<String> unparsedStrings() {
        return (this.bitmap$0 & 0x100000) == 0 ? this.unparsedStrings$lzycompute() : this.unparsedStrings;
    }

    private RDD<SQLTestData.IntField> withEmptyParts$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 0x200000) == 0) {
                this.withEmptyParts = SQLTestData.withEmptyParts$(this);
                this.bitmap$0 |= 0x200000;
            }
        }
        return this.withEmptyParts;
    }

    @Override
    public RDD<SQLTestData.IntField> withEmptyParts() {
        return (this.bitmap$0 & 0x200000) == 0 ? this.withEmptyParts$lzycompute() : this.withEmptyParts;
    }

    private Dataset<Row> person$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 0x400000) == 0) {
                this.person = SQLTestData.person$(this);
                this.bitmap$0 |= 0x400000;
            }
        }
        return this.person;
    }

    @Override
    public Dataset<Row> person() {
        return (this.bitmap$0 & 0x400000) == 0 ? this.person$lzycompute() : this.person;
    }

    private Dataset<Row> salary$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 0x800000) == 0) {
                this.salary = SQLTestData.salary$(this);
                this.bitmap$0 |= 0x800000;
            }
        }
        return this.salary;
    }

    @Override
    public Dataset<Row> salary() {
        return (this.bitmap$0 & 0x800000) == 0 ? this.salary$lzycompute() : this.salary;
    }

    private Dataset<Row> complexData$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 0x1000000) == 0) {
                this.complexData = SQLTestData.complexData$(this);
                this.bitmap$0 |= 0x1000000;
            }
        }
        return this.complexData;
    }

    @Override
    public Dataset<Row> complexData() {
        return (this.bitmap$0 & 0x1000000) == 0 ? this.complexData$lzycompute() : this.complexData;
    }

    private Dataset<Row> courseSales$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 0x2000000) == 0) {
                this.courseSales = SQLTestData.courseSales$(this);
                this.bitmap$0 |= 0x2000000;
            }
        }
        return this.courseSales;
    }

    @Override
    public Dataset<Row> courseSales() {
        return (this.bitmap$0 & 0x2000000) == 0 ? this.courseSales$lzycompute() : this.courseSales;
    }

    private Dataset<Row> trainingSales$lzycompute() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if ((this.bitmap$0 & 0x4000000) == 0) {
                this.trainingSales = SQLTestData.trainingSales$(this);
                this.bitmap$0 |= 0x4000000;
            }
        }
        return this.trainingSales;
    }

    @Override
    public Dataset<Row> trainingSales() {
        return (this.bitmap$0 & 0x4000000) == 0 ? this.trainingSales$lzycompute() : this.trainingSales;
    }

    public AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig() {
        return this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    }

    public final void org$scalatest$concurrent$PatienceConfiguration$_setter_$org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig_$eq(AbstractPatienceConfiguration.PatienceConfig x$1) {
        this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig = x$1;
    }

    public AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig() {
        if (this.PatienceConfig$module == null) {
            this.PatienceConfig$lzycompute$1();
        }
        return this.PatienceConfig$module;
    }

    public <T extends Product> void testSchemaInference(String testName, String messageType, boolean binaryAsString, boolean int96AsTimestamp, boolean writeLegacyParquetFormat, ClassTag<T> evidence$1, TypeTags.TypeTag<T> evidence$2) {
        this.testSchema(testName, StructType$.MODULE$.fromAttributes(ScalaReflection$.MODULE$.attributesFor(evidence$2)), messageType, binaryAsString, int96AsTimestamp, writeLegacyParquetFormat, this.testSchema$default$7());
    }

    public void testParquetToCatalyst(String testName, StructType sqlSchema, String parquetSchema, boolean binaryAsString, boolean int96AsTimestamp) {
        ParquetToSparkSchemaConverter converter = new ParquetToSparkSchemaConverter(binaryAsString, int96AsTimestamp);
        this.test(new StringBuilder(16).append("sql <= parquet: ").append(testName).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            StructType actual = converter.convert(MessageTypeParser.parseMessageType((String)parquetSchema));
            StructType expected = sqlSchema;
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(actual);
            StructType $org_scalatest_assert_macro_right = expected;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(86).append("Schema mismatch.\n           |Expected schema: ").append(expected.json()).append("\n           |Actual schema:   ").append(actual.json()).append("\n         ").toString())).stripMargin(), Prettifier$.MODULE$.default(), new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        }, new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
    }

    public void testCatalystToParquet(String testName, StructType sqlSchema, String parquetSchema, boolean writeLegacyParquetFormat, Enumeration.Value outputTimestampType) {
        SparkToParquetSchemaConverter converter = new SparkToParquetSchemaConverter(writeLegacyParquetFormat, outputTimestampType);
        this.test(new StringBuilder(16).append("sql => parquet: ").append(testName).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            MessageType actual = converter.convert(sqlSchema);
            MessageType expected = MessageTypeParser.parseMessageType((String)parquetSchema);
            actual.checkContains((Type)expected);
            expected.checkContains((Type)actual);
        }, new Position("ParquetSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
    }

    public Enumeration.Value testCatalystToParquet$default$5() {
        return SQLConf.ParquetOutputTimestampType$.MODULE$.INT96();
    }

    public void testSchema(String testName, StructType sqlSchema, String parquetSchema, boolean binaryAsString, boolean int96AsTimestamp, boolean writeLegacyParquetFormat, Enumeration.Value outputTimestampType) {
        this.testCatalystToParquet(testName, sqlSchema, parquetSchema, writeLegacyParquetFormat, outputTimestampType);
        this.testParquetToCatalyst(testName, sqlSchema, parquetSchema, binaryAsString, int96AsTimestamp);
    }

    public Enumeration.Value testSchema$default$7() {
        return SQLConf.ParquetOutputTimestampType$.MODULE$.INT96();
    }

    private final void testImplicits$lzycompute$1() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new SQLTestUtilsBase$testImplicits$(this);
            }
        }
    }

    private final void org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute$1() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if (this.internalImplicits$module == null) {
                this.internalImplicits$module = new SQLTestData$internalImplicits$(this);
            }
        }
    }

    private final void PatienceConfig$lzycompute$1() {
        ParquetSchemaTest parquetSchemaTest = this;
        synchronized (parquetSchemaTest) {
            if (this.PatienceConfig$module == null) {
                this.PatienceConfig$module = new AbstractPatienceConfiguration$PatienceConfig$((AbstractPatienceConfiguration)this);
            }
        }
    }

    public ParquetSchemaTest() {
        ScaledTimeSpans.$init$((ScaledTimeSpans)this);
        AbstractPatienceConfiguration.$init$((AbstractPatienceConfiguration)this);
        PatienceConfiguration.$init$((PatienceConfiguration)this);
        Eventually.$init$((Eventually)this);
        SQLTestData.$init$(this);
        PredicateHelper.$init$((PredicateHelper)this);
        PlanTestBase.$init$((PlanTestBase)this);
        SQLTestUtilsBase.$init$(this);
        SQLTestUtils.$init$(this);
        ParquetTest.$init$(this);
        SharedSparkSession.$init$(this);
        SharedSQLContext.$init$(this);
    }
}

