/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import com.google.common.io.Files;
import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.hadoop.Footer;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Column$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.QueryTest;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalogUtils$;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.PartitionPath;
import org.apache.spark.sql.execution.datasources.PartitionPath$;
import org.apache.spark.sql.execution.datasources.PartitionSpec;
import org.apache.spark.sql.execution.datasources.PartitionSpec$;
import org.apache.spark.sql.execution.datasources.PartitioningAwareFileIndex;
import org.apache.spark.sql.execution.datasources.PartitioningUtils;
import org.apache.spark.sql.execution.datasources.PartitioningUtils$;
import org.apache.spark.sql.execution.datasources.SQLHadoopMapReduceCommitProtocol;
import org.apache.spark.sql.execution.datasources.parquet.ParquetData;
import org.apache.spark.sql.execution.datasources.parquet.ParquetDataWithKey;
import org.apache.spark.sql.execution.datasources.parquet.ParquetPartitionDiscoverySuite$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetTest;
import org.apache.spark.sql.execution.streaming.MemoryStream;
import org.apache.spark.sql.execution.streaming.MemoryStream$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.test.SQLTestData;
import org.apache.spark.sql.test.SQLTestData$internalImplicits$;
import org.apache.spark.sql.test.SQLTestUtils;
import org.apache.spark.sql.test.SQLTestUtilsBase;
import org.apache.spark.sql.test.SQLTestUtilsBase$testImplicits$;
import org.apache.spark.sql.test.SharedSQLContext;
import org.apache.spark.sql.test.SharedSparkSession;
import org.apache.spark.sql.test.TestSparkSession;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.scalatest.concurrent.AbstractPatienceConfiguration;
import org.scalatest.concurrent.AbstractPatienceConfiguration$PatienceConfig$;
import org.scalatest.concurrent.Eventually;
import org.scalatest.concurrent.PatienceConfiguration;
import org.scalatest.concurrent.ScaledTimeSpans;
import org.scalatest.time.Span;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Symbol;
import scala.Tuple1;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001-3AAC\u0006\u00015!)\u0011\u0006\u0001C\u0001U!9A\u0006\u0001b\u0001\n\u0003i\u0003B\u0002\u001c\u0001A\u0003%a\u0006C\u00048\u0001\t\u0007I\u0011\u0001\u001d\t\r}\u0002\u0001\u0015!\u0003:\u0011\u001d\u0001\u0005A1A\u0005\u00025Ba!\u0011\u0001!\u0002\u0013q\u0003\"\u0002\"\u0001\t#\u001a\u0005\"\u0002&\u0001\t#\u001a%A\b)beF,X\r\u001e)beRLG/[8o\t&\u001c8m\u001c<fef\u001cV/\u001b;f\u0015\taQ\"A\u0004qCJ\fX/\u001a;\u000b\u00059y\u0011a\u00033bi\u0006\u001cx.\u001e:dKNT!\u0001E\t\u0002\u0013\u0015DXmY;uS>t'B\u0001\n\u0014\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003)U\tQa\u001d9be.T!AF\f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0012aA8sO\u000e\u00011\u0003\u0002\u0001\u001c?\r\u0002\"\u0001H\u000f\u000e\u0003EI!AH\t\u0003\u0013E+XM]=UKN$\bC\u0001\u0011\"\u001b\u0005Y\u0011B\u0001\u0012\f\u0005-\u0001\u0016M]9vKR$Vm\u001d;\u0011\u0005\u0011:S\"A\u0013\u000b\u0005\u0019\n\u0012\u0001\u0002;fgRL!\u0001K\u0013\u0003!MC\u0017M]3e'Fc5i\u001c8uKb$\u0018A\u0002\u001fj]&$h\bF\u0001,!\t\u0001\u0003!\u0001\u000beK\u001a\fW\u000f\u001c;QCJ$\u0018\u000e^5p]:\u000bW.Z\u000b\u0002]A\u0011q\u0006N\u0007\u0002a)\u0011\u0011GM\u0001\u0005Y\u0006twMC\u00014\u0003\u0011Q\u0017M^1\n\u0005U\u0002$AB*ue&tw-A\u000beK\u001a\fW\u000f\u001c;QCJ$\u0018\u000e^5p]:\u000bW.\u001a\u0011\u0002\u0011QLW.\u001a.p]\u0016,\u0012!\u000f\t\u0003uuj\u0011a\u000f\u0006\u0003yI\nA!\u001e;jY&\u0011ah\u000f\u0002\t)&lWMW8oK\u0006IA/[7f5>tW\rI\u0001\u000bi&lWMW8oK&#\u0017a\u0003;j[\u0016TvN\\3JI\u0002\n\u0011BY3g_J,\u0017\t\u001c7\u0015\u0003\u0011\u0003\"!\u0012%\u000e\u0003\u0019S\u0011aR\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0013\u001a\u0013A!\u00168ji\u0006A\u0011M\u001a;fe\u0006cG\u000e")
public class ParquetPartitionDiscoverySuite
extends QueryTest
implements ParquetTest,
SharedSQLContext {
    private final String defaultPartitionName;
    private final TimeZone timeZone;
    private final String timeZoneId;
    private final boolean enableAutoThreadAudit;
    private TestSparkSession org$apache$spark$sql$test$SharedSparkSession$$_spark;
    private boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    private Function1<String, Dataset<Row>> sql;
    private volatile SQLTestUtilsBase$testImplicits$ testImplicits$module;
    private volatile SQLTestData$internalImplicits$ internalImplicits$module;
    private Dataset<Row> emptyTestData;
    private Dataset<Row> testData;
    private Dataset<Row> testData2;
    private Dataset<Row> testData3;
    private Dataset<Row> negativeData;
    private Dataset<Row> largeAndSmallInts;
    private Dataset<Row> decimalData;
    private Dataset<Row> binaryData;
    private Dataset<Row> upperCaseData;
    private Dataset<Row> lowerCaseData;
    private Dataset<Row> lowerCaseDataWithDuplicates;
    private RDD<SQLTestData.ArrayData> arrayData;
    private RDD<SQLTestData.MapData> mapData;
    private RDD<SQLTestData.StringData> repeatedData;
    private RDD<SQLTestData.StringData> nullableRepeatedData;
    private Dataset<Row> nullInts;
    private Dataset<Row> allNulls;
    private Dataset<Row> nullStrings;
    private Dataset<Row> tableName;
    private RDD<String> unparsedStrings;
    private RDD<SQLTestData.IntField> withEmptyParts;
    private Dataset<Row> person;
    private Dataset<Row> salary;
    private Dataset<Row> complexData;
    private Dataset<Row> courseSales;
    private Dataset<Row> trainingSales;
    private final AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    private volatile AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig$module;
    private volatile int bitmap$0;

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSQLContext$$super$beforeAll() {
        SharedSparkSession.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSQLContext$$super$afterAll() {
        SharedSparkSession.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$beforeAll() {
        SQLTestUtils.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    @Override
    public SparkConf sparkConf() {
        return SharedSparkSession.sparkConf$(this);
    }

    @Override
    public SparkSession spark() {
        return SharedSparkSession.spark$(this);
    }

    @Override
    public SQLContext sqlContext() {
        return SharedSparkSession.sqlContext$(this);
    }

    @Override
    public TestSparkSession createSparkSession() {
        return SharedSparkSession.createSparkSession$(this);
    }

    @Override
    public void initializeSession() {
        SharedSparkSession.initializeSession$(this);
    }

    @Override
    public void beforeEach() {
        SharedSparkSession.beforeEach$(this);
    }

    @Override
    public void afterEach() {
        SharedSparkSession.afterEach$(this);
    }

    @Override
    public void readParquetFile(String path, boolean testVectorized, Function1<Dataset<Row>, BoxedUnit> f) {
        ParquetTest.readParquetFile$(this, path, testVectorized, f);
    }

    @Override
    public boolean readParquetFile$default$2() {
        return ParquetTest.readParquetFile$default$2$(this);
    }

    @Override
    public <T extends Product> void withParquetFile(Seq<T> data, Function1<String, BoxedUnit> f, ClassTag<T> evidence$1, TypeTags.TypeTag<T> evidence$2) {
        ParquetTest.withParquetFile$(this, data, f, evidence$1, evidence$2);
    }

    @Override
    public <T extends Product> void withParquetDataFrame(Seq<T> data, boolean testVectorized, Function1<Dataset<Row>, BoxedUnit> f, ClassTag<T> evidence$3, TypeTags.TypeTag<T> evidence$4) {
        ParquetTest.withParquetDataFrame$(this, data, testVectorized, f, evidence$3, evidence$4);
    }

    @Override
    public <T extends Product> boolean withParquetDataFrame$default$2() {
        return ParquetTest.withParquetDataFrame$default$2$(this);
    }

    @Override
    public <T extends Product> void withParquetTable(Seq<T> data, String tableName, boolean testVectorized, Function0<BoxedUnit> f, ClassTag<T> evidence$5, TypeTags.TypeTag<T> evidence$6) {
        ParquetTest.withParquetTable$(this, data, tableName, testVectorized, f, evidence$5, evidence$6);
    }

    @Override
    public <T extends Product> boolean withParquetTable$default$3() {
        return ParquetTest.withParquetTable$default$3$(this);
    }

    @Override
    public <T extends Product> void makeParquetFile(Seq<T> data, File path, ClassTag<T> evidence$7, TypeTags.TypeTag<T> evidence$8) {
        ParquetTest.makeParquetFile$((ParquetTest)this, data, path, evidence$7, evidence$8);
    }

    @Override
    public <T extends Product> void makeParquetFile(Dataset<Row> df, File path, ClassTag<T> evidence$9, TypeTags.TypeTag<T> evidence$10) {
        ParquetTest.makeParquetFile$((ParquetTest)this, df, path, evidence$9, evidence$10);
    }

    @Override
    public File makePartitionDir(File basePath, String defaultPartitionName, Seq<Tuple2<String, Object>> partitionCols) {
        return ParquetTest.makePartitionDir$(this, basePath, defaultPartitionName, partitionCols);
    }

    @Override
    public void writeMetadata(StructType schema, Path path, Configuration configuration) {
        ParquetTest.writeMetadata$(this, schema, path, configuration);
    }

    @Override
    public void writeMetadata(MessageType parquetSchema, Path path, Configuration configuration, Map<String, String> extraMetadata) {
        ParquetTest.writeMetadata$(this, parquetSchema, path, configuration, extraMetadata);
    }

    @Override
    public Map<String, String> writeMetadata$default$4() {
        return ParquetTest.writeMetadata$default$4$(this);
    }

    @Override
    public Seq<Footer> readAllFootersWithoutSummaryFiles(Path path, Configuration configuration) {
        return ParquetTest.readAllFootersWithoutSummaryFiles$(this, path, configuration);
    }

    @Override
    public ParquetMetadata readFooter(Path path, Configuration configuration) {
        return ParquetTest.readFooter$(this, path, configuration);
    }

    @Override
    public void testStandardAndLegacyModes(String testName, Function0<BoxedUnit> f) {
        ParquetTest.testStandardAndLegacyModes$(this, testName, f);
    }

    @Override
    public Dataset<Row> readResourceParquetFile(String name) {
        return ParquetTest.readResourceParquetFile$(this, name);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public void setupTestData() {
        SQLTestUtils.setupTestData$(this);
    }

    @Override
    public void testQuietly(String name, Function0<BoxedUnit> f) {
        SQLTestUtils.testQuietly$(this, name, f);
    }

    @Override
    public void testWithUninterruptibleThread(String name, boolean quietly, Function0<BoxedUnit> body) {
        SQLTestUtils.testWithUninterruptibleThread$(this, name, quietly, body);
    }

    @Override
    public boolean testWithUninterruptibleThread$default$2() {
        return SQLTestUtils.testWithUninterruptibleThread$default$2$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtilsBase$$super$withSQLConf(Seq pairs, Function0 f) {
        PlanTestBase.withSQLConf$((PlanTestBase)this, (Seq)pairs, (Function0)f);
    }

    @Override
    public SparkContext sparkContext() {
        return SQLTestUtilsBase.sparkContext$(this);
    }

    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withSQLConf$(this, pairs, f);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLTestUtilsBase.withTempPath$(this, f);
    }

    @Override
    public void withResourceTempPath(String resourcePath, Function1<File, BoxedUnit> f) {
        SQLTestUtilsBase.withResourceTempPath$(this, resourcePath, f);
    }

    @Override
    public void waitForTasksToFinish() {
        SQLTestUtilsBase.waitForTasksToFinish$(this);
    }

    @Override
    public void withTempDir(Function1<File, BoxedUnit> f) {
        SQLTestUtilsBase.withTempDir$(this, f);
    }

    @Override
    public void withTempPaths(int numPaths, Function1<Seq<File>, BoxedUnit> f) {
        SQLTestUtilsBase.withTempPaths$(this, numPaths, f);
    }

    @Override
    public void withUserDefinedFunction(Seq<Tuple2<String, Object>> functions, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withUserDefinedFunction$(this, functions, f);
    }

    @Override
    public void withTempView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withTempView$(this, viewNames, f);
    }

    @Override
    public void withGlobalTempView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withGlobalTempView$(this, viewNames, f);
    }

    @Override
    public void withTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withTable$(this, tableNames, f);
    }

    @Override
    public void withView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withView$(this, viewNames, f);
    }

    @Override
    public void withTempDatabase(Function1<String, BoxedUnit> f) {
        SQLTestUtilsBase.withTempDatabase$(this, f);
    }

    @Override
    public void withDatabase(Seq<String> dbNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withDatabase$(this, dbNames, f);
    }

    @Override
    public void withLocale(String language, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withLocale$(this, language, f);
    }

    @Override
    public void activateDatabase(String db, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.activateDatabase$(this, db, f);
    }

    @Override
    public Dataset<Row> stripSparkFilter(Dataset<Row> df) {
        return SQLTestUtilsBase.stripSparkFilter$(this, df);
    }

    @Override
    public Dataset<Row> logicalPlanToSparkQuery(LogicalPlan plan) {
        return SQLTestUtilsBase.logicalPlanToSparkQuery$(this, plan);
    }

    @Override
    public URI makeQualifiedPath(String path) {
        return SQLTestUtilsBase.makeQualifiedPath$(this, path);
    }

    @Override
    public String testFile(String fileName) {
        return SQLTestUtilsBase.testFile$(this, fileName);
    }

    @Override
    public void loadTestData() {
        SQLTestData.loadTestData$(this);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, PatienceConfiguration.Interval interval, Function0<T> fun, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, (PatienceConfiguration.Interval)interval, fun, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, fun, (AbstractPatienceConfiguration.PatienceConfig)config, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Interval interval, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Interval)interval, fun, (AbstractPatienceConfiguration.PatienceConfig)config, (Position)pos);
    }

    public <T> T eventually(Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, fun, (AbstractPatienceConfiguration.PatienceConfig)config, (Position)pos);
    }

    public AbstractPatienceConfiguration.PatienceConfig patienceConfig() {
        return PatienceConfiguration.patienceConfig$((PatienceConfiguration)this);
    }

    public PatienceConfiguration.Timeout timeout(Span value) {
        return PatienceConfiguration.timeout$((PatienceConfiguration)this, (Span)value);
    }

    public PatienceConfiguration.Interval interval(Span value) {
        return PatienceConfiguration.interval$((PatienceConfiguration)this, (Span)value);
    }

    public final Span scaled(Span span) {
        return ScaledTimeSpans.scaled$((ScaledTimeSpans)this, (Span)span);
    }

    public double spanScaleFactor() {
        return ScaledTimeSpans.spanScaleFactor$((ScaledTimeSpans)this);
    }

    @Override
    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSQLContext$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    @Override
    public TestSparkSession org$apache$spark$sql$test$SharedSparkSession$$_spark() {
        return this.org$apache$spark$sql$test$SharedSparkSession$$_spark;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSparkSession$$_spark_$eq(TestSparkSession x$1) {
        this.org$apache$spark$sql$test$SharedSparkSession$$_spark = x$1;
    }

    @Override
    public boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests() {
        return this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    }

    @Override
    public void org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests_$eq(boolean x$1) {
        this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests = x$1;
    }

    private Function1<String, Dataset<Row>> sql$lzycompute() {
        ParquetPartitionDiscoverySuite parquetPartitionDiscoverySuite = this;
        synchronized (parquetPartitionDiscoverySuite) {
            if ((this.bitmap$0 & 1) == 0) {
                this.sql = SQLTestUtilsBase.sql$(this);
                this.bitmap$0 |= 1;
            }
        }
        return this.sql;
    }

    @Override
    public Function1<String, Dataset<Row>> sql() {
        return (this.bitmap$0 & 1) == 0 ? this.sql$lzycompute() : this.sql;
    }

    @Override
    public SQLTestUtilsBase$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    @Override
    public SQLTestData$internalImplicits$ org$apache$spark$sql$test$SQLTestData$$internalImplicits() {
        if (this.internalImplicits$module == null) {
            this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute$1();
        }
        return this.internalImplicits$module;
    }

    private Dataset<Row> emptyTestData$lzycompute() {
        ParquetPartitionDiscoverySuite parquetPartitionDiscoverySuite = this;
        synchronized (parquetPartitionDiscoverySuite) {
            if ((this.bitmap$0 & 2) == 0) {
                this.emptyTestData = SQLTestData.emptyTestData$(this);
                this.bitmap$0 |= 2;
            }
        }
        return this.emptyTestData;
    }

    @Override
    public Dataset<Row> emptyTestData() {
        return (this.bitmap$0 & 2) == 0 ? this.emptyTestData$lzycompute() : this.emptyTestData;
    }

    private Dataset<Row> testData$lzycompute() {
        ParquetPartitionDiscoverySuite parquetPartitionDiscoverySuite = this;
        synchronized (parquetPartitionDiscoverySuite) {
            if ((this.bitmap$0 & 4) == 0) {
                this.testData = SQLTestData.testData$(this);
                this.bitmap$0 |= 4;
            }
        }
        return this.testData;
    }

    @Override
    public Dataset<Row> testData() {
        return (this.bitmap$0 & 4) == 0 ? this.testData$lzycompute() : this.testData;
    }

    private Dataset<Row> testData2$lzycompute() {
        ParquetPartitionDiscoverySuite parquetPartitionDiscoverySuite = this;
        synchronized (parquetPartitionDiscoverySuite) {
            if ((this.bitmap$0 & 8) == 0) {
                this.testData2 = SQLTestData.testData2$(this);
                this.bitmap$0 |= 8;
            }
        }
        return this.testData2;
    }

    @Override
    public Dataset<Row> testData2() {
        return (this.bitmap$0 & 8) == 0 ? this.testData2$lzycompute() : this.testData2;
    }

    private Dataset<Row> testData3$lzycompute() {
        ParquetPartitionDiscoverySuite parquetPartitionDiscoverySuite = this;
        synchronized (parquetPartitionDiscoverySuite) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.testData3 = SQLTestData.testData3$(this);
                this.bitmap$0 |= 0x10;
            }
        }
        return this.testData3;
    }

    @Override
    public Dataset<Row> testData3() {
        return (this.bitmap$0 & 0x10) == 0 ? this.testData3$lzycompute() : this.testData3;
    }

    private Dataset<Row> negativeData$lzycompute() {
        ParquetPartitionDiscoverySuite parquetPartitionDiscoverySuite = this;
        synchronized (parquetPartitionDiscoverySuite) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.negativeData = SQLTestData.negativeData$(this);
                this.bitmap$0 |= 0x20;
            }
        }
        return this.negativeData;
    }

    @Override
    public Dataset<Row> negativeData() {
        return (this.bitmap$0 & 0x20) == 0 ? this.negativeData$lzycompute() : this.negativeData;
    }

    private Dataset<Row> largeAndSmallInts$lzycompute() {
        ParquetPartitionDiscoverySuite parquetPartitionDiscoverySuite = this;
        synchronized (parquetPartitionDiscoverySuite) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.largeAndSmallInts = SQLTestData.largeAndSmallInts$(this);
                this.bitmap$0 |= 0x40;
            }
        }
        return this.largeAndSmallInts;
    }

    @Override
    public Dataset<Row> largeAndSmallInts() {
        return (this.bitmap$0 & 0x40) == 0 ? this.largeAndSmallInts$lzycompute() : this.largeAndSmallInts;
    }

    private Dataset<Row> decimalData$lzycompute() {
        ParquetPartitionDiscoverySuite parquetPartitionDiscoverySuite = this;
        synchronized (parquetPartitionDiscoverySuite) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.decimalData = SQLTestData.decimalData$(this);
                this.bitmap$0 |= 0x80;
            }
        }
        return this.decimalData;
    }

    @Override
    public Dataset<Row> decimalData() {
        return (this.bitmap$0 & 0x80) == 0 ? this.decimalData$lzycompute() : this.decimalData;
    }

    private Dataset<Row> binaryData$lzycompute() {
        ParquetPartitionDiscoverySuite parquetPartitionDiscoverySuite = this;
        synchronized (parquetPartitionDiscoverySuite) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.binaryData = SQLTestData.binaryData$(this);
                this.bitmap$0 |= 0x100;
            }
        }
        return this.binaryData;
    }

    @Override
    public Dataset<Row> binaryData() {
        return (this.bitmap$0 & 0x100) == 0 ? this.binaryData$lzycompute() : this.binaryData;
    }

    private Dataset<Row> upperCaseData$lzycompute() {
        ParquetPartitionDiscoverySuite parquetPartitionDiscoverySuite = this;
        synchronized (parquetPartitionDiscoverySuite) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.upperCaseData = SQLTestData.upperCaseData$(this);
                this.bitmap$0 |= 0x200;
            }
        }
        return this.upperCaseData;
    }

    @Override
    public Dataset<Row> upperCaseData() {
        return (this.bitmap$0 & 0x200) == 0 ? this.upperCaseData$lzycompute() : this.upperCaseData;
    }

    private Dataset<Row> lowerCaseData$lzycompute() {
        ParquetPartitionDiscoverySuite parquetPartitionDiscoverySuite = this;
        synchronized (parquetPartitionDiscoverySuite) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.lowerCaseData = SQLTestData.lowerCaseData$(this);
                this.bitmap$0 |= 0x400;
            }
        }
        return this.lowerCaseData;
    }

    @Override
    public Dataset<Row> lowerCaseData() {
        return (this.bitmap$0 & 0x400) == 0 ? this.lowerCaseData$lzycompute() : this.lowerCaseData;
    }

    private Dataset<Row> lowerCaseDataWithDuplicates$lzycompute() {
        ParquetPartitionDiscoverySuite parquetPartitionDiscoverySuite = this;
        synchronized (parquetPartitionDiscoverySuite) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.lowerCaseDataWithDuplicates = SQLTestData.lowerCaseDataWithDuplicates$(this);
                this.bitmap$0 |= 0x800;
            }
        }
        return this.lowerCaseDataWithDuplicates;
    }

    @Override
    public Dataset<Row> lowerCaseDataWithDuplicates() {
        return (this.bitmap$0 & 0x800) == 0 ? this.lowerCaseDataWithDuplicates$lzycompute() : this.lowerCaseDataWithDuplicates;
    }

    private RDD<SQLTestData.ArrayData> arrayData$lzycompute() {
        ParquetPartitionDiscoverySuite parquetPartitionDiscoverySuite = this;
        synchronized (parquetPartitionDiscoverySuite) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.arrayData = SQLTestData.arrayData$(this);
                this.bitmap$0 |= 0x1000;
            }
        }
        return this.arrayData;
    }

    @Override
    public RDD<SQLTestData.ArrayData> arrayData() {
        return (this.bitmap$0 & 0x1000) == 0 ? this.arrayData$lzycompute() : this.arrayData;
    }

    private RDD<SQLTestData.MapData> mapData$lzycompute() {
        ParquetPartitionDiscoverySuite parquetPartitionDiscoverySuite = this;
        synchronized (parquetPartitionDiscoverySuite) {
            if ((this.bitmap$0 & 0x2000) == 0) {
                this.mapData = SQLTestData.mapData$(this);
                this.bitmap$0 |= 0x2000;
            }
        }
        return this.mapData;
    }

    @Override
    public RDD<SQLTestData.MapData> mapData() {
        return (this.bitmap$0 & 0x2000) == 0 ? this.mapData$lzycompute() : this.mapData;
    }

    private RDD<SQLTestData.StringData> repeatedData$lzycompute() {
        ParquetPartitionDiscoverySuite parquetPartitionDiscoverySuite = this;
        synchronized (parquetPartitionDiscoverySuite) {
            if ((this.bitmap$0 & 0x4000) == 0) {
                this.repeatedData = SQLTestData.repeatedData$(this);
                this.bitmap$0 |= 0x4000;
            }
        }
        return this.repeatedData;
    }

    @Override
    public RDD<SQLTestData.StringData> repeatedData() {
        return (this.bitmap$0 & 0x4000) == 0 ? this.repeatedData$lzycompute() : this.repeatedData;
    }

    private RDD<SQLTestData.StringData> nullableRepeatedData$lzycompute() {
        ParquetPartitionDiscoverySuite parquetPartitionDiscoverySuite = this;
        synchronized (parquetPartitionDiscoverySuite) {
            if ((this.bitmap$0 & 0x8000) == 0) {
                this.nullableRepeatedData = SQLTestData.nullableRepeatedData$(this);
                this.bitmap$0 |= 0x8000;
            }
        }
        return this.nullableRepeatedData;
    }

    @Override
    public RDD<SQLTestData.StringData> nullableRepeatedData() {
        return (this.bitmap$0 & 0x8000) == 0 ? this.nullableRepeatedData$lzycompute() : this.nullableRepeatedData;
    }

    private Dataset<Row> nullInts$lzycompute() {
        ParquetPartitionDiscoverySuite parquetPartitionDiscoverySuite = this;
        synchronized (parquetPartitionDiscoverySuite) {
            if ((this.bitmap$0 & 0x10000) == 0) {
                this.nullInts = SQLTestData.nullInts$(this);
                this.bitmap$0 |= 0x10000;
            }
        }
        return this.nullInts;
    }

    @Override
    public Dataset<Row> nullInts() {
        return (this.bitmap$0 & 0x10000) == 0 ? this.nullInts$lzycompute() : this.nullInts;
    }

    private Dataset<Row> allNulls$lzycompute() {
        ParquetPartitionDiscoverySuite parquetPartitionDiscoverySuite = this;
        synchronized (parquetPartitionDiscoverySuite) {
            if ((this.bitmap$0 & 0x20000) == 0) {
                this.allNulls = SQLTestData.allNulls$(this);
                this.bitmap$0 |= 0x20000;
            }
        }
        return this.allNulls;
    }

    @Override
    public Dataset<Row> allNulls() {
        return (this.bitmap$0 & 0x20000) == 0 ? this.allNulls$lzycompute() : this.allNulls;
    }

    private Dataset<Row> nullStrings$lzycompute() {
        ParquetPartitionDiscoverySuite parquetPartitionDiscoverySuite = this;
        synchronized (parquetPartitionDiscoverySuite) {
            if ((this.bitmap$0 & 0x40000) == 0) {
                this.nullStrings = SQLTestData.nullStrings$(this);
                this.bitmap$0 |= 0x40000;
            }
        }
        return this.nullStrings;
    }

    @Override
    public Dataset<Row> nullStrings() {
        return (this.bitmap$0 & 0x40000) == 0 ? this.nullStrings$lzycompute() : this.nullStrings;
    }

    private Dataset<Row> tableName$lzycompute() {
        ParquetPartitionDiscoverySuite parquetPartitionDiscoverySuite = this;
        synchronized (parquetPartitionDiscoverySuite) {
            if ((this.bitmap$0 & 0x80000) == 0) {
                this.tableName = SQLTestData.tableName$(this);
                this.bitmap$0 |= 0x80000;
            }
        }
        return this.tableName;
    }

    @Override
    public Dataset<Row> tableName() {
        return (this.bitmap$0 & 0x80000) == 0 ? this.tableName$lzycompute() : this.tableName;
    }

    private RDD<String> unparsedStrings$lzycompute() {
        ParquetPartitionDiscoverySuite parquetPartitionDiscoverySuite = this;
        synchronized (parquetPartitionDiscoverySuite) {
            if ((this.bitmap$0 & 0x100000) == 0) {
                this.unparsedStrings = SQLTestData.unparsedStrings$(this);
                this.bitmap$0 |= 0x100000;
            }
        }
        return this.unparsedStrings;
    }

    @Override
    public RDD<String> unparsedStrings() {
        return (this.bitmap$0 & 0x100000) == 0 ? this.unparsedStrings$lzycompute() : this.unparsedStrings;
    }

    private RDD<SQLTestData.IntField> withEmptyParts$lzycompute() {
        ParquetPartitionDiscoverySuite parquetPartitionDiscoverySuite = this;
        synchronized (parquetPartitionDiscoverySuite) {
            if ((this.bitmap$0 & 0x200000) == 0) {
                this.withEmptyParts = SQLTestData.withEmptyParts$(this);
                this.bitmap$0 |= 0x200000;
            }
        }
        return this.withEmptyParts;
    }

    @Override
    public RDD<SQLTestData.IntField> withEmptyParts() {
        return (this.bitmap$0 & 0x200000) == 0 ? this.withEmptyParts$lzycompute() : this.withEmptyParts;
    }

    private Dataset<Row> person$lzycompute() {
        ParquetPartitionDiscoverySuite parquetPartitionDiscoverySuite = this;
        synchronized (parquetPartitionDiscoverySuite) {
            if ((this.bitmap$0 & 0x400000) == 0) {
                this.person = SQLTestData.person$(this);
                this.bitmap$0 |= 0x400000;
            }
        }
        return this.person;
    }

    @Override
    public Dataset<Row> person() {
        return (this.bitmap$0 & 0x400000) == 0 ? this.person$lzycompute() : this.person;
    }

    private Dataset<Row> salary$lzycompute() {
        ParquetPartitionDiscoverySuite parquetPartitionDiscoverySuite = this;
        synchronized (parquetPartitionDiscoverySuite) {
            if ((this.bitmap$0 & 0x800000) == 0) {
                this.salary = SQLTestData.salary$(this);
                this.bitmap$0 |= 0x800000;
            }
        }
        return this.salary;
    }

    @Override
    public Dataset<Row> salary() {
        return (this.bitmap$0 & 0x800000) == 0 ? this.salary$lzycompute() : this.salary;
    }

    private Dataset<Row> complexData$lzycompute() {
        ParquetPartitionDiscoverySuite parquetPartitionDiscoverySuite = this;
        synchronized (parquetPartitionDiscoverySuite) {
            if ((this.bitmap$0 & 0x1000000) == 0) {
                this.complexData = SQLTestData.complexData$(this);
                this.bitmap$0 |= 0x1000000;
            }
        }
        return this.complexData;
    }

    @Override
    public Dataset<Row> complexData() {
        return (this.bitmap$0 & 0x1000000) == 0 ? this.complexData$lzycompute() : this.complexData;
    }

    private Dataset<Row> courseSales$lzycompute() {
        ParquetPartitionDiscoverySuite parquetPartitionDiscoverySuite = this;
        synchronized (parquetPartitionDiscoverySuite) {
            if ((this.bitmap$0 & 0x2000000) == 0) {
                this.courseSales = SQLTestData.courseSales$(this);
                this.bitmap$0 |= 0x2000000;
            }
        }
        return this.courseSales;
    }

    @Override
    public Dataset<Row> courseSales() {
        return (this.bitmap$0 & 0x2000000) == 0 ? this.courseSales$lzycompute() : this.courseSales;
    }

    private Dataset<Row> trainingSales$lzycompute() {
        ParquetPartitionDiscoverySuite parquetPartitionDiscoverySuite = this;
        synchronized (parquetPartitionDiscoverySuite) {
            if ((this.bitmap$0 & 0x4000000) == 0) {
                this.trainingSales = SQLTestData.trainingSales$(this);
                this.bitmap$0 |= 0x4000000;
            }
        }
        return this.trainingSales;
    }

    @Override
    public Dataset<Row> trainingSales() {
        return (this.bitmap$0 & 0x4000000) == 0 ? this.trainingSales$lzycompute() : this.trainingSales;
    }

    public AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig() {
        return this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    }

    public final void org$scalatest$concurrent$PatienceConfiguration$_setter_$org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig_$eq(AbstractPatienceConfiguration.PatienceConfig x$1) {
        this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig = x$1;
    }

    public AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig() {
        if (this.PatienceConfig$module == null) {
            this.PatienceConfig$lzycompute$1();
        }
        return this.PatienceConfig$module;
    }

    public String defaultPartitionName() {
        return this.defaultPartitionName;
    }

    public TimeZone timeZone() {
        return this.timeZone;
    }

    public String timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public void beforeAll() {
        SharedSQLContext.beforeAll$(this);
        this.spark().conf().set(SQLConf$.MODULE$.DEFAULT_DATA_SOURCE_NAME().key(), "parquet");
    }

    @Override
    public void afterAll() {
        this.spark().conf().unset(SQLConf$.MODULE$.DEFAULT_DATA_SOURCE_NAME().key());
        SharedSQLContext.afterAll$(this);
    }

    private final void testImplicits$lzycompute$1() {
        ParquetPartitionDiscoverySuite parquetPartitionDiscoverySuite = this;
        synchronized (parquetPartitionDiscoverySuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new SQLTestUtilsBase$testImplicits$(this);
            }
        }
    }

    private final void org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute$1() {
        ParquetPartitionDiscoverySuite parquetPartitionDiscoverySuite = this;
        synchronized (parquetPartitionDiscoverySuite) {
            if (this.internalImplicits$module == null) {
                this.internalImplicits$module = new SQLTestData$internalImplicits$(this);
            }
        }
    }

    private final void PatienceConfig$lzycompute$1() {
        ParquetPartitionDiscoverySuite parquetPartitionDiscoverySuite = this;
        synchronized (parquetPartitionDiscoverySuite) {
            if (this.PatienceConfig$module == null) {
                this.PatienceConfig$module = new AbstractPatienceConfiguration$PatienceConfig$((AbstractPatienceConfiguration)this);
            }
        }
    }

    private final void check$1(String raw, Literal literal, TimeZone timeZone) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(PartitioningUtils$.MODULE$.inferPartitionColumnValue(raw, true, timeZone));
        Literal $org_scalatest_assert_macro_right = literal;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
    }

    private final TimeZone check$default$3$1() {
        return this.timeZone();
    }

    private final void check$2(String path, Option expected) {
        Option actual = (Option)PartitioningUtils$.MODULE$.parsePartition(new Path(path), true, Predef$.MODULE$.Set().empty(), Predef$.MODULE$.Map().empty(), this.timeZone())._1();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(expected);
        Option $org_scalatest_assert_macro_right = actual;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
    }

    private final void checkThrows$1(String path, String expected, Manifest evidence$1) {
        String message;
        String $org_scalatest_assert_macro_left = message = ((Throwable)this.intercept((Function0 & Serializable & scala.Serializable)() -> PartitioningUtils$.MODULE$.parsePartition(new Path(path), true, Predef$.MODULE$.Set().empty(), Predef$.MODULE$.Map().empty(), this.timeZone()), (ClassTag)evidence$1, new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 199))).getMessage();
        String $org_scalatest_assert_macro_right = expected;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
    }

    private final void check$3(Seq paths, PartitionSpec spec, Set rootPaths) {
        PartitionSpec actualSpec = PartitioningUtils$.MODULE$.parsePartitions((Seq)paths.map((Function1 & Serializable & scala.Serializable)x$7 -> new Path(x$7), Seq$.MODULE$.canBuildFrom()), true, rootPaths, (Option)None$.MODULE$, true, this.timeZoneId());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(actualSpec.partitionColumns());
        StructType $org_scalatest_assert_macro_right = spec.partitionColumns();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)actualSpec.partitions().length()));
        int $org_scalatest_assert_macro_right2 = spec.partitions().length();
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 277));
        ((IterableLike)actualSpec.partitions().zip((GenIterable)spec.partitions(), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            PartitionPath actual = (PartitionPath)tuple2._1();
            PartitionPath expected = (PartitionPath)tuple2._2();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(actual);
            PartitionPath $org_scalatest_assert_macro_right = expected;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertion assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 279));
            return assertion;
        });
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(actualSpec);
        PartitionSpec $org_scalatest_assert_macro_right3 = spec;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
    }

    private static final Set check$default$3$2() {
        return Predef$.MODULE$.Set().empty();
    }

    private final void check$4(Seq paths, PartitionSpec spec) {
        PartitionSpec actualSpec = PartitioningUtils$.MODULE$.parsePartitions((Seq)paths.map((Function1 & Serializable & scala.Serializable)x$8 -> new Path(x$8), Seq$.MODULE$.canBuildFrom()), false, Predef$.MODULE$.Set().empty(), (Option)None$.MODULE$, true, this.timeZoneId());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(actualSpec);
        PartitionSpec $org_scalatest_assert_macro_right = spec;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 388));
    }

    public static final /* synthetic */ ParquetData $anonfun$new$24(int i) {
        return new ParquetData(i, ((Object)BoxesRunTime.boxToInteger((int)i)).toString());
    }

    public static final /* synthetic */ boolean $anonfun$new$23(ParquetPartitionDiscoverySuite $this, File base$1, int pi$1, String ps) {
        File dir = $this.makePartitionDir(base$1, $this.defaultPartitionName(), (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pi"), (Object)BoxesRunTime.boxToInteger((int)pi$1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ps"), (Object)ps)}));
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(ParquetPartitionDiscoverySuite.class.getClassLoader());
        public final class Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.execution.datasources.parquet.ParquetData").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator1$1(ParquetPartitionDiscoverySuite $outer) {
            }
        }
        $this.makeParquetFile((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable & scala.Serializable)i -> ParquetPartitionDiscoverySuite.$anonfun$new$24(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom()), dir, ClassTag$.MODULE$.apply(ParquetData.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator1$1(null)));
        return new File(dir.toString(), "_temporary").mkdir();
    }

    public static final /* synthetic */ Seq $anonfun$new$28(int i$1, int pi) {
        return (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))).map((Function1 & Serializable & scala.Serializable)ps -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i$1), ((Object)BoxesRunTime.boxToInteger((int)i$1)).toString(), BoxesRunTime.boxToInteger((int)pi), ps})), Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ Seq $anonfun$new$27(int i) {
        return (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))).flatMap((Function1 & Serializable & scala.Serializable)pi -> ParquetPartitionDiscoverySuite.$anonfun$new$28(i, BoxesRunTime.unboxToInt((Object)pi)), Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ Seq $anonfun$new$32(int i$2, int pi) {
        return (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))).map((Function1 & Serializable & scala.Serializable)_ -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i$2), BoxesRunTime.boxToInteger((int)pi)})), Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ Seq $anonfun$new$31(int i) {
        return (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))).flatMap((Function1 & Serializable & scala.Serializable)pi -> ParquetPartitionDiscoverySuite.$anonfun$new$32(i, BoxesRunTime.unboxToInt((Object)pi)), Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ Seq $anonfun$new$35(int i) {
        return (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))).map((Function1 & Serializable & scala.Serializable)ps -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), ((Object)BoxesRunTime.boxToInteger((int)i)).toString(), BoxesRunTime.boxToInteger((int)1), ps})), Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ Seq $anonfun$new$38(int i) {
        return (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))).map((Function1 & Serializable & scala.Serializable)pi -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), ((Object)BoxesRunTime.boxToInteger((int)i)).toString(), BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)pi)), "foo"})), Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ void $anonfun$new$21(ParquetPartitionDiscoverySuite $this, File base) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)pi -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))).foreach((Function1 & Serializable & scala.Serializable)ps -> BoxesRunTime.boxToBoolean((boolean)ParquetPartitionDiscoverySuite.$anonfun$new$23($this, base, pi, ps))));
        new File(base.getCanonicalPath(), "_temporary").mkdir();
        $this.spark().read().parquet(base.getCanonicalPath()).createOrReplaceTempView("t");
        $this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT * FROM t"), (Seq<Row>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).flatMap((Function1 & Serializable & scala.Serializable)i -> ParquetPartitionDiscoverySuite.$anonfun$new$27(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT intField, pi FROM t"), (Seq<Row>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).flatMap((Function1 & Serializable & scala.Serializable)i -> ParquetPartitionDiscoverySuite.$anonfun$new$31(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT * FROM t WHERE pi = 1"), (Seq<Row>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).flatMap((Function1 & Serializable & scala.Serializable)i -> ParquetPartitionDiscoverySuite.$anonfun$new$35(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT * FROM t WHERE ps = 'foo'"), (Seq<Row>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).flatMap((Function1 & Serializable & scala.Serializable)i -> ParquetPartitionDiscoverySuite.$anonfun$new$38(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())));
        });
    }

    public static final /* synthetic */ ParquetData $anonfun$new$42(int i) {
        return new ParquetData(i, ((Object)BoxesRunTime.boxToInteger((int)i)).toString());
    }

    public static final /* synthetic */ void $anonfun$new$41(ParquetPartitionDiscoverySuite $this, File base) {
        int pi = 1;
        String ps = "foo";
        File path = $this.makePartitionDir(base, $this.defaultPartitionName(), (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pi"), (Object)BoxesRunTime.boxToInteger((int)pi)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ps"), (Object)ps)}));
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(ParquetPartitionDiscoverySuite.class.getClassLoader());
        public final class Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.execution.datasources.parquet.ParquetData").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator2$1(ParquetPartitionDiscoverySuite $outer) {
            }
        }
        $this.makeParquetFile((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable & scala.Serializable)i -> ParquetPartitionDiscoverySuite.$anonfun$new$42(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom()), path, ClassTag$.MODULE$.apply(ParquetData.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator2$1(null)));
        Dataset baseDf = $this.spark().read().parquet(base.getCanonicalPath());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(baseDf.schema().map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.name(), Seq$.MODULE$.canBuildFrom()));
        Seq $org_scalatest_assert_macro_right = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intField", "stringField", "pi", "ps"}));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 528));
        Dataset partDf = $this.spark().read().parquet(path.getCanonicalPath());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(partDf.schema().map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.name(), Seq$.MODULE$.canBuildFrom()));
        Seq $org_scalatest_assert_macro_right2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intField", "stringField"}));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 532));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])path.listFiles())).foreach((Function1 & Serializable & scala.Serializable)f -> {
            BoxedUnit boxedUnit;
            if (!f.getName().startsWith("_") && f.getName().toLowerCase(Locale.ROOT).endsWith(".parquet")) {
                Dataset df = $this.spark().read().parquet(f.getCanonicalPath());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(df.schema().map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.name(), Seq$.MODULE$.canBuildFrom()));
                Seq $org_scalatest_assert_macro_right = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intField", "stringField"}));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                boxedUnit = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 539));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])path.listFiles())).foreach((Function1 & Serializable & scala.Serializable)f -> {
            BoxedUnit boxedUnit;
            if (!f.getName().startsWith("_") && f.getName().toLowerCase(Locale.ROOT).endsWith(".parquet")) {
                Dataset df = $this.spark().read().option("basePath", base.getCanonicalPath()).parquet(f.getCanonicalPath());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(df.schema().map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.name(), Seq$.MODULE$.canBuildFrom()));
                Seq $org_scalatest_assert_macro_right = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intField", "stringField", "pi", "ps"}));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                boxedUnit = $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 551));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
    }

    public static final /* synthetic */ ParquetDataWithKey $anonfun$new$53(int pi$4, String ps$1, int i) {
        return new ParquetDataWithKey(i, pi$4, ((Object)BoxesRunTime.boxToInteger((int)i)).toString(), ps$1);
    }

    public static final /* synthetic */ void $anonfun$new$52(ParquetPartitionDiscoverySuite $this, int pi$4, File base$3, String ps) {
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(ParquetPartitionDiscoverySuite.class.getClassLoader());
        public final class Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.execution.datasources.parquet.ParquetDataWithKey").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator3$1(ParquetPartitionDiscoverySuite $outer) {
            }
        }
        $this.makeParquetFile((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable & scala.Serializable)i -> ParquetPartitionDiscoverySuite.$anonfun$new$53(pi$4, ps, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom()), $this.makePartitionDir(base$3, $this.defaultPartitionName(), (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pi"), (Object)BoxesRunTime.boxToInteger((int)pi$4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ps"), (Object)ps)})), ClassTag$.MODULE$.apply(ParquetDataWithKey.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator3$1(null)));
    }

    public static final /* synthetic */ Seq $anonfun$new$57(int i$5, int pi) {
        return (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))).map((Function1 & Serializable & scala.Serializable)ps -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i$5), BoxesRunTime.boxToInteger((int)pi), ((Object)BoxesRunTime.boxToInteger((int)i$5)).toString(), ps})), Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ Seq $anonfun$new$56(int i) {
        return (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))).flatMap((Function1 & Serializable & scala.Serializable)pi -> ParquetPartitionDiscoverySuite.$anonfun$new$57(i, BoxesRunTime.unboxToInt((Object)pi)), Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ Seq $anonfun$new$61(int i$6, int pi) {
        return (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))).map((Function1 & Serializable & scala.Serializable)_ -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i$6), BoxesRunTime.boxToInteger((int)pi)})), Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ Seq $anonfun$new$60(int i) {
        return (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))).flatMap((Function1 & Serializable & scala.Serializable)pi -> ParquetPartitionDiscoverySuite.$anonfun$new$61(i, BoxesRunTime.unboxToInt((Object)pi)), Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ Seq $anonfun$new$64(int i) {
        return (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))).map((Function1 & Serializable & scala.Serializable)ps -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), BoxesRunTime.boxToInteger((int)1), ((Object)BoxesRunTime.boxToInteger((int)i)).toString(), ps})), Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ Seq $anonfun$new$67(int i) {
        return (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))).map((Function1 & Serializable & scala.Serializable)pi -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)pi)), ((Object)BoxesRunTime.boxToInteger((int)i)).toString(), "foo"})), Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ void $anonfun$new$50(ParquetPartitionDiscoverySuite $this, File base) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)pi -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))).foreach((Function1 & Serializable & scala.Serializable)ps -> {
            ParquetPartitionDiscoverySuite.$anonfun$new$52($this, pi, base, ps);
            return BoxedUnit.UNIT;
        }));
        $this.spark().read().parquet(base.getCanonicalPath()).createOrReplaceTempView("t");
        $this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT * FROM t"), (Seq<Row>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).flatMap((Function1 & Serializable & scala.Serializable)i -> ParquetPartitionDiscoverySuite.$anonfun$new$56(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT intField, pi FROM t"), (Seq<Row>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).flatMap((Function1 & Serializable & scala.Serializable)i -> ParquetPartitionDiscoverySuite.$anonfun$new$60(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT * FROM t WHERE pi = 1"), (Seq<Row>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).flatMap((Function1 & Serializable & scala.Serializable)i -> ParquetPartitionDiscoverySuite.$anonfun$new$64(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT * FROM t WHERE ps = 'foo'"), (Seq<Row>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).flatMap((Function1 & Serializable & scala.Serializable)i -> ParquetPartitionDiscoverySuite.$anonfun$new$67(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())));
        });
    }

    public static final /* synthetic */ ParquetData $anonfun$new$73(int i) {
        return new ParquetData(i, ((Object)BoxesRunTime.boxToInteger((int)i)).toString());
    }

    public static final /* synthetic */ void $anonfun$new$72(ParquetPartitionDiscoverySuite $this, File base$4, Object pi$7, String ps) {
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(ParquetPartitionDiscoverySuite.class.getClassLoader());
        public final class Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.execution.datasources.parquet.ParquetData").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator4$1(ParquetPartitionDiscoverySuite $outer) {
            }
        }
        $this.makeParquetFile((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable & scala.Serializable)i -> ParquetPartitionDiscoverySuite.$anonfun$new$73(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom()), $this.makePartitionDir(base$4, $this.defaultPartitionName(), (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pi"), pi$7), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ps"), (Object)ps)})), ClassTag$.MODULE$.apply(ParquetData.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator4$1(null)));
    }

    public static final /* synthetic */ void $anonfun$new$71(ParquetPartitionDiscoverySuite $this, File base$4, Object pi) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", null}))).foreach((Function1 & Serializable & scala.Serializable)ps -> {
            ParquetPartitionDiscoverySuite.$anonfun$new$72($this, base$4, pi, ps);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Seq $anonfun$new$76(int i) {
        return (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), null}))).flatMap((Function1 & Serializable & scala.Serializable)pi -> (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", null}))).map((Function1 & Serializable & scala.Serializable)ps -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), ((Object)BoxesRunTime.boxToInteger((int)i)).toString(), pi, ps})), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ Seq $anonfun$new$80(int i) {
        return (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", null}))).map((Function1 & Serializable & scala.Serializable)ps -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), ((Object)BoxesRunTime.boxToInteger((int)i)).toString(), null, ps})), Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ Seq $anonfun$new$83(int i) {
        return (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), null}))).map((Function1 & Serializable & scala.Serializable)pi -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), ((Object)BoxesRunTime.boxToInteger((int)i)).toString(), pi, null})), Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ void $anonfun$new$70(ParquetPartitionDiscoverySuite $this, File base) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), null}))).foreach((Function1 & Serializable & scala.Serializable)pi -> {
            ParquetPartitionDiscoverySuite.$anonfun$new$71($this, base, pi);
            return BoxedUnit.UNIT;
        });
        Dataset parquetRelation = $this.spark().read().format("parquet").load(base.getCanonicalPath());
        parquetRelation.createOrReplaceTempView("t");
        $this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT * FROM t"), (Seq<Row>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).flatMap((Function1 & Serializable & scala.Serializable)i -> ParquetPartitionDiscoverySuite.$anonfun$new$76(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT * FROM t WHERE pi IS NULL"), (Seq<Row>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).flatMap((Function1 & Serializable & scala.Serializable)i -> ParquetPartitionDiscoverySuite.$anonfun$new$80(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT * FROM t WHERE ps IS NULL"), (Seq<Row>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).flatMap((Function1 & Serializable & scala.Serializable)i -> ParquetPartitionDiscoverySuite.$anonfun$new$83(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())));
        });
    }

    public static final /* synthetic */ ParquetDataWithKey $anonfun$new$89(int pi$9, String ps$2, int i) {
        return new ParquetDataWithKey(i, pi$9, ((Object)BoxesRunTime.boxToInteger((int)i)).toString(), ps$2);
    }

    public static final /* synthetic */ void $anonfun$new$88(ParquetPartitionDiscoverySuite $this, int pi$9, File base$5, String ps) {
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(ParquetPartitionDiscoverySuite.class.getClassLoader());
        public final class Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.execution.datasources.parquet.ParquetDataWithKey").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator5$1(ParquetPartitionDiscoverySuite $outer) {
            }
        }
        $this.makeParquetFile((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable & scala.Serializable)i -> ParquetPartitionDiscoverySuite.$anonfun$new$89(pi$9, ps, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom()), $this.makePartitionDir(base$5, $this.defaultPartitionName(), (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pi"), (Object)BoxesRunTime.boxToInteger((int)pi$9)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ps"), (Object)ps)})), ClassTag$.MODULE$.apply(ParquetDataWithKey.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator5$1(null)));
    }

    public static final /* synthetic */ Seq $anonfun$new$93(int i$12, int pi) {
        return (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", null}))).map((Function1 & Serializable & scala.Serializable)ps -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i$12), BoxesRunTime.boxToInteger((int)pi), ((Object)BoxesRunTime.boxToInteger((int)i$12)).toString(), ps})), Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ Seq $anonfun$new$92(int i) {
        return (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))).flatMap((Function1 & Serializable & scala.Serializable)pi -> ParquetPartitionDiscoverySuite.$anonfun$new$93(i, BoxesRunTime.unboxToInt((Object)pi)), Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ Seq $anonfun$new$96(int i) {
        return (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))).map((Function1 & Serializable & scala.Serializable)pi -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)pi)), ((Object)BoxesRunTime.boxToInteger((int)i)).toString(), null})), Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ void $anonfun$new$86(ParquetPartitionDiscoverySuite $this, File base) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)pi -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", null}))).foreach((Function1 & Serializable & scala.Serializable)ps -> {
            ParquetPartitionDiscoverySuite.$anonfun$new$88($this, pi, base, ps);
            return BoxedUnit.UNIT;
        }));
        Dataset parquetRelation = $this.spark().read().format("parquet").load(base.getCanonicalPath());
        parquetRelation.createOrReplaceTempView("t");
        $this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT * FROM t"), (Seq<Row>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).flatMap((Function1 & Serializable & scala.Serializable)i -> ParquetPartitionDiscoverySuite.$anonfun$new$92(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT * FROM t WHERE ps IS NULL"), (Seq<Row>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).flatMap((Function1 & Serializable & scala.Serializable)i -> ParquetPartitionDiscoverySuite.$anonfun$new$96(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())));
        });
    }

    public static final /* synthetic */ Tuple1 $anonfun$new$100(int i) {
        return new Tuple1.mcI.sp(i);
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$101(int i) {
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)i), (Object)((Object)BoxesRunTime.boxToInteger((int)i)).toString());
    }

    public static final /* synthetic */ void $anonfun$new$99(ParquetPartitionDiscoverySuite $this, File base) {
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(ParquetPartitionDiscoverySuite.class.getClassLoader());
        public final class Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator10$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple1"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$));
            }

            public Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator10$1(ParquetPartitionDiscoverySuite $outer) {
            }
        }
        $this.makeParquetFile((Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable & scala.Serializable)i -> ParquetPartitionDiscoverySuite.$anonfun$new$100(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom()), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator10$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intField"})), $this.makePartitionDir(base, $this.defaultPartitionName(), (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pi"), (Object)BoxesRunTime.boxToInteger((int)1))})), ClassTag$.MODULE$.Nothing(), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing());
        JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(ParquetPartitionDiscoverySuite.class.getClassLoader());
        public final class Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator18$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator18$1(ParquetPartitionDiscoverySuite $outer) {
            }
        }
        $this.makeParquetFile((Dataset<Row>)$this.testImplicits().localSeqToDatasetHolder((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable & scala.Serializable)i -> ParquetPartitionDiscoverySuite.$anonfun$new$101(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom()), $this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator18$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"intField", "stringField"})), $this.makePartitionDir(base, $this.defaultPartitionName(), (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pi"), (Object)BoxesRunTime.boxToInteger((int)2))})), ClassTag$.MODULE$.Nothing(), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Nothing());
        $this.spark().read().option("mergeSchema", "true").format("parquet").load(base.getCanonicalPath()).createOrReplaceTempView("t");
        $this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT * FROM t"), (Seq<Row>)((Seq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable & scala.Serializable)i -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), null, BoxesRunTime.boxToInteger((int)1)})), IndexedSeq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable & scala.Serializable)i -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), ((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))).toString(), BoxesRunTime.boxToInteger((int)2)})), IndexedSeq$.MODULE$.canBuildFrom()), IndexedSeq$.MODULE$.canBuildFrom()))));
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$108(int i) {
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)i), (Object)((Object)BoxesRunTime.boxToInteger((int)i)).toString());
    }

    public static final /* synthetic */ void $anonfun$new$107(ParquetPartitionDiscoverySuite $this, File dir) {
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(ParquetPartitionDiscoverySuite.class.getClassLoader());
        public final class Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator26$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator26$1(ParquetPartitionDiscoverySuite $outer) {
            }
        }
        $this.testImplicits().localSeqToDatasetHolder((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable & scala.Serializable)i -> ParquetPartitionDiscoverySuite.$anonfun$new$108(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom()), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator26$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})).write().parquet(dir.getCanonicalPath());
        QueryExecution queryExecution = $this.spark().read().parquet(dir.getCanonicalPath()).queryExecution();
        queryExecution.analyzed().collectFirst((PartialFunction)new scala.Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ParquetPartitionDiscoverySuite $outer;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                HadoopFsRelation hadoopFsRelation;
                FileIndex location;
                LogicalRelation logicalRelation;
                BaseRelation baseRelation;
                A1 A1 = x1;
                if (A1 instanceof LogicalRelation && (baseRelation = (logicalRelation = (LogicalRelation)A1).relation()) instanceof HadoopFsRelation && (location = (hadoopFsRelation = (HadoopFsRelation)baseRelation).location()) instanceof PartitioningAwareFileIndex) {
                    PartitioningAwareFileIndex partitioningAwareFileIndex = (PartitioningAwareFileIndex)location;
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(partitioningAwareFileIndex.partitionSpec());
                    PartitionSpec $org_scalatest_assert_macro_right = PartitionSpec$.MODULE$.emptySpec();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    object = this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 710));
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                HadoopFsRelation hadoopFsRelation;
                FileIndex location;
                LogicalRelation logicalRelation;
                BaseRelation baseRelation;
                LogicalPlan logicalPlan = x1;
                boolean bl = logicalPlan instanceof LogicalRelation && (baseRelation = (logicalRelation = (LogicalRelation)logicalPlan).relation()) instanceof HadoopFsRelation && (location = (hadoopFsRelation = (HadoopFsRelation)baseRelation).location()) instanceof PartitioningAwareFileIndex;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.fail(new StringBuilder(48).append("Expecting a matching HadoopFsRelation, but got:\n").append(queryExecution).toString(), new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 712)));
    }

    public static final /* synthetic */ void $anonfun$new$111(ParquetPartitionDiscoverySuite $this, File dir) {
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(ParquetPartitionDiscoverySuite.class.getClassLoader());
        public final class Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator34$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator34$1(ParquetPartitionDiscoverySuite $outer) {
            }
        }
        Dataset df = $this.testImplicits().localSeqToDatasetHolder((Seq)((TraversableLike)((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/", "[]", "?"}))).zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.swap(), Seq$.MODULE$.canBuildFrom()), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator34$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"i", "s"}));
        df.write().format("parquet").partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"s"})).save(dir.getCanonicalPath());
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().read().parquet(dir.getCanonicalPath()), (Seq<Row>)Predef$.MODULE$.wrapRefArray((Object[])df.collect()));
    }

    public static final /* synthetic */ void $anonfun$new$116(ParquetPartitionDiscoverySuite $this, Dataset df$1, Seq partitionColumns$1, StructType schema$1, Row row$1, File dir) {
        df$1.write().format("parquet").partitionBy((Seq)partitionColumns$1.map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.name(), Seq$.MODULE$.canBuildFrom())).save(dir.toString());
        Seq fields = (Seq)schema$1.map((Function1 & Serializable & scala.Serializable)f -> Column$.MODULE$.apply(f.name()).cast(f.dataType()), Seq$.MODULE$.canBuildFrom());
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().read().load(dir.toString()).select(fields), row$1);
    }

    public static final /* synthetic */ void $anonfun$new$120(ParquetPartitionDiscoverySuite $this, Dataset df$1, Seq partitionColumns$1, StructType schema$1, Row row$1, File dir) {
        df$1.write().option(DateTimeUtils$.MODULE$.TIMEZONE_OPTION(), "GMT").format("parquet").partitionBy((Seq)partitionColumns$1.map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.name(), Seq$.MODULE$.canBuildFrom())).save(dir.toString());
        Seq fields = (Seq)schema$1.map((Function1 & Serializable & scala.Serializable)f -> Column$.MODULE$.apply(f.name()).cast(f.dataType()), Seq$.MODULE$.canBuildFrom());
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().read().option(DateTimeUtils$.MODULE$.TIMEZONE_OPTION(), "GMT").load(dir.toString()).select(fields), row$1);
    }

    public static final /* synthetic */ void $anonfun$new$126(ParquetPartitionDiscoverySuite $this, Dataset df$2, Seq partitionColumns$2, StructType schema$2, Row row$2, File dir) {
        df$2.write().format("parquet").partitionBy((Seq)partitionColumns$2.map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.name(), Seq$.MODULE$.canBuildFrom())).save(dir.toString());
        Seq fields = (Seq)schema$2.map((Function1 & Serializable & scala.Serializable)f -> Column$.MODULE$.apply(f.name()), Seq$.MODULE$.canBuildFrom());
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().read().load(dir.toString()).select(fields), row$2);
    }

    public static final /* synthetic */ void $anonfun$new$130(ParquetPartitionDiscoverySuite $this, Dataset df$2, Seq partitionColumns$2, StructType schema$2, Row row$2, File dir) {
        df$2.write().option(DateTimeUtils$.MODULE$.TIMEZONE_OPTION(), "GMT").format("parquet").partitionBy((Seq)partitionColumns$2.map((Function1 & Serializable & scala.Serializable)x$19 -> x$19.name(), Seq$.MODULE$.canBuildFrom())).save(dir.toString());
        Seq fields = (Seq)schema$2.map((Function1 & Serializable & scala.Serializable)f -> Column$.MODULE$.apply(f.name()), Seq$.MODULE$.canBuildFrom());
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().read().option(DateTimeUtils$.MODULE$.TIMEZONE_OPTION(), "GMT").load(dir.toString()).select(fields), row$2);
    }

    public static final /* synthetic */ Tuple4 $anonfun$new$136(int i) {
        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)i), (Object)BoxesRunTime.boxToInteger((int)i), (Object)BoxesRunTime.boxToInteger((int)i), (Object)BoxesRunTime.boxToInteger((int)i));
    }

    public static final /* synthetic */ void $anonfun$new$135(ParquetPartitionDiscoverySuite $this, File dir) {
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(ParquetPartitionDiscoverySuite.class.getClassLoader());
        public final class Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator42$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
            }

            public Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator42$1(ParquetPartitionDiscoverySuite $outer) {
            }
        }
        Dataset df = $this.testImplicits().localSeqToDatasetHolder((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3).map((Function1 & Serializable & scala.Serializable)i -> ParquetPartitionDiscoverySuite.$anonfun$new$136(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom()), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator42$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c", "d"}));
        df.write().format("parquet").partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b", "c", "d"})).save(dir.getCanonicalPath());
        Files.touch((File)new File(new StringBuilder(4).append(dir.getCanonicalPath()).append("/b=1").toString(), ".DS_Store"));
        Files.createParentDirs((File)new File(new StringBuilder(17).append(dir.getCanonicalPath()).append("/b=1/c=1/.foo/bar").toString()));
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().read().format("parquet").load(dir.getCanonicalPath()), (Dataset<Row>)df);
    }

    public static final /* synthetic */ Tuple4 $anonfun$new$140(int i) {
        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)i), (Object)BoxesRunTime.boxToInteger((int)i), (Object)BoxesRunTime.boxToInteger((int)i), (Object)BoxesRunTime.boxToInteger((int)i));
    }

    public static final /* synthetic */ void $anonfun$new$139(ParquetPartitionDiscoverySuite $this, File dir) {
        File tablePath = new File(dir, "key=value");
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(ParquetPartitionDiscoverySuite.class.getClassLoader());
        public final class Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator50$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
            }

            public Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator50$1(ParquetPartitionDiscoverySuite $outer) {
            }
        }
        Dataset df = $this.testImplicits().localSeqToDatasetHolder((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3).map((Function1 & Serializable & scala.Serializable)i -> ParquetPartitionDiscoverySuite.$anonfun$new$140(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom()), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator50$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c", "d"}));
        df.write().format("parquet").partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b", "c", "d"})).save(tablePath.getCanonicalPath());
        Files.touch((File)new File(new StringBuilder(1).append(tablePath.getCanonicalPath()).append("/").toString(), "_SUCCESS"));
        Files.createParentDirs((File)new File(new StringBuilder(17).append(dir.getCanonicalPath()).append("/b=1/c=1/.foo/bar").toString()));
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().read().format("parquet").load(tablePath.getCanonicalPath()), (Dataset<Row>)df);
    }

    public static final /* synthetic */ Tuple4 $anonfun$new$143(int i) {
        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)i), (Object)BoxesRunTime.boxToInteger((int)i), (Object)BoxesRunTime.boxToInteger((int)i), (Object)BoxesRunTime.boxToInteger((int)i));
    }

    public static final /* synthetic */ void $anonfun$new$142(ParquetPartitionDiscoverySuite $this, File dir) {
        File path = new File(dir, "key=value");
        File tablePath = new File(path, "table");
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(ParquetPartitionDiscoverySuite.class.getClassLoader());
        public final class Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator58$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
            }

            public Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator58$1(ParquetPartitionDiscoverySuite $outer) {
            }
        }
        Dataset df = $this.testImplicits().localSeqToDatasetHolder((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3).map((Function1 & Serializable & scala.Serializable)i -> ParquetPartitionDiscoverySuite.$anonfun$new$143(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom()), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator58$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c", "d"}));
        df.write().format("parquet").partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b", "c", "d"})).save(tablePath.getCanonicalPath());
        Files.touch((File)new File(new StringBuilder(1).append(tablePath.getCanonicalPath()).append("/").toString(), "_SUCCESS"));
        Files.createParentDirs((File)new File(new StringBuilder(17).append(dir.getCanonicalPath()).append("/b=1/c=1/.foo/bar").toString()));
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().read().format("parquet").load(tablePath.getCanonicalPath()), (Dataset<Row>)df);
    }

    public static final /* synthetic */ Tuple4 $anonfun$new$147(int i) {
        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)i), (Object)BoxesRunTime.boxToInteger((int)i), (Object)BoxesRunTime.boxToInteger((int)i), (Object)BoxesRunTime.boxToInteger((int)i));
    }

    public static final /* synthetic */ void $anonfun$new$146(ParquetPartitionDiscoverySuite $this, File dir) {
        File tablePath = new File(dir, "table");
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(ParquetPartitionDiscoverySuite.class.getClassLoader());
        public final class Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator66$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
            }

            public Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator66$1(ParquetPartitionDiscoverySuite $outer) {
            }
        }
        Dataset df = $this.testImplicits().localSeqToDatasetHolder((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3).map((Function1 & Serializable & scala.Serializable)i -> ParquetPartitionDiscoverySuite.$anonfun$new$147(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom()), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator66$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c", "d"}));
        df.write().format("parquet").partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b", "c", "d"})).save(tablePath.getCanonicalPath());
        Dataset twoPartitionsDF = $this.spark().read().option("basePath", tablePath.getCanonicalPath()).parquet((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(4).append(tablePath.getCanonicalPath()).append("/b=1").toString(), new StringBuilder(4).append(tablePath.getCanonicalPath()).append("/b=2").toString()}));
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> twoPartitionsDF, (Dataset<Row>)df.filter("b != 3"));
        $this.intercept((Function0 & Serializable & scala.Serializable)() -> $this.spark().read().parquet((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(4).append(tablePath.getCanonicalPath()).append("/b=1").toString(), new StringBuilder(4).append(tablePath.getCanonicalPath()).append("/b=2").toString()})), ClassTag$.MODULE$.apply(AssertionError.class), new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 890));
    }

    private final void check$5(String path, String basePath, Dataset expectedDf) {
        Dataset testDf = this.spark().read().option("basePath", basePath).parquet(path);
        this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> testDf, (Dataset<Row>)expectedDf);
    }

    public static final /* synthetic */ void $anonfun$new$151(ParquetPartitionDiscoverySuite $this, File dir) {
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(ParquetPartitionDiscoverySuite.class.getClassLoader());
        public final class Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator74$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))));
            }

            public Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator74$1(ParquetPartitionDiscoverySuite $outer) {
            }
        }
        Dataset df = $this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)"foo", (Object)BoxesRunTime.boxToInteger((int)100)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)"bar", (Object)BoxesRunTime.boxToInteger((int)200)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)"foo", (Object)BoxesRunTime.boxToInteger((int)300)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)"bar", (Object)BoxesRunTime.boxToInteger((int)400))})), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator74$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"p1", "p2", "v"}));
        df.write().mode(SaveMode.Overwrite).partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"p1", "p2"})).parquet(dir.getCanonicalPath());
        Dataset resultDf = df.select("v", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"p1", "p2"}));
        $this.check$5(String.valueOf(dir), String.valueOf(dir), resultDf);
        $this.check$5(new StringBuilder(2).append(dir).append("/*").toString(), String.valueOf(dir), resultDf);
        $this.check$5(new StringBuilder(4).append(dir).append("/*/*").toString(), String.valueOf(dir), resultDf);
        $this.check$5(new StringBuilder(6).append(dir).append("/*/*/*").toString(), String.valueOf(dir), resultDf);
        $this.check$5(new StringBuilder(7).append(dir).append("/p1=1/*").toString(), new StringBuilder(6).append(dir).append("/p1=1/").toString(), resultDf.filter("p1 = 1").drop("p1"));
        $this.check$5(new StringBuilder(14).append(dir).append("/p1=1/p2=foo/*").toString(), new StringBuilder(6).append(dir).append("/p1=1/").toString(), resultDf.filter("p1 = 1").filter("p2 = 'foo'").drop("p1"));
        $this.check$5(new StringBuilder(14).append(dir).append("/p1=1/p2=foo/*").toString(), new StringBuilder(13).append(dir).append("/p1=1/p2=foo/").toString(), resultDf.filter("p1 = 1").filter("p2 = 'foo'").drop((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"p1", "p2"})));
    }

    public static final /* synthetic */ Tuple4 $anonfun$new$157(int i) {
        return new Tuple4((Object)BoxesRunTime.boxToInteger((int)i), (Object)BoxesRunTime.boxToInteger((int)i), (Object)BoxesRunTime.boxToInteger((int)i), (Object)BoxesRunTime.boxToInteger((int)i));
    }

    public static final /* synthetic */ void $anonfun$new$156(ParquetPartitionDiscoverySuite $this, File dir) {
        File tablePath = new File(dir, "table");
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(ParquetPartitionDiscoverySuite.class.getClassLoader());
        public final class Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator82$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
            }

            public Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator82$1(ParquetPartitionDiscoverySuite $outer) {
            }
        }
        Dataset df = $this.testImplicits().localSeqToDatasetHolder((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3).map((Function1 & Serializable & scala.Serializable)i -> ParquetPartitionDiscoverySuite.$anonfun$new$157(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom()), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator82$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c", "d"}));
        df.write().format("parquet").partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b", "c", "d"})).save(tablePath.getCanonicalPath());
        Files.touch((File)new File(new StringBuilder(4).append(tablePath.getCanonicalPath()).append("/b=1").toString(), "_SUCCESS"));
        Files.touch((File)new File(new StringBuilder(8).append(tablePath.getCanonicalPath()).append("/b=1/c=1").toString(), "_SUCCESS"));
        Files.touch((File)new File(new StringBuilder(12).append(tablePath.getCanonicalPath()).append("/b=1/c=1/d=1").toString(), "_SUCCESS"));
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().read().format("parquet").load(tablePath.getCanonicalPath()), (Dataset<Row>)df);
    }

    private static final String makeExpectedMessage$1(Seq colNameLists, Seq paths) {
        String conflictingColNameLists = ((TraversableOnce)((TraversableLike)colNameLists.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String list = (String)tuple2._1();
            int index = tuple2._2$mcI$sp();
            String string = new StringBuilder(31).append("\tPartition column name list #").append(index).append(": ").append(list).toString();
            return string;
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n", "\n", "\n");
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(366).append("Conflicting partition column names detected:\n         |").append(conflictingColNameLists).append("\n         |For partitioned table directories, data files should only live in leaf directories.\n         |And directories at the same level should have the same partition column name.\n         |Please check the following directories for unexpected files or inconsistent partition column names:\n         |").append(((TraversableOnce)paths.map((Function1 & Serializable & scala.Serializable)x$20 -> new StringBuilder(1).append("\t").append((String)x$20).toString(), Seq$.MODULE$.canBuildFrom())).mkString("\n", "\n", "")).append("\n       ").toString())).stripMargin().trim();
    }

    public static final /* synthetic */ void $anonfun$new$167(ParquetPartitionDiscoverySuite $this, File dir) {
        String path = dir.getCanonicalPath();
        $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"parquet.summary.metadata.level"), (Object)"ALL"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.sql.sources.commitProtocolClass"), (Object)SQLHadoopMapReduceCommitProtocol.class.getCanonicalName())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.spark().range(3L).write().parquet(new StringBuilder(10).append(path).append("/p0=0/p1=0").toString()));
        File p0 = new File(path, "p0=0");
        File p1 = new File(p0, "p1=0");
        Files.copy((File)new File(p1, "_metadata"), (File)new File(p0, "_metadata"));
        Files.copy((File)new File(p1, "_common_metadata"), (File)new File(p0, "_common_metadata"));
        Files.touch((File)new File(p0, ".dummy"));
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().read().parquet(String.valueOf(path)), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0)}))}))));
    }

    public static final /* synthetic */ void $anonfun$new$172(ParquetPartitionDiscoverySuite $this, File dir) {
        String path = dir.getCanonicalPath();
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(ParquetPartitionDiscoverySuite.class.getClassLoader());
        public final class Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator90$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator90$1(ParquetPartitionDiscoverySuite $outer) {
            }
        }
        Dataset df = $this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcJD.sp(1L, 2.0)})), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator90$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"}));
        df.write().parquet(new StringBuilder(4).append(path).append("/a=1").toString());
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().read().parquet(String.valueOf(path)), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToDouble((double)2.0)}))}))));
    }

    public static final /* synthetic */ void $anonfun$new$175(ParquetPartitionDiscoverySuite $this, File tempDir) {
        String output = new File(tempDir, "output").toString();
        String checkpoint = new File(tempDir, "chkpoint").toString();
        try {
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(ParquetPartitionDiscoverySuite.class.getClassLoader());
            public final class Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator94$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator94$1(ParquetPartitionDiscoverySuite $outer) {
                }
            }
            MemoryStream stream = MemoryStream$.MODULE$.apply($this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator94$1(null))), $this.sqlContext());
            Dataset df = stream.toDS().toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"time", "value"}));
            StreamingQuery sq = df.writeStream().option("checkpointLocation", checkpoint).format("parquet").partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"time"})).start(output);
            stream.addData((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"2017-01-01-00", (Object)BoxesRunTime.boxToInteger((int)1)), new Tuple2((Object)"2017-01-01-01", (Object)BoxesRunTime.boxToInteger((int)2))}));
            sq.processAllAvailable();
            StructType schema = new StructType().add("time", (DataType)StringType$.MODULE$).add("value", (DataType)IntegerType$.MODULE$);
            Dataset readBack = $this.spark().read().schema(schema).parquet(output);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(readBack.schema().toSet());
            Set $org_scalatest_assert_macro_right = schema.toSet();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1102));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> readBack, (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2017-01-01-00", BoxesRunTime.boxToInteger((int)1)})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2017-01-01-01", BoxesRunTime.boxToInteger((int)2)}))}))));
        }
        finally {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.spark().streams().active())).foreach((Function1 & Serializable & scala.Serializable)x$21 -> {
                x$21.stop();
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ void $anonfun$new$179(ParquetPartitionDiscoverySuite $this, Dataset df$3, File path) {
        df$3.write().format("parquet").partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"str"})).save(path.getAbsolutePath());
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().read().load(path.getAbsolutePath()), (Dataset<Row>)df$3);
    }

    public static final /* synthetic */ void $anonfun$new$182(ParquetPartitionDiscoverySuite $this, File path) {
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(ParquetPartitionDiscoverySuite.class.getClassLoader());
        public final class Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator110$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator110$1(ParquetPartitionDiscoverySuite $outer) {
            }
        }
        Dataset df = $this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)"2014-01-01"), new Tuple2((Object)BoxesRunTime.boxToInteger((int)2), (Object)"2016-01-01"), new Tuple2((Object)BoxesRunTime.boxToInteger((int)3), (Object)"2015-01-01 00:01:00")})), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator110$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"i", "ts"}));
        df.write().format("parquet").partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ts"})).save(path.getAbsolutePath());
        Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), Timestamp.valueOf("2014-01-01 00:00:00")}));
        Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), Timestamp.valueOf("2016-01-01 00:00:00")}));
        Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), Timestamp.valueOf("2015-01-01 00:01:00")}));
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().read().load(path.getAbsolutePath()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row3).$colon$colon((Object)row2).$colon$colon((Object)row));
    }

    public static final /* synthetic */ void $anonfun$new$184(ParquetPartitionDiscoverySuite $this, File path) {
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(ParquetPartitionDiscoverySuite.class.getClassLoader());
        public final class Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator118$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator118$1(ParquetPartitionDiscoverySuite $outer) {
            }
        }
        Dataset df = $this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)"1"), new Tuple2((Object)BoxesRunTime.boxToInteger((int)2), (Object)"3"), new Tuple2((Object)BoxesRunTime.boxToInteger((int)3), (Object)new StringOps(Predef$.MODULE$.augmentString("2")).$times(30))})), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator118$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"i", "decimal"}));
        df.write().format("parquet").partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"decimal"})).save(path.getAbsolutePath());
        Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), package$.MODULE$.BigDecimal().apply("1")}));
        Row row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), package$.MODULE$.BigDecimal().apply("3")}));
        Row row3 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), package$.MODULE$.BigDecimal().apply(new StringOps(Predef$.MODULE$.augmentString("2")).$times(30))}));
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().read().load(path.getAbsolutePath()), (Seq<Row>)Nil$.MODULE$.$colon$colon((Object)row3).$colon$colon((Object)row2).$colon$colon((Object)row));
    }

    public static final /* synthetic */ void $anonfun$new$187(ParquetPartitionDiscoverySuite $this, File path) {
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(ParquetPartitionDiscoverySuite.class.getClassLoader());
        public final class Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator126$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
            }

            public Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator126$1(ParquetPartitionDiscoverySuite $outer) {
            }
        }
        Dataset data = $this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4((Object)"1", (Object)"2018-01", (Object)"2018-01-01-04", (Object)"test")})), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator126$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "date_month", "date_hour", "data"}));
        data.write().partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"date_month", "date_hour"})).parquet(path.getAbsolutePath());
        Dataset input = $this.spark().read().parquet(path.getAbsolutePath()).select("id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"date_month", "date_hour", "data"}));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(input.schema().sameType((DataType)input.schema()), "input.schema.sameType(input.schema)", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1157));
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> input, (Dataset<Row>)data);
    }

    public ParquetPartitionDiscoverySuite() {
        ScaledTimeSpans.$init$((ScaledTimeSpans)this);
        AbstractPatienceConfiguration.$init$((AbstractPatienceConfiguration)this);
        PatienceConfiguration.$init$((PatienceConfiguration)this);
        Eventually.$init$((Eventually)this);
        SQLTestData.$init$(this);
        SQLTestUtilsBase.$init$(this);
        SQLTestUtils.$init$(this);
        ParquetTest.$init$(this);
        SharedSparkSession.$init$(this);
        SharedSQLContext.$init$(this);
        this.defaultPartitionName = ExternalCatalogUtils$.MODULE$.DEFAULT_PARTITION_NAME();
        this.timeZone = TimeZone.getDefault();
        this.timeZoneId = this.timeZone().getID();
        this.test("column type inference", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.check$1("10", Literal$.MODULE$.create((Object)BoxesRunTime.boxToInteger((int)10), (DataType)IntegerType$.MODULE$), this.check$default$3$1());
            this.check$1("1000000000000000", Literal$.MODULE$.create((Object)BoxesRunTime.boxToLong((long)1000000000000000L), (DataType)LongType$.MODULE$), this.check$default$3$1());
            Decimal decimal = Decimal$.MODULE$.apply(new StringOps(Predef$.MODULE$.augmentString("1")).$times(20));
            this.check$1(new StringOps(Predef$.MODULE$.augmentString("1")).$times(20), Literal$.MODULE$.create((Object)decimal, (DataType)new DecimalType(decimal.precision(), decimal.scale())), this.check$default$3$1());
            this.check$1("1.5", Literal$.MODULE$.create((Object)BoxesRunTime.boxToDouble((double)1.5), (DataType)DoubleType$.MODULE$), this.check$default$3$1());
            this.check$1("hello", Literal$.MODULE$.create((Object)"hello", (DataType)StringType$.MODULE$), this.check$default$3$1());
            this.check$1("1990-02-24", Literal$.MODULE$.create((Object)Date.valueOf("1990-02-24"), (DataType)DateType$.MODULE$), this.check$default$3$1());
            this.check$1("1990-02-24 12:00:30", Literal$.MODULE$.create((Object)Timestamp.valueOf("1990-02-24 12:00:30"), (DataType)TimestampType$.MODULE$), this.check$default$3$1());
            Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            c.set(1990, 1, 24, 12, 0, 30);
            c.set(14, 0);
            this.check$1("1990-02-24 12:00:30", Literal$.MODULE$.create((Object)new Timestamp(c.getTimeInMillis()), (DataType)TimestampType$.MODULE$), TimeZone.getTimeZone("GMT"));
            this.check$1(this.defaultPartitionName(), Literal$.MODULE$.create(null, (DataType)NullType$.MODULE$), this.check$default$3$1());
        }, new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        this.test("parse invalid partitioned directories", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ObjectRef paths = ObjectRef.create((Object)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hdfs://host:9000/invalidPath", "hdfs://host:9000/path/a=10/b=20", "hdfs://host:9000/path/a=10.5/b=hello"}))));
            AssertionError exception = (AssertionError)this.intercept((Function0 & Serializable & scala.Serializable)() -> PartitioningUtils$.MODULE$.parsePartitions((Seq)((Seq)paths$1.elem).map((Function1 & Serializable & scala.Serializable)x$1 -> new Path(x$1), Seq$.MODULE$.canBuildFrom()), true, Predef$.MODULE$.Set().empty(), (Option)None$.MODULE$, true, this.timeZoneId()), ClassTag$.MODULE$.apply(AssertionError.class), new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
            String $org_scalatest_assert_macro_left = ((Throwable)((Object)exception)).getMessage();
            String $org_scalatest_assert_macro_right = "Conflicting directory structures detected";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
            paths.elem = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hdfs://host:9000/path/_temporary", "hdfs://host:9000/path/a=10/b=20", "hdfs://host:9000/path/_temporary/path"}));
            PartitioningUtils$.MODULE$.parsePartitions((Seq)((Seq)paths.elem).map((Function1 & Serializable & scala.Serializable)x$2 -> new Path(x$2), Seq$.MODULE$.canBuildFrom()), true, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{new Path("hdfs://host:9000/path/")})), (Option)None$.MODULE$, true, this.timeZoneId());
            paths.elem = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hdfs://host:9000/path/something=true/table/", "hdfs://host:9000/path/something=true/table/_temporary", "hdfs://host:9000/path/something=true/table/a=10/b=20", "hdfs://host:9000/path/something=true/table/_temporary/path"}));
            PartitioningUtils$.MODULE$.parsePartitions((Seq)((Seq)paths.elem).map((Function1 & Serializable & scala.Serializable)x$3 -> new Path(x$3), Seq$.MODULE$.canBuildFrom()), true, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{new Path("hdfs://host:9000/path/something=true/table")})), (Option)None$.MODULE$, true, this.timeZoneId());
            paths.elem = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hdfs://host:9000/path/table=true/", "hdfs://host:9000/path/table=true/_temporary", "hdfs://host:9000/path/table=true/a=10/b=20", "hdfs://host:9000/path/table=true/_temporary/path"}));
            PartitioningUtils$.MODULE$.parsePartitions((Seq)((Seq)paths.elem).map((Function1 & Serializable & scala.Serializable)x$4 -> new Path(x$4), Seq$.MODULE$.canBuildFrom()), true, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{new Path("hdfs://host:9000/path/table=true")})), (Option)None$.MODULE$, true, this.timeZoneId());
            paths.elem = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hdfs://host:9000/path/_temporary", "hdfs://host:9000/path/a=10/b=20", "hdfs://host:9000/path/path1"}));
            exception = (AssertionError)this.intercept((Function0 & Serializable & scala.Serializable)() -> PartitioningUtils$.MODULE$.parsePartitions((Seq)((Seq)paths$1.elem).map((Function1 & Serializable & scala.Serializable)x$5 -> new Path(x$5), Seq$.MODULE$.canBuildFrom()), true, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{new Path("hdfs://host:9000/path/")})), (Option)None$.MODULE$, true, this.timeZoneId()), ClassTag$.MODULE$.apply(AssertionError.class), new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
            String $org_scalatest_assert_macro_left2 = ((Throwable)((Object)exception)).getMessage();
            String $org_scalatest_assert_macro_right2 = "Conflicting directory structures detected";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
            paths.elem = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hdfs://host:9000/tmp/tables/partitionedTable", "hdfs://host:9000/tmp/tables/partitionedTable/p=1/", "hdfs://host:9000/tmp/tables/nonPartitionedTable1", "hdfs://host:9000/tmp/tables/nonPartitionedTable2"}));
            exception = (AssertionError)this.intercept((Function0 & Serializable & scala.Serializable)() -> PartitioningUtils$.MODULE$.parsePartitions((Seq)((Seq)paths$1.elem).map((Function1 & Serializable & scala.Serializable)x$6 -> new Path(x$6), Seq$.MODULE$.canBuildFrom()), true, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{new Path("hdfs://host:9000/tmp/tables/")})), (Option)None$.MODULE$, true, this.timeZoneId()), ClassTag$.MODULE$.apply(AssertionError.class), new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
            String $org_scalatest_assert_macro_left3 = ((Throwable)((Object)exception)).getMessage();
            String $org_scalatest_assert_macro_right3 = "Conflicting directory structures detected";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
        }, new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
        this.test("parse partition", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.check$2("file://path/a=10", (Option)new Some((Object)new PartitioningUtils.PartitionValues((Seq)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Seq)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.create((Object)BoxesRunTime.boxToInteger((int)10), (DataType)IntegerType$.MODULE$)})))));
            this.check$2("file://path/a=10/b=hello/c=1.5", (Option)new Some((Object)new PartitioningUtils.PartitionValues((Seq)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"})), (Seq)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.create((Object)BoxesRunTime.boxToInteger((int)10), (DataType)IntegerType$.MODULE$), Literal$.MODULE$.create((Object)"hello", (DataType)StringType$.MODULE$), Literal$.MODULE$.create((Object)BoxesRunTime.boxToDouble((double)1.5), (DataType)DoubleType$.MODULE$)})))));
            this.check$2("file://path/a=10/b_hello/c=1.5", (Option)new Some((Object)new PartitioningUtils.PartitionValues((Seq)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"})), (Seq)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.create((Object)BoxesRunTime.boxToDouble((double)1.5), (DataType)DoubleType$.MODULE$)})))));
            this.check$2("file:///", (Option)None$.MODULE$);
            this.check$2("file:///path/_temporary", (Option)None$.MODULE$);
            this.check$2("file:///path/_temporary/c=1.5", (Option)None$.MODULE$);
            this.check$2("file:///path/_temporary/path", (Option)None$.MODULE$);
            this.check$2("file://path/a=10/_temporary/c=1.5", (Option)None$.MODULE$);
            this.check$2("file://path/a=10/c=1.5/_temporary", (Option)None$.MODULE$);
            this.checkThrows$1("file://path/=10", "Empty partition column name", ManifestFactory$.MODULE$.classType(AssertionError.class));
            this.checkThrows$1("file://path/a=", "Empty partition column value", ManifestFactory$.MODULE$.classType(AssertionError.class));
        }, new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
        this.test("parse partition with base paths", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Option partitionSpec2;
            Option partitionSpec1;
            Option $org_scalatest_assert_macro_left = partitionSpec1 = (Option)PartitioningUtils$.MODULE$.parsePartition(new Path("file://path/a=10"), true, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{new Path("file://path/a=10")})), Predef$.MODULE$.Map().empty(), this.timeZone())._1();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
            Option $org_scalatest_assert_macro_left2 = partitionSpec2 = (Option)PartitioningUtils$.MODULE$.parsePartition(new Path("file://path/a=10"), true, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{new Path("file://path")})), Predef$.MODULE$.Map().empty(), this.timeZone())._1();
            Option $org_scalatest_assert_macro_right = Option$.MODULE$.apply((Object)new PartitioningUtils.PartitionValues((Seq)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Seq)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.create((Object)BoxesRunTime.boxToInteger((int)10), (DataType)IntegerType$.MODULE$)}))));
            Option option = $org_scalatest_assert_macro_left2;
            Option option2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(option2) : option2 != null), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 257));
        }, new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238));
        this.test("parse partitions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.check$3((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hdfs://host:9000/path/a=10/b=hello"})), new PartitionSpec(StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("b", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PartitionPath[]{PartitionPath$.MODULE$.apply(InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)10), UTF8String.fromString((String)"hello")})), "hdfs://host:9000/path/a=10/b=hello")}))), ParquetPartitionDiscoverySuite.check$default$3$2());
            this.check$3((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hdfs://host:9000/path/a=10/b=20", "hdfs://host:9000/path/a=10.5/b=hello"})), new PartitionSpec(StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("b", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PartitionPath[]{PartitionPath$.MODULE$.apply(InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)10), UTF8String.fromString((String)"20")})), "hdfs://host:9000/path/a=10/b=20"), PartitionPath$.MODULE$.apply(InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)10.5), UTF8String.fromString((String)"hello")})), "hdfs://host:9000/path/a=10.5/b=hello")}))), ParquetPartitionDiscoverySuite.check$default$3$2());
            this.check$3((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hdfs://host:9000/path/_temporary", "hdfs://host:9000/path/a=10/b=20", "hdfs://host:9000/path/a=10.5/b=hello", "hdfs://host:9000/path/a=10.5/_temporary", "hdfs://host:9000/path/a=10.5/_TeMpOrArY", "hdfs://host:9000/path/a=10.5/b=hello/_temporary", "hdfs://host:9000/path/a=10.5/b=hello/_TEMPORARY", "hdfs://host:9000/path/_temporary/path", "hdfs://host:9000/path/a=11/_temporary/path", "hdfs://host:9000/path/a=10.5/b=world/_temporary/path"})), new PartitionSpec(StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("b", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PartitionPath[]{PartitionPath$.MODULE$.apply(InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)10), UTF8String.fromString((String)"20")})), "hdfs://host:9000/path/a=10/b=20"), PartitionPath$.MODULE$.apply(InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)10.5), UTF8String.fromString((String)"hello")})), "hdfs://host:9000/path/a=10.5/b=hello")}))), ParquetPartitionDiscoverySuite.check$default$3$2());
            this.check$3((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hdfs://host:9000/path/a=10/b=20", new StringBuilder(32).append("hdfs://host:9000/path/a=").append(this.defaultPartitionName()).append("/b=hello").toString()})), new PartitionSpec(StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("b", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PartitionPath[]{PartitionPath$.MODULE$.apply(InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)10), UTF8String.fromString((String)"20")})), "hdfs://host:9000/path/a=10/b=20"), PartitionPath$.MODULE$.apply(InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, UTF8String.fromString((String)"hello")})), new StringBuilder(32).append("hdfs://host:9000/path/a=").append(this.defaultPartitionName()).append("/b=hello").toString())}))), ParquetPartitionDiscoverySuite.check$default$3$2());
            this.check$3((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(29).append("hdfs://host:9000/path/a=10/b=").append(this.defaultPartitionName()).toString(), new StringBuilder(31).append("hdfs://host:9000/path/a=10.5/b=").append(this.defaultPartitionName()).toString()})), new PartitionSpec(StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("b", (DataType)NullType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PartitionPath[]{PartitionPath$.MODULE$.apply(InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)10), null})), new StringBuilder(29).append("hdfs://host:9000/path/a=10/b=").append(this.defaultPartitionName()).toString()), PartitionPath$.MODULE$.apply(InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)10.5), null})), new StringBuilder(31).append("hdfs://host:9000/path/a=10.5/b=").append(this.defaultPartitionName()).toString())}))), ParquetPartitionDiscoverySuite.check$default$3$2());
            this.check$3((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hdfs://host:9000/path1", "hdfs://host:9000/path2"})), PartitionSpec$.MODULE$.emptySpec(), ParquetPartitionDiscoverySuite.check$default$3$2());
            long t1 = Timestamp.valueOf("2014-01-01 00:00:00.0").getTime() * 1000L;
            long t2 = Timestamp.valueOf("2014-01-01 00:01:00.0").getTime() * 1000L;
            this.check$3((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(28).append("hdfs://host:9000/path/a=").append(this.defaultPartitionName()).append("/b=0").toString(), new StringBuilder(40).append("hdfs://host:9000/path/a=2014-01-01/b=").append(Long.MAX_VALUE).append("111").toString(), new StringBuilder(52).append("hdfs://host:9000/path/a=2014-01-01 00%3A01%3A00.0/b=").append(this.defaultPartitionName()).toString()})), new PartitionSpec(StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", (DataType)TimestampType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("b", (DataType)new DecimalType(22, 0), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PartitionPath[]{PartitionPath$.MODULE$.apply(InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, Decimal$.MODULE$.apply(0)})), new StringBuilder(28).append("hdfs://host:9000/path/a=").append(this.defaultPartitionName()).append("/b=0").toString()), PartitionPath$.MODULE$.apply(InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)t1), Decimal$.MODULE$.apply(new StringBuilder(3).append(Long.MAX_VALUE).append("111").toString())})), new StringBuilder(40).append("hdfs://host:9000/path/a=2014-01-01/b=").append(Long.MAX_VALUE).append("111").toString()), PartitionPath$.MODULE$.apply(InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)t2), null})), new StringBuilder(52).append("hdfs://host:9000/path/a=2014-01-01 00%3A01%3A00.0/b=").append(this.defaultPartitionName()).toString())}))), ParquetPartitionDiscoverySuite.check$default$3$2());
        }, new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 263));
        this.test("parse partitions with type inference disabled", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.check$4((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hdfs://host:9000/path/a=10/b=hello"})), new PartitionSpec(StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("b", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PartitionPath[]{PartitionPath$.MODULE$.apply(InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UTF8String.fromString((String)"10"), UTF8String.fromString((String)"hello")})), "hdfs://host:9000/path/a=10/b=hello")}))));
            this.check$4((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hdfs://host:9000/path/a=10/b=20", "hdfs://host:9000/path/a=10.5/b=hello"})), new PartitionSpec(StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("b", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PartitionPath[]{PartitionPath$.MODULE$.apply(InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UTF8String.fromString((String)"10"), UTF8String.fromString((String)"20")})), "hdfs://host:9000/path/a=10/b=20"), PartitionPath$.MODULE$.apply(InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UTF8String.fromString((String)"10.5"), UTF8String.fromString((String)"hello")})), "hdfs://host:9000/path/a=10.5/b=hello")}))));
            this.check$4((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hdfs://host:9000/path/_temporary", "hdfs://host:9000/path/a=10/b=20", "hdfs://host:9000/path/a=10.5/b=hello", "hdfs://host:9000/path/a=10.5/_temporary", "hdfs://host:9000/path/a=10.5/_TeMpOrArY", "hdfs://host:9000/path/a=10.5/b=hello/_temporary", "hdfs://host:9000/path/a=10.5/b=hello/_TEMPORARY", "hdfs://host:9000/path/_temporary/path", "hdfs://host:9000/path/a=11/_temporary/path", "hdfs://host:9000/path/a=10.5/b=world/_temporary/path"})), new PartitionSpec(StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("b", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PartitionPath[]{PartitionPath$.MODULE$.apply(InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UTF8String.fromString((String)"10"), UTF8String.fromString((String)"20")})), "hdfs://host:9000/path/a=10/b=20"), PartitionPath$.MODULE$.apply(InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UTF8String.fromString((String)"10.5"), UTF8String.fromString((String)"hello")})), "hdfs://host:9000/path/a=10.5/b=hello")}))));
            this.check$4((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hdfs://host:9000/path/a=10/b=20", new StringBuilder(32).append("hdfs://host:9000/path/a=").append(this.defaultPartitionName()).append("/b=hello").toString()})), new PartitionSpec(StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("b", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PartitionPath[]{PartitionPath$.MODULE$.apply(InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UTF8String.fromString((String)"10"), UTF8String.fromString((String)"20")})), "hdfs://host:9000/path/a=10/b=20"), PartitionPath$.MODULE$.apply(InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, UTF8String.fromString((String)"hello")})), new StringBuilder(32).append("hdfs://host:9000/path/a=").append(this.defaultPartitionName()).append("/b=hello").toString())}))));
            this.check$4((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(29).append("hdfs://host:9000/path/a=10/b=").append(this.defaultPartitionName()).toString(), new StringBuilder(31).append("hdfs://host:9000/path/a=10.5/b=").append(this.defaultPartitionName()).toString()})), new PartitionSpec(StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("a", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("b", (DataType)NullType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}))), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PartitionPath[]{PartitionPath$.MODULE$.apply(InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UTF8String.fromString((String)"10"), null})), new StringBuilder(29).append("hdfs://host:9000/path/a=10/b=").append(this.defaultPartitionName()).toString()), PartitionPath$.MODULE$.apply(InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UTF8String.fromString((String)"10.5"), null})), new StringBuilder(31).append("hdfs://host:9000/path/a=10.5/b=").append(this.defaultPartitionName()).toString())}))));
            this.check$4((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hdfs://host:9000/path1", "hdfs://host:9000/path2"})), PartitionSpec$.MODULE$.emptySpec());
        }, new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 384));
        this.test("read partitioned table - normal case", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)base -> {
            ParquetPartitionDiscoverySuite.$anonfun$new$21(this, base);
            return BoxedUnit.UNIT;
        }), new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 466));
        this.test("read partitioned table using different path options", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)base -> {
            ParquetPartitionDiscoverySuite.$anonfun$new$41(this, base);
            return BoxedUnit.UNIT;
        }), new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 518));
        this.test("read partitioned table - partition key included in Parquet file", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)base -> {
            ParquetPartitionDiscoverySuite.$anonfun$new$50(this, base);
            return BoxedUnit.UNIT;
        }), new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 557));
        this.test("read partitioned table - with nulls", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)base -> {
            ParquetPartitionDiscoverySuite.$anonfun$new$70(this, base);
            return BoxedUnit.UNIT;
        }), new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 604));
        this.test("read partitioned table - with nulls and partition keys are included in Parquet file", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)base -> {
            ParquetPartitionDiscoverySuite.$anonfun$new$86(this, base);
            return BoxedUnit.UNIT;
        }), new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 645));
        this.test("read partitioned table - merging compatible schemas", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)base -> {
            ParquetPartitionDiscoverySuite.$anonfun$new$99(this, base);
            return BoxedUnit.UNIT;
        }), new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 678));
        this.test("SPARK-7749 Non-partitioned table should have empty partition spec", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            ParquetPartitionDiscoverySuite.$anonfun$new$107(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 703));
        this.test("SPARK-7847: Dynamic partition directory path escaping and unescaping", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            ParquetPartitionDiscoverySuite.$anonfun$new$111(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 717));
        this.test("Various partition value types", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)((byte)100)), BoxesRunTime.boxToShort((short)((short)40000)), BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE), BoxesRunTime.boxToLong((long)Long.MAX_VALUE), BoxesRunTime.boxToFloat((float)((float)1.5)), BoxesRunTime.boxToDouble((double)4.5), new BigDecimal(new BigInteger("212500"), 5), new BigDecimal("2.125"), Date.valueOf("2015-05-23"), new Timestamp(0L), "This is a string, /[]?=:", "This is not a partition column"}));
            Seq partitionColumnTypes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{ByteType$.MODULE$, ShortType$.MODULE$, IntegerType$.MODULE$, LongType$.MODULE$, FloatType$.MODULE$, DoubleType$.MODULE$, new DecimalType(10, 5), DecimalType$.MODULE$.SYSTEM_DEFAULT(), DateType$.MODULE$, TimestampType$.MODULE$, StringType$.MODULE$}));
            Seq partitionColumns = (Seq)((TraversableLike)partitionColumnTypes.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                AtomicType t = (AtomicType)tuple2._1();
                int index = tuple2._2$mcI$sp();
                StructField structField = new StructField(new StringBuilder(2).append("p_").append(index).toString(), (DataType)t, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                return structField;
            }, Seq$.MODULE$.canBuildFrom());
            StructType schema = StructType$.MODULE$.apply((Seq)partitionColumns.$colon$plus((Object)new StructField("i", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), Seq$.MODULE$.canBuildFrom()));
            SparkContext qual$1 = this.sparkContext();
            Row row2 = row;
            List x$1 = Nil$.MODULE$.$colon$colon((Object)row2);
            int x$2 = qual$1.parallelize$default$2();
            Dataset df = this.spark().createDataFrame(qual$1.parallelize((Seq)x$1, x$2, ClassTag$.MODULE$.apply(Row.class)), schema);
            this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
                ParquetPartitionDiscoverySuite.$anonfun$new$116(this, df, partitionColumns, schema, row, dir);
                return BoxedUnit.UNIT;
            });
            this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
                ParquetPartitionDiscoverySuite.$anonfun$new$120(this, df, partitionColumns, schema, row, dir);
                return BoxedUnit.UNIT;
            });
        }, new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 725));
        this.test("Various inferred partition value types", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)Long.MAX_VALUE), BoxesRunTime.boxToDouble((double)4.5), new BigDecimal(new BigInteger(new StringOps(Predef$.MODULE$.augmentString("1")).$times(20))), Date.valueOf("2015-05-23"), Timestamp.valueOf("1990-02-24 12:00:30"), "This is a string, /[]?=:", "This is not a partition column"}));
            Seq partitionColumnTypes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{LongType$.MODULE$, DoubleType$.MODULE$, new DecimalType(20, 0), DateType$.MODULE$, TimestampType$.MODULE$, StringType$.MODULE$}));
            Seq partitionColumns = (Seq)((TraversableLike)partitionColumnTypes.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                AtomicType t = (AtomicType)tuple2._1();
                int index = tuple2._2$mcI$sp();
                StructField structField = new StructField(new StringBuilder(2).append("p_").append(index).toString(), (DataType)t, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                return structField;
            }, Seq$.MODULE$.canBuildFrom());
            StructType schema = StructType$.MODULE$.apply((Seq)partitionColumns.$colon$plus((Object)new StructField("i", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), Seq$.MODULE$.canBuildFrom()));
            SparkContext qual$2 = this.sparkContext();
            Row row2 = row;
            List x$3 = Nil$.MODULE$.$colon$colon((Object)row2);
            int x$4 = qual$2.parallelize$default$2();
            Dataset df = this.spark().createDataFrame(qual$2.parallelize((Seq)x$3, x$4, ClassTag$.MODULE$.apply(Row.class)), schema);
            this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
                ParquetPartitionDiscoverySuite.$anonfun$new$126(this, df, partitionColumns, schema, row, dir);
                return BoxedUnit.UNIT;
            });
            this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
                ParquetPartitionDiscoverySuite.$anonfun$new$130(this, df, partitionColumns, schema, row, dir);
                return BoxedUnit.UNIT;
            });
        }, new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 778));
        this.test("SPARK-8037: Ignores files whose name starts with dot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            ParquetPartitionDiscoverySuite.$anonfun$new$135(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 820));
        this.test("SPARK-11678: Partition discovery stops at the root path of the dataset", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
                ParquetPartitionDiscoverySuite.$anonfun$new$139(this, dir);
                return BoxedUnit.UNIT;
            });
            this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
                ParquetPartitionDiscoverySuite.$anonfun$new$142(this, dir);
                return BoxedUnit.UNIT;
            });
        }, new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 836));
        this.test("use basePath to specify the root dir of a partitioned table.", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            ParquetPartitionDiscoverySuite.$anonfun$new$146(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 870));
        this.test("use basePath and file globbing to selectively load partitioned table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            ParquetPartitionDiscoverySuite.$anonfun$new$151(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 900));
        this.test("_SUCCESS should not break partitioning discovery", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 32}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)threshold -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARALLEL_PARTITION_DISCOVERY_THRESHOLD().key()), (Object)((Object)BoxesRunTime.boxToInteger((int)threshold)).toString())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            ParquetPartitionDiscoverySuite.$anonfun$new$156(this, dir);
            return BoxedUnit.UNIT;
        }))), new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 947));
        this.test("listConflictingPartitionColumns", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(PartitioningUtils$.MODULE$.listConflictingPartitionColumns((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new Path("file:/tmp/foo/a=1"), (Object)new PartitioningUtils.PartitionValues((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))})))), new Tuple2((Object)new Path("file:/tmp/foo/b=1"), (Object)new PartitioningUtils.PartitionValues((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))}))))}))).trim());
            String $org_scalatest_assert_macro_right = ParquetPartitionDiscoverySuite.makeExpectedMessage$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"file:/tmp/foo/a=1", "file:/tmp/foo/b=1"})));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 987));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(PartitioningUtils$.MODULE$.listConflictingPartitionColumns((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new Path("file:/tmp/foo/a=1/_temporary"), (Object)new PartitioningUtils.PartitionValues((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))})))), new Tuple2((Object)new Path("file:/tmp/foo/a=1"), (Object)new PartitioningUtils.PartitionValues((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))}))))}))).trim());
            String $org_scalatest_assert_macro_right2 = ParquetPartitionDiscoverySuite.makeExpectedMessage$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"file:/tmp/foo/a=1/_temporary", "file:/tmp/foo/a=1"})));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 994));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(PartitioningUtils$.MODULE$.listConflictingPartitionColumns((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new Path("file:/tmp/foo/a=1"), (Object)new PartitioningUtils.PartitionValues((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))})))), new Tuple2((Object)new Path("file:/tmp/foo/a=1/b=foo"), (Object)new PartitioningUtils.PartitionValues((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1)), Literal$.MODULE$.apply((Object)"foo")}))))}))).trim());
            String $org_scalatest_assert_macro_right3 = ParquetPartitionDiscoverySuite.makeExpectedMessage$1((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "a, b"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"file:/tmp/foo/a=1", "file:/tmp/foo/a=1/b=foo"})));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1003));
        }, new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 970));
        this.test("Parallel partition discovery", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARALLEL_PARTITION_DISCOVERY_THRESHOLD().key()), (Object)"1")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                String path = dir.getCanonicalPath();
                Dataset df = $this.spark().range(5L).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{$this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "id")).as((Symbol)SymbolLiteral.bootstrap("apply", "a")), $this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "id")).as((Symbol)SymbolLiteral.bootstrap("apply", "b")), $this.testImplicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "id")).as((Symbol)SymbolLiteral.bootstrap("apply", "c"))})).coalesce(1);
                df.write().partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b", "c"})).parquet(path);
                $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().read().parquet(path), (Dataset<Row>)df);
            });
            return BoxedUnit.UNIT;
        }), new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1015));
        this.test("SPARK-15895 summary files in non-leaf partition directories", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            ParquetPartitionDiscoverySuite.$anonfun$new$167(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1026));
        this.test("SPARK-18108 Parquet reader fails when data column types conflict with partition ones", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_VECTORIZED_READER_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            ParquetPartitionDiscoverySuite.$anonfun$new$172(this, dir);
            return BoxedUnit.UNIT;
        })), new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1071));
        this.test("SPARK-21463: MetadataLogFileIndex should respect userSpecifiedSchema for partition cols", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tempDir -> {
            ParquetPartitionDiscoverySuite.$anonfun$new$175(this, tempDir);
            return BoxedUnit.UNIT;
        }), new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1082));
        this.test("SPARK-22109: Resolve type conflicts between strings and timestamps in partition column", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(ParquetPartitionDiscoverySuite.class.getClassLoader());
            public final class Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator102$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator102$1(ParquetPartitionDiscoverySuite $outer) {
                }
            }
            Dataset df = this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)"2015-01-01 00:00:00"), new Tuple2((Object)BoxesRunTime.boxToInteger((int)2), (Object)"2014-01-01 00:00:00"), new Tuple2((Object)BoxesRunTime.boxToInteger((int)3), (Object)"blah")})), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_parquet_ParquetPartitionDiscoverySuite$$typecreator102$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"i", "str"}));
            this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)path -> {
                ParquetPartitionDiscoverySuite.$anonfun$new$179(this, df, path);
                return BoxedUnit.UNIT;
            });
        }, new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1114));
        this.test("Resolve type conflicts - decimals, dates and timestamps in partition column", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)path -> {
                ParquetPartitionDiscoverySuite.$anonfun$new$182(this, path);
                return BoxedUnit.UNIT;
            });
            this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)path -> {
                ParquetPartitionDiscoverySuite.$anonfun$new$184(this, path);
                return BoxedUnit.UNIT;
            });
        }, new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1126));
        this.test("SPARK-23436: invalid Dates should be inferred as String in partition inference", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)path -> {
            ParquetPartitionDiscoverySuite.$anonfun$new$187(this, path);
            return BoxedUnit.UNIT;
        }), new Position("ParquetPartitionDiscoverySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1148));
    }
}

