/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.File;
import java.io.Serializable;
import java.sql.Timestamp;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetCompatibilityTest;
import org.apache.spark.sql.execution.datasources.parquet.ParquetCompatibilityTest$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.test.SQLTestUtils;
import org.apache.spark.sql.test.SharedSQLContext;
import org.apache.spark.sql.test.SharedSparkSession;
import org.apache.spark.sql.test.TestSparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u00012AAA\u0002\u0001%!)Q\u0004\u0001C\u0001=\ta\u0002+\u0019:rk\u0016$\u0018J\u001c;fe>\u0004XM]1cS2LG/_*vSR,'B\u0001\u0003\u0006\u0003\u001d\u0001\u0018M]9vKRT!AB\u0004\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u0003\u0011%\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005)Y\u0011aA:rY*\u0011A\"D\u0001\u0006gB\f'o\u001b\u0006\u0003\u001d=\ta!\u00199bG\",'\"\u0001\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0019r\u0003\u0005\u0002\u0015+5\t1!\u0003\u0002\u0017\u0007\tA\u0002+\u0019:rk\u0016$8i\\7qCRL'-\u001b7jif$Vm\u001d;\u0011\u0005aYR\"A\r\u000b\u0005iI\u0011\u0001\u0002;fgRL!\u0001H\r\u0003!MC\u0017M]3e'Fc5i\u001c8uKb$\u0018A\u0002\u001fj]&$h\bF\u0001 !\t!\u0002\u0001")
public class ParquetInteroperabilitySuite
extends ParquetCompatibilityTest
implements SharedSQLContext {
    private final boolean enableAutoThreadAudit;
    private TestSparkSession org$apache$spark$sql$test$SharedSparkSession$$_spark;

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSQLContext$$super$beforeAll() {
        SharedSparkSession.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSQLContext$$super$afterAll() {
        SharedSparkSession.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        SharedSQLContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        SharedSQLContext.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$beforeAll() {
        SQLTestUtils.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    @Override
    public SparkConf sparkConf() {
        return SharedSparkSession.sparkConf$(this);
    }

    @Override
    public SparkSession spark() {
        return SharedSparkSession.spark$(this);
    }

    @Override
    public SQLContext sqlContext() {
        return SharedSparkSession.sqlContext$(this);
    }

    @Override
    public TestSparkSession createSparkSession() {
        return SharedSparkSession.createSparkSession$(this);
    }

    @Override
    public void initializeSession() {
        SharedSparkSession.initializeSession$(this);
    }

    @Override
    public void beforeEach() {
        SharedSparkSession.beforeEach$(this);
    }

    @Override
    public void afterEach() {
        SharedSparkSession.afterEach$(this);
    }

    @Override
    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSQLContext$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    @Override
    public TestSparkSession org$apache$spark$sql$test$SharedSparkSession$$_spark() {
        return this.org$apache$spark$sql$test$SharedSparkSession$$_spark;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSparkSession$$_spark_$eq(TestSparkSession x$1) {
        this.org$apache$spark$sql$test$SharedSparkSession$$_spark = x$1;
    }

    public static final /* synthetic */ void $anonfun$new$3(RecordConsumer rc) {
        ParquetCompatibilityTest$.MODULE$.RecordConsumerDSL(rc).message((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ParquetCompatibilityTest$.MODULE$.RecordConsumerDSL(rc).field("f", 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ParquetCompatibilityTest$.MODULE$.RecordConsumerDSL(rc).group((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ParquetCompatibilityTest$.MODULE$.RecordConsumerDSL(rc).field("array", 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            rc.addInteger(0);
            rc.addInteger(1);
        }))));
    }

    public static final /* synthetic */ void $anonfun$new$8(RecordConsumer rc) {
        ParquetCompatibilityTest$.MODULE$.RecordConsumerDSL(rc).message((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ParquetCompatibilityTest$.MODULE$.RecordConsumerDSL(rc).field("f", 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            rc.addInteger(2);
            rc.addInteger(3);
        }));
    }

    public static final /* synthetic */ void $anonfun$new$2(ParquetInteroperabilitySuite $this, File dir) {
        String avroStylePath = new File(dir, "avro-style").getCanonicalPath();
        String protobufStylePath = new File(dir, "protobuf-style").getCanonicalPath();
        String avroStyleSchema = new StringOps(Predef$.MODULE$.augmentString("message avro_style {\n          |  required group f (LIST) {\n          |    repeated int32 array;\n          |  }\n          |}\n        ")).stripMargin();
        ParquetCompatibilityTest$.MODULE$.writeDirect(avroStylePath, avroStyleSchema, (Seq<Function1<RecordConsumer, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable & scala.Serializable)rc -> {
            ParquetInteroperabilitySuite.$anonfun$new$3(rc);
            return BoxedUnit.UNIT;
        }}));
        $this.logParquetSchema(avroStylePath);
        String protobufStyleSchema = new StringOps(Predef$.MODULE$.augmentString("message protobuf_style {\n          |  repeated int32 f;\n          |}\n        ")).stripMargin();
        ParquetCompatibilityTest$.MODULE$.writeDirect(protobufStylePath, protobufStyleSchema, (Seq<Function1<RecordConsumer, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable & scala.Serializable)rc -> {
            ParquetInteroperabilitySuite.$anonfun$new$8(rc);
            return BoxedUnit.UNIT;
        }}));
        $this.logParquetSchema(protobufStylePath);
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().read().parquet(dir.getCanonicalPath()), (Seq<Row>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))})), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3}))}))}))));
    }

    public static final /* synthetic */ void $anonfun$new$16(ParquetInteroperabilitySuite $this, File tableDir$1, Seq impalaFileData$1, Seq ts$1, boolean int96TimestampConversion) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)vectorized -> {
            $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SQLConf$.MODULE$.PARQUET_OUTPUT_TIMESTAMP_TYPE().key(), (Object)SQLConf.ParquetOutputTimestampType$.MODULE$.INT96().toString()), new Tuple2((Object)SQLConf$.MODULE$.PARQUET_INT96_TIMESTAMP_CONVERSION().key(), (Object)((Object)BoxesRunTime.boxToBoolean((boolean)int96TimestampConversion)).toString()), new Tuple2((Object)SQLConf$.MODULE$.PARQUET_VECTORIZED_READER_ENABLED().key(), (Object)((Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)vectorized))).toString())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Row[] readBack = (Row[])$this.spark().read().parquet(tableDir$1.getAbsolutePath()).collect();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])readBack)).size()));
                int $org_scalatest_assert_macro_right = 6;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetInteroperabilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
                Seq impalaExpectations = int96TimestampConversion$1 ? impalaFileData$1 : (Seq)impalaFileData$1.map((Function1 & Serializable & scala.Serializable)ts -> DateTimeUtils$.MODULE$.toJavaTimestamp(DateTimeUtils$.MODULE$.convertTz(DateTimeUtils$.MODULE$.fromJavaTimestamp(ts), DateTimeUtils$.MODULE$.TimeZoneUTC(), DateTimeUtils$.MODULE$.getTimeZone($this.conf().sessionLocalTimeZone()))), Seq$.MODULE$.canBuildFrom());
                String[] fullExpectations = (String[])((TraversableOnce)((SeqLike)((TraversableLike)ts$1.$plus$plus((GenTraversableOnce)impalaExpectations, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString(), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$)).toArray(ClassTag$.MODULE$.apply(String.class));
                String[] actual = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])readBack)).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getTimestamp(0).toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).sorted((Ordering)Ordering.String$.MODULE$);
                $this.withClue(new StringBuilder(42).append("int96TimestampConversion = ").append(int96TimestampConversion$1).append("; vectorized = ").append(vectorized).toString(), (Function0 & Serializable & scala.Serializable)() -> {
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(fullExpectations);
                    String[] $org_scalatest_assert_macro_right = actual;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetInteroperabilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
                    Configuration hadoopConf = $this.spark().sessionState().newHadoopConf();
                    FileSystem fs = FileSystem.get((Configuration)hadoopConf);
                    FileStatus[] parts = fs.listStatus(new Path(tableDir$1.getAbsolutePath()), new PathFilter(null){

                        public boolean accept(Path path) {
                            return !path.getName().startsWith("_");
                        }
                    });
                    Object[] $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])parts);
                    int $org_scalatest_assert_macro_right2 = 2;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left2), "size", (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef($org_scalatest_assert_macro_left2).size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                    $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetInteroperabilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
                    new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parts)).foreach((Function1 & Serializable & scala.Serializable)part -> {
                        ParquetMetadata oneFooter = ParquetFileReader.readFooter((Configuration)hadoopConf, (Path)part.getPath(), (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)oneFooter.getFileMetaData().getSchema().getColumns().size()));
                        int $org_scalatest_assert_macro_right = 1;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetInteroperabilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
                        PrimitiveType.PrimitiveTypeName typeName = ((ColumnDescriptor)oneFooter.getFileMetaData().getSchema().getColumns().get(0)).getPrimitiveType().getPrimitiveTypeName();
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(typeName);
                        PrimitiveType.PrimitiveTypeName $org_scalatest_assert_macro_right2 = PrimitiveType.PrimitiveTypeName.INT96;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetInteroperabilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
                        BlockMetaData oneBlockMeta = (BlockMetaData)oneFooter.getBlocks().get(0);
                        ColumnChunkMetaData oneBlockColumnMeta = (ColumnChunkMetaData)oneBlockMeta.getColumns().get(0);
                        Statistics columnStats = oneBlockColumnMeta.getStatistics();
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(columnStats.hasNonNullValue(), "columnStats.hasNonNullValue()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                        return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetInteroperabilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
                    });
                    Dataset query = $this.spark().read().parquet(tableDir$1.getAbsolutePath()).where("ts > '2001-01-01 01:00:00'");
                    long countWithFilter = query.count();
                    int exp = int96TimestampConversion$1 ? 6 : 5;
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)countWithFilter));
                    int $org_scalatest_assert_macro_right3 = exp;
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)query, Prettifier$.MODULE$.default(), new Position("ParquetInteroperabilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
                });
            });
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$14(ParquetInteroperabilitySuite $this, String impalaPath$1, Seq impalaFileData$1, File tableDir) {
        Seq ts = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2004-04-04 04:04:04", "2005-05-05 05:05:05", "2006-06-06 06:06:06"}))).map((Function1 & Serializable & scala.Serializable)s -> Timestamp.valueOf(s), Seq$.MODULE$.canBuildFrom());
        Dataset df = $this.spark().createDataset(ts, $this.testImplicits().newTimeStampEncoder()).toDF().repartition(1).withColumnRenamed("value", "ts");
        df.write().parquet(tableDir.getAbsolutePath());
        FileUtils.copyFile((File)new File(impalaPath$1), (File)new File(tableDir, "part-00001.parq"));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)int96TimestampConversion -> {
            ParquetInteroperabilitySuite.$anonfun$new$16($this, tableDir, impalaFileData$1, ts, BoxesRunTime.unboxToBoolean((Object)int96TimestampConversion));
            return BoxedUnit.UNIT;
        });
    }

    public ParquetInteroperabilitySuite() {
        SharedSparkSession.$init$(this);
        SharedSQLContext.$init$(this);
        this.test("parquet files with different physical schemas but share the same logical schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            ParquetInteroperabilitySuite.$anonfun$new$2(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("ParquetInteroperabilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 36));
        this.test("parquet timestamp conversion", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String impalaFile = "test-data/impala_timestamp.parq";
            Seq impalaFileData = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"2001-01-01 01:01:01", "2002-02-02 02:02:02", "2003-03-03 03:03:03"}))).map((Function1 & Serializable & scala.Serializable)x$1 -> Timestamp.valueOf(x$1), Seq$.MODULE$.canBuildFrom());
            String impalaPath = Thread.currentThread().getContextClassLoader().getResource(impalaFile).toURI().getPath();
            this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tableDir -> {
                ParquetInteroperabilitySuite.$anonfun$new$14(this, impalaPath, impalaFileData, tableDir);
                return BoxedUnit.UNIT;
            });
        }, new Position("ParquetInteroperabilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 101));
    }
}

