/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.orc;

import java.io.File;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.orc.OrcFile;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.orc.OrcFileFormat;
import org.apache.spark.sql.execution.datasources.orc.OrcQuerySuite$;
import org.apache.spark.sql.execution.datasources.orc.OrcQueryTest;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.test.SharedSQLContext;
import org.apache.spark.sql.test.SharedSparkSession;
import org.apache.spark.sql.test.TestSparkSession;
import org.apache.spark.sql.types.StructType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u00012AAA\u0002\u0001%!)Q\u0004\u0001C\u0001=\tiqJ]2Rk\u0016\u0014\u0018pU;ji\u0016T!\u0001B\u0003\u0002\u0007=\u00148M\u0003\u0002\u0007\u000f\u0005YA-\u0019;bg>,(oY3t\u0015\tA\u0011\"A\u0005fq\u0016\u001cW\u000f^5p]*\u0011!bC\u0001\u0004gFd'B\u0001\u0007\u000e\u0003\u0015\u0019\b/\u0019:l\u0015\tqq\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002!\u0005\u0019qN]4\u0004\u0001M\u0019\u0001aE\f\u0011\u0005Q)R\"A\u0002\n\u0005Y\u0019!\u0001D(sGF+XM]=UKN$\bC\u0001\r\u001c\u001b\u0005I\"B\u0001\u000e\n\u0003\u0011!Xm\u001d;\n\u0005qI\"\u0001E*iCJ,GmU)M\u0007>tG/\u001a=u\u0003\u0019a\u0014N\\5u}Q\tq\u0004\u0005\u0002\u0015\u0001\u0001")
public class OrcQuerySuite
extends OrcQueryTest
implements SharedSQLContext {
    private final boolean enableAutoThreadAudit;
    private TestSparkSession org$apache$spark$sql$test$SharedSparkSession$$_spark;

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSQLContext$$super$beforeAll() {
        SharedSparkSession.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSQLContext$$super$afterAll() {
        SharedSparkSession.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        SharedSQLContext.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        SharedSQLContext.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$beforeAll() {
        super.beforeAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    @Override
    public SparkConf sparkConf() {
        return SharedSparkSession.sparkConf$(this);
    }

    @Override
    public SparkSession spark() {
        return SharedSparkSession.spark$(this);
    }

    @Override
    public SQLContext sqlContext() {
        return SharedSparkSession.sqlContext$(this);
    }

    @Override
    public TestSparkSession createSparkSession() {
        return SharedSparkSession.createSparkSession$(this);
    }

    @Override
    public void initializeSession() {
        SharedSparkSession.initializeSession$(this);
    }

    @Override
    public void beforeEach() {
        SharedSparkSession.beforeEach$(this);
    }

    @Override
    public void afterEach() {
        SharedSparkSession.afterEach$(this);
    }

    @Override
    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSQLContext$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    @Override
    public TestSparkSession org$apache$spark$sql$test$SharedSparkSession$$_spark() {
        return this.org$apache$spark$sql$test$SharedSparkSession$$_spark;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSparkSession$$_spark_$eq(TestSparkSession x$1) {
        this.org$apache$spark$sql$test$SharedSparkSession$$_spark = x$1;
    }

    public static final /* synthetic */ boolean $anonfun$new$159(File x$35) {
        return x$35.getName().endsWith(".lzo.orc");
    }

    public static final /* synthetic */ void $anonfun$new$158(OrcQuerySuite $this, File file) {
        $this.spark().range(0L, 10L).write().option("compression", "LZO").orc(file.getCanonicalPath());
        Option maybeOrcFile = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])file.listFiles())).find((Function1 & Serializable & scala.Serializable)x$35 -> BoxesRunTime.boxToBoolean((boolean)OrcQuerySuite.$anonfun$new$159(x$35)));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(maybeOrcFile.isDefined(), "maybeOrcFile.isDefined", Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 628));
        Path orcFilePath = new Path(((File)maybeOrcFile.get()).getAbsolutePath());
        OrcFile.ReaderOptions conf = OrcFile.readerOptions((Configuration)new Configuration());
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer("LZO");
        String $org_scalatest_assert_macro_right = OrcFile.createReader((Path)orcFilePath, (OrcFile.ReaderOptions)conf).getCompressionKind().name();
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 632));
    }

    public static final /* synthetic */ void $anonfun$new$161(OrcQuerySuite $this, File dir) {
        String path = dir.getCanonicalPath();
        $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"empty_orc"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"empty", "single"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(113).append("CREATE TABLE empty_orc(key INT, value STRING)\n               |USING ORC\n               |LOCATION '").append(dir.toURI()).append("'\n             ").toString())).stripMargin());
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(OrcQuerySuite.class.getClassLoader());
            public final class Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator5$2
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator5$2(OrcQuerySuite $outer) {
                }
            }
            Dataset emptyDF = $this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.empty(), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator5$2(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key", "value"})).coalesce(1);
            emptyDF.createOrReplaceTempView("empty");
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("INSERT INTO TABLE empty_orc\n               |SELECT key, value FROM empty\n             ")).stripMargin());
            Dataset df = $this.spark().read().orc(path);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(df.schema());
            StructType $org_scalatest_assert_macro_right = emptyDF.schema().asNullable();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 660));
            $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> df, (Dataset<Row>)emptyDF);
        }));
    }

    public static final /* synthetic */ void $anonfun$new$166(OrcQuerySuite $this, File dir) {
        String path = new File(dir, "orc").getCanonicalPath();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(OrcQuerySuite.class.getClassLoader());
        public final class Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator13$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$));
            }

            public Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator13$1(OrcQuerySuite $outer) {
            }
        }
        $this.testImplicits().localSeqToDatasetHolder((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{new Some((Object)BoxesRunTime.boxToInteger((int)1)), None$.MODULE$})), $this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_datasources_orc_OrcQuerySuite$$typecreator13$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"col.dots"})).write().orc(path);
        Row[] $org_scalatest_assert_macro_left = (Row[])$this.spark().read().orc(path).collect();
        int $org_scalatest_assert_macro_right = 2;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        $this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 671));
    }

    public OrcQuerySuite() {
        SharedSparkSession.$init$(this);
        SharedSQLContext.$init$(this);
        this.test("LZO compression options for writing to an ORC file", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)file -> {
            OrcQuerySuite.$anonfun$new$158(this, file);
            return BoxedUnit.UNIT;
        }), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 621));
        this.test("Schema discovery on empty ORC files", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            OrcQuerySuite.$anonfun$new$161(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 636));
        this.test("SPARK-21791 ORC should support column names with dot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            OrcQuerySuite.$anonfun$new$166(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 667));
        this.test("SPARK-25579 ORC PPD should support column names with dot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_FILTER_PUSHDOWN_ENABLED().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkPredicatePushDown((Dataset<Row>)this.spark().range(10L).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"col.dot"})), 10, "`col.dot` == 2")), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 675));
        this.test("SPARK-20728 Make ORCFileFormat configurable between sql/hive and sql/core", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_IMPLEMENTATION().key()), (Object)"hive")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                AnalysisException e = (AnalysisException)this.intercept((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"CREATE TABLE spark_20728(a INT) USING ORC"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 683));
                String $org_scalatest_assert_macro_left = e.message();
                String $org_scalatest_assert_macro_right = "Hive built-in ORC data source must be used with Hive support";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 686));
            });
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_IMPLEMENTATION().key()), (Object)"native")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark_20728"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Option fileFormat;
                this.sql().apply((Object)"CREATE TABLE spark_20728(a INT) USING ORC");
                Option $org_scalatest_assert_macro_left = fileFormat = ((Dataset)this.sql().apply((Object)"SELECT * FROM spark_20728")).queryExecution().analyzed().collectFirst((PartialFunction)new scala.Serializable(null){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Class<?> clazz;
                        A1 A1 = x1;
                        if (A1 instanceof LogicalRelation) {
                            LogicalRelation logicalRelation = (LogicalRelation)A1;
                            clazz = ((HadoopFsRelation)logicalRelation.relation()).fileFormat().getClass();
                        } else {
                            clazz = function1.apply(x1);
                        }
                        return (B1)clazz;
                    }

                    public final boolean isDefinedAt(LogicalPlan x1) {
                        LogicalPlan logicalPlan = x1;
                        boolean bl = logicalPlan instanceof LogicalRelation;
                        return bl;
                    }
                });
                Some $org_scalatest_assert_macro_right = new Some(OrcFileFormat.class);
                Option option = $org_scalatest_assert_macro_left;
                Some some = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 695));
            }));
        }, new Position("OrcQuerySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 681));
    }
}

