/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.json;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.Benchmark;
import org.apache.spark.util.Benchmark$;
import org.apache.spark.util.Utils$;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class JSONBenchmarks$ {
    public static JSONBenchmarks$ MODULE$;
    private final SparkConf conf;
    private final SparkSession spark;

    static {
        new JSONBenchmarks$();
    }

    public SparkConf conf() {
        return this.conf;
    }

    public SparkSession spark() {
        return this.spark;
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        File path = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
        path.delete();
        try {
            f.apply((Object)path);
        }
        finally {
            Utils$.MODULE$.deleteRecursively(path);
        }
    }

    public void schemaInferring(int rowsNum) {
        Benchmark benchmark = new Benchmark("JSON schema inferring", (long)rowsNum, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)path -> {
            JSONBenchmarks$.$anonfun$schemaInferring$1(benchmark, rowsNum, path);
            return BoxedUnit.UNIT;
        });
    }

    public void perlineParsing(int rowsNum) {
        Benchmark benchmark = new Benchmark("JSON per-line parsing", (long)rowsNum, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)path -> {
            JSONBenchmarks$.$anonfun$perlineParsing$1(benchmark, rowsNum, path);
            return BoxedUnit.UNIT;
        });
    }

    public void perlineParsingOfWideColumn(int rowsNum) {
        Benchmark benchmark = new Benchmark("JSON parsing of wide lines", (long)rowsNum, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)path -> {
            JSONBenchmarks$.$anonfun$perlineParsingOfWideColumn$1(benchmark, rowsNum, path);
            return BoxedUnit.UNIT;
        });
    }

    public void countBenchmark(int rowsNum) {
        int colsNum = 10;
        Benchmark benchmark = new Benchmark(new StringBuilder(29).append("Count a dataset with ").append(colsNum).append(" columns").toString(), (long)rowsNum, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)path -> {
            JSONBenchmarks$.$anonfun$countBenchmark$1(colsNum, rowsNum, benchmark, path);
            return BoxedUnit.UNIT;
        });
    }

    public void main(String[] args) {
        this.schemaInferring(100000000);
        this.perlineParsing(100000000);
        this.perlineParsingOfWideColumn(10000000);
        this.countBenchmark(10000000);
    }

    public static final /* synthetic */ String $anonfun$schemaInferring$2(long x$1) {
        return "a";
    }

    public static final /* synthetic */ void $anonfun$schemaInferring$1(Benchmark benchmark$1, int rowsNum$1, File path) {
        benchmark$1.out().println("Preparing data for benchmarking ...");
        MODULE$.spark().implicits().rddToDatasetHolder(MODULE$.spark().sparkContext().range(0L, (long)rowsNum$1, 1L, MODULE$.spark().sparkContext().range$default$4()).map((Function1 & Serializable & scala.Serializable)x$1 -> JSONBenchmarks$.$anonfun$schemaInferring$2(BoxesRunTime.unboxToLong((Object)x$1)), ClassTag$.MODULE$.apply(String.class)), MODULE$.spark().implicits().newStringEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fieldA"})).write().option("encoding", "UTF-8").json(path.getAbsolutePath());
        benchmark$1.addCase("No encoding", 3, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$2 -> MODULE$.spark().read().json(path.getAbsolutePath()));
        benchmark$1.addCase("UTF-8 is set", 3, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$3 -> MODULE$.spark().read().option("encoding", "UTF-8").json(path.getAbsolutePath()));
        benchmark$1.run();
    }

    public static final /* synthetic */ String $anonfun$perlineParsing$2(long x$4) {
        return "a";
    }

    public static final /* synthetic */ void $anonfun$perlineParsing$1(Benchmark benchmark$2, int rowsNum$2, File path) {
        benchmark$2.out().println("Preparing data for benchmarking ...");
        MODULE$.spark().implicits().rddToDatasetHolder(MODULE$.spark().sparkContext().range(0L, (long)rowsNum$2, 1L, MODULE$.spark().sparkContext().range$default$4()).map((Function1 & Serializable & scala.Serializable)x$4 -> JSONBenchmarks$.$anonfun$perlineParsing$2(BoxesRunTime.unboxToLong((Object)x$4)), ClassTag$.MODULE$.apply(String.class)), MODULE$.spark().implicits().newStringEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fieldA"})).write().json(path.getAbsolutePath());
        StructType schema = new StructType().add("fieldA", (DataType)StringType$.MODULE$);
        benchmark$2.addCase("No encoding", 3, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$5 -> MODULE$.spark().read().schema(schema).json(path.getAbsolutePath()).count());
        benchmark$2.addCase("UTF-8 is set", 3, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$6 -> MODULE$.spark().read().option("encoding", "UTF-8").schema(schema).json(path.getAbsolutePath()).count());
        benchmark$2.run();
    }

    public static final /* synthetic */ String $anonfun$perlineParsingOfWideColumn$2(long i) {
        String s = new StringOps(Predef$.MODULE$.augmentString("abcdef0123456789ABCDEF")).$times(20);
        return new StringBuilder(57).append("{\"a\":\"").append(s).append("\",\"b\": ").append(i).append(",\"c\":\"").append(s).append("\",\"d\":").append(i).append(",\"e\":\"").append(s).append("\",\"f\":").append(i).append(",\"x\":\"").append(s).append("\",\"y\":").append(i).append(",\"z\":\"").append(s).append("\"}").toString();
    }

    public static final /* synthetic */ void $anonfun$perlineParsingOfWideColumn$1(Benchmark benchmark$3, int rowsNum$3, File path) {
        benchmark$3.out().println("Preparing data for benchmarking ...");
        MODULE$.spark().implicits().rddToDatasetHolder(MODULE$.spark().sparkContext().range(0L, (long)rowsNum$3, 1L, MODULE$.spark().sparkContext().range$default$4()).map((Function1 & Serializable & scala.Serializable)i -> JSONBenchmarks$.$anonfun$perlineParsingOfWideColumn$2(BoxesRunTime.unboxToLong((Object)i)), ClassTag$.MODULE$.apply(String.class)), MODULE$.spark().implicits().newStringEncoder()).toDF().write().text(path.getAbsolutePath());
        StructType schema = new StructType().add("a", (DataType)StringType$.MODULE$).add("b", (DataType)LongType$.MODULE$).add("c", (DataType)StringType$.MODULE$).add("d", (DataType)LongType$.MODULE$).add("e", (DataType)StringType$.MODULE$).add("f", (DataType)LongType$.MODULE$).add("x", (DataType)StringType$.MODULE$).add("y", (DataType)LongType$.MODULE$).add("z", (DataType)StringType$.MODULE$);
        benchmark$3.addCase("No encoding", 3, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$7 -> MODULE$.spark().read().schema(schema).json(path.getAbsolutePath()).count());
        benchmark$3.addCase("UTF-8 is set", 3, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$8 -> MODULE$.spark().read().option("encoding", "UTF-8").schema(schema).json(path.getAbsolutePath()).count());
        benchmark$3.run();
    }

    public static final /* synthetic */ StructField $anonfun$countBenchmark$2(int i) {
        return new StructField(new StringBuilder(3).append("col").append(i).toString(), (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
    }

    public static final /* synthetic */ Column $anonfun$countBenchmark$3(int i) {
        return functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)i)).as(new StringBuilder(3).append("col").append(i).toString());
    }

    public static final /* synthetic */ boolean $anonfun$countBenchmark$5(Row x$10) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$countBenchmark$7(Row x$12) {
        return true;
    }

    public static final /* synthetic */ void $anonfun$countBenchmark$1(int colsNum$1, int rowsNum$4, Benchmark benchmark$4, File path) {
        Seq fields = (Seq)Seq$.MODULE$.tabulate(colsNum$1, (Function1 & Serializable & scala.Serializable)i -> JSONBenchmarks$.$anonfun$countBenchmark$2(BoxesRunTime.unboxToInt((Object)i)));
        StructType schema = StructType$.MODULE$.apply(fields);
        String[] columnNames = schema.fieldNames();
        MODULE$.spark().range((long)rowsNum$4).select((Seq)Seq$.MODULE$.tabulate(colsNum$1, (Function1 & Serializable & scala.Serializable)i -> JSONBenchmarks$.$anonfun$countBenchmark$3(BoxesRunTime.unboxToInt((Object)i)))).write().json(path.getAbsolutePath());
        Dataset ds = MODULE$.spark().read().schema(schema).json(path.getAbsolutePath());
        benchmark$4.addCase(new StringBuilder(25).append("Select ").append(colsNum$1).append(" columns + count()").toString(), 3, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$9 -> ds.select("*", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).filter((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)JSONBenchmarks$.$anonfun$countBenchmark$5(x$10))).count());
        benchmark$4.addCase("Select 1 column + count()", 3, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$11 -> ds.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{MODULE$.spark().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"col1"}))).$((Seq)Nil$.MODULE$)})).filter((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)JSONBenchmarks$.$anonfun$countBenchmark$7(x$12))).count());
        benchmark$4.run();
    }

    private JSONBenchmarks$() {
        MODULE$ = this;
        this.conf = new SparkConf();
        this.spark = SparkSession$.MODULE$.builder().master("local[1]").appName("benchmark-json-datasource").config(this.conf()).getOrCreate();
    }
}

