/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.columnar.BOOLEAN$;
import org.apache.spark.sql.execution.columnar.BYTE$;
import org.apache.spark.sql.execution.columnar.BooleanColumnStats;
import org.apache.spark.sql.execution.columnar.ByteColumnStats;
import org.apache.spark.sql.execution.columnar.COMPACT_DECIMAL;
import org.apache.spark.sql.execution.columnar.ColumnStats;
import org.apache.spark.sql.execution.columnar.ColumnType;
import org.apache.spark.sql.execution.columnar.ColumnarTestUtils$;
import org.apache.spark.sql.execution.columnar.DOUBLE$;
import org.apache.spark.sql.execution.columnar.DecimalColumnStats;
import org.apache.spark.sql.execution.columnar.DoubleColumnStats;
import org.apache.spark.sql.execution.columnar.FLOAT$;
import org.apache.spark.sql.execution.columnar.FloatColumnStats;
import org.apache.spark.sql.execution.columnar.INT$;
import org.apache.spark.sql.execution.columnar.IntColumnStats;
import org.apache.spark.sql.execution.columnar.LONG$;
import org.apache.spark.sql.execution.columnar.LongColumnStats;
import org.apache.spark.sql.execution.columnar.NativeColumnType;
import org.apache.spark.sql.execution.columnar.SHORT$;
import org.apache.spark.sql.execution.columnar.STRING$;
import org.apache.spark.sql.execution.columnar.ShortColumnStats;
import org.apache.spark.sql.execution.columnar.StringColumnStats;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Double$;
import scala.Float$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001e3A\u0001B\u0003\u0001%!)q\u0003\u0001C\u00011!)1\u0004\u0001C\u00019!)1\u000b\u0001C\u0001)\n\u00012i\u001c7v[:\u001cF/\u0019;t'VLG/\u001a\u0006\u0003\r\u001d\t\u0001bY8mk6t\u0017M\u001d\u0006\u0003\u0011%\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005)Y\u0011aA:rY*\u0011A\"D\u0001\u0006gB\f'o\u001b\u0006\u0003\u001d=\ta!\u00199bG\",'\"\u0001\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0019\u0002C\u0001\u000b\u0016\u001b\u0005Y\u0011B\u0001\f\f\u00055\u0019\u0006/\u0019:l\rVt7+^5uK\u00061A(\u001b8jiz\"\u0012!\u0007\t\u00035\u0001i\u0011!B\u0001\u0010i\u0016\u001cHoQ8mk6t7\u000b^1ugV\u0019QDQ\u001a\u0015\ty!Ch\u0013\t\u0003?\tj\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\t\u0002\u0005+:LG\u000fC\u0003&\u0005\u0001\u0007a%\u0001\td_2,XN\\*uCR\u001c8\t\\1tgB\u0019qEL\u0019\u000f\u0005!b\u0003CA\u0015!\u001b\u0005Q#BA\u0016\u0012\u0003\u0019a$o\\8u}%\u0011Q\u0006I\u0001\u0007!J,G-\u001a4\n\u0005=\u0002$!B\"mCN\u001c(BA\u0017!!\t\u00114\u0007\u0004\u0001\u0005\u000bQ\u0012!\u0019A\u001b\u0003\u0003U\u000b\"AN\u001d\u0011\u0005}9\u0014B\u0001\u001d!\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"A\u0007\u001e\n\u0005m*!aC\"pYVlgn\u0015;biNDQ!\u0010\u0002A\u0002y\n!bY8mk6tG+\u001f9f!\rQr(Q\u0005\u0003\u0001\u0016\u0011\u0001CT1uSZ,7i\u001c7v[:$\u0016\u0010]3\u0011\u0005I\u0012E!B\"\u0003\u0005\u0004!%!\u0001+\u0012\u0005Y*\u0005C\u0001$J\u001b\u00059%B\u0001%\n\u0003\u0015!\u0018\u0010]3t\u0013\tQuI\u0001\u0006Bi>l\u0017n\u0019+za\u0016DQ\u0001\u0014\u0002A\u00025\u000b\u0011#\u001b8ji&\fGn\u0015;bi&\u001cH/[2t!\ryb\nU\u0005\u0003\u001f\u0002\u0012Q!\u0011:sCf\u0004\"aH)\n\u0005I\u0003#aA!os\u00061B/Z:u\t\u0016\u001c\u0017.\\1m\u0007>dW/\u001c8Ti\u0006$8/F\u0002V/b#\"A\b,\t\u000b1\u001b\u0001\u0019A'\u0005\u000b\r\u001b!\u0019\u0001#\u0005\u000bQ\u001a!\u0019A\u001b")
public class ColumnStatsSuite
extends SparkFunSuite {
    public <T extends AtomicType, U extends ColumnStats> void testColumnStats(Class<U> columnStatsClass, NativeColumnType<T> columnType, Object[] initialStatistics) {
        String columnStatsName = columnStatsClass.getSimpleName();
        this.test(new StringBuilder(7).append(columnStatsName).append(": empty").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ColumnStats columnStats = (ColumnStats)columnStatsClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps((Object)columnStats.collectedStatistics()).zip((GenIterable)Predef$.MODULE$.genericWrapArray((Object)initialStatistics), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Object actual = tuple2._1();
                Object expected = tuple2._2();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(actual);
                Object $org_scalatest_assert_macro_right = expected;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertion assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
                return assertion;
            });
        }, new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
        this.test(new StringBuilder(11).append(columnStatsName).append(": non-empty").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            ColumnStats columnStats = (ColumnStats)columnStatsClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            Seq rows = (Seq)((TraversableLike)Seq$.MODULE$.fill(10, (Function0 & Serializable & scala.Serializable)() -> ColumnarTestUtils$.MODULE$.makeRandomRow((ColumnType<?>)columnType, (Seq<ColumnType<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ColumnType[0])))).$plus$plus((GenTraversableOnce)Seq$.MODULE$.fill(10, (Function0 & Serializable & scala.Serializable)() -> ColumnarTestUtils$.MODULE$.makeNullRow(1)), Seq$.MODULE$.canBuildFrom());
            rows.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                columnStats.gatherStats(x$1, 0);
                return BoxedUnit.UNIT;
            });
            Seq values = (Seq)((TraversableLike)rows.take(10)).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.get(0, (DataType)columnType.dataType()), Seq$.MODULE$.canBuildFrom());
            Ordering ordering = columnType.dataType().ordering();
            Object[] stats = columnStats.collectedStatistics();
            this.assertResult(values.min(ordering), "Wrong lower bound", stats[0], Prettifier$.MODULE$.default(), new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
            this.assertResult(values.max(ordering), "Wrong upper bound", stats[1], Prettifier$.MODULE$.default(), new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
            this.assertResult(BoxesRunTime.boxToInteger((int)10), "Wrong null count", stats[2], Prettifier$.MODULE$.default(), new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
            this.assertResult(BoxesRunTime.boxToInteger((int)20), "Wrong row count", stats[3], Prettifier$.MODULE$.default(), new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
            return this.assertResult(stats[4], "Wrong size in bytes", ((TraversableOnce)rows.map((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToInteger((int)ColumnStatsSuite.$anonfun$testColumnStats$8(columnType, row)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$), Prettifier$.MODULE$.default(), new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        }, new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
    }

    public <T extends AtomicType, U extends ColumnStats> void testDecimalColumnStats(Object[] initialStatistics) {
        String columnStatsName = DecimalColumnStats.class.getSimpleName();
        COMPACT_DECIMAL columnType = new COMPACT_DECIMAL(15, 10);
        this.test(new StringBuilder(7).append(columnStatsName).append(": empty").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            DecimalColumnStats columnStats = new DecimalColumnStats(15, 10);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps((Object)columnStats.collectedStatistics()).zip((GenIterable)Predef$.MODULE$.genericWrapArray((Object)initialStatistics), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Object actual = tuple2._1();
                Object expected = tuple2._2();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(actual);
                Object $org_scalatest_assert_macro_right = expected;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertion assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
                return assertion;
            });
        }, new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        this.test(new StringBuilder(11).append(columnStatsName).append(": non-empty").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            DecimalColumnStats columnStats = new DecimalColumnStats(15, 10);
            Seq rows = (Seq)((TraversableLike)Seq$.MODULE$.fill(10, (Function0 & Serializable & scala.Serializable)() -> ColumnarTestUtils$.MODULE$.makeRandomRow((ColumnType<?>)columnType, (Seq<ColumnType<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ColumnType[0])))).$plus$plus((GenTraversableOnce)Seq$.MODULE$.fill(10, (Function0 & Serializable & scala.Serializable)() -> ColumnarTestUtils$.MODULE$.makeNullRow(1)), Seq$.MODULE$.canBuildFrom());
            rows.foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                columnStats.gatherStats(x$3, 0);
                return BoxedUnit.UNIT;
            });
            Seq values = (Seq)((TraversableLike)rows.take(10)).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.get(0, (DataType)columnType.dataType()), Seq$.MODULE$.canBuildFrom());
            Decimal.DecimalIsFractional$ ordering = ((DecimalType)columnType.dataType()).ordering();
            Object[] stats = columnStats.collectedStatistics();
            this.assertResult(values.min((Ordering)ordering), "Wrong lower bound", stats[0], Prettifier$.MODULE$.default(), new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
            this.assertResult(values.max((Ordering)ordering), "Wrong upper bound", stats[1], Prettifier$.MODULE$.default(), new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
            this.assertResult(BoxesRunTime.boxToInteger((int)10), "Wrong null count", stats[2], Prettifier$.MODULE$.default(), new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
            this.assertResult(BoxesRunTime.boxToInteger((int)20), "Wrong row count", stats[3], Prettifier$.MODULE$.default(), new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
            return this.assertResult(stats[4], "Wrong size in bytes", ((TraversableOnce)rows.map((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToInteger((int)ColumnStatsSuite.$anonfun$testDecimalColumnStats$8(columnType, row)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$), Prettifier$.MODULE$.default(), new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        }, new Position("ColumnStatsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
    }

    public static final /* synthetic */ int $anonfun$testColumnStats$8(NativeColumnType columnType$1, InternalRow row) {
        return row.isNullAt(0) ? 4 : columnType$1.actualSize(row, 0);
    }

    public static final /* synthetic */ int $anonfun$testDecimalColumnStats$8(COMPACT_DECIMAL columnType$2, InternalRow row) {
        return row.isNullAt(0) ? 4 : columnType$2.actualSize(row, 0);
    }

    public ColumnStatsSuite() {
        this.testColumnStats((Class)BooleanColumnStats.class, (NativeColumnType)BOOLEAN$.MODULE$, (Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToInteger((int)0)}), ClassTag$.MODULE$.Any()));
        this.testColumnStats((Class)ByteColumnStats.class, (NativeColumnType)BYTE$.MODULE$, (Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)127), BoxesRunTime.boxToByte((byte)-128), BoxesRunTime.boxToInteger((int)0)}), ClassTag$.MODULE$.Any()));
        this.testColumnStats((Class)ShortColumnStats.class, (NativeColumnType)SHORT$.MODULE$, (Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)Short.MAX_VALUE), BoxesRunTime.boxToShort((short)Short.MIN_VALUE), BoxesRunTime.boxToInteger((int)0)}), ClassTag$.MODULE$.Any()));
        this.testColumnStats((Class)IntColumnStats.class, (NativeColumnType)INT$.MODULE$, (Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE), BoxesRunTime.boxToInteger((int)Integer.MIN_VALUE), BoxesRunTime.boxToInteger((int)0)}), ClassTag$.MODULE$.Any()));
        this.testColumnStats((Class)LongColumnStats.class, (NativeColumnType)LONG$.MODULE$, (Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)Long.MAX_VALUE), BoxesRunTime.boxToLong((long)Long.MIN_VALUE), BoxesRunTime.boxToInteger((int)0)}), ClassTag$.MODULE$.Any()));
        this.testColumnStats((Class)FloatColumnStats.class, (NativeColumnType)FLOAT$.MODULE$, (Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToFloat((float)Float.MAX_VALUE), BoxesRunTime.boxToFloat((float)Float$.MODULE$.MinValue()), BoxesRunTime.boxToInteger((int)0)}), ClassTag$.MODULE$.Any()));
        this.testColumnStats((Class)DoubleColumnStats.class, (NativeColumnType)DOUBLE$.MODULE$, (Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)Double.MAX_VALUE), BoxesRunTime.boxToDouble((double)Double$.MODULE$.MinValue()), BoxesRunTime.boxToInteger((int)0)}), ClassTag$.MODULE$.Any()));
        this.testColumnStats((Class)StringColumnStats.class, (NativeColumnType)STRING$.MODULE$, (Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, BoxesRunTime.boxToInteger((int)0)}), ClassTag$.MODULE$.Any()));
        this.testDecimalColumnStats((Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, BoxesRunTime.boxToInteger((int)0)}), ClassTag$.MODULE$.Any()));
    }
}

