/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.benchmark;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder$;
import org.apache.spark.sql.catalyst.expressions.UnsafeArrayData;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.execution.benchmark.BenchmarkBase;
import org.apache.spark.sql.execution.benchmark.UnsafeArrayDataBenchmark$;
import org.apache.spark.util.Benchmark;
import org.apache.spark.util.Benchmark$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001m2Aa\u0002\u0005\u0001+!)a\u0004\u0001C\u0001?!)\u0011\u0005\u0001C\u0001E!)1\u0006\u0001C\u0001Y!)!\u0007\u0001C\u0001g!)Q\u0007\u0001C\u0001m!)\u0001\b\u0001C\u0001s\tARK\\:bM\u0016\f%O]1z\t\u0006$\u0018MQ3oG\"l\u0017M]6\u000b\u0005%Q\u0011!\u00032f]\u000eDW.\u0019:l\u0015\tYA\"A\u0005fq\u0016\u001cW\u000f^5p]*\u0011QBD\u0001\u0004gFd'BA\b\u0011\u0003\u0015\u0019\b/\u0019:l\u0015\t\t\"#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002'\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0006\u000e\u0011\u0005]AR\"\u0001\b\n\u0005eq!!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002\u001c95\t\u0001\"\u0003\u0002\u001e\u0011\ti!)\u001a8dQ6\f'o\u001b\"bg\u0016\fa\u0001P5oSRtD#\u0001\u0011\u0011\u0005m\u0001\u0011!H2bY\u000e,H.\u0019;f\u0011\u0016\fG-\u001a:Q_J$\u0018n\u001c8J]\nKH/Z:\u0015\u0005\rJ\u0003C\u0001\u0013(\u001b\u0005)#\"\u0001\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005!*#aA%oi\")!F\u0001a\u0001G\u0005)1m\\;oi\u0006y!/Z1e+:\u001c\u0018MZ3BeJ\f\u0017\u0010\u0006\u0002.aA\u0011AEL\u0005\u0003_\u0015\u0012A!\u00168ji\")\u0011g\u0001a\u0001G\u0005)\u0011\u000e^3sg\u0006\u0001rO]5uKVs7/\u00194f\u0003J\u0014\u0018-\u001f\u000b\u0003[QBQ!\r\u0003A\u0002\r\n\u0011cZ3u!JLW.\u001b;jm\u0016\f%O]1z)\tis\u0007C\u00032\u000b\u0001\u00071%A\tqkR\u0004&/[7ji&4X-\u0011:sCf$\"!\f\u001e\t\u000bE2\u0001\u0019A\u0012")
public class UnsafeArrayDataBenchmark
extends SparkFunSuite
implements BenchmarkBase {
    private SparkSession sparkSession;
    private volatile boolean bitmap$0;

    @Override
    public void runBenchmark(String name, long cardinality, Function0<BoxedUnit> f) {
        BenchmarkBase.runBenchmark$(this, name, cardinality, f);
    }

    private SparkSession sparkSession$lzycompute() {
        UnsafeArrayDataBenchmark unsafeArrayDataBenchmark = this;
        synchronized (unsafeArrayDataBenchmark) {
            if (!this.bitmap$0) {
                this.sparkSession = BenchmarkBase.sparkSession$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkSession;
    }

    @Override
    public SparkSession sparkSession() {
        return !this.bitmap$0 ? this.sparkSession$lzycompute() : this.sparkSession;
    }

    public int calculateHeaderPortionInBytes(int count) {
        return UnsafeArrayData.calculateHeaderPortionInBytes((int)count);
    }

    public void readUnsafeArray(int iters) {
        int count = 0x1000000;
        Random rand = new Random(42);
        int[] intPrimitiveArray = (int[])Array$.MODULE$.fill(count, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> rand.nextInt(), ClassTag$.MODULE$.Int());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(UnsafeArrayDataBenchmark.class.getClassLoader());
        public final class Org_apache_spark_sql_execution_benchmark_UnsafeArrayDataBenchmark$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$));
            }

            public Org_apache_spark_sql_execution_benchmark_UnsafeArrayDataBenchmark$$typecreator1$1(UnsafeArrayDataBenchmark $outer) {
            }
        }
        ExpressionEncoder qual$1 = ExpressionEncoder$.MODULE$.apply(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_benchmark_UnsafeArrayDataBenchmark$$typecreator1$1(null)));
        Seq x$1 = qual$1.resolveAndBind$default$1();
        Analyzer x$2 = qual$1.resolveAndBind$default$2();
        ExpressionEncoder intEncoder = qual$1.resolveAndBind(x$1, x$2);
        ArrayData intUnsafeArray = intEncoder.toRow((Object)intPrimitiveArray).getArray(0);
        JFunction1.mcVI.sp & Serializable & scala.Serializable readIntArray = (JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            for (int n = 0; n < iters; ++n) {
                int len = intUnsafeArray.numElements();
                int sum = 0;
                for (int i2 = 0; i2 < len; ++i2) {
                    sum += intUnsafeArray.getInt(i2);
                }
            }
        };
        double[] doublePrimitiveArray = (double[])Array$.MODULE$.fill(count, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> rand.nextDouble(), ClassTag$.MODULE$.Double());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(UnsafeArrayDataBenchmark.class.getClassLoader());
        public final class Org_apache_spark_sql_execution_benchmark_UnsafeArrayDataBenchmark$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$));
            }

            public Org_apache_spark_sql_execution_benchmark_UnsafeArrayDataBenchmark$$typecreator2$1(UnsafeArrayDataBenchmark $outer) {
            }
        }
        ExpressionEncoder qual$2 = ExpressionEncoder$.MODULE$.apply(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_execution_benchmark_UnsafeArrayDataBenchmark$$typecreator2$1(null)));
        Seq x$3 = qual$2.resolveAndBind$default$1();
        Analyzer x$4 = qual$2.resolveAndBind$default$2();
        ExpressionEncoder doubleEncoder = qual$2.resolveAndBind(x$3, x$4);
        ArrayData doubleUnsafeArray = doubleEncoder.toRow((Object)doublePrimitiveArray).getArray(0);
        JFunction1.mcVI.sp & Serializable & scala.Serializable readDoubleArray = (JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            for (int n = 0; n < iters; ++n) {
                int len = doubleUnsafeArray.numElements();
                double sum = 0.0;
                for (int i2 = 0; i2 < len; ++i2) {
                    sum += doubleUnsafeArray.getDouble(i2);
                }
            }
        };
        Benchmark benchmark = new Benchmark("Read UnsafeArrayData", (long)(count * iters), Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        benchmark.addCase("Int", benchmark.addCase$default$2(), (Function1)readIntArray);
        benchmark.addCase("Double", benchmark.addCase$default$2(), (Function1)readDoubleArray);
        benchmark.run();
    }

    public void writeUnsafeArray(int iters) {
        int count = 0x200000;
        Random rand = new Random(42);
        IntRef intTotalLength = IntRef.create((int)0);
        int[] intPrimitiveArray = (int[])Array$.MODULE$.fill(count, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> rand.nextInt(), ClassTag$.MODULE$.Int());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(UnsafeArrayDataBenchmark.class.getClassLoader());
        public final class Org_apache_spark_sql_execution_benchmark_UnsafeArrayDataBenchmark$$typecreator1$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$));
            }

            public Org_apache_spark_sql_execution_benchmark_UnsafeArrayDataBenchmark$$typecreator1$2(UnsafeArrayDataBenchmark $outer) {
            }
        }
        ExpressionEncoder qual$1 = ExpressionEncoder$.MODULE$.apply(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_benchmark_UnsafeArrayDataBenchmark$$typecreator1$2(null)));
        Seq x$1 = qual$1.resolveAndBind$default$1();
        Analyzer x$2 = qual$1.resolveAndBind$default$2();
        ExpressionEncoder intEncoder = qual$1.resolveAndBind(x$1, x$2);
        JFunction1.mcVI.sp & Serializable & scala.Serializable writeIntArray = (JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            int len = 0;
            for (int n = 0; n < iters; ++n) {
                len += intEncoder.toRow((Object)intPrimitiveArray).getArray(0).numElements();
            }
            intTotalLength$1.elem = len;
        };
        IntRef doubleTotalLength = IntRef.create((int)0);
        double[] doublePrimitiveArray = (double[])Array$.MODULE$.fill(count, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> rand.nextDouble(), ClassTag$.MODULE$.Double());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(UnsafeArrayDataBenchmark.class.getClassLoader());
        public final class Org_apache_spark_sql_execution_benchmark_UnsafeArrayDataBenchmark$$typecreator2$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$));
            }

            public Org_apache_spark_sql_execution_benchmark_UnsafeArrayDataBenchmark$$typecreator2$2(UnsafeArrayDataBenchmark $outer) {
            }
        }
        ExpressionEncoder qual$2 = ExpressionEncoder$.MODULE$.apply(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_execution_benchmark_UnsafeArrayDataBenchmark$$typecreator2$2(null)));
        Seq x$3 = qual$2.resolveAndBind$default$1();
        Analyzer x$4 = qual$2.resolveAndBind$default$2();
        ExpressionEncoder doubleEncoder = qual$2.resolveAndBind(x$3, x$4);
        JFunction1.mcVI.sp & Serializable & scala.Serializable writeDoubleArray = (JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            int len = 0;
            for (int n = 0; n < iters; ++n) {
                len += doubleEncoder.toRow((Object)doublePrimitiveArray).getArray(0).numElements();
            }
            doubleTotalLength$1.elem = len;
        };
        Benchmark benchmark = new Benchmark("Write UnsafeArrayData", (long)(count * iters), Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        benchmark.addCase("Int", benchmark.addCase$default$2(), (Function1)writeIntArray);
        benchmark.addCase("Double", benchmark.addCase$default$2(), (Function1)writeDoubleArray);
        benchmark.run();
    }

    public void getPrimitiveArray(int iters) {
        int count = 0xC00000;
        Random rand = new Random(42);
        IntRef intTotalLength = IntRef.create((int)0);
        int[] intPrimitiveArray = (int[])Array$.MODULE$.fill(count, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> rand.nextInt(), ClassTag$.MODULE$.Int());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(UnsafeArrayDataBenchmark.class.getClassLoader());
        public final class Org_apache_spark_sql_execution_benchmark_UnsafeArrayDataBenchmark$$typecreator1$3
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$));
            }

            public Org_apache_spark_sql_execution_benchmark_UnsafeArrayDataBenchmark$$typecreator1$3(UnsafeArrayDataBenchmark $outer) {
            }
        }
        ExpressionEncoder qual$1 = ExpressionEncoder$.MODULE$.apply(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_execution_benchmark_UnsafeArrayDataBenchmark$$typecreator1$3(null)));
        Seq x$1 = qual$1.resolveAndBind$default$1();
        Analyzer x$2 = qual$1.resolveAndBind$default$2();
        ExpressionEncoder intEncoder = qual$1.resolveAndBind(x$1, x$2);
        ArrayData intUnsafeArray = intEncoder.toRow((Object)intPrimitiveArray).getArray(0);
        JFunction1.mcVI.sp & Serializable & scala.Serializable readIntArray = (JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            int len = 0;
            for (int n = 0; n < iters; ++n) {
                len += intUnsafeArray.toIntArray().length;
            }
            intTotalLength$2.elem = len;
        };
        IntRef doubleTotalLength = IntRef.create((int)0);
        double[] doublePrimitiveArray = (double[])Array$.MODULE$.fill(count, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> rand.nextDouble(), ClassTag$.MODULE$.Double());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(UnsafeArrayDataBenchmark.class.getClassLoader());
        public final class Org_apache_spark_sql_execution_benchmark_UnsafeArrayDataBenchmark$$typecreator2$3
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$));
            }

            public Org_apache_spark_sql_execution_benchmark_UnsafeArrayDataBenchmark$$typecreator2$3(UnsafeArrayDataBenchmark $outer) {
            }
        }
        ExpressionEncoder qual$2 = ExpressionEncoder$.MODULE$.apply(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_execution_benchmark_UnsafeArrayDataBenchmark$$typecreator2$3(null)));
        Seq x$3 = qual$2.resolveAndBind$default$1();
        Analyzer x$4 = qual$2.resolveAndBind$default$2();
        ExpressionEncoder doubleEncoder = qual$2.resolveAndBind(x$3, x$4);
        ArrayData doubleUnsafeArray = doubleEncoder.toRow((Object)doublePrimitiveArray).getArray(0);
        JFunction1.mcVI.sp & Serializable & scala.Serializable readDoubleArray = (JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            int len = 0;
            for (int n = 0; n < iters; ++n) {
                len += doubleUnsafeArray.toDoubleArray().length;
            }
            doubleTotalLength$2.elem = len;
        };
        Benchmark benchmark = new Benchmark("Get primitive array from UnsafeArrayData", (long)(count * iters), Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        benchmark.addCase("Int", benchmark.addCase$default$2(), (Function1)readIntArray);
        benchmark.addCase("Double", benchmark.addCase$default$2(), (Function1)readDoubleArray);
        benchmark.run();
    }

    public void putPrimitiveArray(int iters) {
        int count = 0xC00000;
        Random rand = new Random(42);
        IntRef intTotalLen = IntRef.create((int)0);
        int[] intPrimitiveArray = (int[])Array$.MODULE$.fill(count, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> rand.nextInt(), ClassTag$.MODULE$.Int());
        JFunction1.mcVI.sp & Serializable & scala.Serializable createIntArray = (JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            int len = 0;
            for (int n = 0; n < iters; ++n) {
                len += UnsafeArrayData.fromPrimitiveArray((int[])intPrimitiveArray).numElements();
            }
            intTotalLen$1.elem = len;
        };
        IntRef doubleTotalLen = IntRef.create((int)0);
        double[] doublePrimitiveArray = (double[])Array$.MODULE$.fill(count, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> rand.nextDouble(), ClassTag$.MODULE$.Double());
        JFunction1.mcVI.sp & Serializable & scala.Serializable createDoubleArray = (JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            int len = 0;
            for (int n = 0; n < iters; ++n) {
                len += UnsafeArrayData.fromPrimitiveArray((double[])doublePrimitiveArray).numElements();
            }
            doubleTotalLen$1.elem = len;
        };
        Benchmark benchmark = new Benchmark("Create UnsafeArrayData from primitive array", (long)(count * iters), Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        benchmark.addCase("Int", benchmark.addCase$default$2(), (Function1)createIntArray);
        benchmark.addCase("Double", benchmark.addCase$default$2(), (Function1)createDoubleArray);
        benchmark.run();
    }

    public UnsafeArrayDataBenchmark() {
        BenchmarkBase.$init$(this);
        this.ignore("Benchmark UnsafeArrayData", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.readUnsafeArray(10);
            this.writeUnsafeArray(10);
            this.getPrimitiveArray(5);
            this.putPrimitiveArray(5);
        }, new Position("UnsafeArrayDataBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 226));
    }
}

