/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.benchmark;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.execution.benchmark.BenchmarkBeforeAndAfterEachTest;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.util.Benchmark;
import org.apache.spark.util.Benchmark$;
import org.apache.spark.util.Utils$;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.BeforeAndAfterEachTestData;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.TestData;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.Tuple2Zipped;
import scala.runtime.Tuple2Zipped$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005h\u0001\u0002\u0011\"\u00019BQa\u000e\u0001\u0005\u0002aBqA\u000f\u0001C\u0002\u0013%1\b\u0003\u0004@\u0001\u0001\u0006I\u0001\u0010\u0005\b\u0001\u0002\u0011\r\u0011\"\u0003B\u0011\u0019A\u0005\u0001)A\u0005\u0005\"9\u0011\n\u0001b\u0001\n\u0013\t\u0005B\u0002&\u0001A\u0003%!\tC\u0004L\u0001\t\u0007I\u0011B!\t\r1\u0003\u0001\u0015!\u0003C\u0011\u001di\u0005A1A\u0005\n\u0005CaA\u0014\u0001!\u0002\u0013\u0011\u0005b\u0002\u0015\u0001\u0005\u0004%Ia\u0014\u0005\u0007)\u0002\u0001\u000b\u0011\u0002)\t\u0013U\u0003\u0001\u0019!a\u0001\n\u00131\u0006\"C0\u0001\u0001\u0004\u0005\r\u0011\"\u0003a\u0011%1\u0007\u00011A\u0001B\u0003&q\u000bC\u0003h\u0001\u0011\u0005\u0003\u000eC\u0003j\u0001\u0011\u0005#\u000eC\u0003t\u0001\u0011\u0005C\u000fC\u0003w\u0001\u0011\u0005\u0003\u000eC\u0003x\u0001\u0011\u0005\u0001\u0010C\u0004\u0002\u0004\u0001!\t!!\u0002\t\u000f\u0005E\u0002\u0001\"\u0001\u00024!9\u0011Q\t\u0001\u0005\n\u0005\u001d\u0003bBA.\u0001\u0011%\u0011Q\f\u0005\b\u0003S\u0002A\u0011BA6\u0011%\t)\nAI\u0001\n\u0013\t9\nC\u0004\u0002.\u0002!\t!a,\t\u0013\u0005\u0005\u0007!%A\u0005\u0002\u0005\r\u0007bBAd\u0001\u0011%\u0011\u0011\u001a\u0005\b\u0003#\u0004A\u0011BAj\u0005]1\u0015\u000e\u001c;feB+8\u000f\u001b3po:\u0014UM\\2i[\u0006\u00148N\u0003\u0002#G\u0005I!-\u001a8dQ6\f'o\u001b\u0006\u0003I\u0015\n\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005\u0019:\u0013aA:rY*\u0011\u0001&K\u0001\u0006gB\f'o\u001b\u0006\u0003U-\na!\u00199bG\",'\"\u0001\u0017\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001y3\u0007\u0005\u00021c5\tq%\u0003\u00023O\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"\u0001N\u001b\u000e\u0003\u0005J!AN\u0011\u0003?\t+gn\u00195nCJ\\')\u001a4pe\u0016\fe\u000eZ!gi\u0016\u0014X)Y2i)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u0002sA\u0011A\u0007A\u0001\u0005G>tg-F\u0001=!\t\u0001T(\u0003\u0002?O\tI1\u000b]1sW\u000e{gNZ\u0001\u0006G>tg\rI\u0001\b]Vl'k\\<t+\u0005\u0011\u0005CA\"G\u001b\u0005!%\"A#\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d#%aA%oi\u0006Aa.^7S_^\u001c\b%A\u0003xS\u0012$\b.\u0001\u0004xS\u0012$\b\u000eI\u0001\u0004[&$\u0017\u0001B7jI\u0002\n\u0011B\u00197pG.\u001c\u0016N_3\u0002\u0015\tdwnY6TSj,\u0007%F\u0001Q!\t\t&+D\u0001&\u0013\t\u0019VE\u0001\u0007Ta\u0006\u00148nU3tg&|g.\u0001\u0004ta\u0006\u00148\u000eI\u0001\u0004_V$X#A,\u0011\u0005akV\"A-\u000b\u0005i[\u0016AA5p\u0015\u0005a\u0016\u0001\u00026bm\u0006L!AX-\u0003\u0019=+H\u000f];u'R\u0014X-Y7\u0002\u000f=,Ho\u0018\u0013fcR\u0011\u0011\r\u001a\t\u0003\u0007\nL!a\u0019#\u0003\tUs\u0017\u000e\u001e\u0005\bK>\t\t\u00111\u0001X\u0003\rAH%M\u0001\u0005_V$\b%A\u0005cK\u001a|'/Z!mYR\t\u0011-\u0001\u0006cK\u001a|'/Z#bG\"$\"!Y6\t\u000b1\u0014\u0002\u0019A7\u0002\u0005Q$\u0007C\u00018r\u001b\u0005y'B\u00019,\u0003%\u00198-\u00197bi\u0016\u001cH/\u0003\u0002s_\nAA+Z:u\t\u0006$\u0018-A\u0005bMR,'/R1dQR\u0011\u0011-\u001e\u0005\u0006YN\u0001\r!\\\u0001\tC\u001a$XM]!mY\u0006aq/\u001b;i)\u0016l\u0007\u000fU1uQR\u0011\u0011-\u001f\u0005\u0006uV\u0001\ra_\u0001\u0002MB!1\t @b\u0013\tiHIA\u0005Gk:\u001cG/[8ocA\u0011\u0001l`\u0005\u0004\u0003\u0003I&\u0001\u0002$jY\u0016\fQb^5uQR+W\u000e\u001d+bE2,G\u0003BA\u0004\u0003#!2!YA\u0005\u0011\u001dQh\u0003\"a\u0001\u0003\u0017\u0001BaQA\u0007C&\u0019\u0011q\u0002#\u0003\u0011q\u0012\u0017P\\1nKzBq!a\u0005\u0017\u0001\u0004\t)\"\u0001\u0006uC\ndWMT1nKN\u0004RaQA\f\u00037I1!!\u0007E\u0005)a$/\u001a9fCR,GM\u0010\t\u0005\u0003;\tYC\u0004\u0003\u0002 \u0005\u001d\u0002cAA\u0011\t6\u0011\u00111\u0005\u0006\u0004\u0003Ki\u0013A\u0002\u001fs_>$h(C\u0002\u0002*\u0011\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u0017\u0003_\u0011aa\u0015;sS:<'bAA\u0015\t\u0006Yq/\u001b;i'Fc5i\u001c8g)\u0011\t)$!\u000f\u0015\u0007\u0005\f9\u0004C\u0004{/\u0011\u0005\r!a\u0003\t\u000f\u0005mr\u00031\u0001\u0002>\u0005)\u0001/Y5sgB)1)a\u0006\u0002@A91)!\u0011\u0002\u001c\u0005m\u0011bAA\"\t\n1A+\u001e9mKJ\nA\u0002\u001d:fa\u0006\u0014X\rV1cY\u0016$\u0012\"YA%\u0003\u001b\ny%!\u0015\t\r\u0005-\u0003\u00041\u0001\u007f\u0003\r!\u0017N\u001d\u0005\u0006\u0001b\u0001\rA\u0011\u0005\u0006\u0013b\u0001\rA\u0011\u0005\b\u0003'B\u0002\u0019AA+\u0003E)8/Z*ue&twMR8s-\u0006dW/\u001a\t\u0004\u0007\u0006]\u0013bAA-\t\n9!i\\8mK\u0006t\u0017A\u00069sKB\f'/Z*ue&tw\rR5diR\u000b'\r\\3\u0015\u0013\u0005\fy&!\u0019\u0002d\u0005\u001d\u0004BBA&3\u0001\u0007a\u0010C\u0003A3\u0001\u0007!\t\u0003\u0004\u0002fe\u0001\rAQ\u0001\u0012]VlG)[:uS:\u001cGOV1mk\u0016\u001c\b\"B%\u001a\u0001\u0004\u0011\u0015aC:bm\u0016\f5\u000fV1cY\u0016$r!YA7\u0003\u001f\u000b\t\nC\u0004\u0002pi\u0001\r!!\u001d\u0002\u0005\u00114\u0007\u0003BA:\u0003\u0013sA!!\u001e\u0002\u0006:!\u0011qOAB\u001d\u0011\tI(!!\u000f\t\u0005m\u0014q\u0010\b\u0005\u0003C\ti(C\u0001-\u0013\tQ3&\u0003\u0002)S%\u0011aeJ\u0005\u0004\u0003\u000f+\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003\u0017\u000biIA\u0005ECR\fgI]1nK*\u0019\u0011qQ\u0013\t\r\u0005-#\u00041\u0001\u007f\u0011%\t\u0019J\u0007I\u0001\u0002\u0004\t)&A\u0007vg\u0016$\u0015n\u0019;j_:\f'/_\u0001\u0016g\u00064X-Q:UC\ndW\r\n3fM\u0006,H\u000e\u001e\u00134+\t\tIJ\u000b\u0003\u0002V\u0005m5FAAO!\u0011\ty*!+\u000e\u0005\u0005\u0005&\u0002BAR\u0003K\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u001dF)\u0001\u0006b]:|G/\u0019;j_:LA!a+\u0002\"\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002/\u0019LG\u000e^3s!V\u001c\b\u000eR8x]\n+gn\u00195nCJ\\G#C1\u00022\u0006U\u0016\u0011XA_\u0011\u0019\t\u0019\f\ba\u0001\u0005\u00061a/\u00197vKNDq!a.\u001d\u0001\u0004\tY\"A\u0003uSRdW\rC\u0004\u0002<r\u0001\r!a\u0007\u0002\u0013]DWM]3FqB\u0014\b\"CA`9A\u0005\t\u0019AA\u000e\u0003)\u0019X\r\\3di\u0016C\bO]\u0001\"M&dG/\u001a:QkNDGi\\<o\u0005\u0016t7\r[7be.$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003\u000bTC!a\u0007\u0002\u001c\u0006y!/\u001e8J]R\u0014UM\\2i[\u0006\u00148\u000eF\u0004b\u0003\u0017\fi-a4\t\u000b\u0001s\u0002\u0019\u0001\"\t\u000b%s\u0002\u0019\u0001\"\t\u000b-s\u0002\u0019\u0001\"\u0002%I,hn\u0015;sS:<')\u001a8dQ6\f'o\u001b\u000b\nC\u0006U\u0017q[Am\u0003;DQ\u0001Q\u0010A\u0002\tCQ!S\u0010A\u0002\tCa!a7 \u0001\u0004\u0011\u0015aC:fCJ\u001c\u0007NV1mk\u0016Dq!a8 \u0001\u0004\tY\"A\u0004d_2$\u0016\u0010]3")
public class FilterPushdownBenchmark
extends SparkFunSuite
implements BenchmarkBeforeAndAfterEachTest {
    private final SparkConf conf;
    private final int numRows;
    private final int width;
    private final int mid;
    private final int blockSize;
    private final SparkSession spark;
    private OutputStream out;

    @Override
    public /* synthetic */ void org$apache$spark$sql$execution$benchmark$BenchmarkBeforeAndAfterEachTest$$super$beforeEach(TestData testData) {
        BeforeAndAfterEachTestData.beforeEach$((BeforeAndAfterEachTestData)this, (TestData)testData);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$execution$benchmark$BenchmarkBeforeAndAfterEachTest$$super$afterEach(TestData testData) {
        BeforeAndAfterEachTestData.afterEach$((BeforeAndAfterEachTestData)this, (TestData)testData);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfterEachTestData$$super$runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfterEachTestData.runTest$((BeforeAndAfterEachTestData)this, (String)testName, (Args)args);
    }

    private SparkConf conf() {
        return this.conf;
    }

    private int numRows() {
        return this.numRows;
    }

    private int width() {
        return this.width;
    }

    private int mid() {
        return this.mid;
    }

    private int blockSize() {
        return this.blockSize;
    }

    private SparkSession spark() {
        return this.spark;
    }

    private OutputStream out() {
        return this.out;
    }

    private void out_$eq(OutputStream x$1) {
        this.out = x$1;
    }

    public void beforeAll() {
        super.beforeAll();
        this.out_$eq(new FileOutputStream(new File("benchmarks/FilterPushdownBenchmark-results.txt")));
    }

    @Override
    public void beforeEach(TestData td) {
        BenchmarkBeforeAndAfterEachTest.beforeEach$(this, td);
        String separator = new StringOps(Predef$.MODULE$.augmentString("=")).$times(96);
        byte[] testHeader = new StringBuilder(0).append(separator).append('\n').append(td.name()).append('\n').append(separator).append('\n').append('\n').toString().getBytes();
        this.out().write(testHeader);
    }

    @Override
    public void afterEach(TestData td) {
        this.out().write(10);
        BenchmarkBeforeAndAfterEachTest.afterEach$(this, td);
    }

    public void afterAll() {
        try {
            this.out().close();
        }
        finally {
            super.afterAll();
        }
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        File path = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
        path.delete();
        try {
            f.apply((Object)path);
        }
        finally {
            Utils$.MODULE$.deleteRecursively(path);
        }
    }

    public void withTempTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        try {
            f.apply$mcV$sp();
        }
        finally {
            tableNames.foreach((Function1 & Serializable & scala.Serializable)viewName -> BoxesRunTime.boxToBoolean((boolean)FilterPushdownBenchmark.$anonfun$withTempTable$1(this, viewName)));
        }
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        Tuple2 tuple2 = pairs.unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq keys = (Seq)tuple2._1();
        Seq values = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)keys, (Object)values);
        Tuple2 tuple23 = tuple22;
        Seq keys2 = (Seq)tuple23._1();
        Seq values2 = (Seq)tuple23._2();
        Seq currentValues = (Seq)keys2.map((Function1 & Serializable & scala.Serializable)key -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.spark().conf().get(key)).toOption(), Seq$.MODULE$.canBuildFrom());
        Tuple2Zipped$.MODULE$.foreach$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2((Object)keys2, (Object)values2)), (Function1)Predef$.MODULE$.$conforms(), (Function1)Predef$.MODULE$.$conforms()), (Function2 & Serializable & scala.Serializable)(key, value) -> {
            FilterPushdownBenchmark.$anonfun$withSQLConf$3(this, key, value);
            return BoxedUnit.UNIT;
        });
        try {
            f.apply$mcV$sp();
        }
        finally {
            ((IterableLike)keys2.zip((GenIterable)currentValues, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                FilterPushdownBenchmark.$anonfun$withSQLConf$4(this, x0$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    private void prepareTable(File dir, int numRows, int width, boolean useStringForValue) {
        IndexedSeq selectExpr = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), width).map((Function1 & Serializable & scala.Serializable)i -> FilterPushdownBenchmark.$anonfun$prepareTable$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        Column valueCol = useStringForValue ? functions$.MODULE$.monotonically_increasing_id().cast("string") : functions$.MODULE$.monotonically_increasing_id();
        Dataset df = this.spark().range((long)numRows).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)Random$.MODULE$.nextLong()), this.spark().implicits().newLongEncoder()).selectExpr((Seq)selectExpr).withColumn("value", valueCol).sort("value", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.saveAsTable((Dataset<Row>)df, dir, this.saveAsTable$default$3());
    }

    private void prepareStringDictTable(File dir, int numRows, int numDistinctValues, int width) {
        IndexedSeq selectExpr = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), width).map((Function1 & Serializable & scala.Serializable)x0$1 -> FilterPushdownBenchmark.$anonfun$prepareStringDictTable$1(numDistinctValues, BoxesRunTime.unboxToInt((Object)x0$1)), IndexedSeq$.MODULE$.canBuildFrom());
        Dataset df = this.spark().range((long)numRows).selectExpr((Seq)selectExpr).sort("value", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.saveAsTable((Dataset<Row>)df, dir, true);
    }

    private void saveAsTable(Dataset<Row> df, File dir, boolean useDictionary) {
        String orcPath = new StringBuilder(4).append(dir.getCanonicalPath()).append("/orc").toString();
        String parquetPath = new StringBuilder(8).append(dir.getCanonicalPath()).append("/parquet").toString();
        df.write().mode("overwrite").option("orc.dictionary.key.threshold", useDictionary ? 1.0 : 0.8).option("orc.compress.size", (long)this.blockSize()).option("orc.stripe.size", (long)this.blockSize()).orc(orcPath);
        this.spark().read().orc(orcPath).createOrReplaceTempView("orcTable");
        df.write().mode("overwrite").option("parquet.block.size", (long)this.blockSize()).parquet(parquetPath);
        this.spark().read().parquet(parquetPath).createOrReplaceTempView("parquetTable");
    }

    private boolean saveAsTable$default$3() {
        return false;
    }

    public void filterPushDownBenchmark(int values, String title, String whereExpr, String selectExpr) {
        String x$1 = title;
        long x$2 = values;
        int x$3 = 5;
        Some x$4 = new Some((Object)this.out());
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$3, x$5, x$6, x$7, (Option)x$4);
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)pushDownEnabled -> {
            FilterPushdownBenchmark.$anonfun$filterPushDownBenchmark$1(this, benchmark, selectExpr, whereExpr, BoxesRunTime.unboxToBoolean((Object)pushDownEnabled));
            return BoxedUnit.UNIT;
        });
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)pushDownEnabled -> {
            FilterPushdownBenchmark.$anonfun$filterPushDownBenchmark$4(this, benchmark, selectExpr, whereExpr, BoxesRunTime.unboxToBoolean((Object)pushDownEnabled));
            return BoxedUnit.UNIT;
        });
        benchmark.run();
    }

    public String filterPushDownBenchmark$default$4() {
        return "*";
    }

    private void runIntBenchmark(int numRows, int width, int mid) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value IS NULL", new StringBuilder(21).append(mid).append(" < value AND value < ").append(mid).toString()}))).foreach((Function1 & Serializable & scala.Serializable)whereExpr -> {
            FilterPushdownBenchmark.$anonfun$runIntBenchmark$1(this, numRows, whereExpr);
            return BoxedUnit.UNIT;
        });
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(8).append("value = ").append(mid).toString(), new StringBuilder(10).append("value <=> ").append(mid).toString(), new StringBuilder(23).append(mid).append(" <= value AND value <= ").append(mid).toString(), new StringBuilder(21).append(mid - 1).append(" < value AND value < ").append(mid + 1).toString()}))).foreach((Function1 & Serializable & scala.Serializable)whereExpr -> {
            FilterPushdownBenchmark.$anonfun$runIntBenchmark$2(this, numRows, whereExpr);
            return BoxedUnit.UNIT;
        });
        String selectExpr = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), width).map((Function1 & Serializable & scala.Serializable)i -> FilterPushdownBenchmark.$anonfun$runIntBenchmark$3(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).mkString("", ",", ", MAX(value)");
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{10, 50, 90}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)percent -> this.filterPushDownBenchmark(numRows, new StringBuilder(28).append("Select ").append(percent).append("% int rows (value < ").append(numRows * percent / 100).append(")").toString(), new StringBuilder(8).append("value < ").append(numRows * percent / 100).toString(), selectExpr));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value IS NOT NULL", "value > -1", "value != -1"}))).foreach((Function1 & Serializable & scala.Serializable)whereExpr -> {
            this.filterPushDownBenchmark(numRows, new StringBuilder(22).append("Select all int rows (").append(whereExpr).append(")").toString(), whereExpr, selectExpr);
            return BoxedUnit.UNIT;
        });
    }

    private void runStringBenchmark(int numRows, int width, int searchValue, String colType) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value IS NULL", new StringBuilder(25).append("'").append(searchValue).append("' < value AND value < '").append(searchValue).append("'").toString()}))).foreach((Function1 & Serializable & scala.Serializable)whereExpr -> {
            FilterPushdownBenchmark.$anonfun$runStringBenchmark$1(this, colType, numRows, whereExpr);
            return BoxedUnit.UNIT;
        });
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(10).append("value = '").append(searchValue).append("'").toString(), new StringBuilder(12).append("value <=> '").append(searchValue).append("'").toString(), new StringBuilder(27).append("'").append(searchValue).append("' <= value AND value <= '").append(searchValue).append("'").toString()}))).foreach((Function1 & Serializable & scala.Serializable)whereExpr -> {
            FilterPushdownBenchmark.$anonfun$runStringBenchmark$2(this, colType, numRows, whereExpr);
            return BoxedUnit.UNIT;
        });
        String selectExpr = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), width).map((Function1 & Serializable & scala.Serializable)i -> FilterPushdownBenchmark.$anonfun$runStringBenchmark$3(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).mkString("", ",", ", MAX(value)");
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value IS NOT NULL"}))).foreach((Function1 & Serializable & scala.Serializable)whereExpr -> {
            this.filterPushDownBenchmark(numRows, new StringBuilder(19).append("Select all ").append(colType).append(" rows (").append(whereExpr).append(")").toString(), whereExpr, selectExpr);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$withTempTable$1(FilterPushdownBenchmark $this, String viewName) {
        return $this.spark().catalog().dropTempView(viewName);
    }

    public static final /* synthetic */ void $anonfun$withSQLConf$3(FilterPushdownBenchmark $this, String key, String value) {
        $this.spark().conf().set(key, value);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$withSQLConf$4(FilterPushdownBenchmark $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            Option option = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                String value = (String)some.value();
                $this.spark().conf().set(key, value);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        String key = (String)tuple2._1();
        Option option = (Option)tuple2._2();
        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)tuple2);
        $this.spark().conf().unset(key);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ String $anonfun$prepareTable$1(int i) {
        return new StringBuilder(23).append("CAST(value AS STRING) c").append(i).toString();
    }

    public static final /* synthetic */ String $anonfun$prepareStringDictTable$1(int numDistinctValues$1, int x0$1) {
        String string;
        int n = x0$1;
        switch (n) {
            case 0: {
                string = new StringBuilder(30).append("CAST(id % ").append(numDistinctValues$1).append(" AS STRING) AS value").toString();
                break;
            }
            default: {
                string = new StringBuilder(24).append("CAST(rand() AS STRING) c").append(n).toString();
                break;
            }
        }
        return string;
    }

    public static final /* synthetic */ void $anonfun$filterPushDownBenchmark$1(FilterPushdownBenchmark $this, Benchmark benchmark$1, String selectExpr$1, String whereExpr$1, boolean pushDownEnabled) {
        String name = new StringBuilder(19).append("Parquet Vectorized ").append((Object)(pushDownEnabled ? "(Pushdown)" : "")).toString();
        benchmark$1.addCase(name, benchmark$1.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$3 -> $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_FILTER_PUSHDOWN_ENABLED().key()), (Object)String.valueOf(BoxesRunTime.boxToBoolean((boolean)pushDownEnabled)))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.spark().sql(new StringBuilder(32).append("SELECT ").append(selectExpr$1).append(" FROM parquetTable WHERE ").append(whereExpr$1).toString()).collect()));
    }

    public static final /* synthetic */ void $anonfun$filterPushDownBenchmark$4(FilterPushdownBenchmark $this, Benchmark benchmark$1, String selectExpr$1, String whereExpr$1, boolean pushDownEnabled) {
        String name = new StringBuilder(22).append("Native ORC Vectorized ").append((Object)(pushDownEnabled ? "(Pushdown)" : "")).toString();
        benchmark$1.addCase(name, benchmark$1.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$4 -> $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_FILTER_PUSHDOWN_ENABLED().key()), (Object)String.valueOf(BoxesRunTime.boxToBoolean((boolean)pushDownEnabled)))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.spark().sql(new StringBuilder(28).append("SELECT ").append(selectExpr$1).append(" FROM orcTable WHERE ").append(whereExpr$1).toString()).collect()));
    }

    public static final /* synthetic */ void $anonfun$runIntBenchmark$1(FilterPushdownBenchmark $this, int numRows$1, String whereExpr) {
        String title = new StringBuilder(19).append("Select 0 int row (").append(whereExpr).append(")").toString().replace("value AND value", "value");
        $this.filterPushDownBenchmark(numRows$1, title, whereExpr, $this.filterPushDownBenchmark$default$4());
    }

    public static final /* synthetic */ void $anonfun$runIntBenchmark$2(FilterPushdownBenchmark $this, int numRows$1, String whereExpr) {
        String title = new StringBuilder(19).append("Select 1 int row (").append(whereExpr).append(")").toString().replace("value AND value", "value");
        $this.filterPushDownBenchmark(numRows$1, title, whereExpr, $this.filterPushDownBenchmark$default$4());
    }

    public static final /* synthetic */ String $anonfun$runIntBenchmark$3(int i) {
        return new StringBuilder(6).append("MAX(c").append(i).append(")").toString();
    }

    public static final /* synthetic */ void $anonfun$runStringBenchmark$1(FilterPushdownBenchmark $this, String colType$1, int numRows$2, String whereExpr) {
        String title = new StringBuilder(16).append("Select 0 ").append(colType$1).append(" row (").append(whereExpr).append(")").toString().replace("value AND value", "value");
        $this.filterPushDownBenchmark(numRows$2, title, whereExpr, $this.filterPushDownBenchmark$default$4());
    }

    public static final /* synthetic */ void $anonfun$runStringBenchmark$2(FilterPushdownBenchmark $this, String colType$1, int numRows$2, String whereExpr) {
        String title = new StringBuilder(16).append("Select 1 ").append(colType$1).append(" row (").append(whereExpr).append(")").toString().replace("value AND value", "value");
        $this.filterPushDownBenchmark(numRows$2, title, whereExpr, $this.filterPushDownBenchmark$default$4());
    }

    public static final /* synthetic */ String $anonfun$runStringBenchmark$3(int i) {
        return new StringBuilder(6).append("MAX(c").append(i).append(")").toString();
    }

    public static final /* synthetic */ void $anonfun$new$4(FilterPushdownBenchmark $this, File dir$1, boolean useStringForValue) {
        $this.prepareTable(dir$1, $this.numRows(), $this.width(), useStringForValue);
        if (useStringForValue) {
            $this.runStringBenchmark($this.numRows(), $this.width(), $this.mid(), "string");
        } else {
            $this.runIntBenchmark($this.numRows(), $this.width(), $this.mid());
        }
    }

    public static final /* synthetic */ void $anonfun$new$6(FilterPushdownBenchmark $this, File dir) {
        int numDistinctValues = 200;
        $this.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"orcTable", "parquetTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.prepareStringDictTable(dir, $this.numRows(), numDistinctValues, $this.width());
            $this.runStringBenchmark($this.numRows(), $this.width(), numDistinctValues / 2, "distinct string");
        });
    }

    public static final /* synthetic */ void $anonfun$new$11(FilterPushdownBenchmark $this, String whereExpr) {
        String title = new StringBuilder(27).append("StringStartsWith filter: (").append(whereExpr).append(")").toString();
        $this.filterPushDownBenchmark($this.numRows(), title, whereExpr, $this.filterPushDownBenchmark$default$4());
    }

    public static final /* synthetic */ String $anonfun$new$15(int i) {
        return new StringBuilder(20).append("CAST(id AS string) c").append(i).toString();
    }

    public static final /* synthetic */ void $anonfun$new$17(FilterPushdownBenchmark $this, String dt$1, String whereExpr) {
        String title = new StringBuilder(16).append("Select 1 ").append(dt$1).append(" row (").append(whereExpr).append(")").toString().replace("value AND value", "value");
        $this.filterPushDownBenchmark($this.numRows(), title, whereExpr, $this.filterPushDownBenchmark$default$4());
    }

    public static final /* synthetic */ String $anonfun$new$18(int i) {
        return new StringBuilder(6).append("MAX(c").append(i).append(")").toString();
    }

    public static final /* synthetic */ void $anonfun$new$14(FilterPushdownBenchmark $this, File dir$4, String dt) {
        IndexedSeq columns = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), $this.width()).map((Function1 & Serializable & scala.Serializable)i -> FilterPushdownBenchmark.$anonfun$new$15(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        Column valueCol = dt.equalsIgnoreCase(new StringBuilder(12).append("decimal(").append(Decimal$.MODULE$.MAX_INT_DIGITS()).append(", 2)").toString()) ? functions$.MODULE$.monotonically_increasing_id().$percent((Object)BoxesRunTime.boxToInteger((int)9999999)) : functions$.MODULE$.monotonically_increasing_id();
        Dataset df = $this.spark().range((long)$this.numRows()).selectExpr((Seq)columns).withColumn("value", valueCol.cast(dt));
        $this.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"orcTable", "parquetTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.saveAsTable((Dataset<Row>)df, dir$4, $this.saveAsTable$default$3());
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(8).append("value = ").append($this.mid()).toString()}))).foreach((Function1 & Serializable & scala.Serializable)whereExpr -> {
                FilterPushdownBenchmark.$anonfun$new$17($this, dt, whereExpr);
                return BoxedUnit.UNIT;
            });
            String selectExpr = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), $this.width()).map((Function1 & Serializable & scala.Serializable)i -> FilterPushdownBenchmark.$anonfun$new$18(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).mkString("", ",", ", MAX(value)");
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{10, 50, 90}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)percent -> $this.filterPushDownBenchmark($this.numRows(), new StringBuilder(25).append("Select ").append(percent).append("% ").append(dt).append(" rows (value < ").append($this.numRows() * percent / 100).append(")").toString(), new StringBuilder(8).append("value < ").append($this.numRows() * percent / 100).toString(), selectExpr));
        });
    }

    public static final /* synthetic */ void $anonfun$new$13(FilterPushdownBenchmark $this, File dir) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(12).append("decimal(").append(Decimal$.MODULE$.MAX_INT_DIGITS()).append(", 2)").toString(), new StringBuilder(12).append("decimal(").append(Decimal$.MODULE$.MAX_LONG_DIGITS()).append(", 2)").toString(), new StringBuilder(12).append("decimal(").append(DecimalType$.MODULE$.MAX_PRECISION()).append(", 2)").toString()}))).foreach((Function1 & Serializable & scala.Serializable)dt -> {
            FilterPushdownBenchmark.$anonfun$new$14($this, dir, dt);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ String $anonfun$new$28(int i) {
        return new StringBuilder(20).append("CAST(id AS string) c").append(i).toString();
    }

    public static final /* synthetic */ void $anonfun$new$30(FilterPushdownBenchmark $this, String whereExpr) {
        String title = new StringBuilder(16).append("Select 1 ").append(ByteType$.MODULE$.simpleString()).append(" row (").append(whereExpr).append(")").toString().replace("value AND value", "value");
        $this.filterPushDownBenchmark($this.numRows(), title, whereExpr, $this.filterPushDownBenchmark$default$4());
    }

    public static final /* synthetic */ String $anonfun$new$31(int i) {
        return new StringBuilder(6).append("MAX(c").append(i).append(")").toString();
    }

    public static final /* synthetic */ void $anonfun$new$27(FilterPushdownBenchmark $this, File dir) {
        IndexedSeq columns = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), $this.width()).map((Function1 & Serializable & scala.Serializable)i -> FilterPushdownBenchmark.$anonfun$new$28(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        Dataset df = $this.spark().range((long)$this.numRows()).selectExpr((Seq)columns).withColumn("value", functions$.MODULE$.monotonically_increasing_id().$percent((Object)BoxesRunTime.boxToByte((byte)127)).cast((DataType)ByteType$.MODULE$)).orderBy("value", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        $this.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"orcTable", "parquetTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.saveAsTable((Dataset<Row>)df, dir, $this.saveAsTable$default$3());
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(18).append("value = CAST(").append(63).append(" AS ").append(ByteType$.MODULE$.simpleString()).append(")").toString()}))).foreach((Function1 & Serializable & scala.Serializable)whereExpr -> {
                FilterPushdownBenchmark.$anonfun$new$30($this, whereExpr);
                return BoxedUnit.UNIT;
            });
            String selectExpr = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), $this.width()).map((Function1 & Serializable & scala.Serializable)i -> FilterPushdownBenchmark.$anonfun$new$31(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).mkString("", ",", ", MAX(value)");
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{10, 50, 90}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)percent -> $this.filterPushDownBenchmark($this.numRows(), new StringBuilder(35).append("Select ").append(percent).append("% ").append(ByteType$.MODULE$.simpleString()).append(" rows ").append("(value < CAST(").append(127 * percent / 100).append(" AS ").append(ByteType$.MODULE$.simpleString()).append("))").toString(), new StringBuilder(18).append("value < CAST(").append(127 * percent / 100).append(" AS ").append(ByteType$.MODULE$.simpleString()).append(")").toString(), selectExpr));
        });
    }

    public static final /* synthetic */ String $anonfun$new$39(int i) {
        return new StringBuilder(20).append("CAST(id AS string) c").append(i).toString();
    }

    public static final /* synthetic */ void $anonfun$new$41(FilterPushdownBenchmark $this, String fileType$1, String whereExpr) {
        String title = new StringBuilder(36).append("Select 1 timestamp stored as ").append(fileType$1).append(" row (").append(whereExpr).append(")").toString().replace("value AND value", "value");
        $this.filterPushDownBenchmark($this.numRows(), title, whereExpr, $this.filterPushDownBenchmark$default$4());
    }

    public static final /* synthetic */ String $anonfun$new$42(int i) {
        return new StringBuilder(6).append("MAX(c").append(i).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$new$46(int i) {
        return new StringBuilder(4).append("id c").append(i).toString();
    }

    public static final /* synthetic */ String $anonfun$new$49(int i) {
        return new StringBuilder(5).append("c").append(i).append(" = 0").toString();
    }

    public static final /* synthetic */ void $anonfun$new$45(FilterPushdownBenchmark $this, int width$1, int numRows$3, File dir) {
        IndexedSeq columns = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), width$1).map((Function1 & Serializable & scala.Serializable)i -> FilterPushdownBenchmark.$anonfun$new$46(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        Dataset df = $this.spark().range(1L).selectExpr((Seq)columns);
        $this.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"orcTable", "parquetTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.saveAsTable((Dataset<Row>)df, dir, $this.saveAsTable$default$3());
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 250, 500}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)numFilter -> {
                String whereExpr = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numFilter).map((Function1 & Serializable & scala.Serializable)i -> FilterPushdownBenchmark.$anonfun$new$49(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).mkString(" and ");
                $this.filterPushDownBenchmark(numRows$3, new StringBuilder(26).append("Select 1 row with ").append(numFilter).append(" filters").toString(), whereExpr, $this.filterPushDownBenchmark$default$4());
            });
        });
    }

    public FilterPushdownBenchmark() {
        BeforeAndAfterEachTestData.$init$((BeforeAndAfterEachTestData)this);
        BenchmarkBeforeAndAfterEachTest.$init$(this);
        this.conf = new SparkConf().setAppName(this.getClass().getSimpleName()).set("spark.master", "local[1]").setIfMissing("spark.driver.memory", "3g").setIfMissing("spark.executor.memory", "3g").setIfMissing("spark.ui.enabled", "false").setIfMissing("orc.compression", "snappy").setIfMissing("spark.sql.parquet.compression.codec", "snappy");
        this.numRows = 0xF00000;
        this.width = 5;
        this.mid = this.numRows() / 2;
        this.blockSize = 0x100000;
        this.spark = SparkSession$.MODULE$.builder().config(this.conf()).getOrCreate();
        this.ignore("Pushdown for many distinct value case", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            this.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"orcTable", "parquetTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)useStringForValue -> {
                FilterPushdownBenchmark.$anonfun$new$4($this, dir, BoxesRunTime.unboxToBoolean((Object)useStringForValue));
                return BoxedUnit.UNIT;
            }));
            return BoxedUnit.UNIT;
        }), new Position("FilterPushdownBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 244));
        this.ignore("Pushdown for few distinct value case (use dictionary encoding)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            FilterPushdownBenchmark.$anonfun$new$6(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("FilterPushdownBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 259));
        this.ignore("Pushdown benchmark for StringStartsWith", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            this.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"orcTable", "parquetTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.prepareTable(dir, $this.numRows(), $this.width(), true);
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value like '10%'", "value like '1000%'", new StringBuilder(14).append("value like '").append(((Object)BoxesRunTime.boxToInteger((int)$this.mid())).toString().substring(0, ((Object)BoxesRunTime.boxToInteger((int)$this.mid())).toString().length() - 1)).append("%'").toString()}))).foreach((Function1 & Serializable & scala.Serializable)whereExpr -> {
                    FilterPushdownBenchmark.$anonfun$new$11($this, whereExpr);
                    return BoxedUnit.UNIT;
                });
            });
            return BoxedUnit.UNIT;
        }), new Position("FilterPushdownBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
        this.ignore(new StringBuilder(23).append("Pushdown benchmark for ").append(DecimalType$.MODULE$.simpleString()).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            FilterPushdownBenchmark.$anonfun$new$13(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("FilterPushdownBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 286));
        this.ignore("Pushdown benchmark for InSet -> InFilters", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            this.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"orcTable", "parquetTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                $this.prepareTable(dir, $this.numRows(), $this.width(), false);
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 10, 50, 100}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)count -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{10, 50, 90}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)distribution -> {
                    IndexedSeq filter = (IndexedSeq)package$.MODULE$.Range().apply(0, count).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)r -> Random$.MODULE$.nextInt($this.numRows() * distribution / 100), IndexedSeq$.MODULE$.canBuildFrom());
                    String whereExpr = new StringBuilder(10).append("value in(").append(filter.mkString(",")).append(")").toString();
                    String title = new StringBuilder(51).append("InSet -> InFilters (values count: ").append(count).append(", distribution: ").append(distribution).append(")").toString();
                    $this.filterPushDownBenchmark($this.numRows(), title, whereExpr, $this.filterPushDownBenchmark$default$4());
                }));
            });
            return BoxedUnit.UNIT;
        }), new Position("FilterPushdownBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 322));
        this.ignore(new StringBuilder(23).append("Pushdown benchmark for ").append(ByteType$.MODULE$.simpleString()).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            FilterPushdownBenchmark.$anonfun$new$27(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("FilterPushdownBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 339));
        this.ignore("Pushdown benchmark for Timestamp", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_FILTER_PUSHDOWN_TIMESTAMP_ENABLED().key()), (Object)((Object)BoxesRunTime.boxToBoolean((boolean)true)).toString())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)SQLConf.ParquetOutputTimestampType$.MODULE$.values().toSeq().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.toString(), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)fileType -> {
                $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_OUTPUT_TIMESTAMP_TYPE().key()), (Object)fileType)}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    IndexedSeq columns = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), $this.width()).map((Function1 & Serializable & scala.Serializable)i -> FilterPushdownBenchmark.$anonfun$new$39(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
                    Dataset df = $this.spark().range((long)$this.numRows()).selectExpr((Seq)columns).withColumn("value", functions$.MODULE$.monotonically_increasing_id().cast((DataType)TimestampType$.MODULE$));
                    $this.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"orcTable", "parquetTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                        $this.saveAsTable((Dataset<Row>)df, dir$7, $this.saveAsTable$default$3());
                        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(27).append("value = CAST(").append($this.mid()).append(" AS timestamp)").toString()}))).foreach((Function1 & Serializable & scala.Serializable)whereExpr -> {
                            FilterPushdownBenchmark.$anonfun$new$41($this, fileType, whereExpr);
                            return BoxedUnit.UNIT;
                        });
                        String selectExpr = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), $this.width()).map((Function1 & Serializable & scala.Serializable)i -> FilterPushdownBenchmark.$anonfun$new$42(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).mkString("", ",", ", MAX(value)");
                        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{10, 50, 90}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)percent -> $this.filterPushDownBenchmark($this.numRows(), new StringBuilder(64).append("Select ").append(percent).append("% timestamp stored as ").append(fileType).append(" rows ").append("(value < CAST(").append($this.numRows() * percent / 100).append(" AS timestamp))").toString(), new StringBuilder(27).append("value < CAST(").append($this.numRows() * percent / 100).append(" as timestamp)").toString(), selectExpr));
                    });
                });
                return BoxedUnit.UNIT;
            }));
            return BoxedUnit.UNIT;
        }), new Position("FilterPushdownBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 369));
        this.ignore("Pushdown benchmark with many filters", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            int numRows = 1;
            int width = 500;
            this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
                FilterPushdownBenchmark.$anonfun$new$45(this, width, numRows, dir);
                return BoxedUnit.UNIT;
            });
        }, new Position("FilterPushdownBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 403));
    }
}

