/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.benchmark;

import java.io.File;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.parquet.SpecificParquetRecordReaderBase;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedParquetRecordReader;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.Benchmark;
import org.apache.spark.util.Benchmark$;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.Tuple2Zipped;
import scala.runtime.Tuple2Zipped$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;
import scala.util.Try$;

public final class DataSourceReadBenchmark$ {
    public static DataSourceReadBenchmark$ MODULE$;
    private final SparkConf conf;
    private final SparkSession spark;

    static {
        new DataSourceReadBenchmark$();
    }

    public SparkConf conf() {
        return this.conf;
    }

    public SparkSession spark() {
        return this.spark;
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        File path = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
        path.delete();
        try {
            f.apply((Object)path);
        }
        finally {
            Utils$.MODULE$.deleteRecursively(path);
        }
    }

    public void withTempTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        try {
            f.apply$mcV$sp();
        }
        finally {
            tableNames.foreach((Function1 & Serializable & scala.Serializable)viewName -> BoxesRunTime.boxToBoolean((boolean)DataSourceReadBenchmark$.$anonfun$withTempTable$1(viewName)));
        }
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        Tuple2 tuple2 = pairs.unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq keys = (Seq)tuple2._1();
        Seq values = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)keys, (Object)values);
        Tuple2 tuple23 = tuple22;
        Seq keys2 = (Seq)tuple23._1();
        Seq values2 = (Seq)tuple23._2();
        Seq currentValues = (Seq)keys2.map((Function1 & Serializable & scala.Serializable)key -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MODULE$.spark().conf().get(key)).toOption(), Seq$.MODULE$.canBuildFrom());
        Tuple2Zipped$.MODULE$.foreach$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2((Object)keys2, (Object)values2)), (Function1)Predef$.MODULE$.$conforms(), (Function1)Predef$.MODULE$.$conforms()), (Function2 & Serializable & scala.Serializable)(key, value) -> {
            DataSourceReadBenchmark$.$anonfun$withSQLConf$3(key, value);
            return BoxedUnit.UNIT;
        });
        try {
            f.apply$mcV$sp();
        }
        finally {
            ((IterableLike)keys2.zip((GenIterable)currentValues, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                DataSourceReadBenchmark$.$anonfun$withSQLConf$4(x0$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    private void prepareTable(File dir, Dataset<Row> df, Option<String> partition) {
        DataFrameWriter testDf = partition.isDefined() ? df.write().partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)partition.get()})) : df.write();
        this.saveAsCsvTable((DataFrameWriter<Row>)testDf, new StringBuilder(4).append(dir.getCanonicalPath()).append("/csv").toString());
        this.saveAsJsonTable((DataFrameWriter<Row>)testDf, new StringBuilder(5).append(dir.getCanonicalPath()).append("/json").toString());
        this.saveAsParquetTable((DataFrameWriter<Row>)testDf, new StringBuilder(8).append(dir.getCanonicalPath()).append("/parquet").toString());
        this.saveAsOrcTable((DataFrameWriter<Row>)testDf, new StringBuilder(4).append(dir.getCanonicalPath()).append("/orc").toString());
    }

    private Option<String> prepareTable$default$3() {
        return None$.MODULE$;
    }

    private void saveAsCsvTable(DataFrameWriter<Row> df, String dir) {
        df.mode("overwrite").option("compression", "gzip").option("header", true).csv(dir);
        this.spark().read().option("header", true).csv(dir).createOrReplaceTempView("csvTable");
    }

    private void saveAsJsonTable(DataFrameWriter<Row> df, String dir) {
        df.mode("overwrite").option("compression", "gzip").json(dir);
        this.spark().read().json(dir).createOrReplaceTempView("jsonTable");
    }

    private void saveAsParquetTable(DataFrameWriter<Row> df, String dir) {
        df.mode("overwrite").option("compression", "snappy").parquet(dir);
        this.spark().read().parquet(dir).createOrReplaceTempView("parquetTable");
    }

    private void saveAsOrcTable(DataFrameWriter<Row> df, String dir) {
        df.mode("overwrite").option("compression", "snappy").orc(dir);
        this.spark().read().orc(dir).createOrReplaceTempView("orcTable");
    }

    public void numericScanBenchmark(int values, DataType dataType) {
        Benchmark sqlBenchmark = new Benchmark(new StringBuilder(23).append("SQL Single ").append(dataType.sql()).append(" Column Scan").toString(), (long)values, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        Benchmark parquetReaderBenchmark = new Benchmark(new StringBuilder(34).append("Parquet Reader Single ").append(dataType.sql()).append(" Column Scan").toString(), (long)values, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            DataSourceReadBenchmark$.MODULE$.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "csvTable", "jsonTable", "parquetTable", "orcTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                DataSourceReadBenchmark$.MODULE$.spark().range((long)values$1).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)Random$.MODULE$.nextLong()), DataSourceReadBenchmark$.MODULE$.spark().implicits().newLongEncoder()).createOrReplaceTempView("t1");
                DataSourceReadBenchmark$.MODULE$.prepareTable(dir, (Dataset<Row>)DataSourceReadBenchmark$.MODULE$.spark().sql(new StringBuilder(33).append("SELECT CAST(value as ").append(dataType$1.sql()).append(") id FROM t1").toString()), DataSourceReadBenchmark$.MODULE$.prepareTable$default$3());
                sqlBenchmark$1.addCase("SQL CSV", sqlBenchmark$1.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$3 -> DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(id) from csvTable").collect());
                sqlBenchmark$1.addCase("SQL Json", sqlBenchmark$1.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$4 -> DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(id) from jsonTable").collect());
                sqlBenchmark$1.addCase("SQL Parquet Vectorized", sqlBenchmark$1.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$5 -> DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(id) from parquetTable").collect());
                sqlBenchmark$1.addCase("SQL Parquet MR", sqlBenchmark$1.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$6 -> DataSourceReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(id) from parquetTable").collect()));
                sqlBenchmark$1.addCase("SQL ORC Vectorized", sqlBenchmark$1.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$7 -> DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT sum(id) FROM orcTable").collect());
                sqlBenchmark$1.addCase("SQL ORC Vectorized with copy", sqlBenchmark$1.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$8 -> DataSourceReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_COPY_BATCH_TO_SPARK().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT sum(id) FROM orcTable").collect()));
                sqlBenchmark$1.addCase("SQL ORC MR", sqlBenchmark$1.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$9 -> DataSourceReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT sum(id) FROM orcTable").collect()));
                sqlBenchmark$1.run();
                Object[] files = SpecificParquetRecordReaderBase.listDirectory((File)new File(dir, "parquet")).toArray();
                boolean enableOffHeapColumnVector = DataSourceReadBenchmark$.MODULE$.spark().sessionState().conf().offHeapColumnVectorEnabled();
                int vectorizedReaderBatchSize = DataSourceReadBenchmark$.MODULE$.spark().sessionState().conf().parquetVectorizedReaderBatchSize();
                parquetReaderBenchmark$1.addCase("ParquetReader Vectorized", parquetReaderBenchmark$1.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$10 -> {
                    Function2 & Serializable & scala.Serializable intersect;
                    LongRef longSum = LongRef.create((long)0L);
                    DoubleRef doubleSum = DoubleRef.create((double)0.0);
                    DataType dataType = dataType$1;
                    if (ByteType$.MODULE$.equals(dataType)) {
                        intersect = (Function2 & Serializable & scala.Serializable)(col, i) -> {
                            DataSourceReadBenchmark$.$anonfun$numericScanBenchmark$15(longSum, col, BoxesRunTime.unboxToInt((Object)i));
                            return BoxedUnit.UNIT;
                        };
                    } else if (ShortType$.MODULE$.equals(dataType)) {
                        intersect = (Function2 & Serializable & scala.Serializable)(col, i) -> {
                            DataSourceReadBenchmark$.$anonfun$numericScanBenchmark$16(longSum, col, BoxesRunTime.unboxToInt((Object)i));
                            return BoxedUnit.UNIT;
                        };
                    } else if (IntegerType$.MODULE$.equals(dataType)) {
                        intersect = (Function2 & Serializable & scala.Serializable)(col, i) -> {
                            DataSourceReadBenchmark$.$anonfun$numericScanBenchmark$17(longSum, col, BoxesRunTime.unboxToInt((Object)i));
                            return BoxedUnit.UNIT;
                        };
                    } else if (LongType$.MODULE$.equals(dataType)) {
                        intersect = (Function2 & Serializable & scala.Serializable)(col, i) -> {
                            DataSourceReadBenchmark$.$anonfun$numericScanBenchmark$18(longSum, col, BoxesRunTime.unboxToInt((Object)i));
                            return BoxedUnit.UNIT;
                        };
                    } else if (FloatType$.MODULE$.equals(dataType)) {
                        intersect = (Function2 & Serializable & scala.Serializable)(col, i) -> {
                            DataSourceReadBenchmark$.$anonfun$numericScanBenchmark$19(doubleSum, col, BoxesRunTime.unboxToInt((Object)i));
                            return BoxedUnit.UNIT;
                        };
                    } else if (DoubleType$.MODULE$.equals(dataType)) {
                        intersect = (Function2 & Serializable & scala.Serializable)(col, i) -> {
                            DataSourceReadBenchmark$.$anonfun$numericScanBenchmark$20(doubleSum, col, BoxesRunTime.unboxToInt((Object)i));
                            return BoxedUnit.UNIT;
                        };
                    } else {
                        throw new MatchError((Object)dataType);
                    }
                    Function2 & Serializable & scala.Serializable aggregateValue = intersect;
                    new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(files)).map((Function1 & Serializable & scala.Serializable)x$11 -> (String)x$11, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).foreach((Function1 & Serializable & scala.Serializable)p -> {
                        DataSourceReadBenchmark$.$anonfun$numericScanBenchmark$22(enableOffHeapColumnVector, vectorizedReaderBatchSize, aggregateValue, p);
                        return BoxedUnit.UNIT;
                    });
                });
                parquetReaderBenchmark$1.addCase("ParquetReader Vectorized -> Row", parquetReaderBenchmark$1.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)num -> {
                    Function1 & Serializable & scala.Serializable intersect;
                    LongRef longSum = LongRef.create((long)0L);
                    DoubleRef doubleSum = DoubleRef.create((double)0.0);
                    DataType dataType = dataType$1;
                    if (ByteType$.MODULE$.equals(dataType)) {
                        intersect = (Function1 & Serializable & scala.Serializable)col -> {
                            DataSourceReadBenchmark$.$anonfun$numericScanBenchmark$24(longSum, col);
                            return BoxedUnit.UNIT;
                        };
                    } else if (ShortType$.MODULE$.equals(dataType)) {
                        intersect = (Function1 & Serializable & scala.Serializable)col -> {
                            DataSourceReadBenchmark$.$anonfun$numericScanBenchmark$25(longSum, col);
                            return BoxedUnit.UNIT;
                        };
                    } else if (IntegerType$.MODULE$.equals(dataType)) {
                        intersect = (Function1 & Serializable & scala.Serializable)col -> {
                            DataSourceReadBenchmark$.$anonfun$numericScanBenchmark$26(longSum, col);
                            return BoxedUnit.UNIT;
                        };
                    } else if (LongType$.MODULE$.equals(dataType)) {
                        intersect = (Function1 & Serializable & scala.Serializable)col -> {
                            DataSourceReadBenchmark$.$anonfun$numericScanBenchmark$27(longSum, col);
                            return BoxedUnit.UNIT;
                        };
                    } else if (FloatType$.MODULE$.equals(dataType)) {
                        intersect = (Function1 & Serializable & scala.Serializable)col -> {
                            DataSourceReadBenchmark$.$anonfun$numericScanBenchmark$28(doubleSum, col);
                            return BoxedUnit.UNIT;
                        };
                    } else if (DoubleType$.MODULE$.equals(dataType)) {
                        intersect = (Function1 & Serializable & scala.Serializable)col -> {
                            DataSourceReadBenchmark$.$anonfun$numericScanBenchmark$29(doubleSum, col);
                            return BoxedUnit.UNIT;
                        };
                    } else {
                        throw new MatchError((Object)dataType);
                    }
                    Function1 & Serializable & scala.Serializable aggregateValue = intersect;
                    new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(files)).map((Function1 & Serializable & scala.Serializable)x$13 -> (String)x$13, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).foreach((Function1 & Serializable & scala.Serializable)p -> {
                        DataSourceReadBenchmark$.$anonfun$numericScanBenchmark$31(enableOffHeapColumnVector, vectorizedReaderBatchSize, aggregateValue, p);
                        return BoxedUnit.UNIT;
                    });
                });
                parquetReaderBenchmark$1.run();
            });
            return BoxedUnit.UNIT;
        });
    }

    public void intStringScanBenchmark(int values) {
        Benchmark benchmark = new Benchmark("Int and String Scan", (long)values, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            DataSourceReadBenchmark$.MODULE$.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "csvTable", "jsonTable", "parquetTable", "orcTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                DataSourceReadBenchmark$.MODULE$.spark().range((long)values$2).map((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToLong((long)Random$.MODULE$.nextLong()), DataSourceReadBenchmark$.MODULE$.spark().implicits().newLongEncoder()).createOrReplaceTempView("t1");
                DataSourceReadBenchmark$.MODULE$.prepareTable(dir, (Dataset<Row>)DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT CAST(value AS INT) AS c1, CAST(value as STRING) AS c2 FROM t1"), DataSourceReadBenchmark$.MODULE$.prepareTable$default$3());
                benchmark$1.addCase("SQL CSV", benchmark$1.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$16 -> DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(c1), sum(length(c2)) from csvTable").collect());
                benchmark$1.addCase("SQL Json", benchmark$1.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$17 -> DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(c1), sum(length(c2)) from jsonTable").collect());
                benchmark$1.addCase("SQL Parquet Vectorized", benchmark$1.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$18 -> DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(c1), sum(length(c2)) from parquetTable").collect());
                benchmark$1.addCase("SQL Parquet MR", benchmark$1.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$19 -> DataSourceReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(c1), sum(length(c2)) from parquetTable").collect()));
                benchmark$1.addCase("SQL ORC Vectorized", benchmark$1.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$20 -> DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT sum(c1), sum(length(c2)) FROM orcTable").collect());
                benchmark$1.addCase("SQL ORC Vectorized with copy", benchmark$1.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$21 -> DataSourceReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_COPY_BATCH_TO_SPARK().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT sum(c1), sum(length(c2)) FROM orcTable").collect()));
                benchmark$1.addCase("SQL ORC MR", benchmark$1.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$22 -> DataSourceReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT sum(c1), sum(length(c2)) FROM orcTable").collect()));
                benchmark$1.run();
            });
            return BoxedUnit.UNIT;
        });
    }

    public void repeatedStringScanBenchmark(int values) {
        Benchmark benchmark = new Benchmark("Repeated String", (long)values, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            DataSourceReadBenchmark$.MODULE$.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "csvTable", "jsonTable", "parquetTable", "orcTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                DataSourceReadBenchmark$.MODULE$.spark().range((long)values$3).map((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToLong((long)Random$.MODULE$.nextLong()), DataSourceReadBenchmark$.MODULE$.spark().implicits().newLongEncoder()).createOrReplaceTempView("t1");
                DataSourceReadBenchmark$.MODULE$.prepareTable(dir, (Dataset<Row>)DataSourceReadBenchmark$.MODULE$.spark().sql("select cast((value % 200) + 10000 as STRING) as c1 from t1"), DataSourceReadBenchmark$.MODULE$.prepareTable$default$3());
                benchmark$2.addCase("SQL CSV", benchmark$2.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$24 -> DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(length(c1)) from csvTable").collect());
                benchmark$2.addCase("SQL Json", benchmark$2.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$25 -> DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(length(c1)) from jsonTable").collect());
                benchmark$2.addCase("SQL Parquet Vectorized", benchmark$2.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$26 -> DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(length(c1)) from parquetTable").collect());
                benchmark$2.addCase("SQL Parquet MR", benchmark$2.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$27 -> DataSourceReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(length(c1)) from parquetTable").collect()));
                benchmark$2.addCase("SQL ORC Vectorized", benchmark$2.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$28 -> DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(length(c1)) from orcTable").collect());
                benchmark$2.addCase("SQL ORC Vectorized with copy", benchmark$2.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$29 -> DataSourceReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_COPY_BATCH_TO_SPARK().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(length(c1)) from orcTable").collect()));
                benchmark$2.addCase("SQL ORC MR", benchmark$2.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$30 -> DataSourceReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(length(c1)) from orcTable").collect()));
                benchmark$2.run();
            });
            return BoxedUnit.UNIT;
        });
    }

    public void partitionTableScanBenchmark(int values) {
        Benchmark benchmark = new Benchmark("Partitioned Table", (long)values, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            DataSourceReadBenchmark$.MODULE$.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "csvTable", "jsonTable", "parquetTable", "orcTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                DataSourceReadBenchmark$.MODULE$.spark().range((long)values$4).map((Function1 & Serializable & scala.Serializable)x$31 -> BoxesRunTime.boxToLong((long)Random$.MODULE$.nextLong()), DataSourceReadBenchmark$.MODULE$.spark().implicits().newLongEncoder()).createOrReplaceTempView("t1");
                DataSourceReadBenchmark$.MODULE$.prepareTable(dir, (Dataset<Row>)DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT value % 2 AS p, value AS id FROM t1"), (Option<String>)new Some((Object)"p"));
                benchmark$3.addCase("Data column - CSV", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$32 -> DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(id) from csvTable").collect());
                benchmark$3.addCase("Data column - Json", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$33 -> DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(id) from jsonTable").collect());
                benchmark$3.addCase("Data column - Parquet Vectorized", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$34 -> DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(id) from parquetTable").collect());
                benchmark$3.addCase("Data column - Parquet MR", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$35 -> DataSourceReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(id) from parquetTable").collect()));
                benchmark$3.addCase("Data column - ORC Vectorized", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$36 -> DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT sum(id) FROM orcTable").collect());
                benchmark$3.addCase("Data column - ORC Vectorized with copy", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$37 -> DataSourceReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_COPY_BATCH_TO_SPARK().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT sum(id) FROM orcTable").collect()));
                benchmark$3.addCase("Data column - ORC MR", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$38 -> DataSourceReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT sum(id) FROM orcTable").collect()));
                benchmark$3.addCase("Partition column - CSV", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$39 -> DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(p) from csvTable").collect());
                benchmark$3.addCase("Partition column - Json", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$40 -> DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(p) from jsonTable").collect());
                benchmark$3.addCase("Partition column - Parquet Vectorized", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$41 -> DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(p) from parquetTable").collect());
                benchmark$3.addCase("Partition column - Parquet MR", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$42 -> DataSourceReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(p) from parquetTable").collect()));
                benchmark$3.addCase("Partition column - ORC Vectorized", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$43 -> DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT sum(p) FROM orcTable").collect());
                benchmark$3.addCase("Partition column - ORC Vectorized with copy", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$44 -> DataSourceReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_COPY_BATCH_TO_SPARK().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT sum(p) FROM orcTable").collect()));
                benchmark$3.addCase("Partition column - ORC MR", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$45 -> DataSourceReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT sum(p) FROM orcTable").collect()));
                benchmark$3.addCase("Both columns - CSV", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$46 -> DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(p), sum(id) from csvTable").collect());
                benchmark$3.addCase("Both columns - Json", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$47 -> DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(p), sum(id) from jsonTable").collect());
                benchmark$3.addCase("Both columns - Parquet Vectorized", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$48 -> DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(p), sum(id) from parquetTable").collect());
                benchmark$3.addCase("Both columns - Parquet MR", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$49 -> DataSourceReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(p), sum(id) from parquetTable").collect()));
                benchmark$3.addCase("Both columns - ORC Vectorized", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$50 -> DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT sum(p), sum(id) FROM orcTable").collect());
                benchmark$3.addCase("Both column - ORC Vectorized with copy", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$51 -> DataSourceReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_COPY_BATCH_TO_SPARK().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT sum(p), sum(id) FROM orcTable").collect()));
                benchmark$3.addCase("Both columns - ORC MR", benchmark$3.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$52 -> DataSourceReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT sum(p), sum(id) FROM orcTable").collect()));
                benchmark$3.run();
            });
            return BoxedUnit.UNIT;
        });
    }

    public void stringWithNullsScanBenchmark(int values, double fractionOfNulls) {
        Benchmark benchmark = new Benchmark("String with Nulls Scan", (long)values, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            DataSourceReadBenchmark$.MODULE$.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "csvTable", "jsonTable", "parquetTable", "orcTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                DataSourceReadBenchmark$.MODULE$.spark().range((long)values$5).createOrReplaceTempView("t1");
                DataSourceReadBenchmark$.MODULE$.prepareTable(dir, (Dataset<Row>)DataSourceReadBenchmark$.MODULE$.spark().sql(new StringBuilder(109).append("SELECT IF(RAND(1) < ").append(fractionOfNulls$1).append(", NULL, CAST(id as STRING)) AS c1, ").append("IF(RAND(2) < ").append(fractionOfNulls$1).append(", NULL, CAST(id as STRING)) AS c2 FROM t1").toString()), DataSourceReadBenchmark$.MODULE$.prepareTable$default$3());
                benchmark$4.addCase("SQL CSV", benchmark$4.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$53 -> DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(length(c2)) from csvTable where c1 is not NULL and c2 is not NULL").collect());
                benchmark$4.addCase("SQL Json", benchmark$4.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$54 -> DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(length(c2)) from jsonTable where c1 is not NULL and c2 is not NULL").collect());
                benchmark$4.addCase("SQL Parquet Vectorized", benchmark$4.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$55 -> DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(length(c2)) from parquetTable where c1 is not NULL and c2 is not NULL").collect());
                benchmark$4.addCase("SQL Parquet MR", benchmark$4.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$56 -> DataSourceReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DataSourceReadBenchmark$.MODULE$.spark().sql("select sum(length(c2)) from parquetTable where c1 is not NULL and c2 is not NULL").collect()));
                Object[] files = SpecificParquetRecordReaderBase.listDirectory((File)new File(dir, "parquet")).toArray();
                boolean enableOffHeapColumnVector = DataSourceReadBenchmark$.MODULE$.spark().sessionState().conf().offHeapColumnVectorEnabled();
                int vectorizedReaderBatchSize = DataSourceReadBenchmark$.MODULE$.spark().sessionState().conf().parquetVectorizedReaderBatchSize();
                benchmark$4.addCase("ParquetReader Vectorized", benchmark$4.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)num -> {
                    IntRef sum = IntRef.create((int)0);
                    new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(files)).map((Function1 & Serializable & scala.Serializable)x$57 -> (String)x$57, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).foreach((Function1 & Serializable & scala.Serializable)p -> {
                        DataSourceReadBenchmark$.$anonfun$stringWithNullsScanBenchmark$10(enableOffHeapColumnVector, vectorizedReaderBatchSize, sum, p);
                        return BoxedUnit.UNIT;
                    });
                });
                benchmark$4.addCase("SQL ORC Vectorized", benchmark$4.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$60 -> DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT SUM(LENGTH(c2)) FROM orcTable WHERE c1 IS NOT NULL AND c2 IS NOT NULL").collect());
                benchmark$4.addCase("SQL ORC Vectorized with copy", benchmark$4.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$61 -> DataSourceReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_COPY_BATCH_TO_SPARK().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT SUM(LENGTH(c2)) FROM orcTable WHERE c1 IS NOT NULL AND c2 IS NOT NULL").collect()));
                benchmark$4.addCase("SQL ORC MR", benchmark$4.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$62 -> DataSourceReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT SUM(LENGTH(c2)) FROM orcTable WHERE c1 IS NOT NULL AND c2 IS NOT NULL").collect()));
                benchmark$4.run();
            });
            return BoxedUnit.UNIT;
        });
    }

    public void columnsBenchmark(int values, int width) {
        Benchmark benchmark = new Benchmark(new StringBuilder(32).append("Single Column Scan from ").append(width).append(" columns").toString(), (long)values, Benchmark$.MODULE$.$lessinit$greater$default$3(), Benchmark$.MODULE$.$lessinit$greater$default$4(), Benchmark$.MODULE$.$lessinit$greater$default$5(), Benchmark$.MODULE$.$lessinit$greater$default$6(), Benchmark$.MODULE$.$lessinit$greater$default$7());
        this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            DataSourceReadBenchmark$.MODULE$.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"t1", "csvTable", "jsonTable", "parquetTable", "orcTable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                int middle = width$1 / 2;
                IndexedSeq selectExpr = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), width$1).map((Function1 & Serializable & scala.Serializable)i -> DataSourceReadBenchmark$.$anonfun$columnsBenchmark$3(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
                DataSourceReadBenchmark$.MODULE$.spark().range((long)values$6).map((Function1 & Serializable & scala.Serializable)x$63 -> BoxesRunTime.boxToLong((long)Random$.MODULE$.nextLong()), DataSourceReadBenchmark$.MODULE$.spark().implicits().newLongEncoder()).toDF().selectExpr((Seq)selectExpr).createOrReplaceTempView("t1");
                DataSourceReadBenchmark$.MODULE$.prepareTable(dir, (Dataset<Row>)DataSourceReadBenchmark$.MODULE$.spark().sql("SELECT * FROM t1"), DataSourceReadBenchmark$.MODULE$.prepareTable$default$3());
                benchmark$5.addCase("SQL CSV", benchmark$5.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$64 -> DataSourceReadBenchmark$.MODULE$.spark().sql(new StringBuilder(27).append("SELECT sum(c").append(middle).append(") FROM csvTable").toString()).collect());
                benchmark$5.addCase("SQL Json", benchmark$5.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$65 -> DataSourceReadBenchmark$.MODULE$.spark().sql(new StringBuilder(28).append("SELECT sum(c").append(middle).append(") FROM jsonTable").toString()).collect());
                benchmark$5.addCase("SQL Parquet Vectorized", benchmark$5.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$66 -> DataSourceReadBenchmark$.MODULE$.spark().sql(new StringBuilder(31).append("SELECT sum(c").append(middle).append(") FROM parquetTable").toString()).collect());
                benchmark$5.addCase("SQL Parquet MR", benchmark$5.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$67 -> DataSourceReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DataSourceReadBenchmark$.MODULE$.spark().sql(new StringBuilder(31).append("SELECT sum(c").append(middle).append(") FROM parquetTable").toString()).collect()));
                benchmark$5.addCase("SQL ORC Vectorized", benchmark$5.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$68 -> DataSourceReadBenchmark$.MODULE$.spark().sql(new StringBuilder(27).append("SELECT sum(c").append(middle).append(") FROM orcTable").toString()).collect());
                benchmark$5.addCase("SQL ORC Vectorized with copy", benchmark$5.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$69 -> DataSourceReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_COPY_BATCH_TO_SPARK().key()), (Object)"true")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DataSourceReadBenchmark$.MODULE$.spark().sql(new StringBuilder(27).append("SELECT sum(c").append(middle).append(") FROM orcTable").toString()).collect()));
                benchmark$5.addCase("SQL ORC MR", benchmark$5.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$70 -> DataSourceReadBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DataSourceReadBenchmark$.MODULE$.spark().sql(new StringBuilder(27).append("SELECT sum(c").append(middle).append(") FROM orcTable").toString()).collect()));
                benchmark$5.run();
            });
            return BoxedUnit.UNIT;
        });
    }

    public void main(String[] args) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NumericType[]{ByteType$.MODULE$, ShortType$.MODULE$, IntegerType$.MODULE$, LongType$.MODULE$, FloatType$.MODULE$, DoubleType$.MODULE$}))).foreach((Function1 & Serializable & scala.Serializable)dataType -> {
            DataSourceReadBenchmark$.MODULE$.numericScanBenchmark(0xF00000, (DataType)dataType);
            return BoxedUnit.UNIT;
        });
        this.intStringScanBenchmark(0xA00000);
        this.repeatedStringScanBenchmark(0xA00000);
        this.partitionTableScanBenchmark(0xF00000);
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.5, 0.95})).foreach((Function1)(JFunction1.mcVD.sp & Serializable & scala.Serializable)fractionOfNulls -> MODULE$.stringWithNullsScanBenchmark(0xA00000, fractionOfNulls));
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{10, 50, 100})).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)columnWidth -> MODULE$.columnsBenchmark(0x100000, columnWidth));
    }

    public static final /* synthetic */ boolean $anonfun$withTempTable$1(String viewName) {
        return MODULE$.spark().catalog().dropTempView(viewName);
    }

    public static final /* synthetic */ void $anonfun$withSQLConf$3(String key, String value) {
        MODULE$.spark().conf().set(key, value);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$withSQLConf$4(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            Option option = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                String value = (String)some.value();
                MODULE$.spark().conf().set(key, value);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        String key = (String)tuple2._1();
        Option option = (Option)tuple2._2();
        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)tuple2);
        MODULE$.spark().conf().unset(key);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$numericScanBenchmark$15(LongRef longSum$1, ColumnVector col, int i) {
        longSum$1.elem += (long)col.getByte(i);
    }

    public static final /* synthetic */ void $anonfun$numericScanBenchmark$16(LongRef longSum$1, ColumnVector col, int i) {
        longSum$1.elem += (long)col.getShort(i);
    }

    public static final /* synthetic */ void $anonfun$numericScanBenchmark$17(LongRef longSum$1, ColumnVector col, int i) {
        longSum$1.elem += (long)col.getInt(i);
    }

    public static final /* synthetic */ void $anonfun$numericScanBenchmark$18(LongRef longSum$1, ColumnVector col, int i) {
        longSum$1.elem += col.getLong(i);
    }

    public static final /* synthetic */ void $anonfun$numericScanBenchmark$19(DoubleRef doubleSum$1, ColumnVector col, int i) {
        doubleSum$1.elem += (double)col.getFloat(i);
    }

    public static final /* synthetic */ void $anonfun$numericScanBenchmark$20(DoubleRef doubleSum$1, ColumnVector col, int i) {
        doubleSum$1.elem += col.getDouble(i);
    }

    public static final /* synthetic */ void $anonfun$numericScanBenchmark$22(boolean enableOffHeapColumnVector$1, int vectorizedReaderBatchSize$1, Function2 aggregateValue$1, String p) {
        try (VectorizedParquetRecordReader reader = new VectorizedParquetRecordReader(null, enableOffHeapColumnVector$1, vectorizedReaderBatchSize$1);){
            String string = "id";
            reader.initialize(p, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$.$colon$colon((Object)string)).asJava());
            ColumnarBatch batch = reader.resultBatch();
            ColumnVector col = batch.column(0);
            while (reader.nextBatch()) {
                int numRows = batch.numRows();
                for (int i = 0; i < numRows; ++i) {
                    Object object = !col.isNullAt(i) ? aggregateValue$1.apply((Object)col, (Object)BoxesRunTime.boxToInteger((int)i)) : BoxedUnit.UNIT;
                }
            }
        }
    }

    public static final /* synthetic */ void $anonfun$numericScanBenchmark$24(LongRef longSum$2, InternalRow col) {
        longSum$2.elem += (long)col.getByte(0);
    }

    public static final /* synthetic */ void $anonfun$numericScanBenchmark$25(LongRef longSum$2, InternalRow col) {
        longSum$2.elem += (long)col.getShort(0);
    }

    public static final /* synthetic */ void $anonfun$numericScanBenchmark$26(LongRef longSum$2, InternalRow col) {
        longSum$2.elem += (long)col.getInt(0);
    }

    public static final /* synthetic */ void $anonfun$numericScanBenchmark$27(LongRef longSum$2, InternalRow col) {
        longSum$2.elem += col.getLong(0);
    }

    public static final /* synthetic */ void $anonfun$numericScanBenchmark$28(DoubleRef doubleSum$2, InternalRow col) {
        doubleSum$2.elem += (double)col.getFloat(0);
    }

    public static final /* synthetic */ void $anonfun$numericScanBenchmark$29(DoubleRef doubleSum$2, InternalRow col) {
        doubleSum$2.elem += col.getDouble(0);
    }

    public static final /* synthetic */ void $anonfun$numericScanBenchmark$31(boolean enableOffHeapColumnVector$1, int vectorizedReaderBatchSize$1, Function1 aggregateValue$2, String p) {
        try (VectorizedParquetRecordReader reader = new VectorizedParquetRecordReader(null, enableOffHeapColumnVector$1, vectorizedReaderBatchSize$1);){
            String string = "id";
            reader.initialize(p, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$.$colon$colon((Object)string)).asJava());
            ColumnarBatch batch = reader.resultBatch();
            while (reader.nextBatch()) {
                Iterator it = batch.rowIterator();
                while (it.hasNext()) {
                    InternalRow record = (InternalRow)it.next();
                    Object object = !record.isNullAt(0) ? aggregateValue$2.apply((Object)record) : BoxedUnit.UNIT;
                }
            }
        }
    }

    public static final /* synthetic */ void $anonfun$stringWithNullsScanBenchmark$10(boolean enableOffHeapColumnVector$2, int vectorizedReaderBatchSize$2, IntRef sum$1, String p) {
        try (VectorizedParquetRecordReader reader = new VectorizedParquetRecordReader(null, enableOffHeapColumnVector$2, vectorizedReaderBatchSize$2);){
            String string = "c1";
            String string2 = "c2";
            reader.initialize(p, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$.$colon$colon((Object)string2).$colon$colon((Object)string)).asJava());
            ColumnarBatch batch = reader.resultBatch();
            while (reader.nextBatch()) {
                Iterator rowIterator = batch.rowIterator();
                while (rowIterator.hasNext()) {
                    InternalRow row = (InternalRow)rowIterator.next();
                    UTF8String value = row.getUTF8String(0);
                    if (row.isNullAt(0) || row.isNullAt(1)) continue;
                    sum$1.elem += value.numBytes();
                }
            }
        }
    }

    public static final /* synthetic */ String $anonfun$columnsBenchmark$3(int i) {
        return new StringBuilder(10).append("value as c").append(i).toString();
    }

    private DataSourceReadBenchmark$() {
        MODULE$ = this;
        this.conf = new SparkConf().setAppName("DataSourceReadBenchmark").set("spark.master", "local[1]").setIfMissing("spark.driver.memory", "3g").setIfMissing("spark.executor.memory", "3g").setIfMissing("spark.ui.enabled", "false");
        this.spark = SparkSession$.MODULE$.builder().config(this.conf()).getOrCreate();
        this.spark().conf().set(SQLConf$.MODULE$.ORC_FILTER_PUSHDOWN_ENABLED().key(), "true");
        this.spark().conf().set(SQLConf$.MODULE$.ORC_COPY_BATCH_TO_SPARK().key(), "false");
        this.spark().conf().set(SQLConf$.MODULE$.PARQUET_VECTORIZED_READER_ENABLED().key(), "true");
        this.spark().conf().set(SQLConf$.MODULE$.WHOLESTAGE_CODEGEN_ENABLED().key(), "true");
    }
}

