/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.analysis.AnalysisTest;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAlias;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAlias$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation;
import org.apache.spark.sql.catalyst.analysis.UnresolvedStar;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.expressions.Ascending$;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.Concat;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.SortDirection;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.SortOrder$;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.plans.logical.RepartitionByExpression;
import org.apache.spark.sql.catalyst.plans.logical.Sort;
import org.apache.spark.sql.execution.SparkSqlParser;
import org.apache.spark.sql.execution.command.AnalyzeColumnCommand;
import org.apache.spark.sql.execution.command.AnalyzePartitionCommand;
import org.apache.spark.sql.execution.command.AnalyzeTableCommand;
import org.apache.spark.sql.execution.command.DescribeColumnCommand;
import org.apache.spark.sql.execution.command.DescribeFunctionCommand;
import org.apache.spark.sql.execution.command.DescribeTableCommand;
import org.apache.spark.sql.execution.command.ShowFunctionsCommand;
import org.apache.spark.sql.execution.datasources.CreateTable;
import org.apache.spark.sql.execution.datasources.RefreshResource;
import org.apache.spark.sql.internal.HiveSerDe;
import org.apache.spark.sql.internal.HiveSerDe$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Mg\u0001\u0002\u000f\u001e\u0001!BQ!\u000e\u0001\u0005\u0002YBq!\u000f\u0001C\u0002\u0013\u0005!\b\u0003\u0004B\u0001\u0001\u0006Ia\u000f\u0005\t\u0005\u0002A)\u0019!C\u0005\u0007\")q\t\u0001C!\u0011\")1\u000b\u0001C\u0005)\")\u0011\u000e\u0001C\u0005U\")\u0011\u000f\u0001C\u0005e\"I\u00111\r\u0001\u0012\u0002\u0013%\u0011Q\r\u0005\n\u0003w\u0002\u0011\u0013!C\u0005\u0003{B\u0011\"!!\u0001#\u0003%I!a!\t\u0013\u0005\u001d\u0005!%A\u0005\n\u0005%\u0005\"CAG\u0001E\u0005I\u0011BA3\u0011%\ty\tAI\u0001\n\u0013\t\t\nC\u0005\u0002\u0016\u0002\t\n\u0011\"\u0003\u0002\u0018\"I\u00111\u0014\u0001\u0012\u0002\u0013%\u0011Q\u0014\u0005\n\u0003C\u0003\u0011\u0013!C\u0005\u0003GCq!a*\u0001\t\u0013\tI\u000bC\u0005\u0002B\u0002\t\n\u0011\"\u0003\u0002f!I\u00111\u0019\u0001\u0012\u0002\u0013%\u0011Q\u0010\u0005\n\u0003\u000b\u0004\u0011\u0013!C\u0005\u0003\u0007C\u0011\"a2\u0001#\u0003%I!!#\t\u0013\u0005%\u0007!%A\u0005\n\u0005\u0015\u0004\"CAf\u0001E\u0005I\u0011BAI\u0011%\ti\rAI\u0001\n\u0013\t)\u0007C\u0005\u0002P\u0002\t\n\u0011\"\u0003\u0002\u001e\"I\u0011\u0011\u001b\u0001\u0012\u0002\u0013%\u00111\u0015\u0002\u0014'B\f'o[*rYB\u000b'o]3s'VLG/\u001a\u0006\u0003=}\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005\u0001\n\u0013aA:rY*\u0011!eI\u0001\u0006gB\f'o\u001b\u0006\u0003I\u0015\na!\u00199bG\",'\"\u0001\u0014\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001IS\u0006\u0005\u0002+W5\t\u0011%\u0003\u0002-C\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"AL\u001a\u000e\u0003=R!\u0001M\u0019\u0002\u0011\u0005t\u0017\r\\=tSNT!AM\u0010\u0002\u0011\r\fG/\u00197zgRL!\u0001N\u0018\u0003\u0019\u0005s\u0017\r\\=tSN$Vm\u001d;\u0002\rqJg.\u001b;?)\u00059\u0004C\u0001\u001d\u0001\u001b\u0005i\u0012a\u00028fo\u000e{gNZ\u000b\u0002wA\u0011AhP\u0007\u0002{)\u0011ahH\u0001\tS:$XM\u001d8bY&\u0011\u0001)\u0010\u0002\b'Fc5i\u001c8g\u0003!qWm^\"p]\u001a\u0004\u0013A\u00029beN,'/F\u0001E!\tAT)\u0003\u0002G;\tq1\u000b]1sWN\u000bH\u000eU1sg\u0016\u0014\u0018!\u00048pe6\fG.\u001b>f!2\fg\u000e\u0006\u0002J#B\u0011!jT\u0007\u0002\u0017*\u0011A*T\u0001\bY><\u0017nY1m\u0015\tq\u0015'A\u0003qY\u0006t7/\u0003\u0002Q\u0017\nYAj\\4jG\u0006d\u0007\u000b\\1o\u0011\u0015\u0011V\u00011\u0001J\u0003\u0011\u0001H.\u00198\u0002\u0017\u0005\u001c8/\u001a:u\u000bF,\u0018\r\u001c\u000b\u0004+nC\u0007C\u0001,Z\u001b\u00059&\"\u0001-\u0002\u000bM\u001c\u0017\r\\1\n\u0005i;&\u0001B+oSRDQ\u0001\u0018\u0004A\u0002u\u000b!b]9m\u0007>lW.\u00198e!\tqVM\u0004\u0002`GB\u0011\u0001mV\u0007\u0002C*\u0011!mJ\u0001\u0007yI|w\u000e\u001e \n\u0005\u0011<\u0016A\u0002)sK\u0012,g-\u0003\u0002gO\n11\u000b\u001e:j]\u001eT!\u0001Z,\t\u000bI3\u0001\u0019A%\u0002\u0013%tG/\u001a:dKB$HcA+lY\")Al\u0002a\u0001;\")Qn\u0002a\u0001]\u0006AQ.Z:tC\u001e,7\u000fE\u0002W_vK!\u0001],\u0003\u0015q\u0012X\r]3bi\u0016$g(\u0001\tde\u0016\fG/\u001a+bE2,Wk]5oOR\u00192/_>\u0002\u0002\u0005E\u00111DA\u0016\u0003_\t)%!\u0015\u0002^A\u0011Ao^\u0007\u0002k*\u0011a/H\u0001\fI\u0006$\u0018m]8ve\u000e,7/\u0003\u0002yk\nY1I]3bi\u0016$\u0016M\u00197f\u0011\u0015Q\b\u00021\u0001^\u0003\u0015!\u0018M\u00197f\u0011\u001da\b\u0002%AA\u0002u\f\u0001\u0002Z1uC\n\f7/\u001a\t\u0004-zl\u0016BA@X\u0005\u0019y\u0005\u000f^5p]\"I\u00111\u0001\u0005\u0011\u0002\u0003\u0007\u0011QA\u0001\ni\u0006\u0014G.\u001a+za\u0016\u0004B!a\u0002\u0002\u000e5\u0011\u0011\u0011\u0002\u0006\u0004\u0003\u0017\t\u0014aB2bi\u0006dwnZ\u0005\u0005\u0003\u001f\tIA\u0001\tDCR\fGn\\4UC\ndW\rV=qK\"I\u00111\u0003\u0005\u0011\u0002\u0003\u0007\u0011QC\u0001\bgR|'/Y4f!\u0011\t9!a\u0006\n\t\u0005e\u0011\u0011\u0002\u0002\u0015\u0007\u0006$\u0018\r\\8h'R|'/Y4f\r>\u0014X.\u0019;\t\u0013\u0005u\u0001\u0002%AA\u0002\u0005}\u0011AB:dQ\u0016l\u0017\r\u0005\u0003\u0002\"\u0005\u001dRBAA\u0012\u0015\r\t)cH\u0001\u0006if\u0004Xm]\u0005\u0005\u0003S\t\u0019C\u0001\u0006TiJ,8\r\u001e+za\u0016D\u0001\"!\f\t!\u0003\u0005\r!`\u0001\taJ|g/\u001b3fe\"I\u0011\u0011\u0007\u0005\u0011\u0002\u0003\u0007\u00111G\u0001\u0015a\u0006\u0014H/\u001b;j_:\u001cu\u000e\\;n]:\u000bW.Z:\u0011\u000b\u0005U\u0012qH/\u000f\t\u0005]\u00121\b\b\u0004A\u0006e\u0012\"\u0001-\n\u0007\u0005ur+A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u0005\u00131\t\u0002\u0004'\u0016\f(bAA\u001f/\"I\u0011q\t\u0005\u0011\u0002\u0003\u0007\u0011\u0011J\u0001\u000bEV\u001c7.\u001a;Ta\u0016\u001c\u0007\u0003\u0002,\u007f\u0003\u0017\u0002B!a\u0002\u0002N%!\u0011qJA\u0005\u0005)\u0011UoY6fiN\u0003Xm\u0019\u0005\n\u0003'B\u0001\u0013!a\u0001\u0003+\nA!\\8eKB!\u0011qKA-\u001b\u0005y\u0012bAA.?\tA1+\u0019<f\u001b>$W\rC\u0005\u0002`!\u0001\n\u00111\u0001\u0002b\u0005)\u0011/^3ssB\u0019aK`%\u00025\r\u0014X-\u0019;f)\u0006\u0014G.Z+tS:<G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005\u001d$fA?\u0002j-\u0012\u00111\u000e\t\u0005\u0003[\n9(\u0004\u0002\u0002p)!\u0011\u0011OA:\u0003%)hn\u00195fG.,GMC\u0002\u0002v]\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\tI(a\u001c\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u000ede\u0016\fG/\u001a+bE2,Wk]5oO\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\u0000)\"\u0011QAA5\u0003i\u0019'/Z1uKR\u000b'\r\\3Vg&tw\r\n3fM\u0006,H\u000e\u001e\u00135+\t\t)I\u000b\u0003\u0002\u0016\u0005%\u0014AG2sK\u0006$X\rV1cY\u0016,6/\u001b8hI\u0011,g-Y;mi\u0012*TCAAFU\u0011\ty\"!\u001b\u00025\r\u0014X-\u0019;f)\u0006\u0014G.Z+tS:<G\u0005Z3gCVdG\u000f\n\u001c\u00025\r\u0014X-\u0019;f)\u0006\u0014G.Z+tS:<G\u0005Z3gCVdG\u000fJ\u001c\u0016\u0005\u0005M%\u0006BA\u001a\u0003S\n!d\u0019:fCR,G+\u00192mKV\u001b\u0018N\\4%I\u00164\u0017-\u001e7uIa*\"!!'+\t\u0005%\u0013\u0011N\u0001\u001bGJ,\u0017\r^3UC\ndW-V:j]\u001e$C-\u001a4bk2$H%O\u000b\u0003\u0003?SC!!\u0016\u0002j\u0005Y2M]3bi\u0016$\u0016M\u00197f+NLgn\u001a\u0013eK\u001a\fW\u000f\u001c;%cA*\"!!*+\t\u0005\u0005\u0014\u0011N\u0001\fGJ,\u0017\r^3UC\ndW\rF\u000bt\u0003W\u000bi+a,\u00022\u0006M\u0016QWA\\\u0003s\u000bi,a0\t\u000bi\u0014\u0002\u0019A/\t\u000fq\u0014\u0002\u0013!a\u0001{\"I\u00111\u0001\n\u0011\u0002\u0003\u0007\u0011Q\u0001\u0005\n\u0003'\u0011\u0002\u0013!a\u0001\u0003+A\u0011\"!\b\u0013!\u0003\u0005\r!a\b\t\u0011\u00055\"\u0003%AA\u0002uD\u0011\"!\r\u0013!\u0003\u0005\r!a\r\t\u0011\u0005m&\u0003%AA\u0002u\fqaY8n[\u0016tG\u000fC\u0005\u0002TI\u0001\n\u00111\u0001\u0002V!I\u0011q\f\n\u0011\u0002\u0003\u0007\u0011\u0011M\u0001\u0016GJ,\u0017\r^3UC\ndW\r\n3fM\u0006,H\u000e\u001e\u00133\u0003U\u0019'/Z1uKR\u000b'\r\\3%I\u00164\u0017-\u001e7uIM\nQc\u0019:fCR,G+\u00192mK\u0012\"WMZ1vYR$C'A\u000bde\u0016\fG/\u001a+bE2,G\u0005Z3gCVdG\u000fJ\u001b\u0002+\r\u0014X-\u0019;f)\u0006\u0014G.\u001a\u0013eK\u001a\fW\u000f\u001c;%m\u0005)2M]3bi\u0016$\u0016M\u00197fI\u0011,g-Y;mi\u0012:\u0014!F2sK\u0006$X\rV1cY\u0016$C-\u001a4bk2$H\u0005O\u0001\u0016GJ,\u0017\r^3UC\ndW\r\n3fM\u0006,H\u000e\u001e\u0013:\u0003Y\u0019'/Z1uKR\u000b'\r\\3%I\u00164\u0017-\u001e7uIE\u0002\u0004")
public class SparkSqlParserSuite
extends SparkFunSuite
implements AnalysisTest {
    private SparkSqlParser parser;
    private final SQLConf newConf;
    private final Analyzer caseSensitiveAnalyzer;
    private final Analyzer caseInsensitiveAnalyzer;
    private volatile boolean bitmap$0;

    public /* synthetic */ void org$apache$spark$sql$catalyst$analysis$AnalysisTest$$super$comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$((PlanTestBase)this, (LogicalPlan)plan1, (LogicalPlan)plan2, (boolean)checkAnalysis);
    }

    public Analyzer getAnalyzer(boolean caseSensitive) {
        return AnalysisTest.getAnalyzer$((AnalysisTest)this, (boolean)caseSensitive);
    }

    public void checkAnalysis(LogicalPlan inputPlan, LogicalPlan expectedPlan, boolean caseSensitive) {
        AnalysisTest.checkAnalysis$((AnalysisTest)this, (LogicalPlan)inputPlan, (LogicalPlan)expectedPlan, (boolean)caseSensitive);
    }

    public boolean checkAnalysis$default$3() {
        return AnalysisTest.checkAnalysis$default$3$((AnalysisTest)this);
    }

    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        AnalysisTest.comparePlans$((AnalysisTest)this, (LogicalPlan)plan1, (LogicalPlan)plan2, (boolean)checkAnalysis);
    }

    public boolean comparePlans$default$3() {
        return AnalysisTest.comparePlans$default$3$((AnalysisTest)this);
    }

    public void assertAnalysisSuccess(LogicalPlan inputPlan, boolean caseSensitive) {
        AnalysisTest.assertAnalysisSuccess$((AnalysisTest)this, (LogicalPlan)inputPlan, (boolean)caseSensitive);
    }

    public boolean assertAnalysisSuccess$default$2() {
        return AnalysisTest.assertAnalysisSuccess$default$2$((AnalysisTest)this);
    }

    public void assertAnalysisError(LogicalPlan inputPlan, Seq<String> expectedErrors, boolean caseSensitive) {
        AnalysisTest.assertAnalysisError$((AnalysisTest)this, (LogicalPlan)inputPlan, expectedErrors, (boolean)caseSensitive);
    }

    public boolean assertAnalysisError$default$3() {
        return AnalysisTest.assertAnalysisError$default$3$((AnalysisTest)this);
    }

    public SQLConf conf() {
        return PlanTestBase.conf$((PlanTestBase)this);
    }

    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$((PlanTestBase)this, (LogicalPlan)plan);
    }

    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$((PlanTestBase)this, (Expression)e1, (Expression)e2);
    }

    public void compareJoinOrder(LogicalPlan plan1, LogicalPlan plan2) {
        PlanTestBase.compareJoinOrder$((PlanTestBase)this, (LogicalPlan)plan1, (LogicalPlan)plan2);
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        PlanTestBase.withSQLConf$((PlanTestBase)this, pairs, f);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression replaceAlias(Expression condition, AttributeMap<Expression> aliases) {
        return PredicateHelper.replaceAlias$((PredicateHelper)this, (Expression)condition, aliases);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Analyzer caseSensitiveAnalyzer() {
        return this.caseSensitiveAnalyzer;
    }

    public Analyzer caseInsensitiveAnalyzer() {
        return this.caseInsensitiveAnalyzer;
    }

    public void org$apache$spark$sql$catalyst$analysis$AnalysisTest$_setter_$caseSensitiveAnalyzer_$eq(Analyzer x$1) {
        this.caseSensitiveAnalyzer = x$1;
    }

    public void org$apache$spark$sql$catalyst$analysis$AnalysisTest$_setter_$caseInsensitiveAnalyzer_$eq(Analyzer x$1) {
        this.caseInsensitiveAnalyzer = x$1;
    }

    public SQLConf newConf() {
        return this.newConf;
    }

    private SparkSqlParser parser$lzycompute() {
        SparkSqlParserSuite sparkSqlParserSuite = this;
        synchronized (sparkSqlParserSuite) {
            if (!this.bitmap$0) {
                this.parser = new SparkSqlParser(this.newConf());
                this.bitmap$0 = true;
            }
        }
        return this.parser;
    }

    private SparkSqlParser parser() {
        return !this.bitmap$0 ? this.parser$lzycompute() : this.parser;
    }

    public LogicalPlan normalizePlan(LogicalPlan plan) {
        LogicalPlan logicalPlan;
        LogicalPlan logicalPlan2 = plan;
        if (logicalPlan2 instanceof CreateTable) {
            CreateTable createTable = (CreateTable)logicalPlan2;
            CatalogTable tableDesc = createTable.tableDesc();
            SaveMode mode = createTable.mode();
            Option query = createTable.query();
            long x$1 = -1L;
            TableIdentifier x$2 = tableDesc.copy$default$1();
            CatalogTableType x$3 = tableDesc.copy$default$2();
            CatalogStorageFormat x$4 = tableDesc.copy$default$3();
            StructType x$5 = tableDesc.copy$default$4();
            Option x$6 = tableDesc.copy$default$5();
            Seq x$7 = tableDesc.copy$default$6();
            Option x$8 = tableDesc.copy$default$7();
            String x$9 = tableDesc.copy$default$8();
            long x$10 = tableDesc.copy$default$10();
            String x$11 = tableDesc.copy$default$11();
            Map x$12 = tableDesc.copy$default$12();
            Option x$13 = tableDesc.copy$default$13();
            Option x$14 = tableDesc.copy$default$14();
            Option x$15 = tableDesc.copy$default$15();
            Seq x$16 = tableDesc.copy$default$16();
            boolean x$17 = tableDesc.copy$default$17();
            boolean x$18 = tableDesc.copy$default$18();
            Map x$19 = tableDesc.copy$default$19();
            CatalogTable newTableDesc = tableDesc.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$1, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19);
            logicalPlan = new CreateTable(newTableDesc, mode, query);
        } else {
            logicalPlan = plan;
        }
        return logicalPlan;
    }

    private void assertEqual(String sqlCommand, LogicalPlan plan) {
        LogicalPlan normalized1 = this.normalizePlan(this.parser().parsePlan(sqlCommand));
        LogicalPlan normalized2 = this.normalizePlan(plan);
        this.comparePlans(normalized1, normalized2, this.comparePlans$default$3());
    }

    private void intercept(String sqlCommand, Seq<String> messages) {
        ParseException e = (ParseException)this.intercept((Function0 & Serializable & scala.Serializable)() -> this.parser().parsePlan(sqlCommand), ClassTag$.MODULE$.apply(ParseException.class), new Position("SparkSqlParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        messages.foreach((Function1 & Serializable & scala.Serializable)message -> {
            String $org_scalatest_assert_macro_left = e.message();
            String $org_scalatest_assert_macro_right = message;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkSqlParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        });
    }

    private CreateTable createTableUsing(String table, Option<String> database, CatalogTableType tableType, CatalogStorageFormat storage, StructType schema, Option<String> provider, Seq<String> partitionColumnNames, Option<BucketSpec> bucketSpec, SaveMode mode, Option<LogicalPlan> query) {
        return new CreateTable(new CatalogTable(new TableIdentifier(table, database), tableType, storage, schema, provider, partitionColumnNames, bucketSpec, CatalogTable$.MODULE$.apply$default$8(), CatalogTable$.MODULE$.apply$default$9(), CatalogTable$.MODULE$.apply$default$10(), CatalogTable$.MODULE$.apply$default$11(), CatalogTable$.MODULE$.apply$default$12(), CatalogTable$.MODULE$.apply$default$13(), CatalogTable$.MODULE$.apply$default$14(), CatalogTable$.MODULE$.apply$default$15(), CatalogTable$.MODULE$.apply$default$16(), CatalogTable$.MODULE$.apply$default$17(), CatalogTable$.MODULE$.apply$default$18(), CatalogTable$.MODULE$.apply$default$19()), mode, query);
    }

    private CreateTable createTable(String table, Option<String> database, CatalogTableType tableType, CatalogStorageFormat storage, StructType schema, Option<String> provider, Seq<String> partitionColumnNames, Option<String> comment, SaveMode mode, Option<LogicalPlan> query) {
        TableIdentifier x$7 = new TableIdentifier(table, database);
        CatalogTableType x$8 = tableType;
        CatalogStorageFormat x$9 = storage;
        StructType x$10 = schema;
        Option<String> x$11 = provider;
        Seq<String> x$12 = partitionColumnNames;
        Option<String> x$13 = comment;
        Option x$14 = CatalogTable$.MODULE$.apply$default$7();
        String x$15 = CatalogTable$.MODULE$.apply$default$8();
        long x$16 = CatalogTable$.MODULE$.apply$default$9();
        long x$17 = CatalogTable$.MODULE$.apply$default$10();
        String x$18 = CatalogTable$.MODULE$.apply$default$11();
        Map x$19 = CatalogTable$.MODULE$.apply$default$12();
        Option x$20 = CatalogTable$.MODULE$.apply$default$13();
        Option x$21 = CatalogTable$.MODULE$.apply$default$14();
        Seq x$22 = CatalogTable$.MODULE$.apply$default$16();
        boolean x$23 = CatalogTable$.MODULE$.apply$default$17();
        boolean x$24 = CatalogTable$.MODULE$.apply$default$18();
        Map x$25 = CatalogTable$.MODULE$.apply$default$19();
        return new CreateTable(new CatalogTable(x$7, x$8, x$9, x$10, x$11, x$12, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$13, x$22, x$23, x$24, x$25), mode, query);
    }

    private Option<String> createTableUsing$default$2() {
        return None$.MODULE$;
    }

    private CatalogTableType createTableUsing$default$3() {
        return CatalogTableType$.MODULE$.MANAGED();
    }

    private CatalogStorageFormat createTableUsing$default$4() {
        return CatalogStorageFormat$.MODULE$.empty();
    }

    private StructType createTableUsing$default$5() {
        return new StructType();
    }

    private Option<String> createTableUsing$default$6() {
        return new Some((Object)"parquet");
    }

    private Seq<String> createTableUsing$default$7() {
        return (Seq)Seq$.MODULE$.empty();
    }

    private Option<BucketSpec> createTableUsing$default$8() {
        return None$.MODULE$;
    }

    private SaveMode createTableUsing$default$9() {
        return SaveMode.ErrorIfExists;
    }

    private Option<LogicalPlan> createTableUsing$default$10() {
        return None$.MODULE$;
    }

    private Option<String> createTable$default$2() {
        return None$.MODULE$;
    }

    private CatalogTableType createTable$default$3() {
        return CatalogTableType$.MODULE$.MANAGED();
    }

    private CatalogStorageFormat createTable$default$4() {
        Option x$1 = ((HiveSerDe)HiveSerDe$.MODULE$.sourceToSerDe("textfile").get()).inputFormat();
        Option x$2 = ((HiveSerDe)HiveSerDe$.MODULE$.sourceToSerDe("textfile").get()).outputFormat();
        Some x$3 = new Some((Object)"org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe");
        Option x$4 = CatalogStorageFormat$.MODULE$.empty().copy$default$1();
        boolean x$5 = CatalogStorageFormat$.MODULE$.empty().copy$default$5();
        Map x$6 = CatalogStorageFormat$.MODULE$.empty().copy$default$6();
        return CatalogStorageFormat$.MODULE$.empty().copy(x$4, x$1, x$2, (Option)x$3, x$5, x$6);
    }

    private StructType createTable$default$5() {
        return new StructType();
    }

    private Option<String> createTable$default$6() {
        return new Some((Object)"hive");
    }

    private Seq<String> createTable$default$7() {
        return (Seq)Seq$.MODULE$.empty();
    }

    private Option<String> createTable$default$8() {
        return None$.MODULE$;
    }

    private SaveMode createTable$default$9() {
        return SaveMode.ErrorIfExists;
    }

    private Option<LogicalPlan> createTable$default$10() {
        return None$.MODULE$;
    }

    public SparkSqlParserSuite() {
        PredicateHelper.$init$((PredicateHelper)this);
        PlanTestBase.$init$((PlanTestBase)this);
        AnalysisTest.$init$((AnalysisTest)this);
        this.newConf = new SQLConf();
        this.test("refresh resource", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("REFRESH prefix_path", (LogicalPlan)new RefreshResource("prefix_path"));
            this.assertEqual("REFRESH /", (LogicalPlan)new RefreshResource("/"));
            this.assertEqual("REFRESH /path///a", (LogicalPlan)new RefreshResource("/path///a"));
            this.assertEqual("REFRESH pat1h/112/_1a", (LogicalPlan)new RefreshResource("pat1h/112/_1a"));
            this.assertEqual("REFRESH pat1h/112/_1a/a-1", (LogicalPlan)new RefreshResource("pat1h/112/_1a/a-1"));
            this.assertEqual("REFRESH path-with-dash", (LogicalPlan)new RefreshResource("path-with-dash"));
            this.assertEqual("REFRESH 'path with space'", (LogicalPlan)new RefreshResource("path with space"));
            this.assertEqual("REFRESH \"path with space 2\"", (LogicalPlan)new RefreshResource("path with space 2"));
            this.intercept("REFRESH a b", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"REFRESH statements cannot contain"}));
            this.intercept("REFRESH a\tb", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"REFRESH statements cannot contain"}));
            this.intercept("REFRESH a\nb", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"REFRESH statements cannot contain"}));
            this.intercept("REFRESH a\rb", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"REFRESH statements cannot contain"}));
            this.intercept("REFRESH a\r\nb", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"REFRESH statements cannot contain"}));
            this.intercept("REFRESH @ $a$", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"REFRESH statements cannot contain"}));
            this.intercept("REFRESH  ", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Resource paths cannot be empty in REFRESH statements"}));
            this.intercept("REFRESH", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Resource paths cannot be empty in REFRESH statements"}));
        }, new Position("SparkSqlParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        this.test("show functions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("show functions", (LogicalPlan)new ShowFunctionsCommand((Option)None$.MODULE$, (Option)None$.MODULE$, true, true));
            this.assertEqual("show all functions", (LogicalPlan)new ShowFunctionsCommand((Option)None$.MODULE$, (Option)None$.MODULE$, true, true));
            this.assertEqual("show user functions", (LogicalPlan)new ShowFunctionsCommand((Option)None$.MODULE$, (Option)None$.MODULE$, true, false));
            this.assertEqual("show system functions", (LogicalPlan)new ShowFunctionsCommand((Option)None$.MODULE$, (Option)None$.MODULE$, false, true));
            this.intercept("show special functions", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SHOW special FUNCTIONS"}));
            this.assertEqual("show functions foo", (LogicalPlan)new ShowFunctionsCommand((Option)None$.MODULE$, (Option)new Some((Object)"foo"), true, true));
            this.assertEqual("show functions foo.bar", (LogicalPlan)new ShowFunctionsCommand((Option)new Some((Object)"foo"), (Option)new Some((Object)"bar"), true, true));
            this.assertEqual("show functions 'foo\\\\.*'", (LogicalPlan)new ShowFunctionsCommand((Option)None$.MODULE$, (Option)new Some((Object)"foo\\.*"), true, true));
            this.intercept("show functions foo.bar.baz", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported function name"}));
        }, new Position("SparkSqlParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
        this.test("describe function", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("describe function bar", (LogicalPlan)new DescribeFunctionCommand(new FunctionIdentifier("bar", (Option)None$.MODULE$), false));
            this.assertEqual("describe function extended bar", (LogicalPlan)new DescribeFunctionCommand(new FunctionIdentifier("bar", (Option)None$.MODULE$), true));
            this.assertEqual("describe function foo.bar", (LogicalPlan)new DescribeFunctionCommand(new FunctionIdentifier("bar", (Option)new Some((Object)"foo")), false));
            this.assertEqual("describe function extended f.bar", (LogicalPlan)new DescribeFunctionCommand(new FunctionIdentifier("bar", (Option)new Some((Object)"f")), true));
        }, new Position("SparkSqlParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        this.test("create table - schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String x$1 = "my_tab";
            StructType x$2 = new StructType().add("a", (DataType)IntegerType$.MODULE$, true, "test").add("b", (DataType)StringType$.MODULE$);
            Option<String> x$3 = this.createTable$default$2();
            CatalogTableType x$4 = this.createTable$default$3();
            CatalogStorageFormat x$5 = this.createTable$default$4();
            Option<String> x$6 = this.createTable$default$6();
            Seq<String> x$7 = this.createTable$default$7();
            Option<String> x$8 = this.createTable$default$8();
            SaveMode x$9 = this.createTable$default$9();
            Option<LogicalPlan> x$10 = this.createTable$default$10();
            this.assertEqual("CREATE TABLE my_tab(a INT COMMENT 'test', b STRING)", (LogicalPlan)this.createTable(x$1, x$3, x$4, x$5, x$2, x$6, x$7, x$8, x$9, x$10));
            String x$11 = "my_tab";
            StructType x$12 = new StructType().add("a", (DataType)IntegerType$.MODULE$, true, "test").add("b", (DataType)StringType$.MODULE$).add("c", (DataType)IntegerType$.MODULE$).add("d", (DataType)StringType$.MODULE$, true, "test2");
            Seq x$13 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c", "d"}));
            Option<String> x$14 = this.createTable$default$2();
            CatalogTableType x$15 = this.createTable$default$3();
            CatalogStorageFormat x$16 = this.createTable$default$4();
            Option<String> x$17 = this.createTable$default$6();
            Option<String> x$18 = this.createTable$default$8();
            SaveMode x$19 = this.createTable$default$9();
            Option<LogicalPlan> x$20 = this.createTable$default$10();
            this.assertEqual("CREATE TABLE my_tab(a INT COMMENT 'test', b STRING) PARTITIONED BY (c INT, d STRING COMMENT 'test2')", (LogicalPlan)this.createTable(x$11, x$14, x$15, x$16, x$12, x$17, (Seq<String>)x$13, x$18, x$19, x$20));
            String x$21 = "my_tab";
            StructType x$22 = new StructType().add("id", (DataType)LongType$.MODULE$).add("nested", (DataType)new StructType().add("col1", (DataType)StringType$.MODULE$).add("col2", (DataType)IntegerType$.MODULE$));
            Option<String> x$23 = this.createTable$default$2();
            CatalogTableType x$24 = this.createTable$default$3();
            CatalogStorageFormat x$25 = this.createTable$default$4();
            Option<String> x$26 = this.createTable$default$6();
            Seq<String> x$27 = this.createTable$default$7();
            Option<String> x$28 = this.createTable$default$8();
            SaveMode x$29 = this.createTable$default$9();
            Option<LogicalPlan> x$30 = this.createTable$default$10();
            this.assertEqual("CREATE TABLE my_tab(id BIGINT, nested STRUCT<col1: STRING,col2: INT>)", (LogicalPlan)this.createTable(x$21, x$23, x$24, x$25, x$22, x$26, x$27, x$28, x$29, x$30));
            String x$31 = "my_tab";
            StructType x$32 = new StructType().add("a", (DataType)IntegerType$.MODULE$, true, "test").add("b", (DataType)StringType$.MODULE$).add("nested", (DataType)new StructType().add("col1", (DataType)StringType$.MODULE$).add("col2", (DataType)IntegerType$.MODULE$));
            Seq x$33 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"nested"}));
            Option<String> x$34 = this.createTable$default$2();
            CatalogTableType x$35 = this.createTable$default$3();
            CatalogStorageFormat x$36 = this.createTable$default$4();
            Option<String> x$37 = this.createTable$default$6();
            Option<String> x$38 = this.createTable$default$8();
            SaveMode x$39 = this.createTable$default$9();
            Option<LogicalPlan> x$40 = this.createTable$default$10();
            this.assertEqual("CREATE TABLE my_tab(a INT COMMENT 'test', b STRING) PARTITIONED BY (nested STRUCT<col1: STRING,col2: INT>)", (LogicalPlan)this.createTable(x$31, x$34, x$35, x$36, x$32, x$37, (Seq<String>)x$33, x$38, x$39, x$40));
            this.intercept("CREATE TABLE my_tab(a: INT COMMENT 'test', b: STRING)", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"no viable alternative at input"}));
        }, new Position("SparkSqlParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
        this.test("create table using - schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String x$41 = "my_tab";
            StructType x$42 = new StructType().add("a", (DataType)IntegerType$.MODULE$, true, "test").add("b", (DataType)StringType$.MODULE$);
            Option<String> x$43 = this.createTableUsing$default$2();
            CatalogTableType x$44 = this.createTableUsing$default$3();
            CatalogStorageFormat x$45 = this.createTableUsing$default$4();
            Option<String> x$46 = this.createTableUsing$default$6();
            Seq<String> x$47 = this.createTableUsing$default$7();
            Option<BucketSpec> x$48 = this.createTableUsing$default$8();
            SaveMode x$49 = this.createTableUsing$default$9();
            Option<LogicalPlan> x$50 = this.createTableUsing$default$10();
            this.assertEqual("CREATE TABLE my_tab(a INT COMMENT 'test', b STRING) USING parquet", (LogicalPlan)this.createTableUsing(x$41, x$43, x$44, x$45, x$42, x$46, x$47, x$48, x$49, x$50));
            this.intercept("CREATE TABLE my_tab(a: INT COMMENT 'test', b: STRING) USING parquet", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"no viable alternative at input"}));
        }, new Position("SparkSqlParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 218));
        this.test("create view as insert into table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.intercept("CREATE VIEW testView AS INSERT INTO jt VALUES(1, 1)", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Operation not allowed: CREATE VIEW ... AS INSERT INTO"}));
            this.intercept("CREATE VIEW testView AS FROM jt INSERT INTO tbl1 SELECT * WHERE jt.id < 5 INSERT INTO tbl2 SELECT * WHERE jt.id > 4", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Operation not allowed: CREATE VIEW ... AS FROM ... [INSERT INTO ...]+"}));
        }, new Position("SparkSqlParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 231));
        this.test("SPARK-17328 Fix NPE with EXPLAIN DESCRIBE TABLE", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("describe table t", (LogicalPlan)new DescribeTableCommand(TableIdentifier$.MODULE$.apply("t"), Predef$.MODULE$.Map().empty(), false));
            this.assertEqual("describe table extended t", (LogicalPlan)new DescribeTableCommand(TableIdentifier$.MODULE$.apply("t"), Predef$.MODULE$.Map().empty(), true));
            this.assertEqual("describe table formatted t", (LogicalPlan)new DescribeTableCommand(TableIdentifier$.MODULE$.apply("t"), Predef$.MODULE$.Map().empty(), true));
        }, new Position("SparkSqlParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
        this.test("describe table column", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("DESCRIBE t col", (LogicalPlan)new DescribeColumnCommand(TableIdentifier$.MODULE$.apply("t"), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"col"})), false));
            this.assertEqual("DESCRIBE t `abc.xyz`", (LogicalPlan)new DescribeColumnCommand(TableIdentifier$.MODULE$.apply("t"), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"abc.xyz"})), false));
            this.assertEqual("DESCRIBE t abc.xyz", (LogicalPlan)new DescribeColumnCommand(TableIdentifier$.MODULE$.apply("t"), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"abc", "xyz"})), false));
            this.assertEqual("DESCRIBE t `a.b`.`x.y`", (LogicalPlan)new DescribeColumnCommand(TableIdentifier$.MODULE$.apply("t"), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a.b", "x.y"})), false));
            this.assertEqual("DESCRIBE TABLE t col", (LogicalPlan)new DescribeColumnCommand(TableIdentifier$.MODULE$.apply("t"), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"col"})), false));
            this.assertEqual("DESCRIBE TABLE EXTENDED t col", (LogicalPlan)new DescribeColumnCommand(TableIdentifier$.MODULE$.apply("t"), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"col"})), true));
            this.assertEqual("DESCRIBE TABLE FORMATTED t col", (LogicalPlan)new DescribeColumnCommand(TableIdentifier$.MODULE$.apply("t"), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"col"})), true));
            this.intercept("DESCRIBE TABLE t PARTITION (ds='1970-01-01') col", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DESC TABLE COLUMN for a specific partition is not supported"}));
        }, new Position("SparkSqlParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254));
        this.test("analyze table statistics", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertEqual("analyze table t compute statistics", (LogicalPlan)new AnalyzeTableCommand(TableIdentifier$.MODULE$.apply("t"), false));
            this.assertEqual("analyze table t compute statistics noscan", (LogicalPlan)new AnalyzeTableCommand(TableIdentifier$.MODULE$.apply("t"), true));
            this.assertEqual("analyze table t partition (a) compute statistics nOscAn", (LogicalPlan)new AnalyzePartitionCommand(TableIdentifier$.MODULE$.apply("t"), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)None$.MODULE$)})), true));
            TableIdentifier x$51 = TableIdentifier$.MODULE$.apply("t");
            boolean x$52 = false;
            Map x$53 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)new Some((Object)"2008-04-09")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hr"), (Object)new Some((Object)"11"))}));
            this.assertEqual("ANALYZE TABLE t PARTITION(ds='2008-04-09', hr=11) COMPUTE STATISTICS", (LogicalPlan)new AnalyzePartitionCommand(x$51, x$53, x$52));
            TableIdentifier x$54 = TableIdentifier$.MODULE$.apply("t");
            boolean x$55 = true;
            Map x$56 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)new Some((Object)"2008-04-09")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hr"), (Object)new Some((Object)"11"))}));
            this.assertEqual("ANALYZE TABLE t PARTITION(ds='2008-04-09', hr=11) COMPUTE STATISTICS noscan", (LogicalPlan)new AnalyzePartitionCommand(x$54, x$56, x$55));
            TableIdentifier x$57 = TableIdentifier$.MODULE$.apply("t");
            boolean x$58 = true;
            Map x$59 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)new Some((Object)"2008-04-09"))}));
            this.assertEqual("ANALYZE TABLE t PARTITION(ds='2008-04-09') COMPUTE STATISTICS noscan", (LogicalPlan)new AnalyzePartitionCommand(x$57, x$59, x$58));
            TableIdentifier x$60 = TableIdentifier$.MODULE$.apply("t");
            boolean x$61 = false;
            Map x$62 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)new Some((Object)"2008-04-09")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hr"), (Object)None$.MODULE$)}));
            this.assertEqual("ANALYZE TABLE t PARTITION(ds='2008-04-09', hr) COMPUTE STATISTICS", (LogicalPlan)new AnalyzePartitionCommand(x$60, x$62, x$61));
            TableIdentifier x$63 = TableIdentifier$.MODULE$.apply("t");
            boolean x$64 = true;
            Map x$65 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)new Some((Object)"2008-04-09")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hr"), (Object)None$.MODULE$)}));
            this.assertEqual("ANALYZE TABLE t PARTITION(ds='2008-04-09', hr) COMPUTE STATISTICS noscan", (LogicalPlan)new AnalyzePartitionCommand(x$63, x$65, x$64));
            TableIdentifier x$66 = TableIdentifier$.MODULE$.apply("t");
            boolean x$67 = true;
            Map x$68 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hr"), (Object)new Some((Object)"11"))}));
            this.assertEqual("ANALYZE TABLE t PARTITION(ds, hr=11) COMPUTE STATISTICS noscan", (LogicalPlan)new AnalyzePartitionCommand(x$66, x$68, x$67));
            TableIdentifier x$69 = TableIdentifier$.MODULE$.apply("t");
            boolean x$70 = false;
            Map x$71 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hr"), (Object)None$.MODULE$)}));
            this.assertEqual("ANALYZE TABLE t PARTITION(ds, hr) COMPUTE STATISTICS", (LogicalPlan)new AnalyzePartitionCommand(x$69, x$71, x$70));
            TableIdentifier x$72 = TableIdentifier$.MODULE$.apply("t");
            boolean x$73 = true;
            Map x$74 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ds"), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hr"), (Object)None$.MODULE$)}));
            this.assertEqual("ANALYZE TABLE t PARTITION(ds, hr) COMPUTE STATISTICS noscan", (LogicalPlan)new AnalyzePartitionCommand(x$72, x$74, x$73));
            this.intercept("analyze table t compute statistics xxxx", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected `NOSCAN` instead of `xxxx`"}));
            this.intercept("analyze table t partition (a) compute statistics xxxx", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected `NOSCAN` instead of `xxxx`"}));
        }, new Position("SparkSqlParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 282));
        this.test("analyze table column statistics", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.intercept("ANALYZE TABLE t COMPUTE STATISTICS FOR COLUMNS", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{""}));
            this.assertEqual("ANALYZE TABLE t COMPUTE STATISTICS FOR COLUMNS key, value", (LogicalPlan)new AnalyzeColumnCommand(TableIdentifier$.MODULE$.apply("t"), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key", "value"}))));
            this.assertEqual("ANALYZE TABLE t PARTITION(ds='2017-06-10') COMPUTE STATISTICS FOR COLUMNS key, value", (LogicalPlan)new AnalyzeColumnCommand(TableIdentifier$.MODULE$.apply("t"), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key", "value"}))));
        }, new Position("SparkSqlParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 322));
        this.test("query organization", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String baseSql = "select * from t";
            Project basePlan = new Project((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedStar[]{new UnresolvedStar((Option)None$.MODULE$)})), (LogicalPlan)new UnresolvedRelation(TableIdentifier$.MODULE$.apply("t")));
            UnresolvedAttribute unresolvedAttribute = UnresolvedAttribute$.MODULE$.apply("a");
            UnresolvedAttribute unresolvedAttribute2 = UnresolvedAttribute$.MODULE$.apply("b");
            this.assertEqual(new StringBuilder(19).append(baseSql).append(" distribute by a, b").toString(), (LogicalPlan)new RepartitionByExpression((Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute2).$colon$colon((Object)unresolvedAttribute), (LogicalPlan)basePlan, this.newConf().numShufflePartitions()));
            SortOrder sortOrder = SortOrder$.MODULE$.apply((Expression)UnresolvedAttribute$.MODULE$.apply("b"), (SortDirection)Ascending$.MODULE$, SortOrder$.MODULE$.apply$default$3());
            UnresolvedAttribute unresolvedAttribute3 = UnresolvedAttribute$.MODULE$.apply("a");
            this.assertEqual(new StringBuilder(26).append(baseSql).append(" distribute by a sort by b").toString(), (LogicalPlan)new Sort((Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder), false, (LogicalPlan)new RepartitionByExpression((Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute3), (LogicalPlan)basePlan, this.newConf().numShufflePartitions())));
            SortOrder sortOrder2 = SortOrder$.MODULE$.apply((Expression)UnresolvedAttribute$.MODULE$.apply("a"), (SortDirection)Ascending$.MODULE$, SortOrder$.MODULE$.apply$default$3());
            SortOrder sortOrder3 = SortOrder$.MODULE$.apply((Expression)UnresolvedAttribute$.MODULE$.apply("b"), (SortDirection)Ascending$.MODULE$, SortOrder$.MODULE$.apply$default$3());
            UnresolvedAttribute unresolvedAttribute4 = UnresolvedAttribute$.MODULE$.apply("a");
            UnresolvedAttribute unresolvedAttribute5 = UnresolvedAttribute$.MODULE$.apply("b");
            this.assertEqual(new StringBuilder(16).append(baseSql).append(" cluster by a, b").toString(), (LogicalPlan)new Sort((Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder3).$colon$colon((Object)sortOrder2), false, (LogicalPlan)new RepartitionByExpression((Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute5).$colon$colon((Object)unresolvedAttribute4), (LogicalPlan)basePlan, this.newConf().numShufflePartitions())));
        }, new Position("SparkSqlParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 334));
        this.test("pipeline concatenation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            UnresolvedAttribute unresolvedAttribute = UnresolvedAttribute$.MODULE$.apply("a");
            UnresolvedAttribute unresolvedAttribute2 = UnresolvedAttribute$.MODULE$.apply("b");
            Concat concat = new Concat((Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute2).$colon$colon((Object)unresolvedAttribute));
            UnresolvedAttribute unresolvedAttribute3 = UnresolvedAttribute$.MODULE$.apply("c");
            Concat concat2 = new Concat((Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAttribute3).$colon$colon((Object)concat));
            UnresolvedAlias unresolvedAlias = new UnresolvedAlias((Expression)concat2, UnresolvedAlias$.MODULE$.apply$default$2());
            this.assertEqual("SELECT a || b || c FROM t", (LogicalPlan)new Project((Seq)Nil$.MODULE$.$colon$colon((Object)unresolvedAlias), (LogicalPlan)new UnresolvedRelation(TableIdentifier$.MODULE$.apply("t"))));
        }, new Position("SparkSqlParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 359));
        this.test("SPARK-25046 Fix Alter View ... As Insert Into Table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.intercept("ALTER VIEW testView AS INSERT INTO jt VALUES(1, 1)", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Operation not allowed: ALTER VIEW ... AS INSERT INTO"}));
            this.intercept("ALTER VIEW testView AS FROM jt INSERT INTO tbl1 SELECT * WHERE jt.id < 5 INSERT INTO tbl2 SELECT * WHERE jt.id > 4", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Operation not allowed: ALTER VIEW ... AS FROM ... [INSERT INTO ...]+"}));
        }, new Position("SparkSqlParserSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 370));
    }
}

