/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.WideSchemaBenchmark$;
import org.apache.spark.util.Benchmark;
import org.apache.spark.util.Benchmark$;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple1;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015b\u0001\u0002\u000b\u0016\u0001yAQ!\u000b\u0001\u0005\u0002)Bq!\f\u0001C\u0002\u0013%a\u0006\u0003\u00046\u0001\u0001\u0006Ia\f\u0005\bm\u0001\u0011\r\u0011\"\u00038\u0011\u0019q\u0004\u0001)A\u0005q!9q\b\u0001b\u0001\n\u00139\u0004B\u0002!\u0001A\u0003%\u0001\b\u0003\u0005B\u0001!\u0015\r\u0011\"\u0003C\u0011\u001d1\u0005\u00011A\u0005\n\u001dCq\u0001\u0018\u0001A\u0002\u0013%Q\f\u0003\u0004d\u0001\u0001\u0006K\u0001\u0013\u0005\bI\u0002\u0001\r\u0011\"\u0003f\u0011\u001dI\u0007\u00011A\u0005\n)Da\u0001\u001c\u0001!B\u00131\u0007\"B7\u0001\t\u0003r\u0007\"B8\u0001\t\u0003r\u0007\"\u00029\u0001\t\u0003r\u0007\"B9\u0001\t\u0013\u0011\b\"B>\u0001\t\u0013a(aE,jI\u0016\u001c6\r[3nC\n+gn\u00195nCJ\\'B\u0001\f\u0018\u0003\r\u0019\u0018\u000f\u001c\u0006\u00031e\tQa\u001d9be.T!AG\u000e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0012aA8sO\u000e\u00011c\u0001\u0001 GA\u0011\u0001%I\u0007\u0002/%\u0011!e\u0006\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005\u0011:S\"A\u0013\u000b\u0005\u0019Z\u0012!C:dC2\fG/Z:u\u0013\tASE\u0001\nCK\u001a|'/Z!oI\u00063G/\u001a:FC\u000eD\u0017A\u0002\u001fj]&$h\bF\u0001,!\ta\u0003!D\u0001\u0016\u0003-\u00198-\u00197f\r\u0006\u001cGo\u001c:\u0016\u0003=\u0002\"\u0001M\u001a\u000e\u0003ER\u0011AM\u0001\u0006g\u000e\fG.Y\u0005\u0003iE\u00121!\u00138u\u00031\u00198-\u00197f\r\u0006\u001cGo\u001c:!\u000319\u0018\u000e\u001a;igR{G+Z:u+\u0005A\u0004cA\u001d=_5\t!H\u0003\u0002<c\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005uR$aA*fc\u0006iq/\u001b3uQN$v\u000eV3ti\u0002\nA\u0002Z3qi\"\u001cHk\u001c+fgR\fQ\u0002Z3qi\"\u001cHk\u001c+fgR\u0004\u0013\u0001D:qCJ\\7+Z:tS>tW#A\"\u0011\u00051\"\u0015BA#\u0016\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003!!X\u000e\u001d$jY\u0016\u001cX#\u0001%\u0011\u0007%\u000bFK\u0004\u0002K\u001f:\u00111JT\u0007\u0002\u0019*\u0011Q*H\u0001\u0007yI|w\u000e\u001e \n\u0003IJ!\u0001U\u0019\u0002\u000fA\f7m[1hK&\u0011!k\u0015\u0002\u0005\u0019&\u001cHO\u0003\u0002QcA\u0011QKW\u0007\u0002-*\u0011q\u000bW\u0001\u0003S>T\u0011!W\u0001\u0005U\u00064\u0018-\u0003\u0002\\-\n!a)\u001b7f\u00031!X\u000e\u001d$jY\u0016\u001cx\fJ3r)\tq\u0016\r\u0005\u00021?&\u0011\u0001-\r\u0002\u0005+:LG\u000fC\u0004c\u0015\u0005\u0005\t\u0019\u0001%\u0002\u0007a$\u0013'A\u0005u[B4\u0015\u000e\\3tA\u0005\u0019q.\u001e;\u0016\u0003\u0019\u0004\"!V4\n\u0005!4&\u0001D(viB,Ho\u0015;sK\u0006l\u0017aB8vi~#S-\u001d\u000b\u0003=.DqAY\u0007\u0002\u0002\u0003\u0007a-\u0001\u0003pkR\u0004\u0013!\u00032fM>\u0014X-\u00117m)\u0005q\u0016\u0001C1gi\u0016\u0014\u0018\t\u001c7\u0002\u0013\u00054G/\u001a:FC\u000eD\u0017!D:bm\u0016\f5\u000fU1scV,G\u000f\u0006\u0002tsB\u0011AO\u001e\b\u0003YUL!\u0001U\u000b\n\u0005]D(!\u0003#bi\u00064%/Y7f\u0015\t\u0001V\u0003C\u0003{%\u0001\u00071/\u0001\u0002eM\u0006A\u0011\r\u001a3DCN,7\u000f\u0006\u0005_{\u0006-\u0011QBA\u0011\u0011\u0015q8\u00031\u0001\u0000\u0003%\u0011WM\\2i[\u0006\u00148\u000e\u0005\u0003\u0002\u0002\u0005\u001dQBAA\u0002\u0015\r\t)aF\u0001\u0005kRLG.\u0003\u0003\u0002\n\u0005\r!!\u0003\"f]\u000eDW.\u0019:l\u0011\u0015Q8\u00031\u0001t\u0011\u001d\tya\u0005a\u0001\u0003#\tA\u0001Z3tGB!\u00111CA\u000e\u001d\u0011\t)\"a\u0006\u0011\u0005-\u000b\u0014bAA\rc\u00051\u0001K]3eK\u001aLA!!\b\u0002 \t11\u000b\u001e:j]\u001eT1!!\u00072\u0011\u001d\t\u0019c\u0005a\u0001\u0003#\t\u0001b]3mK\u000e$xN\u001d")
public class WideSchemaBenchmark
extends SparkFunSuite {
    private SparkSession sparkSession;
    private final int scaleFactor;
    private final Seq<Object> widthsToTest = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 100, 2500}));
    private final Seq<Object> depthsToTest = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 100, 250}));
    private List<File> tmpFiles;
    private OutputStream out;
    private volatile boolean bitmap$0;

    private int scaleFactor() {
        return this.scaleFactor;
    }

    private Seq<Object> widthsToTest() {
        return this.widthsToTest;
    }

    private Seq<Object> depthsToTest() {
        return this.depthsToTest;
    }

    private SparkSession sparkSession$lzycompute() {
        WideSchemaBenchmark wideSchemaBenchmark = this;
        synchronized (wideSchemaBenchmark) {
            if (!this.bitmap$0) {
                this.sparkSession = SparkSession$.MODULE$.builder().master("local[1]").appName("microbenchmark").getOrCreate();
                this.bitmap$0 = true;
            }
        }
        return this.sparkSession;
    }

    private SparkSession sparkSession() {
        return !this.bitmap$0 ? this.sparkSession$lzycompute() : this.sparkSession;
    }

    private List<File> tmpFiles() {
        return this.tmpFiles;
    }

    private void tmpFiles_$eq(List<File> x$1) {
        this.tmpFiles = x$1;
    }

    private OutputStream out() {
        return this.out;
    }

    private void out_$eq(OutputStream x$1) {
        this.out = x$1;
    }

    public void beforeAll() {
        super.beforeAll();
        this.out_$eq(new FileOutputStream(new File("benchmarks/WideSchemaBenchmark-results.txt")));
    }

    public void afterAll() {
        super.afterAll();
        this.out().close();
    }

    public void afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
        this.tmpFiles().foreach((Function1 & Serializable & scala.Serializable)tmpFile -> {
            Utils$.MODULE$.deleteRecursively(tmpFile);
            return BoxedUnit.UNIT;
        });
    }

    private Dataset<Row> saveAsParquet(Dataset<Row> df) {
        File tmpFile = File.createTempFile("WideSchemaBenchmark", "tmp");
        this.tmpFiles_$eq((List<File>)this.tmpFiles().$colon$colon((Object)tmpFile));
        tmpFile.delete();
        df.write().parquet(tmpFile.getAbsolutePath());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(tmpFile.isDirectory(), "tmpFile.isDirectory()", Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WideSchemaBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        return this.sparkSession().read().parquet(tmpFile.getAbsolutePath());
    }

    private void addCases(Benchmark benchmark, Dataset<Row> df, String desc, String selector) {
        benchmark.addCase(new StringBuilder(14).append(desc).append(" (read in-mem)").toString(), benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> df.selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(5).append("sum(").append(selector).append(")").toString()})).collect());
        benchmark.addCase(new StringBuilder(14).append(desc).append(" (exec in-mem)").toString(), benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> df.selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"*", new StringBuilder(11).append("hash(").append(selector).append(") as f").toString()})).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(5).append("sum(").append(selector).append(")").toString(), "sum(f)"})).collect());
        Dataset<Row> parquet = this.saveAsParquet(df);
        benchmark.addCase(new StringBuilder(15).append(desc).append(" (read parquet)").toString(), benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> parquet.selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(10).append("sum(").append(selector).append(") as f").toString()})).collect());
        benchmark.addCase(new StringBuilder(16).append(desc).append(" (write parquet)").toString(), benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> this.saveAsParquet((Dataset<Row>)df.selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(10).append("sum(").append(selector).append(") as f").toString()}))));
    }

    public static final /* synthetic */ String $anonfun$new$3(int i) {
        return new StringBuilder(8).append("id as a_").append(i).toString();
    }

    public static final /* synthetic */ String $anonfun$new$7(int i) {
        return new StringBuilder(8).append("id as a_").append(i).toString();
    }

    public WideSchemaBenchmark() {
        this.scaleFactor = 100000;
        int $org_scalatest_assert_macro_left = this.scaleFactor();
        int $org_scalatest_assert_macro_right = BoxesRunTime.unboxToInt((Object)this.widthsToTest().max((Ordering)Ordering.Int$.MODULE$));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WideSchemaBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
        this.tmpFiles = Nil$.MODULE$;
        this.out = null;
        this.ignore("parsing large select expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String x$1 = "parsing large select";
            long x$2 = 1L;
            Some x$3 = new Some((Object)this.out());
            int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
            FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
            FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
            boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
            Benchmark benchmark = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$7, (Option)x$3);
            this.widthsToTest().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)width -> {
                IndexedSeq selectExpr = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), width).map((Function1 & Serializable & scala.Serializable)i -> WideSchemaBenchmark.$anonfun$new$3(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
                benchmark.addCase(new StringBuilder(19).append(width).append(" select expressions").toString(), benchmark.addCase$default$2(), (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> this.sparkSession().range(1L).toDF().selectExpr((Seq)selectExpr));
            });
            benchmark.run();
        }, new Position("WideSchemaBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
        this.ignore("many column field read and write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String x$8 = "many column field r/w";
            long x$9 = this.scaleFactor();
            Some x$10 = new Some((Object)this.out());
            int x$11 = Benchmark$.MODULE$.$lessinit$greater$default$3();
            FiniteDuration x$12 = Benchmark$.MODULE$.$lessinit$greater$default$4();
            FiniteDuration x$13 = Benchmark$.MODULE$.$lessinit$greater$default$5();
            boolean x$14 = Benchmark$.MODULE$.$lessinit$greater$default$6();
            Benchmark benchmark = new Benchmark(x$8, x$9, x$11, x$12, x$13, x$14, (Option)x$10);
            this.widthsToTest().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)width -> {
                int numRows = this.scaleFactor() / width;
                IndexedSeq selectExpr = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), width).map((Function1 & Serializable & scala.Serializable)i -> WideSchemaBenchmark.$anonfun$new$7(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
                Dataset df = this.sparkSession().range((long)numRows).toDF().selectExpr((Seq)selectExpr).cache();
                df.count();
                this.addCases(benchmark, (Dataset<Row>)df, new StringBuilder(13).append(width).append(" cols x ").append(numRows).append(" rows").toString(), "a_1");
            });
            benchmark.run();
        }, new Position("WideSchemaBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
        this.ignore("wide shallowly nested struct field read and write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String x$15 = "wide shallowly nested struct field r/w";
            long x$16 = this.scaleFactor();
            Some x$17 = new Some((Object)this.out());
            int x$18 = Benchmark$.MODULE$.$lessinit$greater$default$3();
            FiniteDuration x$19 = Benchmark$.MODULE$.$lessinit$greater$default$4();
            FiniteDuration x$20 = Benchmark$.MODULE$.$lessinit$greater$default$5();
            boolean x$21 = Benchmark$.MODULE$.$lessinit$greater$default$6();
            Benchmark benchmark = new Benchmark(x$15, x$16, x$18, x$19, x$20, x$21, (Option)x$17);
            this.widthsToTest().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)width -> {
                int numRows = this.scaleFactor() / width;
                ObjectRef datum = ObjectRef.create((Object)"{");
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), width).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    datum$1.elem = i == 1 ? new StringBuilder(11).append((String)datum$1.elem).append("\"value_").append(i).append("\": 1").toString() : new StringBuilder(13).append((String)datum$1.elem).append(", \"value_").append(i).append("\": 1").toString();
                });
                datum.elem = new StringBuilder(1).append((String)datum.elem).append("}").toString();
                datum.elem = new StringBuilder(35).append("{\"a\": {\"b\": {\"c\": ").append((String)datum.elem).append(", \"d\": ").append((String)datum.elem).append("}, \"e\": ").append((String)datum.elem).append("}}").toString();
                Dataset df = this.sparkSession().read().json(this.sparkSession().range((long)numRows).map((Function1 & Serializable & scala.Serializable)x$1 -> (String)datum$1.elem, this.sparkSession().implicits().newStringEncoder())).cache();
                df.count();
                this.addCases(benchmark, (Dataset<Row>)df, new StringBuilder(13).append(width).append(" wide x ").append(numRows).append(" rows").toString(), "a.b.c.value_1");
            });
            benchmark.run();
        }, new Position("WideSchemaBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
        this.ignore("deeply nested struct field read and write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String x$22 = "deeply nested struct field r/w";
            long x$23 = this.scaleFactor();
            Some x$24 = new Some((Object)this.out());
            int x$25 = Benchmark$.MODULE$.$lessinit$greater$default$3();
            FiniteDuration x$26 = Benchmark$.MODULE$.$lessinit$greater$default$4();
            FiniteDuration x$27 = Benchmark$.MODULE$.$lessinit$greater$default$5();
            boolean x$28 = Benchmark$.MODULE$.$lessinit$greater$default$6();
            Benchmark benchmark = new Benchmark(x$22, x$23, x$25, x$26, x$27, x$28, (Option)x$24);
            this.depthsToTest().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)depth -> {
                int numRows = this.scaleFactor() / depth;
                ObjectRef datum = ObjectRef.create((Object)"{\"value\": 1}");
                ObjectRef selector = ObjectRef.create((Object)"value");
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), depth).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    datum$2.elem = new StringBuilder(11).append("{\"value\": ").append((String)datum$2.elem).append("}").toString();
                    selector$2.elem = new StringBuilder(6).append((String)selector$2.elem).append(".value").toString();
                });
                Dataset df = this.sparkSession().read().json(this.sparkSession().range((long)numRows).map((Function1 & Serializable & scala.Serializable)x$2 -> (String)datum$2.elem, this.sparkSession().implicits().newStringEncoder())).cache();
                df.count();
                this.addCases(benchmark, (Dataset<Row>)df, new StringBuilder(13).append(depth).append(" deep x ").append(numRows).append(" rows").toString(), (String)selector.elem);
            });
            benchmark.run();
        }, new Position("WideSchemaBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
        this.ignore("bushy struct field read and write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String x$29 = "bushy struct field r/w";
            long x$30 = this.scaleFactor();
            Some x$31 = new Some((Object)this.out());
            int x$32 = Benchmark$.MODULE$.$lessinit$greater$default$3();
            FiniteDuration x$33 = Benchmark$.MODULE$.$lessinit$greater$default$4();
            FiniteDuration x$34 = Benchmark$.MODULE$.$lessinit$greater$default$5();
            boolean x$35 = Benchmark$.MODULE$.$lessinit$greater$default$6();
            Benchmark benchmark = new Benchmark(x$29, x$30, x$32, x$33, x$34, x$35, (Option)x$31);
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 100, 1000}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)width -> {
                int numRows = this.scaleFactor() / width;
                int numNodes = 1;
                ObjectRef datum = ObjectRef.create((Object)"{\"value\": 1}");
                String selector = "value";
                int depth = 1;
                while (numNodes < width) {
                    numNodes *= 2;
                    datum.elem = new StringBuilder(23).append("{\"left_").append(depth).append("\": ").append((String)datum.elem).append(", \"right_").append(depth).append("\": ").append((String)datum.elem).append("}").toString();
                    selector = new StringBuilder(6).append("left_").append(depth).append(".").append(selector).toString();
                    ++depth;
                }
                Dataset df = this.sparkSession().read().json(this.sparkSession().range((long)numRows).map((Function1 & Serializable & scala.Serializable)x$3 -> (String)datum$3.elem, this.sparkSession().implicits().newStringEncoder())).cache();
                df.count();
                this.addCases(benchmark, (Dataset<Row>)df, new StringBuilder(16).append(numNodes).append(" x ").append(depth).append(" deep x ").append(numRows).append(" rows").toString(), selector);
            });
            benchmark.run();
        }, new Position("WideSchemaBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
        this.ignore("wide array field read and write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String x$36 = "wide array field r/w";
            long x$37 = this.scaleFactor();
            Some x$38 = new Some((Object)this.out());
            int x$39 = Benchmark$.MODULE$.$lessinit$greater$default$3();
            FiniteDuration x$40 = Benchmark$.MODULE$.$lessinit$greater$default$4();
            FiniteDuration x$41 = Benchmark$.MODULE$.$lessinit$greater$default$5();
            boolean x$42 = Benchmark$.MODULE$.$lessinit$greater$default$6();
            Benchmark benchmark = new Benchmark(x$36, x$37, x$39, x$40, x$41, x$42, (Option)x$38);
            this.widthsToTest().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)width -> {
                int numRows = this.scaleFactor() / width;
                ObjectRef datum = ObjectRef.create((Object)"{\"value\": [");
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), width).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    datum$4.elem = i == 1 ? new StringBuilder(1).append((String)datum$4.elem).append("1").toString() : new StringBuilder(3).append((String)datum$4.elem).append(", 1").toString();
                });
                datum.elem = new StringBuilder(2).append((String)datum.elem).append("]}").toString();
                Dataset df = this.sparkSession().read().json(this.sparkSession().range((long)numRows).map((Function1 & Serializable & scala.Serializable)x$4 -> (String)datum$4.elem, this.sparkSession().implicits().newStringEncoder())).cache();
                df.count();
                this.addCases(benchmark, (Dataset<Row>)df, new StringBuilder(13).append(width).append(" wide x ").append(numRows).append(" rows").toString(), "value[0]");
            });
            benchmark.run();
        }, new Position("WideSchemaBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
        this.ignore("wide map field read and write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String x$43 = "wide map field r/w";
            long x$44 = this.scaleFactor();
            Some x$45 = new Some((Object)this.out());
            int x$46 = Benchmark$.MODULE$.$lessinit$greater$default$3();
            FiniteDuration x$47 = Benchmark$.MODULE$.$lessinit$greater$default$4();
            FiniteDuration x$48 = Benchmark$.MODULE$.$lessinit$greater$default$5();
            boolean x$49 = Benchmark$.MODULE$.$lessinit$greater$default$6();
            Benchmark benchmark = new Benchmark(x$43, x$44, x$46, x$47, x$48, x$49, (Option)x$45);
            this.widthsToTest().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)width -> {
                int numRows = this.scaleFactor() / width;
                Tuple1 datum = new Tuple1((Object)((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), width).map((Function1 & Serializable & scala.Serializable)i -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(6).append("value_").append(BoxesRunTime.unboxToInt((Object)i)).toString()), (Object)BoxesRunTime.boxToInteger((int)1)), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(WideSchemaBenchmark.class.getClassLoader());
                public final class Org_apache_spark_sql_WideSchemaBenchmark$$typecreator16$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple1"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.Map"), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))), (List)Nil$.MODULE$));
                    }

                    public Org_apache_spark_sql_WideSchemaBenchmark$$typecreator16$1(WideSchemaBenchmark $outer) {
                    }
                }
                Dataset df = this.sparkSession().range((long)numRows).map((Function1 & Serializable & scala.Serializable)x$5 -> datum, this.sparkSession().implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_WideSchemaBenchmark$$typecreator16$1(null)))).toDF().cache();
                df.count();
                this.addCases(benchmark, (Dataset<Row>)df, new StringBuilder(13).append(width).append(" wide x ").append(numRows).append(" rows").toString(), "_1[\"value_1\"]");
            });
            benchmark.run();
        }, new Position("WideSchemaBenchmark.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210));
    }
}

