/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar.compression;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.columnar.ByteBufferHelper$;
import org.apache.spark.sql.execution.columnar.ColumnType;
import org.apache.spark.sql.execution.columnar.LONG$;
import org.apache.spark.sql.execution.columnar.NativeColumnType;
import org.apache.spark.sql.execution.columnar.compression.LongDelta$;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.LongType$;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\t\u0015qA\u0002\u0015*\u0011\u0003[sG\u0002\u0004:S!\u00055F\u000f\u0005\u0006\u0015\u0006!\t\u0001\u0014\u0005\u0006\u001b\u0006!\tE\u0014\u0005\u0006%\u0006!\te\u0015\u0005\u0006m\u0006!\te\u001e\u0005\b\u0003\u0003\tA\u0011IA\u0002\r\u0015Y\u0018\u0001AA\u0012\u0011\u0019Qu\u0001\"\u0001\u0002.!A\u00111G\u0004A\u0002\u0013Ea\nC\u0005\u00026\u001d\u0001\r\u0011\"\u0005\u00028!9\u00111I\u0004!B\u0013y\u0005\u0002CA#\u000f\u0001\u0007I\u0011\u0003(\t\u0013\u0005\u001ds\u00011A\u0005\u0012\u0005%\u0003bBA'\u000f\u0001\u0006Ka\u0014\u0005\u0007\u0003\u001f:A\u0011\t(\t\r\u0005Es\u0001\"\u0011O\u0011-\t\u0019f\u0002a\u0001\u0002\u0004%I!!\u0016\t\u0017\u0005us\u00011AA\u0002\u0013%\u0011q\f\u0005\f\u0003G:\u0001\u0019!A!B\u0013\t9\u0006C\u0004\u0002f\u001d!\t%a\u001a\t\u000f\u0005ut\u0001\"\u0011\u0002\u0000\u0019)q+\u0001\u0001\u0002\n\"AqM\u0006B\u0001B\u0003%\u0001\u000eC\u0005r-\t\u0005\t\u0015!\u0003\u0002\u000e\"1!J\u0006C\u0001\u0003\u001fC1\"a&\u0017\u0001\u0004\u0005\r\u0011\"\u0003\u0002V!Y\u0011\u0011\u0014\fA\u0002\u0003\u0007I\u0011BAN\u0011-\tyJ\u0006a\u0001\u0002\u0003\u0006K!a\u0016\t\u000f\u0005\u0005f\u0003\"\u0011\u0002$\"9\u0011Q\u0015\f\u0005B\u0005\u001d\u0006bBAW-\u0011\u0005\u0013q\u0016\u0005\n\u0003\u000b\f\u0011\u0011!C!\u0003\u000fD\u0001\"!6\u0002\u0003\u0003%\tA\u0014\u0005\n\u0003/\f\u0011\u0011!C\u0001\u00033D\u0011\"!8\u0002\u0003\u0003%\t%a8\t\u0013\u00055\u0018!!A\u0005\u0002\u0005=\b\"CAz\u0003\u0005\u0005I\u0011IA{\u0011%\t90AA\u0001\n\u0003\nI\u0010C\u0005\u0002|\u0006\t\t\u0011\"\u0003\u0002~\u0006IAj\u001c8h\t\u0016dG/\u0019\u0006\u0003U-\n1bY8naJ,7o]5p]*\u0011A&L\u0001\tG>dW/\u001c8be*\u0011afL\u0001\nKb,7-\u001e;j_:T!\u0001M\u0019\u0002\u0007M\fHN\u0003\u00023g\u0005)1\u000f]1sW*\u0011A'N\u0001\u0007CB\f7\r[3\u000b\u0003Y\n1a\u001c:h!\tA\u0014!D\u0001*\u0005%auN\\4EK2$\u0018mE\u0003\u0002w\u0005#u\t\u0005\u0002=\u007f5\tQHC\u0001?\u0003\u0015\u00198-\u00197b\u0013\t\u0001UH\u0001\u0004B]f\u0014VM\u001a\t\u0003q\tK!aQ\u0015\u0003#\r{W\u000e\u001d:fgNLwN\\*dQ\u0016lW\r\u0005\u0002=\u000b&\u0011a)\u0010\u0002\b!J|G-^2u!\ta\u0004*\u0003\u0002J{\ta1+\u001a:jC2L'0\u00192mK\u00061A(\u001b8jiz\u001a\u0001\u0001F\u00018\u0003\u0019!\u0018\u0010]3JIV\tq\n\u0005\u0002=!&\u0011\u0011+\u0010\u0002\u0004\u0013:$\u0018a\u00023fG>$WM]\u000b\u0003)j#2!\u00164q!\rAd\u000bW\u0005\u0003/&\u0012q\u0001R3d_\u0012,'\u000f\u0005\u0002Z52\u0001A!B.\u0005\u0005\u0004a&!\u0001+\u0012\u0005u\u0003\u0007C\u0001\u001f_\u0013\tyVHA\u0004O_RD\u0017N\\4\u0011\u0005\u0005$W\"\u00012\u000b\u0005\r|\u0013!\u0002;za\u0016\u001c\u0018BA3c\u0005)\tEo\\7jGRK\b/\u001a\u0005\u0006O\u0012\u0001\r\u0001[\u0001\u0007EV4g-\u001a:\u0011\u0005%tW\"\u00016\u000b\u0005-d\u0017a\u00018j_*\tQ.\u0001\u0003kCZ\f\u0017BA8k\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\u0006c\u0012\u0001\rA]\u0001\u000bG>dW/\u001c8UsB,\u0007cA:u16\t1&\u0003\u0002vW\t\u0001b*\u0019;jm\u0016\u001cu\u000e\\;n]RK\b/Z\u0001\bK:\u001cw\u000eZ3s+\tAX\u0010\u0006\u0002z}B\u0019\u0001H\u001f?\n\u0005mL#aB#oG>$WM\u001d\t\u00033v$QaW\u0003C\u0002qCQ!]\u0003A\u0002}\u00042a\u001d;}\u0003!\u0019X\u000f\u001d9peR\u001cH\u0003BA\u0003\u0003\u0017\u00012\u0001PA\u0004\u0013\r\tI!\u0010\u0002\b\u0005>|G.Z1o\u0011\u0019\th\u00011\u0001\u0002\u000eA\"\u0011qBA\f!\u0015\u0019\u0018\u0011CA\u000b\u0013\r\t\u0019b\u000b\u0002\u000b\u0007>dW/\u001c8UsB,\u0007cA-\u0002\u0018\u0011a\u0011\u0011DA\u0006\u0003\u0003\u0005\tQ!\u0001\u0002\u001c\t\u0019q\f\n\u001c\u0012\u0007u\u000bi\u0002E\u0002=\u0003?I1!!\t>\u0005\r\te._\n\u0005\u000fm\n)\u0003\u0005\u00039u\u0006\u001dbbA1\u0002*%\u0019\u00111\u00062\u0002\u00111{gn\u001a+za\u0016$\"!a\f\u0011\u0007\u0005Er!D\u0001\u0002\u0003=y6m\\7qe\u0016\u001c8/\u001a3TSj,\u0017aE0d_6\u0004(/Z:tK\u0012\u001c\u0016N_3`I\u0015\fH\u0003BA\u001d\u0003\u007f\u00012\u0001PA\u001e\u0013\r\ti$\u0010\u0002\u0005+:LG\u000f\u0003\u0005\u0002B)\t\t\u00111\u0001P\u0003\rAH%M\u0001\u0011?\u000e|W\u000e\u001d:fgN,GmU5{K\u0002\n\u0011cX;oG>l\u0007O]3tg\u0016$7+\u001b>f\u0003UyVO\\2p[B\u0014Xm]:fINK'0Z0%KF$B!!\u000f\u0002L!A\u0011\u0011I\u0007\u0002\u0002\u0003\u0007q*\u0001\n`k:\u001cw.\u001c9sKN\u001cX\rZ*ju\u0016\u0004\u0013AD2p[B\u0014Xm]:fINK'0Z\u0001\u0011k:\u001cw.\u001c9sKN\u001cX\rZ*ju\u0016\f\u0011\u0002\u001d:fmZ\u000bG.^3\u0016\u0005\u0005]\u0003c\u0001\u001f\u0002Z%\u0019\u00111L\u001f\u0003\t1{gnZ\u0001\u000eaJ,gOV1mk\u0016|F%Z9\u0015\t\u0005e\u0012\u0011\r\u0005\n\u0003\u0003\u0012\u0012\u0011!a\u0001\u0003/\n!\u0002\u001d:fmZ\u000bG.^3!\u0003i9\u0017\r\u001e5fe\u000e{W\u000e\u001d:fgNL'-\u001b7jif\u001cF/\u0019;t)\u0019\tI$!\u001b\u0002z!9\u00111\u000e\u000bA\u0002\u00055\u0014a\u0001:poB!\u0011qNA;\u001b\t\t\tHC\u0002\u0002t=\n\u0001bY1uC2L8\u000f^\u0005\u0005\u0003o\n\tHA\u0006J]R,'O\\1m%><\bBBA>)\u0001\u0007q*A\u0004pe\u0012Lg.\u00197\u0002\u0011\r|W\u000e\u001d:fgN$R\u0001[AA\u0003\u000bCa!a!\u0016\u0001\u0004A\u0017\u0001\u00024s_6Da!a\"\u0016\u0001\u0004A\u0017A\u0001;p'\u001112(a#\u0011\ta2\u0016q\u0005\t\u0005gR\f9\u0003\u0006\u0004\u0002\u0012\u0006M\u0015Q\u0013\t\u0004\u0003c1\u0002\"B4\u001a\u0001\u0004A\u0007BB9\u001a\u0001\u0004\ti)\u0001\u0003qe\u00164\u0018\u0001\u00039sKZ|F%Z9\u0015\t\u0005e\u0012Q\u0014\u0005\n\u0003\u0003Z\u0012\u0011!a\u0001\u0003/\nQ\u0001\u001d:fm\u0002\nq\u0001[1t\u001d\u0016DH/\u0006\u0002\u0002\u0006\u0005!a.\u001a=u)\u0019\tI$!+\u0002,\"9\u00111\u000e\u0010A\u0002\u00055\u0004BBA>=\u0001\u0007q*\u0001\u0006eK\u000e|W\u000e\u001d:fgN$b!!\u000f\u00022\u0006\u0005\u0007bBAZ?\u0001\u0007\u0011QW\u0001\rG>dW/\u001c8WK\u000e$xN\u001d\t\u0005\u0003o\u000bi,\u0004\u0002\u0002:*\u0019\u00111X\u0017\u0002\u0015Y,7\r^8sSj,G-\u0003\u0003\u0002@\u0006e&\u0001F,sSR\f'\r\\3D_2,XN\u001c,fGR|'\u000f\u0003\u0004\u0002D~\u0001\raT\u0001\tG\u0006\u0004\u0018mY5us\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!!3\u0011\t\u0005-\u0017\u0011[\u0007\u0003\u0003\u001bT1!a4m\u0003\u0011a\u0017M\\4\n\t\u0005M\u0017Q\u001a\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011QDAn\u0011!\t\tEIA\u0001\u0002\u0004y\u0015a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\u0005\bCBAr\u0003S\fi\"\u0004\u0002\u0002f*\u0019\u0011q]\u001f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002l\u0006\u0015(\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!\u0002\u0002r\"I\u0011\u0011\t\u0013\u0002\u0002\u0003\u0007\u0011QD\u0001\tQ\u0006\u001c\bnQ8eKR\tq*\u0001\u0005u_N#(/\u001b8h)\t\tI-A\u0006sK\u0006$'+Z:pYZ,GCAA\u0000!\u0011\tYM!\u0001\n\t\t\r\u0011Q\u001a\u0002\u0007\u001f\nTWm\u0019;")
public final class LongDelta {
    public static String toString() {
        return LongDelta$.MODULE$.toString();
    }

    public static int hashCode() {
        return LongDelta$.MODULE$.hashCode();
    }

    public static boolean canEqual(Object object) {
        return LongDelta$.MODULE$.canEqual(object);
    }

    public static Iterator<Object> productIterator() {
        return LongDelta$.MODULE$.productIterator();
    }

    public static Object productElement(int n) {
        return LongDelta$.MODULE$.productElement(n);
    }

    public static int productArity() {
        return LongDelta$.MODULE$.productArity();
    }

    public static String productPrefix() {
        return LongDelta$.MODULE$.productPrefix();
    }

    public static boolean supports(ColumnType<?> columnType) {
        return LongDelta$.MODULE$.supports(columnType);
    }

    public static <T extends AtomicType> org.apache.spark.sql.execution.columnar.compression.Encoder<T> encoder(NativeColumnType<T> nativeColumnType) {
        return LongDelta$.MODULE$.encoder(nativeColumnType);
    }

    public static <T extends AtomicType> org.apache.spark.sql.execution.columnar.compression.Decoder<T> decoder(ByteBuffer byteBuffer, NativeColumnType<T> nativeColumnType) {
        return LongDelta$.MODULE$.decoder(byteBuffer, nativeColumnType);
    }

    public static int typeId() {
        return LongDelta$.MODULE$.typeId();
    }

    public static class Decoder
    implements org.apache.spark.sql.execution.columnar.compression.Decoder<LongType$> {
        private final ByteBuffer buffer;
        private long prev;

        private long prev() {
            return this.prev;
        }

        private void prev_$eq(long x$1) {
            this.prev = x$1;
        }

        @Override
        public boolean hasNext() {
            return this.buffer.hasRemaining();
        }

        @Override
        public void next(InternalRow row, int ordinal) {
            byte delta = this.buffer.get();
            this.prev_$eq(delta > -128 ? this.prev() + (long)delta : ByteBufferHelper$.MODULE$.getLong(this.buffer));
            row.setLong(ordinal, this.prev());
        }

        @Override
        public void decompress(WritableColumnVector columnVector, int capacity) {
            long prevLocal = 0L;
            ByteBuffer nullsBuffer = this.buffer.duplicate().order(ByteOrder.nativeOrder());
            nullsBuffer.rewind();
            int nullCount = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
            int nextNullIndex = nullCount > 0 ? ByteBufferHelper$.MODULE$.getInt(nullsBuffer) : -1;
            int seenNulls = 0;
            for (int pos = 0; pos < capacity; ++pos) {
                if (pos != nextNullIndex) {
                    byte delta = this.buffer.get();
                    prevLocal = delta > -128 ? prevLocal + (long)delta : ByteBufferHelper$.MODULE$.getLong(this.buffer);
                    columnVector.putLong(pos, prevLocal);
                    continue;
                }
                if (++seenNulls < nullCount) {
                    nextNullIndex = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
                }
                columnVector.putNull(pos);
            }
        }

        public Decoder(ByteBuffer buffer, NativeColumnType<LongType$> columnType) {
            this.buffer = buffer;
        }
    }

    public static class Encoder
    implements org.apache.spark.sql.execution.columnar.compression.Encoder<LongType$> {
        private int _compressedSize;
        private int _uncompressedSize;
        private long prevValue;

        @Override
        public double compressionRatio() {
            return org.apache.spark.sql.execution.columnar.compression.Encoder.compressionRatio$(this);
        }

        public int _compressedSize() {
            return this._compressedSize;
        }

        public void _compressedSize_$eq(int x$1) {
            this._compressedSize = x$1;
        }

        public int _uncompressedSize() {
            return this._uncompressedSize;
        }

        public void _uncompressedSize_$eq(int x$1) {
            this._uncompressedSize = x$1;
        }

        @Override
        public int compressedSize() {
            return this._compressedSize();
        }

        @Override
        public int uncompressedSize() {
            return this._uncompressedSize();
        }

        private long prevValue() {
            return this.prevValue;
        }

        private void prevValue_$eq(long x$1) {
            this.prevValue = x$1;
        }

        @Override
        public void gatherCompressibilityStats(InternalRow row, int ordinal) {
            long value = row.getLong(ordinal);
            long delta = value - this.prevValue();
            this._compressedSize_$eq(this._compressedSize() + 1);
            if (this._uncompressedSize() == 0 || delta <= (long)-128 || delta > (long)127) {
                this._compressedSize_$eq(this._compressedSize() + LONG$.MODULE$.defaultSize());
            }
            this._uncompressedSize_$eq(this._uncompressedSize() + LONG$.MODULE$.defaultSize());
            this.prevValue_$eq(value);
        }

        @Override
        public ByteBuffer compress(ByteBuffer from, ByteBuffer to) {
            to.putInt(LongDelta$.MODULE$.typeId());
            if (from.hasRemaining()) {
                long prev = from.getLong();
                to.put((byte)-128);
                to.putLong(prev);
                while (from.hasRemaining()) {
                    ByteBuffer byteBuffer;
                    long current = from.getLong();
                    long delta = current - prev;
                    prev = current;
                    if ((long)-128 < delta && delta <= (long)127) {
                        byteBuffer = to.put((byte)delta);
                        continue;
                    }
                    to.put((byte)-128);
                    byteBuffer = to.putLong(current);
                }
            }
            return to.rewind();
        }

        public Encoder() {
            org.apache.spark.sql.execution.columnar.compression.Encoder.$init$(this);
            this._compressedSize = 0;
            this._uncompressedSize = 0;
        }
    }
}

