/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.univocity.parsers.csv.CsvParser;
import java.io.Serializable;
import java.util.Locale;
import java.util.Properties;
import org.apache.spark.Partition;
import org.apache.spark.annotation.InterfaceStability;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.json.CreateJacksonParser$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JacksonParser;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.FailureSafeParser;
import org.apache.spark.sql.execution.datasources.csv.CSVDataSource$;
import org.apache.spark.sql.execution.datasources.csv.CSVOptions;
import org.apache.spark.sql.execution.datasources.csv.CSVOptions$;
import org.apache.spark.sql.execution.datasources.csv.CSVUtils$;
import org.apache.spark.sql.execution.datasources.csv.TextInputCSVDataSource$;
import org.apache.spark.sql.execution.datasources.csv.UnivocityParser;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCPartition;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRelation;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRelation$;
import org.apache.spark.sql.execution.datasources.json.TextInputJsonDataSource$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Utils$;
import org.apache.spark.sql.sources.v2.DataSourceV2;
import org.apache.spark.sql.sources.v2.ReadSupport;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@InterfaceStability.Stable
@ScalaSignature(bytes="\u0006\u0001\t\rf\u0001B\u00181\u0001eB\u0001B\u0012\u0001\u0003\u0002\u0003\u0006Ia\u0012\u0005\u0007\u0017\u0002!\t\u0001\r'\t\u000b=\u0003A\u0011\u0001)\t\u000by\u0003A\u0011A0\t\u000by\u0003A\u0011A4\t\u000b)\u0004A\u0011A6\t\u000b)\u0004A\u0011\u00019\t\u000b)\u0004A\u0011\u0001<\t\u000b)\u0004A\u0011\u0001?\t\u000f\u0005\u0015\u0001\u0001\"\u0001\u0002\b!9\u0011Q\u0001\u0001\u0005\u0002\u0005]\u0001bBA\u0015\u0001\u0011\u0005\u00111\u0006\u0005\b\u0003S\u0001A\u0011AA\u001e\u0011\u001d\tI\u0003\u0001C\u0001\u0003\u0003Bq!a\u0017\u0001\t\u0013\ti\u0006C\u0004\u0002b\u0001!\t!a\u0019\t\u000f\u0005\u0005\u0004\u0001\"\u0001\u0002x!9\u0011\u0011\r\u0001\u0005\u0002\u0005]\u0005bBAU\u0001\u0011\u0005\u00111\u0016\u0005\b\u0003S\u0003A\u0011AAX\u0011\u001d\tI\u000b\u0001C\u0001\u0003kCq!!+\u0001\t\u0003\tI\u000eC\u0004\u0002*\u0002!\t!a;\t\u000f\u0005]\b\u0001\"\u0001\u0002z\"9\u0011q\u001f\u0001\u0005\u0002\u0005u\bbBA|\u0001\u0011\u0005!1\u0001\u0005\b\u0005\u0013\u0001A\u0011\u0001B\u0006\u0011\u001d\u0011I\u0001\u0001C\u0001\u0005\u001fAqA!\u0006\u0001\t\u0003\u00119\u0002C\u0004\u0003\u0016\u0001!\tAa\u0007\t\u000f\u0005-\u0004\u0001\"\u0001\u0003\"!9!q\u0005\u0001\u0005\u0002\t%\u0002b\u0002B\u0014\u0001\u0011\u0005!Q\u0006\u0005\b\u0005g\u0001A\u0011\u0001B\u001b\u0011\u001d\u0011\u0019\u0004\u0001C\u0001\u0005sAqAa\u0010\u0001\t\u0013\u0011\t\u0005C\u0004\u0003N\u0001!IAa\u0014\t\u0011I\u0003\u0001\u0019!C\u0005\u0005/B\u0011B!\u0017\u0001\u0001\u0004%IAa\u0017\t\u000f\t\u0005\u0004\u0001)Q\u0005'\"I!1\r\u0001A\u0002\u0013%!Q\r\u0005\n\u0005[\u0002\u0001\u0019!C\u0005\u0005_B\u0001Ba\u001d\u0001A\u0003&!q\r\u0005\n\u0005k\u0002\u0001\u0019!C\u0005\u0005oB\u0011Ba\"\u0001\u0001\u0004%IA!#\t\u0011\t5\u0005\u0001)Q\u0005\u0005s\u0012q\u0002R1uC\u001a\u0013\u0018-\\3SK\u0006$WM\u001d\u0006\u0003cI\n1a]9m\u0015\t\u0019D'A\u0003ta\u0006\u00148N\u0003\u00026m\u00051\u0011\r]1dQ\u0016T\u0011aN\u0001\u0004_J<7\u0001A\n\u0004\u0001i\u0002\u0005CA\u001e?\u001b\u0005a$\"A\u001f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}b$AB!osJ+g\r\u0005\u0002B\t6\t!I\u0003\u0002De\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002F\u0005\n9Aj\\4hS:<\u0017\u0001D:qCJ\\7+Z:tS>t\u0007C\u0001%J\u001b\u0005\u0001\u0014B\u0001&1\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003\u0019a\u0014N\\5u}Q\u0011QJ\u0014\t\u0003\u0011\u0002AQA\u0012\u0002A\u0002\u001d\u000baAZ8s[\u0006$HCA'R\u0011\u0015\u00116\u00011\u0001T\u0003\u0019\u0019x.\u001e:dKB\u0011Ak\u0017\b\u0003+f\u0003\"A\u0016\u001f\u000e\u0003]S!\u0001\u0017\u001d\u0002\rq\u0012xn\u001c;?\u0013\tQF(\u0001\u0004Qe\u0016$WMZ\u0005\u00039v\u0013aa\u0015;sS:<'B\u0001.=\u0003\u0019\u00198\r[3nCR\u0011Q\n\u0019\u0005\u0006=\u0012\u0001\r!\u0019\t\u0003E\u0016l\u0011a\u0019\u0006\u0003IB\nQ\u0001^=qKNL!AZ2\u0003\u0015M#(/^2u)f\u0004X\r\u0006\u0002NQ\")\u0011.\u0002a\u0001'\u0006a1o\u00195f[\u0006\u001cFO]5oO\u00061q\u000e\u001d;j_:$2!\u00147o\u0011\u0015ig\u00011\u0001T\u0003\rYW-\u001f\u0005\u0006_\u001a\u0001\raU\u0001\u0006m\u0006dW/\u001a\u000b\u0004\u001bF\u0014\b\"B7\b\u0001\u0004\u0019\u0006\"B8\b\u0001\u0004\u0019\bCA\u001eu\u0013\t)HHA\u0004C_>dW-\u00198\u0015\u00075;\b\u0010C\u0003n\u0011\u0001\u00071\u000bC\u0003p\u0011\u0001\u0007\u0011\u0010\u0005\u0002<u&\u00111\u0010\u0010\u0002\u0005\u0019>tw\rF\u0002N{zDQ!\\\u0005A\u0002MCQa\\\u0005A\u0002}\u00042aOA\u0001\u0013\r\t\u0019\u0001\u0010\u0002\u0007\t>,(\r\\3\u0002\u000f=\u0004H/[8ogR\u0019Q*!\u0003\t\u000f\u0005\u0015!\u00021\u0001\u0002\fA1\u0011QBA\n'Nk!!a\u0004\u000b\u0007\u0005EA(\u0001\u0006d_2dWm\u0019;j_:LA!!\u0006\u0002\u0010\t\u0019Q*\u00199\u0015\u00075\u000bI\u0002C\u0004\u0002\u0006-\u0001\r!a\u0007\u0011\r\u0005u\u0011qE*T\u001b\t\tyB\u0003\u0003\u0002\"\u0005\r\u0012\u0001B;uS2T!!!\n\u0002\t)\fg/Y\u0005\u0005\u0003+\ty\"\u0001\u0003m_\u0006$GCAA\u0017!\u0011\ty#!\u000e\u000f\u0007!\u000b\t$C\u0002\u00024A\nq\u0001]1dW\u0006<W-\u0003\u0003\u00028\u0005e\"!\u0003#bi\u00064%/Y7f\u0015\r\t\u0019\u0004\r\u000b\u0005\u0003[\ti\u0004\u0003\u0004\u0002@5\u0001\raU\u0001\u0005a\u0006$\b\u000e\u0006\u0003\u0002.\u0005\r\u0003bBA#\u001d\u0001\u0007\u0011qI\u0001\u0006a\u0006$\bn\u001d\t\u0005w\u0005%3+C\u0002\u0002Lq\u0012!\u0002\u0010:fa\u0016\fG/\u001a3?Q\rq\u0011q\n\t\u0005\u0003#\n9&\u0004\u0002\u0002T)\u0019\u0011Q\u000b\u001f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002Z\u0005M#a\u0002<be\u0006\u0014xm]\u0001\rY>\fGMV\u0019T_V\u00148-\u001a\u000b\u0005\u0003[\ty\u0006C\u0004\u0002F=\u0001\r!a\u0012\u0002\t)$'m\u0019\u000b\t\u0003[\t)'!\u001b\u0002n!1\u0011q\r\tA\u0002M\u000b1!\u001e:m\u0011\u0019\tY\u0007\u0005a\u0001'\u0006)A/\u00192mK\"9\u0011q\u000e\tA\u0002\u0005E\u0014A\u00039s_B,'\u000f^5fgB!\u0011QDA:\u0013\u0011\t)(a\b\u0003\u0015A\u0013x\u000e]3si&,7\u000f\u0006\t\u0002.\u0005e\u00141PA?\u0003\u0003\u000b))!#\u0002\u0014\"1\u0011qM\tA\u0002MCa!a\u001b\u0012\u0001\u0004\u0019\u0006BBA@#\u0001\u00071+\u0001\u0006d_2,XN\u001c(b[\u0016Da!a!\u0012\u0001\u0004I\u0018A\u00037po\u0016\u0014(i\\;oI\"1\u0011qQ\tA\u0002e\f!\"\u001e9qKJ\u0014u.\u001e8e\u0011\u001d\tY)\u0005a\u0001\u0003\u001b\u000bQB\\;n!\u0006\u0014H/\u001b;j_:\u001c\bcA\u001e\u0002\u0010&\u0019\u0011\u0011\u0013\u001f\u0003\u0007%sG\u000fC\u0004\u0002\u0016F\u0001\r!!\u001d\u0002)\r|gN\\3di&|g\u000e\u0015:pa\u0016\u0014H/[3t))\ti#!'\u0002\u001c\u0006u\u0015q\u0015\u0005\u0007\u0003O\u0012\u0002\u0019A*\t\r\u0005-$\u00031\u0001T\u0011\u001d\tyJ\u0005a\u0001\u0003C\u000b!\u0002\u001d:fI&\u001c\u0017\r^3t!\u0011Y\u00141U*\n\u0007\u0005\u0015FHA\u0003BeJ\f\u0017\u0010C\u0004\u0002\u0016J\u0001\r!!\u001d\u0002\t)\u001cxN\u001c\u000b\u0005\u0003[\ti\u000b\u0003\u0004\u0002@M\u0001\ra\u0015\u000b\u0005\u0003[\t\t\fC\u0004\u0002FQ\u0001\r!a\u0012)\u0007Q\ty\u0005\u0006\u0003\u0002.\u0005]\u0006bBA]+\u0001\u0007\u00111X\u0001\bUN|gN\u0015#E!\u0015\ti,!2T\u001b\t\tyL\u0003\u0003\u0002&\u0005\u0005'bAAbe\u0005\u0019\u0011\r]5\n\t\u0005\u001d\u0017q\u0018\u0002\b\u0015\u00064\u0018M\u0015#EQ\u001d)\u00121ZAi\u0003+\u00042aOAg\u0013\r\ty\r\u0010\u0002\u000bI\u0016\u0004(/Z2bi\u0016$\u0017EAAj\u0003\t*6/\u001a\u0011kg>t\u0007\u0006R1uCN,GoW*ue&tw-X\u0015!S:\u001cH/Z1e]\u0005\u0012\u0011q[\u0001\u0006e9\u0012d\u0006\r\u000b\u0005\u0003[\tY\u000eC\u0004\u0002:Z\u0001\r!!8\u0011\u000b\u0005}\u0017Q]*\u000e\u0005\u0005\u0005(bAAre\u0005\u0019!\u000f\u001a3\n\t\u0005\u001d\u0018\u0011\u001d\u0002\u0004%\u0012#\u0005f\u0002\f\u0002L\u0006E\u0017Q\u001b\u000b\u0005\u0003[\ti\u000fC\u0004\u0002p^\u0001\r!!=\u0002\u0017)\u001cxN\u001c#bi\u0006\u001cX\r\u001e\t\u0005\u0011\u0006M8+C\u0002\u0002vB\u0012q\u0001R1uCN,G/A\u0002dgZ$B!!\f\u0002|\"1\u0011q\b\rA\u0002M#B!!\f\u0002\u0000\"9!\u0011A\rA\u0002\u0005E\u0018AC2tm\u0012\u000bG/Y:fiR!\u0011Q\u0006B\u0003\u0011\u001d\t)E\u0007a\u0001\u0003\u000fB3AGA(\u0003\u001d\u0001\u0018M]9vKR$B!!\f\u0003\u000e!1\u0011qH\u000eA\u0002M#B!!\f\u0003\u0012!9\u0011Q\t\u000fA\u0002\u0005\u001d\u0003f\u0001\u000f\u0002P\u0005\u0019qN]2\u0015\t\u00055\"\u0011\u0004\u0005\u0007\u0003\u007fi\u0002\u0019A*\u0015\t\u00055\"Q\u0004\u0005\b\u0003\u000br\u0002\u0019AA$Q\rq\u0012q\n\u000b\u0005\u0003[\u0011\u0019\u0003\u0003\u0004\u0003&}\u0001\raU\u0001\ni\u0006\u0014G.\u001a(b[\u0016\fA\u0001^3yiR!\u0011Q\u0006B\u0016\u0011\u0019\ty\u0004\ta\u0001'R!\u0011Q\u0006B\u0018\u0011\u001d\t)%\ta\u0001\u0003\u000fB3!IA(\u0003!!X\r\u001f;GS2,G\u0003BAy\u0005oAa!a\u0010#\u0001\u0004\u0019F\u0003BAy\u0005wAq!!\u0012$\u0001\u0004\t9\u0005K\u0002$\u0003\u001f\nq#Y:tKJ$hj\\*qK\u000eLg-[3e'\u000eDW-\\1\u0015\t\t\r#\u0011\n\t\u0004w\t\u0015\u0013b\u0001B$y\t!QK\\5u\u0011\u0019\u0011Y\u0005\na\u0001'\u0006Iq\u000e]3sCRLwN\\\u0001 m\u0016\u0014\u0018NZ=D_2,XN\u001c(b[\u0016|emQ8seV\u0004HOU3d_J$GC\u0002B\"\u0005#\u0012\u0019\u0006C\u0003_K\u0001\u0007\u0011\r\u0003\u0004\u0003V\u0015\u0002\raU\u0001\u001aG>dW/\u001c8OC6,wJZ\"peJ,\b\u000f\u001e*fG>\u0014H-F\u0001T\u0003)\u0019x.\u001e:dK~#S-\u001d\u000b\u0005\u0005\u0007\u0012i\u0006\u0003\u0005\u0003`\u001d\n\t\u00111\u0001T\u0003\rAH%M\u0001\bg>,(oY3!\u0003M)8/\u001a:Ta\u0016\u001c\u0017NZ5fIN\u001b\u0007.Z7b+\t\u00119\u0007\u0005\u0003<\u0005S\n\u0017b\u0001B6y\t1q\n\u001d;j_:\fq#^:feN\u0003XmY5gS\u0016$7k\u00195f[\u0006|F%Z9\u0015\t\t\r#\u0011\u000f\u0005\n\u0005?R\u0013\u0011!a\u0001\u0005O\nA#^:feN\u0003XmY5gS\u0016$7k\u00195f[\u0006\u0004\u0013\u0001D3yiJ\fw\n\u001d;j_:\u001cXC\u0001B=!\u0015\u0011YHa!T\u001b\t\u0011iH\u0003\u0003\u0002\"\t}$b\u0001BAa\u0005A1-\u0019;bYf\u001cH/\u0003\u0003\u0003\u0006\nu$AE\"bg\u0016Len]3og&$\u0018N^3NCB\f\u0001#\u001a=ue\u0006|\u0005\u000f^5p]N|F%Z9\u0015\t\t\r#1\u0012\u0005\n\u0005?j\u0013\u0011!a\u0001\u0005s\nQ\"\u001a=ue\u0006|\u0005\u000f^5p]N\u0004\u0003f\u0001\u0001\u0003\u0012B!!1\u0013BO\u001d\u0011\u0011)J!'\u000e\u0005\t]%bAA+e%!!1\u0014BL\u0003IIe\u000e^3sM\u0006\u001cWm\u0015;bE&d\u0017\u000e^=\n\t\t}%\u0011\u0015\u0002\u0007'R\f'\r\\3\u000b\t\tm%q\u0013")
public class DataFrameReader
implements Logging {
    private final SparkSession sparkSession;
    private String source;
    private Option<StructType> userSpecifiedSchema;
    private CaseInsensitiveMap<String> extraOptions;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Dataset<Row> load(String ... paths) {
        return this.load((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> json(String ... paths) {
        return this.json((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> csv(String ... paths) {
        return this.csv((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> parquet(String ... paths) {
        return this.parquet((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> orc(String ... paths) {
        return this.orc((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> text(String ... paths) {
        return this.text((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<String> textFile(String ... paths) {
        return this.textFile((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public DataFrameReader format(String source) {
        this.source_$eq(source);
        return this;
    }

    public DataFrameReader schema(StructType schema) {
        this.userSpecifiedSchema_$eq((Option<StructType>)Option$.MODULE$.apply((Object)schema));
        return this;
    }

    public DataFrameReader schema(String schemaString) {
        this.userSpecifiedSchema_$eq((Option<StructType>)Option$.MODULE$.apply((Object)StructType$.MODULE$.fromDDL(schemaString)));
        return this;
    }

    public DataFrameReader option(String key, String value) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value)));
        return this;
    }

    public DataFrameReader option(String key, boolean value) {
        return this.option(key, ((Object)BoxesRunTime.boxToBoolean((boolean)value)).toString());
    }

    public DataFrameReader option(String key, long value) {
        return this.option(key, ((Object)BoxesRunTime.boxToLong((long)value)).toString());
    }

    public DataFrameReader option(String key, double value) {
        return this.option(key, ((Object)BoxesRunTime.boxToDouble((double)value)).toString());
    }

    public DataFrameReader options(Map<String, String> options) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus$plus(options));
        return this;
    }

    public DataFrameReader options(java.util.Map<String, String> options) {
        this.options((Map<String, String>)((Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(options).asScala()));
        return this;
    }

    public Dataset<Row> load() {
        return this.load((Seq<String>)((Seq)Seq$.MODULE$.empty()));
    }

    public Dataset<Row> load(String path) {
        return this.option("path", path).load((Seq<String>)((Seq)Seq$.MODULE$.empty()));
    }

    public Dataset<Row> load(Seq<String> paths) {
        Dataset<Row> dataset;
        String string = this.source().toLowerCase(Locale.ROOT);
        String string2 = DDLUtils$.MODULE$.HIVE_PROVIDER();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new AnalysisException("Hive data source can only be used with tables, you can not read files of Hive data source directly.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        Class<?> cls = DataSource$.MODULE$.lookupDataSource(this.source(), this.sparkSession.sessionState().conf());
        if (DataSourceV2.class.isAssignableFrom(cls)) {
            DataSourceV2 ds = (DataSourceV2)cls.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (ds instanceof ReadSupport) {
                scala.collection.immutable.Map<String, String> sessionOptions = DataSourceV2Utils$.MODULE$.extractSessionConfigs(ds, this.sparkSession.sessionState().conf());
                ObjectMapper objectMapper = new ObjectMapper();
                Tuple2 pathsOption = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paths"), (Object)objectMapper.writeValueAsString(paths.toArray(ClassTag$.MODULE$.apply(String.class))));
                DataSourceV2 x$1 = ds;
                scala.collection.immutable.Map x$2 = sessionOptions.$plus$plus((GenTraversableOnce)this.extraOptions().toMap()).$plus(pathsOption);
                Option<StructType> x$3 = this.userSpecifiedSchema();
                Option<TableIdentifier> x$4 = DataSourceV2Relation$.MODULE$.create$default$3();
                dataset = Dataset$.MODULE$.ofRows(this.sparkSession, (LogicalPlan)DataSourceV2Relation$.MODULE$.create(x$1, (scala.collection.immutable.Map<String, String>)x$2, x$4, x$3));
            } else {
                dataset = this.loadV1Source(paths);
            }
        } else {
            dataset = this.loadV1Source(paths);
        }
        return dataset;
    }

    private Dataset<Row> loadV1Source(Seq<String> paths) {
        SparkSession x$1 = this.sparkSession;
        Seq<String> x$2 = paths;
        Option<StructType> x$3 = this.userSpecifiedSchema();
        String x$4 = this.source();
        scala.collection.immutable.Map x$5 = this.extraOptions().toMap();
        Seq<String> x$6 = DataSource$.MODULE$.apply$default$5();
        Option<BucketSpec> x$7 = DataSource$.MODULE$.apply$default$6();
        Option<CatalogTable> x$8 = DataSource$.MODULE$.apply$default$8();
        DataSource qual$1 = new DataSource(x$1, x$4, x$2, x$3, x$6, x$7, (scala.collection.immutable.Map<String, String>)x$5, x$8);
        boolean x$9 = qual$1.resolveRelation$default$1();
        return this.sparkSession.baseRelationToDataFrame(qual$1.resolveRelation(x$9));
    }

    public Dataset<Row> jdbc(String url, String table, Properties properties) {
        this.assertNoSpecifiedSchema("jdbc");
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus$plus((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(properties).asScala()));
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus$plus((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_URL()), (Object)url), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_TABLE_NAME()), (Object)table)}))));
        return this.format("jdbc").load();
    }

    public Dataset<Row> jdbc(String url, String table, String columnName, long lowerBound, long upperBound, int numPartitions, Properties connectionProperties) {
        this.extraOptions_$eq((CaseInsensitiveMap<String>)this.extraOptions().$plus$plus((TraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_PARTITION_COLUMN()), (Object)columnName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_LOWER_BOUND()), (Object)((Object)BoxesRunTime.boxToLong((long)lowerBound)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_UPPER_BOUND()), (Object)((Object)BoxesRunTime.boxToLong((long)upperBound)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_NUM_PARTITIONS()), (Object)((Object)BoxesRunTime.boxToInteger((int)numPartitions)).toString())}))));
        return this.jdbc(url, table, connectionProperties);
    }

    public Dataset<Row> jdbc(String url, String table, String[] predicates, Properties connectionProperties) {
        this.assertNoSpecifiedSchema("jdbc");
        CaseInsensitiveMap params = this.extraOptions().$plus$plus((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(connectionProperties).asScala());
        JDBCOptions options = new JDBCOptions(url, table, (scala.collection.immutable.Map<String, String>)params);
        Partition[] parts = (Partition[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])predicates)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String part = (String)tuple2._1();
            int i = tuple2._2$mcI$sp();
            JDBCPartition jDBCPartition = new JDBCPartition(part, i);
            return jDBCPartition;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Partition.class)));
        JDBCRelation relation = JDBCRelation$.MODULE$.apply(parts, options, this.sparkSession);
        return this.sparkSession.baseRelationToDataFrame(relation);
    }

    public Dataset<Row> json(String path) {
        return this.json((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<Row> json(Seq<String> paths) {
        return this.format("json").load(paths);
    }

    public Dataset<Row> json(JavaRDD<String> jsonRDD) {
        return this.json((RDD<String>)jsonRDD.rdd());
    }

    public Dataset<Row> json(RDD<String> jsonRDD) {
        return this.json(this.sparkSession.createDataset(jsonRDD, Encoders$.MODULE$.STRING()));
    }

    public Dataset<Row> json(Dataset<String> jsonDataset) {
        JSONOptions parsedOptions = new JSONOptions(this.extraOptions().toMap(), this.sparkSession.sessionState().conf().sessionLocalTimeZone(), this.sparkSession.sessionState().conf().columnNameOfCorruptRecord());
        StructType schema = (StructType)this.userSpecifiedSchema().getOrElse((Function0 & Serializable & scala.Serializable)() -> TextInputJsonDataSource$.MODULE$.inferFromDataset(jsonDataset, parsedOptions));
        this.verifyColumnNameOfCorruptRecord(schema, parsedOptions.columnNameOfCorruptRecord());
        StructType actualSchema = StructType$.MODULE$.apply((Seq)schema.filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DataFrameReader.$anonfun$json$2(parsedOptions, x$1))));
        Function2 & Serializable & scala.Serializable createParser = (Function2 & Serializable & scala.Serializable)(jsonFactory, record) -> CreateJacksonParser$.MODULE$.string(jsonFactory, record);
        RDD parsed = jsonDataset.rdd().mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            JacksonParser rawParser = new JacksonParser((DataType)actualSchema, parsedOptions);
            FailureSafeParser parser = new FailureSafeParser((Function1 & Serializable & scala.Serializable)input -> rawParser.parse(input, createParser, (Function1 & Serializable & scala.Serializable)x$1 -> UTF8String.fromString((String)x$1)), parsedOptions.parseMode(), schema, parsedOptions.columnNameOfCorruptRecord());
            return iter.flatMap((Function1 & Serializable & scala.Serializable)input -> parser.parse(input));
        }, jsonDataset.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(InternalRow.class));
        return this.sparkSession.internalCreateDataFrame((RDD<InternalRow>)parsed, schema, jsonDataset.isStreaming());
    }

    public Dataset<Row> csv(String path) {
        return this.csv((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<Row> csv(Dataset<String> csvDataset) {
        RDD rDD;
        CSVOptions parsedOptions = new CSVOptions((scala.collection.immutable.Map<String, String>)this.extraOptions().toMap(), this.sparkSession.sessionState().conf().csvColumnPruning(), this.sparkSession.sessionState().conf().sessionLocalTimeZone(), CSVOptions$.MODULE$.$lessinit$greater$default$4());
        Dataset<String> filteredLines = CSVUtils$.MODULE$.filterCommentAndEmpty(csvDataset, parsedOptions);
        Option maybeFirstLine = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredLines.take(1))).headOption();
        StructType schema = (StructType)this.userSpecifiedSchema().getOrElse((Function0 & Serializable & scala.Serializable)() -> TextInputCSVDataSource$.MODULE$.inferFromDataset($this.sparkSession, csvDataset, (Option<String>)maybeFirstLine, parsedOptions));
        this.verifyColumnNameOfCorruptRecord(schema, parsedOptions.columnNameOfCorruptRecord());
        StructType actualSchema = StructType$.MODULE$.apply((Seq)schema.filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DataFrameReader.$anonfun$csv$2(parsedOptions, x$2))));
        if (parsedOptions.headerFlag() && maybeFirstLine.isDefined()) {
            String firstLine = (String)maybeFirstLine.get();
            CsvParser parser = new CsvParser(parsedOptions.asParserSettings());
            String[] columnNames = parser.parseLine(firstLine);
            CSVDataSource$.MODULE$.checkHeaderColumnNames(actualSchema, columnNames, csvDataset.getClass().getCanonicalName(), parsedOptions.enforceSchema(), this.sparkSession.sessionState().conf().caseSensitiveAnalysis());
            rDD = filteredLines.rdd().mapPartitions((Function1 & Serializable & scala.Serializable)x$3 -> CSVUtils$.MODULE$.filterHeaderLine((Iterator<String>)x$3, firstLine, parsedOptions), filteredLines.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(String.class));
        } else {
            rDD = filteredLines.rdd();
        }
        RDD linesWithoutHeader = rDD;
        RDD parsed = linesWithoutHeader.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            UnivocityParser rawParser = new UnivocityParser(actualSchema, parsedOptions);
            FailureSafeParser parser = new FailureSafeParser((Function1 & Serializable & scala.Serializable)input -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalRow[]{rawParser.parse((String)input)})), parsedOptions.parseMode(), schema, parsedOptions.columnNameOfCorruptRecord());
            return iter.flatMap((Function1 & Serializable & scala.Serializable)input -> parser.parse(input));
        }, linesWithoutHeader.mapPartitions$default$2(), ClassTag$.MODULE$.apply(InternalRow.class));
        return this.sparkSession.internalCreateDataFrame((RDD<InternalRow>)parsed, schema, csvDataset.isStreaming());
    }

    public Dataset<Row> csv(Seq<String> paths) {
        return this.format("csv").load(paths);
    }

    public Dataset<Row> parquet(String path) {
        return this.parquet((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<Row> parquet(Seq<String> paths) {
        return this.format("parquet").load(paths);
    }

    public Dataset<Row> orc(String path) {
        return this.orc((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<Row> orc(Seq<String> paths) {
        return this.format("orc").load(paths);
    }

    public Dataset<Row> table(String tableName) {
        this.assertNoSpecifiedSchema("table");
        return this.sparkSession.table(tableName);
    }

    public Dataset<Row> text(String path) {
        return this.text((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<Row> text(Seq<String> paths) {
        return this.format("text").load(paths);
    }

    public Dataset<String> textFile(String path) {
        return this.textFile((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<String> textFile(Seq<String> paths) {
        this.assertNoSpecifiedSchema("textFile");
        return this.text(paths).select("value", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).as(this.sparkSession.implicits().newStringEncoder());
    }

    private void assertNoSpecifiedSchema(String operation) {
        if (this.userSpecifiedSchema().nonEmpty()) {
            throw new AnalysisException(new StringBuilder(43).append("User specified schema not supported with `").append(operation).append("`").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    private void verifyColumnNameOfCorruptRecord(StructType schema, String columnNameOfCorruptRecord) {
        schema.getFieldIndex(columnNameOfCorruptRecord).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)corruptFieldIndex -> {
            StructField f = schema.apply(corruptFieldIndex);
            DataType dataType = f.dataType();
            StringType$ stringType$ = StringType$.MODULE$;
            if ((dataType != null ? !dataType.equals(stringType$) : stringType$ != null) || !f.nullable()) {
                throw new AnalysisException("The field for corrupt records must be string type and nullable", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
        });
    }

    private String source() {
        return this.source;
    }

    private void source_$eq(String x$1) {
        this.source = x$1;
    }

    private Option<StructType> userSpecifiedSchema() {
        return this.userSpecifiedSchema;
    }

    private void userSpecifiedSchema_$eq(Option<StructType> x$1) {
        this.userSpecifiedSchema = x$1;
    }

    private CaseInsensitiveMap<String> extraOptions() {
        return this.extraOptions;
    }

    private void extraOptions_$eq(CaseInsensitiveMap<String> x$1) {
        this.extraOptions = x$1;
    }

    public static final /* synthetic */ boolean $anonfun$json$2(JSONOptions parsedOptions$1, StructField x$1) {
        String string = x$1.name();
        String string2 = parsedOptions$1.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$csv$2(CSVOptions parsedOptions$2, StructField x$2) {
        String string = x$2.name();
        String string2 = parsedOptions$2.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public DataFrameReader(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
        Logging.$init$((Logging)this);
        this.source = sparkSession.sessionState().conf().defaultDataSourceName();
        this.userSpecifiedSchema = None$.MODULE$;
        this.extraOptions = CaseInsensitiveMap$.MODULE$.apply(Predef$.MODULE$.Map().empty());
    }
}

