/*
 * Decompiled with CFR 0.152.
 */
package test.org.apache.spark.sql;

import com.google.common.base.Objects;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.spark.Accumulator;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.CoGroupFunction;
import org.apache.spark.api.java.function.FilterFunction;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.FlatMapGroupsFunction;
import org.apache.spark.api.java.function.ForeachFunction;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.api.java.function.MapGroupsFunction;
import org.apache.spark.api.java.function.MapPartitionsFunction;
import org.apache.spark.api.java.function.ReduceFunction;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.GroupedDataset;
import org.apache.spark.sql.catalyst.encoders.OuterScopes;
import org.apache.spark.sql.catalyst.expressions.GenericRow;
import org.apache.spark.sql.expressions.Aggregator;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.test.TestSQLContext;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;

public class JavaDatasetSuite
implements Serializable {
    private transient JavaSparkContext jsc;
    private transient TestSQLContext context;
    @Rule
    public transient ExpectedException nullabilityCheck = ExpectedException.none();

    @Before
    public void setUp() {
        SparkContext sc = new SparkContext("local[*]", "testing");
        this.jsc = new JavaSparkContext(sc);
        this.context = new TestSQLContext(sc);
        this.context.loadTestData();
    }

    @After
    public void tearDown() {
        this.context.sparkContext().stop();
        this.context = null;
        this.jsc = null;
    }

    private <T1, T2> Tuple2<T1, T2> tuple2(T1 t1, T2 t2) {
        return new Tuple2(t1, t2);
    }

    @Test
    public void testCollect() {
        List<String> data = Arrays.asList("hello", "world");
        Dataset ds = this.context.createDataset(data, Encoders.STRING());
        List collected = ds.collectAsList();
        Assert.assertEquals(Arrays.asList("hello", "world"), (Object)collected);
    }

    @Test
    public void testTake() {
        List<String> data = Arrays.asList("hello", "world");
        Dataset ds = this.context.createDataset(data, Encoders.STRING());
        List collected = ds.takeAsList(1);
        Assert.assertEquals(Arrays.asList("hello"), (Object)collected);
    }

    @Test
    public void testCommonOperation() {
        List<String> data = Arrays.asList("hello", "world");
        Dataset ds = this.context.createDataset(data, Encoders.STRING());
        Assert.assertEquals((Object)"hello", (Object)ds.first());
        Dataset filtered = ds.filter((FilterFunction)new FilterFunction<String>(){

            public boolean call(String v) throws Exception {
                return v.startsWith("h");
            }
        });
        Assert.assertEquals(Arrays.asList("hello"), (Object)filtered.collectAsList());
        Dataset mapped = ds.map((MapFunction)new MapFunction<String, Integer>(){

            public Integer call(String v) throws Exception {
                return v.length();
            }
        }, Encoders.INT());
        Assert.assertEquals(Arrays.asList(5, 5), (Object)mapped.collectAsList());
        Dataset parMapped = ds.mapPartitions((MapPartitionsFunction)new MapPartitionsFunction<String, String>(){

            public Iterable<String> call(Iterator<String> it) throws Exception {
                LinkedList<String> ls = new LinkedList<String>();
                while (it.hasNext()) {
                    ls.add(it.next().toUpperCase());
                }
                return ls;
            }
        }, Encoders.STRING());
        Assert.assertEquals(Arrays.asList("HELLO", "WORLD"), (Object)parMapped.collectAsList());
        Dataset flatMapped = ds.flatMap((FlatMapFunction)new FlatMapFunction<String, String>(){

            public Iterable<String> call(String s) throws Exception {
                LinkedList<String> ls = new LinkedList<String>();
                for (char c : s.toCharArray()) {
                    ls.add(String.valueOf(c));
                }
                return ls;
            }
        }, Encoders.STRING());
        Assert.assertEquals(Arrays.asList("h", "e", "l", "l", "o", "w", "o", "r", "l", "d"), (Object)flatMapped.collectAsList());
    }

    @Test
    public void testForeach() {
        final Accumulator accum = this.jsc.accumulator(0);
        List<String> data = Arrays.asList("a", "b", "c");
        Dataset ds = this.context.createDataset(data, Encoders.STRING());
        ds.foreach((ForeachFunction)new ForeachFunction<String>(){

            public void call(String s) throws Exception {
                accum.add((Object)1);
            }
        });
        Assert.assertEquals((long)3L, (long)((Integer)accum.value()).intValue());
    }

    @Test
    public void testReduce() {
        List<Integer> data = Arrays.asList(1, 2, 3);
        Dataset ds = this.context.createDataset(data, Encoders.INT());
        int reduced = (Integer)ds.reduce((ReduceFunction)new ReduceFunction<Integer>(){

            public Integer call(Integer v1, Integer v2) throws Exception {
                return v1 + v2;
            }
        });
        Assert.assertEquals((long)6L, (long)reduced);
    }

    @Test
    public void testGroupBy() {
        List<String> data = Arrays.asList("a", "foo", "bar");
        Dataset ds = this.context.createDataset(data, Encoders.STRING());
        GroupedDataset grouped = ds.groupBy((MapFunction)new MapFunction<String, Integer>(){

            public Integer call(String v) throws Exception {
                return v.length();
            }
        }, Encoders.INT());
        Dataset mapped = grouped.mapGroups((MapGroupsFunction)new MapGroupsFunction<Integer, String, String>(){

            public String call(Integer key, Iterator<String> values) throws Exception {
                StringBuilder sb = new StringBuilder(key.toString());
                while (values.hasNext()) {
                    sb.append(values.next());
                }
                return sb.toString();
            }
        }, Encoders.STRING());
        Assert.assertEquals(Arrays.asList("1a", "3foobar"), (Object)mapped.collectAsList());
        Dataset flatMapped = grouped.flatMapGroups((FlatMapGroupsFunction)new FlatMapGroupsFunction<Integer, String, String>(){

            public Iterable<String> call(Integer key, Iterator<String> values) throws Exception {
                StringBuilder sb = new StringBuilder(key.toString());
                while (values.hasNext()) {
                    sb.append(values.next());
                }
                return Collections.singletonList(sb.toString());
            }
        }, Encoders.STRING());
        Assert.assertEquals(Arrays.asList("1a", "3foobar"), (Object)flatMapped.collectAsList());
        Dataset reduced = grouped.reduce((ReduceFunction)new ReduceFunction<String>(){

            public String call(String v1, String v2) throws Exception {
                return v1 + v2;
            }
        });
        Assert.assertEquals(Arrays.asList(this.tuple2(1, "a"), this.tuple2(3, "foobar")), (Object)reduced.collectAsList());
        List<Integer> data2 = Arrays.asList(2, 6, 10);
        Dataset ds2 = this.context.createDataset(data2, Encoders.INT());
        GroupedDataset grouped2 = ds2.groupBy((MapFunction)new MapFunction<Integer, Integer>(){

            public Integer call(Integer v) throws Exception {
                return v / 2;
            }
        }, Encoders.INT());
        Dataset cogrouped = grouped.cogroup(grouped2, (CoGroupFunction)new CoGroupFunction<Integer, String, Integer, String>(){

            public Iterable<String> call(Integer key, Iterator<String> left, Iterator<Integer> right) throws Exception {
                StringBuilder sb = new StringBuilder(key.toString());
                while (left.hasNext()) {
                    sb.append(left.next());
                }
                sb.append("#");
                while (right.hasNext()) {
                    sb.append(right.next());
                }
                return Collections.singletonList(sb.toString());
            }
        }, Encoders.STRING());
        Assert.assertEquals(Arrays.asList("1a#2", "3foobar#6", "5#10"), (Object)cogrouped.collectAsList());
    }

    @Test
    public void testGroupByColumn() {
        List<String> data = Arrays.asList("a", "foo", "bar");
        Dataset ds = this.context.createDataset(data, Encoders.STRING());
        GroupedDataset grouped = ds.groupBy(new Column[]{functions.length((Column)functions.col((String)"value"))}).keyAs(Encoders.INT());
        Dataset mapped = grouped.mapGroups((MapGroupsFunction)new MapGroupsFunction<Integer, String, String>(){

            public String call(Integer key, Iterator<String> data) throws Exception {
                StringBuilder sb = new StringBuilder(key.toString());
                while (data.hasNext()) {
                    sb.append(data.next());
                }
                return sb.toString();
            }
        }, Encoders.STRING());
        Assert.assertEquals(Arrays.asList("1a", "3foobar"), (Object)mapped.collectAsList());
    }

    @Test
    public void testSelect() {
        List<Integer> data = Arrays.asList(2, 6);
        Dataset ds = this.context.createDataset(data, Encoders.INT());
        Dataset selected = ds.select(new Column[]{functions.expr((String)"value + 1"), functions.col((String)"value").cast("string")}).as(Encoders.tuple((Encoder)Encoders.INT(), (Encoder)Encoders.STRING()));
        Assert.assertEquals(Arrays.asList(this.tuple2(3, "2"), this.tuple2(7, "6")), (Object)selected.collectAsList());
    }

    @Test
    public void testSetOperation() {
        List<String> data = Arrays.asList("abc", "abc", "xyz");
        Dataset ds = this.context.createDataset(data, Encoders.STRING());
        Assert.assertEquals(Arrays.asList("abc", "xyz"), (Object)this.sort((Comparable[])ds.distinct().collectAsList().toArray(new String[0])));
        List<String> data2 = Arrays.asList("xyz", "foo", "foo");
        Dataset ds2 = this.context.createDataset(data2, Encoders.STRING());
        Dataset intersected = ds.intersect(ds2);
        Assert.assertEquals(Arrays.asList("xyz"), (Object)intersected.collectAsList());
        Dataset unioned = ds.union(ds2);
        Assert.assertEquals(Arrays.asList("abc", "abc", "foo", "foo", "xyz", "xyz"), (Object)this.sort((Comparable[])unioned.collectAsList().toArray(new String[0])));
        Dataset subtracted = ds.subtract(ds2);
        Assert.assertEquals(Arrays.asList("abc", "abc"), (Object)subtracted.collectAsList());
    }

    private <T extends Comparable<T>> List<T> sort(T[] data) {
        Arrays.sort(data);
        return Arrays.asList(data);
    }

    @Test
    public void testJoin() {
        List<Integer> data = Arrays.asList(1, 2, 3);
        Dataset ds = this.context.createDataset(data, Encoders.INT()).as("a");
        List<Integer> data2 = Arrays.asList(2, 3, 4);
        Dataset ds2 = this.context.createDataset(data2, Encoders.INT()).as("b");
        Dataset joined = ds.joinWith(ds2, functions.col((String)"a.value").equalTo((Object)functions.col((String)"b.value")));
        Assert.assertEquals(Arrays.asList(this.tuple2(2, 2), this.tuple2(3, 3)), (Object)joined.collectAsList());
    }

    @Test
    public void testTupleEncoder() {
        Encoder encoder2 = Encoders.tuple((Encoder)Encoders.INT(), (Encoder)Encoders.STRING());
        List<Tuple2> data2 = Arrays.asList(this.tuple2(1, "a"), this.tuple2(2, "b"));
        Dataset ds2 = this.context.createDataset(data2, encoder2);
        Assert.assertEquals(data2, (Object)ds2.collectAsList());
        Encoder encoder3 = Encoders.tuple((Encoder)Encoders.INT(), (Encoder)Encoders.LONG(), (Encoder)Encoders.STRING());
        List<Tuple3> data3 = Arrays.asList(new Tuple3((Object)1, (Object)2L, (Object)"a"));
        Dataset ds3 = this.context.createDataset(data3, encoder3);
        Assert.assertEquals(data3, (Object)ds3.collectAsList());
        Encoder encoder4 = Encoders.tuple((Encoder)Encoders.INT(), (Encoder)Encoders.STRING(), (Encoder)Encoders.LONG(), (Encoder)Encoders.STRING());
        List<Tuple4> data4 = Arrays.asList(new Tuple4((Object)1, (Object)"b", (Object)2L, (Object)"a"));
        Dataset ds4 = this.context.createDataset(data4, encoder4);
        Assert.assertEquals(data4, (Object)ds4.collectAsList());
        Encoder encoder5 = Encoders.tuple((Encoder)Encoders.INT(), (Encoder)Encoders.STRING(), (Encoder)Encoders.LONG(), (Encoder)Encoders.STRING(), (Encoder)Encoders.BOOLEAN());
        List<Tuple5> data5 = Arrays.asList(new Tuple5((Object)1, (Object)"b", (Object)2L, (Object)"a", (Object)true));
        Dataset ds5 = this.context.createDataset(data5, encoder5);
        Assert.assertEquals(data5, (Object)ds5.collectAsList());
    }

    @Test
    public void testNestedTupleEncoder() {
        Encoder encoder = Encoders.tuple((Encoder)Encoders.tuple((Encoder)Encoders.INT(), (Encoder)Encoders.STRING()), (Encoder)Encoders.STRING());
        List<Tuple2> data = Arrays.asList(this.tuple2(this.tuple2(1, "a"), "a"), this.tuple2(this.tuple2(2, "b"), "b"));
        Dataset ds = this.context.createDataset(data, encoder);
        Assert.assertEquals(data, (Object)ds.collectAsList());
        Encoder encoder2 = Encoders.tuple((Encoder)Encoders.INT(), (Encoder)Encoders.tuple((Encoder)Encoders.STRING(), (Encoder)Encoders.STRING(), (Encoder)Encoders.LONG()));
        List<Tuple2> data2 = Arrays.asList(this.tuple2(1, new Tuple3((Object)"a", (Object)"b", (Object)3L)));
        Dataset ds2 = this.context.createDataset(data2, encoder2);
        Assert.assertEquals(data2, (Object)ds2.collectAsList());
        Encoder encoder3 = Encoders.tuple((Encoder)Encoders.INT(), (Encoder)Encoders.tuple((Encoder)Encoders.tuple((Encoder)Encoders.STRING(), (Encoder)Encoders.LONG()), (Encoder)Encoders.STRING()));
        List<Tuple2> data3 = Arrays.asList(this.tuple2(1, this.tuple2(this.tuple2("a", 2L), "b")));
        Dataset ds3 = this.context.createDataset(data3, encoder3);
        Assert.assertEquals(data3, (Object)ds3.collectAsList());
    }

    @Test
    public void testPrimitiveEncoder() {
        Encoder encoder = Encoders.tuple((Encoder)Encoders.DOUBLE(), (Encoder)Encoders.DECIMAL(), (Encoder)Encoders.DATE(), (Encoder)Encoders.TIMESTAMP(), (Encoder)Encoders.FLOAT());
        List<Tuple5> data = Arrays.asList(new Tuple5((Object)Double.MAX_VALUE, (Object)new BigDecimal("0.922337203685477589"), (Object)Date.valueOf("1970-01-01"), (Object)new Timestamp(System.currentTimeMillis()), (Object)Float.valueOf(Float.MAX_VALUE)));
        Dataset ds = this.context.createDataset(data, encoder);
        Assert.assertEquals(data, (Object)ds.collectAsList());
    }

    @Test
    public void testTypedAggregation() {
        Encoder encoder = Encoders.tuple((Encoder)Encoders.STRING(), (Encoder)Encoders.INT());
        List<Tuple2> data = Arrays.asList(this.tuple2("a", 1), this.tuple2("a", 2), this.tuple2("b", 3));
        Dataset ds = this.context.createDataset(data, encoder);
        GroupedDataset grouped = ds.groupBy((MapFunction)new MapFunction<Tuple2<String, Integer>, String>(){

            public String call(Tuple2<String, Integer> value) throws Exception {
                return (String)value._1();
            }
        }, Encoders.STRING());
        Dataset agged = grouped.agg(new IntSumOf().toColumn(Encoders.INT(), Encoders.INT()));
        Assert.assertEquals(Arrays.asList(this.tuple2("a", 3), this.tuple2("b", 3)), (Object)agged.collectAsList());
        Dataset agged2 = grouped.agg(new IntSumOf().toColumn(Encoders.INT(), Encoders.INT())).as(Encoders.tuple((Encoder)Encoders.STRING(), (Encoder)Encoders.INT()));
        Assert.assertEquals(Arrays.asList(new Tuple2((Object)"a", (Object)3), new Tuple2((Object)"b", (Object)3)), (Object)agged2.collectAsList());
    }

    @Test
    public void testKryoEncoder() {
        Encoder encoder = Encoders.kryo(KryoSerializable.class);
        List<KryoSerializable> data = Arrays.asList(new KryoSerializable("hello"), new KryoSerializable("world"));
        Dataset ds = this.context.createDataset(data, encoder);
        Assert.assertEquals(data, (Object)ds.collectAsList());
    }

    @Test
    public void testJavaEncoder() {
        Encoder encoder = Encoders.javaSerialization(JavaSerializable.class);
        List<JavaSerializable> data = Arrays.asList(new JavaSerializable("hello"), new JavaSerializable("world"));
        Dataset ds = this.context.createDataset(data, encoder);
        Assert.assertEquals(data, (Object)ds.collectAsList());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testJavaEncoderErrorMessageForPrivateClass() {
        Encoders.javaSerialization(PrivateClassTest.class);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testKryoEncoderErrorMessageForPrivateClass() {
        Encoders.kryo(PrivateClassTest.class);
    }

    @Test
    public void testJavaBeanEncoder() {
        OuterScopes.addOuterScope((Object)this);
        SimpleJavaBean obj1 = new SimpleJavaBean();
        obj1.setA(true);
        obj1.setB(3);
        obj1.setC(new byte[]{1, 2});
        obj1.setD(new String[]{"hello", null});
        obj1.setE(Arrays.asList("a", "b"));
        obj1.setF(Arrays.asList(100L, null, 200L));
        SimpleJavaBean obj2 = new SimpleJavaBean();
        obj2.setA(false);
        obj2.setB(30);
        obj2.setC(new byte[]{3, 4});
        obj2.setD(new String[]{null, "world"});
        obj2.setE(Arrays.asList("x", "y"));
        obj2.setF(Arrays.asList(300L, null, 400L));
        List<SimpleJavaBean> data = Arrays.asList(obj1, obj2);
        Dataset ds = this.context.createDataset(data, Encoders.bean(SimpleJavaBean.class));
        Assert.assertEquals(data, (Object)ds.collectAsList());
        NestedJavaBean obj3 = new NestedJavaBean();
        obj3.setA(obj1);
        List<NestedJavaBean> data2 = Arrays.asList(obj3);
        Dataset ds2 = this.context.createDataset(data2, Encoders.bean(NestedJavaBean.class));
        Assert.assertEquals(data2, (Object)ds2.collectAsList());
        GenericRow row1 = new GenericRow(new Object[]{true, 3, new byte[]{1, 2}, new String[]{"hello", null}, Arrays.asList("a", "b"), Arrays.asList(100L, null, 200L)});
        GenericRow row2 = new GenericRow(new Object[]{false, 30, new byte[]{3, 4}, new String[]{null, "world"}, Arrays.asList("x", "y"), Arrays.asList(300L, null, 400L)});
        StructType schema = new StructType().add("a", DataTypes.BooleanType, false).add("b", DataTypes.IntegerType, false).add("c", DataTypes.BinaryType).add("d", (DataType)DataTypes.createArrayType((DataType)DataTypes.StringType)).add("e", (DataType)DataTypes.createArrayType((DataType)DataTypes.StringType)).add("f", (DataType)DataTypes.createArrayType((DataType)DataTypes.LongType));
        Dataset ds3 = this.context.createDataFrame(Arrays.asList(row1, row2), schema).as(Encoders.bean(SimpleJavaBean.class));
        Assert.assertEquals(data, (Object)ds3.collectAsList());
    }

    @Test
    public void testJavaBeanEncoder2() {
        OuterScopes.addOuterScope((Object)this);
        SimpleJavaBean2 obj = new SimpleJavaBean2();
        obj.setA(new Timestamp(0L));
        obj.setB(new Date(0L));
        obj.setC(BigDecimal.valueOf(1L));
        Dataset ds = this.context.createDataset(Arrays.asList(obj), Encoders.bean(SimpleJavaBean2.class));
        ds.collect();
    }

    @Test
    public void testRuntimeNullabilityCheck() {
        OuterScopes.addOuterScope((Object)this);
        StructType schema = new StructType().add("f", (DataType)new StructType().add("a", DataTypes.StringType, true).add("b", DataTypes.IntegerType, true), true);
        GenericRow row = new GenericRow(new Object[]{new GenericRow(new Object[]{"hello", 1})});
        DataFrame df2 = this.context.createDataFrame(Collections.singletonList(row), schema);
        Dataset ds = df2.as(Encoders.bean(NestedSmallBean.class));
        SmallBean smallBean = new SmallBean();
        smallBean.setA("hello");
        smallBean.setB(1);
        NestedSmallBean nestedSmallBean = new NestedSmallBean();
        nestedSmallBean.setF(smallBean);
        Assert.assertEquals((Object)ds.collectAsList(), Collections.singletonList(nestedSmallBean));
        row = new GenericRow(new Object[]{null});
        df2 = this.context.createDataFrame(Collections.singletonList(row), schema);
        ds = df2.as(Encoders.bean(NestedSmallBean.class));
        NestedSmallBean nestedSmallBean2 = new NestedSmallBean();
        Assert.assertEquals((Object)ds.collectAsList(), Collections.singletonList(nestedSmallBean2));
        this.nullabilityCheck.expect(RuntimeException.class);
        this.nullabilityCheck.expectMessage("Null value appeared in non-nullable field");
        row = new GenericRow(new Object[]{new GenericRow(new Object[]{"hello", null})});
        df2 = this.context.createDataFrame(Collections.singletonList(row), schema);
        ds = df2.as(Encoders.bean(NestedSmallBean.class));
        ds.collect();
    }

    public class NestedSmallBean
    implements Serializable {
        private SmallBean f;

        public SmallBean getF() {
            return this.f;
        }

        public void setF(SmallBean f) {
            this.f = f;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NestedSmallBean that = (NestedSmallBean)o;
            return Objects.equal((Object)this.f, (Object)that.f);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.f});
        }
    }

    public class SmallBean
    implements Serializable {
        private String a;
        private int b;

        public int getB() {
            return this.b;
        }

        public void setB(int b) {
            this.b = b;
        }

        public String getA() {
            return this.a;
        }

        public void setA(String a) {
            this.a = a;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SmallBean smallBean = (SmallBean)o;
            return this.b == smallBean.b && Objects.equal((Object)this.a, (Object)smallBean.a);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.a, this.b});
        }
    }

    public class NestedJavaBean
    implements Serializable {
        private SimpleJavaBean a;

        public SimpleJavaBean getA() {
            return this.a;
        }

        public void setA(SimpleJavaBean a) {
            this.a = a;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NestedJavaBean that = (NestedJavaBean)o;
            return this.a.equals(that.a);
        }

        public int hashCode() {
            return this.a.hashCode();
        }
    }

    public class SimpleJavaBean2
    implements Serializable {
        private Timestamp a;
        private Date b;
        private BigDecimal c;

        public Timestamp getA() {
            return this.a;
        }

        public void setA(Timestamp a) {
            this.a = a;
        }

        public Date getB() {
            return this.b;
        }

        public void setB(Date b) {
            this.b = b;
        }

        public BigDecimal getC() {
            return this.c;
        }

        public void setC(BigDecimal c) {
            this.c = c;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleJavaBean that = (SimpleJavaBean)o;
            if (!this.a.equals(that.a)) {
                return false;
            }
            if (!this.b.equals(that.b)) {
                return false;
            }
            return this.c.equals(that.c);
        }

        public int hashCode() {
            int result = this.a.hashCode();
            result = 31 * result + this.b.hashCode();
            result = 31 * result + this.c.hashCode();
            return result;
        }
    }

    public class SimpleJavaBean
    implements Serializable {
        private boolean a;
        private int b;
        private byte[] c;
        private String[] d;
        private List<String> e;
        private List<Long> f;

        public boolean isA() {
            return this.a;
        }

        public void setA(boolean a) {
            this.a = a;
        }

        public int getB() {
            return this.b;
        }

        public void setB(int b) {
            this.b = b;
        }

        public byte[] getC() {
            return this.c;
        }

        public void setC(byte[] c) {
            this.c = c;
        }

        public String[] getD() {
            return this.d;
        }

        public void setD(String[] d) {
            this.d = d;
        }

        public List<String> getE() {
            return this.e;
        }

        public void setE(List<String> e) {
            this.e = e;
        }

        public List<Long> getF() {
            return this.f;
        }

        public void setF(List<Long> f) {
            this.f = f;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleJavaBean that = (SimpleJavaBean)o;
            if (this.a != that.a) {
                return false;
            }
            if (this.b != that.b) {
                return false;
            }
            if (!Arrays.equals(this.c, that.c)) {
                return false;
            }
            if (!Arrays.equals(this.d, that.d)) {
                return false;
            }
            if (!this.e.equals(that.e)) {
                return false;
            }
            return this.f.equals(that.f);
        }

        public int hashCode() {
            int result = this.a ? 1 : 0;
            result = 31 * result + this.b;
            result = 31 * result + Arrays.hashCode(this.c);
            result = 31 * result + Arrays.hashCode(this.d);
            result = 31 * result + this.e.hashCode();
            result = 31 * result + this.f.hashCode();
            return result;
        }
    }

    private static class PrivateClassTest {
        private PrivateClassTest() {
        }
    }

    public static class JavaSerializable
    implements Serializable {
        String value;

        JavaSerializable(String value) {
            this.value = value;
        }

        public boolean equals(Object other) {
            return this.value.equals(((JavaSerializable)other).value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static class KryoSerializable {
        String value;

        KryoSerializable(String value) {
            this.value = value;
        }

        public boolean equals(Object other) {
            return this.value.equals(((KryoSerializable)other).value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    static class IntSumOf
    extends Aggregator<Tuple2<String, Integer>, Integer, Integer> {
        IntSumOf() {
        }

        public Integer zero() {
            return 0;
        }

        public Integer reduce(Integer l, Tuple2<String, Integer> t) {
            return l + (Integer)t._2();
        }

        public Integer merge(Integer b1, Integer b2) {
            return b1 + b2;
        }

        public Integer finish(Integer reduction) {
            return reduction;
        }
    }
}

