/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.test;

import java.io.File;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.DataFrame$;
import org.apache.spark.sql.SQLConf;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.test.SQLTestUtils;
import org.apache.spark.sql.test.SQLTestUtils$;
import org.apache.spark.util.Utils$;
import org.scalatest.Assertions;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;
import scala.runtime.Tuple2Zipped;
import scala.runtime.Tuple2Zipped$;
import scala.util.Try$;

public abstract class SQLTestUtils$class {
    public static SparkContext sparkContext(SQLTestUtils $this) {
        return $this.sqlContext().sparkContext();
    }

    public static Function1 sql(SQLTestUtils $this) {
        SQLContext sQLContext = $this.sqlContext();
        return new Serializable($this, sQLContext){
            public static final long serialVersionUID = 0L;
            private final SQLContext eta$0$1$1;

            public final DataFrame apply(String sqlText) {
                return this.eta$0$1$1.sql(sqlText);
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        };
    }

    public static void setupTestData(SQLTestUtils $this) {
        $this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests_$eq(true);
    }

    public static void beforeAll(SQLTestUtils $this) {
        $this.org$apache$spark$sql$test$SQLTestUtils$$super$beforeAll();
        if ($this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests()) {
            $this.loadTestData();
        }
    }

    public static Configuration hadoopConfiguration(SQLTestUtils $this) {
        return $this.sparkContext().hadoopConfiguration();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void withSQLConf(SQLTestUtils $this, Seq pairs, Function0 f) {
        Tuple2 tuple22;
        Tuple2 tuple2 = pairs.unzip((Function1)Predef$.MODULE$.conforms());
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Seq keys2 = (Seq)tuple2._1();
        Seq values = (Seq)tuple2._2();
        Tuple2 tuple23 = tuple22 = new Tuple2((Object)keys2, (Object)values);
        Seq keys = (Seq)tuple23._1();
        Seq values2 = (Seq)tuple23._2();
        Seq currentValues = (Seq)keys.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SQLTestUtils $outer;

            public final Option<String> apply(String key) {
                return Try$.MODULE$.apply((Function0)new Serializable(this, key){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ SQLTestUtils$.anonfun.1 $outer;
                    private final String key$1;

                    public final String apply() {
                        return this.$outer.org$apache$spark$sql$test$SQLTestUtils$$anonfun$$$outer().sqlContext().conf().getConfString(this.key$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.key$1 = key$1;
                    }
                }).toOption();
            }

            public /* synthetic */ SQLTestUtils org$apache$spark$sql$test$SQLTestUtils$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        SQLConf sQLConf = $this.sqlContext().conf();
        Tuple2Zipped$.MODULE$.foreach$extension(Tuple2Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple2ToZippedOps(new Tuple2((Object)keys, (Object)values2)), (Function1)Predef$.MODULE$.conforms(), (Function1)Predef$.MODULE$.conforms()), (Function2)new Serializable($this, sQLConf){
            public static final long serialVersionUID = 0L;
            private final SQLConf eta$0$2$1;

            public final void apply(String key, String value) {
                this.eta$0$2$1.setConfString(key, value);
            }
            {
                this.eta$0$2$1 = eta$0$2$1;
            }
        });
        try {
            f.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            ((IterableLike)keys.zip((GenIterable)currentValues, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SQLTestUtils $outer;

                public final void apply(Tuple2<String, Option<String>> x0$1) {
                    Tuple2<String, Option<String>> tuple2;
                    block4: {
                        block3: {
                            block2: {
                                tuple2 = x0$1;
                                if (tuple2 == null) break block2;
                                String key = (String)tuple2._1();
                                Option option = (Option)tuple2._2();
                                if (!(option instanceof Some)) break block2;
                                Some some = (Some)option;
                                String value = (String)some.x();
                                this.$outer.sqlContext().conf().setConfString(key, value);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block3;
                            }
                            if (tuple2 == null) break block4;
                            String key = (String)tuple2._1();
                            Option option = (Option)tuple2._2();
                            None$ none$ = None$.MODULE$;
                            Option option2 = option;
                            if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                            this.$outer.sqlContext().conf().unsetConf(key);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            throw throwable;
        }
        ((IterableLike)keys.zip((GenIterable)currentValues, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new /* invalid duplicate definition of identical inner class */);
    }

    public static void withTempPath(SQLTestUtils $this, Function1 f) {
        File path = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
        path.delete();
        try {
            f.apply((Object)path);
            return;
        }
        finally {
            Utils$.MODULE$.deleteRecursively(path);
        }
    }

    public static void withTempDir(SQLTestUtils $this, Function1 f) {
        File dir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).getCanonicalFile();
        try {
            f.apply((Object)dir);
            return;
        }
        finally {
            Utils$.MODULE$.deleteRecursively(dir);
        }
    }

    public static void withTempTable(SQLTestUtils $this, Seq tableNames, Function0 f) {
        try {
            f.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            SQLContext sQLContext = $this.sqlContext();
            tableNames.foreach((Function1)new Serializable($this, sQLContext){
                public static final long serialVersionUID = 0L;
                private final SQLContext eta$0$3$1;

                public final void apply(String tableName) {
                    this.eta$0$3$1.dropTempTable(tableName);
                }
                {
                    this.eta$0$3$1 = eta$0$3$1;
                }
            });
            throw throwable;
        }
        SQLContext sQLContext = $this.sqlContext();
        tableNames.foreach((Function1)new /* invalid duplicate definition of identical inner class */);
    }

    public static void withTable(SQLTestUtils $this, Seq tableNames, Function0 f) {
        try {
            f.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            tableNames.foreach((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SQLTestUtils $outer;

                public final DataFrame apply(String name) {
                    return this.$outer.sqlContext().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DROP TABLE IF EXISTS ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            throw throwable;
        }
        tableNames.foreach((Function1)new /* invalid duplicate definition of identical inner class */);
    }

    public static void withTempDatabase(SQLTestUtils $this, Function1 f) {
        String dbName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"db_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UUID.randomUUID().toString().replace('-', '_')}));
        try {
            $this.sqlContext().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE DATABASE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dbName})));
        }
        catch (Throwable throwable) {
            throw ((Assertions)$this).fail("Failed to create temporary database", throwable);
        }
        try {
            f.apply((Object)dbName);
        }
        catch (Throwable throwable) {
            $this.sqlContext().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DROP DATABASE ", " CASCADE"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dbName})));
            throw throwable;
        }
        $this.sqlContext().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DROP DATABASE ", " CASCADE"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dbName})));
    }

    public static void activateDatabase(SQLTestUtils $this, String db, Function0 f) {
        $this.sqlContext().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"USE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{db})));
        try {
            f.apply$mcV$sp();
        }
        catch (Throwable throwable) {
            $this.sqlContext().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"USE default"})).s((Seq)Nil$.MODULE$));
            throw throwable;
        }
        $this.sqlContext().sql(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"USE default"})).s((Seq)Nil$.MODULE$));
    }

    public static DataFrame logicalPlanToSparkQuery(SQLTestUtils $this, LogicalPlan plan) {
        return DataFrame$.MODULE$.apply($this.sqlContext(), plan);
    }

    public static void $init$(SQLTestUtils $this) {
        $this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests_$eq(false);
    }
}

